% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpairs_getput.R
\name{getPlot}
\alias{getPlot}
\alias{[.ggmatrix}
\title{Subset a \code{\link{ggmatrix}} object}
\usage{
getPlot(pm, i, j)

\method{[}{ggmatrix}(pm, i, j, ...)
}
\arguments{
\item{pm}{\code{\link{ggmatrix}} object to select from}

\item{i}{row from the top}

\item{j}{column from the left}

\item{...}{ignored}
}
\description{
Retrieves the ggplot object at the desired location.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips, package = "reshape")
plotMatrix2 <- ggpairs(tips[, 3:2], upper = list(combo = "denstrip"))
p_(plotMatrix2[1, 2])
}
\seealso{
\code{\link{putPlot}}
}
\author{
Barret Schloerke
}
\keyword{hplot}
