# -*- coding: utf-8 -*-
# Copyright (c) 2003, Taro Ogawa.  All Rights Reserved.
# Copyright (c) 2013, Savoir-faire Linux inc.  All Rights Reserved.

# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301 USA

from __future__ import unicode_literals

from unittest import TestCase

from num2words import num2words

TEST_CASES_CARDINAL = (
    (1, "один"),
    (2, "два"),
    (3, "три"),
    (4, "чотири"),
    (5, "п'ять"),
    (6, "шість"),
    (7, "сім"),
    (8, "вісім"),
    (9, "дев'ять"),
    (10, "десять"),
    (10.02, "десять кома нуль два"),
    (11, "одинадцять"),
    (12, "дванадцять"),
    (12.40, "дванадцять кома чотири"),
    (13, "тринадцять"),
    (14, "чотирнадцять"),
    (14.13, "чотирнадцять кома тринадцять"),
    (15, "п'ятнадцять"),
    (16, "шістнадцять"),
    (17, "сімнадцять"),
    (17.31, "сімнадцять кома тридцять один"),
    (18, "вісімнадцять"),
    (19, "дев'ятнадцять"),
    (20, "двадцять"),
    (21, "двадцять один"),
    (21.20, "двадцять один кома два"),
    (30, "тридцять"),
    (32, "тридцять два"),
    (40, "сорок"),
    (43, "сорок три"),
    (43.007, "сорок три кома нуль нуль сім"),
    (50, "п'ятдесят"),
    (54, "п'ятдесят чотири"),
    (60, "шістдесят"),
    (60.059, "шістдесят кома нуль п'ятдесят дев'ять"),
    (65, "шістдесят п'ять"),
    (70, "сімдесят"),
    (76, "сімдесят шість"),
    (80, "вісімдесят"),
    (87, "вісімдесят сім"),
    (90, "дев'яносто"),
    (98, "дев'яносто вісім"),
    (99, "дев'яносто дев'ять"),
    (100, "сто"),
    (101, "сто один"),
    (199, "сто дев'яносто дев'ять"),
    (200, "двісті"),
    (203, "двісті три"),
    (300, "триста"),
    (356, "триста п'ятдесят шість"),
    (400, "чотириста"),
    (434, "чотириста тридцять чотири"),
    (500, "п'ятсот"),
    (578, "п'ятсот сімдесят вісім"),
    (600, "шістсот"),
    (689, "шістсот вісімдесят дев'ять"),
    (700, "сімсот"),
    (729, "сімсот двадцять дев'ять"),
    (800, "вісімсот"),
    (894, "вісімсот дев'яносто чотири"),
    (900, "дев'ятсот"),
    (999, "дев'ятсот дев'яносто дев'ять"),
    (1000, "одна тисяча"),
    (1001, "одна тисяча один"),
    (2012, "дві тисячі дванадцять"),
    (12519, "дванадцять тисяч п'ятсот дев'ятнадцять"),
    (12519.85, "дванадцять тисяч п'ятсот дев'ятнадцять кома вісімдесят п'ять"),
    (-260000, "мінус двісті шістдесят тисяч"),
    (1000000, "один мільйон"),
    (1000000000, "один мільярд"),
    (1234567890, "один мільярд двісті тридцять чотири мільйони "
                 "п'ятсот шістдесят сім тисяч вісімсот дев'яносто"),
    (1000000000000, "один трильйон"),
    (1000000000000000, "один квадрильйон"),
    (1000000000000000000, "один квінтильйон"),
    (1000000000000000000000, "один секстильйон"),
    (1000000000000000000000000, "один септильйон"),
    (1000000000000000000000000000, "один октильйон"),
    (1000000000000000000000000000000, "один нонільйон"),
    (215461407892039002157189883901676,
     "двісті п'ятнадцять нонільйонів чотириста шістдесят один "
     "октильйон чотириста сім септильйонів вісімсот дев'яносто "
     "два секстильйони тридцять дев'ять квінтильйонів два "
     "квадрильйони сто п'ятдесят сім трильйонів сто вісімдесят "
     "дев'ять мільярдів вісімсот вісімдесят три мільйони "
     "дев'ятсот одна тисяча шістсот сімдесят шість"),
    (719094234693663034822824384220291,
     "сімсот дев'ятнадцять нонільйонів дев'яносто чотири октильйони "
     "двісті тридцять чотири септильйони шістсот дев'яносто три "
     "секстильйони шістсот шістдесят три квінтильйони тридцять "
     "чотири квадрильйони вісімсот двадцять два трильйони вісімсот "
     "двадцять чотири мільярди триста вісімдесят чотири мільйони "
     "двісті двадцять тисяч двісті дев'яносто один")
)

TEST_CASES_CARDINAL_FEMININE = (
    (1, "одна"),
    (2, "дві"),
    (3, "три"),
    (4, "чотири"),
    (5, "п'ять"),
    (6, "шість"),
    (7, "сім"),
    (8, "вісім"),
    (9, "дев'ять"),
    (10, "десять"),
    (10.02, "десять кома нуль дві"),
    (11, "одинадцять"),
    (12, "дванадцять"),
    (12.40, "дванадцять кома чотири"),
    (13, "тринадцять"),
    (14, "чотирнадцять"),
    (14.13, "чотирнадцять кома тринадцять"),
    (15, "п'ятнадцять"),
    (16, "шістнадцять"),
    (17, "сімнадцять"),
    (17.31, "сімнадцять кома тридцять одна"),
    (18, "вісімнадцять"),
    (19, "дев'ятнадцять"),
    (20, "двадцять"),
    (21, "двадцять одна"),
    (21.20, "двадцять одна кома дві"),
    (30, "тридцять"),
    (32, "тридцять дві"),
    (40, "сорок"),
    (43, "сорок три"),
    (43.007, "сорок три кома нуль нуль сім"),
    (50, "п'ятдесят"),
    (54, "п'ятдесят чотири"),
    (60, "шістдесят"),
    (60.059, "шістдесят кома нуль п'ятдесят дев'ять"),
    (65, "шістдесят п'ять"),
    (70, "сімдесят"),
    (76, "сімдесят шість"),
    (80, "вісімдесят"),
    (87, "вісімдесят сім"),
    (90, "дев'яносто"),
    (98, "дев'яносто вісім"),
    (99, "дев'яносто дев'ять"),
    (100, "сто"),
    (101, "сто одна"),
    (199, "сто дев'яносто дев'ять"),
    (200, "двісті"),
    (203, "двісті три"),
    (300, "триста"),
    (356, "триста п'ятдесят шість"),
    (400, "чотириста"),
    (434, "чотириста тридцять чотири"),
    (500, "п'ятсот"),
    (578, "п'ятсот сімдесят вісім"),
    (600, "шістсот"),
    (689, "шістсот вісімдесят дев'ять"),
    (700, "сімсот"),
    (729, "сімсот двадцять дев'ять"),
    (800, "вісімсот"),
    (894, "вісімсот дев'яносто чотири"),
    (900, "дев'ятсот"),
    (999, "дев'ятсот дев'яносто дев'ять"),
    (1000, "одна тисяча"),
    (1001, "одна тисяча одна"),
    (2012, "дві тисячі дванадцять"),
    (12519, "дванадцять тисяч п'ятсот дев'ятнадцять"),
    (12519.85, "дванадцять тисяч п'ятсот дев'ятнадцять кома вісімдесят п'ять"),
    (-260000, "мінус двісті шістдесят тисяч"),
    (1000000, "один мільйон"),
    (1000000000, "один мільярд"),
    (1234567890, "один мільярд двісті тридцять чотири мільйони "
                 "п'ятсот шістдесят сім тисяч вісімсот дев'яносто"),
    (1000000000000, "один трильйон"),
    (1000000000000000, "один квадрильйон"),
    (1000000000000000000, "один квінтильйон"),
    (1000000000000000000000, "один секстильйон"),
    (1000000000000000000000000, "один септильйон"),
    (1000000000000000000000000000, "один октильйон"),
    (1000000000000000000000000000000, "один нонільйон"),
    (215461407892039002157189883901676,
     "двісті п'ятнадцять нонільйонів чотириста шістдесят один "
     "октильйон чотириста сім септильйонів вісімсот дев'яносто "
     "два секстильйони тридцять дев'ять квінтильйонів два "
     "квадрильйони сто п'ятдесят сім трильйонів сто вісімдесят "
     "дев'ять мільярдів вісімсот вісімдесят три мільйони "
     "дев'ятсот одна тисяча шістсот сімдесят шість"),
    (719094234693663034822824384220291,
     "сімсот дев'ятнадцять нонільйонів дев'яносто чотири октильйони "
     "двісті тридцять чотири септильйони шістсот дев'яносто три "
     "секстильйони шістсот шістдесят три квінтильйони тридцять "
     "чотири квадрильйони вісімсот двадцять два трильйони вісімсот "
     "двадцять чотири мільярди триста вісімдесят чотири мільйони "
     "двісті двадцять тисяч двісті дев'яносто одна")
)

TEST_CASES_CARDINAL_GENITIVE = (
    (1, "одного"),
    (2, "двох"),
    (3, "трьох"),
    (4, "чотирьох"),
    (5, "п'яти"),
    (6, "шести"),
    (7, "семи"),
    (8, "восьми"),
    (9, "дев'яти"),
    (10, "десяти"),
    (10.02, "десяти кома нуль двох"),
    (11, "одинадцяти"),
    (12, "дванадцяти"),
    (12.40, "дванадцяти кома чотирьох"),
    (13, "тринадцяти"),
    (14, "чотирнадцяти"),
    (14.13, "чотирнадцяти кома тринадцяти"),
    (15, "п'ятнадцяти"),
    (16, "шістнадцяти"),
    (17, "сімнадцяти"),
    (17.31, "сімнадцяти кома тридцяти одного"),
    (18, "вісімнадцяти"),
    (19, "дев'ятнадцяти"),
    (20, "двадцяти"),
    (21, "двадцяти одного"),
    (21.20, "двадцяти одного кома двох"),
    (30, "тридцяти"),
    (32, "тридцяти двох"),
    (40, "сорока"),
    (43, "сорока трьох"),
    (43.007, "сорока трьох кома нуль нуль семи"),
    (50, "п'ятдесяти"),
    (54, "п'ятдесяти чотирьох"),
    (60, "шістдесяти"),
    (60.059, "шістдесяти кома нуль п'ятдесяти дев'яти"),
    (65, "шістдесяти п'яти"),
    (70, "сімдесяти"),
    (76, "сімдесяти шести"),
    (80, "вісімдесяти"),
    (87, "вісімдесяти семи"),
    (90, "дев'яноста"),
    (98, "дев'яноста восьми"),
    (99, "дев'яноста дев'яти"),
    (100, "ста"),
    (101, "ста одного"),
    (199, "ста дев'яноста дев'яти"),
    (200, "двохста"),
    (203, "двохста трьох"),
    (300, "трьохста"),
    (356, "трьохста п'ятдесяти шести"),
    (400, "чотирьохста"),
    (434, "чотирьохста тридцяти чотирьох"),
    (500, "п'ятиста"),
    (578, "п'ятиста сімдесяти восьми"),
    (600, "шестиста"),
    (689, "шестиста вісімдесяти дев'яти"),
    (700, "семиста"),
    (729, "семиста двадцяти дев'яти"),
    (800, "восьмиста"),
    (894, "восьмиста дев'яноста чотирьох"),
    (900, "дев'ятиста"),
    (999, "дев'ятиста дев'яноста дев'яти"),
    (1000, "однієї тисячи"),
    (1001, "однієї тисячи одного"),
    (2012, "двох тисяч дванадцяти"),
    (12519, "дванадцяти тисяч п'ятиста дев'ятнадцяти"),
    (12519.85, "дванадцяти тисяч п'ятиста дев'ятнадцяти "
        "кома вісімдесяти п'яти"),
    (-260000, "мінус двохста шістдесяти тисяч"),
    (1000000, "одного мільйона"),
    (1000000000, "одного мільярда"),
    (1234567890, "одного мільярда двохста тридцяти чотирьох мільйонів "
                 "п'ятиста шістдесяти семи тисяч восьмиста дев'яноста"),
    (1000000000000, "одного трильйона"),
    (1000000000000000, "одного квадрильйона"),
    (1000000000000000000, "одного квінтильйона"),
    (1000000000000000000000, "одного секстильйона"),
    (1000000000000000000000000, "одного септильйона"),
    (1000000000000000000000000000, "одного октильйона"),
    (1000000000000000000000000000000, "одного нонільйона"),
    (215461407892039002157189883901676,
     "двохста п'ятнадцяти нонільйонів чотирьохста шістдесяти одного "
     "октильйона чотирьохста семи септильйонів восьмиста дев'яноста "
     "двох секстильйонів тридцяти дев'яти квінтильйонів двох "
     "квадрильйонів ста п'ятдесяти семи трильйонів ста вісімдесяти "
     "дев'яти мільярдів восьмиста вісімдесяти трьох мільйонів "
     "дев'ятиста однієї тисячи шестиста сімдесяти шести"),
    (719094234693663034822824384220291,
     "семиста дев'ятнадцяти нонільйонів дев'яноста чотирьох октильйонів "
     "двохста тридцяти чотирьох септильйонів шестиста дев'яноста трьох "
     "секстильйонів шестиста шістдесяти трьох квінтильйонів тридцяти "
     "чотирьох квадрильйонів восьмиста двадцяти двох трильйонів восьмиста "
     "двадцяти чотирьох мільярдів трьохста вісімдесяти чотирьох мільйонів "
     "двохста двадцяти тисяч двохста дев'яноста одного")
)

TEST_CASES_CARDINAL_DATIVE = (
    (1, "одному"),
    (2, "двом"),
    (3, "трьом"),
    (4, "чотирьом"),
    (5, "п'яти"),
    (6, "шести"),
    (7, "семи"),
    (8, "восьми"),
    (9, "дев'яти"),
    (10, "десяти"),
    (10.02, "десяти кома нуль двом"),
    (11, "одинадцяти"),
    (12, "дванадцяти"),
    (12.40, "дванадцяти кома чотирьом"),
    (13, "тринадцяти"),
    (14, "чотирнадцяти"),
    (14.13, "чотирнадцяти кома тринадцяти"),
    (15, "п'ятнадцяти"),
    (16, "шістнадцяти"),
    (17, "сімнадцяти"),
    (17.31, "сімнадцяти кома тридцяти одному"),
    (18, "вісімнадцяти"),
    (19, "дев'ятнадцяти"),
    (20, "двадцяти"),
    (21, "двадцяти одному"),
    (21.20, "двадцяти одному кома двом"),
    (30, "тридцяти"),
    (32, "тридцяти двом"),
    (40, "сорока"),
    (43, "сорока трьом"),
    (43.007, "сорока трьом кома нуль нуль семи"),
    (50, "п'ятдесяти"),
    (54, "п'ятдесяти чотирьом"),
    (60, "шістдесяти"),
    (60.059, "шістдесяти кома нуль п'ятдесяти дев'яти"),
    (65, "шістдесяти п'яти"),
    (70, "сімдесяти"),
    (76, "сімдесяти шести"),
    (80, "вісімдесяти"),
    (87, "вісімдесяти семи"),
    (90, "дев'яноста"),
    (98, "дев'яноста восьми"),
    (99, "дев'яноста дев'яти"),
    (100, "ста"),
    (101, "ста одному"),
    (199, "ста дев'яноста дев'яти"),
    (200, "двомстам"),
    (203, "двомстам трьом"),
    (300, "трьомстам"),
    (356, "трьомстам п'ятдесяти шести"),
    (400, "чотирьомстам"),
    (434, "чотирьомстам тридцяти чотирьом"),
    (500, "п'ятистам"),
    (578, "п'ятистам сімдесяти восьми"),
    (600, "шестистам"),
    (689, "шестистам вісімдесяти дев'яти"),
    (700, "семистам"),
    (729, "семистам двадцяти дев'яти"),
    (800, "восьмистам"),
    (894, "восьмистам дев'яноста чотирьом"),
    (900, "дев'ятистам"),
    (999, "дев'ятистам дев'яноста дев'яти"),
    (1000, "одній тисячі"),
    (1001, "одній тисячі одному"),
    (2012, "двом тисячам дванадцяти"),
    (12519, "дванадцяти тисячам п'ятистам дев'ятнадцяти"),
    (12519.85, "дванадцяти тисячам п'ятистам дев'ятнадцяти "
               "кома вісімдесяти п'яти"),
    (-260000, "мінус двомстам шістдесяти тисячам"),
    (1000000, "одному мільйону"),
    (1000000000, "одному мільярду"),
    (1234567890, "одному мільярду двомстам тридцяти чотирьом мільйонам "
                 "п'ятистам шістдесяти семи тисячам восьмистам дев'яноста"),
    (1000000000000, "одному трильйону"),
    (1000000000000000, "одному квадрильйону"),
    (1000000000000000000, "одному квінтильйону"),
    (1000000000000000000000, "одному секстильйону"),
    (1000000000000000000000000, "одному септильйону"),
    (1000000000000000000000000000, "одному октильйону"),
    (1000000000000000000000000000000, "одному нонільйону"),
    (215461407892039002157189883901676,
     "двомстам п'ятнадцяти нонільйонам чотирьомстам шістдесяти одному "
     "октильйону чотирьомстам семи септильйонам восьмистам дев'яноста "
     "двом секстильйонам тридцяти дев'яти квінтильйонам двом "
     "квадрильйонам ста п'ятдесяти семи трильйонам ста вісімдесяти "
     "дев'яти мільярдам восьмистам вісімдесяти трьом мільйонам "
     "дев'ятистам одній тисячі шестистам сімдесяти шести"),
    (719094234693663034822824384220291,
     "семистам дев'ятнадцяти нонільйонам дев'яноста чотирьом октильйонам "
     "двомстам тридцяти чотирьом септильйонам шестистам дев'яноста трьом "
     "секстильйонам шестистам шістдесяти трьом квінтильйонам тридцяти "
     "чотирьом квадрильйонам восьмистам двадцяти двом трильйонам восьмистам "
     "двадцяти чотирьом мільярдам трьомстам вісімдесяти чотирьом мільйонам "
     "двомстам двадцяти тисячам двомстам дев'яноста одному")
)

TEST_CASES_CARDINAL_ACCUSATIVE = (
    (1, "один"),
    (2, "два"),
    (3, "три"),
    (4, "чотири"),
    (5, "п'ять"),
    (6, "шість"),
    (7, "сім"),
    (8, "вісім"),
    (9, "дев'ять"),
    (10, "десять"),
    (10.02, "десять кома нуль два"),
    (11, "одинадцять"),
    (12, "дванадцять"),
    (12.40, "дванадцять кома чотири"),
    (13, "тринадцять"),
    (14, "чотирнадцять"),
    (14.13, "чотирнадцять кома тринадцять"),
    (15, "п'ятнадцять"),
    (16, "шістнадцять"),
    (17, "сімнадцять"),
    (17.31, "сімнадцять кома тридцять один"),
    (18, "вісімнадцять"),
    (19, "дев'ятнадцять"),
    (20, "двадцять"),
    (21, "двадцять один"),
    (21.20, "двадцять один кома два"),
    (30, "тридцять"),
    (32, "тридцять два"),
    (40, "сорок"),
    (43, "сорок три"),
    (43.007, "сорок три кома нуль нуль сім"),
    (50, "п'ятдесят"),
    (54, "п'ятдесят чотири"),
    (60, "шістдесят"),
    (60.059, "шістдесят кома нуль п'ятдесят дев'ять"),
    (65, "шістдесят п'ять"),
    (70, "сімдесят"),
    (76, "сімдесят шість"),
    (80, "вісімдесят"),
    (87, "вісімдесят сім"),
    (90, "дев'яносто"),
    (98, "дев'яносто вісім"),
    (99, "дев'яносто дев'ять"),
    (100, "сто"),
    (101, "сто один"),
    (199, "сто дев'яносто дев'ять"),
    (200, "двісті"),
    (203, "двісті три"),
    (300, "триста"),
    (356, "триста п'ятдесят шість"),
    (400, "чотириста"),
    (434, "чотириста тридцять чотири"),
    (500, "п'ятсот"),
    (578, "п'ятсот сімдесят вісім"),
    (600, "шістсот"),
    (689, "шістсот вісімдесят дев'ять"),
    (700, "сімсот"),
    (729, "сімсот двадцять дев'ять"),
    (800, "вісімсот"),
    (894, "вісімсот дев'яносто чотири"),
    (900, "дев'ятсот"),
    (999, "дев'ятсот дев'яносто дев'ять"),
    (1000, "одну тисячу"),
    (1001, "одну тисячу один"),
    (2012, "дві тисячі дванадцять"),
    (12519, "дванадцять тисяч п'ятсот дев'ятнадцять"),
    (12519.85, "дванадцять тисяч п'ятсот дев'ятнадцять кома вісімдесят п'ять"),
    (-260000, "мінус двісті шістдесят тисяч"),
    (1000000, "один мільйон"),
    (1000000000, "один мільярд"),
    (1234567890, "один мільярд двісті тридцять чотири мільйони "
                 "п'ятсот шістдесят сім тисяч вісімсот дев'яносто"),
    (1000000000000, "один трильйон"),
    (1000000000000000, "один квадрильйон"),
    (1000000000000000000, "один квінтильйон"),
    (1000000000000000000000, "один секстильйон"),
    (1000000000000000000000000, "один септильйон"),
    (1000000000000000000000000000, "один октильйон"),
    (1000000000000000000000000000000, "один нонільйон"),
    (215461407892039002157189883901676,
     "двісті п'ятнадцять нонільйонів чотириста шістдесят один "
     "октильйон чотириста сім септильйонів вісімсот дев'яносто "
     "два секстильйони тридцять дев'ять квінтильйонів два "
     "квадрильйони сто п'ятдесят сім трильйонів сто вісімдесят "
     "дев'ять мільярдів вісімсот вісімдесят три мільйони "
     "дев'ятсот одну тисячу шістсот сімдесят шість"),
    (719094234693663034822824384220291,
     "сімсот дев'ятнадцять нонільйонів дев'яносто чотири октильйони "
     "двісті тридцять чотири септильйони шістсот дев'яносто три "
     "секстильйони шістсот шістдесят три квінтильйони тридцять "
     "чотири квадрильйони вісімсот двадцять два трильйони вісімсот "
     "двадцять чотири мільярди триста вісімдесят чотири мільйони "
     "двісті двадцять тисяч двісті дев'яносто один")
)

TEST_CASES_CARDINAL_INSTRUMENTAL = (
    (1, "одним"),
    (2, "двома"),
    (3, "трьома"),
    (4, "чотирма"),
    (5, "п'ятьма"),
    (6, "шістьма"),
    (7, "сьома"),
    (8, "вісьма"),
    (9, "дев'ятьма"),
    (10, "десятьма"),
    (10.02, "десятьма кома нуль двома"),
    (11, "одинадцятьма"),
    (12, "дванадцятьма"),
    (12.40, "дванадцятьма кома чотирма"),
    (13, "тринадцятьма"),
    (14, "чотирнадцятьма"),
    (14.13, "чотирнадцятьма кома тринадцятьма"),
    (15, "п'ятнадцятьма"),
    (16, "шістнадцятьма"),
    (17, "сімнадцятьма"),
    (17.31, "сімнадцятьма кома тридцятьма одним"),
    (18, "вісімнадцятьма"),
    (19, "дев'ятнадцятьма"),
    (20, "двадцятьма"),
    (21, "двадцятьма одним"),
    (21.20, "двадцятьма одним кома двома"),
    (30, "тридцятьма"),
    (32, "тридцятьма двома"),
    (40, "сорока"),
    (43, "сорока трьома"),
    (43.007, "сорока трьома кома нуль нуль сьома"),
    (50, "п'ятдесятьма"),
    (54, "п'ятдесятьма чотирма"),
    (60, "шістдесятьма"),
    (60.059, "шістдесятьма кома нуль п'ятдесятьма дев'ятьма"),
    (65, "шістдесятьма п'ятьма"),
    (70, "сімдесятьма"),
    (76, "сімдесятьма шістьма"),
    (80, "вісімдесятьма"),
    (87, "вісімдесятьма сьома"),
    (90, "дев'яностами"),
    (98, "дев'яностами вісьма"),
    (99, "дев'яностами дев'ятьма"),
    (100, "стами"),
    (101, "стами одним"),
    (199, "стами дев'яностами дев'ятьма"),
    (200, "двомастами"),
    (203, "двомастами трьома"),
    (300, "трьомастами"),
    (356, "трьомастами п'ятдесятьма шістьма"),
    (400, "чотирмастами"),
    (434, "чотирмастами тридцятьма чотирма"),
    (500, "п'ятьмастами"),
    (578, "п'ятьмастами сімдесятьма вісьма"),
    (600, "шістьмастами"),
    (689, "шістьмастами вісімдесятьма дев'ятьма"),
    (700, "сьомастами"),
    (729, "сьомастами двадцятьма дев'ятьма"),
    (800, "восьмастами"),
    (894, "восьмастами дев'яностами чотирма"),
    (900, "дев'ятьмастами"),
    (999, "дев'ятьмастами дев'яностами дев'ятьма"),
    (1000, "однією тисячею"),
    (1001, "однією тисячею одним"),
    (2012, "двома тисячами дванадцятьма"),
    (12519, "дванадцятьма тисячами п'ятьмастами дев'ятнадцятьма"),
    (12519.85, "дванадцятьма тисячами п'ятьмастами дев'ятнадцятьма "
        "кома вісімдесятьма п'ятьма"),
    (-260000, "мінус двомастами шістдесятьма тисячами"),
    (1000000, "одним мільйоном"),
    (1000000000, "одним мільярдом"),
    (1234567890, "одним мільярдом двомастами тридцятьма чотирма мільйонами "
                 "п'ятьмастами шістдесятьма сьома тисячами восьмастами "
                 "дев'яностами"),
    (1000000000000, "одним трильйоном"),
    (1000000000000000, "одним квадрильйоном"),
    (1000000000000000000, "одним квінтильйоном"),
    (1000000000000000000000, "одним секстильйоном"),
    (1000000000000000000000000, "одним септильйоном"),
    (1000000000000000000000000000, "одним октильйоном"),
    (1000000000000000000000000000000, "одним нонільйоном"),
    (215461407892039002157189883901676,
     "двомастами п'ятнадцятьма нонільйонів чотирмастами шістдесятьма одним "
     "октильйоном чотирмастами сьома септильйонів восьмастами дев'яностами "
     "двома секстильйонами тридцятьма дев'ятьма квінтильйонів двома "
     "квадрильйонами стами п'ятдесятьма сьома трильйонів стами вісімдесятьма "
     "дев'ятьма мільярдів восьмастами вісімдесятьма трьома мільйонами "
     "дев'ятьмастами однією тисячею шістьмастами сімдесятьма шістьма"),
    (719094234693663034822824384220291,
     "сьомастами дев'ятнадцятьма нонільйонів дев'яностами чотирма "
     "октильйонами двомастами тридцятьма чотирма септильйонами шістьмастами "
     "дев'яностами трьома секстильйонами шістьмастами шістдесятьма трьома "
     "квінтильйонами тридцятьма чотирма квадрильйонами восьмастами двадцятьма "
     "двома трильйонами восьмастами двадцятьма чотирма мільярдами трьомастами "
     "вісімдесятьма чотирма мільйонами двомастами двадцятьма тисячами "
     "двомастами дев'яностами одним")
)

TEST_CASES_CARDINAL_LOCATIVE = (
    (1, "одному"),
    (2, "двох"),
    (3, "трьох"),
    (4, "чотирьох"),
    (5, "п'яти"),
    (6, "шести"),
    (7, "семи"),
    (8, "восьми"),
    (9, "дев'яти"),
    (10, "десяти"),
    (10.02, "десяти кома нуль двох"),
    (11, "одинадцяти"),
    (12, "дванадцяти"),
    (12.40, "дванадцяти кома чотирьох"),
    (13, "тринадцяти"),
    (14, "чотирнадцяти"),
    (14.13, "чотирнадцяти кома тринадцяти"),
    (15, "п'ятнадцяти"),
    (16, "шістнадцяти"),
    (17, "сімнадцяти"),
    (17.31, "сімнадцяти кома тридцяти одному"),
    (18, "вісімнадцяти"),
    (19, "дев'ятнадцяти"),
    (20, "двадцяти"),
    (21, "двадцяти одному"),
    (21.20, "двадцяти одному кома двох"),
    (30, "тридцяти"),
    (32, "тридцяти двох"),
    (40, "сорока"),
    (43, "сорока трьох"),
    (43.007, "сорока трьох кома нуль нуль семи"),
    (50, "п'ятдесяти"),
    (54, "п'ятдесяти чотирьох"),
    (60, "шістдесяти"),
    (60.059, "шістдесяти кома нуль п'ятдесяти дев'яти"),
    (65, "шістдесяти п'яти"),
    (70, "сімдесяти"),
    (76, "сімдесяти шести"),
    (80, "вісімдесяти"),
    (87, "вісімдесяти семи"),
    (90, "дев'яноста"),
    (98, "дев'яноста восьми"),
    (99, "дев'яноста дев'яти"),
    (100, "стах"),
    (101, "стах одному"),
    (199, "стах дев'яноста дев'яти"),
    (200, "двохстах"),
    (203, "двохстах трьох"),
    (300, "трьохстах"),
    (356, "трьохстах п'ятдесяти шести"),
    (400, "чотирьохстах"),
    (434, "чотирьохстах тридцяти чотирьох"),
    (500, "п'ятистах"),
    (578, "п'ятистах сімдесяти восьми"),
    (600, "шестистах"),
    (689, "шестистах вісімдесяти дев'яти"),
    (700, "семистах"),
    (729, "семистах двадцяти дев'яти"),
    (800, "восьмистах"),
    (894, "восьмистах дев'яноста чотирьох"),
    (900, "дев'ятистах"),
    (999, "дев'ятистах дев'яноста дев'яти"),
    (1000, "одній тисячі"),
    (1001, "одній тисячі одному"),
    (2012, "двох тисячах дванадцяти"),
    (12519, "дванадцяти тисячах п'ятистах дев'ятнадцяти"),
    (12519.85, "дванадцяти тисячах п'ятистах дев'ятнадцяти "
        "кома вісімдесяти п'яти"),
    (-260000, "мінус двохстах шістдесяти тисячах"),
    (1000000, "одному мільйоні"),
    (1000000000, "одному мільярді"),
    (1234567890, "одному мільярді двохстах тридцяти чотирьох мільйонах "
                 "п'ятистах шістдесяти семи тисячах восьмистах дев'яноста"),
    (1000000000000, "одному трильйоні"),
    (1000000000000000, "одному квадрильйоні"),
    (1000000000000000000, "одному квінтильйоні"),
    (1000000000000000000000, "одному секстильйоні"),
    (1000000000000000000000000, "одному септильйоні"),
    (1000000000000000000000000000, "одному октильйоні"),
    (1000000000000000000000000000000, "одному нонільйоні"),
    (215461407892039002157189883901676,
     "двохстах п'ятнадцяти нонільйонах чотирьохстах шістдесяти одному "
     "октильйоні чотирьохстах семи септильйонах восьмистах дев'яноста "
     "двох секстильйонах тридцяти дев'яти квінтильйонах двох "
     "квадрильйонах стах п'ятдесяти семи трильйонах стах вісімдесяти "
     "дев'яти мільярдах восьмистах вісімдесяти трьох мільйонах "
     "дев'ятистах одній тисячі шестистах сімдесяти шести"),
    (719094234693663034822824384220291,
     "семистах дев'ятнадцяти нонільйонах дев'яноста чотирьох октильйонах "
     "двохстах тридцяти чотирьох септильйонах шестистах дев'яноста трьох "
     "секстильйонах шестистах шістдесяти трьох квінтильйонах тридцяти "
     "чотирьох квадрильйонах восьмистах двадцяти двох трильйонах восьмистах "
     "двадцяти чотирьох мільярдах трьохстах вісімдесяти чотирьох мільйонах "
     "двохстах двадцяти тисячах двохстах дев'яноста одному")
)

TEST_CASES_ORDINAL = (
    (1, "перший"),
    (2, "другий"),
    (3, "третій"),
    (4, "четвертий"),
    (5, "п'ятий"),
    (6, "шостий"),
    (7, "сьомий"),
    (8, "восьмий"),
    (9, "дев'ятий"),
    (10, "десятий"),
    (11, "одинадцятий"),
    (12, "дванадцятий"),
    (13, "тринадцятий"),
    (14, "чотирнадцятий"),
    (15, "п'ятнадцятий"),
    (16, "шістнадцятий"),
    (17, "сімнадцятий"),
    (18, "вісімнадцятий"),
    (19, "дев'ятнадцятий"),
    (20, "двадцятий"),
    (21, "двадцять перший"),
    (30, "тридцятий"),
    (32, "тридцять другий"),
    (40, "сороковий"),
    (43, "сорок третій"),
    (50, "п'ятдесятий"),
    (54, "п'ятдесят четвертий"),
    (60, "шістдесятий"),
    (65, "шістдесят п'ятий"),
    (70, "сімдесятий"),
    (76, "сімдесят шостий"),
    (80, "вісімдесятий"),
    (87, "вісімдесят сьомий"),
    (90, "дев'яностий"),
    (98, "дев'яносто восьмий"),
    (100, "сотий"),
    (101, "сто перший"),
    (199, "сто дев'яносто дев'ятий"),
    (200, "двохсотий"),
    (203, "двісті третій"),
    (300, "трьохсотий"),
    (356, "триста п'ятдесят шостий"),
    (400, "чотирьохсотий"),
    (434, "чотириста тридцять четвертий"),
    (500, "п'ятисотий"),
    (578, "п'ятсот сімдесят восьмий"),
    (600, "шестисотий"),
    (690, "шістсот дев'яностий"),
    (700, "семисотий"),
    (729, "сімсот двадцять дев'ятий"),
    (800, "восьмисотий"),
    (894, "вісімсот дев'яносто четвертий"),
    (900, "дев'ятисотий"),
    (999, "дев'ятсот дев'яносто дев'ятий"),
    (1000, "тисячний"),
    (1001, "одна тисяча перший"),
    (2000, "двохтисячний"),
    (2312, "дві тисячі триста дванадцятий"),
    (12000, "дванадцятитисячний"),
    (25000, "двадцятип'ятитисячний"),
    (213000, "двохсоттринадцятитисячний"),
    (256000, "двохсотп'ятдесятишеститисячний"),
    (260000, "двохсотшістдесятитисячний"),
    (1000000, "мільйонний"),
    (589000000, "п'ятсотвісімдесятидев'ятимільйонний"),
    (1000000000, "мільярдний"),
    (1234567890, "один мільярд двісті тридцять чотири мільйони "
                 "п'ятсот шістдесят сім тисяч вісімсот дев'яностий"),
    (1000000000000, "трильйонний"),
    (1000000000000000, "квадрильйонний"),
    (1000000000000000000, "квінтильйонний"),
    (1000000000000000000000, "секстильйонний"),
    (1000000000000000000000000, "септильйонний"),
    (1000000000000000000000000000, "октильйонний"),
    (1000000000000000000000000000000, "нонільйонний"),
    (956000000000000000000000000000000,
     "дев'ятсотп'ятдесятишестинонільйонний"),
)

TEST_CASES_TO_CURRENCY_AED = (
    (0.00, "нуль дирхамів, нуль філсів"),
    (1.00, "один дирхам, нуль філсів"),
    (2.00, "два дирхами, нуль філсів"),
    (5.00, "п'ять дирхамів, нуль філсів"),
    (11.00, "одинадцять дирхамів, нуль філсів"),
    (16.01, "шістнадцять дирхамів, один філс"),
    (21.00, "двадцять один дирхам, нуль філсів"),
    (37.73, "тридцять сім дирхамів, сімдесят три філси"),
    (81.25, "вісімдесят один дирхам, двадцять п'ять філсів"),
    (100.00, "сто дирхамів, нуль філсів"),
    (101.11, "сто один дирхам, одинадцять філсів"),
    (10222, "сто два дирхами, двадцять два філси"),

)

TEST_CASES_TO_CURRENCY_AFN = (
    (0.00, "нуль афгані, нуль пулів"),
    (1.00, "один афгані, нуль пулів"),
    (2.00, "два афгані, нуль пулів"),
    (5.00, "п'ять афгані, нуль пулів"),
    (11.00, "одинадцять афгані, нуль пулів"),
    (16.01, "шістнадцять афгані, один пул"),
    (21.00, "двадцять один афгані, нуль пулів"),
    (37.73, "тридцять сім афгані, сімдесят три пули"),
    (81.25, "вісімдесят один афгані, двадцять п'ять пулів"),
    (100.00, "сто афгані, нуль пулів"),
    (101.11, "сто один афгані, одинадцять пулів"),
    (10222, "сто два афгані, двадцять два пули"),
)

TEST_CASES_TO_CURRENCY_ALL = (
    (0.00, "нуль леків, нуль кіндарок"),
    (1.00, "один лек, нуль кіндарок"),
    (2.00, "два леки, нуль кіндарок"),
    (5.00, "п'ять леків, нуль кіндарок"),
    (11.00, "одинадцять леків, нуль кіндарок"),
    (16.01, "шістнадцять леків, одна кіндарка"),
    (21.00, "двадцять один лек, нуль кіндарок"),
    (37.73, "тридцять сім леків, сімдесят три кіндарки"),
    (81.25, "вісімдесят один лек, двадцять п'ять кіндарок"),
    (100.00, "сто леків, нуль кіндарок"),
    (101.11, "сто один лек, одинадцять кіндарок"),
    (10222, "сто два леки, двадцять дві кіндарки"),
)

TEST_CASES_TO_CURRENCY_AMD = (
    (0.00, "нуль драмів, нуль лум"),
    (1.00, "один драм, нуль лум"),
    (2.00, "два драми, нуль лум"),
    (5.00, "п'ять драмів, нуль лум"),
    (11.00, "одинадцять драмів, нуль лум"),
    (16.01, "шістнадцять драмів, один лум"),
    (21.00, "двадцять один драм, нуль лум"),
    (37.73, "тридцять сім драмів, сімдесят три лум"),
    (81.25, "вісімдесят один драм, двадцять п'ять лум"),
    (100.00, "сто драмів, нуль лум"),
    (101.11, "сто один драм, одинадцять лум"),
    (10222, "сто два драми, двадцять два лум"),
)

TEST_CASES_TO_CURRENCY_ANG = (
    (0.00, "нуль гульденів, нуль центів"),
    (1.00, "один гульден, нуль центів"),
    (2.00, "два гульдени, нуль центів"),
    (5.00, "п'ять гульденів, нуль центів"),
    (11.00, "одинадцять гульденів, нуль центів"),
    (16.01, "шістнадцять гульденів, один цент"),
    (21.00, "двадцять один гульден, нуль центів"),
    (37.73, "тридцять сім гульденів, сімдесят три центи"),
    (81.25, "вісімдесят один гульден, двадцять п'ять центів"),
    (100.00, "сто гульденів, нуль центів"),
    (101.11, "сто один гульден, одинадцять центів"),
    (10222, "сто два гульдени, двадцять два центи"),
)
#
TEST_CASES_TO_CURRENCY_AOA = (
    (0.00, "нуль кванз, нуль сентимо"),
    (1.00, "одна кванза, нуль сентимо"),
    (2.00, "дві кванзи, нуль сентимо"),
    (5.00, "п'ять кванз, нуль сентимо"),
    (11.00, "одинадцять кванз, нуль сентимо"),
    (16.01, "шістнадцять кванз, один сентимо"),
    (21.00, "двадцять одна кванза, нуль сентимо"),
    (37.73, "тридцять сім кванз, сімдесят три сентимо"),
    (81.25, "вісімдесят одна кванза, двадцять п'ять сентимо"),
    (100.00, "сто кванз, нуль сентимо"),
    (101.11, "сто одна кванза, одинадцять сентимо"),
    (10222, "сто дві кванзи, двадцять два сентимо"),
)
#
TEST_CASES_TO_CURRENCY_ARS = (
    (0.00, "нуль песо, нуль сентаво"),
    (1.00, "один песо, нуль сентаво"),
    (2.00, "два песо, нуль сентаво"),
    (5.00, "п'ять песо, нуль сентаво"),
    (11.00, "одинадцять песо, нуль сентаво"),
    (16.01, "шістнадцять песо, один сентаво"),
    (21.00, "двадцять один песо, нуль сентаво"),
    (37.73, "тридцять сім песо, сімдесят три сентаво"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентаво"),
    (100.00, "сто песо, нуль сентаво"),
    (101.11, "сто один песо, одинадцять сентаво"),
    (10222, "сто два песо, двадцять два сентаво"),
)
#
TEST_CASES_TO_CURRENCY_AUD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)
#
TEST_CASES_TO_CURRENCY_AWG = (
    (0.00, "нуль флоринів, нуль центів"),
    (1.00, "один флорин, нуль центів"),
    (2.00, "два флорини, нуль центів"),
    (5.00, "п'ять флоринів, нуль центів"),
    (11.00, "одинадцять флоринів, нуль центів"),
    (16.01, "шістнадцять флоринів, один цент"),
    (21.00, "двадцять один флорин, нуль центів"),
    (37.73, "тридцять сім флоринів, сімдесят три центи"),
    (81.25, "вісімдесят один флорин, двадцять п'ять центів"),
    (100.00, "сто флоринів, нуль центів"),
    (101.11, "сто один флорин, одинадцять центів"),
    (10222, "сто два флорини, двадцять два центи"),
)
#
TEST_CASES_TO_CURRENCY_AZN = (
    (0.00, "нуль манатів, нуль гяпіків"),
    (1.00, "один манат, нуль гяпіків"),
    (2.00, "два манати, нуль гяпіків"),
    (5.00, "п'ять манатів, нуль гяпіків"),
    (11.00, "одинадцять манатів, нуль гяпіків"),
    (16.01, "шістнадцять манатів, один гяпік"),
    (21.00, "двадцять один манат, нуль гяпіків"),
    (37.73, "тридцять сім манатів, сімдесят три гяпіки"),
    (81.25, "вісімдесят один манат, двадцять п'ять гяпіків"),
    (100.00, "сто манатів, нуль гяпіків"),
    (101.11, "сто один манат, одинадцять гяпіків"),
    (10222, "сто два манати, двадцять два гяпіки"),
)
#
TEST_CASES_TO_CURRENCY_BAM = (
    (0.00, "нуль марок, нуль фенінгів"),
    (1.00, "одна марка, нуль фенінгів"),
    (2.00, "дві марки, нуль фенінгів"),
    (5.00, "п'ять марок, нуль фенінгів"),
    (11.00, "одинадцять марок, нуль фенінгів"),
    (16.01, "шістнадцять марок, один фенінг"),
    (21.00, "двадцять одна марка, нуль фенінгів"),
    (37.73, "тридцять сім марок, сімдесят три фенінги"),
    (81.25, "вісімдесят одна марка, двадцять п'ять фенінгів"),
    (100.00, "сто марок, нуль фенінгів"),
    (101.11, "сто одна марка, одинадцять фенінгів"),
    (10222, "сто дві марки, двадцять два фенінги"),
)
#
TEST_CASES_TO_CURRENCY_BBD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_BDT = (
    (0.00, "нуль так, нуль пойш"),
    (1.00, "одна така, нуль пойш"),
    (2.00, "дві таки, нуль пойш"),
    (5.00, "п'ять так, нуль пойш"),
    (11.00, "одинадцять так, нуль пойш"),
    (16.01, "шістнадцять так, одна пойша"),
    (21.00, "двадцять одна така, нуль пойш"),
    (37.73, "тридцять сім так, сімдесят три пойші"),
    (81.25, "вісімдесят одна така, двадцять п'ять пойш"),
    (100.00, "сто так, нуль пойш"),
    (101.11, "сто одна така, одинадцять пойш"),
    (10222, "сто дві таки, двадцять дві пойші"),
)

TEST_CASES_TO_CURRENCY_BGN = (
    (0.00, "нуль левів, нуль стотинок"),
    (1.00, "один лев, нуль стотинок"),
    (2.00, "два леви, нуль стотинок"),
    (5.00, "п'ять левів, нуль стотинок"),
    (11.00, "одинадцять левів, нуль стотинок"),
    (16.01, "шістнадцять левів, одна стотинка"),
    (21.00, "двадцять один лев, нуль стотинок"),
    (37.73, "тридцять сім левів, сімдесят три стотинки"),
    (81.25, "вісімдесят один лев, двадцять п'ять стотинок"),
    (100.00, "сто левів, нуль стотинок"),
    (101.11, "сто один лев, одинадцять стотинок"),
    (10222, "сто два леви, двадцять дві стотинки"),
)

TEST_CASES_TO_CURRENCY_BHD = (
    (0.00, "нуль динарів, нуль філсів"),
    (1.00, "один динар, нуль філсів"),
    (2.00, "два динари, нуль філсів"),
    (5.00, "п'ять динарів, нуль філсів"),
    (11.00, "одинадцять динарів, нуль філсів"),
    (16.01, "шістнадцять динарів, один філс"),
    (21.00, "двадцять один динар, нуль філсів"),
    (37.73, "тридцять сім динарів, сімдесят три філси"),
    (81.25, "вісімдесят один динар, двадцять п'ять філсів"),
    (100.00, "сто динарів, нуль філсів"),
    (101.11, "сто один динар, одинадцять філсів"),
    (10222, "сто два динари, двадцять два філси"),
)

TEST_CASES_TO_CURRENCY_BIF = (
    (0.00, "нуль франків, нуль сантимів"),
    (1.00, "один франк, нуль сантимів"),
    (2.00, "два франки, нуль сантимів"),
    (5.00, "п'ять франків, нуль сантимів"),
    (11.00, "одинадцять франків, нуль сантимів"),
    (16.01, "шістнадцять франків, один сантим"),
    (21.00, "двадцять один франк, нуль сантимів"),
    (37.73, "тридцять сім франків, сімдесят три сантими"),
    (81.25, "вісімдесят один франк, двадцять п'ять сантимів"),
    (100.00, "сто франків, нуль сантимів"),
    (101.11, "сто один франк, одинадцять сантимів"),
    (10222, "сто два франки, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_BMD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_BND = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_BOB = (
    (0.00, "нуль болівіано, нуль сентаво"),
    (1.00, "один болівіано, нуль сентаво"),
    (2.00, "два болівіано, нуль сентаво"),
    (5.00, "п'ять болівіано, нуль сентаво"),
    (11.00, "одинадцять болівіано, нуль сентаво"),
    (16.01, "шістнадцять болівіано, один сентаво"),
    (21.00, "двадцять один болівіано, нуль сентаво"),
    (37.73, "тридцять сім болівіано, сімдесят три сентаво"),
    (81.25, "вісімдесят один болівіано, двадцять п'ять сентаво"),
    (100.00, "сто болівіано, нуль сентаво"),
    (101.11, "сто один болівіано, одинадцять сентаво"),
    (10222, "сто два болівіано, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_BRL = (
    (0.00, "нуль реалів, нуль сентаво"),
    (1.00, "один реал, нуль сентаво"),
    (2.00, "два реали, нуль сентаво"),
    (5.00, "п'ять реалів, нуль сентаво"),
    (11.00, "одинадцять реалів, нуль сентаво"),
    (16.01, "шістнадцять реалів, один сентаво"),
    (21.00, "двадцять один реал, нуль сентаво"),
    (37.73, "тридцять сім реалів, сімдесят три сентаво"),
    (81.25, "вісімдесят один реал, двадцять п'ять сентаво"),
    (100.00, "сто реалів, нуль сентаво"),
    (101.11, "сто один реал, одинадцять сентаво"),
    (10222, "сто два реали, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_BSD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_BTN = (
    (0.00, "нуль нгултрумів, нуль четрумів"),
    (1.00, "один нгултрум, нуль четрумів"),
    (2.00, "два нгултруми, нуль четрумів"),
    (5.00, "п'ять нгултрумів, нуль четрумів"),
    (11.00, "одинадцять нгултрумів, нуль четрумів"),
    (16.01, "шістнадцять нгултрумів, один четрум"),
    (21.00, "двадцять один нгултрум, нуль четрумів"),
    (37.73, "тридцять сім нгултрумів, сімдесят три четруми"),
    (81.25, "вісімдесят один нгултрум, двадцять п'ять четрумів"),
    (100.00, "сто нгултрумів, нуль четрумів"),
    (101.11, "сто один нгултрум, одинадцять четрумів"),
    (10222, "сто два нгултруми, двадцять два четруми"),
)

TEST_CASES_TO_CURRENCY_BWP = (
    (0.00, "нуль пул, нуль тхебе"),
    (1.00, "одна пула, нуль тхебе"),
    (2.00, "дві пули, нуль тхебе"),
    (5.00, "п'ять пул, нуль тхебе"),
    (11.00, "одинадцять пул, нуль тхебе"),
    (16.01, "шістнадцять пул, один тхебе"),
    (21.00, "двадцять одна пула, нуль тхебе"),
    (37.73, "тридцять сім пул, сімдесят три тхебе"),
    (81.25, "вісімдесят одна пула, двадцять п'ять тхебе"),
    (100.00, "сто пул, нуль тхебе"),
    (101.11, "сто одна пула, одинадцять тхебе"),
    (10222, "сто дві пули, двадцять два тхебе"),
)

TEST_CASES_TO_CURRENCY_BYN = (
    (0.00, "нуль рублів, нуль копійок"),
    (1.00, "один рубель, нуль копійок"),
    (2.00, "два рублі, нуль копійок"),
    (5.00, "п'ять рублів, нуль копійок"),
    (11.00, "одинадцять рублів, нуль копійок"),
    (16.01, "шістнадцять рублів, одна копійка"),
    (21.00, "двадцять один рубель, нуль копійок"),
    (37.73, "тридцять сім рублів, сімдесят три копійки"),
    (81.25, "вісімдесят один рубель, двадцять п'ять копійок"),
    (100.00, "сто рублів, нуль копійок"),
    (101.11, "сто один рубель, одинадцять копійок"),
    (10222, "сто два рублі, двадцять дві копійки"),
)

TEST_CASES_TO_CURRENCY_BZD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_CAD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_CDF = (
    (0.00, "нуль франків, нуль сантимів"),
    (1.00, "один франк, нуль сантимів"),
    (2.00, "два франки, нуль сантимів"),
    (5.00, "п'ять франків, нуль сантимів"),
    (11.00, "одинадцять франків, нуль сантимів"),
    (16.01, "шістнадцять франків, один сантим"),
    (21.00, "двадцять один франк, нуль сантимів"),
    (37.73, "тридцять сім франків, сімдесят три сантими"),
    (81.25, "вісімдесят один франк, двадцять п'ять сантимів"),
    (100.00, "сто франків, нуль сантимів"),
    (101.11, "сто один франк, одинадцять сантимів"),
    (10222, "сто два франки, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_CHF = (
    (0.00, "нуль франків, нуль сантимів"),
    (1.00, "один франк, нуль сантимів"),
    (2.00, "два франки, нуль сантимів"),
    (5.00, "п'ять франків, нуль сантимів"),
    (11.00, "одинадцять франків, нуль сантимів"),
    (16.01, "шістнадцять франків, один сантим"),
    (21.00, "двадцять один франк, нуль сантимів"),
    (37.73, "тридцять сім франків, сімдесят три сантими"),
    (81.25, "вісімдесят один франк, двадцять п'ять сантимів"),
    (100.00, "сто франків, нуль сантимів"),
    (101.11, "сто один франк, одинадцять сантимів"),
    (10222, "сто два франки, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_CLP = (
    (0.00, "нуль песо, нуль сентаво"),
    (1.00, "один песо, нуль сентаво"),
    (2.00, "два песо, нуль сентаво"),
    (5.00, "п'ять песо, нуль сентаво"),
    (11.00, "одинадцять песо, нуль сентаво"),
    (16.01, "шістнадцять песо, один сентаво"),
    (21.00, "двадцять один песо, нуль сентаво"),
    (37.73, "тридцять сім песо, сімдесят три сентаво"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентаво"),
    (100.00, "сто песо, нуль сентаво"),
    (101.11, "сто один песо, одинадцять сентаво"),
    (10222, "сто два песо, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_CNY = (
    (0.00, "нуль юанів, нуль финів"),
    (1.00, "один юань, нуль финів"),
    (2.00, "два юані, нуль финів"),
    (5.00, "п'ять юанів, нуль финів"),
    (11.00, "одинадцять юанів, нуль финів"),
    (16.01, "шістнадцять юанів, один финь"),
    (21.00, "двадцять один юань, нуль финів"),
    (37.73, "тридцять сім юанів, сімдесят три фині"),
    (81.25, "вісімдесят один юань, двадцять п'ять финів"),
    (100.00, "сто юанів, нуль финів"),
    (101.11, "сто один юань, одинадцять финів"),
    (10222, "сто два юані, двадцять два фині"),
)

TEST_CASES_TO_CURRENCY_COP = (
    (0.00, "нуль песо, нуль сентаво"),
    (1.00, "один песо, нуль сентаво"),
    (2.00, "два песо, нуль сентаво"),
    (5.00, "п'ять песо, нуль сентаво"),
    (11.00, "одинадцять песо, нуль сентаво"),
    (16.01, "шістнадцять песо, один сентаво"),
    (21.00, "двадцять один песо, нуль сентаво"),
    (37.73, "тридцять сім песо, сімдесят три сентаво"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентаво"),
    (100.00, "сто песо, нуль сентаво"),
    (101.11, "сто один песо, одинадцять сентаво"),
    (10222, "сто два песо, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_CRC = (
    (0.00, "нуль колонів, нуль сентімо"),
    (1.00, "один колон, нуль сентімо"),
    (2.00, "два колони, нуль сентімо"),
    (5.00, "п'ять колонів, нуль сентімо"),
    (11.00, "одинадцять колонів, нуль сентімо"),
    (16.01, "шістнадцять колонів, один сентімо"),
    (21.00, "двадцять один колон, нуль сентімо"),
    (37.73, "тридцять сім колонів, сімдесят три сентімо"),
    (81.25, "вісімдесят один колон, двадцять п'ять сентімо"),
    (100.00, "сто колонів, нуль сентімо"),
    (101.11, "сто один колон, одинадцять сентімо"),
    (10222, "сто два колони, двадцять два сентімо"),
)

TEST_CASES_TO_CURRENCY_CUC = (
    (0.00, "нуль песо, нуль сентаво"),
    (1.00, "один песо, нуль сентаво"),
    (2.00, "два песо, нуль сентаво"),
    (5.00, "п'ять песо, нуль сентаво"),
    (11.00, "одинадцять песо, нуль сентаво"),
    (16.01, "шістнадцять песо, один сентаво"),
    (21.00, "двадцять один песо, нуль сентаво"),
    (37.73, "тридцять сім песо, сімдесят три сентаво"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентаво"),
    (100.00, "сто песо, нуль сентаво"),
    (101.11, "сто один песо, одинадцять сентаво"),
    (10222, "сто два песо, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_CUP = (
    (0.00, "нуль песо, нуль сентаво"),
    (1.00, "один песо, нуль сентаво"),
    (2.00, "два песо, нуль сентаво"),
    (5.00, "п'ять песо, нуль сентаво"),
    (11.00, "одинадцять песо, нуль сентаво"),
    (16.01, "шістнадцять песо, один сентаво"),
    (21.00, "двадцять один песо, нуль сентаво"),
    (37.73, "тридцять сім песо, сімдесят три сентаво"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентаво"),
    (100.00, "сто песо, нуль сентаво"),
    (101.11, "сто один песо, одинадцять сентаво"),
    (10222, "сто два песо, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_CVE = (
    (0.00, "нуль ескудо, нуль сентаво"),
    (1.00, "один ескудо, нуль сентаво"),
    (2.00, "два ескудо, нуль сентаво"),
    (5.00, "п'ять ескудо, нуль сентаво"),
    (11.00, "одинадцять ескудо, нуль сентаво"),
    (16.01, "шістнадцять ескудо, один сентаво"),
    (21.00, "двадцять один ескудо, нуль сентаво"),
    (37.73, "тридцять сім ескудо, сімдесят три сентаво"),
    (81.25, "вісімдесят один ескудо, двадцять п'ять сентаво"),
    (100.00, "сто ескудо, нуль сентаво"),
    (101.11, "сто один ескудо, одинадцять сентаво"),
    (10222, "сто два ескудо, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_CZK = (
    (0.00, "нуль крон, нуль гелерів"),
    (1.00, "одна крона, нуль гелерів"),
    (2.00, "дві крони, нуль гелерів"),
    (5.00, "п'ять крон, нуль гелерів"),
    (11.00, "одинадцять крон, нуль гелерів"),
    (16.01, "шістнадцять крон, один гелер"),
    (21.00, "двадцять одна крона, нуль гелерів"),
    (37.73, "тридцять сім крон, сімдесят три гелери"),
    (81.25, "вісімдесят одна крона, двадцять п'ять гелерів"),
    (100.00, "сто крон, нуль гелерів"),
    (101.11, "сто одна крона, одинадцять гелерів"),
    (10222, "сто дві крони, двадцять два гелери"),
)

TEST_CASES_TO_CURRENCY_DJF = (
    (0.00, "нуль франків, нуль сантимів"),
    (1.00, "один франк, нуль сантимів"),
    (2.00, "два франки, нуль сантимів"),
    (5.00, "п'ять франків, нуль сантимів"),
    (11.00, "одинадцять франків, нуль сантимів"),
    (16.01, "шістнадцять франків, один сантим"),
    (21.00, "двадцять один франк, нуль сантимів"),
    (37.73, "тридцять сім франків, сімдесят три сантими"),
    (81.25, "вісімдесят один франк, двадцять п'ять сантимів"),
    (100.00, "сто франків, нуль сантимів"),
    (101.11, "сто один франк, одинадцять сантимів"),
    (10222, "сто два франки, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_DKK = (
    (0.00, "нуль крон, нуль ере"),
    (1.00, "одна крона, нуль ере"),
    (2.00, "дві крони, нуль ере"),
    (5.00, "п'ять крон, нуль ере"),
    (11.00, "одинадцять крон, нуль ере"),
    (16.01, "шістнадцять крон, один ере"),
    (21.00, "двадцять одна крона, нуль ере"),
    (37.73, "тридцять сім крон, сімдесят три ере"),
    (81.25, "вісімдесят одна крона, двадцять п'ять ере"),
    (100.00, "сто крон, нуль ере"),
    (101.11, "сто одна крона, одинадцять ере"),
    (10222, "сто дві крони, двадцять два ере"),
)

TEST_CASES_TO_CURRENCY_DOP = (
    (0.00, "нуль песо, нуль сентаво"),
    (1.00, "один песо, нуль сентаво"),
    (2.00, "два песо, нуль сентаво"),
    (5.00, "п'ять песо, нуль сентаво"),
    (11.00, "одинадцять песо, нуль сентаво"),
    (16.01, "шістнадцять песо, один сентаво"),
    (21.00, "двадцять один песо, нуль сентаво"),
    (37.73, "тридцять сім песо, сімдесят три сентаво"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентаво"),
    (100.00, "сто песо, нуль сентаво"),
    (101.11, "сто один песо, одинадцять сентаво"),
    (10222, "сто два песо, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_DZD = (
    (0.00, "нуль динарів, нуль сантимів"),
    (1.00, "один динар, нуль сантимів"),
    (2.00, "два динари, нуль сантимів"),
    (5.00, "п'ять динарів, нуль сантимів"),
    (11.00, "одинадцять динарів, нуль сантимів"),
    (16.01, "шістнадцять динарів, один сантим"),
    (21.00, "двадцять один динар, нуль сантимів"),
    (37.73, "тридцять сім динарів, сімдесят три сантими"),
    (81.25, "вісімдесят один динар, двадцять п'ять сантимів"),
    (100.00, "сто динарів, нуль сантимів"),
    (101.11, "сто один динар, одинадцять сантимів"),
    (10222, "сто два динари, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_EGP = (
    (0.00, "нуль фунтів, нуль піастрів"),
    (1.00, "один фунт, нуль піастрів"),
    (2.00, "два фунти, нуль піастрів"),
    (5.00, "п'ять фунтів, нуль піастрів"),
    (11.00, "одинадцять фунтів, нуль піастрів"),
    (16.01, "шістнадцять фунтів, один піастр"),
    (21.00, "двадцять один фунт, нуль піастрів"),
    (37.73, "тридцять сім фунтів, сімдесят три піастри"),
    (81.25, "вісімдесят один фунт, двадцять п'ять піастрів"),
    (100.00, "сто фунтів, нуль піастрів"),
    (101.11, "сто один фунт, одинадцять піастрів"),
    (10222, "сто два фунти, двадцять два піастри"),
)

TEST_CASES_TO_CURRENCY_ERN = (
    (0.00, "нуль накф, нуль центів"),
    (1.00, "одна накфа, нуль центів"),
    (2.00, "дві накфи, нуль центів"),
    (5.00, "п'ять накф, нуль центів"),
    (11.00, "одинадцять накф, нуль центів"),
    (16.01, "шістнадцять накф, один цент"),
    (21.00, "двадцять одна накфа, нуль центів"),
    (37.73, "тридцять сім накф, сімдесят три центи"),
    (81.25, "вісімдесят одна накфа, двадцять п'ять центів"),
    (100.00, "сто накф, нуль центів"),
    (101.11, "сто одна накфа, одинадцять центів"),
    (10222, "сто дві накфи, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_ETB = (
    (0.00, "нуль бирів, нуль центів"),
    (1.00, "один бир, нуль центів"),
    (2.00, "два бири, нуль центів"),
    (5.00, "п'ять бирів, нуль центів"),
    (11.00, "одинадцять бирів, нуль центів"),
    (16.01, "шістнадцять бирів, один цент"),
    (21.00, "двадцять один бир, нуль центів"),
    (37.73, "тридцять сім бирів, сімдесят три центи"),
    (81.25, "вісімдесят один бир, двадцять п'ять центів"),
    (100.00, "сто бирів, нуль центів"),
    (101.11, "сто один бир, одинадцять центів"),
    (10222, "сто два бири, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_EUR = (
    (0.00, "нуль євро, нуль центів"),
    (1.00, "один євро, нуль центів"),
    (2.00, "два євро, нуль центів"),
    (5.00, "п'ять євро, нуль центів"),
    (11.00, "одинадцять євро, нуль центів"),
    (16.01, "шістнадцять євро, один цент"),
    (21.00, "двадцять один євро, нуль центів"),
    (37.73, "тридцять сім євро, сімдесят три центи"),
    (81.25, "вісімдесят один євро, двадцять п'ять центів"),
    (100.00, "сто євро, нуль центів"),
    (101.11, "сто один євро, одинадцять центів"),
    (10222, "сто два євро, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_FJD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_FKP = (
    (0.00, "нуль фунтів, нуль пенсів"),
    (1.00, "один фунт, нуль пенсів"),
    (2.00, "два фунти, нуль пенсів"),
    (5.00, "п'ять фунтів, нуль пенсів"),
    (11.00, "одинадцять фунтів, нуль пенсів"),
    (16.01, "шістнадцять фунтів, один пенс"),
    (21.00, "двадцять один фунт, нуль пенсів"),
    (37.73, "тридцять сім фунтів, сімдесят три пенси"),
    (81.25, "вісімдесят один фунт, двадцять п'ять пенсів"),
    (100.00, "сто фунтів, нуль пенсів"),
    (101.11, "сто один фунт, одинадцять пенсів"),
    (10222, "сто два фунти, двадцять два пенси"),
)

TEST_CASES_TO_CURRENCY_GBP = (
    (0.00, "нуль фунтів, нуль пенсів"),
    (1.00, "один фунт, нуль пенсів"),
    (2.00, "два фунти, нуль пенсів"),
    (5.00, "п'ять фунтів, нуль пенсів"),
    (11.00, "одинадцять фунтів, нуль пенсів"),
    (16.01, "шістнадцять фунтів, один пенс"),
    (21.00, "двадцять один фунт, нуль пенсів"),
    (37.73, "тридцять сім фунтів, сімдесят три пенси"),
    (81.25, "вісімдесят один фунт, двадцять п'ять пенсів"),
    (100.00, "сто фунтів, нуль пенсів"),
    (101.11, "сто один фунт, одинадцять пенсів"),
    (10222, "сто два фунти, двадцять два пенси"),
)

TEST_CASES_TO_CURRENCY_GEL = (
    (0.00, "нуль ларі, нуль тетрі"),
    (1.00, "один ларі, нуль тетрі"),
    (2.00, "два ларі, нуль тетрі"),
    (5.00, "п'ять ларі, нуль тетрі"),
    (11.00, "одинадцять ларі, нуль тетрі"),
    (16.01, "шістнадцять ларі, один тетрі"),
    (21.00, "двадцять один ларі, нуль тетрі"),
    (37.73, "тридцять сім ларі, сімдесят три тетрі"),
    (81.25, "вісімдесят один ларі, двадцять п'ять тетрі"),
    (100.00, "сто ларі, нуль тетрі"),
    (101.11, "сто один ларі, одинадцять тетрі"),
    (10222, "сто два ларі, двадцять два тетрі"),
)

TEST_CASES_TO_CURRENCY_GHS = (
    (0.00, "нуль седі, нуль песев"),
    (1.00, "один седі, нуль песев"),
    (2.00, "два седі, нуль песев"),
    (5.00, "п'ять седі, нуль песев"),
    (11.00, "одинадцять седі, нуль песев"),
    (16.01, "шістнадцять седі, одна песева"),
    (21.00, "двадцять один седі, нуль песев"),
    (37.73, "тридцять сім седі, сімдесят три песеви"),
    (81.25, "вісімдесят один седі, двадцять п'ять песев"),
    (100.00, "сто седі, нуль песев"),
    (101.11, "сто один седі, одинадцять песев"),
    (10222, "сто два седі, двадцять дві песеви"),
)

TEST_CASES_TO_CURRENCY_GIP = (
    (0.00, "нуль фунтів, нуль пенсів"),
    (1.00, "один фунт, нуль пенсів"),
    (2.00, "два фунти, нуль пенсів"),
    (5.00, "п'ять фунтів, нуль пенсів"),
    (11.00, "одинадцять фунтів, нуль пенсів"),
    (16.01, "шістнадцять фунтів, один пенс"),
    (21.00, "двадцять один фунт, нуль пенсів"),
    (37.73, "тридцять сім фунтів, сімдесят три пенси"),
    (81.25, "вісімдесят один фунт, двадцять п'ять пенсів"),
    (100.00, "сто фунтів, нуль пенсів"),
    (101.11, "сто один фунт, одинадцять пенсів"),
    (10222, "сто два фунти, двадцять два пенси"),
)

TEST_CASES_TO_CURRENCY_GMD = (
    (0.00, "нуль даласі, нуль бутутів"),
    (1.00, "один даласі, нуль бутутів"),
    (2.00, "два даласі, нуль бутутів"),
    (5.00, "п'ять даласі, нуль бутутів"),
    (11.00, "одинадцять даласі, нуль бутутів"),
    (16.01, "шістнадцять даласі, один бутут"),
    (21.00, "двадцять один даласі, нуль бутутів"),
    (37.73, "тридцять сім даласі, сімдесят три бутути"),
    (81.25, "вісімдесят один даласі, двадцять п'ять бутутів"),
    (100.00, "сто даласі, нуль бутутів"),
    (101.11, "сто один даласі, одинадцять бутутів"),
    (10222, "сто два даласі, двадцять два бутути"),
)

TEST_CASES_TO_CURRENCY_GNF = (
    (0.00, "нуль франків, нуль сантимів"),
    (1.00, "один франк, нуль сантимів"),
    (2.00, "два франки, нуль сантимів"),
    (5.00, "п'ять франків, нуль сантимів"),
    (11.00, "одинадцять франків, нуль сантимів"),
    (16.01, "шістнадцять франків, один сантим"),
    (21.00, "двадцять один франк, нуль сантимів"),
    (37.73, "тридцять сім франків, сімдесят три сантими"),
    (81.25, "вісімдесят один франк, двадцять п'ять сантимів"),
    (100.00, "сто франків, нуль сантимів"),
    (101.11, "сто один франк, одинадцять сантимів"),
    (10222, "сто два франки, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_GTQ = (
    (0.00, "нуль кетсалів, нуль сентаво"),
    (1.00, "один кетсаль, нуль сентаво"),
    (2.00, "два кетсалі, нуль сентаво"),
    (5.00, "п'ять кетсалів, нуль сентаво"),
    (11.00, "одинадцять кетсалів, нуль сентаво"),
    (16.01, "шістнадцять кетсалів, один сентаво"),
    (21.00, "двадцять один кетсаль, нуль сентаво"),
    (37.73, "тридцять сім кетсалів, сімдесят три сентаво"),
    (81.25, "вісімдесят один кетсаль, двадцять п'ять сентаво"),
    (100.00, "сто кетсалів, нуль сентаво"),
    (101.11, "сто один кетсаль, одинадцять сентаво"),
    (10222, "сто два кетсалі, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_GYD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_HKD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_HNL = (
    (0.00, "нуль лемпір, нуль сентаво"),
    (1.00, "одна лемпіра, нуль сентаво"),
    (2.00, "дві лемпіри, нуль сентаво"),
    (5.00, "п'ять лемпір, нуль сентаво"),
    (11.00, "одинадцять лемпір, нуль сентаво"),
    (16.01, "шістнадцять лемпір, один сентаво"),
    (21.00, "двадцять одна лемпіра, нуль сентаво"),
    (37.73, "тридцять сім лемпір, сімдесят три сентаво"),
    (81.25, "вісімдесят одна лемпіра, двадцять п'ять сентаво"),
    (100.00, "сто лемпір, нуль сентаво"),
    (101.11, "сто одна лемпіра, одинадцять сентаво"),
    (10222, "сто дві лемпіри, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_HRK = (
    (0.00, "нуль кун, нуль ліп"),
    (1.00, "одна куна, нуль ліп"),
    (2.00, "дві куни, нуль ліп"),
    (5.00, "п'ять кун, нуль ліп"),
    (11.00, "одинадцять кун, нуль ліп"),
    (16.01, "шістнадцять кун, одна ліпа"),
    (21.00, "двадцять одна куна, нуль ліп"),
    (37.73, "тридцять сім кун, сімдесят три ліпи"),
    (81.25, "вісімдесят одна куна, двадцять п'ять ліп"),
    (100.00, "сто кун, нуль ліп"),
    (101.11, "сто одна куна, одинадцять ліп"),
    (10222, "сто дві куни, двадцять дві ліпи"),
)

TEST_CASES_TO_CURRENCY_HTG = (
    (0.00, "нуль гурдів, нуль сантимів"),
    (1.00, "один гурд, нуль сантимів"),
    (2.00, "два гурди, нуль сантимів"),
    (5.00, "п'ять гурдів, нуль сантимів"),
    (11.00, "одинадцять гурдів, нуль сантимів"),
    (16.01, "шістнадцять гурдів, один сантим"),
    (21.00, "двадцять один гурд, нуль сантимів"),
    (37.73, "тридцять сім гурдів, сімдесят три сантими"),
    (81.25, "вісімдесят один гурд, двадцять п'ять сантимів"),
    (100.00, "сто гурдів, нуль сантимів"),
    (101.11, "сто один гурд, одинадцять сантимів"),
    (10222, "сто два гурди, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_HUF = (
    (0.00, "нуль форинтів, нуль філлерів"),
    (1.00, "один форинт, нуль філлерів"),
    (2.00, "два форинти, нуль філлерів"),
    (5.00, "п'ять форинтів, нуль філлерів"),
    (11.00, "одинадцять форинтів, нуль філлерів"),
    (16.01, "шістнадцять форинтів, один філлер"),
    (21.00, "двадцять один форинт, нуль філлерів"),
    (37.73, "тридцять сім форинтів, сімдесят три філлери"),
    (81.25, "вісімдесят один форинт, двадцять п'ять філлерів"),
    (100.00, "сто форинтів, нуль філлерів"),
    (101.11, "сто один форинт, одинадцять філлерів"),
    (10222, "сто два форинти, двадцять два філлери"),
)

TEST_CASES_TO_CURRENCY_IDR = (
    (0.00, "нуль рупій, нуль центів"),
    (1.00, "одна рупія, нуль центів"),
    (2.00, "дві рупії, нуль центів"),
    (5.00, "п'ять рупій, нуль центів"),
    (11.00, "одинадцять рупій, нуль центів"),
    (16.01, "шістнадцять рупій, один цент"),
    (21.00, "двадцять одна рупія, нуль центів"),
    (37.73, "тридцять сім рупій, сімдесят три центи"),
    (81.25, "вісімдесят одна рупія, двадцять п'ять центів"),
    (100.00, "сто рупій, нуль центів"),
    (101.11, "сто одна рупія, одинадцять центів"),
    (10222, "сто дві рупії, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_ILS = (
    (0.00, "нуль шекелів, нуль агор"),
    (1.00, "один шекель, нуль агор"),
    (2.00, "два шекелі, нуль агор"),
    (5.00, "п'ять шекелів, нуль агор"),
    (11.00, "одинадцять шекелів, нуль агор"),
    (16.01, "шістнадцять шекелів, одна агора"),
    (21.00, "двадцять один шекель, нуль агор"),
    (37.73, "тридцять сім шекелів, сімдесят три агори"),
    (81.25, "вісімдесят один шекель, двадцять п'ять агор"),
    (100.00, "сто шекелів, нуль агор"),
    (101.11, "сто один шекель, одинадцять агор"),
    (10222, "сто два шекелі, двадцять дві агори"),
)

TEST_CASES_TO_CURRENCY_INR = (
    (0.00, "нуль рупій, нуль пайс"),
    (1.00, "одна рупія, нуль пайс"),
    (2.00, "дві рупії, нуль пайс"),
    (5.00, "п'ять рупій, нуль пайс"),
    (11.00, "одинадцять рупій, нуль пайс"),
    (16.01, "шістнадцять рупій, одна пайса"),
    (21.00, "двадцять одна рупія, нуль пайс"),
    (37.73, "тридцять сім рупій, сімдесят три пайси"),
    (81.25, "вісімдесят одна рупія, двадцять п'ять пайс"),
    (100.00, "сто рупій, нуль пайс"),
    (101.11, "сто одна рупія, одинадцять пайс"),
    (10222, "сто дві рупії, двадцять дві пайси"),
)

TEST_CASES_TO_CURRENCY_IQD = (
    (0.00, "нуль динарів, нуль філсів"),
    (1.00, "один динар, нуль філсів"),
    (2.00, "два динари, нуль філсів"),
    (5.00, "п'ять динарів, нуль філсів"),
    (11.00, "одинадцять динарів, нуль філсів"),
    (16.01, "шістнадцять динарів, один філс"),
    (21.00, "двадцять один динар, нуль філсів"),
    (37.73, "тридцять сім динарів, сімдесят три філси"),
    (81.25, "вісімдесят один динар, двадцять п'ять філсів"),
    (100.00, "сто динарів, нуль філсів"),
    (101.11, "сто один динар, одинадцять філсів"),
    (10222, "сто два динари, двадцять два філси"),
)

TEST_CASES_TO_CURRENCY_IRR = (
    (0.00, "нуль ріалів, нуль динарів"),
    (1.00, "один ріал, нуль динарів"),
    (2.00, "два ріали, нуль динарів"),
    (5.00, "п'ять ріалів, нуль динарів"),
    (11.00, "одинадцять ріалів, нуль динарів"),
    (16.01, "шістнадцять ріалів, один динар"),
    (21.00, "двадцять один ріал, нуль динарів"),
    (37.73, "тридцять сім ріалів, сімдесят три динари"),
    (81.25, "вісімдесят один ріал, двадцять п'ять динарів"),
    (100.00, "сто ріалів, нуль динарів"),
    (101.11, "сто один ріал, одинадцять динарів"),
    (10222, "сто два ріали, двадцять два динари"),
)

TEST_CASES_TO_CURRENCY_ISK = (
    (0.00, "нуль крон, нуль ейре"),
    (1.00, "одна крона, нуль ейре"),
    (2.00, "дві крони, нуль ейре"),
    (5.00, "п'ять крон, нуль ейре"),
    (11.00, "одинадцять крон, нуль ейре"),
    (16.01, "шістнадцять крон, один ейре"),
    (21.00, "двадцять одна крона, нуль ейре"),
    (37.73, "тридцять сім крон, сімдесят три ейре"),
    (81.25, "вісімдесят одна крона, двадцять п'ять ейре"),
    (100.00, "сто крон, нуль ейре"),
    (101.11, "сто одна крона, одинадцять ейре"),
    (10222, "сто дві крони, двадцять два ейре"),
)

TEST_CASES_TO_CURRENCY_JMD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_JOD = (
    (0.00, "нуль динарів, нуль філсів"),
    (1.00, "один динар, нуль філсів"),
    (2.00, "два динари, нуль філсів"),
    (5.00, "п'ять динарів, нуль філсів"),
    (11.00, "одинадцять динарів, нуль філсів"),
    (16.01, "шістнадцять динарів, один філс"),
    (21.00, "двадцять один динар, нуль філсів"),
    (37.73, "тридцять сім динарів, сімдесят три філси"),
    (81.25, "вісімдесят один динар, двадцять п'ять філсів"),
    (100.00, "сто динарів, нуль філсів"),
    (101.11, "сто один динар, одинадцять філсів"),
    (10222, "сто два динари, двадцять два філси"),
)

TEST_CASES_TO_CURRENCY_JPY = (
    (0.00, "нуль єн, нуль сен"),
    (1.00, "одна єна, нуль сен"),
    (2.00, "дві єни, нуль сен"),
    (5.00, "п'ять єн, нуль сен"),
    (11.00, "одинадцять єн, нуль сен"),
    (16.01, "шістнадцять єн, один сен"),
    (21.00, "двадцять одна єна, нуль сен"),
    (37.73, "тридцять сім єн, сімдесят три сен"),
    (81.25, "вісімдесят одна єна, двадцять п'ять сен"),
    (100.00, "сто єн, нуль сен"),
    (101.11, "сто одна єна, одинадцять сен"),
    (10222, "сто дві єни, двадцять два сен"),
)

TEST_CASES_TO_CURRENCY_KES = (
    (0.00, "нуль шилінгів, нуль центів"),
    (1.00, "один шилінг, нуль центів"),
    (2.00, "два шилінги, нуль центів"),
    (5.00, "п'ять шилінгів, нуль центів"),
    (11.00, "одинадцять шилінгів, нуль центів"),
    (16.01, "шістнадцять шилінгів, один цент"),
    (21.00, "двадцять один шилінг, нуль центів"),
    (37.73, "тридцять сім шилінгів, сімдесят три центи"),
    (81.25, "вісімдесят один шилінг, двадцять п'ять центів"),
    (100.00, "сто шилінгів, нуль центів"),
    (101.11, "сто один шилінг, одинадцять центів"),
    (10222, "сто два шилінги, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_KGS = (
    (0.00, "нуль сомів, нуль тиїнів"),
    (1.00, "один сом, нуль тиїнів"),
    (2.00, "два соми, нуль тиїнів"),
    (5.00, "п'ять сомів, нуль тиїнів"),
    (11.00, "одинадцять сомів, нуль тиїнів"),
    (16.01, "шістнадцять сомів, один тиїн"),
    (21.00, "двадцять один сом, нуль тиїнів"),
    (37.73, "тридцять сім сомів, сімдесят три тиїни"),
    (81.25, "вісімдесят один сом, двадцять п'ять тиїнів"),
    (100.00, "сто сомів, нуль тиїнів"),
    (101.11, "сто один сом, одинадцять тиїнів"),
    (10222, "сто два соми, двадцять два тиїни"),
)

TEST_CASES_TO_CURRENCY_KHR = (
    (0.00, "нуль рієлів, нуль су"),
    (1.00, "один рієль, нуль су"),
    (2.00, "два рієлі, нуль су"),
    (5.00, "п'ять рієлів, нуль су"),
    (11.00, "одинадцять рієлів, нуль су"),
    (16.01, "шістнадцять рієлів, один су"),
    (21.00, "двадцять один рієль, нуль су"),
    (37.73, "тридцять сім рієлів, сімдесят три су"),
    (81.25, "вісімдесят один рієль, двадцять п'ять су"),
    (100.00, "сто рієлів, нуль су"),
    (101.11, "сто один рієль, одинадцять су"),
    (10222, "сто два рієлі, двадцять два су"),
)

TEST_CASES_TO_CURRENCY_KMF = (
    (0.00, "нуль франків, нуль сантимів"),
    (1.00, "один франк, нуль сантимів"),
    (2.00, "два франки, нуль сантимів"),
    (5.00, "п'ять франків, нуль сантимів"),
    (11.00, "одинадцять франків, нуль сантимів"),
    (16.01, "шістнадцять франків, один сантим"),
    (21.00, "двадцять один франк, нуль сантимів"),
    (37.73, "тридцять сім франків, сімдесят три сантими"),
    (81.25, "вісімдесят один франк, двадцять п'ять сантимів"),
    (100.00, "сто франків, нуль сантимів"),
    (101.11, "сто один франк, одинадцять сантимів"),
    (10222, "сто два франки, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_KPW = (
    (0.00, "нуль вон, нуль чонів"),
    (1.00, "одна вона, нуль чонів"),
    (2.00, "дві вони, нуль чонів"),
    (5.00, "п'ять вон, нуль чонів"),
    (11.00, "одинадцять вон, нуль чонів"),
    (16.01, "шістнадцять вон, один чон"),
    (21.00, "двадцять одна вона, нуль чонів"),
    (37.73, "тридцять сім вон, сімдесят три чони"),
    (81.25, "вісімдесят одна вона, двадцять п'ять чонів"),
    (100.00, "сто вон, нуль чонів"),
    (101.11, "сто одна вона, одинадцять чонів"),
    (10222, "сто дві вони, двадцять два чони"),
)

TEST_CASES_TO_CURRENCY_KRW = (
    (0.00, "нуль вон, нуль джеонів"),
    (1.00, "одна вона, нуль джеонів"),
    (2.00, "дві вони, нуль джеонів"),
    (5.00, "п'ять вон, нуль джеонів"),
    (11.00, "одинадцять вон, нуль джеонів"),
    (16.01, "шістнадцять вон, один джеон"),
    (21.00, "двадцять одна вона, нуль джеонів"),
    (37.73, "тридцять сім вон, сімдесят три джеони"),
    (81.25, "вісімдесят одна вона, двадцять п'ять джеонів"),
    (100.00, "сто вон, нуль джеонів"),
    (101.11, "сто одна вона, одинадцять джеонів"),
    (10222, "сто дві вони, двадцять два джеони"),
)

TEST_CASES_TO_CURRENCY_KWD = (
    (0.00, "нуль динарів, нуль філсів"),
    (1.00, "один динар, нуль філсів"),
    (2.00, "два динари, нуль філсів"),
    (5.00, "п'ять динарів, нуль філсів"),
    (11.00, "одинадцять динарів, нуль філсів"),
    (16.01, "шістнадцять динарів, один філс"),
    (21.00, "двадцять один динар, нуль філсів"),
    (37.73, "тридцять сім динарів, сімдесят три філси"),
    (81.25, "вісімдесят один динар, двадцять п'ять філсів"),
    (100.00, "сто динарів, нуль філсів"),
    (101.11, "сто один динар, одинадцять філсів"),
    (10222, "сто два динари, двадцять два філси"),
)

TEST_CASES_TO_CURRENCY_KYD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_KZT = (
    (0.00, "нуль теньге, нуль тиїнів"),
    (1.00, "один теньге, нуль тиїнів"),
    (2.00, "два теньге, нуль тиїнів"),
    (5.00, "п'ять теньге, нуль тиїнів"),
    (11.00, "одинадцять теньге, нуль тиїнів"),
    (16.01, "шістнадцять теньге, один тиїн"),
    (21.00, "двадцять один теньге, нуль тиїнів"),
    (37.73, "тридцять сім теньге, сімдесят три тиїни"),
    (81.25, "вісімдесят один теньге, двадцять п'ять тиїнів"),
    (100.00, "сто теньге, нуль тиїнів"),
    (101.11, "сто один теньге, одинадцять тиїнів"),
    (10222, "сто два теньге, двадцять два тиїни"),
)

TEST_CASES_TO_CURRENCY_LAK = (
    (0.00, "нуль кіпів, нуль атів"),
    (1.00, "один кіп, нуль атів"),
    (2.00, "два кіпи, нуль атів"),
    (5.00, "п'ять кіпів, нуль атів"),
    (11.00, "одинадцять кіпів, нуль атів"),
    (16.01, "шістнадцять кіпів, один ат"),
    (21.00, "двадцять один кіп, нуль атів"),
    (37.73, "тридцять сім кіпів, сімдесят три ати"),
    (81.25, "вісімдесят один кіп, двадцять п'ять атів"),
    (100.00, "сто кіпів, нуль атів"),
    (101.11, "сто один кіп, одинадцять атів"),
    (10222, "сто два кіпи, двадцять два ати"),
)

TEST_CASES_TO_CURRENCY_LBP = (
    (0.00, "нуль фунтів, нуль піастрів"),
    (1.00, "один фунт, нуль піастрів"),
    (2.00, "два фунти, нуль піастрів"),
    (5.00, "п'ять фунтів, нуль піастрів"),
    (11.00, "одинадцять фунтів, нуль піастрів"),
    (16.01, "шістнадцять фунтів, один піастр"),
    (21.00, "двадцять один фунт, нуль піастрів"),
    (37.73, "тридцять сім фунтів, сімдесят три піастри"),
    (81.25, "вісімдесят один фунт, двадцять п'ять піастрів"),
    (100.00, "сто фунтів, нуль піастрів"),
    (101.11, "сто один фунт, одинадцять піастрів"),
    (10222, "сто два фунти, двадцять два піастри"),
)

TEST_CASES_TO_CURRENCY_LKR = (
    (0.00, "нуль рупій, нуль центів"),
    (1.00, "одна рупія, нуль центів"),
    (2.00, "дві рупії, нуль центів"),
    (5.00, "п'ять рупій, нуль центів"),
    (11.00, "одинадцять рупій, нуль центів"),
    (16.01, "шістнадцять рупій, один цент"),
    (21.00, "двадцять одна рупія, нуль центів"),
    (37.73, "тридцять сім рупій, сімдесят три центи"),
    (81.25, "вісімдесят одна рупія, двадцять п'ять центів"),
    (100.00, "сто рупій, нуль центів"),
    (101.11, "сто одна рупія, одинадцять центів"),
    (10222, "сто дві рупії, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_LRD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_LSL = (
    (0.00, "нуль малоті, нуль лісенте"),
    (1.00, "один лоті, нуль лісенте"),
    (2.00, "два малоті, нуль лісенте"),
    (5.00, "п'ять малоті, нуль лісенте"),
    (11.00, "одинадцять малоті, нуль лісенте"),
    (16.01, "шістнадцять малоті, один сенте"),
    (21.00, "двадцять один лоті, нуль лісенте"),
    (37.73, "тридцять сім малоті, сімдесят три лісенте"),
    (81.25, "вісімдесят один лоті, двадцять п'ять лісенте"),
    (100.00, "сто малоті, нуль лісенте"),
    (101.11, "сто один лоті, одинадцять лісенте"),
    (10222, "сто два малоті, двадцять два лісенте"),
)

TEST_CASES_TO_CURRENCY_LYD = (
    (0.00, "нуль динарів, нуль дирхамів"),
    (1.00, "один динар, нуль дирхамів"),
    (2.00, "два динари, нуль дирхамів"),
    (5.00, "п'ять динарів, нуль дирхамів"),
    (11.00, "одинадцять динарів, нуль дирхамів"),
    (16.01, "шістнадцять динарів, один дирхам"),
    (21.00, "двадцять один динар, нуль дирхамів"),
    (37.73, "тридцять сім динарів, сімдесят три дирхами"),
    (81.25, "вісімдесят один динар, двадцять п'ять дирхамів"),
    (100.00, "сто динарів, нуль дирхамів"),
    (101.11, "сто один динар, одинадцять дирхамів"),
    (10222, "сто два динари, двадцять два дирхами"),
)

TEST_CASES_TO_CURRENCY_MAD = (
    (0.00, "нуль дирхамів, нуль сантимів"),
    (1.00, "один дирхам, нуль сантимів"),
    (2.00, "два дирхами, нуль сантимів"),
    (5.00, "п'ять дирхамів, нуль сантимів"),
    (11.00, "одинадцять дирхамів, нуль сантимів"),
    (16.01, "шістнадцять дирхамів, один сантим"),
    (21.00, "двадцять один дирхам, нуль сантимів"),
    (37.73, "тридцять сім дирхамів, сімдесят три сантими"),
    (81.25, "вісімдесят один дирхам, двадцять п'ять сантимів"),
    (100.00, "сто дирхамів, нуль сантимів"),
    (101.11, "сто один дирхам, одинадцять сантимів"),
    (10222, "сто два дирхами, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_MDL = (
    (0.00, "нуль леї, нуль бані"),
    (1.00, "один лей, нуль бані"),
    (2.00, "два леї, нуль бані"),
    (5.00, "п'ять леї, нуль бані"),
    (11.00, "одинадцять леї, нуль бані"),
    (16.01, "шістнадцять леї, один бан"),
    (21.00, "двадцять один лей, нуль бані"),
    (37.73, "тридцять сім леї, сімдесят три бані"),
    (81.25, "вісімдесят один лей, двадцять п'ять бані"),
    (100.00, "сто леї, нуль бані"),
    (101.11, "сто один лей, одинадцять бані"),
    (10222, "сто два леї, двадцять два бані"),
)

TEST_CASES_TO_CURRENCY_MGA = (
    (0.00, "нуль аріарі, нуль іраймбіланья"),
    (1.00, "один аріарі, нуль іраймбіланья"),
    (2.00, "два аріарі, нуль іраймбіланья"),
    (5.00, "п'ять аріарі, нуль іраймбіланья"),
    (11.00, "одинадцять аріарі, нуль іраймбіланья"),
    (16.01, "шістнадцять аріарі, один іраймбіланья"),
    (21.00, "двадцять один аріарі, нуль іраймбіланья"),
    (37.73, "тридцять сім аріарі, сімдесят три іраймбіланья"),
    (81.25, "вісімдесят один аріарі, двадцять п'ять іраймбіланья"),
    (100.00, "сто аріарі, нуль іраймбіланья"),
    (101.11, "сто один аріарі, одинадцять іраймбіланья"),
    (10222, "сто два аріарі, двадцять два іраймбіланья"),
)

TEST_CASES_TO_CURRENCY_MKD = (
    (0.00, "нуль денарів, нуль дені"),
    (1.00, "один денар, нуль дені"),
    (2.00, "два денари, нуль дені"),
    (5.00, "п'ять денарів, нуль дені"),
    (11.00, "одинадцять денарів, нуль дені"),
    (16.01, "шістнадцять денарів, один дені"),
    (21.00, "двадцять один денар, нуль дені"),
    (37.73, "тридцять сім денарів, сімдесят три дені"),
    (81.25, "вісімдесят один денар, двадцять п'ять дені"),
    (100.00, "сто денарів, нуль дені"),
    (101.11, "сто один денар, одинадцять дені"),
    (10222, "сто два денари, двадцять два дені"),
)

TEST_CASES_TO_CURRENCY_MMK = (
    (0.00, "нуль к'ят, нуль п'я"),
    (1.00, "один к'ят, нуль п'я"),
    (2.00, "два к'ят, нуль п'я"),
    (5.00, "п'ять к'ят, нуль п'я"),
    (11.00, "одинадцять к'ят, нуль п'я"),
    (16.01, "шістнадцять к'ят, один п'я"),
    (21.00, "двадцять один к'ят, нуль п'я"),
    (37.73, "тридцять сім к'ят, сімдесят три п'я"),
    (81.25, "вісімдесят один к'ят, двадцять п'ять п'я"),
    (100.00, "сто к'ят, нуль п'я"),
    (101.11, "сто один к'ят, одинадцять п'я"),
    (10222, "сто два к'ят, двадцять два п'я"),
)

TEST_CASES_TO_CURRENCY_MNT = (
    (0.00, "нуль тугриків, нуль мунгу"),
    (1.00, "один тугрик, нуль мунгу"),
    (2.00, "два тугрики, нуль мунгу"),
    (5.00, "п'ять тугриків, нуль мунгу"),
    (11.00, "одинадцять тугриків, нуль мунгу"),
    (16.01, "шістнадцять тугриків, один мунгу"),
    (21.00, "двадцять один тугрик, нуль мунгу"),
    (37.73, "тридцять сім тугриків, сімдесят три мунгу"),
    (81.25, "вісімдесят один тугрик, двадцять п'ять мунгу"),
    (100.00, "сто тугриків, нуль мунгу"),
    (101.11, "сто один тугрик, одинадцять мунгу"),
    (10222, "сто два тугрики, двадцять два мунгу"),
)

TEST_CASES_TO_CURRENCY_MOP = (
    (0.00, "нуль патак, нуль аво"),
    (1.00, "одна патака, нуль аво"),
    (2.00, "дві патакі, нуль аво"),
    (5.00, "п'ять патак, нуль аво"),
    (11.00, "одинадцять патак, нуль аво"),
    (16.01, "шістнадцять патак, один аво"),
    (21.00, "двадцять одна патака, нуль аво"),
    (37.73, "тридцять сім патак, сімдесят три аво"),
    (81.25, "вісімдесят одна патака, двадцять п'ять аво"),
    (100.00, "сто патак, нуль аво"),
    (101.11, "сто одна патака, одинадцять аво"),
    (10222, "сто дві патакі, двадцять два аво"),
)

TEST_CASES_TO_CURRENCY_MRU = (
    (0.00, "нуль угій, нуль хумс"),
    (1.00, "одна угія, нуль хумс"),
    (2.00, "дві угії, нуль хумс"),
    (5.00, "п'ять угій, нуль хумс"),
    (11.00, "одинадцять угій, нуль хумс"),
    (16.01, "шістнадцять угій, один хумс"),
    (21.00, "двадцять одна угія, нуль хумс"),
    (37.73, "тридцять сім угій, сімдесят три хумс"),
    (81.25, "вісімдесят одна угія, двадцять п'ять хумс"),
    (100.00, "сто угій, нуль хумс"),
    (101.11, "сто одна угія, одинадцять хумс"),
    (10222, "сто дві угії, двадцять два хумс"),
)

TEST_CASES_TO_CURRENCY_MUR = (
    (0.00, "нуль рупій, нуль центів"),
    (1.00, "одна рупія, нуль центів"),
    (2.00, "дві рупії, нуль центів"),
    (5.00, "п'ять рупій, нуль центів"),
    (11.00, "одинадцять рупій, нуль центів"),
    (16.01, "шістнадцять рупій, один цент"),
    (21.00, "двадцять одна рупія, нуль центів"),
    (37.73, "тридцять сім рупій, сімдесят три центи"),
    (81.25, "вісімдесят одна рупія, двадцять п'ять центів"),
    (100.00, "сто рупій, нуль центів"),
    (101.11, "сто одна рупія, одинадцять центів"),
    (10222, "сто дві рупії, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_MVR = (
    (0.00, "нуль руфій, нуль ларі"),
    (1.00, "одна руфія, нуль ларі"),
    (2.00, "дві руфії, нуль ларі"),
    (5.00, "п'ять руфій, нуль ларі"),
    (11.00, "одинадцять руфій, нуль ларі"),
    (16.01, "шістнадцять руфій, один ларі"),
    (21.00, "двадцять одна руфія, нуль ларі"),
    (37.73, "тридцять сім руфій, сімдесят три ларі"),
    (81.25, "вісімдесят одна руфія, двадцять п'ять ларі"),
    (100.00, "сто руфій, нуль ларі"),
    (101.11, "сто одна руфія, одинадцять ларі"),
    (10222, "сто дві руфії, двадцять два ларі"),
)

TEST_CASES_TO_CURRENCY_MWK = (
    (0.00, "нуль квач, нуль тамбала"),
    (1.00, "одна квача, нуль тамбала"),
    (2.00, "дві квачі, нуль тамбала"),
    (5.00, "п'ять квач, нуль тамбала"),
    (11.00, "одинадцять квач, нуль тамбала"),
    (16.01, "шістнадцять квач, один тамбала"),
    (21.00, "двадцять одна квача, нуль тамбала"),
    (37.73, "тридцять сім квач, сімдесят три тамбала"),
    (81.25, "вісімдесят одна квача, двадцять п'ять тамбала"),
    (100.00, "сто квач, нуль тамбала"),
    (101.11, "сто одна квача, одинадцять тамбала"),
    (10222, "сто дві квачі, двадцять два тамбала"),
)

TEST_CASES_TO_CURRENCY_MXN = (
    (0.00, "нуль песо, нуль сентаво"),
    (1.00, "один песо, нуль сентаво"),
    (2.00, "два песо, нуль сентаво"),
    (5.00, "п'ять песо, нуль сентаво"),
    (11.00, "одинадцять песо, нуль сентаво"),
    (16.01, "шістнадцять песо, один сентаво"),
    (21.00, "двадцять один песо, нуль сентаво"),
    (37.73, "тридцять сім песо, сімдесят три сентаво"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентаво"),
    (100.00, "сто песо, нуль сентаво"),
    (101.11, "сто один песо, одинадцять сентаво"),
    (10222, "сто два песо, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_MYR = (
    (0.00, "нуль рингітів, нуль центів"),
    (1.00, "один рингіт, нуль центів"),
    (2.00, "два рингіти, нуль центів"),
    (5.00, "п'ять рингітів, нуль центів"),
    (11.00, "одинадцять рингітів, нуль центів"),
    (16.01, "шістнадцять рингітів, один цент"),
    (21.00, "двадцять один рингіт, нуль центів"),
    (37.73, "тридцять сім рингітів, сімдесят три центи"),
    (81.25, "вісімдесят один рингіт, двадцять п'ять центів"),
    (100.00, "сто рингітів, нуль центів"),
    (101.11, "сто один рингіт, одинадцять центів"),
    (10222, "сто два рингіти, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_MZN = (
    (0.00, "нуль метікалів, нуль сентаво"),
    (1.00, "один метікал, нуль сентаво"),
    (2.00, "два метікали, нуль сентаво"),
    (5.00, "п'ять метікалів, нуль сентаво"),
    (11.00, "одинадцять метікалів, нуль сентаво"),
    (16.01, "шістнадцять метікалів, один сентаво"),
    (21.00, "двадцять один метікал, нуль сентаво"),
    (37.73, "тридцять сім метікалів, сімдесят три сентаво"),
    (81.25, "вісімдесят один метікал, двадцять п'ять сентаво"),
    (100.00, "сто метікалів, нуль сентаво"),
    (101.11, "сто один метікал, одинадцять сентаво"),
    (10222, "сто два метікали, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_NAD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_NGN = (
    (0.00, "нуль найр, нуль кобо"),
    (1.00, "одна найра, нуль кобо"),
    (2.00, "дві найри, нуль кобо"),
    (5.00, "п'ять найр, нуль кобо"),
    (11.00, "одинадцять найр, нуль кобо"),
    (16.01, "шістнадцять найр, один кобо"),
    (21.00, "двадцять одна найра, нуль кобо"),
    (37.73, "тридцять сім найр, сімдесят три кобо"),
    (81.25, "вісімдесят одна найра, двадцять п'ять кобо"),
    (100.00, "сто найр, нуль кобо"),
    (101.11, "сто одна найра, одинадцять кобо"),
    (10222, "сто дві найри, двадцять два кобо"),
)

TEST_CASES_TO_CURRENCY_NIO = (
    (0.00, "нуль кордоб, нуль сентаво"),
    (1.00, "одна кордоба, нуль сентаво"),
    (2.00, "дві кордоби, нуль сентаво"),
    (5.00, "п'ять кордоб, нуль сентаво"),
    (11.00, "одинадцять кордоб, нуль сентаво"),
    (16.01, "шістнадцять кордоб, один сентаво"),
    (21.00, "двадцять одна кордоба, нуль сентаво"),
    (37.73, "тридцять сім кордоб, сімдесят три сентаво"),
    (81.25, "вісімдесят одна кордоба, двадцять п'ять сентаво"),
    (100.00, "сто кордоб, нуль сентаво"),
    (101.11, "сто одна кордоба, одинадцять сентаво"),
    (10222, "сто дві кордоби, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_NOK = (
    (0.00, "нуль крон, нуль ере"),
    (1.00, "одна крона, нуль ере"),
    (2.00, "дві крони, нуль ере"),
    (5.00, "п'ять крон, нуль ере"),
    (11.00, "одинадцять крон, нуль ере"),
    (16.01, "шістнадцять крон, один ере"),
    (21.00, "двадцять одна крона, нуль ере"),
    (37.73, "тридцять сім крон, сімдесят три ере"),
    (81.25, "вісімдесят одна крона, двадцять п'ять ере"),
    (100.00, "сто крон, нуль ере"),
    (101.11, "сто одна крона, одинадцять ере"),
    (10222, "сто дві крони, двадцять два ере"),
)

TEST_CASES_TO_CURRENCY_NPR = (
    (0.00, "нуль рупій, нуль пайс"),
    (1.00, "одна рупія, нуль пайс"),
    (2.00, "дві рупії, нуль пайс"),
    (5.00, "п'ять рупій, нуль пайс"),
    (11.00, "одинадцять рупій, нуль пайс"),
    (16.01, "шістнадцять рупій, одна пайса"),
    (21.00, "двадцять одна рупія, нуль пайс"),
    (37.73, "тридцять сім рупій, сімдесят три пайси"),
    (81.25, "вісімдесят одна рупія, двадцять п'ять пайс"),
    (100.00, "сто рупій, нуль пайс"),
    (101.11, "сто одна рупія, одинадцять пайс"),
    (10222, "сто дві рупії, двадцять дві пайси"),
)

TEST_CASES_TO_CURRENCY_NZD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_OMR = (
    (0.00, "нуль ріалів, нуль байз"),
    (1.00, "один ріал, нуль байз"),
    (2.00, "два ріали, нуль байз"),
    (5.00, "п'ять ріалів, нуль байз"),
    (11.00, "одинадцять ріалів, нуль байз"),
    (16.01, "шістнадцять ріалів, одна байза"),
    (21.00, "двадцять один ріал, нуль байз"),
    (37.73, "тридцять сім ріалів, сімдесят три байзи"),
    (81.25, "вісімдесят один ріал, двадцять п'ять байз"),
    (100.00, "сто ріалів, нуль байз"),
    (101.11, "сто один ріал, одинадцять байз"),
    (10222, "сто два ріали, двадцять дві байзи"),
)

TEST_CASES_TO_CURRENCY_PAB = (
    (0.00, "нуль бальбоа, нуль сентесімо"),
    (1.00, "один бальбоа, нуль сентесімо"),
    (2.00, "два бальбоа, нуль сентесімо"),
    (5.00, "п'ять бальбоа, нуль сентесімо"),
    (11.00, "одинадцять бальбоа, нуль сентесімо"),
    (16.01, "шістнадцять бальбоа, один сентесімо"),
    (21.00, "двадцять один бальбоа, нуль сентесімо"),
    (37.73, "тридцять сім бальбоа, сімдесят три сентесімо"),
    (81.25, "вісімдесят один бальбоа, двадцять п'ять сентесімо"),
    (100.00, "сто бальбоа, нуль сентесімо"),
    (101.11, "сто один бальбоа, одинадцять сентесімо"),
    (10222, "сто два бальбоа, двадцять два сентесімо"),
)

TEST_CASES_TO_CURRENCY_PEN = (
    (0.00, "нуль соль, нуль сентімо"),
    (1.00, "один соль, нуль сентімо"),
    (2.00, "два соль, нуль сентімо"),
    (5.00, "п'ять соль, нуль сентімо"),
    (11.00, "одинадцять соль, нуль сентімо"),
    (16.01, "шістнадцять соль, один сентімо"),
    (21.00, "двадцять один соль, нуль сентімо"),
    (37.73, "тридцять сім соль, сімдесят три сентімо"),
    (81.25, "вісімдесят один соль, двадцять п'ять сентімо"),
    (100.00, "сто соль, нуль сентімо"),
    (101.11, "сто один соль, одинадцять сентімо"),
    (10222, "сто два соль, двадцять два сентімо"),
)

TEST_CASES_TO_CURRENCY_PGK = (
    (0.00, "нуль кіна, нуль тойя"),
    (1.00, "один кіна, нуль тойя"),
    (2.00, "два кіна, нуль тойя"),
    (5.00, "п'ять кіна, нуль тойя"),
    (11.00, "одинадцять кіна, нуль тойя"),
    (16.01, "шістнадцять кіна, один тойя"),
    (21.00, "двадцять один кіна, нуль тойя"),
    (37.73, "тридцять сім кіна, сімдесят три тойя"),
    (81.25, "вісімдесят один кіна, двадцять п'ять тойя"),
    (100.00, "сто кіна, нуль тойя"),
    (101.11, "сто один кіна, одинадцять тойя"),
    (10222, "сто два кіна, двадцять два тойя"),
)

TEST_CASES_TO_CURRENCY_PHP = (
    (0.00, "нуль песо, нуль сентаво"),
    (1.00, "один песо, нуль сентаво"),
    (2.00, "два песо, нуль сентаво"),
    (5.00, "п'ять песо, нуль сентаво"),
    (11.00, "одинадцять песо, нуль сентаво"),
    (16.01, "шістнадцять песо, один сентаво"),
    (21.00, "двадцять один песо, нуль сентаво"),
    (37.73, "тридцять сім песо, сімдесят три сентаво"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентаво"),
    (100.00, "сто песо, нуль сентаво"),
    (101.11, "сто один песо, одинадцять сентаво"),
    (10222, "сто два песо, двадцять два сентаво"),
)

TEST_CASES_TO_CURRENCY_PKR = (
    (0.00, "нуль рупій, нуль пайс"),
    (1.00, "одна рупія, нуль пайс"),
    (2.00, "дві рупії, нуль пайс"),
    (5.00, "п'ять рупій, нуль пайс"),
    (11.00, "одинадцять рупій, нуль пайс"),
    (16.01, "шістнадцять рупій, одна пайса"),
    (21.00, "двадцять одна рупія, нуль пайс"),
    (37.73, "тридцять сім рупій, сімдесят три пайси"),
    (81.25, "вісімдесят одна рупія, двадцять п'ять пайс"),
    (100.00, "сто рупій, нуль пайс"),
    (101.11, "сто одна рупія, одинадцять пайс"),
    (10222, "сто дві рупії, двадцять дві пайси"),
)

TEST_CASES_TO_CURRENCY_PLN = (
    (0.00, "нуль злотих, нуль грошів"),
    (1.00, "один злотий, нуль грошів"),
    (2.00, "два злоті, нуль грошів"),
    (5.00, "п'ять злотих, нуль грошів"),
    (11.00, "одинадцять злотих, нуль грошів"),
    (16.01, "шістнадцять злотих, один грош"),
    (21.00, "двадцять один злотий, нуль грошів"),
    (37.73, "тридцять сім злотих, сімдесят три гроші"),
    (81.25, "вісімдесят один злотий, двадцять п'ять грошів"),
    (100.00, "сто злотих, нуль грошів"),
    (101.11, "сто один злотий, одинадцять грошів"),
    (10222, "сто два злоті, двадцять два гроші"),
)

TEST_CASES_TO_CURRENCY_PYG = (
    (0.00, "нуль гуарані, нуль сентімо"),
    (1.00, "один гуарані, нуль сентімо"),
    (2.00, "два гуарані, нуль сентімо"),
    (5.00, "п'ять гуарані, нуль сентімо"),
    (11.00, "одинадцять гуарані, нуль сентімо"),
    (16.01, "шістнадцять гуарані, один сентімо"),
    (21.00, "двадцять один гуарані, нуль сентімо"),
    (37.73, "тридцять сім гуарані, сімдесят три сентімо"),
    (81.25, "вісімдесят один гуарані, двадцять п'ять сентімо"),
    (100.00, "сто гуарані, нуль сентімо"),
    (101.11, "сто один гуарані, одинадцять сентімо"),
    (10222, "сто два гуарані, двадцять два сентімо"),
)

TEST_CASES_TO_CURRENCY_QAR = (
    (0.00, "нуль ріалів, нуль дирхамів"),
    (1.00, "один ріал, нуль дирхамів"),
    (2.00, "два ріали, нуль дирхамів"),
    (5.00, "п'ять ріалів, нуль дирхамів"),
    (11.00, "одинадцять ріалів, нуль дирхамів"),
    (16.01, "шістнадцять ріалів, один дирхам"),
    (21.00, "двадцять один ріал, нуль дирхамів"),
    (37.73, "тридцять сім ріалів, сімдесят три дирхами"),
    (81.25, "вісімдесят один ріал, двадцять п'ять дирхамів"),
    (100.00, "сто ріалів, нуль дирхамів"),
    (101.11, "сто один ріал, одинадцять дирхамів"),
    (10222, "сто два ріали, двадцять два дирхами"),
)

TEST_CASES_TO_CURRENCY_RON = (
    (0.00, "нуль леї, нуль бані"),
    (1.00, "один лей, нуль бані"),
    (2.00, "два леї, нуль бані"),
    (5.00, "п'ять леї, нуль бані"),
    (11.00, "одинадцять леї, нуль бані"),
    (16.01, "шістнадцять леї, один бан"),
    (21.00, "двадцять один лей, нуль бані"),
    (37.73, "тридцять сім леї, сімдесят три бані"),
    (81.25, "вісімдесят один лей, двадцять п'ять бані"),
    (100.00, "сто леї, нуль бані"),
    (101.11, "сто один лей, одинадцять бані"),
    (10222, "сто два леї, двадцять два бані"),
)

TEST_CASES_TO_CURRENCY_RSD = (
    (0.00, "нуль динарів, нуль пар"),
    (1.00, "один динар, нуль пар"),
    (2.00, "два динари, нуль пар"),
    (5.00, "п'ять динарів, нуль пар"),
    (11.00, "одинадцять динарів, нуль пар"),
    (16.01, "шістнадцять динарів, одна пара"),
    (21.00, "двадцять один динар, нуль пар"),
    (37.73, "тридцять сім динарів, сімдесят три пари"),
    (81.25, "вісімдесят один динар, двадцять п'ять пар"),
    (100.00, "сто динарів, нуль пар"),
    (101.11, "сто один динар, одинадцять пар"),
    (10222, "сто два динари, двадцять дві пари"),
)

TEST_CASES_TO_CURRENCY_RUB = (
    (0.00, "нуль рублів, нуль копійок"),
    (1.00, "один рубль, нуль копійок"),
    (2.00, "два рублі, нуль копійок"),
    (5.00, "п'ять рублів, нуль копійок"),
    (11.00, "одинадцять рублів, нуль копійок"),
    (16.01, "шістнадцять рублів, одна копійка"),
    (21.00, "двадцять один рубль, нуль копійок"),
    (37.73, "тридцять сім рублів, сімдесят три копійки"),
    (81.25, "вісімдесят один рубль, двадцять п'ять копійок"),
    (100.00, "сто рублів, нуль копійок"),
    (101.11, "сто один рубль, одинадцять копійок"),
)

TEST_CASES_TO_CURRENCY_RWF = (
    (0.00, "нуль франків, нуль сантимів"),
    (1.00, "один франк, нуль сантимів"),
    (2.00, "два франки, нуль сантимів"),
    (5.00, "п'ять франків, нуль сантимів"),
    (11.00, "одинадцять франків, нуль сантимів"),
    (16.01, "шістнадцять франків, один сантим"),
    (21.00, "двадцять один франк, нуль сантимів"),
    (37.73, "тридцять сім франків, сімдесят три сантими"),
    (81.25, "вісімдесят один франк, двадцять п'ять сантимів"),
    (100.00, "сто франків, нуль сантимів"),
    (101.11, "сто один франк, одинадцять сантимів"),
    (10222, "сто два франки, двадцять два сантими"),
)

TEST_CASES_TO_CURRENCY_SAR = (
    (0.00, "нуль ріалів, нуль халалів"),
    (1.00, "один ріал, нуль халалів"),
    (2.00, "два ріали, нуль халалів"),
    (5.00, "п'ять ріалів, нуль халалів"),
    (11.00, "одинадцять ріалів, нуль халалів"),
    (16.01, "шістнадцять ріалів, один халал"),
    (21.00, "двадцять один ріал, нуль халалів"),
    (37.73, "тридцять сім ріалів, сімдесят три халали"),
    (81.25, "вісімдесят один ріал, двадцять п'ять халалів"),
    (100.00, "сто ріалів, нуль халалів"),
    (101.11, "сто один ріал, одинадцять халалів"),
    (10222, "сто два ріали, двадцять два халали"),
)

TEST_CASES_TO_CURRENCY_SBD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_SCR = (
    (0.00, "нуль рупій, нуль центів"),
    (1.00, "одна рупія, нуль центів"),
    (2.00, "дві рупії, нуль центів"),
    (5.00, "п'ять рупій, нуль центів"),
    (11.00, "одинадцять рупій, нуль центів"),
    (16.01, "шістнадцять рупій, один цент"),
    (21.00, "двадцять одна рупія, нуль центів"),
    (37.73, "тридцять сім рупій, сімдесят три центи"),
    (81.25, "вісімдесят одна рупія, двадцять п'ять центів"),
    (100.00, "сто рупій, нуль центів"),
    (101.11, "сто одна рупія, одинадцять центів"),
    (10222, "сто дві рупії, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_SDG = (
    (0.00, "нуль фунтів, нуль піастрів"),
    (1.00, "один фунт, нуль піастрів"),
    (2.00, "два фунти, нуль піастрів"),
    (5.00, "п'ять фунтів, нуль піастрів"),
    (11.00, "одинадцять фунтів, нуль піастрів"),
    (16.01, "шістнадцять фунтів, один піастр"),
    (21.00, "двадцять один фунт, нуль піастрів"),
    (37.73, "тридцять сім фунтів, сімдесят три піастри"),
    (81.25, "вісімдесят один фунт, двадцять п'ять піастрів"),
    (100.00, "сто фунтів, нуль піастрів"),
    (101.11, "сто один фунт, одинадцять піастрів"),
    (10222, "сто два фунти, двадцять два піастри"),
)

TEST_CASES_TO_CURRENCY_SEK = (
    (0.00, "нуль крон, нуль ере"),
    (1.00, "одна крона, нуль ере"),
    (2.00, "дві крони, нуль ере"),
    (5.00, "п'ять крон, нуль ере"),
    (11.00, "одинадцять крон, нуль ере"),
    (16.01, "шістнадцять крон, один ере"),
    (21.00, "двадцять одна крона, нуль ере"),
    (37.73, "тридцять сім крон, сімдесят три ере"),
    (81.25, "вісімдесят одна крона, двадцять п'ять ере"),
    (100.00, "сто крон, нуль ере"),
    (101.11, "сто одна крона, одинадцять ере"),
    (10222, "сто дві крони, двадцять два ере"),
)

TEST_CASES_TO_CURRENCY_SGD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_SHP = (
    (0.00, "нуль фунтів, нуль пенсів"),
    (1.00, "один фунт, нуль пенсів"),
    (2.00, "два фунти, нуль пенсів"),
    (5.00, "п'ять фунтів, нуль пенсів"),
    (11.00, "одинадцять фунтів, нуль пенсів"),
    (16.01, "шістнадцять фунтів, один пенс"),
    (21.00, "двадцять один фунт, нуль пенсів"),
    (37.73, "тридцять сім фунтів, сімдесят три пенси"),
    (81.25, "вісімдесят один фунт, двадцять п'ять пенсів"),
    (100.00, "сто фунтів, нуль пенсів"),
    (101.11, "сто один фунт, одинадцять пенсів"),
    (10222, "сто два фунти, двадцять два пенси"),
)

TEST_CASES_TO_CURRENCY_SLL = (
    (0.00, "нуль леоне, нуль центів"),
    (1.00, "один леоне, нуль центів"),
    (2.00, "два леоне, нуль центів"),
    (5.00, "п'ять леоне, нуль центів"),
    (11.00, "одинадцять леоне, нуль центів"),
    (16.01, "шістнадцять леоне, один цент"),
    (21.00, "двадцять один леоне, нуль центів"),
    (37.73, "тридцять сім леоне, сімдесят три центи"),
    (81.25, "вісімдесят один леоне, двадцять п'ять центів"),
    (100.00, "сто леоне, нуль центів"),
    (101.11, "сто один леоне, одинадцять центів"),
    (10222, "сто два леоне, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_SOS = (
    (0.00, "нуль шилінгів, нуль центів"),
    (1.00, "один шилінг, нуль центів"),
    (2.00, "два шилінги, нуль центів"),
    (5.00, "п'ять шилінгів, нуль центів"),
    (11.00, "одинадцять шилінгів, нуль центів"),
    (16.01, "шістнадцять шилінгів, один цент"),
    (21.00, "двадцять один шилінг, нуль центів"),
    (37.73, "тридцять сім шилінгів, сімдесят три центи"),
    (81.25, "вісімдесят один шилінг, двадцять п'ять центів"),
    (100.00, "сто шилінгів, нуль центів"),
    (101.11, "сто один шилінг, одинадцять центів"),
    (10222, "сто два шилінги, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_SRD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_SSP = (
    (0.00, "нуль фунтів, нуль піастрів"),
    (1.00, "один фунт, нуль піастрів"),
    (2.00, "два фунти, нуль піастрів"),
    (5.00, "п'ять фунтів, нуль піастрів"),
    (11.00, "одинадцять фунтів, нуль піастрів"),
    (16.01, "шістнадцять фунтів, один піастр"),
    (21.00, "двадцять один фунт, нуль піастрів"),
    (37.73, "тридцять сім фунтів, сімдесят три піастри"),
    (81.25, "вісімдесят один фунт, двадцять п'ять піастрів"),
    (100.00, "сто фунтів, нуль піастрів"),
    (101.11, "сто один фунт, одинадцять піастрів"),
    (10222, "сто два фунти, двадцять два піастри"),
)

TEST_CASES_TO_CURRENCY_STN = (
    (0.00, "нуль добр, нуль сентімо"),
    (1.00, "одна добра, нуль сентімо"),
    (2.00, "дві добри, нуль сентімо"),
    (5.00, "п'ять добр, нуль сентімо"),
    (11.00, "одинадцять добр, нуль сентімо"),
    (16.01, "шістнадцять добр, один сентімо"),
    (21.00, "двадцять одна добра, нуль сентімо"),
    (37.73, "тридцять сім добр, сімдесят три сентімо"),
    (81.25, "вісімдесят одна добра, двадцять п'ять сентімо"),
    (100.00, "сто добр, нуль сентімо"),
    (101.11, "сто одна добра, одинадцять сентімо"),
    (10222, "сто дві добри, двадцять два сентімо"),
)

TEST_CASES_TO_CURRENCY_SYP = (
    (0.00, "нуль фунтів, нуль піастрів"),
    (1.00, "один фунт, нуль піастрів"),
    (2.00, "два фунти, нуль піастрів"),
    (5.00, "п'ять фунтів, нуль піастрів"),
    (11.00, "одинадцять фунтів, нуль піастрів"),
    (16.01, "шістнадцять фунтів, один піастр"),
    (21.00, "двадцять один фунт, нуль піастрів"),
    (37.73, "тридцять сім фунтів, сімдесят три піастри"),
    (81.25, "вісімдесят один фунт, двадцять п'ять піастрів"),
    (100.00, "сто фунтів, нуль піастрів"),
    (101.11, "сто один фунт, одинадцять піастрів"),
    (10222, "сто два фунти, двадцять два піастри"),
)

TEST_CASES_TO_CURRENCY_SZL = (
    (0.00, "нуль ліланґені, нуль центів"),
    (1.00, "один ліланґені, нуль центів"),
    (2.00, "два ліланґені, нуль центів"),
    (5.00, "п'ять ліланґені, нуль центів"),
    (11.00, "одинадцять ліланґені, нуль центів"),
    (16.01, "шістнадцять ліланґені, один цент"),
    (21.00, "двадцять один ліланґені, нуль центів"),
    (37.73, "тридцять сім ліланґені, сімдесят три центи"),
    (81.25, "вісімдесят один ліланґені, двадцять п'ять центів"),
    (100.00, "сто ліланґені, нуль центів"),
    (101.11, "сто один ліланґені, одинадцять центів"),
    (10222, "сто два ліланґені, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_THB = (
    (0.00, "нуль батів, нуль сатангів"),
    (1.00, "один бат, нуль сатангів"),
    (2.00, "два бати, нуль сатангів"),
    (5.00, "п'ять батів, нуль сатангів"),
    (11.00, "одинадцять батів, нуль сатангів"),
    (16.01, "шістнадцять батів, один сатанг"),
    (21.00, "двадцять один бат, нуль сатангів"),
    (37.73, "тридцять сім батів, сімдесят три сатанги"),
    (81.25, "вісімдесят один бат, двадцять п'ять сатангів"),
    (100.00, "сто батів, нуль сатангів"),
    (101.11, "сто один бат, одинадцять сатангів"),
    (10222, "сто два бати, двадцять два сатанги"),
)

TEST_CASES_TO_CURRENCY_TJS = (
    (0.00, "нуль сомоні, нуль дірамів"),
    (1.00, "один сомоні, нуль дірамів"),
    (2.00, "два сомоні, нуль дірамів"),
    (5.00, "п'ять сомоні, нуль дірамів"),
    (11.00, "одинадцять сомоні, нуль дірамів"),
    (16.01, "шістнадцять сомоні, один дірам"),
    (21.00, "двадцять один сомоні, нуль дірамів"),
    (37.73, "тридцять сім сомоні, сімдесят три дірами"),
    (81.25, "вісімдесят один сомоні, двадцять п'ять дірамів"),
    (100.00, "сто сомоні, нуль дірамів"),
    (101.11, "сто один сомоні, одинадцять дірамів"),
    (10222, "сто два сомоні, двадцять два дірами"),
)

TEST_CASES_TO_CURRENCY_TMT = (
    (0.00, "нуль манатів, нуль тенге"),
    (1.00, "один манат, нуль тенге"),
    (2.00, "два манати, нуль тенге"),
    (5.00, "п'ять манатів, нуль тенге"),
    (11.00, "одинадцять манатів, нуль тенге"),
    (16.01, "шістнадцять манатів, один тенге"),
    (21.00, "двадцять один манат, нуль тенге"),
    (37.73, "тридцять сім манатів, сімдесят три тенге"),
    (81.25, "вісімдесят один манат, двадцять п'ять тенге"),
    (100.00, "сто манатів, нуль тенге"),
    (101.11, "сто один манат, одинадцять тенге"),
    (10222, "сто два манати, двадцять два тенге"),
)

TEST_CASES_TO_CURRENCY_TND = (
    (0.00, "нуль динарів, нуль міллімів"),
    (1.00, "один динар, нуль міллімів"),
    (2.00, "два динари, нуль міллімів"),
    (5.00, "п'ять динарів, нуль міллімів"),
    (11.00, "одинадцять динарів, нуль міллімів"),
    (16.01, "шістнадцять динарів, один міллім"),
    (21.00, "двадцять один динар, нуль міллімів"),
    (37.73, "тридцять сім динарів, сімдесят три мілліми"),
    (81.25, "вісімдесят один динар, двадцять п'ять міллімів"),
    (100.00, "сто динарів, нуль міллімів"),
    (101.11, "сто один динар, одинадцять міллімів"),
    (10222, "сто два динари, двадцять два мілліми"),
)

TEST_CASES_TO_CURRENCY_TOP = (
    (0.00, "нуль паанга, нуль сеніті"),
    (1.00, "один паанга, нуль сеніті"),
    (2.00, "два паанга, нуль сеніті"),
    (5.00, "п'ять паанга, нуль сеніті"),
    (11.00, "одинадцять паанга, нуль сеніті"),
    (16.01, "шістнадцять паанга, один сеніті"),
    (21.00, "двадцять один паанга, нуль сеніті"),
    (37.73, "тридцять сім паанга, сімдесят три сеніті"),
    (81.25, "вісімдесят один паанга, двадцять п'ять сеніті"),
    (100.00, "сто паанга, нуль сеніті"),
    (101.11, "сто один паанга, одинадцять сеніті"),
    (10222, "сто два паанга, двадцять два сеніті"),
)

TEST_CASES_TO_CURRENCY_TRY = (
    (0.00, "нуль лір, нуль курушів"),
    (1.00, "одна ліра, нуль курушів"),
    (2.00, "дві ліри, нуль курушів"),
    (5.00, "п'ять лір, нуль курушів"),
    (11.00, "одинадцять лір, нуль курушів"),
    (16.01, "шістнадцять лір, один куруш"),
    (21.00, "двадцять одна ліра, нуль курушів"),
    (37.73, "тридцять сім лір, сімдесят три куруші"),
    (81.25, "вісімдесят одна ліра, двадцять п'ять курушів"),
    (100.00, "сто лір, нуль курушів"),
    (101.11, "сто одна ліра, одинадцять курушів"),
    (10222, "сто дві ліри, двадцять два куруші"),
)

TEST_CASES_TO_CURRENCY_TTD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_TWD = (
    (0.00, "нуль нових доларів, нуль центів"),
    (1.00, "один новий долар, нуль центів"),
    (2.00, "два нові долари, нуль центів"),
    (5.00, "п'ять нових доларів, нуль центів"),
    (11.00, "одинадцять нових доларів, нуль центів"),
    (16.01, "шістнадцять нових доларів, один цент"),
    (21.00, "двадцять один новий долар, нуль центів"),
    (37.73, "тридцять сім нових доларів, сімдесят три центи"),
    (81.25, "вісімдесят один новий долар, двадцять п'ять центів"),
    (100.00, "сто нових доларів, нуль центів"),
    (101.11, "сто один новий долар, одинадцять центів"),
    (10222, "сто два нові долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_TZS = (
    (0.00, "нуль шилінгів, нуль центів"),
    (1.00, "один шилінг, нуль центів"),
    (2.00, "два шилінги, нуль центів"),
    (5.00, "п'ять шилінгів, нуль центів"),
    (11.00, "одинадцять шилінгів, нуль центів"),
    (16.01, "шістнадцять шилінгів, один цент"),
    (21.00, "двадцять один шилінг, нуль центів"),
    (37.73, "тридцять сім шилінгів, сімдесят три центи"),
    (81.25, "вісімдесят один шилінг, двадцять п'ять центів"),
    (100.00, "сто шилінгів, нуль центів"),
    (101.11, "сто один шилінг, одинадцять центів"),
    (10222, "сто два шилінги, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_UAH = (
    (0.00, "нуль гривень, нуль копійок"),
    (1.00, "одна гривня, нуль копійок"),
    (2.00, "дві гривні, нуль копійок"),
    (5.00, "п'ять гривень, нуль копійок"),
    (11.00, "одинадцять гривень, нуль копійок"),
    (16.01, "шістнадцять гривень, одна копійка"),
    (21.00, "двадцять одна гривня, нуль копійок"),
    (37.73, "тридцять сім гривень, сімдесят три копійки"),
    (81.25, "вісімдесят одна гривня, двадцять п'ять копійок"),
    (100.00, "сто гривень, нуль копійок"),
    (101.11, "сто одна гривня, одинадцять копійок"),
    (10222, "сто дві гривні, двадцять дві копійки"),
)

TEST_CASES_TO_CURRENCY_UGX = (
    (0.00, "нуль шилінгів, нуль центів"),
    (1.00, "один шилінг, нуль центів"),
    (2.00, "два шилінги, нуль центів"),
    (5.00, "п'ять шилінгів, нуль центів"),
    (11.00, "одинадцять шилінгів, нуль центів"),
    (16.01, "шістнадцять шилінгів, один цент"),
    (21.00, "двадцять один шилінг, нуль центів"),
    (37.73, "тридцять сім шилінгів, сімдесят три центи"),
    (81.25, "вісімдесят один шилінг, двадцять п'ять центів"),
    (100.00, "сто шилінгів, нуль центів"),
    (101.11, "сто один шилінг, одинадцять центів"),
    (10222, "сто два шилінги, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_USD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_UYU = (
    (0.00, "нуль песо, нуль сентесімо"),
    (1.00, "один песо, нуль сентесімо"),
    (2.00, "два песо, нуль сентесімо"),
    (5.00, "п'ять песо, нуль сентесімо"),
    (11.00, "одинадцять песо, нуль сентесімо"),
    (16.01, "шістнадцять песо, один сентесімо"),
    (21.00, "двадцять один песо, нуль сентесімо"),
    (37.73, "тридцять сім песо, сімдесят три сентесімо"),
    (81.25, "вісімдесят один песо, двадцять п'ять сентесімо"),
    (100.00, "сто песо, нуль сентесімо"),
    (101.11, "сто один песо, одинадцять сентесімо"),
    (10222, "сто два песо, двадцять два сентесімо"),
)

TEST_CASES_TO_CURRENCY_UZS = (
    (0.00, "нуль сумів, нуль тиїнів"),
    (1.00, "один сум, нуль тиїнів"),
    (2.00, "два суми, нуль тиїнів"),
    (5.00, "п'ять сумів, нуль тиїнів"),
    (11.00, "одинадцять сумів, нуль тиїнів"),
    (16.01, "шістнадцять сумів, один тиїн"),
    (21.00, "двадцять один сум, нуль тиїнів"),
    (37.73, "тридцять сім сумів, сімдесят три тиїни"),
    (81.25, "вісімдесят один сум, двадцять п'ять тиїнів"),
    (100.00, "сто сумів, нуль тиїнів"),
    (101.11, "сто один сум, одинадцять тиїнів"),
    (10222, "сто два суми, двадцять два тиїни"),
)

TEST_CASES_TO_CURRENCY_VND = (
    (0.00, "нуль донгів, нуль су"),
    (1.00, "один донг, нуль су"),
    (2.00, "два донги, нуль су"),
    (5.00, "п'ять донгів, нуль су"),
    (11.00, "одинадцять донгів, нуль су"),
    (16.01, "шістнадцять донгів, один су"),
    (21.00, "двадцять один донг, нуль су"),
    (37.73, "тридцять сім донгів, сімдесят три су"),
    (81.25, "вісімдесят один донг, двадцять п'ять су"),
    (100.00, "сто донгів, нуль су"),
    (101.11, "сто один донг, одинадцять су"),
    (10222, "сто два донги, двадцять два су"),
)

TEST_CASES_TO_CURRENCY_WST = (
    (0.00, "нуль тал, нуль сене"),
    (1.00, "одна тала, нуль сене"),
    (2.00, "дві тали, нуль сене"),
    (5.00, "п'ять тал, нуль сене"),
    (11.00, "одинадцять тал, нуль сене"),
    (16.01, "шістнадцять тал, один сене"),
    (21.00, "двадцять одна тала, нуль сене"),
    (37.73, "тридцять сім тал, сімдесят три сене"),
    (81.25, "вісімдесят одна тала, двадцять п'ять сене"),
    (100.00, "сто тал, нуль сене"),
    (101.11, "сто одна тала, одинадцять сене"),
    (10222, "сто дві тали, двадцять два сене"),
)

TEST_CASES_TO_CURRENCY_XCD = (
    (0.00, "нуль доларів, нуль центів"),
    (1.00, "один долар, нуль центів"),
    (2.00, "два долари, нуль центів"),
    (5.00, "п'ять доларів, нуль центів"),
    (11.00, "одинадцять доларів, нуль центів"),
    (16.01, "шістнадцять доларів, один цент"),
    (21.00, "двадцять один долар, нуль центів"),
    (37.73, "тридцять сім доларів, сімдесят три центи"),
    (81.25, "вісімдесят один долар, двадцять п'ять центів"),
    (100.00, "сто доларів, нуль центів"),
    (101.11, "сто один долар, одинадцять центів"),
    (10222, "сто два долари, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_YER = (
    (0.00, "нуль ріалів, нуль філсів"),
    (1.00, "один ріал, нуль філсів"),
    (2.00, "два ріали, нуль філсів"),
    (5.00, "п'ять ріалів, нуль філсів"),
    (11.00, "одинадцять ріалів, нуль філсів"),
    (16.01, "шістнадцять ріалів, один філс"),
    (21.00, "двадцять один ріал, нуль філсів"),
    (37.73, "тридцять сім ріалів, сімдесят три філси"),
    (81.25, "вісімдесят один ріал, двадцять п'ять філсів"),
    (100.00, "сто ріалів, нуль філсів"),
    (101.11, "сто один ріал, одинадцять філсів"),
    (10222, "сто два ріали, двадцять два філси"),
)

TEST_CASES_TO_CURRENCY_ZAR = (
    (0.00, "нуль рандів, нуль центів"),
    (1.00, "один ранд, нуль центів"),
    (2.00, "два ранди, нуль центів"),
    (5.00, "п'ять рандів, нуль центів"),
    (11.00, "одинадцять рандів, нуль центів"),
    (16.01, "шістнадцять рандів, один цент"),
    (21.00, "двадцять один ранд, нуль центів"),
    (37.73, "тридцять сім рандів, сімдесят три центи"),
    (81.25, "вісімдесят один ранд, двадцять п'ять центів"),
    (100.00, "сто рандів, нуль центів"),
    (101.11, "сто один ранд, одинадцять центів"),
    (10222, "сто два ранди, двадцять два центи"),
)

TEST_CASES_TO_CURRENCY_ZMW = (
    (0.00, "нуль квач, нуль нгве"),
    (1.00, "одна квача, нуль нгве"),
    (2.00, "дві квачі, нуль нгве"),
    (5.00, "п'ять квач, нуль нгве"),
    (11.00, "одинадцять квач, нуль нгве"),
    (16.01, "шістнадцять квач, один нгве"),
    (21.00, "двадцять одна квача, нуль нгве"),
    (37.73, "тридцять сім квач, сімдесят три нгве"),
    (81.25, "вісімдесят одна квача, двадцять п'ять нгве"),
    (100.00, "сто квач, нуль нгве"),
    (101.11, "сто одна квача, одинадцять нгве"),
    (10222, "сто дві квачі, двадцять два нгве"),
)


class Num2WordsUKTest(TestCase):

    def test_to_cardinal(self):
        for test in TEST_CASES_CARDINAL:
            self.assertEqual(num2words(test[0], lang='uk'), test[1])

    def test_to_cardinal_feminine(self):
        for test in TEST_CASES_CARDINAL_FEMININE:
            word = num2words(test[0], lang='uk', gender='feminine')
            self.assertEqual(word, test[1])

    def test_to_cardinal_nominative(self):
        for test in TEST_CASES_CARDINAL:
            word = num2words(test[0], lang='uk', case='nominative')
            self.assertEqual(word, test[1])

    def test_to_cardinal_genitive(self):
        for test in TEST_CASES_CARDINAL_GENITIVE:
            word = num2words(test[0], lang='uk', case='genitive')
            self.assertEqual(word, test[1])

    def test_to_cardinal_dative(self):
        self.maxDiff = None
        for test in TEST_CASES_CARDINAL_DATIVE:
            word = num2words(test[0], lang='uk', case='dative')
            self.assertEqual(word, test[1])

    def test_to_cardinal_accusative(self):
        self.maxDiff = None
        for test in TEST_CASES_CARDINAL_ACCUSATIVE:
            word = num2words(test[0], lang='uk', case='accusative')
            self.assertEqual(word, test[1])

    def test_to_cardinal_instrumental(self):
        self.maxDiff = None
        for test in TEST_CASES_CARDINAL_INSTRUMENTAL:
            word = num2words(test[0], lang='uk', case='instrumental')
            self.assertEqual(word, test[1])

    def test_to_cardinal_locative(self):
        self.maxDiff = None
        for test in TEST_CASES_CARDINAL_LOCATIVE:
            word = num2words(test[0], lang='uk', case='locative')
            self.assertEqual(word, test[1])

    def test_to_ordinal(self):
        for test in TEST_CASES_ORDINAL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='ordinal'),
                test[1]
            )

    def test_to_currency(self):
        for test in TEST_CASES_TO_CURRENCY_AED:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="AED"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_AFN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="AFN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ALL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ALL"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_AMD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="AMD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ANG:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ANG"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_AOA:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="AOA"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ARS:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ARS"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_AUD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="AUD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_AWG:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="AWG"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_AZN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="AZN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BAM:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BAM"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BBD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BBD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BDT:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BDT"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BGN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BGN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BHD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BHD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BIF:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BIF"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BMD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BMD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BND:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BND"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BOB:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BOB"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BRL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BRL"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BSD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BSD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BTN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BTN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BWP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BWP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BYN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BYN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_BZD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="BZD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CAD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CAD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CDF:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CDF"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CHF:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CHF"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CLP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CLP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CNY:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CNY"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_COP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="COP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CRC:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CRC"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CUC:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CUC"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CUP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CUP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CVE:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CVE"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_CZK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="CZK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_DJF:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="DJF"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_DKK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="DKK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_DOP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="DOP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_DZD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="DZD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_EGP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="EGP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ERN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ERN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ETB:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ETB"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_EUR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="EUR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_FJD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="FJD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_FKP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="FKP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_GBP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="GBP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_GEL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="GEL"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_GHS:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="GHS"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_GIP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="GIP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_GMD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="GMD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_GNF:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="GNF"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_GTQ:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="GTQ"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_GYD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="GYD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_HKD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="HKD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_HNL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="HNL"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_HRK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="HRK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_HTG:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="HTG"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_HUF:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="HUF"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_IDR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="IDR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ILS:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ILS"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_INR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="INR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_IQD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="IQD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_IRR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="IRR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ISK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ISK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_JMD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="JMD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_JOD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="JOD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_JPY:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="JPY"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KES:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KES"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KGS:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KGS"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KHR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KHR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KMF:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KMF"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KPW:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KPW"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KRW:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KRW"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KWD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KWD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KYD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KYD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_KZT:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="KZT"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_LAK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="LAK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_LBP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="LBP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_LKR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="LKR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_LRD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="LRD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_LSL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="LSL"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_LYD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="LYD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MAD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MAD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MDL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MDL"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MGA:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MGA"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MKD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MKD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MMK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MMK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MNT:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MNT"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MOP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MOP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MRU:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MRU"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MUR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MUR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MVR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MVR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MWK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MWK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MXN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MXN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MYR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MYR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_MZN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="MZN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_NAD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="NAD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_NGN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="NGN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_NIO:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="NIO"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_NOK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="NOK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_NPR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="NPR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_NZD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="NZD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_OMR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="OMR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_PAB:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="PAB"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_PEN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="PEN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_PGK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="PGK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_PHP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="PHP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_PKR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="PKR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_PLN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="PLN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_PYG:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="PYG"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_QAR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="QAR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_RON:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="RON"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_RSD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="RSD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_RUB:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="RUB"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_RWF:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="RWF"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SAR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SAR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SBD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SBD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SCR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SCR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SDG:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SDG"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SEK:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SEK"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SGD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SGD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SHP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SHP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SLL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SLL"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SOS:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SOS"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SRD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SRD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SSP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SSP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_STN:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="STN"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SYP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SYP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_SZL:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="SZL"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_THB:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="THB"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_TJS:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="TJS"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_TMT:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="TMT"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_TND:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="TND"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_TOP:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="TOP"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_TRY:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="TRY"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_TTD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="TTD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_TWD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="TWD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_TZS:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="TZS"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_UAH:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="UAH"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_UGX:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="UGX"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_USD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="USD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_UYU:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="UYU"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_UZS:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="UZS"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_VND:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="VND"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_WST:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="WST"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_XCD:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="XCD"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_YER:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="YER"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ZAR:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ZAR"),
                test[1]
            )
        for test in TEST_CASES_TO_CURRENCY_ZMW:
            self.assertEqual(
                num2words(test[0], lang='uk', to='currency',
                          currency="ZMW"),
                test[1]
            )
