# Contributing

Contributions are welcome, and they are greatly appreciated! Every little bit helps, and credit will always be given.

There are multiple ways to contribute to this project:

- with **feature requests**: we are always happy to receive feedback and new ideas! If you have any, you can create [new feature requests](https://github.com/mkdocstrings/griffe/issues/new?assignees=pawamoy&labels=feature&projects=&template=feature_request.md&title=feature%3A+) on our issue tracker. Make sure to search issues first, to avoid creating duplicate requests.
- with **bug reports**: only you (the users) can help us find and fix bugs! We greatly appreciate if you can give us a bit of your time to create a proper [bug report](https://github.com/mkdocstrings/griffe/issues/new?assignees=pawamoy&labels=unconfirmed&projects=&template=bug_report.md&title=bug%3A+) on our issue tracker. Same as for feature requests, make sure the bug is not already reported, by searching through issues first.
- with **user support**: watch activity on the [Github repository](https://github.com/mkdocstrings/griffe) and our [Gitter channel](https://app.gitter.im/#/room/#mkdocstrings_griffe:gitter.im){ target="_blank" } to answer issues and discussions created by users. Answering questions from users can take a lot of time off maintenance and new features: helping us with user support means more time for us to work on the project.
- with **documentation**: spotted a mistake in the documentation? Found a paragraph unclear or a section missing? Reporting those already helps a lot, and if you can, sending pull requests is even better.
- with **code**: if you are interested in a feature request, or are experiencing a reported bug, you can contribute a feature or a fix. You can simply drop a comment in the relevant issue, and we will do our best to guide you.

For easy documentation fixes, you can edit a file and send a pull request [directly from the GitHub web interface](https://docs.github.com/en/repositories/working-with-files/managing-files/editing-files#editing-files-in-another-users-repository). For more complex fixes or improvements, please read our contributor guide. The guide will show you how to setup a development environment to run tests or serve the documentation locally.

[:fontawesome-solid-helmet-safety: Contributor guide](guide/contributors.md){ .md-button }