# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CertificateProfileStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the certificate profiles."""

    ACTIVE = "Active"
    """The certificate profile is active."""
    DISABLED = "Disabled"
    """The certificate profile is disabled."""
    SUSPENDED = "Suspended"
    """The certificate profile is suspended."""


class CertificateStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the certificate."""

    ACTIVE = "Active"
    """The certificate is active."""
    EXPIRED = "Expired"
    """The certificate is expired."""
    REVOKED = "Revoked"
    """The certificate is revoked."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class NameUnavailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason that a trusted signing account name could not be used. The Reason element is only
    returned if nameAvailable is false.
    """

    ACCOUNT_NAME_INVALID = "AccountNameInvalid"
    """Account name is invalid"""
    ALREADY_EXISTS = "AlreadyExists"
    """Account name already exists"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProfileType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the certificate."""

    PUBLIC_TRUST = "PublicTrust"
    """Used for signing files which are distributed publicly."""
    PRIVATE_TRUST = "PrivateTrust"
    """Used for signing files which are distributed internally within organization or group boundary."""
    PRIVATE_TRUST_CI_POLICY = "PrivateTrustCIPolicy"
    """Used for signing CI policy files."""
    VBS_ENCLAVE = "VBSEnclave"
    """Used for signing files which are run in secure vbs enclave."""
    PUBLIC_TRUST_TEST = "PublicTrustTest"
    """Used for signing files for testing purpose."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    UPDATING = "Updating"
    """Updating in progress."""
    DELETING = "Deleting"
    """Deletion in progress."""
    ACCEPTED = "Accepted"
    """Resource creation started."""


class RevocationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Revocation status of the certificate."""

    SUCCEEDED = "Succeeded"
    """Certificate revocation succeeded."""
    IN_PROGRESS = "InProgress"
    """Certificate revocation is in progress."""
    FAILED = "Failed"
    """Certificate revocation failed."""


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the sku."""

    BASIC = "Basic"
    """Basic sku."""
    PREMIUM = "Premium"
    """Premium sku."""
