# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import json
import sys
from typing import (
    Any,
    AsyncIterable,
    AsyncIterator,
    Callable,
    Dict,
    IO,
    List,
    Optional,
    Type,
    TypeVar,
    Union,
    cast,
    overload,
)
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...models import _models
from ...models import _enums
from ... import _model_base
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._operations._operations import (
    build_document_translation_cancel_translation_request,
    build_document_translation_get_document_status_request,
    build_document_translation_get_documents_status_request,
    build_document_translation_get_supported_formats_request,
    build_document_translation_get_translation_status_request,
    build_document_translation_get_translations_status_request,
    build_document_translation_start_translation_request,
    build_single_document_translation_document_translate_request,
)
from ..._vendor import prepare_multipart_form_data
from .._vendor import DocumentTranslationClientMixinABC, SingleDocumentTranslationClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DocumentTranslationClientOperationsMixin(DocumentTranslationClientMixinABC):

    async def _start_translation_initial(  # pylint: disable=inconsistent-return-statements
        self, body: Union[_models.StartTranslationDetails, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_document_translation_start_translation_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_start_translation(  # pylint: disable=protected-access
        self, body: _models.StartTranslationDetails, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        # pylint: disable=line-too-long
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document
        Translation service.
        Each request can contain multiple documents and must
        contain a source and destination container for each document.

        The
        prefix and suffix filter (if supplied) are used to filter folders. The prefix
        is applied to the subpath after the container name.

        Glossaries /
        Translation memory can be included in the request and are applied by the
        service when the document is translated.

        If the glossary is
        invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the
        destination, it will be overwritten. The targetUrl for each target language
        must be unique.

        :param body: Required.
        :type body: ~azure.ai.translation.document.models._models.StartTranslationDetails
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "inputs": [
                        {
                            "source": {
                                "sourceUrl": "str",  # Location of the folder /
                                  container or single file with your documents. Required.
                                "filter": {
                                    "prefix": "str",  # Optional. A
                                      case-sensitive prefix string to filter documents in the source
                                      path for translation.  For example, when using a Azure storage
                                      blob Uri, use the prefix to restrict sub folders for translation.
                                    "suffix": "str"  # Optional. A case-sensitive
                                      suffix string to filter documents in the source path for
                                      translation.  This is most often use for file extensions.
                                },
                                "language": "str",  # Optional. Language code If none
                                  is specified, we will perform auto detect on the document.
                                "storageSource": "str"  # Optional. Storage Source.
                                  "AzureBlob"
                            },
                            "targets": [
                                {
                                    "language": "str",  # Target Language.
                                      Required.
                                    "targetUrl": "str",  # Location of the folder
                                      / container with your documents. Required.
                                    "category": "str",  # Optional. Category /
                                      custom system for translation request.
                                    "glossaries": [
                                        {
                                            "format": "str",  # Format.
                                              Required.
                                            "glossaryUrl": "str",  #
                                              Location of the glossary.  We will use the file extension
                                              to extract the formatting if the format parameter is not
                                              supplied.  If the translation language pair is not
                                              present in the glossary, it will not be applied.
                                              Required.
                                            "storageSource": "str",  #
                                              Optional. Storage Source. "AzureBlob"
                                            "version": "str"  # Optional.
                                              Optional Version.  If not specified, default is used.
                                        }
                                    ],
                                    "storageSource": "str"  # Optional. Storage
                                      Source. "AzureBlob"
                                }
                            ],
                            "storageType": "str"  # Optional. Storage type of the input
                              documents source string. Known values are: "Folder" and "File".
                        }
                    ]
                }
        """

    @overload
    async def begin_start_translation(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document
        Translation service.
        Each request can contain multiple documents and must
        contain a source and destination container for each document.

        The
        prefix and suffix filter (if supplied) are used to filter folders. The prefix
        is applied to the subpath after the container name.

        Glossaries /
        Translation memory can be included in the request and are applied by the
        service when the document is translated.

        If the glossary is
        invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the
        destination, it will be overwritten. The targetUrl for each target language
        must be unique.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_start_translation(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document
        Translation service.
        Each request can contain multiple documents and must
        contain a source and destination container for each document.

        The
        prefix and suffix filter (if supplied) are used to filter folders. The prefix
        is applied to the subpath after the container name.

        Glossaries /
        Translation memory can be included in the request and are applied by the
        service when the document is translated.

        If the glossary is
        invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the
        destination, it will be overwritten. The targetUrl for each target language
        must be unique.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_start_translation(
        self, body: Union[_models.StartTranslationDetails, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        # pylint: disable=line-too-long
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document
        Translation service.
        Each request can contain multiple documents and must
        contain a source and destination container for each document.

        The
        prefix and suffix filter (if supplied) are used to filter folders. The prefix
        is applied to the subpath after the container name.

        Glossaries /
        Translation memory can be included in the request and are applied by the
        service when the document is translated.

        If the glossary is
        invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the
        destination, it will be overwritten. The targetUrl for each target language
        must be unique.

        :param body: Is one of the following types: StartTranslationDetails, JSON, IO[bytes] Required.
        :type body: ~azure.ai.translation.document.models._models.StartTranslationDetails or JSON or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "inputs": [
                        {
                            "source": {
                                "sourceUrl": "str",  # Location of the folder /
                                  container or single file with your documents. Required.
                                "filter": {
                                    "prefix": "str",  # Optional. A
                                      case-sensitive prefix string to filter documents in the source
                                      path for translation.  For example, when using a Azure storage
                                      blob Uri, use the prefix to restrict sub folders for translation.
                                    "suffix": "str"  # Optional. A case-sensitive
                                      suffix string to filter documents in the source path for
                                      translation.  This is most often use for file extensions.
                                },
                                "language": "str",  # Optional. Language code If none
                                  is specified, we will perform auto detect on the document.
                                "storageSource": "str"  # Optional. Storage Source.
                                  "AzureBlob"
                            },
                            "targets": [
                                {
                                    "language": "str",  # Target Language.
                                      Required.
                                    "targetUrl": "str",  # Location of the folder
                                      / container with your documents. Required.
                                    "category": "str",  # Optional. Category /
                                      custom system for translation request.
                                    "glossaries": [
                                        {
                                            "format": "str",  # Format.
                                              Required.
                                            "glossaryUrl": "str",  #
                                              Location of the glossary.  We will use the file extension
                                              to extract the formatting if the format parameter is not
                                              supplied.  If the translation language pair is not
                                              present in the glossary, it will not be applied.
                                              Required.
                                            "storageSource": "str",  #
                                              Optional. Storage Source. "AzureBlob"
                                            "version": "str"  # Optional.
                                              Optional Version.  If not specified, default is used.
                                        }
                                    ],
                                    "storageSource": "str"  # Optional. Storage
                                      Source. "AzureBlob"
                                }
                            ],
                            "storageType": "str"  # Optional. Storage type of the input
                              documents source string. Known values are: "Folder" and "File".
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._start_translation_initial(  # type: ignore
                body=body, content_type=content_type, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def get_translations_status(
        self,
        *,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        created_date_time_utc_start: Optional[datetime.datetime] = None,
        created_date_time_utc_end: Optional[datetime.datetime] = None,
        orderby: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.TranslationStatus"]:
        # pylint: disable=line-too-long
        """Returns a list of batch requests submitted and the status for each request.

        Returns a list of batch requests submitted and the status for each
        request.
        This list only contains batch requests submitted by the user (based on
        the resource).

        If the number of requests exceeds our paging limit,
        server-side paging is used. Paginated responses indicate a partial result and
        include a continuation token in the response.
        The absence of a continuation
        token means that no additional pages are available.

        top, skip
        and maxpagesize query parameters can be used to specify a number of results to
        return and an offset for the collection.

        top indicates the total
        number of records the user wants to be returned across all pages.
        skip
        indicates the number of records to skip from the list of batches based on the
        sorting method specified.  By default, we sort by descending start
        time.
        maxpagesize is the maximum items returned in a page.  If more items are
        requested via top (or top is not specified and there are more items to be
        returned), @nextLink will contain the link to the next page.

        orderby query parameter can be used to sort the returned list (ex
        "orderby=createdDateTimeUtc asc" or "orderby=createdDateTimeUtc
        desc").
        The default sorting is descending by createdDateTimeUtc.
        Some query
        parameters can be used to filter the returned list (ex:
        "status=Succeeded,Cancelled") will only return succeeded and cancelled
        operations.
        createdDateTimeUtcStart and createdDateTimeUtcEnd can be used
        combined or separately to specify a range of datetime to filter the returned
        list by.
        The supported filtering query parameters are (status, ids,
        createdDateTimeUtcStart, createdDateTimeUtcEnd).

        The server honors
        the values specified by the client. However, clients must be prepared to handle
        responses that contain a different page size or contain a continuation token.

        When both top and skip are included, the server should first apply
        skip and then top on the collection.
        Note: If the server can't honor top
        and/or skip, the server must return an error to the client informing about it
        instead of just ignoring the query options.
        This reduces the risk of the client
        making assumptions about the data returned.

        :keyword top: top indicates the total number of records the user wants to be returned across
         all pages.

         Clients MAY use top and skip query parameters to
         specify a number of results to return and an offset into the collection.
         When
         both top and skip are given by a client, the server SHOULD first apply skip
         and then top on the collection.

         Note: If the server can't honor
         top and/or skip, the server MUST return an error to the client informing
         about it instead of just ignoring the query options. Default value is None.
        :paramtype top: int
        :keyword skip: skip indicates the number of records to skip from the list of records held by
         the server based on the sorting method specified.  By default, we sort by
         descending start time.

         Clients MAY use top and skip query
         parameters to specify a number of results to return and an offset into the
         collection.
         When both top and skip are given by a client, the server SHOULD
         first apply skip and then top on the collection.

         Note: If the
         server can't honor top and/or skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options. Default value is None.
        :paramtype skip: int
        :keyword ids: Ids to use in filtering. Default value is None.
        :paramtype ids: list[str]
        :keyword statuses: Statuses to use in filtering. Default value is None.
        :paramtype statuses: list[str]
        :keyword created_date_time_utc_start: the start datetime to get items after. Default value is
         None.
        :paramtype created_date_time_utc_start: ~datetime.datetime
        :keyword created_date_time_utc_end: the end datetime to get items before. Default value is
         None.
        :paramtype created_date_time_utc_end: ~datetime.datetime
        :keyword orderby: the sorting query for the collection (ex: 'CreatedDateTimeUtc
         asc','CreatedDateTimeUtc desc'). Default value is None.
        :paramtype orderby: list[str]
        :return: An iterator like instance of TranslationStatus
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.translation.document.models._models.TranslationStatus]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Operation created date time.
                      Required.
                    "id": "str",  # Id of the operation. Required.
                    "lastActionDateTimeUtc": "2020-02-20 00:00:00",  # Date time in which the
                      operation's status has been updated. Required.
                    "status": "str",  # List of possible statuses for job or document. Required.
                      Known values are: "NotStarted", "Running", "Succeeded", "Failed", "Cancelled",
                      "Cancelling", and "ValidationFailed".
                    "summary": {
                        "cancelled": 0,  # Number of cancelled. Required.
                        "failed": 0,  # Failed count. Required.
                        "inProgress": 0,  # Number of in progress. Required.
                        "notYetStarted": 0,  # Count of not yet started. Required.
                        "success": 0,  # Number of Success. Required.
                        "total": 0,  # Total count. Required.
                        "totalCharacterCharged": 0  # Total characters charged by the API.
                          Required.
                    },
                    "error": {
                        "code": "str",  # Enums containing high level error codes. Required.
                          Known values are: "InvalidRequest", "InvalidArgument", "InternalServerError",
                          "ServiceUnavailable", "ResourceNotFound", "Unauthorized", and
                          "RequestRateTooHigh".
                        "message": "str",  # Gets high level error message. Required.
                        "innerError": {
                            "code": "str",  # Gets code error string. Required.
                            "message": "str",  # Gets high level error message. Required.
                            "innerError": ...,
                            "target": "str"  # Optional. Gets the source of the error.
                              For example it would be "documents" or "document id" in case of invalid
                              document.
                        },
                        "target": "str"  # Optional. Gets the source of the error.  For
                          example it would be "documents" or "document id" in case of invalid document.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.TranslationStatus]] = kwargs.pop(  # pylint: disable=protected-access
            "cls", None
        )

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_document_translation_get_translations_status_request(
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    ids=ids,
                    statuses=statuses,
                    created_date_time_utc_start=created_date_time_utc_start,
                    created_date_time_utc_end=created_date_time_utc_end,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TranslationStatus], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_document_status(  # pylint: disable=protected-access
        self, id: str, document_id: str, **kwargs: Any
    ) -> _models.DocumentStatus:
        # pylint: disable=line-too-long
        """Returns the status for a specific document.

        Returns the translation status for a specific document based on the request Id
        and document Id.

        :param id: Format - uuid.  The batch id. Required.
        :type id: str
        :param document_id: Format - uuid.  The document id. Required.
        :type document_id: str
        :return: DocumentStatus. The DocumentStatus is compatible with MutableMapping
        :rtype: ~azure.ai.translation.document.models._models.DocumentStatus
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Operation created date time.
                      Required.
                    "id": "str",  # Document Id. Required.
                    "lastActionDateTimeUtc": "2020-02-20 00:00:00",  # Date time in which the
                      operation's status has been updated. Required.
                    "progress": 0.0,  # Progress of the translation if available. Required.
                    "sourcePath": "str",  # Location of the source document. Required.
                    "status": "str",  # List of possible statuses for job or document. Required.
                      Known values are: "NotStarted", "Running", "Succeeded", "Failed", "Cancelled",
                      "Cancelling", and "ValidationFailed".
                    "to": "str",  # To language. Required.
                    "characterCharged": 0,  # Optional. Character charged by the API.
                    "error": {
                        "code": "str",  # Enums containing high level error codes. Required.
                          Known values are: "InvalidRequest", "InvalidArgument", "InternalServerError",
                          "ServiceUnavailable", "ResourceNotFound", "Unauthorized", and
                          "RequestRateTooHigh".
                        "message": "str",  # Gets high level error message. Required.
                        "innerError": {
                            "code": "str",  # Gets code error string. Required.
                            "message": "str",  # Gets high level error message. Required.
                            "innerError": ...,
                            "target": "str"  # Optional. Gets the source of the error.
                              For example it would be "documents" or "document id" in case of invalid
                              document.
                        },
                        "target": "str"  # Optional. Gets the source of the error.  For
                          example it would be "documents" or "document id" in case of invalid document.
                    },
                    "path": "str"  # Optional. Location of the document or folder.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DocumentStatus] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        _request = build_document_translation_get_document_status_request(
            id=id,
            document_id=document_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models.DocumentStatus, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_translation_status(  # pylint: disable=protected-access
        self, id: str, **kwargs: Any
    ) -> _models.TranslationStatus:
        # pylint: disable=line-too-long
        """Returns the status for a document translation request.

        Returns the status for a document translation request.
        The status includes the
        overall request status, as well as the status for documents that are being
        translated as part of that request.

        :param id: Format - uuid.  The operation id. Required.
        :type id: str
        :return: TranslationStatus. The TranslationStatus is compatible with MutableMapping
        :rtype: ~azure.ai.translation.document.models._models.TranslationStatus
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Operation created date time.
                      Required.
                    "id": "str",  # Id of the operation. Required.
                    "lastActionDateTimeUtc": "2020-02-20 00:00:00",  # Date time in which the
                      operation's status has been updated. Required.
                    "status": "str",  # List of possible statuses for job or document. Required.
                      Known values are: "NotStarted", "Running", "Succeeded", "Failed", "Cancelled",
                      "Cancelling", and "ValidationFailed".
                    "summary": {
                        "cancelled": 0,  # Number of cancelled. Required.
                        "failed": 0,  # Failed count. Required.
                        "inProgress": 0,  # Number of in progress. Required.
                        "notYetStarted": 0,  # Count of not yet started. Required.
                        "success": 0,  # Number of Success. Required.
                        "total": 0,  # Total count. Required.
                        "totalCharacterCharged": 0  # Total characters charged by the API.
                          Required.
                    },
                    "error": {
                        "code": "str",  # Enums containing high level error codes. Required.
                          Known values are: "InvalidRequest", "InvalidArgument", "InternalServerError",
                          "ServiceUnavailable", "ResourceNotFound", "Unauthorized", and
                          "RequestRateTooHigh".
                        "message": "str",  # Gets high level error message. Required.
                        "innerError": {
                            "code": "str",  # Gets code error string. Required.
                            "message": "str",  # Gets high level error message. Required.
                            "innerError": ...,
                            "target": "str"  # Optional. Gets the source of the error.
                              For example it would be "documents" or "document id" in case of invalid
                              document.
                        },
                        "target": "str"  # Optional. Gets the source of the error.  For
                          example it would be "documents" or "document id" in case of invalid document.
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TranslationStatus] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        _request = build_document_translation_get_translation_status_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models.TranslationStatus, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def cancel_translation(  # pylint: disable=protected-access
        self, id: str, **kwargs: Any
    ) -> _models.TranslationStatus:
        # pylint: disable=line-too-long
        """Cancel a currently processing or queued translation.

        Cancel a currently processing or queued translation.
        A translation will not be
        cancelled if it is already completed or failed or cancelling. A bad request
        will be returned.
        All documents that have completed translation will not be
        cancelled and will be charged.
        All pending documents will be cancelled if
        possible.

        :param id: Format - uuid.  The operation-id. Required.
        :type id: str
        :return: TranslationStatus. The TranslationStatus is compatible with MutableMapping
        :rtype: ~azure.ai.translation.document.models._models.TranslationStatus
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Operation created date time.
                      Required.
                    "id": "str",  # Id of the operation. Required.
                    "lastActionDateTimeUtc": "2020-02-20 00:00:00",  # Date time in which the
                      operation's status has been updated. Required.
                    "status": "str",  # List of possible statuses for job or document. Required.
                      Known values are: "NotStarted", "Running", "Succeeded", "Failed", "Cancelled",
                      "Cancelling", and "ValidationFailed".
                    "summary": {
                        "cancelled": 0,  # Number of cancelled. Required.
                        "failed": 0,  # Failed count. Required.
                        "inProgress": 0,  # Number of in progress. Required.
                        "notYetStarted": 0,  # Count of not yet started. Required.
                        "success": 0,  # Number of Success. Required.
                        "total": 0,  # Total count. Required.
                        "totalCharacterCharged": 0  # Total characters charged by the API.
                          Required.
                    },
                    "error": {
                        "code": "str",  # Enums containing high level error codes. Required.
                          Known values are: "InvalidRequest", "InvalidArgument", "InternalServerError",
                          "ServiceUnavailable", "ResourceNotFound", "Unauthorized", and
                          "RequestRateTooHigh".
                        "message": "str",  # Gets high level error message. Required.
                        "innerError": {
                            "code": "str",  # Gets code error string. Required.
                            "message": "str",  # Gets high level error message. Required.
                            "innerError": ...,
                            "target": "str"  # Optional. Gets the source of the error.
                              For example it would be "documents" or "document id" in case of invalid
                              document.
                        },
                        "target": "str"  # Optional. Gets the source of the error.  For
                          example it would be "documents" or "document id" in case of invalid document.
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TranslationStatus] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        _request = build_document_translation_cancel_translation_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models.TranslationStatus, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_documents_status(
        self,
        id: str,
        *,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        created_date_time_utc_start: Optional[datetime.datetime] = None,
        created_date_time_utc_end: Optional[datetime.datetime] = None,
        orderby: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DocumentStatus"]:
        # pylint: disable=line-too-long
        """Returns the status for all documents in a batch document translation request.

        Returns the status for all documents in a batch document translation request.

        If the number of documents in the response exceeds our paging limit,
        server-side paging is used.
        Paginated responses indicate a partial result and
        include a continuation token in the response. The absence of a continuation
        token means that no additional pages are available.

        top, skip
        and maxpagesize query parameters can be used to specify a number of results to
        return and an offset for the collection.

        top indicates the total
        number of records the user wants to be returned across all pages.
        skip
        indicates the number of records to skip from the list of document status held
        by the server based on the sorting method specified.  By default, we sort by
        descending start time.
        maxpagesize is the maximum items returned in a page.
        If more items are requested via top (or top is not specified and there are
        more items to be returned), @nextLink will contain the link to the next page.

        orderby query parameter can be used to sort the returned list (ex
        "orderby=createdDateTimeUtc asc" or "orderby=createdDateTimeUtc
        desc").
        The default sorting is descending by createdDateTimeUtc.
        Some query
        parameters can be used to filter the returned list (ex:
        "status=Succeeded,Cancelled") will only return succeeded and cancelled
        documents.
        createdDateTimeUtcStart and createdDateTimeUtcEnd can be used
        combined or separately to specify a range of datetime to filter the returned
        list by.
        The supported filtering query parameters are (status, ids,
        createdDateTimeUtcStart, createdDateTimeUtcEnd).

        When both top
        and skip are included, the server should first apply skip and then top on
        the collection.
        Note: If the server can't honor top and/or skip, the server
        must return an error to the client informing about it instead of just ignoring
        the query options.
        This reduces the risk of the client making assumptions about
        the data returned.

        :param id: Format - uuid.  The operation id. Required.
        :type id: str
        :keyword top: top indicates the total number of records the user wants to be returned across
         all pages.

         Clients MAY use top and skip query parameters to
         specify a number of results to return and an offset into the collection.
         When
         both top and skip are given by a client, the server SHOULD first apply skip
         and then top on the collection.

         Note: If the server can't honor
         top and/or skip, the server MUST return an error to the client informing
         about it instead of just ignoring the query options. Default value is None.
        :paramtype top: int
        :keyword skip: skip indicates the number of records to skip from the list of records held by
         the server based on the sorting method specified.  By default, we sort by
         descending start time.

         Clients MAY use top and skip query
         parameters to specify a number of results to return and an offset into the
         collection.
         When both top and skip are given by a client, the server SHOULD
         first apply skip and then top on the collection.

         Note: If the
         server can't honor top and/or skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options. Default value is None.
        :paramtype skip: int
        :keyword ids: Ids to use in filtering. Default value is None.
        :paramtype ids: list[str]
        :keyword statuses: Statuses to use in filtering. Default value is None.
        :paramtype statuses: list[str]
        :keyword created_date_time_utc_start: the start datetime to get items after. Default value is
         None.
        :paramtype created_date_time_utc_start: ~datetime.datetime
        :keyword created_date_time_utc_end: the end datetime to get items before. Default value is
         None.
        :paramtype created_date_time_utc_end: ~datetime.datetime
        :keyword orderby: the sorting query for the collection (ex: 'CreatedDateTimeUtc
         asc','CreatedDateTimeUtc desc'). Default value is None.
        :paramtype orderby: list[str]
        :return: An iterator like instance of DocumentStatus
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.ai.translation.document.models._models.DocumentStatus]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Operation created date time.
                      Required.
                    "id": "str",  # Document Id. Required.
                    "lastActionDateTimeUtc": "2020-02-20 00:00:00",  # Date time in which the
                      operation's status has been updated. Required.
                    "progress": 0.0,  # Progress of the translation if available. Required.
                    "sourcePath": "str",  # Location of the source document. Required.
                    "status": "str",  # List of possible statuses for job or document. Required.
                      Known values are: "NotStarted", "Running", "Succeeded", "Failed", "Cancelled",
                      "Cancelling", and "ValidationFailed".
                    "to": "str",  # To language. Required.
                    "characterCharged": 0,  # Optional. Character charged by the API.
                    "error": {
                        "code": "str",  # Enums containing high level error codes. Required.
                          Known values are: "InvalidRequest", "InvalidArgument", "InternalServerError",
                          "ServiceUnavailable", "ResourceNotFound", "Unauthorized", and
                          "RequestRateTooHigh".
                        "message": "str",  # Gets high level error message. Required.
                        "innerError": {
                            "code": "str",  # Gets code error string. Required.
                            "message": "str",  # Gets high level error message. Required.
                            "innerError": ...,
                            "target": "str"  # Optional. Gets the source of the error.
                              For example it would be "documents" or "document id" in case of invalid
                              document.
                        },
                        "target": "str"  # Optional. Gets the source of the error.  For
                          example it would be "documents" or "document id" in case of invalid document.
                    },
                    "path": "str"  # Optional. Location of the document or folder.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.DocumentStatus]] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_document_translation_get_documents_status_request(
                    id=id,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    ids=ids,
                    statuses=statuses,
                    created_date_time_utc_start=created_date_time_utc_start,
                    created_date_time_utc_end=created_date_time_utc_end,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.DocumentStatus], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_supported_formats(  # pylint: disable=protected-access
        self, *, type: Optional[Union[str, _enums.FileFormatType]] = None, **kwargs: Any
    ) -> _models.SupportedFileFormats:
        """Returns a list of supported document formats.

        The list of supported formats supported by the Document Translation
        service.
        The list includes the common file extension, as well as the
        content-type if using the upload API.

        :keyword type: the type of format like document or glossary. Known values are: "document" and
         "glossary". Default value is None.
        :paramtype type: str or ~azure.ai.translation.document.models.FileFormatType
        :return: SupportedFileFormats. The SupportedFileFormats is compatible with MutableMapping
        :rtype: ~azure.ai.translation.document.models._models.SupportedFileFormats
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "value": [
                        {
                            "contentTypes": [
                                "str"  # Supported Content-Types for this format.
                                  Required.
                            ],
                            "fileExtensions": [
                                "str"  # Supported file extension for this format.
                                  Required.
                            ],
                            "format": "str",  # Name of the format. Required.
                            "defaultVersion": "str",  # Optional. Default version if none
                              is specified.
                            "type": "str",  # Optional. Supported Type for this format.
                            "versions": [
                                "str"  # Optional. Supported Version.
                            ]
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SupportedFileFormats] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        _request = build_document_translation_get_supported_formats_request(
            type=type,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models.SupportedFileFormats, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class SingleDocumentTranslationClientOperationsMixin(  # pylint: disable=name-too-long
    SingleDocumentTranslationClientMixinABC
):

    @overload
    async def document_translate(
        self,
        body: _models.DocumentTranslateContent,
        *,
        target_language: str,
        source_language: Optional[str] = None,
        category: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Submit a single document translation request to the Document Translation service.

        Use this API to submit a single translation request to the Document Translation Service.

        :param body: Required.
        :type body: ~azure.ai.translation.document.models.DocumentTranslateContent
        :keyword target_language: Specifies the language of the output document.
         The target language must be one of the supported languages included in the translation scope.
         For example if you want to translate the document in German language, then use
         targetLanguage=de. Required.
        :paramtype target_language: str
        :keyword source_language: Specifies source language of the input document.
         If this parameter isn't specified, automatic language detection is applied to determine the
         source language.
         For example if the source document is written in English, then use sourceLanguage=en. Default
         value is None.
        :paramtype source_language: str
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false. Default value is None.
        :paramtype allow_fallback: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "document": filetype,
                    "glossary": [filetype]
                }
        """

    @overload
    async def document_translate(
        self,
        body: JSON,
        *,
        target_language: str,
        source_language: Optional[str] = None,
        category: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Submit a single document translation request to the Document Translation service.

        Use this API to submit a single translation request to the Document Translation Service.

        :param body: Required.
        :type body: JSON
        :keyword target_language: Specifies the language of the output document.
         The target language must be one of the supported languages included in the translation scope.
         For example if you want to translate the document in German language, then use
         targetLanguage=de. Required.
        :paramtype target_language: str
        :keyword source_language: Specifies source language of the input document.
         If this parameter isn't specified, automatic language detection is applied to determine the
         source language.
         For example if the source document is written in English, then use sourceLanguage=en. Default
         value is None.
        :paramtype source_language: str
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false. Default value is None.
        :paramtype allow_fallback: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def document_translate(
        self,
        body: Union[_models.DocumentTranslateContent, JSON],
        *,
        target_language: str,
        source_language: Optional[str] = None,
        category: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Submit a single document translation request to the Document Translation service.

        Use this API to submit a single translation request to the Document Translation Service.

        :param body: Is either a DocumentTranslateContent type or a JSON type. Required.
        :type body: ~azure.ai.translation.document.models.DocumentTranslateContent or JSON
        :keyword target_language: Specifies the language of the output document.
         The target language must be one of the supported languages included in the translation scope.
         For example if you want to translate the document in German language, then use
         targetLanguage=de. Required.
        :paramtype target_language: str
        :keyword source_language: Specifies source language of the input document.
         If this parameter isn't specified, automatic language detection is applied to determine the
         source language.
         For example if the source document is written in English, then use sourceLanguage=en. Default
         value is None.
        :paramtype source_language: str
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false. Default value is None.
        :paramtype allow_fallback: bool
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "document": filetype,
                    "glossary": [filetype]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _model_base.Model) else body
        _file_fields: List[str] = ["document", "glossary"]
        _data_fields: List[str] = []
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_single_document_translation_document_translate_request(
            target_language=target_language,
            source_language=source_language,
            category=category,
            allow_fallback=allow_fallback,
            api_version=self._config.api_version,
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
