# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ContainerGroupProfile(_serialization.Model):
    """Details of the ContainerGroupProfile.

    All required parameters must be populated in order to send to server.

    :ivar id: Specifies container group profile id of standby container groups. Required.
    :vartype id: str
    :ivar revision: Specifies revision of container group profile.
    :vartype revision: int
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "revision": {"key": "revision", "type": "int"},
    }

    def __init__(
        self, *, id: str, revision: Optional[int] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Specifies container group profile id of standby container groups. Required.
        :paramtype id: str
        :keyword revision: Specifies revision of container group profile.
        :paramtype revision: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.revision = revision


class ContainerGroupProfileUpdate(_serialization.Model):
    """Details of the ContainerGroupProfile.

    :ivar id: Specifies container group profile id of standby container groups.
    :vartype id: str
    :ivar revision: Specifies revision of container group profile.
    :vartype revision: int
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "revision": {"key": "revision", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        revision: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Specifies container group profile id of standby container groups.
        :paramtype id: str
        :keyword revision: Specifies revision of container group profile.
        :paramtype revision: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.revision = revision


class ContainerGroupProperties(_serialization.Model):
    """Details of the ContainerGroupProperties.

    All required parameters must be populated in order to send to server.

    :ivar container_group_profile: Specifies container group profile of standby container groups.
     Required.
    :vartype container_group_profile: ~azure.mgmt.standbypool.models.ContainerGroupProfile
    :ivar subnet_ids: Specifies subnet Ids for container group.
    :vartype subnet_ids: list[~azure.mgmt.standbypool.models.Subnet]
    """

    _validation = {
        "container_group_profile": {"required": True},
    }

    _attribute_map = {
        "container_group_profile": {"key": "containerGroupProfile", "type": "ContainerGroupProfile"},
        "subnet_ids": {"key": "subnetIds", "type": "[Subnet]"},
    }

    def __init__(
        self,
        *,
        container_group_profile: "_models.ContainerGroupProfile",
        subnet_ids: Optional[List["_models.Subnet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_group_profile: Specifies container group profile of standby container
         groups. Required.
        :paramtype container_group_profile: ~azure.mgmt.standbypool.models.ContainerGroupProfile
        :keyword subnet_ids: Specifies subnet Ids for container group.
        :paramtype subnet_ids: list[~azure.mgmt.standbypool.models.Subnet]
        """
        super().__init__(**kwargs)
        self.container_group_profile = container_group_profile
        self.subnet_ids = subnet_ids


class ContainerGroupPropertiesUpdate(_serialization.Model):
    """Details of the ContainerGroupProperties.

    :ivar container_group_profile: Specifies container group profile of standby container groups.
    :vartype container_group_profile: ~azure.mgmt.standbypool.models.ContainerGroupProfileUpdate
    :ivar subnet_ids: Specifies subnet Ids for container group.
    :vartype subnet_ids: list[~azure.mgmt.standbypool.models.Subnet]
    """

    _attribute_map = {
        "container_group_profile": {"key": "containerGroupProfile", "type": "ContainerGroupProfileUpdate"},
        "subnet_ids": {"key": "subnetIds", "type": "[Subnet]"},
    }

    def __init__(
        self,
        *,
        container_group_profile: Optional["_models.ContainerGroupProfileUpdate"] = None,
        subnet_ids: Optional[List["_models.Subnet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_group_profile: Specifies container group profile of standby container
         groups.
        :paramtype container_group_profile: ~azure.mgmt.standbypool.models.ContainerGroupProfileUpdate
        :keyword subnet_ids: Specifies subnet Ids for container group.
        :paramtype subnet_ids: list[~azure.mgmt.standbypool.models.Subnet]
        """
        super().__init__(**kwargs)
        self.container_group_profile = container_group_profile
        self.subnet_ids = subnet_ids


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.standbypool.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.standbypool.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.standbypool.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.standbypool.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.standbypool.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.standbypool.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.standbypool.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.standbypool.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.standbypool.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    """


class StandbyContainerGroupPoolElasticityProfile(_serialization.Model):  # pylint: disable=name-too-long
    """Specifies the elasticity profile of the standby container group pools.

    All required parameters must be populated in order to send to server.

    :ivar max_ready_capacity: Specifies maximum number of standby container groups in the standby
     pool. Required.
    :vartype max_ready_capacity: int
    :ivar refill_policy: Specifies refill policy of the pool. "always"
    :vartype refill_policy: str or ~azure.mgmt.standbypool.models.RefillPolicy
    """

    _validation = {
        "max_ready_capacity": {"required": True, "maximum": 2000, "minimum": 0},
    }

    _attribute_map = {
        "max_ready_capacity": {"key": "maxReadyCapacity", "type": "int"},
        "refill_policy": {"key": "refillPolicy", "type": "str"},
    }

    def __init__(
        self,
        *,
        max_ready_capacity: int,
        refill_policy: Optional[Union[str, "_models.RefillPolicy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_ready_capacity: Specifies maximum number of standby container groups in the
         standby pool. Required.
        :paramtype max_ready_capacity: int
        :keyword refill_policy: Specifies refill policy of the pool. "always"
        :paramtype refill_policy: str or ~azure.mgmt.standbypool.models.RefillPolicy
        """
        super().__init__(**kwargs)
        self.max_ready_capacity = max_ready_capacity
        self.refill_policy = refill_policy


class StandbyContainerGroupPoolElasticityProfileUpdate(_serialization.Model):  # pylint: disable=name-too-long
    """Specifies the elasticity profile of the standby container group pools.

    :ivar max_ready_capacity: Specifies maximum number of standby container groups in the standby
     pool.
    :vartype max_ready_capacity: int
    :ivar refill_policy: Specifies refill policy of the pool. "always"
    :vartype refill_policy: str or ~azure.mgmt.standbypool.models.RefillPolicy
    """

    _validation = {
        "max_ready_capacity": {"maximum": 2000, "minimum": 0},
    }

    _attribute_map = {
        "max_ready_capacity": {"key": "maxReadyCapacity", "type": "int"},
        "refill_policy": {"key": "refillPolicy", "type": "str"},
    }

    def __init__(
        self,
        *,
        max_ready_capacity: Optional[int] = None,
        refill_policy: Optional[Union[str, "_models.RefillPolicy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_ready_capacity: Specifies maximum number of standby container groups in the
         standby pool.
        :paramtype max_ready_capacity: int
        :keyword refill_policy: Specifies refill policy of the pool. "always"
        :paramtype refill_policy: str or ~azure.mgmt.standbypool.models.RefillPolicy
        """
        super().__init__(**kwargs)
        self.max_ready_capacity = max_ready_capacity
        self.refill_policy = refill_policy


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class StandbyContainerGroupPoolResource(TrackedResource):
    """A StandbyContainerGroupPoolResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "StandbyContainerGroupPoolResourceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyContainerGroupPoolResourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties:
         ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResourceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class StandbyContainerGroupPoolResourceListResult(_serialization.Model):  # pylint: disable=name-too-long
    """The response of a StandbyContainerGroupPoolResource list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: The StandbyContainerGroupPoolResource items on this page. Required.
    :vartype value: list[~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StandbyContainerGroupPoolResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.StandbyContainerGroupPoolResource"], **kwargs: Any) -> None:
        """
        :keyword value: The StandbyContainerGroupPoolResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class StandbyContainerGroupPoolResourceProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Details of the StandbyContainerGroupPool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar elasticity_profile: Specifies elasticity profile of standby container group pools.
     Required.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolElasticityProfile
    :ivar container_group_properties: Specifies container group properties of standby container
     group pools. Required.
    :vartype container_group_properties: ~azure.mgmt.standbypool.models.ContainerGroupProperties
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    _validation = {
        "elasticity_profile": {"required": True},
        "container_group_properties": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "elasticity_profile": {"key": "elasticityProfile", "type": "StandbyContainerGroupPoolElasticityProfile"},
        "container_group_properties": {"key": "containerGroupProperties", "type": "ContainerGroupProperties"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        elasticity_profile: "_models.StandbyContainerGroupPoolElasticityProfile",
        container_group_properties: "_models.ContainerGroupProperties",
        **kwargs: Any
    ) -> None:
        """
        :keyword elasticity_profile: Specifies elasticity profile of standby container group pools.
         Required.
        :paramtype elasticity_profile:
         ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolElasticityProfile
        :keyword container_group_properties: Specifies container group properties of standby container
         group pools. Required.
        :paramtype container_group_properties: ~azure.mgmt.standbypool.models.ContainerGroupProperties
        """
        super().__init__(**kwargs)
        self.elasticity_profile = elasticity_profile
        self.container_group_properties = container_group_properties
        self.provisioning_state = None


class StandbyContainerGroupPoolResourceUpdate(_serialization.Model):
    """The type used for update operations of the StandbyContainerGroupPoolResource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the StandbyContainerGroupPoolResource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResourceUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "StandbyContainerGroupPoolResourceUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyContainerGroupPoolResourceUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the StandbyContainerGroupPoolResource.
        :paramtype properties:
         ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResourceUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class StandbyContainerGroupPoolResourceUpdateProperties(_serialization.Model):  # pylint: disable=name-too-long
    """The updatable properties of the StandbyContainerGroupPoolResource.

    :ivar elasticity_profile: Specifies elasticity profile of standby container group pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolElasticityProfileUpdate
    :ivar container_group_properties: Specifies container group properties of standby container
     group pools.
    :vartype container_group_properties:
     ~azure.mgmt.standbypool.models.ContainerGroupPropertiesUpdate
    """

    _attribute_map = {
        "elasticity_profile": {"key": "elasticityProfile", "type": "StandbyContainerGroupPoolElasticityProfileUpdate"},
        "container_group_properties": {"key": "containerGroupProperties", "type": "ContainerGroupPropertiesUpdate"},
    }

    def __init__(
        self,
        *,
        elasticity_profile: Optional["_models.StandbyContainerGroupPoolElasticityProfileUpdate"] = None,
        container_group_properties: Optional["_models.ContainerGroupPropertiesUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword elasticity_profile: Specifies elasticity profile of standby container group pools.
        :paramtype elasticity_profile:
         ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolElasticityProfileUpdate
        :keyword container_group_properties: Specifies container group properties of standby container
         group pools.
        :paramtype container_group_properties:
         ~azure.mgmt.standbypool.models.ContainerGroupPropertiesUpdate
        """
        super().__init__(**kwargs)
        self.elasticity_profile = elasticity_profile
        self.container_group_properties = container_group_properties


class StandbyVirtualMachinePoolElasticityProfile(_serialization.Model):  # pylint: disable=name-too-long
    """Details of the elasticity profile.

    All required parameters must be populated in order to send to server.

    :ivar max_ready_capacity: Specifies the maximum number of virtual machines in the standby
     virtual machine pool. Required.
    :vartype max_ready_capacity: int
    """

    _validation = {
        "max_ready_capacity": {"required": True, "maximum": 2000, "minimum": 0},
    }

    _attribute_map = {
        "max_ready_capacity": {"key": "maxReadyCapacity", "type": "int"},
    }

    def __init__(self, *, max_ready_capacity: int, **kwargs: Any) -> None:
        """
        :keyword max_ready_capacity: Specifies the maximum number of virtual machines in the standby
         virtual machine pool. Required.
        :paramtype max_ready_capacity: int
        """
        super().__init__(**kwargs)
        self.max_ready_capacity = max_ready_capacity


class StandbyVirtualMachinePoolElasticityProfileUpdate(_serialization.Model):  # pylint: disable=name-too-long
    """Details of the elasticity profile.

    :ivar max_ready_capacity: Specifies the maximum number of virtual machines in the standby
     virtual machine pool.
    :vartype max_ready_capacity: int
    """

    _validation = {
        "max_ready_capacity": {"maximum": 2000, "minimum": 0},
    }

    _attribute_map = {
        "max_ready_capacity": {"key": "maxReadyCapacity", "type": "int"},
    }

    def __init__(self, *, max_ready_capacity: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword max_ready_capacity: Specifies the maximum number of virtual machines in the standby
         virtual machine pool.
        :paramtype max_ready_capacity: int
        """
        super().__init__(**kwargs)
        self.max_ready_capacity = max_ready_capacity


class StandbyVirtualMachinePoolResource(TrackedResource):
    """A StandbyVirtualMachinePoolResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "StandbyVirtualMachinePoolResourceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyVirtualMachinePoolResourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties:
         ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResourceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class StandbyVirtualMachinePoolResourceListResult(_serialization.Model):  # pylint: disable=name-too-long
    """The response of a StandbyVirtualMachinePoolResource list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: The StandbyVirtualMachinePoolResource items on this page. Required.
    :vartype value: list[~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StandbyVirtualMachinePoolResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.StandbyVirtualMachinePoolResource"], **kwargs: Any) -> None:
        """
        :keyword value: The StandbyVirtualMachinePoolResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class StandbyVirtualMachinePoolResourceProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Details of the StandbyVirtualMachinePool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar elasticity_profile: Specifies the elasticity profile of the standby virtual machine
     pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolElasticityProfile
    :ivar virtual_machine_state: Specifies the desired state of virtual machines in the pool.
     Required. Known values are: "Running" and "Deallocated".
    :vartype virtual_machine_state: str or ~azure.mgmt.standbypool.models.VirtualMachineState
    :ivar attached_virtual_machine_scale_set_id: Specifies the fully qualified resource ID of a
     virtual machine scale set the pool is attached to.
    :vartype attached_virtual_machine_scale_set_id: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    _validation = {
        "virtual_machine_state": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "elasticity_profile": {"key": "elasticityProfile", "type": "StandbyVirtualMachinePoolElasticityProfile"},
        "virtual_machine_state": {"key": "virtualMachineState", "type": "str"},
        "attached_virtual_machine_scale_set_id": {"key": "attachedVirtualMachineScaleSetId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machine_state: Union[str, "_models.VirtualMachineState"],
        elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = None,
        attached_virtual_machine_scale_set_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword elasticity_profile: Specifies the elasticity profile of the standby virtual machine
         pools.
        :paramtype elasticity_profile:
         ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolElasticityProfile
        :keyword virtual_machine_state: Specifies the desired state of virtual machines in the pool.
         Required. Known values are: "Running" and "Deallocated".
        :paramtype virtual_machine_state: str or ~azure.mgmt.standbypool.models.VirtualMachineState
        :keyword attached_virtual_machine_scale_set_id: Specifies the fully qualified resource ID of a
         virtual machine scale set the pool is attached to.
        :paramtype attached_virtual_machine_scale_set_id: str
        """
        super().__init__(**kwargs)
        self.elasticity_profile = elasticity_profile
        self.virtual_machine_state = virtual_machine_state
        self.attached_virtual_machine_scale_set_id = attached_virtual_machine_scale_set_id
        self.provisioning_state = None


class StandbyVirtualMachinePoolResourceUpdate(_serialization.Model):
    """The type used for update operations of the StandbyVirtualMachinePoolResource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the StandbyVirtualMachinePoolResource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResourceUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "StandbyVirtualMachinePoolResourceUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyVirtualMachinePoolResourceUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the StandbyVirtualMachinePoolResource.
        :paramtype properties:
         ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResourceUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class StandbyVirtualMachinePoolResourceUpdateProperties(_serialization.Model):  # pylint: disable=name-too-long
    """The updatable properties of the StandbyVirtualMachinePoolResource.

    :ivar elasticity_profile: Specifies the elasticity profile of the standby virtual machine
     pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolElasticityProfileUpdate
    :ivar virtual_machine_state: Specifies the desired state of virtual machines in the pool. Known
     values are: "Running" and "Deallocated".
    :vartype virtual_machine_state: str or ~azure.mgmt.standbypool.models.VirtualMachineState
    :ivar attached_virtual_machine_scale_set_id: Specifies the fully qualified resource ID of a
     virtual machine scale set the pool is attached to.
    :vartype attached_virtual_machine_scale_set_id: str
    """

    _attribute_map = {
        "elasticity_profile": {"key": "elasticityProfile", "type": "StandbyVirtualMachinePoolElasticityProfileUpdate"},
        "virtual_machine_state": {"key": "virtualMachineState", "type": "str"},
        "attached_virtual_machine_scale_set_id": {"key": "attachedVirtualMachineScaleSetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfileUpdate"] = None,
        virtual_machine_state: Optional[Union[str, "_models.VirtualMachineState"]] = None,
        attached_virtual_machine_scale_set_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword elasticity_profile: Specifies the elasticity profile of the standby virtual machine
         pools.
        :paramtype elasticity_profile:
         ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolElasticityProfileUpdate
        :keyword virtual_machine_state: Specifies the desired state of virtual machines in the pool.
         Known values are: "Running" and "Deallocated".
        :paramtype virtual_machine_state: str or ~azure.mgmt.standbypool.models.VirtualMachineState
        :keyword attached_virtual_machine_scale_set_id: Specifies the fully qualified resource ID of a
         virtual machine scale set the pool is attached to.
        :paramtype attached_virtual_machine_scale_set_id: str
        """
        super().__init__(**kwargs)
        self.elasticity_profile = elasticity_profile
        self.virtual_machine_state = virtual_machine_state
        self.attached_virtual_machine_scale_set_id = attached_virtual_machine_scale_set_id


class StandbyVirtualMachineResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyVirtualMachineResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "StandbyVirtualMachineResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.StandbyVirtualMachineResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.standbypool.models.StandbyVirtualMachineResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class StandbyVirtualMachineResourceListResult(_serialization.Model):
    """The response of a StandbyVirtualMachineResource list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: The StandbyVirtualMachineResource items on this page. Required.
    :vartype value: list[~azure.mgmt.standbypool.models.StandbyVirtualMachineResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StandbyVirtualMachineResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.StandbyVirtualMachineResource"], **kwargs: Any) -> None:
        """
        :keyword value: The StandbyVirtualMachineResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.standbypool.models.StandbyVirtualMachineResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class StandbyVirtualMachineResourceProperties(_serialization.Model):
    """Details of the StandbyVirtualMachine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar virtual_machine_resource_id: Resource id of the virtual machine. Required.
    :vartype virtual_machine_resource_id: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    _validation = {
        "virtual_machine_resource_id": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "virtual_machine_resource_id": {"key": "virtualMachineResourceId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, virtual_machine_resource_id: str, **kwargs: Any) -> None:
        """
        :keyword virtual_machine_resource_id: Resource id of the virtual machine. Required.
        :paramtype virtual_machine_resource_id: str
        """
        super().__init__(**kwargs)
        self.virtual_machine_resource_id = virtual_machine_resource_id
        self.provisioning_state = None


class Subnet(_serialization.Model):
    """Subnet of container group.

    All required parameters must be populated in order to send to server.

    :ivar id: Specifies ARM resource id of the subnet. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Specifies ARM resource id of the subnet. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.standbypool.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.standbypool.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.standbypool.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.standbypool.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
