# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field
from .._vendor import FileType

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AtlasAttributeDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """class that captures details of a struct-attribute.

    :ivar cardinality: single-valued attribute or multi-valued attribute. Known values are:
     "SINGLE", "LIST", and "SET".
    :vartype cardinality: str or ~azure.purview.datamap.models.CardinalityValue
    :ivar constraints: An array of constraints.
    :vartype constraints: list[~azure.purview.datamap.models.AtlasConstraintDef]
    :ivar default_value: The default value of the attribute.
    :vartype default_value: str
    :ivar description: The description of the attribute.
    :vartype description: str
    :ivar include_in_notification: Determines if it is included in notification.
    :vartype include_in_notification: bool
    :ivar is_indexable: Determines if it is indexable.
    :vartype is_indexable: bool
    :ivar is_optional: Determines if it is optional.
    :vartype is_optional: bool
    :ivar is_unique: Determines if it unique.
    :vartype is_unique: bool
    :ivar name: The name of the attribute.
    :vartype name: str
    :ivar options: The options for the attribute.
    :vartype options: dict[str, str]
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar values_max_count: The maximum count of the values.
    :vartype values_max_count: int
    :ivar values_min_count: The minimum count of the values.
    :vartype values_min_count: int
    """

    cardinality: Optional[Union[str, "_models.CardinalityValue"]] = rest_field()
    """single-valued attribute or multi-valued attribute. Known values are: \"SINGLE\", \"LIST\", and
     \"SET\"."""
    constraints: Optional[List["_models.AtlasConstraintDef"]] = rest_field()
    """An array of constraints."""
    default_value: Optional[str] = rest_field(name="defaultValue")
    """The default value of the attribute."""
    description: Optional[str] = rest_field()
    """The description of the attribute."""
    include_in_notification: Optional[bool] = rest_field(name="includeInNotification")
    """Determines if it is included in notification."""
    is_indexable: Optional[bool] = rest_field(name="isIndexable")
    """Determines if it is indexable."""
    is_optional: Optional[bool] = rest_field(name="isOptional")
    """Determines if it is optional."""
    is_unique: Optional[bool] = rest_field(name="isUnique")
    """Determines if it unique."""
    name: Optional[str] = rest_field()
    """The name of the attribute."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the attribute."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    values_max_count: Optional[int] = rest_field(name="valuesMaxCount")
    """The maximum count of the values."""
    values_min_count: Optional[int] = rest_field(name="valuesMinCount")
    """The minimum count of the values."""

    @overload
    def __init__(
        self,
        *,
        cardinality: Optional[Union[str, "_models.CardinalityValue"]] = None,
        constraints: Optional[List["_models.AtlasConstraintDef"]] = None,
        default_value: Optional[str] = None,
        description: Optional[str] = None,
        include_in_notification: Optional[bool] = None,
        is_indexable: Optional[bool] = None,
        is_optional: Optional[bool] = None,
        is_unique: Optional[bool] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        type_name: Optional[str] = None,
        values_max_count: Optional[int] = None,
        values_min_count: Optional[int] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasBusinessMetadataDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """class that captures details of a struct-type.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar date_formatter: The date format.
    :vartype date_formatter: ~azure.purview.datamap.models.DateFormat
    :ivar description: The description of the type definition.
    :vartype description: str
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    :ivar options: The options for the type definition.
    :vartype options: dict[str, str]
    :ivar service_type: The service type.
    :vartype service_type: str
    :ivar type_version: The version of the type.
    :vartype type_version: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the record.
    :vartype version: int
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar attribute_defs: An array of attribute definitions.
    :vartype attribute_defs: list[~azure.purview.datamap.models.AtlasAttributeDef]
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    date_formatter: Optional["_models.DateFormat"] = rest_field(name="dateFormatter")
    """The date format."""
    description: Optional[str] = rest_field()
    """The description of the type definition."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the type definition."""
    service_type: Optional[str] = rest_field(name="serviceType")
    """The service type."""
    type_version: Optional[str] = rest_field(name="typeVersion")
    """The version of the type."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the record."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = rest_field(name="attributeDefs")
    """An array of attribute definitions."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        date_formatter: Optional["_models.DateFormat"] = None,
        description: Optional[str] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        service_type: Optional[str] = None,
        type_version: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        last_modified_t_s: Optional[str] = None,
        attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasClassification(_model_base.Model):
    """An instance of a classification; it doesn't have an identity, this object
    exists only when associated with an entity.

    :ivar attributes: The attributes of the struct.
    :vartype attributes: dict[str, any]
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar entity_guid: The GUID of the entity.
    :vartype entity_guid: str
    :ivar entity_status: Status of the entity - can be active or deleted. Deleted entities are not
     removed. Known values are: "ACTIVE" and "DELETED".
    :vartype entity_status: str or ~azure.purview.datamap.models.EntityStatus
    :ivar remove_propagations_on_entity_delete: Determines if propagations will be removed on
     entity deletion.
    :vartype remove_propagations_on_entity_delete: bool
    :ivar validity_periods: An array of time boundaries indicating validity periods.
    :vartype validity_periods: list[~azure.purview.datamap.models.TimeBoundary]
    """

    attributes: Optional[Dict[str, Any]] = rest_field()
    """The attributes of the struct."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    entity_guid: Optional[str] = rest_field(name="entityGuid")
    """The GUID of the entity."""
    entity_status: Optional[Union[str, "_models.EntityStatus"]] = rest_field(name="entityStatus")
    """Status of the entity - can be active or deleted. Deleted entities are not
     removed. Known values are: \"ACTIVE\" and \"DELETED\"."""
    remove_propagations_on_entity_delete: Optional[bool] = rest_field(name="removePropagationsOnEntityDelete")
    """Determines if propagations will be removed on entity deletion."""
    validity_periods: Optional[List["_models.TimeBoundary"]] = rest_field(name="validityPeriods")
    """An array of time boundaries indicating validity periods."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional[Dict[str, Any]] = None,
        type_name: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
        entity_guid: Optional[str] = None,
        entity_status: Optional[Union[str, "_models.EntityStatus"]] = None,
        remove_propagations_on_entity_delete: Optional[bool] = None,
        validity_periods: Optional[List["_models.TimeBoundary"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasClassificationDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """class that captures details of a classification-type.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar date_formatter: The date format.
    :vartype date_formatter: ~azure.purview.datamap.models.DateFormat
    :ivar description: The description of the type definition.
    :vartype description: str
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    :ivar options: The options for the type definition.
    :vartype options: dict[str, str]
    :ivar service_type: The service type.
    :vartype service_type: str
    :ivar type_version: The version of the type.
    :vartype type_version: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the record.
    :vartype version: int
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar attribute_defs: An array of attribute definitions.
    :vartype attribute_defs: list[~azure.purview.datamap.models.AtlasAttributeDef]
    :ivar entity_types: Specifying a list of entityType names in the classificationDef, ensures
     that
     classifications can
     only be applied to those entityTypes.

     Any subtypes of the entity types inherit the restriction.

     Any classificationDef subtypes inherit the parents entityTypes restrictions.

     Any classificationDef subtypes can further restrict the parents entityTypes
     restrictions by specifying a subset of the entityTypes.

     An empty entityTypes list when there are no parent restrictions means there are no
     restrictions.

     An empty entityTypes list when there are parent
     restrictions means that the subtype picks up the parents
     restrictions.

     If a list of entityTypes are supplied, where one inherits
     from another, this will be rejected. This should encourage cleaner
     classificationsDefs.
    :vartype entity_types: list[str]
    :ivar sub_types: An array of sub types.
    :vartype sub_types: list[str]
    :ivar super_types: An array of super types.
    :vartype super_types: list[str]
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    date_formatter: Optional["_models.DateFormat"] = rest_field(name="dateFormatter")
    """The date format."""
    description: Optional[str] = rest_field()
    """The description of the type definition."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the type definition."""
    service_type: Optional[str] = rest_field(name="serviceType")
    """The service type."""
    type_version: Optional[str] = rest_field(name="typeVersion")
    """The version of the type."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the record."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = rest_field(name="attributeDefs")
    """An array of attribute definitions."""
    entity_types: Optional[List[str]] = rest_field(name="entityTypes")
    """Specifying a list of entityType names in the classificationDef, ensures that
     classifications can
     only be applied to those entityTypes.
     
     Any subtypes of the entity types inherit the restriction.
     
     Any classificationDef subtypes inherit the parents entityTypes restrictions.
     
     Any classificationDef subtypes can further restrict the parents entityTypes
     restrictions by specifying a subset of the entityTypes.
     
     An empty entityTypes list when there are no parent restrictions means there are no
     restrictions.
     
     An empty entityTypes list when there are parent
     restrictions means that the subtype picks up the parents
     restrictions.
     
     If a list of entityTypes are supplied, where one inherits
     from another, this will be rejected. This should encourage cleaner
     classificationsDefs."""
    sub_types: Optional[List[str]] = rest_field(name="subTypes")
    """An array of sub types."""
    super_types: Optional[List[str]] = rest_field(name="superTypes")
    """An array of super types."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        date_formatter: Optional["_models.DateFormat"] = None,
        description: Optional[str] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        service_type: Optional[str] = None,
        type_version: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        last_modified_t_s: Optional[str] = None,
        attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = None,
        entity_types: Optional[List[str]] = None,
        sub_types: Optional[List[str]] = None,
        super_types: Optional[List[str]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasClassifications(_model_base.Model):
    """REST serialization friendly list.

    :ivar list: An array of objects.
    :vartype list: list[any]
    :ivar page_size: The size of the page.
    :vartype page_size: int
    :ivar sort_by: The sorted by field.
    :vartype sort_by: str
    :ivar sort_type: to specify whether the result should be sorted? If yes, whether asc or desc.
     Known values are: "NONE", "ASC", and "DESC".
    :vartype sort_type: str or ~azure.purview.datamap.models.SortType
    :ivar start_index: The start index of the page.
    :vartype start_index: int
    :ivar total_count: The total count of items.
    :vartype total_count: int
    """

    list: Optional[List[Any]] = rest_field()
    """An array of objects."""
    page_size: Optional[int] = rest_field(name="pageSize")
    """The size of the page."""
    sort_by: Optional[str] = rest_field(name="sortBy")
    """The sorted by field."""
    sort_type: Optional[Union[str, "_models.SortType"]] = rest_field(name="sortType")
    """to specify whether the result should be sorted? If yes, whether asc or desc. Known values are:
     \"NONE\", \"ASC\", and \"DESC\"."""
    start_index: Optional[int] = rest_field(name="startIndex")
    """The start index of the page."""
    total_count: Optional[int] = rest_field(name="totalCount")
    """The total count of items."""

    @overload
    def __init__(
        self,
        *,
        list: Optional[List[Any]] = None,
        page_size: Optional[int] = None,
        sort_by: Optional[str] = None,
        sort_type: Optional[Union[str, "_models.SortType"]] = None,
        start_index: Optional[int] = None,
        total_count: Optional[int] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasConstraintDef(_model_base.Model):
    """class that captures details of a constraint.

    :ivar params: The parameters of the constraint definition.
    :vartype params: dict[str, any]
    :ivar type: The type of the constraint.
    :vartype type: str
    """

    params: Optional[Dict[str, Any]] = rest_field()
    """The parameters of the constraint definition."""
    type: Optional[str] = rest_field()
    """The type of the constraint."""

    @overload
    def __init__(
        self,
        *,
        params: Optional[Dict[str, Any]] = None,
        type: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasEntitiesWithExtInfo(_model_base.Model):
    """An instance of an entity along with extended info - like hive_table,
    hive_database.

    :ivar referred_entities: The referred entities.
    :vartype referred_entities: dict[str, ~azure.purview.datamap.models.AtlasEntity]
    :ivar entities: An array of entities.
    :vartype entities: list[~azure.purview.datamap.models.AtlasEntity]
    """

    referred_entities: Optional[Dict[str, "_models.AtlasEntity"]] = rest_field(name="referredEntities")
    """The referred entities."""
    entities: Optional[List["_models.AtlasEntity"]] = rest_field()
    """An array of entities."""

    @overload
    def __init__(
        self,
        *,
        referred_entities: Optional[Dict[str, "_models.AtlasEntity"]] = None,
        entities: Optional[List["_models.AtlasEntity"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasEntity(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """An instance of an entity - like hive_table, hive_database.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar attributes: The attributes of the struct.
    :vartype attributes: dict[str, any]
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar business_attributes: Business attributes.
    :vartype business_attributes: dict[str, any]
    :ivar classifications: An array of classifications.
    :vartype classifications: list[~azure.purview.datamap.models.AtlasClassification]
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar custom_attributes: Custom Attribute.
    :vartype custom_attributes: dict[str, str]
    :ivar guid: The GUID of the entity.
    :vartype guid: str
    :ivar home_id: The home ID of the entity.
    :vartype home_id: str
    :ivar collection_id: The collection ID of the entity.
    :vartype collection_id: str
    :ivar is_incomplete: Whether it is a shell entity.
    :vartype is_incomplete: bool
    :ivar labels: labels.
    :vartype labels: list[str]
    :ivar meanings: An array of term assignment headers indicating the meanings of the entity.
    :vartype meanings: list[~azure.purview.datamap.models.AtlasTermAssignmentHeader]
    :ivar provenance_type: Used to record the provenance of an instance of an entity or
     relationship.
    :vartype provenance_type: int
    :ivar proxy: Determines if there's a proxy.
    :vartype proxy: bool
    :ivar relationship_attributes: The attributes of relationship.
    :vartype relationship_attributes: dict[str, any]
    :ivar status: Status of the entity - can be active or deleted. Deleted entities are not
     removed. Known values are: "ACTIVE" and "DELETED".
    :vartype status: str or ~azure.purview.datamap.models.EntityStatus
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the entity.
    :vartype version: int
    :ivar contacts: The dictionary of contacts for entities. Key could be Expert or Owner.
    :vartype contacts: dict[str, list[~azure.purview.datamap.models.ContactInfo]]
    """

    attributes: Optional[Dict[str, Any]] = rest_field()
    """The attributes of the struct."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    business_attributes: Optional[Dict[str, Any]] = rest_field(name="businessAttributes")
    """Business attributes."""
    classifications: Optional[List["_models.AtlasClassification"]] = rest_field()
    """An array of classifications."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    custom_attributes: Optional[Dict[str, str]] = rest_field(name="customAttributes")
    """Custom Attribute."""
    guid: Optional[str] = rest_field()
    """The GUID of the entity."""
    home_id: Optional[str] = rest_field(name="homeId")
    """The home ID of the entity."""
    collection_id: Optional[str] = rest_field(name="collectionId", visibility=["read"])
    """The collection ID of the entity."""
    is_incomplete: Optional[bool] = rest_field(name="isIncomplete")
    """Whether it is a shell entity."""
    labels: Optional[List[str]] = rest_field()
    """labels."""
    meanings: Optional[List["_models.AtlasTermAssignmentHeader"]] = rest_field()
    """An array of term assignment headers indicating the meanings of the entity."""
    provenance_type: Optional[int] = rest_field(name="provenanceType")
    """Used to record the provenance of an instance of an entity or relationship."""
    proxy: Optional[bool] = rest_field()
    """Determines if there's a proxy."""
    relationship_attributes: Optional[Dict[str, Any]] = rest_field(name="relationshipAttributes")
    """The attributes of relationship."""
    status: Optional[Union[str, "_models.EntityStatus"]] = rest_field()
    """Status of the entity - can be active or deleted. Deleted entities are not
     removed. Known values are: \"ACTIVE\" and \"DELETED\"."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the entity."""
    contacts: Optional[Dict[str, List["_models.ContactInfo"]]] = rest_field()
    """The dictionary of contacts for entities. Key could be Expert or Owner."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional[Dict[str, Any]] = None,
        type_name: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
        business_attributes: Optional[Dict[str, Any]] = None,
        classifications: Optional[List["_models.AtlasClassification"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        custom_attributes: Optional[Dict[str, str]] = None,
        guid: Optional[str] = None,
        home_id: Optional[str] = None,
        is_incomplete: Optional[bool] = None,
        labels: Optional[List[str]] = None,
        meanings: Optional[List["_models.AtlasTermAssignmentHeader"]] = None,
        provenance_type: Optional[int] = None,
        proxy: Optional[bool] = None,
        relationship_attributes: Optional[Dict[str, Any]] = None,
        status: Optional[Union[str, "_models.EntityStatus"]] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        contacts: Optional[Dict[str, List["_models.ContactInfo"]]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasEntityDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """class that captures details of a entity-type.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar date_formatter: The date format.
    :vartype date_formatter: ~azure.purview.datamap.models.DateFormat
    :ivar description: The description of the type definition.
    :vartype description: str
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    :ivar options: The options for the type definition.
    :vartype options: dict[str, str]
    :ivar service_type: The service type.
    :vartype service_type: str
    :ivar type_version: The version of the type.
    :vartype type_version: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the record.
    :vartype version: int
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar attribute_defs: An array of attribute definitions.
    :vartype attribute_defs: list[~azure.purview.datamap.models.AtlasAttributeDef]
    :ivar sub_types: An array of sub types.
    :vartype sub_types: list[str]
    :ivar super_types: An array of super types.
    :vartype super_types: list[str]
    :ivar relationship_attribute_defs: An array of relationship attributes.
    :vartype relationship_attribute_defs:
     list[~azure.purview.datamap.models.AtlasRelationshipAttributeDef]
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    date_formatter: Optional["_models.DateFormat"] = rest_field(name="dateFormatter")
    """The date format."""
    description: Optional[str] = rest_field()
    """The description of the type definition."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the type definition."""
    service_type: Optional[str] = rest_field(name="serviceType")
    """The service type."""
    type_version: Optional[str] = rest_field(name="typeVersion")
    """The version of the type."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the record."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = rest_field(name="attributeDefs")
    """An array of attribute definitions."""
    sub_types: Optional[List[str]] = rest_field(name="subTypes")
    """An array of sub types."""
    super_types: Optional[List[str]] = rest_field(name="superTypes")
    """An array of super types."""
    relationship_attribute_defs: Optional[List["_models.AtlasRelationshipAttributeDef"]] = rest_field(
        name="relationshipAttributeDefs"
    )
    """An array of relationship attributes."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        date_formatter: Optional["_models.DateFormat"] = None,
        description: Optional[str] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        service_type: Optional[str] = None,
        type_version: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        last_modified_t_s: Optional[str] = None,
        attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = None,
        sub_types: Optional[List[str]] = None,
        super_types: Optional[List[str]] = None,
        relationship_attribute_defs: Optional[List["_models.AtlasRelationshipAttributeDef"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasEntityHeader(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """An instance of an entity - like hive_table, hive_database.

    :ivar attributes: The attributes of the struct.
    :vartype attributes: dict[str, any]
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar classification_names: An array of classification names.
    :vartype classification_names: list[str]
    :ivar classifications: An array of classifications.
    :vartype classifications: list[~azure.purview.datamap.models.AtlasClassification]
    :ivar display_text: The display text.
    :vartype display_text: str
    :ivar guid: The GUID of the record.
    :vartype guid: str
    :ivar is_incomplete: Whether it is a shell entity.
    :vartype is_incomplete: bool
    :ivar labels: labels.
    :vartype labels: list[str]
    :ivar meaning_names: An array of meanings.
    :vartype meaning_names: list[str]
    :ivar meanings: An array of term assignment headers.
    :vartype meanings: list[~azure.purview.datamap.models.AtlasTermAssignmentHeader]
    :ivar status: Status of the entity - can be active or deleted. Deleted entities are not
     removed. Known values are: "ACTIVE" and "DELETED".
    :vartype status: str or ~azure.purview.datamap.models.EntityStatus
    """

    attributes: Optional[Dict[str, Any]] = rest_field()
    """The attributes of the struct."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    classification_names: Optional[List[str]] = rest_field(name="classificationNames")
    """An array of classification names."""
    classifications: Optional[List["_models.AtlasClassification"]] = rest_field()
    """An array of classifications."""
    display_text: Optional[str] = rest_field(name="displayText")
    """The display text."""
    guid: Optional[str] = rest_field()
    """The GUID of the record."""
    is_incomplete: Optional[bool] = rest_field(name="isIncomplete")
    """Whether it is a shell entity."""
    labels: Optional[List[str]] = rest_field()
    """labels."""
    meaning_names: Optional[List[str]] = rest_field(name="meaningNames")
    """An array of meanings."""
    meanings: Optional[List["_models.AtlasTermAssignmentHeader"]] = rest_field()
    """An array of term assignment headers."""
    status: Optional[Union[str, "_models.EntityStatus"]] = rest_field()
    """Status of the entity - can be active or deleted. Deleted entities are not
     removed. Known values are: \"ACTIVE\" and \"DELETED\"."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional[Dict[str, Any]] = None,
        type_name: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
        classification_names: Optional[List[str]] = None,
        classifications: Optional[List["_models.AtlasClassification"]] = None,
        display_text: Optional[str] = None,
        guid: Optional[str] = None,
        is_incomplete: Optional[bool] = None,
        labels: Optional[List[str]] = None,
        meaning_names: Optional[List[str]] = None,
        meanings: Optional[List["_models.AtlasTermAssignmentHeader"]] = None,
        status: Optional[Union[str, "_models.EntityStatus"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasEntityHeaders(_model_base.Model):
    """An instance of an entity header map.

    :ivar guid_header_map: The description of the guid header map,.
    :vartype guid_header_map: dict[str, ~azure.purview.datamap.models.AtlasEntityHeader]
    """

    guid_header_map: Optional[Dict[str, "_models.AtlasEntityHeader"]] = rest_field(name="guidHeaderMap")
    """The description of the guid header map,."""

    @overload
    def __init__(
        self,
        *,
        guid_header_map: Optional[Dict[str, "_models.AtlasEntityHeader"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasEntityWithExtInfo(_model_base.Model):
    """An instance of an entity along with extended info - like hive_table,
    hive_database.

    :ivar referred_entities: The referred entities.
    :vartype referred_entities: dict[str, ~azure.purview.datamap.models.AtlasEntity]
    :ivar entity: An instance of an entity - like hive_table, hive_database.
    :vartype entity: ~azure.purview.datamap.models.AtlasEntity
    """

    referred_entities: Optional[Dict[str, "_models.AtlasEntity"]] = rest_field(name="referredEntities")
    """The referred entities."""
    entity: Optional["_models.AtlasEntity"] = rest_field()
    """An instance of an entity - like hive_table, hive_database."""

    @overload
    def __init__(
        self,
        *,
        referred_entities: Optional[Dict[str, "_models.AtlasEntity"]] = None,
        entity: Optional["_models.AtlasEntity"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasEnumDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """class that captures details of an enum-type.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar date_formatter: The date format.
    :vartype date_formatter: ~azure.purview.datamap.models.DateFormat
    :ivar description: The description of the type definition.
    :vartype description: str
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    :ivar options: The options for the type definition.
    :vartype options: dict[str, str]
    :ivar service_type: The service type.
    :vartype service_type: str
    :ivar type_version: The version of the type.
    :vartype type_version: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the record.
    :vartype version: int
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar default_value: The default value.
    :vartype default_value: str
    :ivar element_defs: An array of enum element definitions.
    :vartype element_defs: list[~azure.purview.datamap.models.AtlasEnumElementDef]
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    date_formatter: Optional["_models.DateFormat"] = rest_field(name="dateFormatter")
    """The date format."""
    description: Optional[str] = rest_field()
    """The description of the type definition."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the type definition."""
    service_type: Optional[str] = rest_field(name="serviceType")
    """The service type."""
    type_version: Optional[str] = rest_field(name="typeVersion")
    """The version of the type."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the record."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    default_value: Optional[str] = rest_field(name="defaultValue")
    """The default value."""
    element_defs: Optional[List["_models.AtlasEnumElementDef"]] = rest_field(name="elementDefs")
    """An array of enum element definitions."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        date_formatter: Optional["_models.DateFormat"] = None,
        description: Optional[str] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        service_type: Optional[str] = None,
        type_version: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        last_modified_t_s: Optional[str] = None,
        default_value: Optional[str] = None,
        element_defs: Optional[List["_models.AtlasEnumElementDef"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasEnumElementDef(_model_base.Model):
    """class that captures details of an enum-element.

    :ivar description: The description of the enum element definition.
    :vartype description: str
    :ivar ordinal: The ordinal of the enum element definition.
    :vartype ordinal: int
    :ivar value: The value of the enum element definition.
    :vartype value: str
    """

    description: Optional[str] = rest_field()
    """The description of the enum element definition."""
    ordinal: Optional[int] = rest_field()
    """The ordinal of the enum element definition."""
    value: Optional[str] = rest_field()
    """The value of the enum element definition."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        ordinal: Optional[int] = None,
        value: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasErrorResponse(_model_base.Model):
    """An error response from the service.

    :ivar request_id: The request ID.
    :vartype request_id: str
    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    """

    request_id: Optional[str] = rest_field(name="requestId")
    """The request ID."""
    error_code: Optional[str] = rest_field(name="errorCode")
    """The error code."""
    error_message: Optional[str] = rest_field(name="errorMessage")
    """The error message."""

    @overload
    def __init__(
        self,
        *,
        request_id: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasGlossary(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The glossary object.

    :ivar guid: The GUID of the object.
    :vartype guid: str
    :ivar classifications: An array of classifications.
    :vartype classifications: list[~azure.purview.datamap.models.AtlasClassification]
    :ivar long_description: The long version description.
    :vartype long_description: str
    :ivar name: The name of the glossary object.
    :vartype name: str
    :ivar qualified_name: The qualified name of the glossary object.
    :vartype qualified_name: str
    :ivar short_description: The short version of description.
    :vartype short_description: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar categories: An array of categories.
    :vartype categories: list[~azure.purview.datamap.models.AtlasRelatedCategoryHeader]
    :ivar language: The language of the glossary.
    :vartype language: str
    :ivar terms: An array of related term headers.
    :vartype terms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar usage: The usage of the glossary.
    :vartype usage: str
    """

    guid: Optional[str] = rest_field()
    """The GUID of the object."""
    classifications: Optional[List["_models.AtlasClassification"]] = rest_field()
    """An array of classifications."""
    long_description: Optional[str] = rest_field(name="longDescription")
    """The long version description."""
    name: Optional[str] = rest_field()
    """The name of the glossary object."""
    qualified_name: Optional[str] = rest_field(name="qualifiedName")
    """The qualified name of the glossary object."""
    short_description: Optional[str] = rest_field(name="shortDescription")
    """The short version of description."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    categories: Optional[List["_models.AtlasRelatedCategoryHeader"]] = rest_field()
    """An array of categories."""
    language: Optional[str] = rest_field()
    """The language of the glossary."""
    terms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field()
    """An array of related term headers."""
    usage: Optional[str] = rest_field()
    """The usage of the glossary."""

    @overload
    def __init__(
        self,
        *,
        guid: Optional[str] = None,
        classifications: Optional[List["_models.AtlasClassification"]] = None,
        long_description: Optional[str] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        short_description: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        categories: Optional[List["_models.AtlasRelatedCategoryHeader"]] = None,
        language: Optional[str] = None,
        terms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        usage: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasGlossaryCategory(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The glossary category.

    :ivar guid: The GUID of the object.
    :vartype guid: str
    :ivar classifications: An array of classifications.
    :vartype classifications: list[~azure.purview.datamap.models.AtlasClassification]
    :ivar long_description: The long version description.
    :vartype long_description: str
    :ivar name: The name of the glossary object.
    :vartype name: str
    :ivar qualified_name: The qualified name of the glossary object.
    :vartype qualified_name: str
    :ivar short_description: The short version of description.
    :vartype short_description: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar anchor: The glossary header with basic information.
    :vartype anchor: ~azure.purview.datamap.models.AtlasGlossaryHeader
    :ivar children_categories: An array of children categories.
    :vartype children_categories: list[~azure.purview.datamap.models.AtlasRelatedCategoryHeader]
    :ivar parent_category: The header of the related category.
    :vartype parent_category: ~azure.purview.datamap.models.AtlasRelatedCategoryHeader
    :ivar terms: An array of related term headers.
    :vartype terms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    """

    guid: Optional[str] = rest_field()
    """The GUID of the object."""
    classifications: Optional[List["_models.AtlasClassification"]] = rest_field()
    """An array of classifications."""
    long_description: Optional[str] = rest_field(name="longDescription")
    """The long version description."""
    name: Optional[str] = rest_field()
    """The name of the glossary object."""
    qualified_name: Optional[str] = rest_field(name="qualifiedName")
    """The qualified name of the glossary object."""
    short_description: Optional[str] = rest_field(name="shortDescription")
    """The short version of description."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    anchor: Optional["_models.AtlasGlossaryHeader"] = rest_field()
    """The glossary header with basic information."""
    children_categories: Optional[List["_models.AtlasRelatedCategoryHeader"]] = rest_field(name="childrenCategories")
    """An array of children categories."""
    parent_category: Optional["_models.AtlasRelatedCategoryHeader"] = rest_field(name="parentCategory")
    """The header of the related category."""
    terms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field()
    """An array of related term headers."""

    @overload
    def __init__(
        self,
        *,
        guid: Optional[str] = None,
        classifications: Optional[List["_models.AtlasClassification"]] = None,
        long_description: Optional[str] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        short_description: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        anchor: Optional["_models.AtlasGlossaryHeader"] = None,
        children_categories: Optional[List["_models.AtlasRelatedCategoryHeader"]] = None,
        parent_category: Optional["_models.AtlasRelatedCategoryHeader"] = None,
        terms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasGlossaryExtInfo(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The extended information of glossary.

    :ivar guid: The GUID of the object.
    :vartype guid: str
    :ivar classifications: An array of classifications.
    :vartype classifications: list[~azure.purview.datamap.models.AtlasClassification]
    :ivar long_description: The long version description.
    :vartype long_description: str
    :ivar name: The name of the glossary object.
    :vartype name: str
    :ivar qualified_name: The qualified name of the glossary object.
    :vartype qualified_name: str
    :ivar short_description: The short version of description.
    :vartype short_description: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar categories: An array of categories.
    :vartype categories: list[~azure.purview.datamap.models.AtlasRelatedCategoryHeader]
    :ivar language: The language of the glossary.
    :vartype language: str
    :ivar terms: An array of related term headers.
    :vartype terms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar usage: The usage of the glossary.
    :vartype usage: str
    :ivar category_info: The glossary category information.
    :vartype category_info: dict[str, ~azure.purview.datamap.models.AtlasGlossaryCategory]
    :ivar term_info: The glossary term information.
    :vartype term_info: dict[str, ~azure.purview.datamap.models.AtlasGlossaryTerm]
    """

    guid: Optional[str] = rest_field()
    """The GUID of the object."""
    classifications: Optional[List["_models.AtlasClassification"]] = rest_field()
    """An array of classifications."""
    long_description: Optional[str] = rest_field(name="longDescription")
    """The long version description."""
    name: Optional[str] = rest_field()
    """The name of the glossary object."""
    qualified_name: Optional[str] = rest_field(name="qualifiedName")
    """The qualified name of the glossary object."""
    short_description: Optional[str] = rest_field(name="shortDescription")
    """The short version of description."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    categories: Optional[List["_models.AtlasRelatedCategoryHeader"]] = rest_field()
    """An array of categories."""
    language: Optional[str] = rest_field()
    """The language of the glossary."""
    terms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field()
    """An array of related term headers."""
    usage: Optional[str] = rest_field()
    """The usage of the glossary."""
    category_info: Optional[Dict[str, "_models.AtlasGlossaryCategory"]] = rest_field(name="categoryInfo")
    """The glossary category information."""
    term_info: Optional[Dict[str, "_models.AtlasGlossaryTerm"]] = rest_field(name="termInfo")
    """The glossary term information."""

    @overload
    def __init__(
        self,
        *,
        guid: Optional[str] = None,
        classifications: Optional[List["_models.AtlasClassification"]] = None,
        long_description: Optional[str] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        short_description: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        categories: Optional[List["_models.AtlasRelatedCategoryHeader"]] = None,
        language: Optional[str] = None,
        terms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        usage: Optional[str] = None,
        category_info: Optional[Dict[str, "_models.AtlasGlossaryCategory"]] = None,
        term_info: Optional[Dict[str, "_models.AtlasGlossaryTerm"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasGlossaryHeader(_model_base.Model):
    """The glossary header with basic information.

    :ivar display_text: The display text.
    :vartype display_text: str
    :ivar glossary_guid: The GUID of the glossary.
    :vartype glossary_guid: str
    :ivar relation_guid: The GUID of the relationship.
    :vartype relation_guid: str
    """

    display_text: Optional[str] = rest_field(name="displayText")
    """The display text."""
    glossary_guid: Optional[str] = rest_field(name="glossaryGuid")
    """The GUID of the glossary."""
    relation_guid: Optional[str] = rest_field(name="relationGuid")
    """The GUID of the relationship."""

    @overload
    def __init__(
        self,
        *,
        display_text: Optional[str] = None,
        glossary_guid: Optional[str] = None,
        relation_guid: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasGlossaryTerm(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The glossary term.

    :ivar guid: The GUID of the object.
    :vartype guid: str
    :ivar classifications: An array of classifications.
    :vartype classifications: list[~azure.purview.datamap.models.AtlasClassification]
    :ivar long_description: The long version description.
    :vartype long_description: str
    :ivar name: The name of the glossary object.
    :vartype name: str
    :ivar qualified_name: The qualified name of the glossary object.
    :vartype qualified_name: str
    :ivar short_description: The short version of description.
    :vartype short_description: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar abbreviation: The abbreviation of the term.
    :vartype abbreviation: str
    :ivar template_name: The name of the template.
    :vartype template_name: list[any]
    :ivar anchor: The glossary header with basic information.
    :vartype anchor: ~azure.purview.datamap.models.AtlasGlossaryHeader
    :ivar antonyms: An array of related term headers as antonyms.
    :vartype antonyms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar status: Status of the AtlasGlossaryTerm. Known values are: "Draft", "Approved", "Alert",
     and "Expired".
    :vartype status: str or ~azure.purview.datamap.models.TermStatus
    :ivar nick_name: The nick name of the term.
    :vartype nick_name: str
    :ivar hierarchy_info: The hierarchy information of the term.
    :vartype hierarchy_info: list[~azure.purview.datamap.models.PurviewObjectId]
    :ivar resources: An array of resource link for term.
    :vartype resources: list[~azure.purview.datamap.models.ResourceLink]
    :ivar contacts: The dictionary of contacts for terms. Key could be Expert or Steward.
    :vartype contacts: dict[str, list[~azure.purview.datamap.models.ContactInfo]]
    :ivar attributes: The custom attributes of the term, which is map<string,map<string,object>>.
     The
     key of the first layer map is term template name.
    :vartype attributes: dict[str, dict[str, any]]
    :ivar assigned_entities: An array of related object IDs.
    :vartype assigned_entities: list[~azure.purview.datamap.models.AtlasRelatedObjectId]
    :ivar categories: An array of term categorization headers.
    :vartype categories: list[~azure.purview.datamap.models.AtlasTermCategorizationHeader]
    :ivar classifies: An array of related term headers.
    :vartype classifies: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar examples: An array of examples.
    :vartype examples: list[str]
    :ivar is_a: An array of related term headers indicating the is-a relationship.
    :vartype is_a: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar preferred_terms: An array of preferred related term headers.
    :vartype preferred_terms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar preferred_to_terms: An array of related term headers that are preferred to.
    :vartype preferred_to_terms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar replaced_by: An array of related term headers that are replaced by.
    :vartype replaced_by: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar replacement_terms: An array of related term headers for replacement.
    :vartype replacement_terms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar see_also: An array of related term headers for see also.
    :vartype see_also: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar synonyms: An array of related term headers as synonyms.
    :vartype synonyms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar translated_terms: An array of translated related term headers.
    :vartype translated_terms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar translation_terms: An array of related term headers for translation.
    :vartype translation_terms: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar usage: The usage of the term.
    :vartype usage: str
    :ivar valid_values: An array of related term headers as valid values.
    :vartype valid_values: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    :ivar valid_values_for: An array of related term headers as valid values for other records.
    :vartype valid_values_for: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
    """

    guid: Optional[str] = rest_field()
    """The GUID of the object."""
    classifications: Optional[List["_models.AtlasClassification"]] = rest_field()
    """An array of classifications."""
    long_description: Optional[str] = rest_field(name="longDescription")
    """The long version description."""
    name: Optional[str] = rest_field()
    """The name of the glossary object."""
    qualified_name: Optional[str] = rest_field(name="qualifiedName")
    """The qualified name of the glossary object."""
    short_description: Optional[str] = rest_field(name="shortDescription")
    """The short version of description."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    abbreviation: Optional[str] = rest_field()
    """The abbreviation of the term."""
    template_name: Optional[List[Any]] = rest_field(name="templateName")
    """The name of the template."""
    anchor: Optional["_models.AtlasGlossaryHeader"] = rest_field()
    """The glossary header with basic information."""
    antonyms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field()
    """An array of related term headers as antonyms."""
    status: Optional[Union[str, "_models.TermStatus"]] = rest_field()
    """Status of the AtlasGlossaryTerm. Known values are: \"Draft\", \"Approved\", \"Alert\", and
     \"Expired\"."""
    nick_name: Optional[str] = rest_field(name="nickName")
    """The nick name of the term."""
    hierarchy_info: Optional[List["_models.PurviewObjectId"]] = rest_field(name="hierarchyInfo")
    """The hierarchy information of the term."""
    resources: Optional[List["_models.ResourceLink"]] = rest_field()
    """An array of resource link for term."""
    contacts: Optional[Dict[str, List["_models.ContactInfo"]]] = rest_field()
    """The dictionary of contacts for terms. Key could be Expert or Steward."""
    attributes: Optional[Dict[str, Dict[str, Any]]] = rest_field()
    """The custom attributes of the term, which is map<string,map<string,object>>.
     The
     key of the first layer map is term template name."""
    assigned_entities: Optional[List["_models.AtlasRelatedObjectId"]] = rest_field(name="assignedEntities")
    """An array of related object IDs."""
    categories: Optional[List["_models.AtlasTermCategorizationHeader"]] = rest_field()
    """An array of term categorization headers."""
    classifies: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field()
    """An array of related term headers."""
    examples: Optional[List[str]] = rest_field()
    """An array of examples."""
    is_a: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="isA")
    """An array of related term headers indicating the is-a relationship."""
    preferred_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="preferredTerms")
    """An array of preferred related term headers."""
    preferred_to_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="preferredToTerms")
    """An array of related term headers that are preferred to."""
    replaced_by: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="replacedBy")
    """An array of related term headers that are replaced by."""
    replacement_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="replacementTerms")
    """An array of related term headers for replacement."""
    see_also: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="seeAlso")
    """An array of related term headers for see also."""
    synonyms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field()
    """An array of related term headers as synonyms."""
    translated_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="translatedTerms")
    """An array of translated related term headers."""
    translation_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="translationTerms")
    """An array of related term headers for translation."""
    usage: Optional[str] = rest_field()
    """The usage of the term."""
    valid_values: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="validValues")
    """An array of related term headers as valid values."""
    valid_values_for: Optional[List["_models.AtlasRelatedTermHeader"]] = rest_field(name="validValuesFor")
    """An array of related term headers as valid values for other records."""

    @overload
    def __init__(
        self,
        *,
        guid: Optional[str] = None,
        classifications: Optional[List["_models.AtlasClassification"]] = None,
        long_description: Optional[str] = None,
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        short_description: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        abbreviation: Optional[str] = None,
        template_name: Optional[List[Any]] = None,
        anchor: Optional["_models.AtlasGlossaryHeader"] = None,
        antonyms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        status: Optional[Union[str, "_models.TermStatus"]] = None,
        nick_name: Optional[str] = None,
        hierarchy_info: Optional[List["_models.PurviewObjectId"]] = None,
        resources: Optional[List["_models.ResourceLink"]] = None,
        contacts: Optional[Dict[str, List["_models.ContactInfo"]]] = None,
        attributes: Optional[Dict[str, Dict[str, Any]]] = None,
        assigned_entities: Optional[List["_models.AtlasRelatedObjectId"]] = None,
        categories: Optional[List["_models.AtlasTermCategorizationHeader"]] = None,
        classifies: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        examples: Optional[List[str]] = None,
        is_a: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        preferred_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        preferred_to_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        replaced_by: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        replacement_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        see_also: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        synonyms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        translated_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        translation_terms: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        usage: Optional[str] = None,
        valid_values: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
        valid_values_for: Optional[List["_models.AtlasRelatedTermHeader"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasLineageInfo(_model_base.Model):
    """The lineage information.

    :ivar base_entity_guid: The GUID of the base entity.
    :vartype base_entity_guid: str
    :ivar guid_entity_map: The GUID entity map.
    :vartype guid_entity_map: dict[str, ~azure.purview.datamap.models.AtlasEntityHeader]
    :ivar width_counts: The entity count in specific direction.
    :vartype width_counts: dict[str, dict[str, any]]
    :ivar lineage_depth: The depth of lineage.
    :vartype lineage_depth: int
    :ivar lineage_width: The width of lineage.
    :vartype lineage_width: int
    :ivar children_count: The number of children node.
    :vartype children_count: int
    :ivar lineage_direction: The enum of lineage direction. Known values are: "INPUT", "OUTPUT",
     and "BOTH".
    :vartype lineage_direction: str or ~azure.purview.datamap.models.LineageDirection
    :ivar parent_relations: An array of parentRelations relations.
    :vartype parent_relations: list[~azure.purview.datamap.models.ParentRelation]
    :ivar relations: An array of lineage relations.
    :vartype relations: list[~azure.purview.datamap.models.LineageRelation]
    """

    base_entity_guid: Optional[str] = rest_field(name="baseEntityGuid")
    """The GUID of the base entity."""
    guid_entity_map: Optional[Dict[str, "_models.AtlasEntityHeader"]] = rest_field(name="guidEntityMap")
    """The GUID entity map."""
    width_counts: Optional[Dict[str, Dict[str, Any]]] = rest_field(name="widthCounts")
    """The entity count in specific direction."""
    lineage_depth: Optional[int] = rest_field(name="lineageDepth")
    """The depth of lineage."""
    lineage_width: Optional[int] = rest_field(name="lineageWidth")
    """The width of lineage."""
    children_count: Optional[int] = rest_field(name="childrenCount")
    """The number of children node."""
    lineage_direction: Optional[Union[str, "_models.LineageDirection"]] = rest_field(name="lineageDirection")
    """The enum of lineage direction. Known values are: \"INPUT\", \"OUTPUT\", and \"BOTH\"."""
    parent_relations: Optional[List["_models.ParentRelation"]] = rest_field(name="parentRelations")
    """An array of parentRelations relations."""
    relations: Optional[List["_models.LineageRelation"]] = rest_field()
    """An array of lineage relations."""

    @overload
    def __init__(
        self,
        *,
        base_entity_guid: Optional[str] = None,
        guid_entity_map: Optional[Dict[str, "_models.AtlasEntityHeader"]] = None,
        width_counts: Optional[Dict[str, Dict[str, Any]]] = None,
        lineage_depth: Optional[int] = None,
        lineage_width: Optional[int] = None,
        children_count: Optional[int] = None,
        lineage_direction: Optional[Union[str, "_models.LineageDirection"]] = None,
        parent_relations: Optional[List["_models.ParentRelation"]] = None,
        relations: Optional[List["_models.LineageRelation"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasObjectId(_model_base.Model):
    """Reference to an object-instance of a type - like entity.

    :ivar guid: The GUID of the object.
    :vartype guid: str
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar unique_attributes: The unique attributes of the object.
    :vartype unique_attributes: dict[str, any]
    """

    guid: Optional[str] = rest_field()
    """The GUID of the object."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    unique_attributes: Optional[Dict[str, Any]] = rest_field(name="uniqueAttributes")
    """The unique attributes of the object."""

    @overload
    def __init__(
        self,
        *,
        guid: Optional[str] = None,
        type_name: Optional[str] = None,
        unique_attributes: Optional[Dict[str, Any]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasRelatedCategoryHeader(_model_base.Model):
    """The header of the related category.

    :ivar category_guid: The GUID of the category.
    :vartype category_guid: str
    :ivar description: The description of the category header.
    :vartype description: str
    :ivar display_text: The display text.
    :vartype display_text: str
    :ivar parent_category_guid: The GUID of the parent category.
    :vartype parent_category_guid: str
    :ivar relation_guid: The GUID of the relationship.
    :vartype relation_guid: str
    """

    category_guid: Optional[str] = rest_field(name="categoryGuid")
    """The GUID of the category."""
    description: Optional[str] = rest_field()
    """The description of the category header."""
    display_text: Optional[str] = rest_field(name="displayText")
    """The display text."""
    parent_category_guid: Optional[str] = rest_field(name="parentCategoryGuid")
    """The GUID of the parent category."""
    relation_guid: Optional[str] = rest_field(name="relationGuid")
    """The GUID of the relationship."""

    @overload
    def __init__(
        self,
        *,
        category_guid: Optional[str] = None,
        description: Optional[str] = None,
        display_text: Optional[str] = None,
        parent_category_guid: Optional[str] = None,
        relation_guid: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasRelatedObjectId(_model_base.Model):
    """Reference to an object-instance of AtlasEntity type used in relationship
    attribute values.

    :ivar guid: The GUID of the object.
    :vartype guid: str
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar unique_attributes: The unique attributes of the object.
    :vartype unique_attributes: dict[str, any]
    :ivar display_text: The display text.
    :vartype display_text: str
    :ivar entity_status: Status of the entity - can be active or deleted. Deleted entities are not
     removed. Known values are: "ACTIVE" and "DELETED".
    :vartype entity_status: str or ~azure.purview.datamap.models.EntityStatus
    :ivar relationship_type: Relationship type.
    :vartype relationship_type: str
    :ivar relationship_attributes: Captures details of struct contents. Not instantiated directly,
     used only via
     AtlasEntity, AtlasClassification.
    :vartype relationship_attributes: ~azure.purview.datamap.models.AtlasStruct
    :ivar relationship_guid: The GUID of the relationship.
    :vartype relationship_guid: str
    :ivar relationship_status: The enum of relationship status. Known values are: "ACTIVE" and
     "DELETED".
    :vartype relationship_status: str or ~azure.purview.datamap.models.StatusAtlasRelationship
    """

    guid: Optional[str] = rest_field()
    """The GUID of the object."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    unique_attributes: Optional[Dict[str, Any]] = rest_field(name="uniqueAttributes")
    """The unique attributes of the object."""
    display_text: Optional[str] = rest_field(name="displayText")
    """The display text."""
    entity_status: Optional[Union[str, "_models.EntityStatus"]] = rest_field(name="entityStatus")
    """Status of the entity - can be active or deleted. Deleted entities are not
     removed. Known values are: \"ACTIVE\" and \"DELETED\"."""
    relationship_type: Optional[str] = rest_field(name="relationshipType")
    """Relationship type."""
    relationship_attributes: Optional["_models.AtlasStruct"] = rest_field(name="relationshipAttributes")
    """Captures details of struct contents. Not instantiated directly, used only via
     AtlasEntity, AtlasClassification."""
    relationship_guid: Optional[str] = rest_field(name="relationshipGuid")
    """The GUID of the relationship."""
    relationship_status: Optional[Union[str, "_models.StatusAtlasRelationship"]] = rest_field(name="relationshipStatus")
    """The enum of relationship status. Known values are: \"ACTIVE\" and \"DELETED\"."""

    @overload
    def __init__(
        self,
        *,
        guid: Optional[str] = None,
        type_name: Optional[str] = None,
        unique_attributes: Optional[Dict[str, Any]] = None,
        display_text: Optional[str] = None,
        entity_status: Optional[Union[str, "_models.EntityStatus"]] = None,
        relationship_type: Optional[str] = None,
        relationship_attributes: Optional["_models.AtlasStruct"] = None,
        relationship_guid: Optional[str] = None,
        relationship_status: Optional[Union[str, "_models.StatusAtlasRelationship"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasRelatedTermHeader(_model_base.Model):
    """The header of the related term.

    :ivar description: The description of the related term.
    :vartype description: str
    :ivar display_text: The display text.
    :vartype display_text: str
    :ivar expression: The expression of the term.
    :vartype expression: str
    :ivar relation_guid: The GUID of the relationship.
    :vartype relation_guid: str
    :ivar status: The status of term relationship. Known values are: "DRAFT", "ACTIVE",
     "DEPRECATED", "OBSOLETE", and "OTHER".
    :vartype status: str or ~azure.purview.datamap.models.AtlasTermRelationshipStatus
    :ivar steward: The steward of the term.
    :vartype steward: str
    :ivar term_guid: The GUID of the term.
    :vartype term_guid: str
    """

    description: Optional[str] = rest_field()
    """The description of the related term."""
    display_text: Optional[str] = rest_field(name="displayText")
    """The display text."""
    expression: Optional[str] = rest_field()
    """The expression of the term."""
    relation_guid: Optional[str] = rest_field(name="relationGuid")
    """The GUID of the relationship."""
    status: Optional[Union[str, "_models.AtlasTermRelationshipStatus"]] = rest_field()
    """The status of term relationship. Known values are: \"DRAFT\", \"ACTIVE\", \"DEPRECATED\",
     \"OBSOLETE\", and \"OTHER\"."""
    steward: Optional[str] = rest_field()
    """The steward of the term."""
    term_guid: Optional[str] = rest_field(name="termGuid")
    """The GUID of the term."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        display_text: Optional[str] = None,
        expression: Optional[str] = None,
        relation_guid: Optional[str] = None,
        status: Optional[Union[str, "_models.AtlasTermRelationshipStatus"]] = None,
        steward: Optional[str] = None,
        term_guid: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasRelationship(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Atlas relationship instance.

    :ivar attributes: The attributes of the struct.
    :vartype attributes: dict[str, any]
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar end1: Reference to an object-instance of a type - like entity.
    :vartype end1: ~azure.purview.datamap.models.AtlasObjectId
    :ivar end2: Reference to an object-instance of a type - like entity.
    :vartype end2: ~azure.purview.datamap.models.AtlasObjectId
    :ivar guid: The GUID of the relationship.
    :vartype guid: str
    :ivar home_id: The home ID of the relationship.
    :vartype home_id: str
    :ivar label: The label of the relationship.
    :vartype label: str
    :ivar provenance_type: Used to record the provenance of an instance of an entity or
     relationship.
    :vartype provenance_type: int
    :ivar status: The enum of relationship status. Known values are: "ACTIVE" and "DELETED".
    :vartype status: str or ~azure.purview.datamap.models.StatusAtlasRelationship
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the relationship.
    :vartype version: int
    """

    attributes: Optional[Dict[str, Any]] = rest_field()
    """The attributes of the struct."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    end1: Optional["_models.AtlasObjectId"] = rest_field()
    """Reference to an object-instance of a type - like entity."""
    end2: Optional["_models.AtlasObjectId"] = rest_field()
    """Reference to an object-instance of a type - like entity."""
    guid: Optional[str] = rest_field()
    """The GUID of the relationship."""
    home_id: Optional[str] = rest_field(name="homeId")
    """The home ID of the relationship."""
    label: Optional[str] = rest_field()
    """The label of the relationship."""
    provenance_type: Optional[int] = rest_field(name="provenanceType")
    """Used to record the provenance of an instance of an entity or relationship."""
    status: Optional[Union[str, "_models.StatusAtlasRelationship"]] = rest_field()
    """The enum of relationship status. Known values are: \"ACTIVE\" and \"DELETED\"."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the relationship."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional[Dict[str, Any]] = None,
        type_name: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        end1: Optional["_models.AtlasObjectId"] = None,
        end2: Optional["_models.AtlasObjectId"] = None,
        guid: Optional[str] = None,
        home_id: Optional[str] = None,
        label: Optional[str] = None,
        provenance_type: Optional[int] = None,
        status: Optional[Union[str, "_models.StatusAtlasRelationship"]] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasRelationshipAttributeDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The relationshipEndDef represents an end of the relationship. The end of the
    relationship is defined by a type, an
    attribute name, cardinality and whether
    it  is the container end of the relationship.

    :ivar cardinality: single-valued attribute or multi-valued attribute. Known values are:
     "SINGLE", "LIST", and "SET".
    :vartype cardinality: str or ~azure.purview.datamap.models.CardinalityValue
    :ivar constraints: An array of constraints.
    :vartype constraints: list[~azure.purview.datamap.models.AtlasConstraintDef]
    :ivar default_value: The default value of the attribute.
    :vartype default_value: str
    :ivar description: The description of the attribute.
    :vartype description: str
    :ivar include_in_notification: Determines if it is included in notification.
    :vartype include_in_notification: bool
    :ivar is_indexable: Determines if it is indexable.
    :vartype is_indexable: bool
    :ivar is_optional: Determines if it is optional.
    :vartype is_optional: bool
    :ivar is_unique: Determines if it unique.
    :vartype is_unique: bool
    :ivar name: The name of the attribute.
    :vartype name: str
    :ivar options: The options for the attribute.
    :vartype options: dict[str, str]
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar values_max_count: The maximum count of the values.
    :vartype values_max_count: int
    :ivar values_min_count: The minimum count of the values.
    :vartype values_min_count: int
    :ivar is_legacy_attribute: Determines if it is a legacy attribute.
    :vartype is_legacy_attribute: bool
    :ivar relationship_type_name: The name of the relationship type.
    :vartype relationship_type_name: str
    """

    cardinality: Optional[Union[str, "_models.CardinalityValue"]] = rest_field()
    """single-valued attribute or multi-valued attribute. Known values are: \"SINGLE\", \"LIST\", and
     \"SET\"."""
    constraints: Optional[List["_models.AtlasConstraintDef"]] = rest_field()
    """An array of constraints."""
    default_value: Optional[str] = rest_field(name="defaultValue")
    """The default value of the attribute."""
    description: Optional[str] = rest_field()
    """The description of the attribute."""
    include_in_notification: Optional[bool] = rest_field(name="includeInNotification")
    """Determines if it is included in notification."""
    is_indexable: Optional[bool] = rest_field(name="isIndexable")
    """Determines if it is indexable."""
    is_optional: Optional[bool] = rest_field(name="isOptional")
    """Determines if it is optional."""
    is_unique: Optional[bool] = rest_field(name="isUnique")
    """Determines if it unique."""
    name: Optional[str] = rest_field()
    """The name of the attribute."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the attribute."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    values_max_count: Optional[int] = rest_field(name="valuesMaxCount")
    """The maximum count of the values."""
    values_min_count: Optional[int] = rest_field(name="valuesMinCount")
    """The minimum count of the values."""
    is_legacy_attribute: Optional[bool] = rest_field(name="isLegacyAttribute")
    """Determines if it is a legacy attribute."""
    relationship_type_name: Optional[str] = rest_field(name="relationshipTypeName")
    """The name of the relationship type."""

    @overload
    def __init__(
        self,
        *,
        cardinality: Optional[Union[str, "_models.CardinalityValue"]] = None,
        constraints: Optional[List["_models.AtlasConstraintDef"]] = None,
        default_value: Optional[str] = None,
        description: Optional[str] = None,
        include_in_notification: Optional[bool] = None,
        is_indexable: Optional[bool] = None,
        is_optional: Optional[bool] = None,
        is_unique: Optional[bool] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        type_name: Optional[str] = None,
        values_max_count: Optional[int] = None,
        values_min_count: Optional[int] = None,
        is_legacy_attribute: Optional[bool] = None,
        relationship_type_name: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasRelationshipDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """AtlasRelationshipDef is a TypeDef that defines a relationship.
    As with other typeDefs the AtlasRelationshipDef has a name. Once created the
    RelationshipDef has a guid.
    The name and the guid are the 2 ways that the
    RelationshipDef is identified.
    RelationshipDefs have 2 ends, each of which
    specify cardinality, an EntityDef type name and name and optionally
    whether the
    end is a container.
    RelationshipDefs can have AttributeDefs - though only
    primitive types are allowed.
    RelationshipDefs have a relationshipCategory
    specifying the UML type of relationship required
    The way EntityDefs and
    RelationshipDefs are intended to be used is that EntityDefs will define
    AttributeDefs these AttributeDefs
    will not specify an EntityDef type name as
    their types.
    RelationshipDefs introduce new attributes to the entity
    instances. For example
    EntityDef A might have attributes attr1,attr2,attr3

    EntityDef B might have attributes attr4,attr5,attr6
    RelationshipDef
    AtoB might define 2 ends

    end1:  type A, name attr7
    end2:  type B, name attr8

    When an instance of EntityDef A is created, it
    will have attributes attr1,attr2,attr3,attr7
    When an instance of EntityDef
    B is created, it will have attributes attr4,attr5,attr6,attr8

    In this way
    relationshipDefs can be authored separately from entityDefs and can inject
    relationship attributes into
    the entity instances.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar date_formatter: The date format.
    :vartype date_formatter: ~azure.purview.datamap.models.DateFormat
    :ivar description: The description of the type definition.
    :vartype description: str
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    :ivar options: The options for the type definition.
    :vartype options: dict[str, str]
    :ivar service_type: The service type.
    :vartype service_type: str
    :ivar type_version: The version of the type.
    :vartype type_version: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the record.
    :vartype version: int
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar attribute_defs: An array of attribute definitions.
    :vartype attribute_defs: list[~azure.purview.datamap.models.AtlasAttributeDef]
    :ivar end_def1: The relationshipEndDef represents an end of the relationship. The end of the
     relationship is defined by a type, an
     attribute name, cardinality and whether
     it  is the container end of the relationship.
    :vartype end_def1: ~azure.purview.datamap.models.AtlasRelationshipEndDef
    :ivar end_def2: The relationshipEndDef represents an end of the relationship. The end of the
     relationship is defined by a type, an
     attribute name, cardinality and whether
     it  is the container end of the relationship.
    :vartype end_def2: ~azure.purview.datamap.models.AtlasRelationshipEndDef
    :ivar relationship_category: The Relationship category determines the style of relationship
     around
     containment and lifecycle.
     UML terminology is used for the values.
     ASSOCIATION is a relationship with no containment.
     COMPOSITION and AGGREGATION are containment relationships.
     The difference being in the lifecycles of the container and its children.
     In the COMPOSITION case, the children cannot exist without the container.
     For AGGREGATION, the life cycles of the container and children are totally independent. Known
     values are: "ASSOCIATION", "AGGREGATION", and "COMPOSITION".
    :vartype relationship_category: str or ~azure.purview.datamap.models.RelationshipCategory
    :ivar relationship_label: The label of the relationship.
    :vartype relationship_label: str
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    date_formatter: Optional["_models.DateFormat"] = rest_field(name="dateFormatter")
    """The date format."""
    description: Optional[str] = rest_field()
    """The description of the type definition."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the type definition."""
    service_type: Optional[str] = rest_field(name="serviceType")
    """The service type."""
    type_version: Optional[str] = rest_field(name="typeVersion")
    """The version of the type."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the record."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = rest_field(name="attributeDefs")
    """An array of attribute definitions."""
    end_def1: Optional["_models.AtlasRelationshipEndDef"] = rest_field(name="endDef1")
    """The relationshipEndDef represents an end of the relationship. The end of the
     relationship is defined by a type, an
     attribute name, cardinality and whether
     it  is the container end of the relationship."""
    end_def2: Optional["_models.AtlasRelationshipEndDef"] = rest_field(name="endDef2")
    """The relationshipEndDef represents an end of the relationship. The end of the
     relationship is defined by a type, an
     attribute name, cardinality and whether
     it  is the container end of the relationship."""
    relationship_category: Optional[Union[str, "_models.RelationshipCategory"]] = rest_field(
        name="relationshipCategory"
    )
    """The Relationship category determines the style of relationship around
     containment and lifecycle.
     UML terminology is used for the values.
     ASSOCIATION is a relationship with no containment.
     COMPOSITION and AGGREGATION are containment relationships.
     The difference being in the lifecycles of the container and its children.
     In the COMPOSITION case, the children cannot exist without the container.
     For AGGREGATION, the life cycles of the container and children are totally independent. Known
     values are: \"ASSOCIATION\", \"AGGREGATION\", and \"COMPOSITION\"."""
    relationship_label: Optional[str] = rest_field(name="relationshipLabel")
    """The label of the relationship."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        date_formatter: Optional["_models.DateFormat"] = None,
        description: Optional[str] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        service_type: Optional[str] = None,
        type_version: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        last_modified_t_s: Optional[str] = None,
        attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = None,
        end_def1: Optional["_models.AtlasRelationshipEndDef"] = None,
        end_def2: Optional["_models.AtlasRelationshipEndDef"] = None,
        relationship_category: Optional[Union[str, "_models.RelationshipCategory"]] = None,
        relationship_label: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasRelationshipEndDef(_model_base.Model):
    """The relationshipEndDef represents an end of the relationship. The end of the
    relationship is defined by a type, an
    attribute name, cardinality and whether
    it  is the container end of the relationship.

    :ivar cardinality: single-valued attribute or multi-valued attribute. Known values are:
     "SINGLE", "LIST", and "SET".
    :vartype cardinality: str or ~azure.purview.datamap.models.CardinalityValue
    :ivar description: The description of the relationship end definition.
    :vartype description: str
    :ivar is_container: Determines if it is container.
    :vartype is_container: bool
    :ivar is_legacy_attribute: Determines if it is a legacy attribute.
    :vartype is_legacy_attribute: bool
    :ivar name: The name of the relationship end definition.
    :vartype name: str
    :ivar type: The type of the relationship end.
    :vartype type: str
    """

    cardinality: Optional[Union[str, "_models.CardinalityValue"]] = rest_field()
    """single-valued attribute or multi-valued attribute. Known values are: \"SINGLE\", \"LIST\", and
     \"SET\"."""
    description: Optional[str] = rest_field()
    """The description of the relationship end definition."""
    is_container: Optional[bool] = rest_field(name="isContainer")
    """Determines if it is container."""
    is_legacy_attribute: Optional[bool] = rest_field(name="isLegacyAttribute")
    """Determines if it is a legacy attribute."""
    name: Optional[str] = rest_field()
    """The name of the relationship end definition."""
    type: Optional[str] = rest_field()
    """The type of the relationship end."""

    @overload
    def __init__(
        self,
        *,
        cardinality: Optional[Union[str, "_models.CardinalityValue"]] = None,
        description: Optional[str] = None,
        is_container: Optional[bool] = None,
        is_legacy_attribute: Optional[bool] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasRelationshipWithExtInfo(_model_base.Model):
    """The relationship with extended information.

    :ivar referred_entities: The referred entity header.
    :vartype referred_entities: dict[str, ~azure.purview.datamap.models.AtlasEntityHeader]
    :ivar relationship: Atlas relationship instance.
    :vartype relationship: ~azure.purview.datamap.models.AtlasRelationship
    """

    referred_entities: Optional[Dict[str, "_models.AtlasEntityHeader"]] = rest_field(name="referredEntities")
    """The referred entity header."""
    relationship: Optional["_models.AtlasRelationship"] = rest_field()
    """Atlas relationship instance."""

    @overload
    def __init__(
        self,
        *,
        referred_entities: Optional[Dict[str, "_models.AtlasEntityHeader"]] = None,
        relationship: Optional["_models.AtlasRelationship"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasStruct(_model_base.Model):
    """Captures details of struct contents. Not instantiated directly, used only via
    AtlasEntity, AtlasClassification.

    :ivar attributes: The attributes of the struct.
    :vartype attributes: dict[str, any]
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    """

    attributes: Optional[Dict[str, Any]] = rest_field()
    """The attributes of the struct."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional[Dict[str, Any]] = None,
        type_name: Optional[str] = None,
        last_modified_t_s: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasStructDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """class that captures details of a struct-type.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar date_formatter: The date format.
    :vartype date_formatter: ~azure.purview.datamap.models.DateFormat
    :ivar description: The description of the type definition.
    :vartype description: str
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    :ivar options: The options for the type definition.
    :vartype options: dict[str, str]
    :ivar service_type: The service type.
    :vartype service_type: str
    :ivar type_version: The version of the type.
    :vartype type_version: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the record.
    :vartype version: int
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar attribute_defs: An array of attribute definitions.
    :vartype attribute_defs: list[~azure.purview.datamap.models.AtlasAttributeDef]
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    date_formatter: Optional["_models.DateFormat"] = rest_field(name="dateFormatter")
    """The date format."""
    description: Optional[str] = rest_field()
    """The description of the type definition."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the type definition."""
    service_type: Optional[str] = rest_field(name="serviceType")
    """The service type."""
    type_version: Optional[str] = rest_field(name="typeVersion")
    """The version of the type."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the record."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = rest_field(name="attributeDefs")
    """An array of attribute definitions."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        date_formatter: Optional["_models.DateFormat"] = None,
        description: Optional[str] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        service_type: Optional[str] = None,
        type_version: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        last_modified_t_s: Optional[str] = None,
        attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasTermAssignmentHeader(_model_base.Model):
    """The header for term assignment.

    :ivar confidence: The confidence of the term assignment.
    :vartype confidence: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar description: The description of the term assignment.
    :vartype description: str
    :ivar display_text: The display text.
    :vartype display_text: str
    :ivar expression: The expression of the term assignment.
    :vartype expression: str
    :ivar relation_guid: The GUID of the relationship.
    :vartype relation_guid: str
    :ivar status: The status of terms assignment. Known values are: "DISCOVERED", "PROPOSED",
     "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
    :vartype status: str or ~azure.purview.datamap.models.AtlasTermAssignmentStatus
    :ivar steward: The steward of the term.
    :vartype steward: str
    :ivar term_guid: The GUID of the term.
    :vartype term_guid: str
    """

    confidence: Optional[int] = rest_field()
    """The confidence of the term assignment."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    description: Optional[str] = rest_field()
    """The description of the term assignment."""
    display_text: Optional[str] = rest_field(name="displayText")
    """The display text."""
    expression: Optional[str] = rest_field()
    """The expression of the term assignment."""
    relation_guid: Optional[str] = rest_field(name="relationGuid")
    """The GUID of the relationship."""
    status: Optional[Union[str, "_models.AtlasTermAssignmentStatus"]] = rest_field()
    """The status of terms assignment. Known values are: \"DISCOVERED\", \"PROPOSED\", \"IMPORTED\",
     \"VALIDATED\", \"DEPRECATED\", \"OBSOLETE\", and \"OTHER\"."""
    steward: Optional[str] = rest_field()
    """The steward of the term."""
    term_guid: Optional[str] = rest_field(name="termGuid")
    """The GUID of the term."""

    @overload
    def __init__(
        self,
        *,
        confidence: Optional[int] = None,
        created_by: Optional[str] = None,
        description: Optional[str] = None,
        display_text: Optional[str] = None,
        expression: Optional[str] = None,
        relation_guid: Optional[str] = None,
        status: Optional[Union[str, "_models.AtlasTermAssignmentStatus"]] = None,
        steward: Optional[str] = None,
        term_guid: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasTermCategorizationHeader(_model_base.Model):
    """The basic information for term categorization.

    :ivar category_guid: The GUID of the category.
    :vartype category_guid: str
    :ivar description: The description of the record.
    :vartype description: str
    :ivar display_text: The display text.
    :vartype display_text: str
    :ivar relation_guid: The GUID of the relationship.
    :vartype relation_guid: str
    :ivar status: The status of term relationship. Known values are: "DRAFT", "ACTIVE",
     "DEPRECATED", "OBSOLETE", and "OTHER".
    :vartype status: str or ~azure.purview.datamap.models.AtlasTermRelationshipStatus
    """

    category_guid: Optional[str] = rest_field(name="categoryGuid")
    """The GUID of the category."""
    description: Optional[str] = rest_field()
    """The description of the record."""
    display_text: Optional[str] = rest_field(name="displayText")
    """The display text."""
    relation_guid: Optional[str] = rest_field(name="relationGuid")
    """The GUID of the relationship."""
    status: Optional[Union[str, "_models.AtlasTermRelationshipStatus"]] = rest_field()
    """The status of term relationship. Known values are: \"DRAFT\", \"ACTIVE\", \"DEPRECATED\",
     \"OBSOLETE\", and \"OTHER\"."""

    @overload
    def __init__(
        self,
        *,
        category_guid: Optional[str] = None,
        description: Optional[str] = None,
        display_text: Optional[str] = None,
        relation_guid: Optional[str] = None,
        status: Optional[Union[str, "_models.AtlasTermRelationshipStatus"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasTypeDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The definitions of type.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar date_formatter: The date format.
    :vartype date_formatter: ~azure.purview.datamap.models.DateFormat
    :ivar description: The description of the type definition.
    :vartype description: str
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    :ivar options: The options for the type definition.
    :vartype options: dict[str, str]
    :ivar service_type: The service type.
    :vartype service_type: str
    :ivar type_version: The version of the type.
    :vartype type_version: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the record.
    :vartype version: int
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar entity_types: Specifying a list of entityType names in the classificationDef, ensures
     that
     classifications can
     only be applied to those entityTypes.

     Any subtypes of the entity types inherit the restriction.

     Any classificationDef subtypes inherit the parents entityTypes restrictions.

     Any classificationDef subtypes can further restrict the parents entityTypes
     restrictions by specifying a subset of the entityTypes.

     An empty entityTypes list when there are no parent restrictions means there are no
     restrictions.

     An empty entityTypes list when there are parent
     restrictions means that the subtype picks up the parents
     restrictions.

     If a list of entityTypes are supplied, where one inherits
     from another, this will be rejected. This should encourage cleaner
     classificationsDefs.
    :vartype entity_types: list[str]
    :ivar sub_types: An array of sub types.
    :vartype sub_types: list[str]
    :ivar super_types: An array of super types.
    :vartype super_types: list[str]
    :ivar relationship_attribute_defs: An array of relationship attributes.
    :vartype relationship_attribute_defs:
     list[~azure.purview.datamap.models.AtlasRelationshipAttributeDef]
    :ivar default_value: The default value.
    :vartype default_value: str
    :ivar element_defs: An array of enum element definitions.
    :vartype element_defs: list[~azure.purview.datamap.models.AtlasEnumElementDef]
    :ivar end_def1: The relationshipEndDef represents an end of the relationship. The end of the
     relationship is defined by a type, an
     attribute name, cardinality and whether
     it  is the container end of the relationship.
    :vartype end_def1: ~azure.purview.datamap.models.AtlasRelationshipEndDef
    :ivar end_def2: The relationshipEndDef represents an end of the relationship. The end of the
     relationship is defined by a type, an
     attribute name, cardinality and whether
     it  is the container end of the relationship.
    :vartype end_def2: ~azure.purview.datamap.models.AtlasRelationshipEndDef
    :ivar relationship_category: The Relationship category determines the style of relationship
     around
     containment and lifecycle.
     UML terminology is used for the values.

     ASSOCIATION is a relationship with no containment.
     COMPOSITION and AGGREGATION are containment relationships.

     The difference being in the lifecycles of the container and its children.
     In the COMPOSITION case, the children cannot exist without the container.
     For AGGREGATION, the life cycles of the container and children are totally independent. Known
     values are: "ASSOCIATION", "AGGREGATION", and "COMPOSITION".
    :vartype relationship_category: str or ~azure.purview.datamap.models.RelationshipCategory
    :ivar relationship_label: The label of the relationship.
    :vartype relationship_label: str
    :ivar attribute_defs: An array of attribute definitions.
    :vartype attribute_defs: list[~azure.purview.datamap.models.AtlasAttributeDef]
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    date_formatter: Optional["_models.DateFormat"] = rest_field(name="dateFormatter")
    """The date format."""
    description: Optional[str] = rest_field()
    """The description of the type definition."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the type definition."""
    service_type: Optional[str] = rest_field(name="serviceType")
    """The service type."""
    type_version: Optional[str] = rest_field(name="typeVersion")
    """The version of the type."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the record."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    entity_types: Optional[List[str]] = rest_field(name="entityTypes")
    """Specifying a list of entityType names in the classificationDef, ensures that
     classifications can
     only be applied to those entityTypes.
     
     Any subtypes of the entity types inherit the restriction.
     
     Any classificationDef subtypes inherit the parents entityTypes restrictions.
     
     Any classificationDef subtypes can further restrict the parents entityTypes
     restrictions by specifying a subset of the entityTypes.
     
     An empty entityTypes list when there are no parent restrictions means there are no
     restrictions.
     
     An empty entityTypes list when there are parent
     restrictions means that the subtype picks up the parents
     restrictions.
     
     If a list of entityTypes are supplied, where one inherits
     from another, this will be rejected. This should encourage cleaner
     classificationsDefs."""
    sub_types: Optional[List[str]] = rest_field(name="subTypes")
    """An array of sub types."""
    super_types: Optional[List[str]] = rest_field(name="superTypes")
    """An array of super types."""
    relationship_attribute_defs: Optional[List["_models.AtlasRelationshipAttributeDef"]] = rest_field(
        name="relationshipAttributeDefs"
    )
    """An array of relationship attributes."""
    default_value: Optional[str] = rest_field(name="defaultValue")
    """The default value."""
    element_defs: Optional[List["_models.AtlasEnumElementDef"]] = rest_field(name="elementDefs")
    """An array of enum element definitions."""
    end_def1: Optional["_models.AtlasRelationshipEndDef"] = rest_field(name="endDef1")
    """The relationshipEndDef represents an end of the relationship. The end of the
     relationship is defined by a type, an
     attribute name, cardinality and whether
     it  is the container end of the relationship."""
    end_def2: Optional["_models.AtlasRelationshipEndDef"] = rest_field(name="endDef2")
    """The relationshipEndDef represents an end of the relationship. The end of the
     relationship is defined by a type, an
     attribute name, cardinality and whether
     it  is the container end of the relationship."""
    relationship_category: Optional[Union[str, "_models.RelationshipCategory"]] = rest_field(
        name="relationshipCategory"
    )
    """The Relationship category determines the style of relationship around
     containment and lifecycle.
     UML terminology is used for the values.
     
     ASSOCIATION is a relationship with no containment.
     COMPOSITION and AGGREGATION are containment relationships.
     
     The difference being in the lifecycles of the container and its children.
     In the COMPOSITION case, the children cannot exist without the container.
     For AGGREGATION, the life cycles of the container and children are totally independent. Known
     values are: \"ASSOCIATION\", \"AGGREGATION\", and \"COMPOSITION\"."""
    relationship_label: Optional[str] = rest_field(name="relationshipLabel")
    """The label of the relationship."""
    attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = rest_field(name="attributeDefs")
    """An array of attribute definitions."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        date_formatter: Optional["_models.DateFormat"] = None,
        description: Optional[str] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        service_type: Optional[str] = None,
        type_version: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        last_modified_t_s: Optional[str] = None,
        entity_types: Optional[List[str]] = None,
        sub_types: Optional[List[str]] = None,
        super_types: Optional[List[str]] = None,
        relationship_attribute_defs: Optional[List["_models.AtlasRelationshipAttributeDef"]] = None,
        default_value: Optional[str] = None,
        element_defs: Optional[List["_models.AtlasEnumElementDef"]] = None,
        end_def1: Optional["_models.AtlasRelationshipEndDef"] = None,
        end_def2: Optional["_models.AtlasRelationshipEndDef"] = None,
        relationship_category: Optional[Union[str, "_models.RelationshipCategory"]] = None,
        relationship_label: Optional[str] = None,
        attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasTypeDefHeader(_model_base.Model):
    """The basic information of the type definition.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AtlasTypesDef(_model_base.Model):
    """The definitions of types.

    :ivar business_metadata_defs: businessMetadataDefs.
    :vartype business_metadata_defs: list[~azure.purview.datamap.models.AtlasBusinessMetadataDef]
    :ivar classification_defs: An array of classification definitions.
    :vartype classification_defs: list[~azure.purview.datamap.models.AtlasClassificationDef]
    :ivar entity_defs: An array of entity definitions.
    :vartype entity_defs: list[~azure.purview.datamap.models.AtlasEntityDef]
    :ivar enum_defs: An array of enum definitions.
    :vartype enum_defs: list[~azure.purview.datamap.models.AtlasEnumDef]
    :ivar relationship_defs: An array of relationship definitions.
    :vartype relationship_defs: list[~azure.purview.datamap.models.AtlasRelationshipDef]
    :ivar struct_defs: An array of struct definitions.
    :vartype struct_defs: list[~azure.purview.datamap.models.AtlasStructDef]
    :ivar term_template_defs: An array of term template definitions.
    :vartype term_template_defs: list[~azure.purview.datamap.models.TermTemplateDef]
    """

    business_metadata_defs: Optional[List["_models.AtlasBusinessMetadataDef"]] = rest_field(name="businessMetadataDefs")
    """businessMetadataDefs."""
    classification_defs: Optional[List["_models.AtlasClassificationDef"]] = rest_field(name="classificationDefs")
    """An array of classification definitions."""
    entity_defs: Optional[List["_models.AtlasEntityDef"]] = rest_field(name="entityDefs")
    """An array of entity definitions."""
    enum_defs: Optional[List["_models.AtlasEnumDef"]] = rest_field(name="enumDefs")
    """An array of enum definitions."""
    relationship_defs: Optional[List["_models.AtlasRelationshipDef"]] = rest_field(name="relationshipDefs")
    """An array of relationship definitions."""
    struct_defs: Optional[List["_models.AtlasStructDef"]] = rest_field(name="structDefs")
    """An array of struct definitions."""
    term_template_defs: Optional[List["_models.TermTemplateDef"]] = rest_field(name="termTemplateDefs")
    """An array of term template definitions."""

    @overload
    def __init__(
        self,
        *,
        business_metadata_defs: Optional[List["_models.AtlasBusinessMetadataDef"]] = None,
        classification_defs: Optional[List["_models.AtlasClassificationDef"]] = None,
        entity_defs: Optional[List["_models.AtlasEntityDef"]] = None,
        enum_defs: Optional[List["_models.AtlasEnumDef"]] = None,
        relationship_defs: Optional[List["_models.AtlasRelationshipDef"]] = None,
        struct_defs: Optional[List["_models.AtlasStructDef"]] = None,
        term_template_defs: Optional[List["_models.TermTemplateDef"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AutoCompleteOptions(_model_base.Model):
    """The payload of autocomplete request.

    :ivar keywords: The keywords applied to all fields that support autocomplete operation. It must
     be at least 1 character, and no more than 100 characters.
    :vartype keywords: str
    :ivar limit: The number of autocomplete results we hope to return. The default value is 50.
     The value must be a number between 1 and 100.
    :vartype limit: int
    :ivar filter: The filter for the autocomplete request.
    :vartype filter: any
    """

    keywords: Optional[str] = rest_field()
    """The keywords applied to all fields that support autocomplete operation. It must
     be at least 1 character, and no more than 100 characters."""
    limit: Optional[int] = rest_field()
    """The number of autocomplete results we hope to return. The default value is 50.
     The value must be a number between 1 and 100."""
    filter: Optional[Any] = rest_field()
    """The filter for the autocomplete request."""

    @overload
    def __init__(
        self,
        *,
        keywords: Optional[str] = None,
        limit: Optional[int] = None,
        filter: Optional[Any] = None,  # pylint: disable=redefined-builtin
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AutoCompleteResult(_model_base.Model):
    """The result of the autocomplete request.

    :ivar value: The result value.
    :vartype value: list[~azure.purview.datamap.models.AutoCompleteResultValue]
    """

    value: Optional[List["_models.AutoCompleteResultValue"]] = rest_field()
    """The result value."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[List["_models.AutoCompleteResultValue"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AutoCompleteResultValue(_model_base.Model):
    """The value item of the autocomplete suggest.

    :ivar text: The completed term or phrase.
    :vartype text: str
    :ivar query_plus_text: The completed search query text.
    :vartype query_plus_text: str
    """

    text: Optional[str] = rest_field()
    """The completed term or phrase."""
    query_plus_text: Optional[str] = rest_field(name="queryPlusText")
    """The completed search query text."""

    @overload
    def __init__(
        self,
        *,
        text: Optional[str] = None,
        query_plus_text: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BulkImportResult(_model_base.Model):
    """Bulk import result.

    :ivar failed_import_info_list: failed importInfoList.
    :vartype failed_import_info_list: list[~azure.purview.datamap.models.ImportInfo]
    :ivar success_import_info_list: successful importInfoList.
    :vartype success_import_info_list: list[~azure.purview.datamap.models.ImportInfo]
    """

    failed_import_info_list: Optional[List["_models.ImportInfo"]] = rest_field(name="failedImportInfoList")
    """failed importInfoList."""
    success_import_info_list: Optional[List["_models.ImportInfo"]] = rest_field(name="successImportInfoList")
    """successful importInfoList."""

    @overload
    def __init__(
        self,
        *,
        failed_import_info_list: Optional[List["_models.ImportInfo"]] = None,
        success_import_info_list: Optional[List["_models.ImportInfo"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BusinessMetadataOptions(_model_base.Model):
    """Business metadata to send to the service.

    All required parameters must be populated in order to send to server.

    :ivar file: InputStream of file. Required.
    :vartype file: bytes
    """

    file: FileType = rest_field(is_multipart_file_input=True)
    """InputStream of file. Required."""

    @overload
    def __init__(
        self,
        *,
        file: FileType,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ClassificationAssociateOptions(_model_base.Model):
    """The request payload for classification association.

    :ivar classification: An instance of a classification; it doesn't have an identity, this object
     exists only when associated with an entity.
    :vartype classification: ~azure.purview.datamap.models.AtlasClassification
    :ivar entity_guids: The GUID of the entity.
    :vartype entity_guids: list[str]
    """

    classification: Optional["_models.AtlasClassification"] = rest_field()
    """An instance of a classification; it doesn't have an identity, this object
     exists only when associated with an entity."""
    entity_guids: Optional[List[str]] = rest_field(name="entityGuids")
    """The GUID of the entity."""

    @overload
    def __init__(
        self,
        *,
        classification: Optional["_models.AtlasClassification"] = None,
        entity_guids: Optional[List[str]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ContactInfo(_model_base.Model):
    """ContactInfo.

    :ivar id: Azure Active Directory object Id.
    :vartype id: str
    :ivar info: additional information to describe this contact.
    :vartype info: str
    """

    id: Optional[str] = rest_field()
    """Azure Active Directory object Id."""
    info: Optional[str] = rest_field()
    """additional information to describe this contact."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        info: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ContactSearchResultValue(_model_base.Model):
    """The contact in the search and suggest result.

    :ivar id: The GUID of the contact.
    :vartype id: str
    :ivar info: The description of the contact.
    :vartype info: str
    :ivar contact_type: The type of the contact. It can be Expert or Owner for an entity. It can be
     Expert or Steward for a glossary term.
    :vartype contact_type: str
    """

    id: Optional[str] = rest_field()
    """The GUID of the contact."""
    info: Optional[str] = rest_field()
    """The description of the contact."""
    contact_type: Optional[str] = rest_field(name="contactType")
    """The type of the contact. It can be Expert or Owner for an entity. It can be
     Expert or Steward for a glossary term."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        info: Optional[str] = None,
        contact_type: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DateFormat(_model_base.Model):
    """The date format.

    :ivar available_locales: An array of available locales.
    :vartype available_locales: list[str]
    :ivar calendar: Calendar.
    :vartype calendar: float
    :ivar date_instance: The date format.
    :vartype date_instance: ~azure.purview.datamap.models.DateFormat
    :ivar date_time_instance: The date format.
    :vartype date_time_instance: ~azure.purview.datamap.models.DateFormat
    :ivar instance: The date format.
    :vartype instance: ~azure.purview.datamap.models.DateFormat
    :ivar lenient: Determines the leniency of the date format.
    :vartype lenient: bool
    :ivar number_format: The number format.
    :vartype number_format: ~azure.purview.datamap.models.NumberFormat
    :ivar time_instance: The date format.
    :vartype time_instance: ~azure.purview.datamap.models.DateFormat
    :ivar time_zone: The timezone information.
    :vartype time_zone: ~azure.purview.datamap.models.TimeZone
    """

    available_locales: Optional[List[str]] = rest_field(name="availableLocales")
    """An array of available locales."""
    calendar: Optional[float] = rest_field()
    """Calendar."""
    date_instance: Optional["_models.DateFormat"] = rest_field(name="dateInstance")
    """The date format."""
    date_time_instance: Optional["_models.DateFormat"] = rest_field(name="dateTimeInstance")
    """The date format."""
    instance: Optional["_models.DateFormat"] = rest_field()
    """The date format."""
    lenient: Optional[bool] = rest_field()
    """Determines the leniency of the date format."""
    number_format: Optional["_models.NumberFormat"] = rest_field(name="numberFormat")
    """The number format."""
    time_instance: Optional["_models.DateFormat"] = rest_field(name="timeInstance")
    """The date format."""
    time_zone: Optional["_models.TimeZone"] = rest_field(name="timeZone")
    """The timezone information."""

    @overload
    def __init__(
        self,
        *,
        available_locales: Optional[List[str]] = None,
        calendar: Optional[float] = None,
        date_instance: Optional["_models.DateFormat"] = None,
        date_time_instance: Optional["_models.DateFormat"] = None,
        instance: Optional["_models.DateFormat"] = None,
        lenient: Optional[bool] = None,
        number_format: Optional["_models.NumberFormat"] = None,
        time_instance: Optional["_models.DateFormat"] = None,
        time_zone: Optional["_models.TimeZone"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class EntityMutationResult(_model_base.Model):
    """The mutation response result of entity.

    :ivar guid_assignments: A map of GUID assignments with entities.
    :vartype guid_assignments: dict[str, str]
    :ivar mutated_entities: The entity headers of mutated entities.
    :vartype mutated_entities: dict[str, list[~azure.purview.datamap.models.AtlasEntityHeader]]
    :ivar partial_updated_entities: An array of entity headers that partially updated.
    :vartype partial_updated_entities: list[~azure.purview.datamap.models.AtlasEntityHeader]
    """

    guid_assignments: Optional[Dict[str, str]] = rest_field(name="guidAssignments")
    """A map of GUID assignments with entities."""
    mutated_entities: Optional[Dict[str, List["_models.AtlasEntityHeader"]]] = rest_field(name="mutatedEntities")
    """The entity headers of mutated entities."""
    partial_updated_entities: Optional[List["_models.AtlasEntityHeader"]] = rest_field(name="partialUpdatedEntities")
    """An array of entity headers that partially updated."""

    @overload
    def __init__(
        self,
        *,
        guid_assignments: Optional[Dict[str, str]] = None,
        mutated_entities: Optional[Dict[str, List["_models.AtlasEntityHeader"]]] = None,
        partial_updated_entities: Optional[List["_models.AtlasEntityHeader"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ImportInfo(_model_base.Model):
    """ImportInfo.

    :ivar child_object_name: childObjectName.
    :vartype child_object_name: str
    :ivar import_status: importStatus. Known values are: "SUCCESS" and "FAILED".
    :vartype import_status: str or ~azure.purview.datamap.models.ImportStatus
    :ivar parent_object_name: parentObjectName.
    :vartype parent_object_name: str
    :ivar remarks: remarks.
    :vartype remarks: str
    """

    child_object_name: Optional[str] = rest_field(name="childObjectName")
    """childObjectName."""
    import_status: Optional[Union[str, "_models.ImportStatus"]] = rest_field(name="importStatus")
    """importStatus. Known values are: \"SUCCESS\" and \"FAILED\"."""
    parent_object_name: Optional[str] = rest_field(name="parentObjectName")
    """parentObjectName."""
    remarks: Optional[str] = rest_field()
    """remarks."""

    @overload
    def __init__(
        self,
        *,
        child_object_name: Optional[str] = None,
        import_status: Optional[Union[str, "_models.ImportStatus"]] = None,
        parent_object_name: Optional[str] = None,
        remarks: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LineageRelation(_model_base.Model):
    """The lineage relation with GUID of the from and to entity.

    :ivar from_entity_id: The GUID of from-entity.
    :vartype from_entity_id: str
    :ivar relationship_id: The GUID of relationship.
    :vartype relationship_id: str
    :ivar to_entity_id: The GUID of to-entity.
    :vartype to_entity_id: str
    """

    from_entity_id: Optional[str] = rest_field(name="fromEntityId")
    """The GUID of from-entity."""
    relationship_id: Optional[str] = rest_field(name="relationshipId")
    """The GUID of relationship."""
    to_entity_id: Optional[str] = rest_field(name="toEntityId")
    """The GUID of to-entity."""

    @overload
    def __init__(
        self,
        *,
        from_entity_id: Optional[str] = None,
        relationship_id: Optional[str] = None,
        to_entity_id: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MoveEntitiesOptions(_model_base.Model):
    """MoveEntitiesOptions.

    :ivar entity_guids: An array of entity guids to be moved to target collection.
    :vartype entity_guids: list[str]
    """

    entity_guids: Optional[List[str]] = rest_field(name="entityGuids")
    """An array of entity guids to be moved to target collection."""

    @overload
    def __init__(
        self,
        *,
        entity_guids: Optional[List[str]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class NumberFormat(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The number format.

    :ivar available_locales: The number format.
    :vartype available_locales: list[str]
    :ivar currency: The currency.
    :vartype currency: str
    :ivar currency_instance: The number format.
    :vartype currency_instance: ~azure.purview.datamap.models.NumberFormat
    :ivar grouping_used: Determines if grouping is used.
    :vartype grouping_used: bool
    :ivar instance: The number format.
    :vartype instance: ~azure.purview.datamap.models.NumberFormat
    :ivar integer_instance: The number format.
    :vartype integer_instance: ~azure.purview.datamap.models.NumberFormat
    :ivar maximum_fraction_digits: The maximum of fraction digits.
    :vartype maximum_fraction_digits: int
    :ivar maximum_integer_digits: The maximum of integer digits.
    :vartype maximum_integer_digits: int
    :ivar minimum_fraction_digits: The minimum of fraction digits.
    :vartype minimum_fraction_digits: int
    :ivar minimum_integer_digits: The minimum of integer digits.
    :vartype minimum_integer_digits: int
    :ivar number_instance: The number format.
    :vartype number_instance: ~azure.purview.datamap.models.NumberFormat
    :ivar parse_integer_only: Determines if only integer is parsed.
    :vartype parse_integer_only: bool
    :ivar percent_instance: The number format.
    :vartype percent_instance: ~azure.purview.datamap.models.NumberFormat
    :ivar rounding_mode: The enum of rounding mode. Known values are: "UP", "DOWN", "CEILING",
     "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", and "UNNECESSARY".
    :vartype rounding_mode: str or ~azure.purview.datamap.models.RoundingMode
    """

    available_locales: Optional[List[str]] = rest_field(name="availableLocales")
    """The number format."""
    currency: Optional[str] = rest_field()
    """The currency."""
    currency_instance: Optional["_models.NumberFormat"] = rest_field(name="currencyInstance")
    """The number format."""
    grouping_used: Optional[bool] = rest_field(name="groupingUsed")
    """Determines if grouping is used."""
    instance: Optional["_models.NumberFormat"] = rest_field()
    """The number format."""
    integer_instance: Optional["_models.NumberFormat"] = rest_field(name="integerInstance")
    """The number format."""
    maximum_fraction_digits: Optional[int] = rest_field(name="maximumFractionDigits")
    """The maximum of fraction digits."""
    maximum_integer_digits: Optional[int] = rest_field(name="maximumIntegerDigits")
    """The maximum of integer digits."""
    minimum_fraction_digits: Optional[int] = rest_field(name="minimumFractionDigits")
    """The minimum of fraction digits."""
    minimum_integer_digits: Optional[int] = rest_field(name="minimumIntegerDigits")
    """The minimum of integer digits."""
    number_instance: Optional["_models.NumberFormat"] = rest_field(name="numberInstance")
    """The number format."""
    parse_integer_only: Optional[bool] = rest_field(name="parseIntegerOnly")
    """Determines if only integer is parsed."""
    percent_instance: Optional["_models.NumberFormat"] = rest_field(name="percentInstance")
    """The number format."""
    rounding_mode: Optional[Union[str, "_models.RoundingMode"]] = rest_field(name="roundingMode")
    """The enum of rounding mode. Known values are: \"UP\", \"DOWN\", \"CEILING\", \"FLOOR\",
     \"HALF_UP\", \"HALF_DOWN\", \"HALF_EVEN\", and \"UNNECESSARY\"."""

    @overload
    def __init__(
        self,
        *,
        available_locales: Optional[List[str]] = None,
        currency: Optional[str] = None,
        currency_instance: Optional["_models.NumberFormat"] = None,
        grouping_used: Optional[bool] = None,
        instance: Optional["_models.NumberFormat"] = None,
        integer_instance: Optional["_models.NumberFormat"] = None,
        maximum_fraction_digits: Optional[int] = None,
        maximum_integer_digits: Optional[int] = None,
        minimum_fraction_digits: Optional[int] = None,
        minimum_integer_digits: Optional[int] = None,
        number_instance: Optional["_models.NumberFormat"] = None,
        parse_integer_only: Optional[bool] = None,
        percent_instance: Optional["_models.NumberFormat"] = None,
        rounding_mode: Optional[Union[str, "_models.RoundingMode"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ParentRelation(_model_base.Model):
    """The lineage parents relation with GUID of the parent entity and to child entity.

    :ivar child_entity_id: The GUID of child entity.
    :vartype child_entity_id: str
    :ivar relationship_id: The GUID of relationship.
    :vartype relationship_id: str
    :ivar parent_entity_id: The GUID of parent entity.
    :vartype parent_entity_id: str
    """

    child_entity_id: Optional[str] = rest_field(name="childEntityId")
    """The GUID of child entity."""
    relationship_id: Optional[str] = rest_field(name="relationshipId")
    """The GUID of relationship."""
    parent_entity_id: Optional[str] = rest_field(name="parentEntityId")
    """The GUID of parent entity."""

    @overload
    def __init__(
        self,
        *,
        child_entity_id: Optional[str] = None,
        relationship_id: Optional[str] = None,
        parent_entity_id: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PurviewObjectId(_model_base.Model):
    """PurviewObjectId.

    :ivar guid: The GUID of the object.
    :vartype guid: str
    :ivar type_name: The name of the type.
    :vartype type_name: str
    :ivar unique_attributes: The unique attributes of the object.
    :vartype unique_attributes: dict[str, any]
    :ivar name: Name.
    :vartype name: str
    :ivar display_text: Display text.
    :vartype display_text: str
    :ivar item_path: Item path.
    :vartype item_path: str
    :ivar resource_id: Resource Id.
    :vartype resource_id: str
    :ivar properties: Dictionary of :code:`<any>`.
    :vartype properties: dict[str, any]
    """

    guid: Optional[str] = rest_field()
    """The GUID of the object."""
    type_name: Optional[str] = rest_field(name="typeName")
    """The name of the type."""
    unique_attributes: Optional[Dict[str, Any]] = rest_field(name="uniqueAttributes")
    """The unique attributes of the object."""
    name: Optional[str] = rest_field()
    """Name."""
    display_text: Optional[str] = rest_field(name="displayText")
    """Display text."""
    item_path: Optional[str] = rest_field(name="itemPath")
    """Item path."""
    resource_id: Optional[str] = rest_field(name="resourceId")
    """Resource Id."""
    properties: Optional[Dict[str, Any]] = rest_field()
    """Dictionary of :code:`<any>`."""

    @overload
    def __init__(
        self,
        *,
        guid: Optional[str] = None,
        type_name: Optional[str] = None,
        unique_attributes: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        display_text: Optional[str] = None,
        item_path: Optional[str] = None,
        resource_id: Optional[str] = None,
        properties: Optional[Dict[str, Any]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class QueryOptions(_model_base.Model):
    """The search query of advanced search request.

    :ivar keywords: The keywords applied to all searchable fields.
    :vartype keywords: str
    :ivar limit: The limit of the number of the search result. default value is 50; maximum
     value is 1000.
    :vartype limit: int
    :ivar continuation_token: The token used to get next batch of data. Default 'Null' to get the
     first
     batch, and will return new token in each response unless there's no more data.
    :vartype continuation_token: str
    :ivar orderby: The sort order of search results, can specify multiple fields.
    :vartype orderby: list[any]
    :ivar filter: The filter for the search. See examples for the usage of supported filters.
    :vartype filter: any
    :ivar facets: The facets for search. See examples for the usage of supported facets.
    :vartype facets: list[~azure.purview.datamap.models.SearchFacetItem]
    :ivar taxonomy_setting: The taxonomy setting for search.
    :vartype taxonomy_setting: ~azure.purview.datamap.models.SearchTaxonomySetting
    """

    keywords: Optional[str] = rest_field()
    """The keywords applied to all searchable fields."""
    limit: Optional[int] = rest_field()
    """The limit of the number of the search result. default value is 50; maximum
     value is 1000."""
    continuation_token: Optional[str] = rest_field(name="continuationToken")
    """The token used to get next batch of data. Default 'Null' to get the first
     batch, and will return new token in each response unless there's no more data."""
    orderby: Optional[List[Any]] = rest_field()
    """The sort order of search results, can specify multiple fields."""
    filter: Optional[Any] = rest_field()
    """The filter for the search. See examples for the usage of supported filters."""
    facets: Optional[List["_models.SearchFacetItem"]] = rest_field()
    """The facets for search. See examples for the usage of supported facets."""
    taxonomy_setting: Optional["_models.SearchTaxonomySetting"] = rest_field(name="taxonomySetting")
    """The taxonomy setting for search."""

    @overload
    def __init__(
        self,
        *,
        keywords: Optional[str] = None,
        limit: Optional[int] = None,
        continuation_token: Optional[str] = None,
        orderby: Optional[List[Any]] = None,
        filter: Optional[Any] = None,  # pylint: disable=redefined-builtin
        facets: Optional[List["_models.SearchFacetItem"]] = None,
        taxonomy_setting: Optional["_models.SearchTaxonomySetting"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class QueryResult(_model_base.Model):
    """The result of the search result.

    :ivar search_count: The total number of search results (not the number of documents in a single
     page).
    :vartype search_count: int
    :ivar search_count_approximate: 'True' if the '@search.count' is an approximate value and vise
     versa.
    :vartype search_count_approximate: bool
    :ivar continuation_token: The token used to get next batch of data. Absent if there's no more
     data.
    :vartype continuation_token: str
    :ivar search_facets: A facet list that consists of index fields assetType ,classification,
     contactId, and label. When the facet is specified in the request, the value of
     the facet is returned as an element of @search.facets.
    :vartype search_facets: ~azure.purview.datamap.models.SearchFacetResultValue
    :ivar value: Search result value.
    :vartype value: list[~azure.purview.datamap.models.SearchResultValue]
    """

    search_count: Optional[int] = rest_field(name="@search.count")
    """The total number of search results (not the number of documents in a single
     page)."""
    search_count_approximate: Optional[bool] = rest_field(name="@search.count.approximate")
    """'True' if the '@search.count' is an approximate value and vise versa."""
    continuation_token: Optional[str] = rest_field(name="continuationToken")
    """The token used to get next batch of data. Absent if there's no more data."""
    search_facets: Optional["_models.SearchFacetResultValue"] = rest_field(name="@search.facets")
    """A facet list that consists of index fields assetType ,classification,
     contactId, and label. When the facet is specified in the request, the value of
     the facet is returned as an element of @search.facets."""
    value: Optional[List["_models.SearchResultValue"]] = rest_field()
    """Search result value."""

    @overload
    def __init__(
        self,
        *,
        search_count: Optional[int] = None,
        search_count_approximate: Optional[bool] = None,
        continuation_token: Optional[str] = None,
        search_facets: Optional["_models.SearchFacetResultValue"] = None,
        value: Optional[List["_models.SearchResultValue"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceLink(_model_base.Model):
    """ResourceLink.

    :ivar display_name: Display name for url.
    :vartype display_name: str
    :ivar url: web url. http or https.
    :vartype url: str
    """

    display_name: Optional[str] = rest_field(name="displayName")
    """Display name for url."""
    url: Optional[str] = rest_field()
    """web url. http or https."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        url: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SearchFacetItem(_model_base.Model):
    """The content of a search facet result item.

    :ivar count: The count of the facet item.
    :vartype count: int
    :ivar facet: The name of the facet item.
    :vartype facet: str
    :ivar sort: Define the sorting criteria for items.
    :vartype sort: ~azure.purview.datamap.models.SearchFacetSort
    """

    count: Optional[int] = rest_field()
    """The count of the facet item."""
    facet: Optional[str] = rest_field()
    """The name of the facet item."""
    sort: Optional["_models.SearchFacetSort"] = rest_field()
    """Define the sorting criteria for items."""

    @overload
    def __init__(
        self,
        *,
        count: Optional[int] = None,
        facet: Optional[str] = None,
        sort: Optional["_models.SearchFacetSort"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SearchFacetItemValue(_model_base.Model):
    """The content of a search facet result item.

    :ivar count: The count of the facet item.
    :vartype count: int
    :ivar value: The name of the facet item.
    :vartype value: str
    """

    count: Optional[int] = rest_field()
    """The count of the facet item."""
    value: Optional[str] = rest_field()
    """The name of the facet item."""

    @overload
    def __init__(
        self,
        *,
        count: Optional[int] = None,
        value: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SearchFacetResultValue(_model_base.Model):
    """A facet list that consists of index fields assetType ,classification,
    contactId, and label. When the facet is specified in the request, the value of
    the facet is returned as an element of @search.facets.

    :ivar entity_type: Entity type.
    :vartype entity_type: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar asset_type: Asset type.
    :vartype asset_type: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar classification: Classification.
    :vartype classification: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar term: Term.
    :vartype term: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar contact_id: Contact id.
    :vartype contact_id: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar contact_type: Contact type.
    :vartype contact_type: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar label: Label.
    :vartype label: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar glossary_type: Glossary type.
    :vartype glossary_type: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar term_status: Term status.
    :vartype term_status: list[~azure.purview.datamap.models.SearchFacetItemValue]
    :ivar term_template: Term template.
    :vartype term_template: list[~azure.purview.datamap.models.SearchFacetItemValue]
    """

    entity_type: Optional[List["_models.SearchFacetItemValue"]] = rest_field(name="entityType")
    """Entity type."""
    asset_type: Optional[List["_models.SearchFacetItemValue"]] = rest_field(name="assetType")
    """Asset type."""
    classification: Optional[List["_models.SearchFacetItemValue"]] = rest_field()
    """Classification."""
    term: Optional[List["_models.SearchFacetItemValue"]] = rest_field()
    """Term."""
    contact_id: Optional[List["_models.SearchFacetItemValue"]] = rest_field(name="contactId")
    """Contact id."""
    contact_type: Optional[List["_models.SearchFacetItemValue"]] = rest_field(name="contactType")
    """Contact type."""
    label: Optional[List["_models.SearchFacetItemValue"]] = rest_field()
    """Label."""
    glossary_type: Optional[List["_models.SearchFacetItemValue"]] = rest_field(name="glossaryType")
    """Glossary type."""
    term_status: Optional[List["_models.SearchFacetItemValue"]] = rest_field(name="termStatus")
    """Term status."""
    term_template: Optional[List["_models.SearchFacetItemValue"]] = rest_field(name="termTemplate")
    """Term template."""

    @overload
    def __init__(
        self,
        *,
        entity_type: Optional[List["_models.SearchFacetItemValue"]] = None,
        asset_type: Optional[List["_models.SearchFacetItemValue"]] = None,
        classification: Optional[List["_models.SearchFacetItemValue"]] = None,
        term: Optional[List["_models.SearchFacetItemValue"]] = None,
        contact_id: Optional[List["_models.SearchFacetItemValue"]] = None,
        contact_type: Optional[List["_models.SearchFacetItemValue"]] = None,
        label: Optional[List["_models.SearchFacetItemValue"]] = None,
        glossary_type: Optional[List["_models.SearchFacetItemValue"]] = None,
        term_status: Optional[List["_models.SearchFacetItemValue"]] = None,
        term_template: Optional[List["_models.SearchFacetItemValue"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SearchFacetSort(_model_base.Model):
    """The sorting criteria.

    :ivar count: Order by count. Known values are: "asc" and "desc".
    :vartype count: str or ~azure.purview.datamap.models.SearchSortOrder
    :ivar value: Order by value. Known values are: "asc" and "desc".
    :vartype value: str or ~azure.purview.datamap.models.SearchSortOrder
    """

    count: Optional[Union[str, "_models.SearchSortOrder"]] = rest_field()
    """Order by count. Known values are: \"asc\" and \"desc\"."""
    value: Optional[Union[str, "_models.SearchSortOrder"]] = rest_field()
    """Order by value. Known values are: \"asc\" and \"desc\"."""

    @overload
    def __init__(
        self,
        *,
        count: Optional[Union[str, "_models.SearchSortOrder"]] = None,
        value: Optional[Union[str, "_models.SearchSortOrder"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SearchHighlights(_model_base.Model):
    """A highlight list that consists of index fields id ,qualifiedName, name,
    description, entityType. When the keyword appears in those fields, the value of
    the field, attached with emphasis mark, is returned as an element of
    @search.highlights.

    :ivar id: Id.
    :vartype id: list[str]
    :ivar qualified_name: Qualified name.
    :vartype qualified_name: list[str]
    :ivar name: Name.
    :vartype name: list[str]
    :ivar description: Description.
    :vartype description: list[str]
    :ivar entity_type: Entity type.
    :vartype entity_type: list[str]
    """

    id: Optional[List[str]] = rest_field()
    """Id."""
    qualified_name: Optional[List[str]] = rest_field(name="qualifiedName")
    """Qualified name."""
    name: Optional[List[str]] = rest_field()
    """Name."""
    description: Optional[List[str]] = rest_field()
    """Description."""
    entity_type: Optional[List[str]] = rest_field(name="entityType")
    """Entity type."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[List[str]] = None,  # pylint: disable=redefined-builtin
        qualified_name: Optional[List[str]] = None,
        name: Optional[List[str]] = None,
        description: Optional[List[str]] = None,
        entity_type: Optional[List[str]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SearchResultValue(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The value item of the search result.

    :ivar search_score: The search score calculated by the search engine. The results are ordered
     by
     search score by default.
    :vartype search_score: float
    :ivar search_highlights: A highlight list that consists of index fields id ,qualifiedName,
     name,
     description, entityType. When the keyword appears in those fields, the value of
     the field, attached with emphasis mark, is returned as an element of
     @search.highlights.
    :vartype search_highlights: ~azure.purview.datamap.models.SearchHighlights
    :ivar object_type: The object type of the record. Object type is the top-level property to
     distinguish whether a record is an asset or a term.
    :vartype object_type: str
    :ivar create_time: The create time of the record. The Unix epoch format.
    :vartype create_time: int
    :ivar update_time: The last update time of the record. The Unix epoch format.
    :vartype update_time: int
    :ivar id: The GUID of the record.
    :vartype id: str
    :ivar name: The name of the record.
    :vartype name: str
    :ivar qualified_name: The qualified name of the record.
    :vartype qualified_name: str
    :ivar entity_type: The type name of the asset.
    :vartype entity_type: str
    :ivar description: The description of the asset.
    :vartype description: str
    :ivar endorsement: The endorsement of the asset.
    :vartype endorsement: str
    :ivar owner: The owner of the record.
    :vartype owner: str
    :ivar classification: The classifications of the record.
    :vartype classification: list[str]
    :ivar label: The labels of the asset.
    :vartype label: list[str]
    :ivar term: The terms assigned to the asset.
    :vartype term: list[~azure.purview.datamap.models.TermSearchResultValue]
    :ivar contact: The contacts of the asset.
    :vartype contact: list[~azure.purview.datamap.models.ContactSearchResultValue]
    :ivar asset_type: The asset types of the asset.
    :vartype asset_type: list[str]
    :ivar glossary_type: The type name of the term. Could be AtlasGlossary, AtlasGlossaryTerm or
     AtlasGlossaryCategory.
    :vartype glossary_type: str
    :ivar glossary: The glossary name of the term.
    :vartype glossary: str
    :ivar term_status: The status of the term.
    :vartype term_status: str
    :ivar term_template: The term template names used by the term.
    :vartype term_template: list[str]
    :ivar long_description: The definition of the term.
    :vartype long_description: str
    """

    search_score: Optional[float] = rest_field(name="@search.score")
    """The search score calculated by the search engine. The results are ordered by
     search score by default."""
    search_highlights: Optional["_models.SearchHighlights"] = rest_field(name="@search.highlights")
    """A highlight list that consists of index fields id ,qualifiedName, name,
     description, entityType. When the keyword appears in those fields, the value of
     the field, attached with emphasis mark, is returned as an element of
     @search.highlights."""
    object_type: Optional[str] = rest_field(name="objectType")
    """The object type of the record. Object type is the top-level property to
     distinguish whether a record is an asset or a term."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The create time of the record. The Unix epoch format."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The last update time of the record. The Unix epoch format."""
    id: Optional[str] = rest_field()
    """The GUID of the record."""
    name: Optional[str] = rest_field()
    """The name of the record."""
    qualified_name: Optional[str] = rest_field(name="qualifiedName")
    """The qualified name of the record."""
    entity_type: Optional[str] = rest_field(name="entityType")
    """The type name of the asset."""
    description: Optional[str] = rest_field()
    """The description of the asset."""
    endorsement: Optional[str] = rest_field()
    """The endorsement of the asset."""
    owner: Optional[str] = rest_field()
    """The owner of the record."""
    classification: Optional[List[str]] = rest_field()
    """The classifications of the record."""
    label: Optional[List[str]] = rest_field()
    """The labels of the asset."""
    term: Optional[List["_models.TermSearchResultValue"]] = rest_field()
    """The terms assigned to the asset."""
    contact: Optional[List["_models.ContactSearchResultValue"]] = rest_field()
    """The contacts of the asset."""
    asset_type: Optional[List[str]] = rest_field(name="assetType")
    """The asset types of the asset."""
    glossary_type: Optional[str] = rest_field(name="glossaryType")
    """The type name of the term. Could be AtlasGlossary, AtlasGlossaryTerm or
     AtlasGlossaryCategory."""
    glossary: Optional[str] = rest_field()
    """The glossary name of the term."""
    term_status: Optional[str] = rest_field(name="termStatus")
    """The status of the term."""
    term_template: Optional[List[str]] = rest_field(name="termTemplate")
    """The term template names used by the term."""
    long_description: Optional[str] = rest_field(name="longDescription")
    """The definition of the term."""

    @overload
    def __init__(
        self,
        *,
        search_score: Optional[float] = None,
        search_highlights: Optional["_models.SearchHighlights"] = None,
        object_type: Optional[str] = None,
        create_time: Optional[int] = None,
        update_time: Optional[int] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        entity_type: Optional[str] = None,
        description: Optional[str] = None,
        endorsement: Optional[str] = None,
        owner: Optional[str] = None,
        classification: Optional[List[str]] = None,
        label: Optional[List[str]] = None,
        term: Optional[List["_models.TermSearchResultValue"]] = None,
        contact: Optional[List["_models.ContactSearchResultValue"]] = None,
        asset_type: Optional[List[str]] = None,
        glossary_type: Optional[str] = None,
        glossary: Optional[str] = None,
        term_status: Optional[str] = None,
        term_template: Optional[List[str]] = None,
        long_description: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SearchTaxonomySetting(_model_base.Model):
    """Taxonomy setting for search request.

    :ivar asset_types: Asset types.
    :vartype asset_types: list[str]
    :ivar facet: The content of a search facet result item.
    :vartype facet: ~azure.purview.datamap.models.SearchFacetItem
    """

    asset_types: Optional[List[str]] = rest_field(name="assetTypes")
    """Asset types."""
    facet: Optional["_models.SearchFacetItem"] = rest_field()
    """The content of a search facet result item."""

    @overload
    def __init__(
        self,
        *,
        asset_types: Optional[List[str]] = None,
        facet: Optional["_models.SearchFacetItem"] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SuggestOptions(_model_base.Model):
    """The payload of suggest request.

    :ivar keywords: The keywords applied to all fields that support suggest operation. It must be
     at least 1 character, and no more than 100 characters. In the index schema we
     defined a default suggester which lists all the supported fields and specifies
     a search mode.
    :vartype keywords: str
    :ivar limit: The number of suggestions we hope to return. The default value is 5. The value
     must be a number between 1 and 100.
    :vartype limit: int
    :ivar filter: The filter for the search.
    :vartype filter: any
    """

    keywords: Optional[str] = rest_field()
    """The keywords applied to all fields that support suggest operation. It must be
     at least 1 character, and no more than 100 characters. In the index schema we
     defined a default suggester which lists all the supported fields and specifies
     a search mode."""
    limit: Optional[int] = rest_field()
    """The number of suggestions we hope to return. The default value is 5. The value
     must be a number between 1 and 100."""
    filter: Optional[Any] = rest_field()
    """The filter for the search."""

    @overload
    def __init__(
        self,
        *,
        keywords: Optional[str] = None,
        limit: Optional[int] = None,
        filter: Optional[Any] = None,  # pylint: disable=redefined-builtin
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SuggestResult(_model_base.Model):
    """The result item of the search suggest.

    :ivar value: The result value.
    :vartype value: list[~azure.purview.datamap.models.SuggestResultValue]
    """

    value: Optional[List["_models.SuggestResultValue"]] = rest_field()
    """The result value."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[List["_models.SuggestResultValue"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SuggestResultValue(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The value item of the search suggest.

    :ivar search_score: The search score calculated by the search engine. The results are ordered
     by
     search score by default.
    :vartype search_score: float
    :ivar search_text: The target text that contains the keyword as prefix. The keyword is wrapped
     with emphasis mark.
    :vartype search_text: str
    :ivar object_type: The object type of the record. Object type is the top-level property to
     distinguish whether a record is an asset or a term.
    :vartype object_type: str
    :ivar create_time: The create time of the record. The Unix epoch format.
    :vartype create_time: int
    :ivar update_time: The last update time of the record. The Unix epoch format.
    :vartype update_time: int
    :ivar id: The GUID of the record.
    :vartype id: str
    :ivar name: The name of the record.
    :vartype name: str
    :ivar qualified_name: The qualified name of the record.
    :vartype qualified_name: str
    :ivar entity_type: The type name of the asset.
    :vartype entity_type: str
    :ivar description: The description of the asset.
    :vartype description: str
    :ivar endorsement: The endorsement of the asset.
    :vartype endorsement: str
    :ivar owner: The owner of the record.
    :vartype owner: str
    :ivar classification: The classifications of the record.
    :vartype classification: list[str]
    :ivar label: The labels of the asset.
    :vartype label: list[str]
    :ivar term: The terms assigned to the asset.
    :vartype term: list[~azure.purview.datamap.models.TermSearchResultValue]
    :ivar contact: The contacts of the asset.
    :vartype contact: list[~azure.purview.datamap.models.ContactSearchResultValue]
    :ivar asset_type: The asset types of the asset.
    :vartype asset_type: list[str]
    :ivar glossary_type: The type name of the term. Could be AtlasGlossary, AtlasGlossaryTerm or
     AtlasGlossaryCategory.
    :vartype glossary_type: str
    :ivar glossary: The glossary name of the term.
    :vartype glossary: str
    :ivar term_status: The status of the term.
    :vartype term_status: str
    :ivar term_template: The term template names used by the term.
    :vartype term_template: list[str]
    :ivar long_description: The definition of the term.
    :vartype long_description: str
    """

    search_score: Optional[float] = rest_field(name="@search.score")
    """The search score calculated by the search engine. The results are ordered by
     search score by default."""
    search_text: Optional[str] = rest_field(name="@search.text")
    """The target text that contains the keyword as prefix. The keyword is wrapped
     with emphasis mark."""
    object_type: Optional[str] = rest_field(name="objectType")
    """The object type of the record. Object type is the top-level property to
     distinguish whether a record is an asset or a term."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The create time of the record. The Unix epoch format."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The last update time of the record. The Unix epoch format."""
    id: Optional[str] = rest_field()
    """The GUID of the record."""
    name: Optional[str] = rest_field()
    """The name of the record."""
    qualified_name: Optional[str] = rest_field(name="qualifiedName")
    """The qualified name of the record."""
    entity_type: Optional[str] = rest_field(name="entityType")
    """The type name of the asset."""
    description: Optional[str] = rest_field()
    """The description of the asset."""
    endorsement: Optional[str] = rest_field()
    """The endorsement of the asset."""
    owner: Optional[str] = rest_field()
    """The owner of the record."""
    classification: Optional[List[str]] = rest_field()
    """The classifications of the record."""
    label: Optional[List[str]] = rest_field()
    """The labels of the asset."""
    term: Optional[List["_models.TermSearchResultValue"]] = rest_field()
    """The terms assigned to the asset."""
    contact: Optional[List["_models.ContactSearchResultValue"]] = rest_field()
    """The contacts of the asset."""
    asset_type: Optional[List[str]] = rest_field(name="assetType")
    """The asset types of the asset."""
    glossary_type: Optional[str] = rest_field(name="glossaryType")
    """The type name of the term. Could be AtlasGlossary, AtlasGlossaryTerm or
     AtlasGlossaryCategory."""
    glossary: Optional[str] = rest_field()
    """The glossary name of the term."""
    term_status: Optional[str] = rest_field(name="termStatus")
    """The status of the term."""
    term_template: Optional[List[str]] = rest_field(name="termTemplate")
    """The term template names used by the term."""
    long_description: Optional[str] = rest_field(name="longDescription")
    """The definition of the term."""

    @overload
    def __init__(
        self,
        *,
        search_score: Optional[float] = None,
        search_text: Optional[str] = None,
        object_type: Optional[str] = None,
        create_time: Optional[int] = None,
        update_time: Optional[int] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        qualified_name: Optional[str] = None,
        entity_type: Optional[str] = None,
        description: Optional[str] = None,
        endorsement: Optional[str] = None,
        owner: Optional[str] = None,
        classification: Optional[List[str]] = None,
        label: Optional[List[str]] = None,
        term: Optional[List["_models.TermSearchResultValue"]] = None,
        contact: Optional[List["_models.ContactSearchResultValue"]] = None,
        asset_type: Optional[List[str]] = None,
        glossary_type: Optional[str] = None,
        glossary: Optional[str] = None,
        term_status: Optional[str] = None,
        term_template: Optional[List[str]] = None,
        long_description: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TermSearchResultValue(_model_base.Model):
    """The context.

    :ivar name: The name of the term.
    :vartype name: str
    :ivar glossary_name: The name of the glossary which contains the term.
    :vartype glossary_name: str
    :ivar guid: The GUID of the term.
    :vartype guid: str
    """

    name: Optional[str] = rest_field()
    """The name of the term."""
    glossary_name: Optional[str] = rest_field(name="glossaryName")
    """The name of the glossary which contains the term."""
    guid: Optional[str] = rest_field()
    """The GUID of the term."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        glossary_name: Optional[str] = None,
        guid: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TermTemplateDef(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Term template definition for glossary term.

    :ivar category: The enum of type category. Known values are: "PRIMITIVE", "OBJECT_ID_TYPE",
     "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", and
     "TERM_TEMPLATE".
    :vartype category: str or ~azure.purview.datamap.models.TypeCategory
    :ivar create_time: The created time of the record.
    :vartype create_time: int
    :ivar created_by: The user who created the record.
    :vartype created_by: str
    :ivar date_formatter: The date format.
    :vartype date_formatter: ~azure.purview.datamap.models.DateFormat
    :ivar description: The description of the type definition.
    :vartype description: str
    :ivar guid: The GUID of the type definition.
    :vartype guid: str
    :ivar name: The name of the type definition.
    :vartype name: str
    :ivar options: The options for the type definition.
    :vartype options: dict[str, str]
    :ivar service_type: The service type.
    :vartype service_type: str
    :ivar type_version: The version of the type.
    :vartype type_version: str
    :ivar update_time: The update time of the record.
    :vartype update_time: int
    :ivar updated_by: The user who updated the record.
    :vartype updated_by: str
    :ivar version: The version of the record.
    :vartype version: int
    :ivar last_modified_t_s: ETag for concurrency control.
    :vartype last_modified_t_s: str
    :ivar attribute_defs: An array of attribute definitions.
    :vartype attribute_defs: list[~azure.purview.datamap.models.AtlasAttributeDef]
    """

    category: Optional[Union[str, "_models.TypeCategory"]] = rest_field()
    """The enum of type category. Known values are: \"PRIMITIVE\", \"OBJECT_ID_TYPE\", \"ENUM\",
     \"STRUCT\", \"CLASSIFICATION\", \"ENTITY\", \"ARRAY\", \"MAP\", \"RELATIONSHIP\", and
     \"TERM_TEMPLATE\"."""
    create_time: Optional[int] = rest_field(name="createTime")
    """The created time of the record."""
    created_by: Optional[str] = rest_field(name="createdBy")
    """The user who created the record."""
    date_formatter: Optional["_models.DateFormat"] = rest_field(name="dateFormatter")
    """The date format."""
    description: Optional[str] = rest_field()
    """The description of the type definition."""
    guid: Optional[str] = rest_field()
    """The GUID of the type definition."""
    name: Optional[str] = rest_field()
    """The name of the type definition."""
    options: Optional[Dict[str, str]] = rest_field()
    """The options for the type definition."""
    service_type: Optional[str] = rest_field(name="serviceType")
    """The service type."""
    type_version: Optional[str] = rest_field(name="typeVersion")
    """The version of the type."""
    update_time: Optional[int] = rest_field(name="updateTime")
    """The update time of the record."""
    updated_by: Optional[str] = rest_field(name="updatedBy")
    """The user who updated the record."""
    version: Optional[int] = rest_field()
    """The version of the record."""
    last_modified_t_s: Optional[str] = rest_field(name="lastModifiedTS")
    """ETag for concurrency control."""
    attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = rest_field(name="attributeDefs")
    """An array of attribute definitions."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.TypeCategory"]] = None,
        create_time: Optional[int] = None,
        created_by: Optional[str] = None,
        date_formatter: Optional["_models.DateFormat"] = None,
        description: Optional[str] = None,
        guid: Optional[str] = None,
        name: Optional[str] = None,
        options: Optional[Dict[str, str]] = None,
        service_type: Optional[str] = None,
        type_version: Optional[str] = None,
        update_time: Optional[int] = None,
        updated_by: Optional[str] = None,
        version: Optional[int] = None,
        last_modified_t_s: Optional[str] = None,
        attribute_defs: Optional[List["_models.AtlasAttributeDef"]] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TimeBoundary(_model_base.Model):
    """Captures time-boundary details.

    :ivar end_time: The end of the time boundary.
    :vartype end_time: str
    :ivar start_time: The start of the time boundary.
    :vartype start_time: str
    :ivar time_zone: The timezone of the time boundary.
    :vartype time_zone: str
    """

    end_time: Optional[str] = rest_field(name="endTime")
    """The end of the time boundary."""
    start_time: Optional[str] = rest_field(name="startTime")
    """The start of the time boundary."""
    time_zone: Optional[str] = rest_field(name="timeZone")
    """The timezone of the time boundary."""

    @overload
    def __init__(
        self,
        *,
        end_time: Optional[str] = None,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TimeZone(_model_base.Model):
    """The timezone information.

    :ivar dst_savings: The value of the daylight saving time.
    :vartype dst_savings: int
    :ivar id: The ID of the timezone.
    :vartype id: str
    :ivar available_ids: An array of available IDs.
    :vartype available_ids: list[str]
    :ivar default: The timezone information.
    :vartype default: ~azure.purview.datamap.models.TimeZone
    :ivar display_name: The display name of the timezone.
    :vartype display_name: str
    :ivar raw_offset: The raw offset of the timezone.
    :vartype raw_offset: int
    """

    dst_savings: Optional[int] = rest_field(name="dstSavings")
    """The value of the daylight saving time."""
    id: Optional[str] = rest_field()
    """The ID of the timezone."""
    available_ids: Optional[List[str]] = rest_field(name="availableIds")
    """An array of available IDs."""
    default: Optional["_models.TimeZone"] = rest_field()
    """The timezone information."""
    display_name: Optional[str] = rest_field(name="displayName")
    """The display name of the timezone."""
    raw_offset: Optional[int] = rest_field(name="rawOffset")
    """The raw offset of the timezone."""

    @overload
    def __init__(
        self,
        *,
        dst_savings: Optional[int] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        available_ids: Optional[List[str]] = None,
        default: Optional["_models.TimeZone"] = None,
        display_name: Optional[str] = None,
        raw_offset: Optional[int] = None,
    ):
        ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
