# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessPolicyEntry(_serialization.Model):
    """An identity that have access to the key vault. All identities in the array must use the same
    tenant ID as the key vault's tenant ID.

    All required parameters must be populated in order to send to server.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault. Required.
    :vartype tenant_id: str
    :ivar object_id: The object ID of a user, service principal or security group in the Azure
     Active Directory tenant for the vault. The object ID must be unique for the list of access
     policies. Required.
    :vartype object_id: str
    :ivar application_id: Application ID of the client making request on behalf of a principal.
    :vartype application_id: str
    :ivar permissions: Permissions the identity has for keys, secrets and certificates. Required.
    :vartype permissions: ~azure.mgmt.keyvault.v2018_02_14.models.Permissions
    """

    _validation = {
        "tenant_id": {"required": True},
        "object_id": {"required": True},
        "permissions": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
        "permissions": {"key": "permissions", "type": "Permissions"},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        object_id: str,
        permissions: "_models.Permissions",
        application_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault. Required.
        :paramtype tenant_id: str
        :keyword object_id: The object ID of a user, service principal or security group in the Azure
         Active Directory tenant for the vault. The object ID must be unique for the list of access
         policies. Required.
        :paramtype object_id: str
        :keyword application_id: Application ID of the client making request on behalf of a principal.
        :paramtype application_id: str
        :keyword permissions: Permissions the identity has for keys, secrets and certificates.
         Required.
        :paramtype permissions: ~azure.mgmt.keyvault.v2018_02_14.models.Permissions
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.application_id = application_id
        self.permissions = permissions


class CheckNameAvailabilityResult(_serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: A boolean value that indicates whether the name is available for you to
     use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: The reason that a vault name could not be used. The Reason element is only
     returned if NameAvailable is false. Known values are: "AccountNameInvalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.keyvault.v2018_02_14.models.Reason
    :ivar message: An error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CloudErrorBody(_serialization.Model):
    """An error response from Key Vault resource provider.

    :ivar code: Error code. This is a mnemonic that can be consumed programmatically.
    :vartype code: str
    :ivar message: User friendly error message. The message is typically localized and may vary
     with service version.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code. This is a mnemonic that can be consumed programmatically.
        :paramtype code: str
        :keyword message: User friendly error message. The message is typically localized and may vary
         with service version.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class DeletedVault(_serialization.Model):
    """Deleted vault information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID for the deleted key vault.
    :vartype id: str
    :ivar name: The name of the key vault.
    :vartype name: str
    :ivar type: The resource type of the key vault.
    :vartype type: str
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.keyvault.v2018_02_14.models.DeletedVaultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DeletedVaultProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DeletedVaultProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the vault.
        :paramtype properties: ~azure.mgmt.keyvault.v2018_02_14.models.DeletedVaultProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class DeletedVaultListResult(_serialization.Model):
    """List of vaults.

    :ivar value: The list of deleted vaults.
    :vartype value: list[~azure.mgmt.keyvault.v2018_02_14.models.DeletedVault]
    :ivar next_link: The URL to get the next set of deleted vaults.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedVault]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DeletedVault"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of deleted vaults.
        :paramtype value: list[~azure.mgmt.keyvault.v2018_02_14.models.DeletedVault]
        :keyword next_link: The URL to get the next set of deleted vaults.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeletedVaultProperties(_serialization.Model):
    """Properties of the deleted vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vault_id: The resource id of the original vault.
    :vartype vault_id: str
    :ivar location: The location of the original vault.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar tags: Tags of the original vault.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "vault_id": {"readonly": True},
        "location": {"readonly": True},
        "deletion_date": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "vault_id": {"key": "vaultId", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "deletion_date": {"key": "deletionDate", "type": "iso-8601"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "iso-8601"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.vault_id = None
        self.location = None
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.tags = None


class IPRule(_serialization.Model):
    """A rule governing the accessibility of a vault from a specific ip address or ip range.

    All required parameters must be populated in order to send to server.

    :ivar value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address)
     or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, **kwargs: Any) -> None:
        """
        :keyword value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP
         address) or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class LogSpecification(_serialization.Model):
    """Log specification of operation.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of specification.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of log specification.
        :paramtype name: str
        :keyword display_name: Display name of log specification.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of specification.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class NetworkRuleSet(_serialization.Model):
    """A set of rules governing the network accessibility of a vault.

    :ivar bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
     'None'.  If not specified the default is 'AzureServices'. Known values are: "AzureServices" and
     "None".
    :vartype bypass: str or ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleBypassOptions
    :ivar default_action: The default action when no rule from ipRules and from virtualNetworkRules
     match. This is only used after the bypass property has been evaluated. Known values are:
     "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleAction
    :ivar ip_rules: The list of IP address rules.
    :vartype ip_rules: list[~azure.mgmt.keyvault.v2018_02_14.models.IPRule]
    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules:
     list[~azure.mgmt.keyvault.v2018_02_14.models.VirtualNetworkRule]
    """

    _attribute_map = {
        "bypass": {"key": "bypass", "type": "str"},
        "default_action": {"key": "defaultAction", "type": "str"},
        "ip_rules": {"key": "ipRules", "type": "[IPRule]"},
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[VirtualNetworkRule]"},
    }

    def __init__(
        self,
        *,
        bypass: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        default_action: Optional[Union[str, "_models.NetworkRuleAction"]] = None,
        ip_rules: Optional[List["_models.IPRule"]] = None,
        virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
         'None'.  If not specified the default is 'AzureServices'. Known values are: "AzureServices" and
         "None".
        :paramtype bypass: str or ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleBypassOptions
        :keyword default_action: The default action when no rule from ipRules and from
         virtualNetworkRules match. This is only used after the bypass property has been evaluated.
         Known values are: "Allow" and "Deny".
        :paramtype default_action: str or ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleAction
        :keyword ip_rules: The list of IP address rules.
        :paramtype ip_rules: list[~azure.mgmt.keyvault.v2018_02_14.models.IPRule]
        :keyword virtual_network_rules: The list of virtual network rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.keyvault.v2018_02_14.models.VirtualNetworkRule]
        """
        super().__init__(**kwargs)
        self.bypass = bypass
        self.default_action = default_action
        self.ip_rules = ip_rules
        self.virtual_network_rules = virtual_network_rules


class Operation(_serialization.Model):
    """Key Vault REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.keyvault.v2018_02_14.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.keyvault.v2018_02_14.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.keyvault.v2018_02_14.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.keyvault.v2018_02_14.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Key Vault.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft Key Vault.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL
    link to get the next set of results.

    :ivar value: List of Storage operations supported by the Storage resource provider.
    :vartype value: list[~azure.mgmt.keyvault.v2018_02_14.models.Operation]
    :ivar next_link: The URL to get the next set of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Storage operations supported by the Storage resource provider.
        :paramtype value: list[~azure.mgmt.keyvault.v2018_02_14.models.Operation]
        :keyword next_link: The URL to get the next set of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Permissions(_serialization.Model):
    """Permissions the identity has for keys, secrets, certificates and storage.

    :ivar keys: Permissions to keys.
    :vartype keys: list[str or ~azure.mgmt.keyvault.v2018_02_14.models.KeyPermissions]
    :ivar secrets: Permissions to secrets.
    :vartype secrets: list[str or ~azure.mgmt.keyvault.v2018_02_14.models.SecretPermissions]
    :ivar certificates: Permissions to certificates.
    :vartype certificates: list[str or
     ~azure.mgmt.keyvault.v2018_02_14.models.CertificatePermissions]
    :ivar storage: Permissions to storage accounts.
    :vartype storage: list[str or ~azure.mgmt.keyvault.v2018_02_14.models.StoragePermissions]
    """

    _attribute_map = {
        "keys": {"key": "keys", "type": "[str]"},
        "secrets": {"key": "secrets", "type": "[str]"},
        "certificates": {"key": "certificates", "type": "[str]"},
        "storage": {"key": "storage", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        keys: Optional[List[Union[str, "_models.KeyPermissions"]]] = None,
        secrets: Optional[List[Union[str, "_models.SecretPermissions"]]] = None,
        certificates: Optional[List[Union[str, "_models.CertificatePermissions"]]] = None,
        storage: Optional[List[Union[str, "_models.StoragePermissions"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword keys: Permissions to keys.
        :paramtype keys: list[str or ~azure.mgmt.keyvault.v2018_02_14.models.KeyPermissions]
        :keyword secrets: Permissions to secrets.
        :paramtype secrets: list[str or ~azure.mgmt.keyvault.v2018_02_14.models.SecretPermissions]
        :keyword certificates: Permissions to certificates.
        :paramtype certificates: list[str or
         ~azure.mgmt.keyvault.v2018_02_14.models.CertificatePermissions]
        :keyword storage: Permissions to storage accounts.
        :paramtype storage: list[str or ~azure.mgmt.keyvault.v2018_02_14.models.StoragePermissions]
        """
        super().__init__(**kwargs)
        self.keys = keys
        self.secrets = secrets
        self.certificates = certificates
        self.storage = storage


class PrivateEndpoint(_serialization.Model):
    """Private endpoint object properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Full identifier of the private endpoint resource.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class Resource(_serialization.Model):
    """Key Vault resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class PrivateEndpointConnection(Resource):
    """Private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar private_endpoint: Properties of the private endpoint object.
    :vartype private_endpoint: ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Approval state of the private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Properties of the private endpoint object.
        :paramtype private_endpoint: ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Approval state of the private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionItem(_serialization.Model):
    """Private endpoint connection item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_endpoint: Properties of the private endpoint object.
    :vartype private_endpoint: ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Approval state of the private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Properties of the private endpoint object.
        :paramtype private_endpoint: ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Approval state of the private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: Required DNS zone names of the the private link resource.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """An object that represents the approval state of the private link connection.

    :ivar status: Indicates whether the connection has been approved, rejected or removed by the
     key vault owner. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval or rejection.
    :vartype description: str
    :ivar action_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype action_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "action_required": {"key": "actionRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        action_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been approved, rejected or removed by the
         key vault owner. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval or rejection.
        :paramtype description: str
        :keyword action_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype action_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = action_required


class ResourceListResult(_serialization.Model):
    """List of vault resources.

    :ivar value: The list of vault resources.
    :vartype value: list[~azure.mgmt.keyvault.v2018_02_14.models.Resource]
    :ivar next_link: The URL to get the next set of vault resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Resource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Resource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of vault resources.
        :paramtype value: list[~azure.mgmt.keyvault.v2018_02_14.models.Resource]
        :keyword next_link: The URL to get the next set of vault resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceSpecification(_serialization.Model):
    """One property of operation, include log specifications.

    :ivar log_specifications: Log specifications of operation.
    :vartype log_specifications: list[~azure.mgmt.keyvault.v2018_02_14.models.LogSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(self, *, log_specifications: Optional[List["_models.LogSpecification"]] = None, **kwargs: Any) -> None:
        """
        :keyword log_specifications: Log specifications of operation.
        :paramtype log_specifications: list[~azure.mgmt.keyvault.v2018_02_14.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications


class Sku(_serialization.Model):
    """SKU details.

    All required parameters must be populated in order to send to server.

    :ivar family: SKU family name. "A"
    :vartype family: str or ~azure.mgmt.keyvault.v2018_02_14.models.SkuFamily
    :ivar name: SKU name to specify whether the key vault is a standard vault or a premium vault.
     Required. Known values are: "standard" and "premium".
    :vartype name: str or ~azure.mgmt.keyvault.v2018_02_14.models.SkuName
    """

    _validation = {
        "family": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "family": {"key": "family", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, family: Union[str, "_models.SkuFamily"] = "A", name: Union[str, "_models.SkuName"], **kwargs: Any
    ) -> None:
        """
        :keyword family: SKU family name. "A"
        :paramtype family: str or ~azure.mgmt.keyvault.v2018_02_14.models.SkuFamily
        :keyword name: SKU name to specify whether the key vault is a standard vault or a premium
         vault. Required. Known values are: "standard" and "premium".
        :paramtype name: str or ~azure.mgmt.keyvault.v2018_02_14.models.SkuName
        """
        super().__init__(**kwargs)
        self.family = family
        self.name = name


class Vault(_serialization.Model):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault. Required.
    :vartype properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultProperties"},
    }

    def __init__(
        self,
        *,
        properties: "_models.VaultProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Azure location of the key vault resource.
        :paramtype location: str
        :keyword tags: Tags assigned to the key vault resource.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault. Required.
        :paramtype properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.properties = properties


class VaultAccessPolicyParameters(_serialization.Model):
    """Parameters for updating the access policy in a vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource id of the access policy.
    :vartype id: str
    :ivar name: The resource name of the access policy.
    :vartype name: str
    :ivar type: The resource name of the access policy.
    :vartype type: str
    :ivar location: The resource type of the access policy.
    :vartype location: str
    :ivar properties: Properties of the access policy. Required.
    :vartype properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultAccessPolicyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "VaultAccessPolicyProperties"},
    }

    def __init__(self, *, properties: "_models.VaultAccessPolicyProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the access policy. Required.
        :paramtype properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultAccessPolicyProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class VaultAccessPolicyProperties(_serialization.Model):
    """Properties of the vault access policy.

    All required parameters must be populated in order to send to server.

    :ivar access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. Required.
    :vartype access_policies: list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
    """

    _validation = {
        "access_policies": {"required": True},
    }

    _attribute_map = {
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
    }

    def __init__(self, *, access_policies: List["_models.AccessPolicyEntry"], **kwargs: Any) -> None:
        """
        :keyword access_policies: An array of 0 to 16 identities that have access to the key vault. All
         identities in the array must use the same tenant ID as the key vault's tenant ID. Required.
        :paramtype access_policies: list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
        """
        super().__init__(**kwargs)
        self.access_policies = access_policies


class VaultCheckNameAvailabilityParameters(_serialization.Model):
    """The parameters used to check the availability of the vault name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The vault name. Required.
    :vartype name: str
    :ivar type: The type of resource, Microsoft.KeyVault/vaults. Required. Default value is
     "Microsoft.KeyVault/vaults".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.KeyVault/vaults"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The vault name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class VaultCreateOrUpdateParameters(_serialization.Model):
    """Parameters for creating or updating a vault.

    All required parameters must be populated in order to send to server.

    :ivar location: The supported Azure location where the key vault should be created. Required.
    :vartype location: str
    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault. Required.
    :vartype properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultProperties
    """

    _validation = {
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.VaultProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the key vault should be created.
         Required.
        :paramtype location: str
        :keyword tags: The tags that will be assigned to the key vault.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault. Required.
        :paramtype properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties


class VaultListResult(_serialization.Model):
    """List of vaults.

    :ivar value: The list of vaults.
    :vartype value: list[~azure.mgmt.keyvault.v2018_02_14.models.Vault]
    :ivar next_link: The URL to get the next set of vaults.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Vault]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Vault"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of vaults.
        :paramtype value: list[~azure.mgmt.keyvault.v2018_02_14.models.Vault]
        :keyword next_link: The URL to get the next set of vaults.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VaultPatchParameters(_serialization.Model):
    """Parameters for creating or updating a vault.

    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultPatchProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "VaultPatchProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VaultPatchProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags that will be assigned to the key vault.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the vault.
        :paramtype properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultPatchProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class VaultPatchProperties(_serialization.Model):
    """Properties of the vault.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault.
    :vartype tenant_id: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.v2018_02_14.models.Sku
    :ivar access_policies: An array of 0 to 1024 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID.
    :vartype access_policies: list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
    :ivar enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :vartype enabled_for_deployment: bool
    :ivar enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :vartype enabled_for_disk_encryption: bool
    :ivar enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :vartype enabled_for_template_deployment: bool
    :ivar enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this key vault. It does not accept false value.
    :vartype enable_soft_delete: bool
    :ivar create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.v2018_02_14.models.CreateMode
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :vartype enable_purge_protection: bool
    :ivar network_acls: A collection of rules governing the accessibility of the vault from
     specific network locations.
    :vartype network_acls: ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleSet
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
        "enabled_for_deployment": {"key": "enabledForDeployment", "type": "bool"},
        "enabled_for_disk_encryption": {"key": "enabledForDiskEncryption", "type": "bool"},
        "enabled_for_template_deployment": {"key": "enabledForTemplateDeployment", "type": "bool"},
        "enable_soft_delete": {"key": "enableSoftDelete", "type": "bool"},
        "create_mode": {"key": "createMode", "type": "str"},
        "enable_purge_protection": {"key": "enablePurgeProtection", "type": "bool"},
        "network_acls": {"key": "networkAcls", "type": "NetworkRuleSet"},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        access_policies: Optional[List["_models.AccessPolicyEntry"]] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault.
        :paramtype tenant_id: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.keyvault.v2018_02_14.models.Sku
        :keyword access_policies: An array of 0 to 1024 identities that have access to the key vault.
         All identities in the array must use the same tenant ID as the key vault's tenant ID.
        :paramtype access_policies: list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
        :keyword enabled_for_deployment: Property to specify whether Azure Virtual Machines are
         permitted to retrieve certificates stored as secrets from the key vault.
        :paramtype enabled_for_deployment: bool
        :keyword enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
         permitted to retrieve secrets from the vault and unwrap keys.
        :paramtype enabled_for_disk_encryption: bool
        :keyword enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
         permitted to retrieve secrets from the key vault.
        :paramtype enabled_for_template_deployment: bool
        :keyword enable_soft_delete: Property to specify whether the 'soft delete' functionality is
         enabled for this key vault. It does not accept false value.
        :paramtype enable_soft_delete: bool
        :keyword create_mode: The vault's create mode to indicate whether the vault need to be
         recovered or not. Known values are: "recover" and "default".
        :paramtype create_mode: str or ~azure.mgmt.keyvault.v2018_02_14.models.CreateMode
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this vault. Setting this property to true activates protection against purge for
         this vault and its content - only the Key Vault service may initiate a hard, irrecoverable
         deletion. The setting is effective only if soft delete is also enabled. Enabling this
         functionality is irreversible - that is, the property does not accept false as its value.
        :paramtype enable_purge_protection: bool
        :keyword network_acls: A collection of rules governing the accessibility of the vault from
         specific network locations.
        :paramtype network_acls: ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleSet
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
        self.network_acls = network_acls


class VaultProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of the vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault. Required.
    :vartype tenant_id: str
    :ivar sku: SKU details. Required.
    :vartype sku: ~azure.mgmt.keyvault.v2018_02_14.models.Sku
    :ivar access_policies: An array of 0 to 1024 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. When
     ``createMode`` is set to ``recover``\\ , access policies are not required. Otherwise, access
     policies are required.
    :vartype access_policies: list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
    :ivar vault_uri: The URI of the vault for performing operations on keys and secrets.
    :vartype vault_uri: str
    :ivar enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :vartype enabled_for_deployment: bool
    :ivar enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :vartype enabled_for_disk_encryption: bool
    :ivar enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :vartype enabled_for_template_deployment: bool
    :ivar enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this key vault. It does not accept false value.
    :vartype enable_soft_delete: bool
    :ivar create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.v2018_02_14.models.CreateMode
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :vartype enable_purge_protection: bool
    :ivar network_acls: Rules governing the accessibility of the key vault from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleSet
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     key vault.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointConnectionItem]
    """

    _validation = {
        "tenant_id": {"required": True},
        "sku": {"required": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "access_policies": {"key": "accessPolicies", "type": "[AccessPolicyEntry]"},
        "vault_uri": {"key": "vaultUri", "type": "str"},
        "enabled_for_deployment": {"key": "enabledForDeployment", "type": "bool"},
        "enabled_for_disk_encryption": {"key": "enabledForDiskEncryption", "type": "bool"},
        "enabled_for_template_deployment": {"key": "enabledForTemplateDeployment", "type": "bool"},
        "enable_soft_delete": {"key": "enableSoftDelete", "type": "bool"},
        "create_mode": {"key": "createMode", "type": "str"},
        "enable_purge_protection": {"key": "enablePurgeProtection", "type": "bool"},
        "network_acls": {"key": "networkAcls", "type": "NetworkRuleSet"},
        "private_endpoint_connections": {
            "key": "privateEndpointConnections",
            "type": "[PrivateEndpointConnectionItem]",
        },
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        sku: "_models.Sku",
        access_policies: Optional[List["_models.AccessPolicyEntry"]] = None,
        vault_uri: Optional[str] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
         requests to the key vault. Required.
        :paramtype tenant_id: str
        :keyword sku: SKU details. Required.
        :paramtype sku: ~azure.mgmt.keyvault.v2018_02_14.models.Sku
        :keyword access_policies: An array of 0 to 1024 identities that have access to the key vault.
         All identities in the array must use the same tenant ID as the key vault's tenant ID. When
         ``createMode`` is set to ``recover``\\ , access policies are not required. Otherwise, access
         policies are required.
        :paramtype access_policies: list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
        :keyword vault_uri: The URI of the vault for performing operations on keys and secrets.
        :paramtype vault_uri: str
        :keyword enabled_for_deployment: Property to specify whether Azure Virtual Machines are
         permitted to retrieve certificates stored as secrets from the key vault.
        :paramtype enabled_for_deployment: bool
        :keyword enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
         permitted to retrieve secrets from the vault and unwrap keys.
        :paramtype enabled_for_disk_encryption: bool
        :keyword enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
         permitted to retrieve secrets from the key vault.
        :paramtype enabled_for_template_deployment: bool
        :keyword enable_soft_delete: Property to specify whether the 'soft delete' functionality is
         enabled for this key vault. It does not accept false value.
        :paramtype enable_soft_delete: bool
        :keyword create_mode: The vault's create mode to indicate whether the vault need to be
         recovered or not. Known values are: "recover" and "default".
        :paramtype create_mode: str or ~azure.mgmt.keyvault.v2018_02_14.models.CreateMode
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this vault. Setting this property to true activates protection against purge for
         this vault and its content - only the Key Vault service may initiate a hard, irrecoverable
         deletion. The setting is effective only if soft delete is also enabled. Enabling this
         functionality is irreversible - that is, the property does not accept false as its value.
        :paramtype enable_purge_protection: bool
        :keyword network_acls: Rules governing the accessibility of the key vault from specific network
         locations.
        :paramtype network_acls: ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleSet
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.vault_uri = vault_uri
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
        self.network_acls = network_acls
        self.private_endpoint_connections = None


class VirtualNetworkRule(_serialization.Model):
    """A rule governing the accessibility of a vault from a specific virtual network.

    All required parameters must be populated in order to send to server.

    :ivar id: Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Full resource id of a vnet subnet, such as
         '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.  # pylint: disable=line-too-long
         Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
