# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ...operations._operations import (
    build_image_versions_list_by_image_request,
    build_operations_list_request,
    build_pools_create_or_update_request,
    build_pools_delete_request,
    build_pools_get_request,
    build_pools_list_by_resource_group_request,
    build_pools_list_by_subscription_request,
    build_pools_update_request,
    build_resource_details_list_by_pool_request,
    build_sku_list_by_location_request,
    build_subscription_usages_list_by_location_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Operations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.devopsinfrastructure.aio.DevOpsInfrastructureMgmtClient`'s
        :attr:`operations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.Operation"]:
        # pylint: disable=line-too-long
        """List the operations for the provider.

        :return: An iterator like instance of Operation
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.devopsinfrastructure.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionType": "str",  # Optional. Extensible enum. Indicates the action type.
                      "Internal" refers to actions that are for internal only APIs. "Internal"
                    "display": {
                        "description": "str",  # Optional. The short, localized friendly
                          description of the operation; suitable for tool tips and detailed views.
                        "operation": "str",  # Optional. The concise, localized friendly name
                          for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
                          Machine", "Restart Virtual Machine".
                        "provider": "str",  # Optional. The localized friendly form of the
                          resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
                          Compute".
                        "resource": "str"  # Optional. The localized friendly name of the
                          resource type related to this operation. E.g. "Virtual Machines" or "Job
                          Schedule Collections".
                    },
                    "isDataAction": bool,  # Optional. Whether the operation applies to
                      data-plane. This is "true" for data-plane operations and "false" for Azure
                      Resource Manager/control-plane operations.
                    "name": "str",  # Optional. The name of the operation, as per Resource-Based
                      Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
                      "Microsoft.Compute/virtualMachines/capture/action".
                    "origin": "str"  # Optional. The intended executor of the operation; as in
                      Resource Based Access Control (RBAC) and audit logs UX. Default value is
                      "user,system". Known values are: "user", "system", and "user,system".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Operation]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_operations_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Operation], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class PoolsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.devopsinfrastructure.aio.DevOpsInfrastructureMgmtClient`'s
        :attr:`pools` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, resource_group_name: str, pool_name: str, **kwargs: Any) -> _models.Pool:
        # pylint: disable=line-too-long
        """Get a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.devopsinfrastructure.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Pool] = kwargs.pop("cls", None)

        _request = build_pools_get_request(
            resource_group_name=resource_group_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Pool, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self, resource_group_name: str, pool_name: str, resource: Union[_models.Pool, JSON, IO[bytes]], **kwargs: Any
    ) -> JSON:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_pools_create_or_update_request(
            resource_group_name=resource_group_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            deserialized = _deserialize(JSON, response.json())

        if response.status_code == 201:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = _deserialize(JSON, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        pool_name: str,
        resource: _models.Pool,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Pool]:
        # pylint: disable=line-too-long
        """Create a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :param resource: Resource create parameters. Required.
        :type resource: ~azure.mgmt.devopsinfrastructure.models.Pool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Pool. The Pool is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        pool_name: str,
        resource: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Pool]:
        # pylint: disable=line-too-long
        """Create a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :param resource: Resource create parameters. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Pool. The Pool is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        pool_name: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Pool]:
        # pylint: disable=line-too-long
        """Create a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :param resource: Resource create parameters. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Pool. The Pool is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self, resource_group_name: str, pool_name: str, resource: Union[_models.Pool, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.Pool]:
        # pylint: disable=line-too-long
        """Create a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :param resource: Resource create parameters. Is one of the following types: Pool, JSON,
         IO[bytes] Required.
        :type resource: ~azure.mgmt.devopsinfrastructure.models.Pool or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns Pool. The Pool is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Pool] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                pool_name=pool_name,
                resource=resource,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.Pool, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Pool].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Pool](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_initial(
        self,
        resource_group_name: str,
        pool_name: str,
        properties: Union[_models.PoolUpdate, JSON, IO[bytes]],
        **kwargs: Any
    ) -> Optional[JSON]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(properties, (IOBase, bytes)):
            _content = properties
        else:
            _content = json.dumps(properties, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_pools_update_request(
            resource_group_name=resource_group_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = _deserialize(JSON, response.json())

        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        pool_name: str,
        properties: _models.PoolUpdate,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Pool]:
        # pylint: disable=line-too-long
        """Update a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: ~azure.mgmt.devopsinfrastructure.models.PoolUpdate
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Pool. The Pool is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # JSON input template you can fill out and use as your body input.
                properties = {
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # Optional. The resource id of
                          the DevCenter Project the pool belongs to.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Optional. Defines how many resources can
                          there be created at any given time.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    }
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200, 202
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        pool_name: str,
        properties: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Pool]:
        # pylint: disable=line-too-long
        """Update a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Pool. The Pool is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200, 202
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        pool_name: str,
        properties: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Pool]:
        # pylint: disable=line-too-long
        """Update a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Pool. The Pool is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200, 202
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """

    @distributed_trace_async
    async def begin_update(
        self,
        resource_group_name: str,
        pool_name: str,
        properties: Union[_models.PoolUpdate, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Pool]:
        # pylint: disable=line-too-long
        """Update a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :param properties: The resource properties to be updated. Is one of the following types:
         PoolUpdate, JSON, IO[bytes] Required.
        :type properties: ~azure.mgmt.devopsinfrastructure.models.PoolUpdate or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns Pool. The Pool is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # JSON input template you can fill out and use as your body input.
                properties = {
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # Optional. The resource id of
                          the DevCenter Project the pool belongs to.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Optional. Defines how many resources can
                          there be created at any given time.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    }
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200, 202
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Pool] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                pool_name=pool_name,
                properties=properties,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.Pool, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Pool].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Pool](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, pool_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_pools_delete_request(
            resource_group_name=resource_group_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_delete(self, resource_group_name: str, pool_name: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Delete a Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                pool_name=pool_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_resource_group(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.Pool"]:
        # pylint: disable=line-too-long
        """List Pool resources by resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of Pool
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Pool]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_pools_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Pool], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_subscription(self, **kwargs: Any) -> AsyncIterable["_models.Pool"]:
        # pylint: disable=line-too-long
        """List Pool resources by subscription ID.

        :return: An iterator like instance of Pool
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.devopsinfrastructure.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "AzureDevOps":
                organization_profile = {
                    "kind": "AzureDevOps",
                    "organizations": [
                        {
                            "url": "str",  # The Azure DevOps organization URL in which
                              the pool should be created. Required.
                            "parallelism": 0,  # Optional. How many machines can be
                              created at maximum in this organization out of the maximumConcurrency of
                              the pool.
                            "projects": [
                                "str"  # Optional. Optional list of projects in which
                                  the pool should be created.
                            ]
                        }
                    ],
                    "permissionProfile": {
                        "kind": "str",  # Determines who has admin permissions to the Azure
                          DevOps pool. Required. Known values are: "Inherit", "CreatorOnly", and
                          "SpecificAccounts".
                        "groups": [
                            "str"  # Optional. Group email addresses.
                        ],
                        "users": [
                            "str"  # Optional. User email addresses.
                        ]
                    }
                }

                # JSON input template for discriminator value "GitHub":
                organization_profile = {
                    "kind": "GitHub",
                    "organizations": [
                        {
                            "url": "str",  # The GitHub organization URL in which the
                              pool should be created. Required.
                            "repositories": [
                                "str"  # Optional. Optional list of repositories in
                                  which the pool should be created.
                            ]
                        }
                    ]
                }

                # JSON input template for discriminator value "Stateful":
                agent_profile = {
                    "kind": "Stateful",
                    "gracePeriodTimeSpan": "str",  # Optional. How long should the machine be
                      kept around after it ran a workload when there are no stand-by agents. The
                      maximum is one week.
                    "maxAgentLifetime": "str",  # Optional. How long should stateful machines be
                      kept around. The maximum is one week.
                    "resourcePredictions": {},
                    "resourcePredictionsProfile": resource_predictions_profile
                }

                # JSON input template for discriminator value "Automatic":
                resource_predictions_profile = {
                    "kind": "Automatic",
                    "predictionPreference": "str"  # Optional. Determines the balance between
                      cost and performance. Known values are: "Balanced", "MostCostEffective",
                      "MoreCostEffective", "MorePerformance", and "BestPerformance".
                }

                # JSON input template for discriminator value "Manual":
                resource_predictions_profile = {
                    "kind": "Manual"
                }

                # response body for status code(s): 200
                response == {
                    "location": "str",  # The geo-location where the resource lives. Required.
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "identity": {
                        "type": "str",  # The type of managed identity assigned to this
                          resource. Required. Known values are: "None", "SystemAssigned",
                          "UserAssigned", and "SystemAssigned, UserAssigned".
                        "principalId": "str",  # Optional. The active directory identifier of
                          this principal.
                        "tenantId": "str",  # Optional. The Active Directory tenant id of the
                          principal.
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",  # Optional. The active directory
                                  client identifier for this principal.
                                "principalId": "str"  # Optional. The active
                                  directory identifier for this principal.
                            }
                        }
                    },
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "agentProfile": agent_profile,
                        "devCenterProjectResourceId": "str",  # The resource id of the
                          DevCenter Project the pool belongs to. Required.
                        "fabricProfile": fabric_profile,
                        "maximumConcurrency": 0,  # Defines how many resources can there be
                          created at any given time. Required.
                        "organizationProfile": organization_profile,
                        "provisioningState": "str"  # Optional. The status of the current
                          operation. Known values are: "Succeeded", "Failed", "Canceled",
                          "Provisioning", "Updating", "Deleting", and "Accepted".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "tags": {
                        "str": "str"  # Optional. Resource tags.
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Pool]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_pools_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Pool], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ResourceDetailsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.devopsinfrastructure.aio.DevOpsInfrastructureMgmtClient`'s
        :attr:`resource_details` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_pool(
        self, resource_group_name: str, pool_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ResourceDetailsObject"]:
        # pylint: disable=line-too-long
        """List ResourceDetailsObject resources by Pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param pool_name: Name of the pool. It needs to be globally unique. Required.
        :type pool_name: str
        :return: An iterator like instance of ResourceDetailsObject
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.devopsinfrastructure.models.ResourceDetailsObject]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "image": "str",  # The image name of the resource. Required.
                        "imageVersion": "str",  # The version of the image running on the
                          resource. Required.
                        "status": "str"  # The status of the resource. Required. Known values
                          are: "Ready", "NotReady", "Allocated", "PendingReturn", "Returned", "Leased",
                          "Provisioning", "Updating", "Starting", "PendingReimage", and "Reimaging".
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ResourceDetailsObject]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_resource_details_list_by_pool_request(
                    resource_group_name=resource_group_name,
                    pool_name=pool_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ResourceDetailsObject], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class SkuOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.devopsinfrastructure.aio.DevOpsInfrastructureMgmtClient`'s
        :attr:`sku` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_location(self, location_name: str, **kwargs: Any) -> AsyncIterable["_models.ResourceSku"]:
        # pylint: disable=line-too-long
        """List ResourceSku resources by subscription ID.

        :param location_name: Name of the location. Required.
        :type location_name: str
        :return: An iterator like instance of ResourceSku
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.devopsinfrastructure.models.ResourceSku]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "capabilities": [
                            {
                                "name": "str",  # The name of the SKU capability.
                                  Required.
                                "value": "str"  # The value of the SKU capability.
                                  Required.
                            }
                        ],
                        "family": "str",  # The family of the SKU. Required.
                        "locationInfo": [
                            {
                                "location": "str",  # Location of the SKU. Required.
                                "zoneDetails": [
                                    {
                                        "capabilities": [
                                            {
                                                "name": "str",  # The
                                                  name of the SKU capability. Required.
                                                "value": "str"  # The
                                                  value of the SKU capability. Required.
                                            }
                                        ],
                                        "name": [
                                            "str"  # Gets the set of
                                              zones that the SKU is available in with the specified
                                              capabilities. Required.
                                        ]
                                    }
                                ],
                                "zones": [
                                    "str"  # List of availability zones where the
                                      SKU is supported. Required.
                                ]
                            }
                        ],
                        "locations": [
                            "str"  # The set of locations that the SKU is available.
                              Required.
                        ],
                        "resourceType": "str",  # The type of resource the SKU applies to.
                          Required.
                        "restrictions": [
                            {
                                "restrictionInfo": {
                                    "locations": [
                                        "str"  # Optional. Locations where
                                          the SKU is restricted.
                                    ],
                                    "zones": [
                                        "str"  # Optional. List of
                                          availability zones where the SKU is restricted.
                                    ]
                                },
                                "values": [
                                    "str"  # The value of restrictions. If the
                                      restriction type is set to location. This would be different
                                      locations where the SKU is restricted. Required.
                                ],
                                "reasonCode": "str",  # Optional. the reason for
                                  restriction. Known values are: "QuotaId" and
                                  "NotAvailableForSubscription".
                                "type": "str"  # Optional. the type of restrictions.
                                  Known values are: "Location" and "Zone".
                            }
                        ],
                        "size": "str",  # The size of the SKU. Required.
                        "tier": "str"  # The tier of virtual machines in a scale set.
                          Required.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ResourceSku]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_sku_list_by_location_request(
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ResourceSku], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class SubscriptionUsagesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.devopsinfrastructure.aio.DevOpsInfrastructureMgmtClient`'s
        :attr:`subscription_usages` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_location(self, location_name: str, **kwargs: Any) -> AsyncIterable["_models.Quota"]:
        # pylint: disable=line-too-long
        """List Quota resources by subscription ID.

        :param location_name: Name of the location. Required.
        :type location_name: str
        :return: An iterator like instance of Quota
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.devopsinfrastructure.models.Quota]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "currentValue": 0,  # The current usage of the resource. Required.
                        "limit": 0,  # The maximum permitted usage of the resource. Required.
                        "name": {
                            "localizedValue": "str",  # Optional. The localized name of
                              the resource.
                            "value": "str"  # Optional. The name of the resource.
                        },
                        "unit": "str"  # The unit of usage measurement. Required.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Quota]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_subscription_usages_list_by_location_request(
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Quota], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ImageVersionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.devopsinfrastructure.aio.DevOpsInfrastructureMgmtClient`'s
        :attr:`image_versions` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_image(
        self, resource_group_name: str, image_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ImageVersion"]:
        # pylint: disable=line-too-long
        """List ImageVersion resources by Image.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param image_name: Name of the image. Required.
        :type image_name: str
        :return: An iterator like instance of ImageVersion
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.devopsinfrastructure.models.ImageVersion]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. Fully qualified resource ID for the resource. Ex -
                      /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
                    "name": "str",  # Optional. The name of the resource.
                    "properties": {
                        "version": "str"  # Version of the image. Required.
                    },
                    "systemData": {
                        "createdAt": "2020-02-20",  # Optional. The type of identity that
                          created the resource.
                        "createdBy": "str",  # Optional. The identity that created the
                          resource.
                        "createdByType": "str",  # Optional. The type of identity that
                          created the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                        "lastModifiedAt": "2020-02-20",  # Optional. The timestamp of
                          resource last modification (UTC).
                        "lastModifiedBy": "str",  # Optional. The identity that last modified
                          the resource.
                        "lastModifiedByType": "str"  # Optional. The type of identity that
                          last modified the resource. Known values are: "User", "Application",
                          "ManagedIdentity", and "Key".
                    },
                    "type": "str"  # Optional. The type of the resource. E.g.
                      "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ImageVersion]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_image_versions_list_by_image_request(
                    resource_group_name=resource_group_name,
                    image_name=image_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ImageVersion], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    await response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
