# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DataPointsObservabilityMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An indication of how the data point should be mapped to OpenTelemetry."""

    NONE = "none"
    """No mapping to OpenTelemetry."""
    COUNTER = "counter"
    """Map as counter to OpenTelemetry."""
    GAUGE = "gauge"
    """Map as gauge to OpenTelemetry."""
    HISTOGRAM = "histogram"
    """Map as histogram to OpenTelemetry."""
    LOG = "log"
    """Map as log to OpenTelemetry."""


class EventsObservabilityMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An indication of how the event should be mapped to OpenTelemetry."""

    NONE = "none"
    """No mapping to OpenTelemetry."""
    LOG = "log"
    """Map as log to OpenTelemetry."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning status of the resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    ACCEPTED = "Accepted"
    """Resource has been accepted by the server."""


class UserAuthenticationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the mode to authenticate the user of the client at the server."""

    ANONYMOUS = "Anonymous"
    """The user authentication mode is anonymous."""
    CERTIFICATE = "Certificate"
    """The user authentication mode is an x509 certificate."""
    USERNAME_PASSWORD = "UsernamePassword"
    """The user authentication mode is a username and password."""
