# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.cosmosdb import CosmosDBManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-cosmosdb
# USAGE
    python cosmos_db_mongo_db_collection_create_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = CosmosDBManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.mongo_db_resources.begin_create_update_mongo_db_collection(
        resource_group_name="rg1",
        account_name="ddb1",
        database_name="databaseName",
        collection_name="collectionName",
        create_update_mongo_db_collection_parameters={
            "location": "West US",
            "properties": {
                "options": {},
                "resource": {
                    "id": "collectionName",
                    "indexes": [
                        {"key": {"keys": ["_ts"]}, "options": {"expireAfterSeconds": 100, "unique": True}},
                        {"key": {"keys": ["_id"]}},
                    ],
                    "shardKey": {"testKey": "Hash"},
                },
            },
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/cosmos-db/resource-manager/Microsoft.DocumentDB/stable/2024-05-15/examples/CosmosDBMongoDBCollectionCreateUpdate.json
if __name__ == "__main__":
    main()
