# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementLogAnalyticsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_export_request_rate_by_interval(self, resource_group):
        response = self.client.log_analytics.begin_export_request_rate_by_interval(
            location="str",
            parameters={
                "blobContainerSasUri": "str",
                "fromTime": "2020-02-20 00:00:00",
                "intervalLength": "str",
                "toTime": "2020-02-20 00:00:00",
                "groupByOperationName": bool,
                "groupByResourceName": bool,
                "groupByThrottlePolicy": bool,
            },
            api_version="2017-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_export_throttled_requests(self, resource_group):
        response = self.client.log_analytics.begin_export_throttled_requests(
            location="str",
            parameters={
                "blobContainerSasUri": "str",
                "fromTime": "2020-02-20 00:00:00",
                "toTime": "2020-02-20 00:00:00",
                "groupByOperationName": bool,
                "groupByResourceName": bool,
                "groupByThrottlePolicy": bool,
            },
            api_version="2017-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
