# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.web import WebSiteManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-web
# USAGE
    python update_auth_settings_v2.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = WebSiteManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="34adfa4f-cedf-4dc0-ba29-b6d1a69ab345",
    )

    response = client.web_apps.update_auth_settings_v2(
        resource_group_name="testrg123",
        name="sitef6141",
        site_auth_settings_v2={
            "properties": {
                "globalValidation": {
                    "excludedPaths": ["/nosecrets/Path"],
                    "requireAuthentication": True,
                    "unauthenticatedClientAction": "Return403",
                },
                "httpSettings": {
                    "forwardProxy": {
                        "convention": "Standard",
                        "customHostHeaderName": "authHeader",
                        "customProtoHeaderName": "customProtoHeader",
                    },
                    "requireHttps": True,
                    "routes": {"apiPrefix": "/authv2/"},
                },
                "identityProviders": {
                    "google": {
                        "enabled": True,
                        "login": {"scopes": ["admin"]},
                        "registration": {
                            "clientId": "42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com",
                            "clientSecretSettingName": "ClientSecret",
                        },
                        "validation": {"allowedAudiences": ["https://example.com"]},
                    }
                },
                "login": {
                    "allowedExternalRedirectUrls": ["https://someurl.com"],
                    "cookieExpiration": {
                        "convention": "IdentityProviderDerived",
                        "timeToExpiration": "2022:09-01T00:00Z",
                    },
                    "nonce": {"validateNonce": True},
                    "preserveUrlFragmentsForLogins": True,
                    "routes": {"logoutEndpoint": "https://app.com/logout"},
                    "tokenStore": {
                        "enabled": True,
                        "fileSystem": {"directory": "/wwwroot/sites/example"},
                        "tokenRefreshExtensionHours": 96,
                    },
                },
                "platform": {"configFilePath": "/auth/config.json", "enabled": True, "runtimeVersion": "~1"},
            }
        },
    )
    print(response)


# x-ms-original-file: specification/web/resource-manager/Microsoft.Web/stable/2023-12-01/examples/UpdateAuthSettingsV2.json
if __name__ == "__main__":
    main()
