# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AbnormalTimePeriod(_serialization.Model):
    """Class representing Abnormal Time Period identified in diagnosis.

    :ivar start_time: Start time of the downtime.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the downtime.
    :vartype end_time: ~datetime.datetime
    :ivar events: List of Possible Cause of downtime.
    :vartype events: list[~azure.mgmt.web.v2023_01_01.models.DetectorAbnormalTimePeriod]
    :ivar solutions: List of proposed solutions.
    :vartype solutions: list[~azure.mgmt.web.v2023_01_01.models.Solution]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "events": {"key": "events", "type": "[DetectorAbnormalTimePeriod]"},
        "solutions": {"key": "solutions", "type": "[Solution]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        events: Optional[List["_models.DetectorAbnormalTimePeriod"]] = None,
        solutions: Optional[List["_models.Solution"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Start time of the downtime.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the downtime.
        :paramtype end_time: ~datetime.datetime
        :keyword events: List of Possible Cause of downtime.
        :paramtype events: list[~azure.mgmt.web.v2023_01_01.models.DetectorAbnormalTimePeriod]
        :keyword solutions: List of proposed solutions.
        :paramtype solutions: list[~azure.mgmt.web.v2023_01_01.models.Solution]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.events = events
        self.solutions = solutions


class Address(_serialization.Model):
    """Address information for domain registration.

    All required parameters must be populated in order to send to server.

    :ivar address1: First line of an Address. Required.
    :vartype address1: str
    :ivar address2: The second line of the Address. Optional.
    :vartype address2: str
    :ivar city: The city for the address. Required.
    :vartype city: str
    :ivar country: The country for the address. Required.
    :vartype country: str
    :ivar postal_code: The postal code for the address. Required.
    :vartype postal_code: str
    :ivar state: The state or province for the address. Required.
    :vartype state: str
    """

    _validation = {
        "address1": {"required": True},
        "city": {"required": True},
        "country": {"required": True},
        "postal_code": {"required": True},
        "state": {"required": True},
    }

    _attribute_map = {
        "address1": {"key": "address1", "type": "str"},
        "address2": {"key": "address2", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        address1: str,
        city: str,
        country: str,
        postal_code: str,
        state: str,
        address2: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address1: First line of an Address. Required.
        :paramtype address1: str
        :keyword address2: The second line of the Address. Optional.
        :paramtype address2: str
        :keyword city: The city for the address. Required.
        :paramtype city: str
        :keyword country: The country for the address. Required.
        :paramtype country: str
        :keyword postal_code: The postal code for the address. Required.
        :paramtype postal_code: str
        :keyword state: The state or province for the address. Required.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.address1 = address1
        self.address2 = address2
        self.city = city
        self.country = country
        self.postal_code = postal_code
        self.state = state


class ProxyOnlyResource(_serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class AddressResponse(ProxyOnlyResource):
    """Describes main public IP address and any extra virtual IPs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_ip_address: Main public virtual IP.
    :vartype service_ip_address: str
    :ivar internal_ip_address: Virtual Network internal IP address of the App Service Environment
     if it is in internal load-balancing mode.
    :vartype internal_ip_address: str
    :ivar outbound_ip_addresses: IP addresses appearing on outbound connections.
    :vartype outbound_ip_addresses: list[str]
    :ivar vip_mappings: Additional virtual IPs.
    :vartype vip_mappings: list[~azure.mgmt.web.v2023_01_01.models.VirtualIPMapping]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_ip_address": {"key": "properties.serviceIpAddress", "type": "str"},
        "internal_ip_address": {"key": "properties.internalIpAddress", "type": "str"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "[str]"},
        "vip_mappings": {"key": "properties.vipMappings", "type": "[VirtualIPMapping]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_ip_address: Optional[str] = None,
        internal_ip_address: Optional[str] = None,
        outbound_ip_addresses: Optional[List[str]] = None,
        vip_mappings: Optional[List["_models.VirtualIPMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_ip_address: Main public virtual IP.
        :paramtype service_ip_address: str
        :keyword internal_ip_address: Virtual Network internal IP address of the App Service
         Environment if it is in internal load-balancing mode.
        :paramtype internal_ip_address: str
        :keyword outbound_ip_addresses: IP addresses appearing on outbound connections.
        :paramtype outbound_ip_addresses: list[str]
        :keyword vip_mappings: Additional virtual IPs.
        :paramtype vip_mappings: list[~azure.mgmt.web.v2023_01_01.models.VirtualIPMapping]
        """
        super().__init__(kind=kind, **kwargs)
        self.service_ip_address = service_ip_address
        self.internal_ip_address = internal_ip_address
        self.outbound_ip_addresses = outbound_ip_addresses
        self.vip_mappings = vip_mappings


class AllowedAudiencesValidation(_serialization.Model):
    """The configuration settings of the Allowed Audiences validation flow.

    :ivar allowed_audiences: The configuration settings of the allowed list of audiences from which
     to validate the JWT token.
    :vartype allowed_audiences: list[str]
    """

    _attribute_map = {
        "allowed_audiences": {"key": "allowedAudiences", "type": "[str]"},
    }

    def __init__(self, *, allowed_audiences: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword allowed_audiences: The configuration settings of the allowed list of audiences from
         which to validate the JWT token.
        :paramtype allowed_audiences: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_audiences = allowed_audiences


class AllowedPrincipals(_serialization.Model):
    """The configuration settings of the Azure Active Directory allowed principals.

    :ivar groups: The list of the allowed groups.
    :vartype groups: list[str]
    :ivar identities: The list of the allowed identities.
    :vartype identities: list[str]
    """

    _attribute_map = {
        "groups": {"key": "groups", "type": "[str]"},
        "identities": {"key": "identities", "type": "[str]"},
    }

    def __init__(
        self, *, groups: Optional[List[str]] = None, identities: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword groups: The list of the allowed groups.
        :paramtype groups: list[str]
        :keyword identities: The list of the allowed identities.
        :paramtype identities: list[str]
        """
        super().__init__(**kwargs)
        self.groups = groups
        self.identities = identities


class AnalysisData(_serialization.Model):
    """Class Representing Detector Evidence used for analysis.

    :ivar source: Name of the Detector.
    :vartype source: str
    :ivar detector_definition: Detector Definition.
    :vartype detector_definition: ~azure.mgmt.web.v2023_01_01.models.DetectorDefinition
    :ivar metrics: Source Metrics.
    :vartype metrics: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticMetricSet]
    :ivar data: Additional Source Data.
    :vartype data: list[list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]]
    :ivar detector_meta_data: Detector Meta Data.
    :vartype detector_meta_data: ~azure.mgmt.web.v2023_01_01.models.ResponseMetaData
    """

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "detector_definition": {"key": "detectorDefinition", "type": "DetectorDefinition"},
        "metrics": {"key": "metrics", "type": "[DiagnosticMetricSet]"},
        "data": {"key": "data", "type": "[[NameValuePair]]"},
        "detector_meta_data": {"key": "detectorMetaData", "type": "ResponseMetaData"},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        detector_definition: Optional["_models.DetectorDefinition"] = None,
        metrics: Optional[List["_models.DiagnosticMetricSet"]] = None,
        data: Optional[List[List["_models.NameValuePair"]]] = None,
        detector_meta_data: Optional["_models.ResponseMetaData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Name of the Detector.
        :paramtype source: str
        :keyword detector_definition: Detector Definition.
        :paramtype detector_definition: ~azure.mgmt.web.v2023_01_01.models.DetectorDefinition
        :keyword metrics: Source Metrics.
        :paramtype metrics: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticMetricSet]
        :keyword data: Additional Source Data.
        :paramtype data: list[list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]]
        :keyword detector_meta_data: Detector Meta Data.
        :paramtype detector_meta_data: ~azure.mgmt.web.v2023_01_01.models.ResponseMetaData
        """
        super().__init__(**kwargs)
        self.source = source
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.data = data
        self.detector_meta_data = detector_meta_data


class AnalysisDefinition(ProxyOnlyResource):
    """Definition of Analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the Analysis.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.description = None


class ApiDefinitionInfo(_serialization.Model):
    """Information about the formal API definition for the app.

    :ivar url: The URL of the API definition.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword url: The URL of the API definition.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class ApiKVReference(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Description of site key vault references.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar reference:
    :vartype reference: str
    :ivar status: Known values are: "Initialized", "Resolved", "InvalidSyntax", "MSINotEnabled",
     "VaultNotFound", "SecretNotFound", "SecretVersionNotFound", "AccessToKeyVaultDenied",
     "OtherReasons", "FetchTimedOut", and "UnauthorizedClient".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.ResolveStatus
    :ivar vault_name:
    :vartype vault_name: str
    :ivar secret_name:
    :vartype secret_name: str
    :ivar secret_version:
    :vartype secret_version: str
    :ivar identity_type: Managed service identity.
    :vartype identity_type: ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentity
    :ivar details:
    :vartype details: str
    :ivar source: Default value is "KeyVault".
    :vartype source: str
    :ivar active_version:
    :vartype active_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "reference": {"key": "properties.reference", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "vault_name": {"key": "properties.vaultName", "type": "str"},
        "secret_name": {"key": "properties.secretName", "type": "str"},
        "secret_version": {"key": "properties.secretVersion", "type": "str"},
        "identity_type": {"key": "properties.identityType", "type": "ManagedServiceIdentity"},
        "details": {"key": "properties.details", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "active_version": {"key": "properties.activeVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        reference: Optional[str] = None,
        status: Optional[Union[str, "_models.ResolveStatus"]] = None,
        vault_name: Optional[str] = None,
        secret_name: Optional[str] = None,
        secret_version: Optional[str] = None,
        identity_type: Optional["_models.ManagedServiceIdentity"] = None,
        details: Optional[str] = None,
        source: Optional[Literal["KeyVault"]] = None,
        active_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword reference:
        :paramtype reference: str
        :keyword status: Known values are: "Initialized", "Resolved", "InvalidSyntax", "MSINotEnabled",
         "VaultNotFound", "SecretNotFound", "SecretVersionNotFound", "AccessToKeyVaultDenied",
         "OtherReasons", "FetchTimedOut", and "UnauthorizedClient".
        :paramtype status: str or ~azure.mgmt.web.v2023_01_01.models.ResolveStatus
        :keyword vault_name:
        :paramtype vault_name: str
        :keyword secret_name:
        :paramtype secret_name: str
        :keyword secret_version:
        :paramtype secret_version: str
        :keyword identity_type: Managed service identity.
        :paramtype identity_type: ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentity
        :keyword details:
        :paramtype details: str
        :keyword source: Default value is "KeyVault".
        :paramtype source: str
        :keyword active_version:
        :paramtype active_version: str
        """
        super().__init__(kind=kind, **kwargs)
        self.reference = reference
        self.status = status
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.identity_type = identity_type
        self.details = details
        self.source = source
        self.active_version = active_version


class ApiKVReferenceCollection(_serialization.Model):
    """ApiKVReferenceCollection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ApiKVReference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApiKVReference]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ApiKVReference"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ApiKVReference]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApiManagementConfig(_serialization.Model):
    """Azure API management (APIM) configuration linked to the app.

    :ivar id: APIM-Api Identifier.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: APIM-Api Identifier.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AppInsightsWebAppStackSettings(_serialization.Model):
    """App Insights Web App stack settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_supported: :code:`<code>true</code>` if remote Application Insights is supported for
     the stack; otherwise, :code:`<code>false</code>`.
    :vartype is_supported: bool
    :ivar is_default_off: :code:`<code>true</code>` if Application Insights is disabled by default
     for the stack; otherwise, :code:`<code>false</code>`.
    :vartype is_default_off: bool
    """

    _validation = {
        "is_supported": {"readonly": True},
        "is_default_off": {"readonly": True},
    }

    _attribute_map = {
        "is_supported": {"key": "isSupported", "type": "bool"},
        "is_default_off": {"key": "isDefaultOff", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.is_supported = None
        self.is_default_off = None


class Apple(_serialization.Model):
    """The configuration settings of the Apple provider.

    :ivar enabled: :code:`<code>false</code>` if the Apple provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Apple registration.
    :vartype registration: ~azure.mgmt.web.v2023_01_01.models.AppleRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "AppleRegistration"},
        "login": {"key": "login", "type": "LoginScopes"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.AppleRegistration"] = None,
        login: Optional["_models.LoginScopes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Apple provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Apple registration.
        :paramtype registration: ~azure.mgmt.web.v2023_01_01.models.AppleRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class AppleRegistration(_serialization.Model):
    """The configuration settings of the registration for the Apple provider.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_setting_name": {"key": "clientSecretSettingName", "type": "str"},
    }

    def __init__(
        self, *, client_id: Optional[str] = None, client_secret_setting_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret.
        :paramtype client_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name


class ApplicationLogsConfig(_serialization.Model):
    """Application logs configuration.

    :ivar file_system: Application logs to file system configuration.
    :vartype file_system: ~azure.mgmt.web.v2023_01_01.models.FileSystemApplicationLogsConfig
    :ivar azure_table_storage: Application logs to azure table storage configuration.
    :vartype azure_table_storage:
     ~azure.mgmt.web.v2023_01_01.models.AzureTableStorageApplicationLogsConfig
    :ivar azure_blob_storage: Application logs to blob storage configuration.
    :vartype azure_blob_storage:
     ~azure.mgmt.web.v2023_01_01.models.AzureBlobStorageApplicationLogsConfig
    """

    _attribute_map = {
        "file_system": {"key": "fileSystem", "type": "FileSystemApplicationLogsConfig"},
        "azure_table_storage": {"key": "azureTableStorage", "type": "AzureTableStorageApplicationLogsConfig"},
        "azure_blob_storage": {"key": "azureBlobStorage", "type": "AzureBlobStorageApplicationLogsConfig"},
    }

    def __init__(
        self,
        *,
        file_system: Optional["_models.FileSystemApplicationLogsConfig"] = None,
        azure_table_storage: Optional["_models.AzureTableStorageApplicationLogsConfig"] = None,
        azure_blob_storage: Optional["_models.AzureBlobStorageApplicationLogsConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_system: Application logs to file system configuration.
        :paramtype file_system: ~azure.mgmt.web.v2023_01_01.models.FileSystemApplicationLogsConfig
        :keyword azure_table_storage: Application logs to azure table storage configuration.
        :paramtype azure_table_storage:
         ~azure.mgmt.web.v2023_01_01.models.AzureTableStorageApplicationLogsConfig
        :keyword azure_blob_storage: Application logs to blob storage configuration.
        :paramtype azure_blob_storage:
         ~azure.mgmt.web.v2023_01_01.models.AzureBlobStorageApplicationLogsConfig
        """
        super().__init__(**kwargs)
        self.file_system = file_system
        self.azure_table_storage = azure_table_storage
        self.azure_blob_storage = azure_blob_storage


class ApplicationStack(_serialization.Model):
    """Application stack.

    :ivar name: Application stack name.
    :vartype name: str
    :ivar display: Application stack display name.
    :vartype display: str
    :ivar dependency: Application stack dependency.
    :vartype dependency: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2023_01_01.models.StackMajorVersion]
    :ivar frameworks: List of frameworks associated with application stack.
    :vartype frameworks: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStack]
    :ivar is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStack]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "str"},
        "dependency": {"key": "dependency", "type": "str"},
        "major_versions": {"key": "majorVersions", "type": "[StackMajorVersion]"},
        "frameworks": {"key": "frameworks", "type": "[ApplicationStack]"},
        "is_deprecated": {"key": "isDeprecated", "type": "[ApplicationStack]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional[str] = None,
        dependency: Optional[str] = None,
        major_versions: Optional[List["_models.StackMajorVersion"]] = None,
        frameworks: Optional[List["_models.ApplicationStack"]] = None,
        is_deprecated: Optional[List["_models.ApplicationStack"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Application stack name.
        :paramtype name: str
        :keyword display: Application stack display name.
        :paramtype display: str
        :keyword dependency: Application stack dependency.
        :paramtype dependency: str
        :keyword major_versions: List of major versions available.
        :paramtype major_versions: list[~azure.mgmt.web.v2023_01_01.models.StackMajorVersion]
        :keyword frameworks: List of frameworks associated with application stack.
        :paramtype frameworks: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStack]
        :keyword is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated;
         otherwise, :code:`<code>false</code>`.
        :paramtype is_deprecated: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStack]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.dependency = dependency
        self.major_versions = major_versions
        self.frameworks = frameworks
        self.is_deprecated = is_deprecated


class ApplicationStackCollection(_serialization.Model):
    """Collection of Application Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStackResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationStackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ApplicationStackResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStackResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationStackResource(ProxyOnlyResource):
    """ARM resource for a ApplicationStack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Application stack name.
    :vartype name_properties_name: str
    :ivar display: Application stack display name.
    :vartype display: str
    :ivar dependency: Application stack dependency.
    :vartype dependency: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2023_01_01.models.StackMajorVersion]
    :ivar frameworks: List of frameworks associated with application stack.
    :vartype frameworks: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStack]
    :ivar is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStack]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "display": {"key": "properties.display", "type": "str"},
        "dependency": {"key": "properties.dependency", "type": "str"},
        "major_versions": {"key": "properties.majorVersions", "type": "[StackMajorVersion]"},
        "frameworks": {"key": "properties.frameworks", "type": "[ApplicationStack]"},
        "is_deprecated": {"key": "properties.isDeprecated", "type": "[ApplicationStack]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        display: Optional[str] = None,
        dependency: Optional[str] = None,
        major_versions: Optional[List["_models.StackMajorVersion"]] = None,
        frameworks: Optional[List["_models.ApplicationStack"]] = None,
        is_deprecated: Optional[List["_models.ApplicationStack"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword name_properties_name: Application stack name.
        :paramtype name_properties_name: str
        :keyword display: Application stack display name.
        :paramtype display: str
        :keyword dependency: Application stack dependency.
        :paramtype dependency: str
        :keyword major_versions: List of major versions available.
        :paramtype major_versions: list[~azure.mgmt.web.v2023_01_01.models.StackMajorVersion]
        :keyword frameworks: List of frameworks associated with application stack.
        :paramtype frameworks: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStack]
        :keyword is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated;
         otherwise, :code:`<code>false</code>`.
        :paramtype is_deprecated: list[~azure.mgmt.web.v2023_01_01.models.ApplicationStack]
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.display = display
        self.dependency = dependency
        self.major_versions = major_versions
        self.frameworks = frameworks
        self.is_deprecated = is_deprecated


class AppLogsConfiguration(_serialization.Model):
    """AppLogsConfiguration.

    :ivar destination:
    :vartype destination: str
    :ivar log_analytics_configuration:
    :vartype log_analytics_configuration:
     ~azure.mgmt.web.v2023_01_01.models.LogAnalyticsConfiguration
    """

    _attribute_map = {
        "destination": {"key": "destination", "type": "str"},
        "log_analytics_configuration": {"key": "logAnalyticsConfiguration", "type": "LogAnalyticsConfiguration"},
    }

    def __init__(
        self,
        *,
        destination: Optional[str] = None,
        log_analytics_configuration: Optional["_models.LogAnalyticsConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination:
        :paramtype destination: str
        :keyword log_analytics_configuration:
        :paramtype log_analytics_configuration:
         ~azure.mgmt.web.v2023_01_01.models.LogAnalyticsConfiguration
        """
        super().__init__(**kwargs)
        self.destination = destination
        self.log_analytics_configuration = log_analytics_configuration


class AppRegistration(_serialization.Model):
    """The configuration settings of the app registration for providers that have app ids and app
    secrets.

    :ivar app_id: The App ID of the app used for login.
    :vartype app_id: str
    :ivar app_secret_setting_name: The app setting name that contains the app secret.
    :vartype app_secret_setting_name: str
    """

    _attribute_map = {
        "app_id": {"key": "appId", "type": "str"},
        "app_secret_setting_name": {"key": "appSecretSettingName", "type": "str"},
    }

    def __init__(
        self, *, app_id: Optional[str] = None, app_secret_setting_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword app_id: The App ID of the app used for login.
        :paramtype app_id: str
        :keyword app_secret_setting_name: The app setting name that contains the app secret.
        :paramtype app_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.app_id = app_id
        self.app_secret_setting_name = app_secret_setting_name


class AppServiceCertificate(_serialization.Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, key_vault_id: Optional[str] = None, key_vault_secret_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateCollection(_serialization.Model):
    """Collection of certificate order certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.AppServiceCertificateResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceCertificateResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceCertificateResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.AppServiceCertificateResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(_serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self, *, location: str, kind: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class AppServiceCertificateOrder(Resource):  # pylint: disable=too-many-instance-attributes
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str, ~azure.mgmt.web.v2023_01_01.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be 1).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
     and "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.web.v2023_01_01.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar status: Current order status. Known values are: "Pendingissuance", "Issued", "Revoked",
     "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired", and
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2023_01_01.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2023_01_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2023_01_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2023_01_01.models.ResourceNotRenewableReason]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    :ivar contact: Contact info.
    :vartype contact: ~azure.mgmt.web.v2023_01_01.models.CertificateOrderContact
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "domain_verification_token": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "signed_certificate": {"readonly": True},
        "intermediate": {"readonly": True},
        "root": {"readonly": True},
        "serial_number": {"readonly": True},
        "last_certificate_issuance_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "is_private_key_external": {"readonly": True},
        "app_service_certificate_not_renewable_reasons": {"readonly": True},
        "next_auto_renewal_time_stamp": {"readonly": True},
        "contact": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "certificates": {"key": "properties.certificates", "type": "{AppServiceCertificate}"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "domain_verification_token": {"key": "properties.domainVerificationToken", "type": "str"},
        "validity_in_years": {"key": "properties.validityInYears", "type": "int"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "product_type": {"key": "properties.productType", "type": "str"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "signed_certificate": {"key": "properties.signedCertificate", "type": "CertificateDetails"},
        "csr": {"key": "properties.csr", "type": "str"},
        "intermediate": {"key": "properties.intermediate", "type": "CertificateDetails"},
        "root": {"key": "properties.root", "type": "CertificateDetails"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "last_certificate_issuance_time": {"key": "properties.lastCertificateIssuanceTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
        "app_service_certificate_not_renewable_reasons": {
            "key": "properties.appServiceCertificateNotRenewableReasons",
            "type": "[str]",
        },
        "next_auto_renewal_time_stamp": {"key": "properties.nextAutoRenewalTimeStamp", "type": "iso-8601"},
        "contact": {"key": "properties.contact", "type": "CertificateOrderContact"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        certificates: Optional[Dict[str, "_models.AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: int = 1,
        key_size: int = 2048,
        product_type: Optional[Union[str, "_models.CertificateProductType"]] = None,
        auto_renew: bool = True,
        csr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str, ~azure.mgmt.web.v2023_01_01.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be 1).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
         and "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or ~azure.mgmt.web.v2023_01_01.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None
        self.contact = None


class AppServiceCertificateOrderCollection(_serialization.Model):
    """Collection of certificate orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.AppServiceCertificateOrder]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceCertificateOrder]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceCertificateOrder"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.AppServiceCertificateOrder]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str, ~azure.mgmt.web.v2023_01_01.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be 1).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
     and "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.web.v2023_01_01.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar status: Current order status. Known values are: "Pendingissuance", "Issued", "Revoked",
     "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired", and
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2023_01_01.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2023_01_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2023_01_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2023_01_01.models.ResourceNotRenewableReason]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    :ivar contact: Contact info.
    :vartype contact: ~azure.mgmt.web.v2023_01_01.models.CertificateOrderContact
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "domain_verification_token": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "signed_certificate": {"readonly": True},
        "intermediate": {"readonly": True},
        "root": {"readonly": True},
        "serial_number": {"readonly": True},
        "last_certificate_issuance_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "is_private_key_external": {"readonly": True},
        "app_service_certificate_not_renewable_reasons": {"readonly": True},
        "next_auto_renewal_time_stamp": {"readonly": True},
        "contact": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "certificates": {"key": "properties.certificates", "type": "{AppServiceCertificate}"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "domain_verification_token": {"key": "properties.domainVerificationToken", "type": "str"},
        "validity_in_years": {"key": "properties.validityInYears", "type": "int"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "product_type": {"key": "properties.productType", "type": "str"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "signed_certificate": {"key": "properties.signedCertificate", "type": "CertificateDetails"},
        "csr": {"key": "properties.csr", "type": "str"},
        "intermediate": {"key": "properties.intermediate", "type": "CertificateDetails"},
        "root": {"key": "properties.root", "type": "CertificateDetails"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "last_certificate_issuance_time": {"key": "properties.lastCertificateIssuanceTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
        "app_service_certificate_not_renewable_reasons": {
            "key": "properties.appServiceCertificateNotRenewableReasons",
            "type": "[str]",
        },
        "next_auto_renewal_time_stamp": {"key": "properties.nextAutoRenewalTimeStamp", "type": "iso-8601"},
        "contact": {"key": "properties.contact", "type": "CertificateOrderContact"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        certificates: Optional[Dict[str, "_models.AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: int = 1,
        key_size: int = 2048,
        product_type: Optional[Union[str, "_models.CertificateProductType"]] = None,
        auto_renew: bool = True,
        csr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str, ~azure.mgmt.web.v2023_01_01.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be 1).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
         and "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or ~azure.mgmt.web.v2023_01_01.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super().__init__(kind=kind, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None
        self.contact = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(kind=kind, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceEnvironment(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Description of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentStatus
    :ivar virtual_network: Description of the Virtual Network. Required.
    :vartype virtual_network: ~azure.mgmt.web.v2023_01_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", "Publishing",
     and "Web, Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2023_01_01.models.LoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar upgrade_preference: Upgrade Preference. Known values are: "None", "Early", "Late", and
     "Manual".
    :vartype upgrade_preference: str or ~azure.mgmt.web.v2023_01_01.models.UpgradePreference
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    :ivar zone_redundant: Whether or not this App Service Environment is zone-redundant.
    :vartype zone_redundant: bool
    :ivar custom_dns_suffix_configuration: Full view of the custom domain suffix configuration for
     ASEv3.
    :vartype custom_dns_suffix_configuration:
     ~azure.mgmt.web.v2023_01_01.models.CustomDnsSuffixConfiguration
    :ivar networking_configuration: Full view of networking configuration for an ASE.
    :vartype networking_configuration:
     ~azure.mgmt.web.v2023_01_01.models.AseV3NetworkingConfiguration
    :ivar upgrade_availability: Whether an upgrade is available for this App Service Environment.
     Known values are: "None" and "Ready".
    :vartype upgrade_availability: str or ~azure.mgmt.web.v2023_01_01.models.UpgradeAvailability
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "virtual_network": {"required": True},
        "multi_role_count": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "suspended": {"readonly": True},
        "has_linux_workers": {"readonly": True},
        "upgrade_availability": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "virtual_network": {"key": "virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "multiSize", "type": "str"},
        "multi_role_count": {"key": "multiRoleCount", "type": "int"},
        "ipssl_address_count": {"key": "ipsslAddressCount", "type": "int"},
        "dns_suffix": {"key": "dnsSuffix", "type": "str"},
        "maximum_number_of_machines": {"key": "maximumNumberOfMachines", "type": "int"},
        "front_end_scale_factor": {"key": "frontEndScaleFactor", "type": "int"},
        "suspended": {"key": "suspended", "type": "bool"},
        "cluster_settings": {"key": "clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "userWhitelistedIpRanges", "type": "[str]"},
        "has_linux_workers": {"key": "hasLinuxWorkers", "type": "bool"},
        "upgrade_preference": {"key": "upgradePreference", "type": "str"},
        "dedicated_host_count": {"key": "dedicatedHostCount", "type": "int"},
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "custom_dns_suffix_configuration": {
            "key": "customDnsSuffixConfiguration",
            "type": "CustomDnsSuffixConfiguration",
        },
        "networking_configuration": {"key": "networkingConfiguration", "type": "AseV3NetworkingConfiguration"},
        "upgrade_availability": {"key": "upgradeAvailability", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_network: "_models.VirtualNetworkProfile",
        internal_load_balancing_mode: Optional[Union[str, "_models.LoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        front_end_scale_factor: Optional[int] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        upgrade_preference: Union[str, "_models.UpgradePreference"] = "None",
        dedicated_host_count: Optional[int] = None,
        zone_redundant: Optional[bool] = None,
        custom_dns_suffix_configuration: Optional["_models.CustomDnsSuffixConfiguration"] = None,
        networking_configuration: Optional["_models.AseV3NetworkingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_network: Description of the Virtual Network. Required.
        :paramtype virtual_network: ~azure.mgmt.web.v2023_01_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", "Publishing",
         and "Web, Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2023_01_01.models.LoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        :keyword upgrade_preference: Upgrade Preference. Known values are: "None", "Early", "Late", and
         "Manual".
        :paramtype upgrade_preference: str or ~azure.mgmt.web.v2023_01_01.models.UpgradePreference
        :keyword dedicated_host_count: Dedicated Host Count.
        :paramtype dedicated_host_count: int
        :keyword zone_redundant: Whether or not this App Service Environment is zone-redundant.
        :paramtype zone_redundant: bool
        :keyword custom_dns_suffix_configuration: Full view of the custom domain suffix configuration
         for ASEv3.
        :paramtype custom_dns_suffix_configuration:
         ~azure.mgmt.web.v2023_01_01.models.CustomDnsSuffixConfiguration
        :keyword networking_configuration: Full view of networking configuration for an ASE.
        :paramtype networking_configuration:
         ~azure.mgmt.web.v2023_01_01.models.AseV3NetworkingConfiguration
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = None
        self.ipssl_address_count = ipssl_address_count
        self.dns_suffix = dns_suffix
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = front_end_scale_factor
        self.suspended = None
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = None
        self.upgrade_preference = upgrade_preference
        self.dedicated_host_count = dedicated_host_count
        self.zone_redundant = zone_redundant
        self.custom_dns_suffix_configuration = custom_dns_suffix_configuration
        self.networking_configuration = networking_configuration
        self.upgrade_availability = None


class AppServiceEnvironmentCollection(_serialization.Model):
    """Collection of App Service Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.AppServiceEnvironmentResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceEnvironmentResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceEnvironmentResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.AppServiceEnvironmentResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceEnvironmentPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a app service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentStatus
    :ivar virtual_network: Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2023_01_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", "Publishing",
     and "Web, Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2023_01_01.models.LoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar upgrade_preference: Upgrade Preference. Known values are: "None", "Early", "Late", and
     "Manual".
    :vartype upgrade_preference: str or ~azure.mgmt.web.v2023_01_01.models.UpgradePreference
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    :ivar zone_redundant: Whether or not this App Service Environment is zone-redundant.
    :vartype zone_redundant: bool
    :ivar custom_dns_suffix_configuration: Full view of the custom domain suffix configuration for
     ASEv3.
    :vartype custom_dns_suffix_configuration:
     ~azure.mgmt.web.v2023_01_01.models.CustomDnsSuffixConfiguration
    :ivar networking_configuration: Full view of networking configuration for an ASE.
    :vartype networking_configuration:
     ~azure.mgmt.web.v2023_01_01.models.AseV3NetworkingConfiguration
    :ivar upgrade_availability: Whether an upgrade is available for this App Service Environment.
     Known values are: "None" and "Ready".
    :vartype upgrade_availability: str or ~azure.mgmt.web.v2023_01_01.models.UpgradeAvailability
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "multi_role_count": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "suspended": {"readonly": True},
        "has_linux_workers": {"readonly": True},
        "upgrade_availability": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "properties.internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "properties.multiSize", "type": "str"},
        "multi_role_count": {"key": "properties.multiRoleCount", "type": "int"},
        "ipssl_address_count": {"key": "properties.ipsslAddressCount", "type": "int"},
        "dns_suffix": {"key": "properties.dnsSuffix", "type": "str"},
        "maximum_number_of_machines": {"key": "properties.maximumNumberOfMachines", "type": "int"},
        "front_end_scale_factor": {"key": "properties.frontEndScaleFactor", "type": "int"},
        "suspended": {"key": "properties.suspended", "type": "bool"},
        "cluster_settings": {"key": "properties.clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "properties.userWhitelistedIpRanges", "type": "[str]"},
        "has_linux_workers": {"key": "properties.hasLinuxWorkers", "type": "bool"},
        "upgrade_preference": {"key": "properties.upgradePreference", "type": "str"},
        "dedicated_host_count": {"key": "properties.dedicatedHostCount", "type": "int"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "custom_dns_suffix_configuration": {
            "key": "properties.customDnsSuffixConfiguration",
            "type": "CustomDnsSuffixConfiguration",
        },
        "networking_configuration": {
            "key": "properties.networkingConfiguration",
            "type": "AseV3NetworkingConfiguration",
        },
        "upgrade_availability": {"key": "properties.upgradeAvailability", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        virtual_network: Optional["_models.VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "_models.LoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        front_end_scale_factor: Optional[int] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        upgrade_preference: Union[str, "_models.UpgradePreference"] = "None",
        dedicated_host_count: Optional[int] = None,
        zone_redundant: Optional[bool] = None,
        custom_dns_suffix_configuration: Optional["_models.CustomDnsSuffixConfiguration"] = None,
        networking_configuration: Optional["_models.AseV3NetworkingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword virtual_network: Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2023_01_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", "Publishing",
         and "Web, Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2023_01_01.models.LoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        :keyword upgrade_preference: Upgrade Preference. Known values are: "None", "Early", "Late", and
         "Manual".
        :paramtype upgrade_preference: str or ~azure.mgmt.web.v2023_01_01.models.UpgradePreference
        :keyword dedicated_host_count: Dedicated Host Count.
        :paramtype dedicated_host_count: int
        :keyword zone_redundant: Whether or not this App Service Environment is zone-redundant.
        :paramtype zone_redundant: bool
        :keyword custom_dns_suffix_configuration: Full view of the custom domain suffix configuration
         for ASEv3.
        :paramtype custom_dns_suffix_configuration:
         ~azure.mgmt.web.v2023_01_01.models.CustomDnsSuffixConfiguration
        :keyword networking_configuration: Full view of networking configuration for an ASE.
        :paramtype networking_configuration:
         ~azure.mgmt.web.v2023_01_01.models.AseV3NetworkingConfiguration
        """
        super().__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = None
        self.ipssl_address_count = ipssl_address_count
        self.dns_suffix = dns_suffix
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = front_end_scale_factor
        self.suspended = None
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = None
        self.upgrade_preference = upgrade_preference
        self.dedicated_host_count = dedicated_host_count
        self.zone_redundant = zone_redundant
        self.custom_dns_suffix_configuration = custom_dns_suffix_configuration
        self.networking_configuration = networking_configuration
        self.upgrade_availability = None


class AppServiceEnvironmentResource(Resource):  # pylint: disable=too-many-instance-attributes
    """App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentStatus
    :ivar virtual_network: Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2023_01_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", "Publishing",
     and "Web, Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2023_01_01.models.LoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar upgrade_preference: Upgrade Preference. Known values are: "None", "Early", "Late", and
     "Manual".
    :vartype upgrade_preference: str or ~azure.mgmt.web.v2023_01_01.models.UpgradePreference
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    :ivar zone_redundant: Whether or not this App Service Environment is zone-redundant.
    :vartype zone_redundant: bool
    :ivar custom_dns_suffix_configuration: Full view of the custom domain suffix configuration for
     ASEv3.
    :vartype custom_dns_suffix_configuration:
     ~azure.mgmt.web.v2023_01_01.models.CustomDnsSuffixConfiguration
    :ivar networking_configuration: Full view of networking configuration for an ASE.
    :vartype networking_configuration:
     ~azure.mgmt.web.v2023_01_01.models.AseV3NetworkingConfiguration
    :ivar upgrade_availability: Whether an upgrade is available for this App Service Environment.
     Known values are: "None" and "Ready".
    :vartype upgrade_availability: str or ~azure.mgmt.web.v2023_01_01.models.UpgradeAvailability
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "multi_role_count": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "suspended": {"readonly": True},
        "has_linux_workers": {"readonly": True},
        "upgrade_availability": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "properties.internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "properties.multiSize", "type": "str"},
        "multi_role_count": {"key": "properties.multiRoleCount", "type": "int"},
        "ipssl_address_count": {"key": "properties.ipsslAddressCount", "type": "int"},
        "dns_suffix": {"key": "properties.dnsSuffix", "type": "str"},
        "maximum_number_of_machines": {"key": "properties.maximumNumberOfMachines", "type": "int"},
        "front_end_scale_factor": {"key": "properties.frontEndScaleFactor", "type": "int"},
        "suspended": {"key": "properties.suspended", "type": "bool"},
        "cluster_settings": {"key": "properties.clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "properties.userWhitelistedIpRanges", "type": "[str]"},
        "has_linux_workers": {"key": "properties.hasLinuxWorkers", "type": "bool"},
        "upgrade_preference": {"key": "properties.upgradePreference", "type": "str"},
        "dedicated_host_count": {"key": "properties.dedicatedHostCount", "type": "int"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "custom_dns_suffix_configuration": {
            "key": "properties.customDnsSuffixConfiguration",
            "type": "CustomDnsSuffixConfiguration",
        },
        "networking_configuration": {
            "key": "properties.networkingConfiguration",
            "type": "AseV3NetworkingConfiguration",
        },
        "upgrade_availability": {"key": "properties.upgradeAvailability", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_network: Optional["_models.VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "_models.LoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        front_end_scale_factor: Optional[int] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        upgrade_preference: Union[str, "_models.UpgradePreference"] = "None",
        dedicated_host_count: Optional[int] = None,
        zone_redundant: Optional[bool] = None,
        custom_dns_suffix_configuration: Optional["_models.CustomDnsSuffixConfiguration"] = None,
        networking_configuration: Optional["_models.AseV3NetworkingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_network: Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2023_01_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", "Publishing",
         and "Web, Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2023_01_01.models.LoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        :keyword upgrade_preference: Upgrade Preference. Known values are: "None", "Early", "Late", and
         "Manual".
        :paramtype upgrade_preference: str or ~azure.mgmt.web.v2023_01_01.models.UpgradePreference
        :keyword dedicated_host_count: Dedicated Host Count.
        :paramtype dedicated_host_count: int
        :keyword zone_redundant: Whether or not this App Service Environment is zone-redundant.
        :paramtype zone_redundant: bool
        :keyword custom_dns_suffix_configuration: Full view of the custom domain suffix configuration
         for ASEv3.
        :paramtype custom_dns_suffix_configuration:
         ~azure.mgmt.web.v2023_01_01.models.CustomDnsSuffixConfiguration
        :keyword networking_configuration: Full view of networking configuration for an ASE.
        :paramtype networking_configuration:
         ~azure.mgmt.web.v2023_01_01.models.AseV3NetworkingConfiguration
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = None
        self.ipssl_address_count = ipssl_address_count
        self.dns_suffix = dns_suffix
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = front_end_scale_factor
        self.suspended = None
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = None
        self.upgrade_preference = upgrade_preference
        self.dedicated_host_count = dedicated_host_count
        self.zone_redundant = zone_redundant
        self.custom_dns_suffix_configuration = custom_dns_suffix_configuration
        self.networking_configuration = networking_configuration
        self.upgrade_availability = None


class AppserviceGithubToken(_serialization.Model):
    """Github access token for Appservice CLI github integration.

    :ivar access_token: Github access token for Appservice CLI github integration.
    :vartype access_token: str
    :ivar scope: Scope of the github access token.
    :vartype scope: str
    :ivar token_type: token type.
    :vartype token_type: str
    :ivar got_token: True if valid github token received, False otherwise.
    :vartype got_token: bool
    :ivar error_message: Error message if unable to get token.
    :vartype error_message: str
    """

    _attribute_map = {
        "access_token": {"key": "accessToken", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "token_type": {"key": "tokenType", "type": "str"},
        "got_token": {"key": "gotToken", "type": "bool"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
        scope: Optional[str] = None,
        token_type: Optional[str] = None,
        got_token: Optional[bool] = None,
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword access_token: Github access token for Appservice CLI github integration.
        :paramtype access_token: str
        :keyword scope: Scope of the github access token.
        :paramtype scope: str
        :keyword token_type: token type.
        :paramtype token_type: str
        :keyword got_token: True if valid github token received, False otherwise.
        :paramtype got_token: bool
        :keyword error_message: Error message if unable to get token.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.access_token = access_token
        self.scope = scope
        self.token_type = token_type
        self.got_token = got_token
        self.error_message = error_message


class AppserviceGithubTokenRequest(_serialization.Model):
    """Appservice Github token request content.

    All required parameters must be populated in order to send to server.

    :ivar code: Code string to exchange for Github Access token. Required.
    :vartype code: str
    :ivar state: State string used for verification. Required.
    :vartype state: str
    """

    _validation = {
        "code": {"required": True},
        "state": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, code: str, state: str, **kwargs: Any) -> None:
        """
        :keyword code: Code string to exchange for Github Access token. Required.
        :paramtype code: str
        :keyword state: State string used for verification. Required.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.state = state


class AppServicePlan(Resource):  # pylint: disable=too-many-instance-attributes
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.web.v2023_01_01.models.SkuDescription
    :ivar extended_location: Extended Location.
    :vartype extended_location: ~azure.mgmt.web.v2023_01_01.models.ExtendedLocation
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Known values are: "Ready", "Pending", and "Creating".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar number_of_workers: The number of instances that are assigned to this App Service plan.
    :vartype number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale as
     if the ServerFarm was ElasticPremium sku.
    :vartype elastic_scale_enabled: bool
    :ivar maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :vartype maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar free_offer_expiration_time: The time when the server farm free offer expires.
    :vartype free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype is_xenon: bool
    :ivar hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype hyper_v: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Plan. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar kube_environment_profile: Specification for the Kubernetes Environment to use for the App
     Service plan.
    :vartype kube_environment_profile: ~azure.mgmt.web.v2023_01_01.models.KubeEnvironmentProfile
    :ivar zone_redundant: If :code:`<code>true</code>`, this App Service Plan will perform
     availability zone balancing.
     If :code:`<code>false</code>`, this App Service Plan will not perform availability zone
     balancing.
    :vartype zone_redundant: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "subscription": {"readonly": True},
        "maximum_number_of_workers": {"readonly": True},
        "number_of_workers": {"readonly": True},
        "geo_region": {"readonly": True},
        "number_of_sites": {"readonly": True},
        "resource_group": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "worker_tier_name": {"key": "properties.workerTierName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "maximum_number_of_workers": {"key": "properties.maximumNumberOfWorkers", "type": "int"},
        "number_of_workers": {"key": "properties.numberOfWorkers", "type": "int"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "per_site_scaling": {"key": "properties.perSiteScaling", "type": "bool"},
        "elastic_scale_enabled": {"key": "properties.elasticScaleEnabled", "type": "bool"},
        "maximum_elastic_worker_count": {"key": "properties.maximumElasticWorkerCount", "type": "int"},
        "number_of_sites": {"key": "properties.numberOfSites", "type": "int"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "spot_expiration_time": {"key": "properties.spotExpirationTime", "type": "iso-8601"},
        "free_offer_expiration_time": {"key": "properties.freeOfferExpirationTime", "type": "iso-8601"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "target_worker_count": {"key": "properties.targetWorkerCount", "type": "int"},
        "target_worker_size_id": {"key": "properties.targetWorkerSizeId", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "kube_environment_profile": {"key": "properties.kubeEnvironmentProfile", "type": "KubeEnvironmentProfile"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.SkuDescription"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        per_site_scaling: bool = False,
        elastic_scale_enabled: Optional[bool] = None,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        kube_environment_profile: Optional["_models.KubeEnvironmentProfile"] = None,
        zone_redundant: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.web.v2023_01_01.models.SkuDescription
        :keyword extended_location: Extended Location.
        :paramtype extended_location: ~azure.mgmt.web.v2023_01_01.models.ExtendedLocation
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale
         as if the ServerFarm was ElasticPremium sku.
        :paramtype elastic_scale_enabled: bool
        :keyword maximum_elastic_worker_count: Maximum number of total workers allowed for this
         ElasticScaleEnabled App Service Plan.
        :paramtype maximum_elastic_worker_count: int
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword free_offer_expiration_time: The time when the server farm free offer expires.
        :paramtype free_offer_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype is_xenon: bool
        :keyword hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype hyper_v: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        :keyword kube_environment_profile: Specification for the Kubernetes Environment to use for the
         App Service plan.
        :paramtype kube_environment_profile: ~azure.mgmt.web.v2023_01_01.models.KubeEnvironmentProfile
        :keyword zone_redundant: If :code:`<code>true</code>`, this App Service Plan will perform
         availability zone balancing.
         If :code:`<code>false</code>`, this App Service Plan will not perform availability zone
         balancing.
        :paramtype zone_redundant: bool
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.extended_location = extended_location
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.elastic_scale_enabled = elastic_scale_enabled
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None
        self.kube_environment_profile = kube_environment_profile
        self.zone_redundant = zone_redundant


class AppServicePlanCollection(_serialization.Model):
    """Collection of App Service plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.AppServicePlan]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServicePlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServicePlan"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.AppServicePlan]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServicePlanPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a app service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Known values are: "Ready", "Pending", and "Creating".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar number_of_workers: The number of instances that are assigned to this App Service plan.
    :vartype number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale as
     if the ServerFarm was ElasticPremium sku.
    :vartype elastic_scale_enabled: bool
    :ivar maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :vartype maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar free_offer_expiration_time: The time when the server farm free offer expires.
    :vartype free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype is_xenon: bool
    :ivar hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype hyper_v: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Plan. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar kube_environment_profile: Specification for the Kubernetes Environment to use for the App
     Service plan.
    :vartype kube_environment_profile: ~azure.mgmt.web.v2023_01_01.models.KubeEnvironmentProfile
    :ivar zone_redundant: If :code:`<code>true</code>`, this App Service Plan will perform
     availability zone balancing.
     If :code:`<code>false</code>`, this App Service Plan will not perform availability zone
     balancing.
    :vartype zone_redundant: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "subscription": {"readonly": True},
        "maximum_number_of_workers": {"readonly": True},
        "number_of_workers": {"readonly": True},
        "geo_region": {"readonly": True},
        "number_of_sites": {"readonly": True},
        "resource_group": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "worker_tier_name": {"key": "properties.workerTierName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "maximum_number_of_workers": {"key": "properties.maximumNumberOfWorkers", "type": "int"},
        "number_of_workers": {"key": "properties.numberOfWorkers", "type": "int"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "per_site_scaling": {"key": "properties.perSiteScaling", "type": "bool"},
        "elastic_scale_enabled": {"key": "properties.elasticScaleEnabled", "type": "bool"},
        "maximum_elastic_worker_count": {"key": "properties.maximumElasticWorkerCount", "type": "int"},
        "number_of_sites": {"key": "properties.numberOfSites", "type": "int"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "spot_expiration_time": {"key": "properties.spotExpirationTime", "type": "iso-8601"},
        "free_offer_expiration_time": {"key": "properties.freeOfferExpirationTime", "type": "iso-8601"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "target_worker_count": {"key": "properties.targetWorkerCount", "type": "int"},
        "target_worker_size_id": {"key": "properties.targetWorkerSizeId", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "kube_environment_profile": {"key": "properties.kubeEnvironmentProfile", "type": "KubeEnvironmentProfile"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        per_site_scaling: bool = False,
        elastic_scale_enabled: Optional[bool] = None,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        kube_environment_profile: Optional["_models.KubeEnvironmentProfile"] = None,
        zone_redundant: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale
         as if the ServerFarm was ElasticPremium sku.
        :paramtype elastic_scale_enabled: bool
        :keyword maximum_elastic_worker_count: Maximum number of total workers allowed for this
         ElasticScaleEnabled App Service Plan.
        :paramtype maximum_elastic_worker_count: int
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword free_offer_expiration_time: The time when the server farm free offer expires.
        :paramtype free_offer_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype is_xenon: bool
        :keyword hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype hyper_v: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        :keyword kube_environment_profile: Specification for the Kubernetes Environment to use for the
         App Service plan.
        :paramtype kube_environment_profile: ~azure.mgmt.web.v2023_01_01.models.KubeEnvironmentProfile
        :keyword zone_redundant: If :code:`<code>true</code>`, this App Service Plan will perform
         availability zone balancing.
         If :code:`<code>false</code>`, this App Service Plan will not perform availability zone
         balancing.
        :paramtype zone_redundant: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.elastic_scale_enabled = elastic_scale_enabled
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None
        self.kube_environment_profile = kube_environment_profile
        self.zone_redundant = zone_redundant


class ArcConfiguration(_serialization.Model):
    """ArcConfiguration.

    :ivar artifacts_storage_type: Known values are: "LocalNode" and "NetworkFileSystem".
    :vartype artifacts_storage_type: str or ~azure.mgmt.web.v2023_01_01.models.StorageType
    :ivar artifact_storage_class_name:
    :vartype artifact_storage_class_name: str
    :ivar artifact_storage_mount_path:
    :vartype artifact_storage_mount_path: str
    :ivar artifact_storage_node_name:
    :vartype artifact_storage_node_name: str
    :ivar artifact_storage_access_mode:
    :vartype artifact_storage_access_mode: str
    :ivar front_end_service_configuration:
    :vartype front_end_service_configuration:
     ~azure.mgmt.web.v2023_01_01.models.FrontEndConfiguration
    :ivar kube_config:
    :vartype kube_config: str
    """

    _attribute_map = {
        "artifacts_storage_type": {"key": "artifactsStorageType", "type": "str"},
        "artifact_storage_class_name": {"key": "artifactStorageClassName", "type": "str"},
        "artifact_storage_mount_path": {"key": "artifactStorageMountPath", "type": "str"},
        "artifact_storage_node_name": {"key": "artifactStorageNodeName", "type": "str"},
        "artifact_storage_access_mode": {"key": "artifactStorageAccessMode", "type": "str"},
        "front_end_service_configuration": {"key": "frontEndServiceConfiguration", "type": "FrontEndConfiguration"},
        "kube_config": {"key": "kubeConfig", "type": "str"},
    }

    def __init__(
        self,
        *,
        artifacts_storage_type: Optional[Union[str, "_models.StorageType"]] = None,
        artifact_storage_class_name: Optional[str] = None,
        artifact_storage_mount_path: Optional[str] = None,
        artifact_storage_node_name: Optional[str] = None,
        artifact_storage_access_mode: Optional[str] = None,
        front_end_service_configuration: Optional["_models.FrontEndConfiguration"] = None,
        kube_config: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword artifacts_storage_type: Known values are: "LocalNode" and "NetworkFileSystem".
        :paramtype artifacts_storage_type: str or ~azure.mgmt.web.v2023_01_01.models.StorageType
        :keyword artifact_storage_class_name:
        :paramtype artifact_storage_class_name: str
        :keyword artifact_storage_mount_path:
        :paramtype artifact_storage_mount_path: str
        :keyword artifact_storage_node_name:
        :paramtype artifact_storage_node_name: str
        :keyword artifact_storage_access_mode:
        :paramtype artifact_storage_access_mode: str
        :keyword front_end_service_configuration:
        :paramtype front_end_service_configuration:
         ~azure.mgmt.web.v2023_01_01.models.FrontEndConfiguration
        :keyword kube_config:
        :paramtype kube_config: str
        """
        super().__init__(**kwargs)
        self.artifacts_storage_type = artifacts_storage_type
        self.artifact_storage_class_name = artifact_storage_class_name
        self.artifact_storage_mount_path = artifact_storage_mount_path
        self.artifact_storage_node_name = artifact_storage_node_name
        self.artifact_storage_access_mode = artifact_storage_access_mode
        self.front_end_service_configuration = front_end_service_configuration
        self.kube_config = kube_config


class ArmIdWrapper(_serialization.Model):
    """A wrapper for an ARM resource id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class ArmPlan(_serialization.Model):
    """The plan object in Azure Resource Manager, represents a marketplace plan.

    :ivar name: The name.
    :vartype name: str
    :ivar publisher: The publisher.
    :vartype publisher: str
    :ivar product: The product.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar version: Version of product.
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name.
        :paramtype name: str
        :keyword publisher: The publisher.
        :paramtype publisher: str
        :keyword product: The product.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        :keyword version: Version of product.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class AseRegion(ProxyOnlyResource):
    """ASE region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name for region.
    :vartype display_name: str
    :ivar standard: Is region standard.
    :vartype standard: bool
    :ivar dedicated_host: Dedicated host enabled.
    :vartype dedicated_host: bool
    :ivar zone_redundant: Zone redundant deployment enabled.
    :vartype zone_redundant: bool
    :ivar available_sku: Available Skus in region.
    :vartype available_sku: list[str]
    :ivar available_os: Available OSs in region.
    :vartype available_os: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "standard": {"readonly": True},
        "dedicated_host": {"readonly": True},
        "zone_redundant": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "standard": {"key": "properties.standard", "type": "bool"},
        "dedicated_host": {"key": "properties.dedicatedHost", "type": "bool"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "available_sku": {"key": "properties.availableSku", "type": "[str]"},
        "available_os": {"key": "properties.availableOS", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        available_sku: Optional[List[str]] = None,
        available_os: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword available_sku: Available Skus in region.
        :paramtype available_sku: list[str]
        :keyword available_os: Available OSs in region.
        :paramtype available_os: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.display_name = None
        self.standard = None
        self.dedicated_host = None
        self.zone_redundant = None
        self.available_sku = available_sku
        self.available_os = available_os


class AseRegionCollection(_serialization.Model):
    """Collection of ASE regions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.AseRegion]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AseRegion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AseRegion"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.AseRegion]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AseV3NetworkingConfiguration(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Full view of networking configuration for an ASE.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar windows_outbound_ip_addresses:
    :vartype windows_outbound_ip_addresses: list[str]
    :ivar linux_outbound_ip_addresses:
    :vartype linux_outbound_ip_addresses: list[str]
    :ivar external_inbound_ip_addresses:
    :vartype external_inbound_ip_addresses: list[str]
    :ivar internal_inbound_ip_addresses:
    :vartype internal_inbound_ip_addresses: list[str]
    :ivar allow_new_private_endpoint_connections: Property to enable and disable new private
     endpoint connection creation on ASE.
    :vartype allow_new_private_endpoint_connections: bool
    :ivar ftp_enabled: Property to enable and disable FTP on ASEV3.
    :vartype ftp_enabled: bool
    :ivar remote_debug_enabled: Property to enable and disable Remote Debug on ASEV3.
    :vartype remote_debug_enabled: bool
    :ivar inbound_ip_address_override: Customer provided Inbound IP Address. Only able to be set on
     Ase create.
    :vartype inbound_ip_address_override: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "windows_outbound_ip_addresses": {"readonly": True},
        "linux_outbound_ip_addresses": {"readonly": True},
        "external_inbound_ip_addresses": {"readonly": True},
        "internal_inbound_ip_addresses": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "windows_outbound_ip_addresses": {"key": "properties.windowsOutboundIpAddresses", "type": "[str]"},
        "linux_outbound_ip_addresses": {"key": "properties.linuxOutboundIpAddresses", "type": "[str]"},
        "external_inbound_ip_addresses": {"key": "properties.externalInboundIpAddresses", "type": "[str]"},
        "internal_inbound_ip_addresses": {"key": "properties.internalInboundIpAddresses", "type": "[str]"},
        "allow_new_private_endpoint_connections": {
            "key": "properties.allowNewPrivateEndpointConnections",
            "type": "bool",
        },
        "ftp_enabled": {"key": "properties.ftpEnabled", "type": "bool"},
        "remote_debug_enabled": {"key": "properties.remoteDebugEnabled", "type": "bool"},
        "inbound_ip_address_override": {"key": "properties.inboundIpAddressOverride", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        allow_new_private_endpoint_connections: Optional[bool] = None,
        ftp_enabled: Optional[bool] = None,
        remote_debug_enabled: Optional[bool] = None,
        inbound_ip_address_override: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword allow_new_private_endpoint_connections: Property to enable and disable new private
         endpoint connection creation on ASE.
        :paramtype allow_new_private_endpoint_connections: bool
        :keyword ftp_enabled: Property to enable and disable FTP on ASEV3.
        :paramtype ftp_enabled: bool
        :keyword remote_debug_enabled: Property to enable and disable Remote Debug on ASEV3.
        :paramtype remote_debug_enabled: bool
        :keyword inbound_ip_address_override: Customer provided Inbound IP Address. Only able to be set
         on Ase create.
        :paramtype inbound_ip_address_override: str
        """
        super().__init__(kind=kind, **kwargs)
        self.windows_outbound_ip_addresses = None
        self.linux_outbound_ip_addresses = None
        self.external_inbound_ip_addresses = None
        self.internal_inbound_ip_addresses = None
        self.allow_new_private_endpoint_connections = allow_new_private_endpoint_connections
        self.ftp_enabled = ftp_enabled
        self.remote_debug_enabled = remote_debug_enabled
        self.inbound_ip_address_override = inbound_ip_address_override


class AuthPlatform(_serialization.Model):
    """The configuration settings of the platform of App Service Authentication/Authorization.

    :ivar enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :vartype runtime_version: str
    :ivar config_file_path: The path of the config file containing auth settings if they come from
     a file.
     If the path is relative, base will the site's root directory.
    :vartype config_file_path: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "config_file_path": {"key": "configFilePath", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        runtime_version: Optional[str] = None,
        config_file_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
         enabled for the current app; otherwise, :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword runtime_version: The RuntimeVersion of the Authentication / Authorization feature in
         use for the current app.
         The setting in this value can control the behavior of certain features in the Authentication /
         Authorization module.
        :paramtype runtime_version: str
        :keyword config_file_path: The path of the config file containing auth settings if they come
         from a file.
         If the path is relative, base will the site's root directory.
        :paramtype config_file_path: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version
        self.config_file_path = config_file_path


class AutoHealActions(_serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :ivar action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent", and
     "CustomAction".
    :vartype action_type: str or ~azure.mgmt.web.v2023_01_01.models.AutoHealActionType
    :ivar custom_action: Custom action to be taken.
    :vartype custom_action: ~azure.mgmt.web.v2023_01_01.models.AutoHealCustomAction
    :ivar min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :vartype min_process_execution_time: str
    """

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "custom_action": {"key": "customAction", "type": "AutoHealCustomAction"},
        "min_process_execution_time": {"key": "minProcessExecutionTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.AutoHealActionType"]] = None,
        custom_action: Optional["_models.AutoHealCustomAction"] = None,
        min_process_execution_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent",
         and "CustomAction".
        :paramtype action_type: str or ~azure.mgmt.web.v2023_01_01.models.AutoHealActionType
        :keyword custom_action: Custom action to be taken.
        :paramtype custom_action: ~azure.mgmt.web.v2023_01_01.models.AutoHealCustomAction
        :keyword min_process_execution_time: Minimum time the process must execute
         before taking the action.
        :paramtype min_process_execution_time: str
        """
        super().__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(_serialization.Model):
    """Custom action to be executed
    when an auto heal rule is triggered.

    :ivar exe: Executable to be run.
    :vartype exe: str
    :ivar parameters: Parameters for the executable.
    :vartype parameters: str
    """

    _attribute_map = {
        "exe": {"key": "exe", "type": "str"},
        "parameters": {"key": "parameters", "type": "str"},
    }

    def __init__(self, *, exe: Optional[str] = None, parameters: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword exe: Executable to be run.
        :paramtype exe: str
        :keyword parameters: Parameters for the executable.
        :paramtype parameters: str
        """
        super().__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(_serialization.Model):
    """Rules that can be defined for auto-heal.

    :ivar triggers: Conditions that describe when to execute the auto-heal actions.
    :vartype triggers: ~azure.mgmt.web.v2023_01_01.models.AutoHealTriggers
    :ivar actions: Actions to be executed when a rule is triggered.
    :vartype actions: ~azure.mgmt.web.v2023_01_01.models.AutoHealActions
    """

    _attribute_map = {
        "triggers": {"key": "triggers", "type": "AutoHealTriggers"},
        "actions": {"key": "actions", "type": "AutoHealActions"},
    }

    def __init__(
        self,
        *,
        triggers: Optional["_models.AutoHealTriggers"] = None,
        actions: Optional["_models.AutoHealActions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword triggers: Conditions that describe when to execute the auto-heal actions.
        :paramtype triggers: ~azure.mgmt.web.v2023_01_01.models.AutoHealTriggers
        :keyword actions: Actions to be executed when a rule is triggered.
        :paramtype actions: ~azure.mgmt.web.v2023_01_01.models.AutoHealActions
        """
        super().__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(_serialization.Model):
    """Triggers for auto-heal.

    :ivar requests: A rule based on total requests.
    :vartype requests: ~azure.mgmt.web.v2023_01_01.models.RequestsBasedTrigger
    :ivar private_bytes_in_kb: A rule based on private bytes.
    :vartype private_bytes_in_kb: int
    :ivar status_codes: A rule based on status codes.
    :vartype status_codes: list[~azure.mgmt.web.v2023_01_01.models.StatusCodesBasedTrigger]
    :ivar slow_requests: A rule based on request execution time.
    :vartype slow_requests: ~azure.mgmt.web.v2023_01_01.models.SlowRequestsBasedTrigger
    :ivar slow_requests_with_path: A rule based on multiple Slow Requests Rule with path.
    :vartype slow_requests_with_path:
     list[~azure.mgmt.web.v2023_01_01.models.SlowRequestsBasedTrigger]
    :ivar status_codes_range: A rule based on status codes ranges.
    :vartype status_codes_range:
     list[~azure.mgmt.web.v2023_01_01.models.StatusCodesRangeBasedTrigger]
    """

    _attribute_map = {
        "requests": {"key": "requests", "type": "RequestsBasedTrigger"},
        "private_bytes_in_kb": {"key": "privateBytesInKB", "type": "int"},
        "status_codes": {"key": "statusCodes", "type": "[StatusCodesBasedTrigger]"},
        "slow_requests": {"key": "slowRequests", "type": "SlowRequestsBasedTrigger"},
        "slow_requests_with_path": {"key": "slowRequestsWithPath", "type": "[SlowRequestsBasedTrigger]"},
        "status_codes_range": {"key": "statusCodesRange", "type": "[StatusCodesRangeBasedTrigger]"},
    }

    def __init__(
        self,
        *,
        requests: Optional["_models.RequestsBasedTrigger"] = None,
        private_bytes_in_kb: Optional[int] = None,
        status_codes: Optional[List["_models.StatusCodesBasedTrigger"]] = None,
        slow_requests: Optional["_models.SlowRequestsBasedTrigger"] = None,
        slow_requests_with_path: Optional[List["_models.SlowRequestsBasedTrigger"]] = None,
        status_codes_range: Optional[List["_models.StatusCodesRangeBasedTrigger"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword requests: A rule based on total requests.
        :paramtype requests: ~azure.mgmt.web.v2023_01_01.models.RequestsBasedTrigger
        :keyword private_bytes_in_kb: A rule based on private bytes.
        :paramtype private_bytes_in_kb: int
        :keyword status_codes: A rule based on status codes.
        :paramtype status_codes: list[~azure.mgmt.web.v2023_01_01.models.StatusCodesBasedTrigger]
        :keyword slow_requests: A rule based on request execution time.
        :paramtype slow_requests: ~azure.mgmt.web.v2023_01_01.models.SlowRequestsBasedTrigger
        :keyword slow_requests_with_path: A rule based on multiple Slow Requests Rule with path.
        :paramtype slow_requests_with_path:
         list[~azure.mgmt.web.v2023_01_01.models.SlowRequestsBasedTrigger]
        :keyword status_codes_range: A rule based on status codes ranges.
        :paramtype status_codes_range:
         list[~azure.mgmt.web.v2023_01_01.models.StatusCodesRangeBasedTrigger]
        """
        super().__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests
        self.slow_requests_with_path = slow_requests_with_path
        self.status_codes_range = status_codes_range


class AzureActiveDirectory(_serialization.Model):
    """The configuration settings of the Azure Active directory provider.

    :ivar enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Azure Active Directory app registration.
    :vartype registration: ~azure.mgmt.web.v2023_01_01.models.AzureActiveDirectoryRegistration
    :ivar login: The configuration settings of the Azure Active Directory login flow.
    :vartype login: ~azure.mgmt.web.v2023_01_01.models.AzureActiveDirectoryLogin
    :ivar validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :vartype validation: ~azure.mgmt.web.v2023_01_01.models.AzureActiveDirectoryValidation
    :ivar is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
     auto-provisioned using 1st party tooling.
     This is an internal flag primarily intended to support the Azure Management Portal. Users
     should not
     read or write to this property.
    :vartype is_auto_provisioned: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "AzureActiveDirectoryRegistration"},
        "login": {"key": "login", "type": "AzureActiveDirectoryLogin"},
        "validation": {"key": "validation", "type": "AzureActiveDirectoryValidation"},
        "is_auto_provisioned": {"key": "isAutoProvisioned", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.AzureActiveDirectoryRegistration"] = None,
        login: Optional["_models.AzureActiveDirectoryLogin"] = None,
        validation: Optional["_models.AzureActiveDirectoryValidation"] = None,
        is_auto_provisioned: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not
         be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Azure Active Directory app
         registration.
        :paramtype registration: ~azure.mgmt.web.v2023_01_01.models.AzureActiveDirectoryRegistration
        :keyword login: The configuration settings of the Azure Active Directory login flow.
        :paramtype login: ~azure.mgmt.web.v2023_01_01.models.AzureActiveDirectoryLogin
        :keyword validation: The configuration settings of the Azure Active Directory token validation
         flow.
        :paramtype validation: ~azure.mgmt.web.v2023_01_01.models.AzureActiveDirectoryValidation
        :keyword is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
         auto-provisioned using 1st party tooling.
         This is an internal flag primarily intended to support the Azure Management Portal. Users
         should not
         read or write to this property.
        :paramtype is_auto_provisioned: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation
        self.is_auto_provisioned = is_auto_provisioned


class AzureActiveDirectoryLogin(_serialization.Model):
    """The configuration settings of the Azure Active Directory login flow.

    :ivar login_parameters: Login parameters to send to the OpenID Connect authorization endpoint
     when
     a user logs in. Each parameter must be in the form "key=value".
    :vartype login_parameters: list[str]
    :ivar disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
     should be omitted from the request; otherwise, :code:`<code>false</code>`.
    :vartype disable_www_authenticate: bool
    """

    _attribute_map = {
        "login_parameters": {"key": "loginParameters", "type": "[str]"},
        "disable_www_authenticate": {"key": "disableWWWAuthenticate", "type": "bool"},
    }

    def __init__(
        self,
        *,
        login_parameters: Optional[List[str]] = None,
        disable_www_authenticate: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword login_parameters: Login parameters to send to the OpenID Connect authorization
         endpoint when
         a user logs in. Each parameter must be in the form "key=value".
        :paramtype login_parameters: list[str]
        :keyword disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
         should be omitted from the request; otherwise, :code:`<code>false</code>`.
        :paramtype disable_www_authenticate: bool
        """
        super().__init__(**kwargs)
        self.login_parameters = login_parameters
        self.disable_www_authenticate = disable_www_authenticate


class AzureActiveDirectoryRegistration(_serialization.Model):
    """The configuration settings of the Azure Active Directory app registration.

    :ivar open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
     access tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://login.microsoftonline.com/v2.0/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :vartype open_id_issuer: str
    :ivar client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret of the
     relying party application.
    :vartype client_secret_setting_name: str
    :ivar client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :vartype client_secret_certificate_thumbprint: str
    :ivar client_secret_certificate_subject_alternative_name: An alternative to the client secret
     thumbprint, that is the subject alternative name of a certificate used for signing purposes.
     This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :vartype client_secret_certificate_subject_alternative_name: str
    :ivar client_secret_certificate_issuer: An alternative to the client secret thumbprint, that is
     the issuer of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :vartype client_secret_certificate_issuer: str
    """

    _attribute_map = {
        "open_id_issuer": {"key": "openIdIssuer", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_setting_name": {"key": "clientSecretSettingName", "type": "str"},
        "client_secret_certificate_thumbprint": {"key": "clientSecretCertificateThumbprint", "type": "str"},
        "client_secret_certificate_subject_alternative_name": {
            "key": "clientSecretCertificateSubjectAlternativeName",
            "type": "str",
        },
        "client_secret_certificate_issuer": {"key": "clientSecretCertificateIssuer", "type": "str"},
    }

    def __init__(
        self,
        *,
        open_id_issuer: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        client_secret_certificate_thumbprint: Optional[str] = None,
        client_secret_certificate_subject_alternative_name: Optional[str] = None,
        client_secret_certificate_issuer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
         access tokens for this application.
         When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
         https://login.microsoftonline.com/v2.0/{tenant-guid}/.
         This URI is a case-sensitive identifier for the token issuer.
         More information on OpenID Connect Discovery:
         http://openid.net/specs/openid-connect-discovery-1_0.html.
        :paramtype open_id_issuer: str
        :keyword client_id: The Client ID of this relying party application, known as the client_id.
         This setting is required for enabling OpenID Connection authentication with Azure Active
         Directory or
         other 3rd party OpenID Connect providers.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret of
         the relying party application.
        :paramtype client_secret_setting_name: str
        :keyword client_secret_certificate_thumbprint: An alternative to the client secret, that is the
         thumbprint of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret. It is also optional.
        :paramtype client_secret_certificate_thumbprint: str
        :keyword client_secret_certificate_subject_alternative_name: An alternative to the client
         secret thumbprint, that is the subject alternative name of a certificate used for signing
         purposes. This property acts as
         a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :paramtype client_secret_certificate_subject_alternative_name: str
        :keyword client_secret_certificate_issuer: An alternative to the client secret thumbprint, that
         is the issuer of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :paramtype client_secret_certificate_issuer: str
        """
        super().__init__(**kwargs)
        self.open_id_issuer = open_id_issuer
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name
        self.client_secret_certificate_thumbprint = client_secret_certificate_thumbprint
        self.client_secret_certificate_subject_alternative_name = client_secret_certificate_subject_alternative_name
        self.client_secret_certificate_issuer = client_secret_certificate_issuer


class AzureActiveDirectoryValidation(_serialization.Model):
    """The configuration settings of the Azure Active Directory token validation flow.

    :ivar jwt_claim_checks: The configuration settings of the checks that should be made while
     validating the JWT Claims.
    :vartype jwt_claim_checks: ~azure.mgmt.web.v2023_01_01.models.JwtClaimChecks
    :ivar allowed_audiences: The list of audiences that can make successful
     authentication/authorization requests.
    :vartype allowed_audiences: list[str]
    :ivar default_authorization_policy: The configuration settings of the default authorization
     policy.
    :vartype default_authorization_policy:
     ~azure.mgmt.web.v2023_01_01.models.DefaultAuthorizationPolicy
    """

    _attribute_map = {
        "jwt_claim_checks": {"key": "jwtClaimChecks", "type": "JwtClaimChecks"},
        "allowed_audiences": {"key": "allowedAudiences", "type": "[str]"},
        "default_authorization_policy": {"key": "defaultAuthorizationPolicy", "type": "DefaultAuthorizationPolicy"},
    }

    def __init__(
        self,
        *,
        jwt_claim_checks: Optional["_models.JwtClaimChecks"] = None,
        allowed_audiences: Optional[List[str]] = None,
        default_authorization_policy: Optional["_models.DefaultAuthorizationPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword jwt_claim_checks: The configuration settings of the checks that should be made while
         validating the JWT Claims.
        :paramtype jwt_claim_checks: ~azure.mgmt.web.v2023_01_01.models.JwtClaimChecks
        :keyword allowed_audiences: The list of audiences that can make successful
         authentication/authorization requests.
        :paramtype allowed_audiences: list[str]
        :keyword default_authorization_policy: The configuration settings of the default authorization
         policy.
        :paramtype default_authorization_policy:
         ~azure.mgmt.web.v2023_01_01.models.DefaultAuthorizationPolicy
        """
        super().__init__(**kwargs)
        self.jwt_claim_checks = jwt_claim_checks
        self.allowed_audiences = allowed_audiences
        self.default_authorization_policy = default_authorization_policy


class AzureBlobStorageApplicationLogsConfig(_serialization.Model):
    """Application logs azure blob storage configuration.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2023_01_01.models.LogLevel
    :ivar sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :vartype sas_url: str
    :ivar retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    """

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "sas_url": {"key": "sasUrl", "type": "str"},
        "retention_in_days": {"key": "retentionInDays", "type": "int"},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "_models.LogLevel"]] = None,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2023_01_01.models.LogLevel
        :keyword sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        :paramtype sas_url: str
        :keyword retention_in_days: Retention in days.
         Remove blobs older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        """
        super().__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days


class AzureBlobStorageHttpLogsConfig(_serialization.Model):
    """Http logs to azure blob storage configuration.

    :ivar sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :vartype sas_url: str
    :ivar retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _attribute_map = {
        "sas_url": {"key": "sasUrl", "type": "str"},
        "retention_in_days": {"key": "retentionInDays", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        :paramtype sas_url: str
        :keyword retention_in_days: Retention in days.
         Remove blobs older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class ErrorInfo(_serialization.Model):
    """The error info.

    All required parameters must be populated in order to send to server.

    :ivar code: The error code. Required.
    :vartype code: str
    """

    _validation = {
        "code": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, code: str, **kwargs: Any) -> None:
        """
        :keyword code: The error code. Required.
        :paramtype code: str
        """
        super().__init__(**kwargs)
        self.code = code


class AzureResourceErrorInfo(ErrorInfo):
    """The azure resource error info.

    All required parameters must be populated in order to send to server.

    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: The error message. Required.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.web.v2023_01_01.models.AzureResourceErrorInfo]
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[AzureResourceErrorInfo]"},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["_models.AzureResourceErrorInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code. Required.
        :paramtype code: str
        :keyword message: The error message. Required.
        :paramtype message: str
        :keyword details: The error details.
        :paramtype details: list[~azure.mgmt.web.v2023_01_01.models.AzureResourceErrorInfo]
        """
        super().__init__(code=code, **kwargs)
        self.message = message
        self.details = details


class AzureStaticWebApps(_serialization.Model):
    """The configuration settings of the Azure Static Web Apps provider.

    :ivar enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Azure Static Web Apps registration.
    :vartype registration: ~azure.mgmt.web.v2023_01_01.models.AzureStaticWebAppsRegistration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "AzureStaticWebAppsRegistration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.AzureStaticWebAppsRegistration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not
         be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Azure Static Web Apps registration.
        :paramtype registration: ~azure.mgmt.web.v2023_01_01.models.AzureStaticWebAppsRegistration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration


class AzureStaticWebAppsRegistration(_serialization.Model):
    """The configuration settings of the registration for the Azure Static Web Apps provider.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, *, client_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id


class AzureStorageInfoValue(_serialization.Model):
    """Azure Files or Blob Storage access information value for dictionary storage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of storage. Known values are: "AzureFiles" and "AzureBlob".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.AzureStorageType
    :ivar account_name: Name of the storage account.
    :vartype account_name: str
    :ivar share_name: Name of the file share (container name, for Blob storage).
    :vartype share_name: str
    :ivar access_key: Access key for the storage account.
    :vartype access_key: str
    :ivar mount_path: Path to mount the storage within the site's runtime environment.
    :vartype mount_path: str
    :ivar state: State of the storage account. Known values are: "Ok", "InvalidCredentials",
     "InvalidShare", and "NotValidated".
    :vartype state: str or ~azure.mgmt.web.v2023_01_01.models.AzureStorageState
    """

    _validation = {
        "state": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "share_name": {"key": "shareName", "type": "str"},
        "access_key": {"key": "accessKey", "type": "str"},
        "mount_path": {"key": "mountPath", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.AzureStorageType"]] = None,
        account_name: Optional[str] = None,
        share_name: Optional[str] = None,
        access_key: Optional[str] = None,
        mount_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of storage. Known values are: "AzureFiles" and "AzureBlob".
        :paramtype type: str or ~azure.mgmt.web.v2023_01_01.models.AzureStorageType
        :keyword account_name: Name of the storage account.
        :paramtype account_name: str
        :keyword share_name: Name of the file share (container name, for Blob storage).
        :paramtype share_name: str
        :keyword access_key: Access key for the storage account.
        :paramtype access_key: str
        :keyword mount_path: Path to mount the storage within the site's runtime environment.
        :paramtype mount_path: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.account_name = account_name
        self.share_name = share_name
        self.access_key = access_key
        self.mount_path = mount_path
        self.state = None


class AzureStoragePropertyDictionaryResource(ProxyOnlyResource):
    """AzureStorageInfo dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Azure storage accounts.
    :vartype properties: dict[str, ~azure.mgmt.web.v2023_01_01.models.AzureStorageInfoValue]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "{AzureStorageInfoValue}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "_models.AzureStorageInfoValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Azure storage accounts.
        :paramtype properties: dict[str, ~azure.mgmt.web.v2023_01_01.models.AzureStorageInfoValue]
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class AzureTableStorageApplicationLogsConfig(_serialization.Model):
    """Application logs to Azure table storage configuration.

    All required parameters must be populated in order to send to server.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2023_01_01.models.LogLevel
    :ivar sas_url: SAS URL to an Azure table with add/query/delete permissions. Required.
    :vartype sas_url: str
    """

    _validation = {
        "sas_url": {"required": True},
    }

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "sas_url": {"key": "sasUrl", "type": "str"},
    }

    def __init__(self, *, sas_url: str, level: Optional[Union[str, "_models.LogLevel"]] = None, **kwargs: Any) -> None:
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2023_01_01.models.LogLevel
        :keyword sas_url: SAS URL to an Azure table with add/query/delete permissions. Required.
        :paramtype sas_url: str
        """
        super().__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url


class BackupItem(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Backup description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: Id of the backup.
    :vartype backup_id: int
    :ivar storage_account_url: SAS URL for the storage account container which contains this
     backup.
    :vartype storage_account_url: str
    :ivar blob_name: Name of the blob which contains data for this backup.
    :vartype blob_name: str
    :ivar name_properties_name: Name of this backup.
    :vartype name_properties_name: str
    :ivar status: Backup status. Known values are: "InProgress", "Failed", "Succeeded", "TimedOut",
     "Created", "Skipped", "PartiallySucceeded", "DeleteInProgress", "DeleteFailed", and "Deleted".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.BackupItemStatus
    :ivar size_in_bytes: Size of the backup in bytes.
    :vartype size_in_bytes: int
    :ivar created: Timestamp of the backup creation.
    :vartype created: ~datetime.datetime
    :ivar log: Details regarding this backup. Might contain an error message.
    :vartype log: str
    :ivar databases: List of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2023_01_01.models.DatabaseBackupSetting]
    :ivar scheduled: True if this backup has been created due to a schedule being triggered.
    :vartype scheduled: bool
    :ivar last_restore_time_stamp: Timestamp of a last restore operation which used this backup.
    :vartype last_restore_time_stamp: ~datetime.datetime
    :ivar finished_time_stamp: Timestamp when this backup finished.
    :vartype finished_time_stamp: ~datetime.datetime
    :ivar correlation_id: Unique correlation identifier. Please use this along with the timestamp
     while communicating with Azure support.
    :vartype correlation_id: str
    :ivar website_size_in_bytes: Size of the original web app which has been backed up.
    :vartype website_size_in_bytes: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "backup_id": {"readonly": True},
        "storage_account_url": {"readonly": True},
        "blob_name": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "status": {"readonly": True},
        "size_in_bytes": {"readonly": True},
        "created": {"readonly": True},
        "log": {"readonly": True},
        "databases": {"readonly": True},
        "scheduled": {"readonly": True},
        "last_restore_time_stamp": {"readonly": True},
        "finished_time_stamp": {"readonly": True},
        "correlation_id": {"readonly": True},
        "website_size_in_bytes": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backup_id": {"key": "properties.id", "type": "int"},
        "storage_account_url": {"key": "properties.storageAccountUrl", "type": "str"},
        "blob_name": {"key": "properties.blobName", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "size_in_bytes": {"key": "properties.sizeInBytes", "type": "int"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "log": {"key": "properties.log", "type": "str"},
        "databases": {"key": "properties.databases", "type": "[DatabaseBackupSetting]"},
        "scheduled": {"key": "properties.scheduled", "type": "bool"},
        "last_restore_time_stamp": {"key": "properties.lastRestoreTimeStamp", "type": "iso-8601"},
        "finished_time_stamp": {"key": "properties.finishedTimeStamp", "type": "iso-8601"},
        "correlation_id": {"key": "properties.correlationId", "type": "str"},
        "website_size_in_bytes": {"key": "properties.websiteSizeInBytes", "type": "int"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.backup_id = None
        self.storage_account_url = None
        self.blob_name = None
        self.name_properties_name = None
        self.status = None
        self.size_in_bytes = None
        self.created = None
        self.log = None
        self.databases = None
        self.scheduled = None
        self.last_restore_time_stamp = None
        self.finished_time_stamp = None
        self.correlation_id = None
        self.website_size_in_bytes = None


class BackupItemCollection(_serialization.Model):
    """Collection of backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.BackupItem]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BackupItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.BackupItem"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.BackupItem]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class BackupRequest(ProxyOnlyResource):
    """Description of a backup which will be performed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_name: Name of the backup.
    :vartype backup_name: str
    :ivar enabled: True if the backup schedule is enabled (must be included in that case), false if
     the backup schedule should be disabled.
    :vartype enabled: bool
    :ivar storage_account_url: SAS URL to the container.
    :vartype storage_account_url: str
    :ivar backup_schedule: Schedule for the backup if it is executed periodically.
    :vartype backup_schedule: ~azure.mgmt.web.v2023_01_01.models.BackupSchedule
    :ivar databases: Databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2023_01_01.models.DatabaseBackupSetting]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backup_name": {"key": "properties.backupName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "storage_account_url": {"key": "properties.storageAccountUrl", "type": "str"},
        "backup_schedule": {"key": "properties.backupSchedule", "type": "BackupSchedule"},
        "databases": {"key": "properties.databases", "type": "[DatabaseBackupSetting]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        backup_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        storage_account_url: Optional[str] = None,
        backup_schedule: Optional["_models.BackupSchedule"] = None,
        databases: Optional[List["_models.DatabaseBackupSetting"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword backup_name: Name of the backup.
        :paramtype backup_name: str
        :keyword enabled: True if the backup schedule is enabled (must be included in that case), false
         if the backup schedule should be disabled.
        :paramtype enabled: bool
        :keyword storage_account_url: SAS URL to the container.
        :paramtype storage_account_url: str
        :keyword backup_schedule: Schedule for the backup if it is executed periodically.
        :paramtype backup_schedule: ~azure.mgmt.web.v2023_01_01.models.BackupSchedule
        :keyword databases: Databases included in the backup.
        :paramtype databases: list[~azure.mgmt.web.v2023_01_01.models.DatabaseBackupSetting]
        """
        super().__init__(kind=kind, **kwargs)
        self.backup_name = backup_name
        self.enabled = enabled
        self.storage_account_url = storage_account_url
        self.backup_schedule = backup_schedule
        self.databases = databases


class BackupSchedule(_serialization.Model):
    """Description of a backup schedule. Describes how often should be the backup performed and what
    should be the retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar frequency_interval: How often the backup should be executed (e.g. for weekly backup, this
     should be set to 7 and FrequencyUnit should be set to Day).
    :vartype frequency_interval: int
    :ivar frequency_unit: The unit of time for how often the backup should be executed (e.g. for
     weekly backup, this should be set to Day and FrequencyInterval should be set to 7). Known
     values are: "Day" and "Hour".
    :vartype frequency_unit: str or ~azure.mgmt.web.v2023_01_01.models.FrequencyUnit
    :ivar keep_at_least_one_backup: True if the retention policy should always keep at least one
     backup in the storage account, regardless how old it is; false otherwise.
    :vartype keep_at_least_one_backup: bool
    :ivar retention_period_in_days: After how many days backups should be deleted.
    :vartype retention_period_in_days: int
    :ivar start_time: When the schedule should start working.
    :vartype start_time: ~datetime.datetime
    :ivar last_execution_time: Last time when this schedule was triggered.
    :vartype last_execution_time: ~datetime.datetime
    """

    _validation = {
        "frequency_interval": {"required": True},
        "frequency_unit": {"required": True},
        "keep_at_least_one_backup": {"required": True},
        "retention_period_in_days": {"required": True},
        "last_execution_time": {"readonly": True},
    }

    _attribute_map = {
        "frequency_interval": {"key": "frequencyInterval", "type": "int"},
        "frequency_unit": {"key": "frequencyUnit", "type": "str"},
        "keep_at_least_one_backup": {"key": "keepAtLeastOneBackup", "type": "bool"},
        "retention_period_in_days": {"key": "retentionPeriodInDays", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_execution_time": {"key": "lastExecutionTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        frequency_interval: int = 7,
        frequency_unit: Union[str, "_models.FrequencyUnit"] = "Day",
        keep_at_least_one_backup: bool = True,
        retention_period_in_days: int = 30,
        start_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword frequency_interval: How often the backup should be executed (e.g. for weekly backup,
         this should be set to 7 and FrequencyUnit should be set to Day).
        :paramtype frequency_interval: int
        :keyword frequency_unit: The unit of time for how often the backup should be executed (e.g. for
         weekly backup, this should be set to Day and FrequencyInterval should be set to 7). Known
         values are: "Day" and "Hour".
        :paramtype frequency_unit: str or ~azure.mgmt.web.v2023_01_01.models.FrequencyUnit
        :keyword keep_at_least_one_backup: True if the retention policy should always keep at least one
         backup in the storage account, regardless how old it is; false otherwise.
        :paramtype keep_at_least_one_backup: bool
        :keyword retention_period_in_days: After how many days backups should be deleted.
        :paramtype retention_period_in_days: int
        :keyword start_time: When the schedule should start working.
        :paramtype start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.frequency_interval = frequency_interval
        self.frequency_unit = frequency_unit
        self.keep_at_least_one_backup = keep_at_least_one_backup
        self.retention_period_in_days = retention_period_in_days
        self.start_time = start_time
        self.last_execution_time = None


class BillingMeter(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """App Service billing entity that contains information about meter which the Azure billing system
    utilizes to charge users for services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar meter_id: Meter GUID onboarded in Commerce.
    :vartype meter_id: str
    :ivar billing_location: Azure Location of billable resource.
    :vartype billing_location: str
    :ivar short_name: Short Name from App Service Azure pricing Page.
    :vartype short_name: str
    :ivar friendly_name: Friendly name of the meter.
    :vartype friendly_name: str
    :ivar resource_type: App Service ResourceType meter used for.
    :vartype resource_type: str
    :ivar os_type: App Service OS type meter used for.
    :vartype os_type: str
    :ivar multiplier: Meter Multiplier.
    :vartype multiplier: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "meter_id": {"key": "properties.meterId", "type": "str"},
        "billing_location": {"key": "properties.billingLocation", "type": "str"},
        "short_name": {"key": "properties.shortName", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "resource_type": {"key": "properties.resourceType", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "multiplier": {"key": "properties.multiplier", "type": "float"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        meter_id: Optional[str] = None,
        billing_location: Optional[str] = None,
        short_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        os_type: Optional[str] = None,
        multiplier: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword meter_id: Meter GUID onboarded in Commerce.
        :paramtype meter_id: str
        :keyword billing_location: Azure Location of billable resource.
        :paramtype billing_location: str
        :keyword short_name: Short Name from App Service Azure pricing Page.
        :paramtype short_name: str
        :keyword friendly_name: Friendly name of the meter.
        :paramtype friendly_name: str
        :keyword resource_type: App Service ResourceType meter used for.
        :paramtype resource_type: str
        :keyword os_type: App Service OS type meter used for.
        :paramtype os_type: str
        :keyword multiplier: Meter Multiplier.
        :paramtype multiplier: float
        """
        super().__init__(kind=kind, **kwargs)
        self.meter_id = meter_id
        self.billing_location = billing_location
        self.short_name = short_name
        self.friendly_name = friendly_name
        self.resource_type = resource_type
        self.os_type = os_type
        self.multiplier = multiplier


class BillingMeterCollection(_serialization.Model):
    """Collection of Billing Meters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.BillingMeter]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BillingMeter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.BillingMeter"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.BillingMeter]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class BlobStorageTokenStore(_serialization.Model):
    """The configuration settings of the storage of the tokens if blob storage is used.

    :ivar sas_url_setting_name: The name of the app setting containing the SAS URL of the blob
     storage containing the tokens.
    :vartype sas_url_setting_name: str
    """

    _attribute_map = {
        "sas_url_setting_name": {"key": "sasUrlSettingName", "type": "str"},
    }

    def __init__(self, *, sas_url_setting_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword sas_url_setting_name: The name of the app setting containing the SAS URL of the blob
         storage containing the tokens.
        :paramtype sas_url_setting_name: str
        """
        super().__init__(**kwargs)
        self.sas_url_setting_name = sas_url_setting_name


class Capability(_serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :ivar name: Name of the SKU capability.
    :vartype name: str
    :ivar value: Value of the SKU capability.
    :vartype value: str
    :ivar reason: Reason of the SKU capability.
    :vartype reason: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[str] = None, reason: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the SKU capability.
        :paramtype name: str
        :keyword value: Value of the SKU capability.
        :paramtype value: str
        :keyword reason: Reason of the SKU capability.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.reason = reason


class Certificate(Resource):  # pylint: disable=too-many-instance-attributes
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar password: Certificate password.
    :vartype password: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytes
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytes
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2023_01_01.models.KeyVaultSecretStatus
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".  # pylint: disable=line-too-long
    :vartype server_farm_id: str
    :ivar canonical_name: CNAME of the certificate to be issued via free certificate.
    :vartype canonical_name: str
    :ivar domain_validation_method: Method of domain validation for free cert.
    :vartype domain_validation_method: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "subject_name": {"readonly": True},
        "site_name": {"readonly": True},
        "self_link": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "cer_blob": {"readonly": True},
        "public_key_hash": {"readonly": True},
        "hosting_environment_profile": {"readonly": True},
        "key_vault_secret_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "password": {"key": "properties.password", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "subject_name": {"key": "properties.subjectName", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "pfx_blob": {"key": "properties.pfxBlob", "type": "bytearray"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "self_link": {"key": "properties.selfLink", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "issue_date": {"key": "properties.issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "valid": {"key": "properties.valid", "type": "bool"},
        "cer_blob": {"key": "properties.cerBlob", "type": "bytearray"},
        "public_key_hash": {"key": "properties.publicKeyHash", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_status": {"key": "properties.keyVaultSecretStatus", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "canonical_name": {"key": "properties.canonicalName", "type": "str"},
        "domain_validation_method": {"key": "properties.domainValidationMethod", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        password: Optional[str] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytes] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        canonical_name: Optional[str] = None,
        domain_validation_method: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytes
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".  # pylint: disable=line-too-long
        :paramtype server_farm_id: str
        :keyword canonical_name: CNAME of the certificate to be issued via free certificate.
        :paramtype canonical_name: str
        :keyword domain_validation_method: Method of domain validation for free cert.
        :paramtype domain_validation_method: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.password = password
        self.friendly_name = None
        self.subject_name = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status = None
        self.server_farm_id = server_farm_id
        self.canonical_name = canonical_name
        self.domain_validation_method = domain_validation_method


class CertificateCollection(_serialization.Model):
    """Collection of certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Certificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Certificate"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.Certificate]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CertificateDetails(_serialization.Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: ~datetime.datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: ~datetime.datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        "version": {"readonly": True},
        "serial_number": {"readonly": True},
        "thumbprint": {"readonly": True},
        "subject": {"readonly": True},
        "not_before": {"readonly": True},
        "not_after": {"readonly": True},
        "signature_algorithm": {"readonly": True},
        "issuer": {"readonly": True},
        "raw_data": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "int"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "not_before": {"key": "notBefore", "type": "iso-8601"},
        "not_after": {"key": "notAfter", "type": "iso-8601"},
        "signature_algorithm": {"key": "signatureAlgorithm", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "raw_data": {"key": "rawData", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.serial_number = None
        self.thumbprint = None
        self.subject = None
        self.not_before = None
        self.not_after = None
        self.signature_algorithm = None
        self.issuer = None
        self.raw_data = None


class CertificateEmail(_serialization.Model):
    """SSL certificate email.

    :ivar email_id: Email id.
    :vartype email_id: str
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    """

    _attribute_map = {
        "email_id": {"key": "emailId", "type": "str"},
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
    }

    def __init__(
        self, *, email_id: Optional[str] = None, time_stamp: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword email_id: Email id.
        :paramtype email_id: str
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.email_id = email_id
        self.time_stamp = time_stamp


class CertificateOrderAction(_serialization.Model):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar action_type: Action type. Known values are: "CertificateIssued",
     "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
     "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
     "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
     "FraudDocumentationRequired", and "Unknown".
    :vartype action_type: str or ~azure.mgmt.web.v2023_01_01.models.CertificateOrderActionType
    :ivar created_at: Time at which the certificate action was performed.
    :vartype created_at: ~datetime.datetime
    """

    _validation = {
        "action_type": {"readonly": True},
        "created_at": {"readonly": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.action_type = None
        self.created_at = None


class CertificateOrderContact(_serialization.Model):
    """CertificateOrderContact.

    :ivar email:
    :vartype email: str
    :ivar name_first:
    :vartype name_first: str
    :ivar name_last:
    :vartype name_last: str
    :ivar phone:
    :vartype phone: str
    """

    _attribute_map = {
        "email": {"key": "email", "type": "str"},
        "name_first": {"key": "nameFirst", "type": "str"},
        "name_last": {"key": "nameLast", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        name_first: Optional[str] = None,
        name_last: Optional[str] = None,
        phone: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword email:
        :paramtype email: str
        :keyword name_first:
        :paramtype name_first: str
        :keyword name_last:
        :paramtype name_last: str
        :keyword phone:
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.email = email
        self.name_first = name_first
        self.name_last = name_last
        self.phone = phone


class CertificatePatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar password: Certificate password.
    :vartype password: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytes
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytes
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2023_01_01.models.KeyVaultSecretStatus
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".  # pylint: disable=line-too-long
    :vartype server_farm_id: str
    :ivar canonical_name: CNAME of the certificate to be issued via free certificate.
    :vartype canonical_name: str
    :ivar domain_validation_method: Method of domain validation for free cert.
    :vartype domain_validation_method: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "subject_name": {"readonly": True},
        "site_name": {"readonly": True},
        "self_link": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "cer_blob": {"readonly": True},
        "public_key_hash": {"readonly": True},
        "hosting_environment_profile": {"readonly": True},
        "key_vault_secret_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "subject_name": {"key": "properties.subjectName", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "pfx_blob": {"key": "properties.pfxBlob", "type": "bytearray"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "self_link": {"key": "properties.selfLink", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "issue_date": {"key": "properties.issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "valid": {"key": "properties.valid", "type": "bool"},
        "cer_blob": {"key": "properties.cerBlob", "type": "bytearray"},
        "public_key_hash": {"key": "properties.publicKeyHash", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_status": {"key": "properties.keyVaultSecretStatus", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "canonical_name": {"key": "properties.canonicalName", "type": "str"},
        "domain_validation_method": {"key": "properties.domainValidationMethod", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        password: Optional[str] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytes] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        canonical_name: Optional[str] = None,
        domain_validation_method: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytes
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".  # pylint: disable=line-too-long
        :paramtype server_farm_id: str
        :keyword canonical_name: CNAME of the certificate to be issued via free certificate.
        :paramtype canonical_name: str
        :keyword domain_validation_method: Method of domain validation for free cert.
        :paramtype domain_validation_method: str
        """
        super().__init__(kind=kind, **kwargs)
        self.password = password
        self.friendly_name = None
        self.subject_name = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status = None
        self.server_farm_id = server_farm_id
        self.canonical_name = canonical_name
        self.domain_validation_method = domain_validation_method


class ClientRegistration(_serialization.Model):
    """The configuration settings of the app registration for providers that have client ids and
    client secrets.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_setting_name": {"key": "clientSecretSettingName", "type": "str"},
    }

    def __init__(
        self, *, client_id: Optional[str] = None, client_secret_setting_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret.
        :paramtype client_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name


class CloningInfo(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to server.

    :ivar correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :vartype correlation_id: str
    :ivar overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :vartype clone_custom_host_names: bool
    :ivar clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :vartype clone_source_control: bool
    :ivar source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots. Required.
    :vartype source_web_app_id: str
    :ivar source_web_app_location: Location of source app ex: West US or North Europe.
    :vartype source_web_app_location: str
    :ivar hosting_environment: App Service Environment.
    :vartype hosting_environment: str
    :ivar app_settings_overrides: Application setting overrides for cloned app. If specified, these
     settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :vartype app_settings_overrides: dict[str, str]
    :ivar configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :vartype configure_load_balancing: bool
    :ivar traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.  # pylint: disable=line-too-long
    :vartype traffic_manager_profile_id: str
    :ivar traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :vartype traffic_manager_profile_name: str
    """

    _validation = {
        "source_web_app_id": {"required": True},
    }

    _attribute_map = {
        "correlation_id": {"key": "correlationId", "type": "str"},
        "overwrite": {"key": "overwrite", "type": "bool"},
        "clone_custom_host_names": {"key": "cloneCustomHostNames", "type": "bool"},
        "clone_source_control": {"key": "cloneSourceControl", "type": "bool"},
        "source_web_app_id": {"key": "sourceWebAppId", "type": "str"},
        "source_web_app_location": {"key": "sourceWebAppLocation", "type": "str"},
        "hosting_environment": {"key": "hostingEnvironment", "type": "str"},
        "app_settings_overrides": {"key": "appSettingsOverrides", "type": "{str}"},
        "configure_load_balancing": {"key": "configureLoadBalancing", "type": "bool"},
        "traffic_manager_profile_id": {"key": "trafficManagerProfileId", "type": "str"},
        "traffic_manager_profile_name": {"key": "trafficManagerProfileName", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_web_app_id: str,
        correlation_id: Optional[str] = None,
        overwrite: Optional[bool] = None,
        clone_custom_host_names: Optional[bool] = None,
        clone_source_control: Optional[bool] = None,
        source_web_app_location: Optional[str] = None,
        hosting_environment: Optional[str] = None,
        app_settings_overrides: Optional[Dict[str, str]] = None,
        configure_load_balancing: Optional[bool] = None,
        traffic_manager_profile_id: Optional[str] = None,
        traffic_manager_profile_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
         operations
         together to use the same snapshot.
        :paramtype correlation_id: str
        :keyword overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
         :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from
         source app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_custom_host_names: bool
        :keyword clone_source_control: :code:`<code>true</code>` to clone source control from source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_source_control: bool
        :keyword source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots. Required.
        :paramtype source_web_app_id: str
        :keyword source_web_app_location: Location of source app ex: West US or North Europe.
        :paramtype source_web_app_location: str
        :keyword hosting_environment: App Service Environment.
        :paramtype hosting_environment: str
        :keyword app_settings_overrides: Application setting overrides for cloned app. If specified,
         these settings override the settings cloned
         from source app. Otherwise, application settings from source app are retained.
        :paramtype app_settings_overrides: dict[str, str]
        :keyword configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
         source and destination app.
        :paramtype configure_load_balancing: bool
        :keyword traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if
         it exists. Traffic Manager resource ID is of the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.  # pylint: disable=line-too-long
        :paramtype traffic_manager_profile_id: str
        :keyword traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
         needed if Traffic Manager profile does not already exist.
        :paramtype traffic_manager_profile_name: str
        """
        super().__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.source_web_app_location = source_web_app_location
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name


class Configuration(_serialization.Model):
    """Non versioned Container App configuration properties that define the mutable settings of a
    Container app.

    :ivar secrets: Collection of secrets used by a Container app.
    :vartype secrets: list[~azure.mgmt.web.v2023_01_01.models.Secret]
    :ivar active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled for
     the Container app:


     .. raw:: html

        <list><item>Multiple: multiple revisions can be active. If no value if provided, this is
     the default</item><item>Single: Only one revision can be active at a time. Revision weights can
     not be used in this mode</item></list>. Known values are: "multiple" and "single".
    :vartype active_revisions_mode: str or ~azure.mgmt.web.v2023_01_01.models.ActiveRevisionsMode
    :ivar ingress: Ingress configurations.
    :vartype ingress: ~azure.mgmt.web.v2023_01_01.models.Ingress
    :ivar registries: Collection of private container registry credentials for containers used by
     the Container app.
    :vartype registries: list[~azure.mgmt.web.v2023_01_01.models.RegistryCredentials]
    """

    _attribute_map = {
        "secrets": {"key": "secrets", "type": "[Secret]"},
        "active_revisions_mode": {"key": "activeRevisionsMode", "type": "str"},
        "ingress": {"key": "ingress", "type": "Ingress"},
        "registries": {"key": "registries", "type": "[RegistryCredentials]"},
    }

    def __init__(
        self,
        *,
        secrets: Optional[List["_models.Secret"]] = None,
        active_revisions_mode: Optional[Union[str, "_models.ActiveRevisionsMode"]] = None,
        ingress: Optional["_models.Ingress"] = None,
        registries: Optional[List["_models.RegistryCredentials"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword secrets: Collection of secrets used by a Container app.
        :paramtype secrets: list[~azure.mgmt.web.v2023_01_01.models.Secret]
        :keyword active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled
         for the Container app:


         .. raw:: html

            <list><item>Multiple: multiple revisions can be active. If no value if provided, this is
         the default</item><item>Single: Only one revision can be active at a time. Revision weights can
         not be used in this mode</item></list>. Known values are: "multiple" and "single".
        :paramtype active_revisions_mode: str or ~azure.mgmt.web.v2023_01_01.models.ActiveRevisionsMode
        :keyword ingress: Ingress configurations.
        :paramtype ingress: ~azure.mgmt.web.v2023_01_01.models.Ingress
        :keyword registries: Collection of private container registry credentials for containers used
         by the Container app.
        :paramtype registries: list[~azure.mgmt.web.v2023_01_01.models.RegistryCredentials]
        """
        super().__init__(**kwargs)
        self.secrets = secrets
        self.active_revisions_mode = active_revisions_mode
        self.ingress = ingress
        self.registries = registries


class ConnectionStringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Connection strings.
    :vartype properties: dict[str, ~azure.mgmt.web.v2023_01_01.models.ConnStringValueTypePair]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "{ConnStringValueTypePair}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "_models.ConnStringValueTypePair"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Connection strings.
        :paramtype properties: dict[str, ~azure.mgmt.web.v2023_01_01.models.ConnStringValueTypePair]
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class ConnStringInfo(_serialization.Model):
    """Database connection string information.

    :ivar name: Name of connection string.
    :vartype name: str
    :ivar connection_string: Connection string value.
    :vartype connection_string: str
    :ivar type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
     "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.ConnectionStringType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_string: Optional[str] = None,
        type: Optional[Union[str, "_models.ConnectionStringType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of connection string.
        :paramtype name: str
        :keyword connection_string: Connection string value.
        :paramtype connection_string: str
        :keyword type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
         "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2023_01_01.models.ConnectionStringType
        """
        super().__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class ConnStringValueTypePair(_serialization.Model):
    """Database connection string value to type pair.

    All required parameters must be populated in order to send to server.

    :ivar value: Value of pair. Required.
    :vartype value: str
    :ivar type: Type of database. Required. Known values are: "MySql", "SQLServer", "SQLAzure",
     "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and
     "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.ConnectionStringType
    """

    _validation = {
        "value": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, value: str, type: Union[str, "_models.ConnectionStringType"], **kwargs: Any) -> None:
        """
        :keyword value: Value of pair. Required.
        :paramtype value: str
        :keyword type: Type of database. Required. Known values are: "MySql", "SQLServer", "SQLAzure",
         "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and
         "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2023_01_01.models.ConnectionStringType
        """
        super().__init__(**kwargs)
        self.value = value
        self.type = type


class Contact(_serialization.Model):
    """Contact information for domain registration. If 'Domain Privacy' option is not selected then
    the contact information is made publicly available through the Whois
    directories as per ICANN requirements.

    All required parameters must be populated in order to send to server.

    :ivar address_mailing: Mailing address.
    :vartype address_mailing: ~azure.mgmt.web.v2023_01_01.models.Address
    :ivar email: Email address. Required.
    :vartype email: str
    :ivar fax: Fax number.
    :vartype fax: str
    :ivar job_title: Job title.
    :vartype job_title: str
    :ivar name_first: First name. Required.
    :vartype name_first: str
    :ivar name_last: Last name. Required.
    :vartype name_last: str
    :ivar name_middle: Middle name.
    :vartype name_middle: str
    :ivar organization: Organization contact belongs to.
    :vartype organization: str
    :ivar phone: Phone number. Required.
    :vartype phone: str
    """

    _validation = {
        "email": {"required": True},
        "name_first": {"required": True},
        "name_last": {"required": True},
        "phone": {"required": True},
    }

    _attribute_map = {
        "address_mailing": {"key": "addressMailing", "type": "Address"},
        "email": {"key": "email", "type": "str"},
        "fax": {"key": "fax", "type": "str"},
        "job_title": {"key": "jobTitle", "type": "str"},
        "name_first": {"key": "nameFirst", "type": "str"},
        "name_last": {"key": "nameLast", "type": "str"},
        "name_middle": {"key": "nameMiddle", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self,
        *,
        email: str,
        name_first: str,
        name_last: str,
        phone: str,
        address_mailing: Optional["_models.Address"] = None,
        fax: Optional[str] = None,
        job_title: Optional[str] = None,
        name_middle: Optional[str] = None,
        organization: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address_mailing: Mailing address.
        :paramtype address_mailing: ~azure.mgmt.web.v2023_01_01.models.Address
        :keyword email: Email address. Required.
        :paramtype email: str
        :keyword fax: Fax number.
        :paramtype fax: str
        :keyword job_title: Job title.
        :paramtype job_title: str
        :keyword name_first: First name. Required.
        :paramtype name_first: str
        :keyword name_last: Last name. Required.
        :paramtype name_last: str
        :keyword name_middle: Middle name.
        :paramtype name_middle: str
        :keyword organization: Organization contact belongs to.
        :paramtype organization: str
        :keyword phone: Phone number. Required.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.address_mailing = address_mailing
        self.email = email
        self.fax = fax
        self.job_title = job_title
        self.name_first = name_first
        self.name_last = name_last
        self.name_middle = name_middle
        self.organization = organization
        self.phone = phone


class Container(_serialization.Model):
    """Container App container definition.

    :ivar image: Container image tag.
    :vartype image: str
    :ivar name: Custom container name.
    :vartype name: str
    :ivar command: Container start command.
    :vartype command: list[str]
    :ivar args: Container start command arguments.
    :vartype args: list[str]
    :ivar env: Container environment variables.
    :vartype env: list[~azure.mgmt.web.v2023_01_01.models.EnvironmentVar]
    :ivar resources: Container resource requirements.
    :vartype resources: ~azure.mgmt.web.v2023_01_01.models.ContainerResources
    """

    _attribute_map = {
        "image": {"key": "image", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "command": {"key": "command", "type": "[str]"},
        "args": {"key": "args", "type": "[str]"},
        "env": {"key": "env", "type": "[EnvironmentVar]"},
        "resources": {"key": "resources", "type": "ContainerResources"},
    }

    def __init__(
        self,
        *,
        image: Optional[str] = None,
        name: Optional[str] = None,
        command: Optional[List[str]] = None,
        args: Optional[List[str]] = None,
        env: Optional[List["_models.EnvironmentVar"]] = None,
        resources: Optional["_models.ContainerResources"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image: Container image tag.
        :paramtype image: str
        :keyword name: Custom container name.
        :paramtype name: str
        :keyword command: Container start command.
        :paramtype command: list[str]
        :keyword args: Container start command arguments.
        :paramtype args: list[str]
        :keyword env: Container environment variables.
        :paramtype env: list[~azure.mgmt.web.v2023_01_01.models.EnvironmentVar]
        :keyword resources: Container resource requirements.
        :paramtype resources: ~azure.mgmt.web.v2023_01_01.models.ContainerResources
        """
        super().__init__(**kwargs)
        self.image = image
        self.name = name
        self.command = command
        self.args = args
        self.env = env
        self.resources = resources


class ContainerApp(Resource):  # pylint: disable=too-many-instance-attributes
    """Container App.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the Container App. Known values are:
     "InProgress", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2023_01_01.models.ContainerAppProvisioningState
    :ivar kube_environment_id: Resource ID of the Container App's KubeEnvironment.
    :vartype kube_environment_id: str
    :ivar latest_revision_name: Name of the latest revision of the Container App.
    :vartype latest_revision_name: str
    :ivar latest_revision_fqdn: Fully Qualified Domain Name of the latest revision of the Container
     App.
    :vartype latest_revision_fqdn: str
    :ivar configuration: Non versioned Container App configuration properties.
    :vartype configuration: ~azure.mgmt.web.v2023_01_01.models.Configuration
    :ivar template: Container App versioned application definition.
    :vartype template: ~azure.mgmt.web.v2023_01_01.models.Template
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "latest_revision_name": {"readonly": True},
        "latest_revision_fqdn": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "kube_environment_id": {"key": "properties.kubeEnvironmentId", "type": "str"},
        "latest_revision_name": {"key": "properties.latestRevisionName", "type": "str"},
        "latest_revision_fqdn": {"key": "properties.latestRevisionFqdn", "type": "str"},
        "configuration": {"key": "properties.configuration", "type": "Configuration"},
        "template": {"key": "properties.template", "type": "Template"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        kube_environment_id: Optional[str] = None,
        configuration: Optional["_models.Configuration"] = None,
        template: Optional["_models.Template"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kube_environment_id: Resource ID of the Container App's KubeEnvironment.
        :paramtype kube_environment_id: str
        :keyword configuration: Non versioned Container App configuration properties.
        :paramtype configuration: ~azure.mgmt.web.v2023_01_01.models.Configuration
        :keyword template: Container App versioned application definition.
        :paramtype template: ~azure.mgmt.web.v2023_01_01.models.Template
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.kube_environment_id = kube_environment_id
        self.latest_revision_name = None
        self.latest_revision_fqdn = None
        self.configuration = configuration
        self.template = template


class ContainerAppCollection(_serialization.Model):
    """Container App collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ContainerApp]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ContainerApp]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ContainerApp"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ContainerApp]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ContainerAppsConfiguration(_serialization.Model):
    """ContainerAppsConfiguration.

    :ivar dapr_ai_instrumentation_key: Azure Monitor instrumentation key used by Dapr to export
     Service to Service communication telemetry.
    :vartype dapr_ai_instrumentation_key: str
    :ivar platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment
     infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
    :vartype platform_reserved_cidr: str
    :ivar platform_reserved_dns_ip: An IP address from the IP range defined by platformReservedCidr
     that will be reserved for the internal DNS server.
    :vartype platform_reserved_dns_ip: str
    :ivar control_plane_subnet_resource_id: Resource ID of a subnet for control plane
     infrastructure components. This subnet must be in the same VNET as the subnet defined in
     appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if
     defined.
    :vartype control_plane_subnet_resource_id: str
    :ivar app_subnet_resource_id: Resource ID of a subnet for control plane infrastructure
     components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId.
     Must not overlap with the IP range defined in platformReservedCidr, if defined.
    :vartype app_subnet_resource_id: str
    :ivar docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge network. It must
     not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if
     defined.
    :vartype docker_bridge_cidr: str
    """

    _attribute_map = {
        "dapr_ai_instrumentation_key": {"key": "daprAIInstrumentationKey", "type": "str"},
        "platform_reserved_cidr": {"key": "platformReservedCidr", "type": "str"},
        "platform_reserved_dns_ip": {"key": "platformReservedDnsIP", "type": "str"},
        "control_plane_subnet_resource_id": {"key": "controlPlaneSubnetResourceId", "type": "str"},
        "app_subnet_resource_id": {"key": "appSubnetResourceId", "type": "str"},
        "docker_bridge_cidr": {"key": "dockerBridgeCidr", "type": "str"},
    }

    def __init__(
        self,
        *,
        dapr_ai_instrumentation_key: Optional[str] = None,
        platform_reserved_cidr: Optional[str] = None,
        platform_reserved_dns_ip: Optional[str] = None,
        control_plane_subnet_resource_id: Optional[str] = None,
        app_subnet_resource_id: Optional[str] = None,
        docker_bridge_cidr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dapr_ai_instrumentation_key: Azure Monitor instrumentation key used by Dapr to export
         Service to Service communication telemetry.
        :paramtype dapr_ai_instrumentation_key: str
        :keyword platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment
         infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
        :paramtype platform_reserved_cidr: str
        :keyword platform_reserved_dns_ip: An IP address from the IP range defined by
         platformReservedCidr that will be reserved for the internal DNS server.
        :paramtype platform_reserved_dns_ip: str
        :keyword control_plane_subnet_resource_id: Resource ID of a subnet for control plane
         infrastructure components. This subnet must be in the same VNET as the subnet defined in
         appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if
         defined.
        :paramtype control_plane_subnet_resource_id: str
        :keyword app_subnet_resource_id: Resource ID of a subnet for control plane infrastructure
         components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId.
         Must not overlap with the IP range defined in platformReservedCidr, if defined.
        :paramtype app_subnet_resource_id: str
        :keyword docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge network. It
         must not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if
         defined.
        :paramtype docker_bridge_cidr: str
        """
        super().__init__(**kwargs)
        self.dapr_ai_instrumentation_key = dapr_ai_instrumentation_key
        self.platform_reserved_cidr = platform_reserved_cidr
        self.platform_reserved_dns_ip = platform_reserved_dns_ip
        self.control_plane_subnet_resource_id = control_plane_subnet_resource_id
        self.app_subnet_resource_id = app_subnet_resource_id
        self.docker_bridge_cidr = docker_bridge_cidr


class ContainerAppSecret(_serialization.Model):
    """Container App Secret.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class ContainerCpuStatistics(_serialization.Model):
    """ContainerCpuStatistics.

    :ivar cpu_usage:
    :vartype cpu_usage: ~azure.mgmt.web.v2023_01_01.models.ContainerCpuUsage
    :ivar system_cpu_usage:
    :vartype system_cpu_usage: int
    :ivar online_cpu_count:
    :vartype online_cpu_count: int
    :ivar throttling_data:
    :vartype throttling_data: ~azure.mgmt.web.v2023_01_01.models.ContainerThrottlingData
    """

    _attribute_map = {
        "cpu_usage": {"key": "cpuUsage", "type": "ContainerCpuUsage"},
        "system_cpu_usage": {"key": "systemCpuUsage", "type": "int"},
        "online_cpu_count": {"key": "onlineCpuCount", "type": "int"},
        "throttling_data": {"key": "throttlingData", "type": "ContainerThrottlingData"},
    }

    def __init__(
        self,
        *,
        cpu_usage: Optional["_models.ContainerCpuUsage"] = None,
        system_cpu_usage: Optional[int] = None,
        online_cpu_count: Optional[int] = None,
        throttling_data: Optional["_models.ContainerThrottlingData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cpu_usage:
        :paramtype cpu_usage: ~azure.mgmt.web.v2023_01_01.models.ContainerCpuUsage
        :keyword system_cpu_usage:
        :paramtype system_cpu_usage: int
        :keyword online_cpu_count:
        :paramtype online_cpu_count: int
        :keyword throttling_data:
        :paramtype throttling_data: ~azure.mgmt.web.v2023_01_01.models.ContainerThrottlingData
        """
        super().__init__(**kwargs)
        self.cpu_usage = cpu_usage
        self.system_cpu_usage = system_cpu_usage
        self.online_cpu_count = online_cpu_count
        self.throttling_data = throttling_data


class ContainerCpuUsage(_serialization.Model):
    """ContainerCpuUsage.

    :ivar total_usage:
    :vartype total_usage: int
    :ivar per_cpu_usage:
    :vartype per_cpu_usage: list[int]
    :ivar kernel_mode_usage:
    :vartype kernel_mode_usage: int
    :ivar user_mode_usage:
    :vartype user_mode_usage: int
    """

    _attribute_map = {
        "total_usage": {"key": "totalUsage", "type": "int"},
        "per_cpu_usage": {"key": "perCpuUsage", "type": "[int]"},
        "kernel_mode_usage": {"key": "kernelModeUsage", "type": "int"},
        "user_mode_usage": {"key": "userModeUsage", "type": "int"},
    }

    def __init__(
        self,
        *,
        total_usage: Optional[int] = None,
        per_cpu_usage: Optional[List[int]] = None,
        kernel_mode_usage: Optional[int] = None,
        user_mode_usage: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword total_usage:
        :paramtype total_usage: int
        :keyword per_cpu_usage:
        :paramtype per_cpu_usage: list[int]
        :keyword kernel_mode_usage:
        :paramtype kernel_mode_usage: int
        :keyword user_mode_usage:
        :paramtype user_mode_usage: int
        """
        super().__init__(**kwargs)
        self.total_usage = total_usage
        self.per_cpu_usage = per_cpu_usage
        self.kernel_mode_usage = kernel_mode_usage
        self.user_mode_usage = user_mode_usage


class ContainerInfo(_serialization.Model):
    """ContainerInfo.

    :ivar current_time_stamp:
    :vartype current_time_stamp: ~datetime.datetime
    :ivar previous_time_stamp:
    :vartype previous_time_stamp: ~datetime.datetime
    :ivar current_cpu_stats:
    :vartype current_cpu_stats: ~azure.mgmt.web.v2023_01_01.models.ContainerCpuStatistics
    :ivar previous_cpu_stats:
    :vartype previous_cpu_stats: ~azure.mgmt.web.v2023_01_01.models.ContainerCpuStatistics
    :ivar memory_stats:
    :vartype memory_stats: ~azure.mgmt.web.v2023_01_01.models.ContainerMemoryStatistics
    :ivar name:
    :vartype name: str
    :ivar id:
    :vartype id: str
    :ivar eth0:
    :vartype eth0: ~azure.mgmt.web.v2023_01_01.models.ContainerNetworkInterfaceStatistics
    """

    _attribute_map = {
        "current_time_stamp": {"key": "currentTimeStamp", "type": "iso-8601"},
        "previous_time_stamp": {"key": "previousTimeStamp", "type": "iso-8601"},
        "current_cpu_stats": {"key": "currentCpuStats", "type": "ContainerCpuStatistics"},
        "previous_cpu_stats": {"key": "previousCpuStats", "type": "ContainerCpuStatistics"},
        "memory_stats": {"key": "memoryStats", "type": "ContainerMemoryStatistics"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "eth0": {"key": "eth0", "type": "ContainerNetworkInterfaceStatistics"},
    }

    def __init__(
        self,
        *,
        current_time_stamp: Optional[datetime.datetime] = None,
        previous_time_stamp: Optional[datetime.datetime] = None,
        current_cpu_stats: Optional["_models.ContainerCpuStatistics"] = None,
        previous_cpu_stats: Optional["_models.ContainerCpuStatistics"] = None,
        memory_stats: Optional["_models.ContainerMemoryStatistics"] = None,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        eth0: Optional["_models.ContainerNetworkInterfaceStatistics"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword current_time_stamp:
        :paramtype current_time_stamp: ~datetime.datetime
        :keyword previous_time_stamp:
        :paramtype previous_time_stamp: ~datetime.datetime
        :keyword current_cpu_stats:
        :paramtype current_cpu_stats: ~azure.mgmt.web.v2023_01_01.models.ContainerCpuStatistics
        :keyword previous_cpu_stats:
        :paramtype previous_cpu_stats: ~azure.mgmt.web.v2023_01_01.models.ContainerCpuStatistics
        :keyword memory_stats:
        :paramtype memory_stats: ~azure.mgmt.web.v2023_01_01.models.ContainerMemoryStatistics
        :keyword name:
        :paramtype name: str
        :keyword id:
        :paramtype id: str
        :keyword eth0:
        :paramtype eth0: ~azure.mgmt.web.v2023_01_01.models.ContainerNetworkInterfaceStatistics
        """
        super().__init__(**kwargs)
        self.current_time_stamp = current_time_stamp
        self.previous_time_stamp = previous_time_stamp
        self.current_cpu_stats = current_cpu_stats
        self.previous_cpu_stats = previous_cpu_stats
        self.memory_stats = memory_stats
        self.name = name
        self.id = id
        self.eth0 = eth0


class ContainerMemoryStatistics(_serialization.Model):
    """ContainerMemoryStatistics.

    :ivar usage:
    :vartype usage: int
    :ivar max_usage:
    :vartype max_usage: int
    :ivar limit:
    :vartype limit: int
    """

    _attribute_map = {
        "usage": {"key": "usage", "type": "int"},
        "max_usage": {"key": "maxUsage", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
    }

    def __init__(
        self,
        *,
        usage: Optional[int] = None,
        max_usage: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword usage:
        :paramtype usage: int
        :keyword max_usage:
        :paramtype max_usage: int
        :keyword limit:
        :paramtype limit: int
        """
        super().__init__(**kwargs)
        self.usage = usage
        self.max_usage = max_usage
        self.limit = limit


class ContainerNetworkInterfaceStatistics(_serialization.Model):
    """ContainerNetworkInterfaceStatistics.

    :ivar rx_bytes:
    :vartype rx_bytes: int
    :ivar rx_packets:
    :vartype rx_packets: int
    :ivar rx_errors:
    :vartype rx_errors: int
    :ivar rx_dropped:
    :vartype rx_dropped: int
    :ivar tx_bytes:
    :vartype tx_bytes: int
    :ivar tx_packets:
    :vartype tx_packets: int
    :ivar tx_errors:
    :vartype tx_errors: int
    :ivar tx_dropped:
    :vartype tx_dropped: int
    """

    _attribute_map = {
        "rx_bytes": {"key": "rxBytes", "type": "int"},
        "rx_packets": {"key": "rxPackets", "type": "int"},
        "rx_errors": {"key": "rxErrors", "type": "int"},
        "rx_dropped": {"key": "rxDropped", "type": "int"},
        "tx_bytes": {"key": "txBytes", "type": "int"},
        "tx_packets": {"key": "txPackets", "type": "int"},
        "tx_errors": {"key": "txErrors", "type": "int"},
        "tx_dropped": {"key": "txDropped", "type": "int"},
    }

    def __init__(
        self,
        *,
        rx_bytes: Optional[int] = None,
        rx_packets: Optional[int] = None,
        rx_errors: Optional[int] = None,
        rx_dropped: Optional[int] = None,
        tx_bytes: Optional[int] = None,
        tx_packets: Optional[int] = None,
        tx_errors: Optional[int] = None,
        tx_dropped: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rx_bytes:
        :paramtype rx_bytes: int
        :keyword rx_packets:
        :paramtype rx_packets: int
        :keyword rx_errors:
        :paramtype rx_errors: int
        :keyword rx_dropped:
        :paramtype rx_dropped: int
        :keyword tx_bytes:
        :paramtype tx_bytes: int
        :keyword tx_packets:
        :paramtype tx_packets: int
        :keyword tx_errors:
        :paramtype tx_errors: int
        :keyword tx_dropped:
        :paramtype tx_dropped: int
        """
        super().__init__(**kwargs)
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.rx_errors = rx_errors
        self.rx_dropped = rx_dropped
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.tx_errors = tx_errors
        self.tx_dropped = tx_dropped


class ContainerResources(_serialization.Model):
    """Container App container resource requirements.

    :ivar cpu: Required CPU in cores, e.g. 0.5.
    :vartype cpu: float
    :ivar memory: Required memory, e.g. "250Mb".
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "float"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, cpu: Optional[float] = None, memory: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cpu: Required CPU in cores, e.g. 0.5.
        :paramtype cpu: float
        :keyword memory: Required memory, e.g. "250Mb".
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class ContainerThrottlingData(_serialization.Model):
    """ContainerThrottlingData.

    :ivar periods:
    :vartype periods: int
    :ivar throttled_periods:
    :vartype throttled_periods: int
    :ivar throttled_time:
    :vartype throttled_time: int
    """

    _attribute_map = {
        "periods": {"key": "periods", "type": "int"},
        "throttled_periods": {"key": "throttledPeriods", "type": "int"},
        "throttled_time": {"key": "throttledTime", "type": "int"},
    }

    def __init__(
        self,
        *,
        periods: Optional[int] = None,
        throttled_periods: Optional[int] = None,
        throttled_time: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword periods:
        :paramtype periods: int
        :keyword throttled_periods:
        :paramtype throttled_periods: int
        :keyword throttled_time:
        :paramtype throttled_time: int
        """
        super().__init__(**kwargs)
        self.periods = periods
        self.throttled_periods = throttled_periods
        self.throttled_time = throttled_time


class ContentHash(_serialization.Model):
    """The content hash.

    :ivar algorithm: The algorithm of the content hash.
    :vartype algorithm: str
    :ivar value: The value of the content hash.
    :vartype value: str
    """

    _attribute_map = {
        "algorithm": {"key": "algorithm", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, algorithm: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword algorithm: The algorithm of the content hash.
        :paramtype algorithm: str
        :keyword value: The value of the content hash.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class ContentLink(_serialization.Model):
    """The content link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar uri: The content link URI.
    :vartype uri: str
    :ivar content_version: The content version.
    :vartype content_version: str
    :ivar content_size: The content size.
    :vartype content_size: int
    :ivar content_hash: The content hash.
    :vartype content_hash: ~azure.mgmt.web.v2023_01_01.models.ContentHash
    :ivar metadata: The metadata.
    :vartype metadata: JSON
    """

    _validation = {
        "content_version": {"readonly": True},
        "content_size": {"readonly": True},
        "content_hash": {"readonly": True},
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
        "content_size": {"key": "contentSize", "type": "int"},
        "content_hash": {"key": "contentHash", "type": "ContentHash"},
        "metadata": {"key": "metadata", "type": "object"},
    }

    def __init__(self, *, uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: The content link URI.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.content_version = None
        self.content_size = None
        self.content_hash = None
        self.metadata = None


class ContinuousWebJob(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Continuous Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Job status. Known values are: "Initializing", "Starting", "Running",
     "PendingRestart", and "Stopped".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.ContinuousWebJobStatus
    :ivar detailed_status: Detailed status.
    :vartype detailed_status: str
    :ivar log_url: Log URL.
    :vartype log_url: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar web_job_type: Job type. Known values are: "Continuous" and "Triggered".
    :vartype web_job_type: str or ~azure.mgmt.web.v2023_01_01.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, JSON]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "detailed_status": {"key": "properties.detailed_status", "type": "str"},
        "log_url": {"key": "properties.log_url", "type": "str"},
        "run_command": {"key": "properties.run_command", "type": "str"},
        "url": {"key": "properties.url", "type": "str"},
        "extra_info_url": {"key": "properties.extra_info_url", "type": "str"},
        "web_job_type": {"key": "properties.web_job_type", "type": "str"},
        "error": {"key": "properties.error", "type": "str"},
        "using_sdk": {"key": "properties.using_sdk", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[Union[str, "_models.ContinuousWebJobStatus"]] = None,
        detailed_status: Optional[str] = None,
        log_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "_models.WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword status: Job status. Known values are: "Initializing", "Starting", "Running",
         "PendingRestart", and "Stopped".
        :paramtype status: str or ~azure.mgmt.web.v2023_01_01.models.ContinuousWebJobStatus
        :keyword detailed_status: Detailed status.
        :paramtype detailed_status: str
        :keyword log_url: Log URL.
        :paramtype log_url: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword web_job_type: Job type. Known values are: "Continuous" and "Triggered".
        :paramtype web_job_type: str or ~azure.mgmt.web.v2023_01_01.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, JSON]
        """
        super().__init__(kind=kind, **kwargs)
        self.status = status
        self.detailed_status = detailed_status
        self.log_url = log_url
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class ContinuousWebJobCollection(_serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ContinuousWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ContinuousWebJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ContinuousWebJob"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ContinuousWebJob]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CookieExpiration(_serialization.Model):
    """The configuration settings of the session cookie's expiration.

    :ivar convention: The convention used when determining the session cookie's expiration. Known
     values are: "FixedTime" and "IdentityProviderDerived".
    :vartype convention: str or ~azure.mgmt.web.v2023_01_01.models.CookieExpirationConvention
    :ivar time_to_expiration: The time after the request is made when the session cookie should
     expire.
    :vartype time_to_expiration: str
    """

    _attribute_map = {
        "convention": {"key": "convention", "type": "str"},
        "time_to_expiration": {"key": "timeToExpiration", "type": "str"},
    }

    def __init__(
        self,
        *,
        convention: Optional[Union[str, "_models.CookieExpirationConvention"]] = None,
        time_to_expiration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword convention: The convention used when determining the session cookie's expiration.
         Known values are: "FixedTime" and "IdentityProviderDerived".
        :paramtype convention: str or ~azure.mgmt.web.v2023_01_01.models.CookieExpirationConvention
        :keyword time_to_expiration: The time after the request is made when the session cookie should
         expire.
        :paramtype time_to_expiration: str
        """
        super().__init__(**kwargs)
        self.convention = convention
        self.time_to_expiration = time_to_expiration


class Correlation(_serialization.Model):
    """The correlation property.

    :ivar client_tracking_id: The client tracking id.
    :vartype client_tracking_id: str
    """

    _attribute_map = {
        "client_tracking_id": {"key": "clientTrackingId", "type": "str"},
    }

    def __init__(self, *, client_tracking_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_tracking_id: The client tracking id.
        :paramtype client_tracking_id: str
        """
        super().__init__(**kwargs)
        self.client_tracking_id = client_tracking_id


class CorsSettings(_serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :ivar allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :vartype allowed_origins: list[str]
    :ivar support_credentials: Gets or sets whether CORS requests with credentials are allowed. See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
    :vartype support_credentials: bool
    """

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
        "support_credentials": {"key": "supportCredentials", "type": "bool"},
    }

    def __init__(
        self, *, allowed_origins: Optional[List[str]] = None, support_credentials: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword allowed_origins: Gets or sets the list of origins that should be allowed to make
         cross-origin
         calls (for example: http://example.com:12345). Use "*" to allow all.
        :paramtype allowed_origins: list[str]
        :keyword support_credentials: Gets or sets whether CORS requests with credentials are allowed.
         See
         https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
         for more details.
        :paramtype support_credentials: bool
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.support_credentials = support_credentials


class CsmDeploymentStatus(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Deployment status response payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deployment_id: Deployment operation id.
    :vartype deployment_id: str
    :ivar status: Deployment build status. Known values are: "TimedOut", "RuntimeFailed",
     "BuildAborted", "BuildFailed", "BuildRequestReceived", "BuildPending", "BuildInProgress",
     "BuildSuccessful", "PostBuildRestartRequired", "StartPolling", "StartPollingWithRestart",
     "RuntimeStarting", and "RuntimeSuccessful".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.DeploymentBuildStatus
    :ivar number_of_instances_in_progress: Number of site instances currently being provisioned.
    :vartype number_of_instances_in_progress: int
    :ivar number_of_instances_successful: Number of site instances provisioned successfully.
    :vartype number_of_instances_successful: int
    :ivar number_of_instances_failed: Number of site instances failed to provision.
    :vartype number_of_instances_failed: int
    :ivar failed_instances_logs: List of URLs pointing to logs for instances which failed to
     provision.
    :vartype failed_instances_logs: list[str]
    :ivar errors: List of errors.
    :vartype errors: list[~azure.mgmt.web.v2023_01_01.models.ErrorEntity]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deployment_id": {"key": "properties.deploymentId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "number_of_instances_in_progress": {"key": "properties.numberOfInstancesInProgress", "type": "int"},
        "number_of_instances_successful": {"key": "properties.numberOfInstancesSuccessful", "type": "int"},
        "number_of_instances_failed": {"key": "properties.numberOfInstancesFailed", "type": "int"},
        "failed_instances_logs": {"key": "properties.failedInstancesLogs", "type": "[str]"},
        "errors": {"key": "properties.errors", "type": "[ErrorEntity]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        deployment_id: Optional[str] = None,
        status: Optional[Union[str, "_models.DeploymentBuildStatus"]] = None,
        number_of_instances_in_progress: Optional[int] = None,
        number_of_instances_successful: Optional[int] = None,
        number_of_instances_failed: Optional[int] = None,
        failed_instances_logs: Optional[List[str]] = None,
        errors: Optional[List["_models.ErrorEntity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword deployment_id: Deployment operation id.
        :paramtype deployment_id: str
        :keyword status: Deployment build status. Known values are: "TimedOut", "RuntimeFailed",
         "BuildAborted", "BuildFailed", "BuildRequestReceived", "BuildPending", "BuildInProgress",
         "BuildSuccessful", "PostBuildRestartRequired", "StartPolling", "StartPollingWithRestart",
         "RuntimeStarting", and "RuntimeSuccessful".
        :paramtype status: str or ~azure.mgmt.web.v2023_01_01.models.DeploymentBuildStatus
        :keyword number_of_instances_in_progress: Number of site instances currently being provisioned.
        :paramtype number_of_instances_in_progress: int
        :keyword number_of_instances_successful: Number of site instances provisioned successfully.
        :paramtype number_of_instances_successful: int
        :keyword number_of_instances_failed: Number of site instances failed to provision.
        :paramtype number_of_instances_failed: int
        :keyword failed_instances_logs: List of URLs pointing to logs for instances which failed to
         provision.
        :paramtype failed_instances_logs: list[str]
        :keyword errors: List of errors.
        :paramtype errors: list[~azure.mgmt.web.v2023_01_01.models.ErrorEntity]
        """
        super().__init__(kind=kind, **kwargs)
        self.deployment_id = deployment_id
        self.status = status
        self.number_of_instances_in_progress = number_of_instances_in_progress
        self.number_of_instances_successful = number_of_instances_successful
        self.number_of_instances_failed = number_of_instances_failed
        self.failed_instances_logs = failed_instances_logs
        self.errors = errors


class CsmDeploymentStatusCollection(_serialization.Model):
    """Deployment status collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.CsmDeploymentStatus]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmDeploymentStatus]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmDeploymentStatus"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.CsmDeploymentStatus]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CsmMoveResourceEnvelope(_serialization.Model):
    """Object with a list of the resources that need to be moved and the resource group they should be
    moved to.

    :ivar target_resource_group:
    :vartype target_resource_group: str
    :ivar resources:
    :vartype resources: list[str]
    """

    _validation = {
        "target_resource_group": {"max_length": 90, "min_length": 1, "pattern": r" ^[-\w\._\(\)]+[^\.]$"},
    }

    _attribute_map = {
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "resources": {"key": "resources", "type": "[str]"},
    }

    def __init__(
        self, *, target_resource_group: Optional[str] = None, resources: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_group:
        :paramtype target_resource_group: str
        :keyword resources:
        :paramtype resources: list[str]
        """
        super().__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class CsmOperationCollection(_serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmOperationDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmOperationDescription"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.CsmOperationDescription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CsmOperationDescription(_serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :ivar name:
    :vartype name: str
    :ivar is_data_action:
    :vartype is_data_action: bool
    :ivar display: Meta data about operation used for display in portal.
    :vartype display: ~azure.mgmt.web.v2023_01_01.models.CsmOperationDisplay
    :ivar origin:
    :vartype origin: str
    :ivar properties: Properties available for a Microsoft.Web resource provider operation.
    :vartype properties: ~azure.mgmt.web.v2023_01_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "CsmOperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "CsmOperationDescriptionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.CsmOperationDescriptionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword is_data_action:
        :paramtype is_data_action: bool
        :keyword display: Meta data about operation used for display in portal.
        :paramtype display: ~azure.mgmt.web.v2023_01_01.models.CsmOperationDisplay
        :keyword origin:
        :paramtype origin: str
        :keyword properties: Properties available for a Microsoft.Web resource provider operation.
        :paramtype properties: ~azure.mgmt.web.v2023_01_01.models.CsmOperationDescriptionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(_serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :ivar service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :vartype service_specification: ~azure.mgmt.web.v2023_01_01.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Resource metrics service provided by Microsoft.Insights
         resource provider.
        :paramtype service_specification: ~azure.mgmt.web.v2023_01_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(_serialization.Model):
    """Meta data about operation used for display in portal.

    :ivar provider:
    :vartype provider: str
    :ivar resource:
    :vartype resource: str
    :ivar operation:
    :vartype operation: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider:
        :paramtype provider: str
        :keyword resource:
        :paramtype resource: str
        :keyword operation:
        :paramtype operation: str
        :keyword description:
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class CsmPublishingCredentialsPoliciesEntity(ProxyOnlyResource):
    """Publishing Credentials Policies parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar allow: :code:`<code>true</code>` to allow access to a publishing method; otherwise,
     :code:`<code>false</code>`.
    :vartype allow: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "allow": {"key": "properties.allow", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, allow: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword allow: :code:`<code>true</code>` to allow access to a publishing method; otherwise,
         :code:`<code>false</code>`.
        :paramtype allow: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.allow = allow


class CsmPublishingProfileOptions(_serialization.Model):
    """Publishing options for requested profile.

    :ivar format: Name of the format. Valid values are:
     FileZilla3
     WebDeploy -- default
     Ftp. Known values are: "FileZilla3", "WebDeploy", and "Ftp".
    :vartype format: str or ~azure.mgmt.web.v2023_01_01.models.PublishingProfileFormat
    :ivar include_disaster_recovery_endpoints: Include the DisasterRecover endpoint if true.
    :vartype include_disaster_recovery_endpoints: bool
    """

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "include_disaster_recovery_endpoints": {"key": "includeDisasterRecoveryEndpoints", "type": "bool"},
    }

    def __init__(
        self,
        *,
        format: Optional[Union[str, "_models.PublishingProfileFormat"]] = None,
        include_disaster_recovery_endpoints: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword format: Name of the format. Valid values are:
         FileZilla3
         WebDeploy -- default
         Ftp. Known values are: "FileZilla3", "WebDeploy", and "Ftp".
        :paramtype format: str or ~azure.mgmt.web.v2023_01_01.models.PublishingProfileFormat
        :keyword include_disaster_recovery_endpoints: Include the DisasterRecover endpoint if true.
        :paramtype include_disaster_recovery_endpoints: bool
        """
        super().__init__(**kwargs)
        self.format = format
        self.include_disaster_recovery_endpoints = include_disaster_recovery_endpoints


class CsmSlotEntity(_serialization.Model):
    """Deployment slot parameters.

    All required parameters must be populated in order to send to server.

    :ivar target_slot: Destination deployment slot during swap operation. Required.
    :vartype target_slot: str
    :ivar preserve_vnet: :code:`<code>true</code>` to preserve Virtual Network to the slot during
     swap; otherwise, :code:`<code>false</code>`. Required.
    :vartype preserve_vnet: bool
    """

    _validation = {
        "target_slot": {"required": True},
        "preserve_vnet": {"required": True},
    }

    _attribute_map = {
        "target_slot": {"key": "targetSlot", "type": "str"},
        "preserve_vnet": {"key": "preserveVnet", "type": "bool"},
    }

    def __init__(self, *, target_slot: str, preserve_vnet: bool, **kwargs: Any) -> None:
        """
        :keyword target_slot: Destination deployment slot during swap operation. Required.
        :paramtype target_slot: str
        :keyword preserve_vnet: :code:`<code>true</code>` to preserve Virtual Network to the slot
         during swap; otherwise, :code:`<code>false</code>`. Required.
        :paramtype preserve_vnet: bool
        """
        super().__init__(**kwargs)
        self.target_slot = target_slot
        self.preserve_vnet = preserve_vnet


class CsmUsageQuota(_serialization.Model):
    """Usage of the quota resource.

    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: int
    :ivar limit: The resource limit.
    :vartype limit: int
    :ivar name: Quota name.
    :vartype name: ~azure.mgmt.web.v2023_01_01.models.LocalizableString
    """

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "next_reset_time": {"key": "nextResetTime", "type": "iso-8601"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "LocalizableString"},
    }

    def __init__(
        self,
        *,
        unit: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.LocalizableString"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: Units of measurement for the quota resource.
        :paramtype unit: str
        :keyword next_reset_time: Next reset time for the resource counter.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: The current value of the resource counter.
        :paramtype current_value: int
        :keyword limit: The resource limit.
        :paramtype limit: int
        :keyword name: Quota name.
        :paramtype name: ~azure.mgmt.web.v2023_01_01.models.LocalizableString
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class CsmUsageQuotaCollection(_serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmUsageQuota]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmUsageQuota"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.CsmUsageQuota]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CustomDnsSuffixConfiguration(ProxyOnlyResource):
    """Full view of the custom domain suffix configuration for ASEv3.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Known values are: "Succeeded", "Failed", "Degraded", and
     "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2023_01_01.models.CustomDnsSuffixProvisioningState
    :ivar provisioning_details:
    :vartype provisioning_details: str
    :ivar dns_suffix: The default custom domain suffix to use for all sites deployed on the ASE.
    :vartype dns_suffix: str
    :ivar certificate_url: The URL referencing the Azure Key Vault certificate secret that should
     be used as the default SSL/TLS certificate for sites with the custom domain suffix.
    :vartype certificate_url: str
    :ivar key_vault_reference_identity: The user-assigned identity to use for resolving the key
     vault certificate reference. If not specified, the system-assigned ASE identity will be used if
     available.
    :vartype key_vault_reference_identity: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "provisioning_details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "provisioning_details": {"key": "properties.provisioningDetails", "type": "str"},
        "dns_suffix": {"key": "properties.dnsSuffix", "type": "str"},
        "certificate_url": {"key": "properties.certificateUrl", "type": "str"},
        "key_vault_reference_identity": {"key": "properties.keyVaultReferenceIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        dns_suffix: Optional[str] = None,
        certificate_url: Optional[str] = None,
        key_vault_reference_identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword dns_suffix: The default custom domain suffix to use for all sites deployed on the ASE.
        :paramtype dns_suffix: str
        :keyword certificate_url: The URL referencing the Azure Key Vault certificate secret that
         should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
        :paramtype certificate_url: str
        :keyword key_vault_reference_identity: The user-assigned identity to use for resolving the key
         vault certificate reference. If not specified, the system-assigned ASE identity will be used if
         available.
        :paramtype key_vault_reference_identity: str
        """
        super().__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.provisioning_details = None
        self.dns_suffix = dns_suffix
        self.certificate_url = certificate_url
        self.key_vault_reference_identity = key_vault_reference_identity


class CustomHostnameAnalysisResult(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Known values are:
     "Passed", "Failed", and "Skipped".
    :vartype custom_domain_verification_test: str or
     ~azure.mgmt.web.v2023_01_01.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~azure.mgmt.web.v2023_01_01.models.ErrorEntity
    :ivar has_conflict_on_scale_unit: :code:`<code>true</code>` if there is a conflict on a scale
     unit; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_scale_unit: bool
    :ivar has_conflict_across_subscription: :code:`<code>true</code>` if there is a conflict across
     subscriptions; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_across_subscription: bool
    :ivar conflicting_app_resource_id: Name of the conflicting app on scale unit if it's within the
     same subscription.
    :vartype conflicting_app_resource_id: str
    :ivar c_name_records: CName records controller can see for this hostname.
    :vartype c_name_records: list[str]
    :ivar txt_records: TXT records controller can see for this hostname.
    :vartype txt_records: list[str]
    :ivar a_records: A records controller can see for this hostname.
    :vartype a_records: list[str]
    :ivar alternate_c_name_records: Alternate CName records controller can see for this hostname.
    :vartype alternate_c_name_records: list[str]
    :ivar alternate_txt_records: Alternate TXT records controller can see for this hostname.
    :vartype alternate_txt_records: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "is_hostname_already_verified": {"readonly": True},
        "custom_domain_verification_test": {"readonly": True},
        "custom_domain_verification_failure_info": {"readonly": True},
        "has_conflict_on_scale_unit": {"readonly": True},
        "has_conflict_across_subscription": {"readonly": True},
        "conflicting_app_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_hostname_already_verified": {"key": "properties.isHostnameAlreadyVerified", "type": "bool"},
        "custom_domain_verification_test": {"key": "properties.customDomainVerificationTest", "type": "str"},
        "custom_domain_verification_failure_info": {
            "key": "properties.customDomainVerificationFailureInfo",
            "type": "ErrorEntity",
        },
        "has_conflict_on_scale_unit": {"key": "properties.hasConflictOnScaleUnit", "type": "bool"},
        "has_conflict_across_subscription": {"key": "properties.hasConflictAcrossSubscription", "type": "bool"},
        "conflicting_app_resource_id": {"key": "properties.conflictingAppResourceId", "type": "str"},
        "c_name_records": {"key": "properties.cNameRecords", "type": "[str]"},
        "txt_records": {"key": "properties.txtRecords", "type": "[str]"},
        "a_records": {"key": "properties.aRecords", "type": "[str]"},
        "alternate_c_name_records": {"key": "properties.alternateCNameRecords", "type": "[str]"},
        "alternate_txt_records": {"key": "properties.alternateTxtRecords", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        c_name_records: Optional[List[str]] = None,
        txt_records: Optional[List[str]] = None,
        a_records: Optional[List[str]] = None,
        alternate_c_name_records: Optional[List[str]] = None,
        alternate_txt_records: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword c_name_records: CName records controller can see for this hostname.
        :paramtype c_name_records: list[str]
        :keyword txt_records: TXT records controller can see for this hostname.
        :paramtype txt_records: list[str]
        :keyword a_records: A records controller can see for this hostname.
        :paramtype a_records: list[str]
        :keyword alternate_c_name_records: Alternate CName records controller can see for this
         hostname.
        :paramtype alternate_c_name_records: list[str]
        :keyword alternate_txt_records: Alternate TXT records controller can see for this hostname.
        :paramtype alternate_txt_records: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_scale_unit = None
        self.has_conflict_across_subscription = None
        self.conflicting_app_resource_id = None
        self.c_name_records = c_name_records
        self.txt_records = txt_records
        self.a_records = a_records
        self.alternate_c_name_records = alternate_c_name_records
        self.alternate_txt_records = alternate_txt_records


class CustomHostnameSites(ProxyOnlyResource):
    """A hostname and its assigned sites.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar custom_hostname:
    :vartype custom_hostname: str
    :ivar region:
    :vartype region: str
    :ivar site_resource_ids:
    :vartype site_resource_ids: list[~azure.mgmt.web.v2023_01_01.models.Identifier]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "custom_hostname": {"key": "properties.customHostname", "type": "str"},
        "region": {"key": "properties.region", "type": "str"},
        "site_resource_ids": {"key": "properties.siteResourceIds", "type": "[Identifier]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        custom_hostname: Optional[str] = None,
        region: Optional[str] = None,
        site_resource_ids: Optional[List["_models.Identifier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword custom_hostname:
        :paramtype custom_hostname: str
        :keyword region:
        :paramtype region: str
        :keyword site_resource_ids:
        :paramtype site_resource_ids: list[~azure.mgmt.web.v2023_01_01.models.Identifier]
        """
        super().__init__(kind=kind, **kwargs)
        self.custom_hostname = custom_hostname
        self.region = region
        self.site_resource_ids = site_resource_ids


class CustomHostnameSitesCollection(_serialization.Model):
    """Collection of custom hostname sites.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.CustomHostnameSites]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomHostnameSites]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CustomHostnameSites"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.CustomHostnameSites]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CustomOpenIdConnectProvider(_serialization.Model):
    """The configuration settings of the custom Open ID Connect provider.

    :ivar enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not be
     enabled; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the custom Open ID
     Connect provider.
    :vartype registration: ~azure.mgmt.web.v2023_01_01.models.OpenIdConnectRegistration
    :ivar login: The configuration settings of the login flow of the custom Open ID Connect
     provider.
    :vartype login: ~azure.mgmt.web.v2023_01_01.models.OpenIdConnectLogin
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "OpenIdConnectRegistration"},
        "login": {"key": "login", "type": "OpenIdConnectLogin"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.OpenIdConnectRegistration"] = None,
        login: Optional["_models.OpenIdConnectLogin"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not
         be enabled; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the custom Open
         ID Connect provider.
        :paramtype registration: ~azure.mgmt.web.v2023_01_01.models.OpenIdConnectRegistration
        :keyword login: The configuration settings of the login flow of the custom Open ID Connect
         provider.
        :paramtype login: ~azure.mgmt.web.v2023_01_01.models.OpenIdConnectLogin
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class CustomScaleRule(_serialization.Model):
    """Container App container Custom scaling rule.

    :ivar type: Type of the custom scale rule
     eg: azure-servicebus, redis etc.
    :vartype type: str
    :ivar metadata: Metadata properties to describe custom scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~azure.mgmt.web.v2023_01_01.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the custom scale rule
         eg: azure-servicebus, redis etc.
        :paramtype type: str
        :keyword metadata: Metadata properties to describe custom scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~azure.mgmt.web.v2023_01_01.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.type = type
        self.metadata = metadata
        self.auth = auth


class Dapr(_serialization.Model):
    """Container App Dapr configuration.

    :ivar enabled: Boolean indicating if the Dapr side car is enabled.
    :vartype enabled: bool
    :ivar app_id: Dapr application identifier.
    :vartype app_id: str
    :ivar app_port: Port on which the Dapr side car.
    :vartype app_port: int
    :ivar components: Collection of Dapr components.
    :vartype components: list[~azure.mgmt.web.v2023_01_01.models.DaprComponent]
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "app_id": {"key": "appId", "type": "str"},
        "app_port": {"key": "appPort", "type": "int"},
        "components": {"key": "components", "type": "[DaprComponent]"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        app_id: Optional[str] = None,
        app_port: Optional[int] = None,
        components: Optional[List["_models.DaprComponent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Boolean indicating if the Dapr side car is enabled.
        :paramtype enabled: bool
        :keyword app_id: Dapr application identifier.
        :paramtype app_id: str
        :keyword app_port: Port on which the Dapr side car.
        :paramtype app_port: int
        :keyword components: Collection of Dapr components.
        :paramtype components: list[~azure.mgmt.web.v2023_01_01.models.DaprComponent]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.app_id = app_id
        self.app_port = app_port
        self.components = components


class DaprComponent(_serialization.Model):
    """Dapr component configuration.

    :ivar name: Component name.
    :vartype name: str
    :ivar type: Component type.
    :vartype type: str
    :ivar version: Component version.
    :vartype version: str
    :ivar metadata: Component metadata.
    :vartype metadata: list[~azure.mgmt.web.v2023_01_01.models.DaprMetadata]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "metadata": {"key": "metadata", "type": "[DaprMetadata]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        version: Optional[str] = None,
        metadata: Optional[List["_models.DaprMetadata"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Component name.
        :paramtype name: str
        :keyword type: Component type.
        :paramtype type: str
        :keyword version: Component version.
        :paramtype version: str
        :keyword metadata: Component metadata.
        :paramtype metadata: list[~azure.mgmt.web.v2023_01_01.models.DaprMetadata]
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.version = version
        self.metadata = metadata


class DaprConfig(_serialization.Model):
    """App Dapr configuration.

    :ivar enabled: Boolean indicating if the Dapr side car is enabled.
    :vartype enabled: bool
    :ivar app_id: Dapr application identifier.
    :vartype app_id: str
    :ivar app_port: Tells Dapr which port your application is listening on.
    :vartype app_port: int
    :ivar http_read_buffer_size: Dapr max size of http header read buffer in KB to handle when
     sending multi-KB headers. Default is 65KB.
    :vartype http_read_buffer_size: int
    :ivar http_max_request_size: Increasing max size of request body http servers parameter in MB
     to handle uploading of big files. Default is 4 MB.
    :vartype http_max_request_size: int
    :ivar log_level: Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn,
     error. Default is info. Known values are: "info", "debug", "warn", and "error".
    :vartype log_level: str or ~azure.mgmt.web.v2023_01_01.models.DaprLogLevel
    :ivar enable_api_logging: Enables API logging for the Dapr sidecar.
    :vartype enable_api_logging: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "app_id": {"key": "appId", "type": "str"},
        "app_port": {"key": "appPort", "type": "int"},
        "http_read_buffer_size": {"key": "httpReadBufferSize", "type": "int"},
        "http_max_request_size": {"key": "httpMaxRequestSize", "type": "int"},
        "log_level": {"key": "logLevel", "type": "str"},
        "enable_api_logging": {"key": "enableApiLogging", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: bool = False,
        app_id: Optional[str] = None,
        app_port: Optional[int] = None,
        http_read_buffer_size: Optional[int] = None,
        http_max_request_size: Optional[int] = None,
        log_level: Optional[Union[str, "_models.DaprLogLevel"]] = None,
        enable_api_logging: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Boolean indicating if the Dapr side car is enabled.
        :paramtype enabled: bool
        :keyword app_id: Dapr application identifier.
        :paramtype app_id: str
        :keyword app_port: Tells Dapr which port your application is listening on.
        :paramtype app_port: int
        :keyword http_read_buffer_size: Dapr max size of http header read buffer in KB to handle when
         sending multi-KB headers. Default is 65KB.
        :paramtype http_read_buffer_size: int
        :keyword http_max_request_size: Increasing max size of request body http servers parameter in
         MB to handle uploading of big files. Default is 4 MB.
        :paramtype http_max_request_size: int
        :keyword log_level: Sets the log level for the Dapr sidecar. Allowed values are debug, info,
         warn, error. Default is info. Known values are: "info", "debug", "warn", and "error".
        :paramtype log_level: str or ~azure.mgmt.web.v2023_01_01.models.DaprLogLevel
        :keyword enable_api_logging: Enables API logging for the Dapr sidecar.
        :paramtype enable_api_logging: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.app_id = app_id
        self.app_port = app_port
        self.http_read_buffer_size = http_read_buffer_size
        self.http_max_request_size = http_max_request_size
        self.log_level = log_level
        self.enable_api_logging = enable_api_logging


class DaprMetadata(_serialization.Model):
    """Container App Dapr component metadata.

    :ivar name: Metadata property name.
    :vartype name: str
    :ivar value: Metadata property value.
    :vartype value: str
    :ivar secret_ref: Name of the Container App secret from which to pull the metadata property
     value.
    :vartype secret_ref: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "secret_ref": {"key": "secretRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Metadata property name.
        :paramtype name: str
        :keyword value: Metadata property value.
        :paramtype value: str
        :keyword secret_ref: Name of the Container App secret from which to pull the metadata property
         value.
        :paramtype secret_ref: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref


class DatabaseBackupSetting(_serialization.Model):
    """Database backup settings.

    All required parameters must be populated in order to send to server.

    :ivar database_type: Database type (e.g. SqlAzure / MySql). Required. Known values are:
     "SqlAzure", "MySql", "LocalMySql", and "PostgreSql".
    :vartype database_type: str or ~azure.mgmt.web.v2023_01_01.models.DatabaseType
    :ivar name:
    :vartype name: str
    :ivar connection_string_name: Contains a connection string name that is linked to the
     SiteConfig.ConnectionStrings.
     This is used during restore with overwrite connection strings options.
    :vartype connection_string_name: str
    :ivar connection_string: Contains a connection string to a database which is being backed up or
     restored. If the restore should happen to a new database, the database name inside is the new
     one.
    :vartype connection_string: str
    """

    _validation = {
        "database_type": {"required": True},
    }

    _attribute_map = {
        "database_type": {"key": "databaseType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "connection_string_name": {"key": "connectionStringName", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
    }

    def __init__(
        self,
        *,
        database_type: Union[str, "_models.DatabaseType"],
        name: Optional[str] = None,
        connection_string_name: Optional[str] = None,
        connection_string: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword database_type: Database type (e.g. SqlAzure / MySql). Required. Known values are:
         "SqlAzure", "MySql", "LocalMySql", and "PostgreSql".
        :paramtype database_type: str or ~azure.mgmt.web.v2023_01_01.models.DatabaseType
        :keyword name:
        :paramtype name: str
        :keyword connection_string_name: Contains a connection string name that is linked to the
         SiteConfig.ConnectionStrings.
         This is used during restore with overwrite connection strings options.
        :paramtype connection_string_name: str
        :keyword connection_string: Contains a connection string to a database which is being backed up
         or restored. If the restore should happen to a new database, the database name inside is the
         new one.
        :paramtype connection_string: str
        """
        super().__init__(**kwargs)
        self.database_type = database_type
        self.name = name
        self.connection_string_name = connection_string_name
        self.connection_string = connection_string


class DatabaseConnection(ProxyOnlyResource):
    """Static Site Database Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_id: The resource id of the database.
    :vartype resource_id: str
    :ivar connection_identity: If present, the identity is used in conjunction with connection
     string to connect to the database. Use of the system-assigned managed identity is indicated
     with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated
     with the resource id of the managed identity resource.
    :vartype connection_identity: str
    :ivar connection_string: The connection string to use to connect to the database.
    :vartype connection_string: str
    :ivar region: The region of the database resource.
    :vartype region: str
    :ivar configuration_files: A list of configuration files associated with this database
     connection.
    :vartype configuration_files:
     list[~azure.mgmt.web.v2023_01_01.models.StaticSiteDatabaseConnectionConfigurationFileOverview]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "configuration_files": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "connection_identity": {"key": "properties.connectionIdentity", "type": "str"},
        "connection_string": {"key": "properties.connectionString", "type": "str"},
        "region": {"key": "properties.region", "type": "str"},
        "configuration_files": {
            "key": "properties.configurationFiles",
            "type": "[StaticSiteDatabaseConnectionConfigurationFileOverview]",
        },
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        resource_id: Optional[str] = None,
        connection_identity: Optional[str] = None,
        connection_string: Optional[str] = None,
        region: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword resource_id: The resource id of the database.
        :paramtype resource_id: str
        :keyword connection_identity: If present, the identity is used in conjunction with connection
         string to connect to the database. Use of the system-assigned managed identity is indicated
         with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated
         with the resource id of the managed identity resource.
        :paramtype connection_identity: str
        :keyword connection_string: The connection string to use to connect to the database.
        :paramtype connection_string: str
        :keyword region: The region of the database resource.
        :paramtype region: str
        """
        super().__init__(kind=kind, **kwargs)
        self.resource_id = resource_id
        self.connection_identity = connection_identity
        self.connection_string = connection_string
        self.region = region
        self.configuration_files = None


class DatabaseConnectionCollection(_serialization.Model):
    """Collection of static site database connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.DatabaseConnection]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DatabaseConnection"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.DatabaseConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DatabaseConnectionOverview(_serialization.Model):
    """Static Site Database Connection overview.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: The resource id of the database.
    :vartype resource_id: str
    :ivar connection_identity: If present, the identity is used in conjunction with connection
     string to connect to the database. Use of the system-assigned managed identity is indicated
     with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated
     with the resource id of the managed identity resource.
    :vartype connection_identity: str
    :ivar region: The region of the database resource.
    :vartype region: str
    :ivar configuration_files: A list of configuration files associated with this database
     connection.
    :vartype configuration_files:
     list[~azure.mgmt.web.v2023_01_01.models.StaticSiteDatabaseConnectionConfigurationFileOverview]
    :ivar name: If present, the name of this database connection resource.
    :vartype name: str
    """

    _validation = {
        "resource_id": {"readonly": True},
        "connection_identity": {"readonly": True},
        "region": {"readonly": True},
        "configuration_files": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "connection_identity": {"key": "connectionIdentity", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "configuration_files": {
            "key": "configurationFiles",
            "type": "[StaticSiteDatabaseConnectionConfigurationFileOverview]",
        },
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_id = None
        self.connection_identity = None
        self.region = None
        self.configuration_files = None
        self.name = None


class DatabaseConnectionPatchRequest(_serialization.Model):
    """Static Site Database Connection Request Properties resource when patching.

    :ivar resource_id: The resource id of the database.
    :vartype resource_id: str
    :ivar connection_identity: If present, the identity is used in conjunction with connection
     string to connect to the database. Use of the system-assigned managed identity is indicated
     with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated
     with the resource id of the managed identity resource.
    :vartype connection_identity: str
    :ivar connection_string: The connection string to use to connect to the database.
    :vartype connection_string: str
    :ivar region: The region of the database resource.
    :vartype region: str
    """

    _attribute_map = {
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "connection_identity": {"key": "properties.connectionIdentity", "type": "str"},
        "connection_string": {"key": "properties.connectionString", "type": "str"},
        "region": {"key": "properties.region", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        connection_identity: Optional[str] = None,
        connection_string: Optional[str] = None,
        region: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource id of the database.
        :paramtype resource_id: str
        :keyword connection_identity: If present, the identity is used in conjunction with connection
         string to connect to the database. Use of the system-assigned managed identity is indicated
         with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated
         with the resource id of the managed identity resource.
        :paramtype connection_identity: str
        :keyword connection_string: The connection string to use to connect to the database.
        :paramtype connection_string: str
        :keyword region: The region of the database resource.
        :paramtype region: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.connection_identity = connection_identity
        self.connection_string = connection_string
        self.region = region


class DataProviderMetadata(_serialization.Model):
    """Additional configuration for a data providers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider_name:
    :vartype provider_name: str
    :ivar property_bag: Settings for the data provider.
    :vartype property_bag: list[~azure.mgmt.web.v2023_01_01.models.KeyValuePairStringObject]
    """

    _validation = {
        "property_bag": {"readonly": True},
    }

    _attribute_map = {
        "provider_name": {"key": "providerName", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "[KeyValuePairStringObject]"},
    }

    def __init__(self, *, provider_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword provider_name:
        :paramtype provider_name: str
        """
        super().__init__(**kwargs)
        self.provider_name = provider_name
        self.property_bag = None


class DataSource(_serialization.Model):
    """Class representing data source used by the detectors.

    :ivar instructions: Instructions if any for the data source.
    :vartype instructions: list[str]
    :ivar data_source_uri: Datasource Uri Links.
    :vartype data_source_uri: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
    """

    _attribute_map = {
        "instructions": {"key": "instructions", "type": "[str]"},
        "data_source_uri": {"key": "dataSourceUri", "type": "[NameValuePair]"},
    }

    def __init__(
        self,
        *,
        instructions: Optional[List[str]] = None,
        data_source_uri: Optional[List["_models.NameValuePair"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instructions: Instructions if any for the data source.
        :paramtype instructions: list[str]
        :keyword data_source_uri: Datasource Uri Links.
        :paramtype data_source_uri: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
        """
        super().__init__(**kwargs)
        self.instructions = instructions
        self.data_source_uri = data_source_uri


class DataTableResponseColumn(_serialization.Model):
    """Column definition.

    :ivar column_name: Name of the column.
    :vartype column_name: str
    :ivar data_type: Data type which looks like 'String' or 'Int32'.
    :vartype data_type: str
    :ivar column_type: Column Type.
    :vartype column_type: str
    """

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "column_type": {"key": "columnType", "type": "str"},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[str] = None,
        column_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword column_name: Name of the column.
        :paramtype column_name: str
        :keyword data_type: Data type which looks like 'String' or 'Int32'.
        :paramtype data_type: str
        :keyword column_type: Column Type.
        :paramtype column_type: str
        """
        super().__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type
        self.column_type = column_type


class DataTableResponseObject(_serialization.Model):
    """Data Table which defines columns and raw row values.

    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar columns: List of columns with data types.
    :vartype columns: list[~azure.mgmt.web.v2023_01_01.models.DataTableResponseColumn]
    :ivar rows: Raw row values.
    :vartype rows: list[list[str]]
    """

    _attribute_map = {
        "table_name": {"key": "tableName", "type": "str"},
        "columns": {"key": "columns", "type": "[DataTableResponseColumn]"},
        "rows": {"key": "rows", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        columns: Optional[List["_models.DataTableResponseColumn"]] = None,
        rows: Optional[List[List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: Name of the table.
        :paramtype table_name: str
        :keyword columns: List of columns with data types.
        :paramtype columns: list[~azure.mgmt.web.v2023_01_01.models.DataTableResponseColumn]
        :keyword rows: Raw row values.
        :paramtype rows: list[list[str]]
        """
        super().__init__(**kwargs)
        self.table_name = table_name
        self.columns = columns
        self.rows = rows


class DefaultAuthorizationPolicy(_serialization.Model):
    """The configuration settings of the Azure Active Directory default authorization policy.

    :ivar allowed_principals: The configuration settings of the Azure Active Directory allowed
     principals.
    :vartype allowed_principals: ~azure.mgmt.web.v2023_01_01.models.AllowedPrincipals
    :ivar allowed_applications: The configuration settings of the Azure Active Directory allowed
     applications.
    :vartype allowed_applications: list[str]
    """

    _attribute_map = {
        "allowed_principals": {"key": "allowedPrincipals", "type": "AllowedPrincipals"},
        "allowed_applications": {"key": "allowedApplications", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allowed_principals: Optional["_models.AllowedPrincipals"] = None,
        allowed_applications: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_principals: The configuration settings of the Azure Active Directory allowed
         principals.
        :paramtype allowed_principals: ~azure.mgmt.web.v2023_01_01.models.AllowedPrincipals
        :keyword allowed_applications: The configuration settings of the Azure Active Directory allowed
         applications.
        :paramtype allowed_applications: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_principals = allowed_principals
        self.allowed_applications = allowed_applications


class DefaultErrorResponse(_serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.web.v2023_01_01.models.DefaultErrorResponseError
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "DefaultErrorResponseError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class DefaultErrorResponseError(_serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.web.v2023_01_01.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "innererror": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[DefaultErrorResponseErrorDetailsItem]"},
        "innererror": {"key": "innererror", "type": "str"},
    }

    def __init__(
        self, *, details: Optional[List["_models.DefaultErrorResponseErrorDetailsItem"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword details:
        :paramtype details:
         list[~azure.mgmt.web.v2023_01_01.models.DefaultErrorResponseErrorDetailsItem]
        """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = details
        self.innererror = None


class DefaultErrorResponseErrorDetailsItem(_serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class DeletedAppRestoreRequest(ProxyOnlyResource):
    """Details about restoring a deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: ARM resource ID of the deleted app. Example:
     /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
    :vartype deleted_site_id: str
    :ivar recover_configuration: If true, deleted site configuration, in addition to content, will
     be restored.
    :vartype recover_configuration: bool
    :ivar snapshot_time: Point in time to restore the deleted app from, formatted as a DateTime
     string.
     If unspecified, default value is the time that the app was deleted.
    :vartype snapshot_time: str
    :ivar use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :vartype use_dr_secondary: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deleted_site_id": {"key": "properties.deletedSiteId", "type": "str"},
        "recover_configuration": {"key": "properties.recoverConfiguration", "type": "bool"},
        "snapshot_time": {"key": "properties.snapshotTime", "type": "str"},
        "use_dr_secondary": {"key": "properties.useDRSecondary", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        deleted_site_id: Optional[str] = None,
        recover_configuration: Optional[bool] = None,
        snapshot_time: Optional[str] = None,
        use_dr_secondary: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword deleted_site_id: ARM resource ID of the deleted app. Example:
         /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
        :paramtype deleted_site_id: str
        :keyword recover_configuration: If true, deleted site configuration, in addition to content,
         will be restored.
        :paramtype recover_configuration: bool
        :keyword snapshot_time: Point in time to restore the deleted app from, formatted as a DateTime
         string.
         If unspecified, default value is the time that the app was deleted.
        :paramtype snapshot_time: str
        :keyword use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
        :paramtype use_dr_secondary: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.deleted_site_id = deleted_site_id
        self.recover_configuration = recover_configuration
        self.snapshot_time = snapshot_time
        self.use_dr_secondary = use_dr_secondary


class DeletedSite(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """A deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: Numeric id for the deleted site.
    :vartype deleted_site_id: int
    :ivar deleted_timestamp: Time in UTC when the app was deleted.
    :vartype deleted_timestamp: str
    :ivar subscription: Subscription containing the deleted site.
    :vartype subscription: str
    :ivar resource_group: ResourceGroup that contained the deleted site.
    :vartype resource_group: str
    :ivar deleted_site_name: Name of the deleted site.
    :vartype deleted_site_name: str
    :ivar slot: Slot of the deleted site.
    :vartype slot: str
    :ivar kind_properties_kind: Kind of site that was deleted.
    :vartype kind_properties_kind: str
    :ivar geo_region_name: Geo Region of the deleted site.
    :vartype geo_region_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "deleted_site_id": {"readonly": True},
        "deleted_timestamp": {"readonly": True},
        "subscription": {"readonly": True},
        "resource_group": {"readonly": True},
        "deleted_site_name": {"readonly": True},
        "slot": {"readonly": True},
        "kind_properties_kind": {"readonly": True},
        "geo_region_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deleted_site_id": {"key": "properties.deletedSiteId", "type": "int"},
        "deleted_timestamp": {"key": "properties.deletedTimestamp", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "deleted_site_name": {"key": "properties.deletedSiteName", "type": "str"},
        "slot": {"key": "properties.slot", "type": "str"},
        "kind_properties_kind": {"key": "properties.kind", "type": "str"},
        "geo_region_name": {"key": "properties.geoRegionName", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.deleted_site_id = None
        self.deleted_timestamp = None
        self.subscription = None
        self.resource_group = None
        self.deleted_site_name = None
        self.slot = None
        self.kind_properties_kind = None
        self.geo_region_name = None


class DeletedWebAppCollection(_serialization.Model):
    """Collection of deleted apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.DeletedSite]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedSite]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DeletedSite"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.DeletedSite]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Deployment(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Deployment status.
    :vartype status: int
    :ivar message: Details about deployment status.
    :vartype message: str
    :ivar author: Who authored the deployment.
    :vartype author: str
    :ivar deployer: Who performed the deployment.
    :vartype deployer: str
    :ivar author_email: Author email.
    :vartype author_email: str
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time.
    :vartype end_time: ~datetime.datetime
    :ivar active: True if deployment is currently active, false if completed and null if not
     started.
    :vartype active: bool
    :ivar details: Details on deployment.
    :vartype details: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "properties.status", "type": "int"},
        "message": {"key": "properties.message", "type": "str"},
        "author": {"key": "properties.author", "type": "str"},
        "deployer": {"key": "properties.deployer", "type": "str"},
        "author_email": {"key": "properties.author_email", "type": "str"},
        "start_time": {"key": "properties.start_time", "type": "iso-8601"},
        "end_time": {"key": "properties.end_time", "type": "iso-8601"},
        "active": {"key": "properties.active", "type": "bool"},
        "details": {"key": "properties.details", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[int] = None,
        message: Optional[str] = None,
        author: Optional[str] = None,
        deployer: Optional[str] = None,
        author_email: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        active: Optional[bool] = None,
        details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword status: Deployment status.
        :paramtype status: int
        :keyword message: Details about deployment status.
        :paramtype message: str
        :keyword author: Who authored the deployment.
        :paramtype author: str
        :keyword deployer: Who performed the deployment.
        :paramtype deployer: str
        :keyword author_email: Author email.
        :paramtype author_email: str
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time.
        :paramtype end_time: ~datetime.datetime
        :keyword active: True if deployment is currently active, false if completed and null if not
         started.
        :paramtype active: bool
        :keyword details: Details on deployment.
        :paramtype details: str
        """
        super().__init__(kind=kind, **kwargs)
        self.status = status
        self.message = message
        self.author = author
        self.deployer = deployer
        self.author_email = author_email
        self.start_time = start_time
        self.end_time = end_time
        self.active = active
        self.details = details


class DeploymentCollection(_serialization.Model):
    """Collection of app deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.Deployment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Deployment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Deployment"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.Deployment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DeploymentLocations(_serialization.Model):
    """List of available locations (regions or App Service Environments) for
    deployment of App Service resources.

    :ivar locations: Available regions.
    :vartype locations: list[~azure.mgmt.web.v2023_01_01.models.GeoRegion]
    :ivar hosting_environments: Available App Service Environments with full descriptions of the
     environments.
    :vartype hosting_environments: list[~azure.mgmt.web.v2023_01_01.models.AppServiceEnvironment]
    :ivar hosting_environment_deployment_infos: Available App Service Environments with basic
     information.
    :vartype hosting_environment_deployment_infos:
     list[~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentDeploymentInfo]
    """

    _attribute_map = {
        "locations": {"key": "locations", "type": "[GeoRegion]"},
        "hosting_environments": {"key": "hostingEnvironments", "type": "[AppServiceEnvironment]"},
        "hosting_environment_deployment_infos": {
            "key": "hostingEnvironmentDeploymentInfos",
            "type": "[HostingEnvironmentDeploymentInfo]",
        },
    }

    def __init__(
        self,
        *,
        locations: Optional[List["_models.GeoRegion"]] = None,
        hosting_environments: Optional[List["_models.AppServiceEnvironment"]] = None,
        hosting_environment_deployment_infos: Optional[List["_models.HostingEnvironmentDeploymentInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword locations: Available regions.
        :paramtype locations: list[~azure.mgmt.web.v2023_01_01.models.GeoRegion]
        :keyword hosting_environments: Available App Service Environments with full descriptions of the
         environments.
        :paramtype hosting_environments: list[~azure.mgmt.web.v2023_01_01.models.AppServiceEnvironment]
        :keyword hosting_environment_deployment_infos: Available App Service Environments with basic
         information.
        :paramtype hosting_environment_deployment_infos:
         list[~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentDeploymentInfo]
        """
        super().__init__(**kwargs)
        self.locations = locations
        self.hosting_environments = hosting_environments
        self.hosting_environment_deployment_infos = hosting_environment_deployment_infos


class DetectorAbnormalTimePeriod(_serialization.Model):
    """Class representing Abnormal Time Period detected.

    :ivar start_time: Start time of the correlated event.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the correlated event.
    :vartype end_time: ~datetime.datetime
    :ivar message: Message describing the event.
    :vartype message: str
    :ivar source: Represents the name of the Detector.
    :vartype source: str
    :ivar priority: Represents the rank of the Detector.
    :vartype priority: float
    :ivar meta_data: Downtime metadata.
    :vartype meta_data: list[list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]]
    :ivar type: Represents the type of the Detector. Known values are: "ServiceIncident",
     "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
     "PlatformIssue", and "Other".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.IssueType
    :ivar solutions: List of proposed solutions.
    :vartype solutions: list[~azure.mgmt.web.v2023_01_01.models.Solution]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "priority": {"key": "priority", "type": "float"},
        "meta_data": {"key": "metaData", "type": "[[NameValuePair]]"},
        "type": {"key": "type", "type": "str"},
        "solutions": {"key": "solutions", "type": "[Solution]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        source: Optional[str] = None,
        priority: Optional[float] = None,
        meta_data: Optional[List[List["_models.NameValuePair"]]] = None,
        type: Optional[Union[str, "_models.IssueType"]] = None,
        solutions: Optional[List["_models.Solution"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Start time of the correlated event.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the correlated event.
        :paramtype end_time: ~datetime.datetime
        :keyword message: Message describing the event.
        :paramtype message: str
        :keyword source: Represents the name of the Detector.
        :paramtype source: str
        :keyword priority: Represents the rank of the Detector.
        :paramtype priority: float
        :keyword meta_data: Downtime metadata.
        :paramtype meta_data: list[list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]]
        :keyword type: Represents the type of the Detector. Known values are: "ServiceIncident",
         "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
         "PlatformIssue", and "Other".
        :paramtype type: str or ~azure.mgmt.web.v2023_01_01.models.IssueType
        :keyword solutions: List of proposed solutions.
        :paramtype solutions: list[~azure.mgmt.web.v2023_01_01.models.Solution]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.message = message
        self.source = source
        self.priority = priority
        self.meta_data = meta_data
        self.type = type
        self.solutions = solutions


class DetectorDefinition(_serialization.Model):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display name of the detector.
    :vartype display_name: str
    :ivar description: Description of the detector.
    :vartype description: str
    :ivar rank: Detector Rank.
    :vartype rank: float
    :ivar is_enabled: Flag representing whether detector is enabled or not.
    :vartype is_enabled: bool
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "rank": {"readonly": True},
        "is_enabled": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rank": {"key": "rank", "type": "float"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.rank = None
        self.is_enabled = None


class DetectorDefinitionResource(ProxyOnlyResource):
    """ARM resource for a detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the detector.
    :vartype display_name: str
    :ivar description: Description of the detector.
    :vartype description: str
    :ivar rank: Detector Rank.
    :vartype rank: float
    :ivar is_enabled: Flag representing whether detector is enabled or not.
    :vartype is_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "rank": {"readonly": True},
        "is_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "rank": {"key": "properties.rank", "type": "float"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.display_name = None
        self.description = None
        self.rank = None
        self.is_enabled = None


class DetectorInfo(_serialization.Model):
    """Definition of Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of detector.
    :vartype id: str
    :ivar name: Name of detector.
    :vartype name: str
    :ivar description: Short description of the detector and its purpose.
    :vartype description: str
    :ivar author: Author of the detector.
    :vartype author: str
    :ivar category: Problem category. This serves for organizing group for detectors.
    :vartype category: str
    :ivar support_topic_list: List of Support Topics for which this detector is enabled.
    :vartype support_topic_list: list[~azure.mgmt.web.v2023_01_01.models.SupportTopic]
    :ivar analysis_type: Analysis Types for which this detector should apply to.
    :vartype analysis_type: list[str]
    :ivar type: Whether this detector is an Analysis Detector or not. Known values are: "Detector",
     "Analysis", and "CategoryOverview".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.DetectorType
    :ivar score: Defines score of a detector to power ML based matching.
    :vartype score: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "description": {"readonly": True},
        "author": {"readonly": True},
        "category": {"readonly": True},
        "support_topic_list": {"readonly": True},
        "analysis_type": {"readonly": True},
        "type": {"readonly": True},
        "score": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "author": {"key": "author", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "support_topic_list": {"key": "supportTopicList", "type": "[SupportTopic]"},
        "analysis_type": {"key": "analysisType", "type": "[str]"},
        "type": {"key": "type", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.description = None
        self.author = None
        self.category = None
        self.support_topic_list = None
        self.analysis_type = None
        self.type = None
        self.score = None


class DetectorResponse(ProxyOnlyResource):
    """Class representing Response from Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar metadata: metadata for the detector.
    :vartype metadata: ~azure.mgmt.web.v2023_01_01.models.DetectorInfo
    :ivar dataset: Data Set.
    :vartype dataset: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticData]
    :ivar status: Indicates status of the most severe insight.
    :vartype status: ~azure.mgmt.web.v2023_01_01.models.Status
    :ivar data_providers_metadata: Additional configuration for different data providers to be used
     by the UI.
    :vartype data_providers_metadata: list[~azure.mgmt.web.v2023_01_01.models.DataProviderMetadata]
    :ivar suggested_utterances: Suggested utterances where the detector can be applicable.
    :vartype suggested_utterances: ~azure.mgmt.web.v2023_01_01.models.QueryUtterancesResults
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "DetectorInfo"},
        "dataset": {"key": "properties.dataset", "type": "[DiagnosticData]"},
        "status": {"key": "properties.status", "type": "Status"},
        "data_providers_metadata": {"key": "properties.dataProvidersMetadata", "type": "[DataProviderMetadata]"},
        "suggested_utterances": {"key": "properties.suggestedUtterances", "type": "QueryUtterancesResults"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.DetectorInfo"] = None,
        dataset: Optional[List["_models.DiagnosticData"]] = None,
        status: Optional["_models.Status"] = None,
        data_providers_metadata: Optional[List["_models.DataProviderMetadata"]] = None,
        suggested_utterances: Optional["_models.QueryUtterancesResults"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword metadata: metadata for the detector.
        :paramtype metadata: ~azure.mgmt.web.v2023_01_01.models.DetectorInfo
        :keyword dataset: Data Set.
        :paramtype dataset: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticData]
        :keyword status: Indicates status of the most severe insight.
        :paramtype status: ~azure.mgmt.web.v2023_01_01.models.Status
        :keyword data_providers_metadata: Additional configuration for different data providers to be
         used by the UI.
        :paramtype data_providers_metadata:
         list[~azure.mgmt.web.v2023_01_01.models.DataProviderMetadata]
        :keyword suggested_utterances: Suggested utterances where the detector can be applicable.
        :paramtype suggested_utterances: ~azure.mgmt.web.v2023_01_01.models.QueryUtterancesResults
        """
        super().__init__(kind=kind, **kwargs)
        self.metadata = metadata
        self.dataset = dataset
        self.status = status
        self.data_providers_metadata = data_providers_metadata
        self.suggested_utterances = suggested_utterances


class DetectorResponseCollection(_serialization.Model):
    """Collection of detector responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.DetectorResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DetectorResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DetectorResponse"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.DetectorResponse]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticAnalysis(ProxyOnlyResource):
    """Class representing a diagnostic analysis done on an application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar abnormal_time_periods: List of time periods.
    :vartype abnormal_time_periods: list[~azure.mgmt.web.v2023_01_01.models.AbnormalTimePeriod]
    :ivar payload: Data by each detector.
    :vartype payload: list[~azure.mgmt.web.v2023_01_01.models.AnalysisData]
    :ivar non_correlated_detectors: Data by each detector for detectors that did not corelate.
    :vartype non_correlated_detectors: list[~azure.mgmt.web.v2023_01_01.models.DetectorDefinition]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "abnormal_time_periods": {"key": "properties.abnormalTimePeriods", "type": "[AbnormalTimePeriod]"},
        "payload": {"key": "properties.payload", "type": "[AnalysisData]"},
        "non_correlated_detectors": {"key": "properties.nonCorrelatedDetectors", "type": "[DetectorDefinition]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        abnormal_time_periods: Optional[List["_models.AbnormalTimePeriod"]] = None,
        payload: Optional[List["_models.AnalysisData"]] = None,
        non_correlated_detectors: Optional[List["_models.DetectorDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword abnormal_time_periods: List of time periods.
        :paramtype abnormal_time_periods: list[~azure.mgmt.web.v2023_01_01.models.AbnormalTimePeriod]
        :keyword payload: Data by each detector.
        :paramtype payload: list[~azure.mgmt.web.v2023_01_01.models.AnalysisData]
        :keyword non_correlated_detectors: Data by each detector for detectors that did not corelate.
        :paramtype non_correlated_detectors:
         list[~azure.mgmt.web.v2023_01_01.models.DetectorDefinition]
        """
        super().__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.abnormal_time_periods = abnormal_time_periods
        self.payload = payload
        self.non_correlated_detectors = non_correlated_detectors


class DiagnosticAnalysisCollection(_serialization.Model):
    """Collection of Diagnostic Analyses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.AnalysisDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AnalysisDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AnalysisDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.AnalysisDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticCategory(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the diagnostic category.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.description = None


class DiagnosticCategoryCollection(_serialization.Model):
    """Collection of Diagnostic Categories.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticCategory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiagnosticCategory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DiagnosticCategory"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticCategory]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticData(_serialization.Model):
    """Set of data with rendering instructions.

    :ivar table: Data in table form.
    :vartype table: ~azure.mgmt.web.v2023_01_01.models.DataTableResponseObject
    :ivar rendering_properties: Properties that describe how the table should be rendered.
    :vartype rendering_properties: ~azure.mgmt.web.v2023_01_01.models.Rendering
    """

    _attribute_map = {
        "table": {"key": "table", "type": "DataTableResponseObject"},
        "rendering_properties": {"key": "renderingProperties", "type": "Rendering"},
    }

    def __init__(
        self,
        *,
        table: Optional["_models.DataTableResponseObject"] = None,
        rendering_properties: Optional["_models.Rendering"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table: Data in table form.
        :paramtype table: ~azure.mgmt.web.v2023_01_01.models.DataTableResponseObject
        :keyword rendering_properties: Properties that describe how the table should be rendered.
        :paramtype rendering_properties: ~azure.mgmt.web.v2023_01_01.models.Rendering
        """
        super().__init__(**kwargs)
        self.table = table
        self.rendering_properties = rendering_properties


class DiagnosticDetectorCollection(_serialization.Model):
    """Collection of Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.DetectorDefinitionResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DetectorDefinitionResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DetectorDefinitionResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.DetectorDefinitionResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticDetectorResponse(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Class representing Response from Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar issue_detected: Flag representing Issue was detected.
    :vartype issue_detected: bool
    :ivar detector_definition: Detector's definition.
    :vartype detector_definition: ~azure.mgmt.web.v2023_01_01.models.DetectorDefinition
    :ivar metrics: Metrics provided by the detector.
    :vartype metrics: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticMetricSet]
    :ivar abnormal_time_periods: List of Correlated events found by the detector.
    :vartype abnormal_time_periods:
     list[~azure.mgmt.web.v2023_01_01.models.DetectorAbnormalTimePeriod]
    :ivar data: Additional Data that detector wants to send.
    :vartype data: list[list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]]
    :ivar response_meta_data: Meta Data.
    :vartype response_meta_data: ~azure.mgmt.web.v2023_01_01.models.ResponseMetaData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "issue_detected": {"key": "properties.issueDetected", "type": "bool"},
        "detector_definition": {"key": "properties.detectorDefinition", "type": "DetectorDefinition"},
        "metrics": {"key": "properties.metrics", "type": "[DiagnosticMetricSet]"},
        "abnormal_time_periods": {"key": "properties.abnormalTimePeriods", "type": "[DetectorAbnormalTimePeriod]"},
        "data": {"key": "properties.data", "type": "[[NameValuePair]]"},
        "response_meta_data": {"key": "properties.responseMetaData", "type": "ResponseMetaData"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        issue_detected: Optional[bool] = None,
        detector_definition: Optional["_models.DetectorDefinition"] = None,
        metrics: Optional[List["_models.DiagnosticMetricSet"]] = None,
        abnormal_time_periods: Optional[List["_models.DetectorAbnormalTimePeriod"]] = None,
        data: Optional[List[List["_models.NameValuePair"]]] = None,
        response_meta_data: Optional["_models.ResponseMetaData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword issue_detected: Flag representing Issue was detected.
        :paramtype issue_detected: bool
        :keyword detector_definition: Detector's definition.
        :paramtype detector_definition: ~azure.mgmt.web.v2023_01_01.models.DetectorDefinition
        :keyword metrics: Metrics provided by the detector.
        :paramtype metrics: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticMetricSet]
        :keyword abnormal_time_periods: List of Correlated events found by the detector.
        :paramtype abnormal_time_periods:
         list[~azure.mgmt.web.v2023_01_01.models.DetectorAbnormalTimePeriod]
        :keyword data: Additional Data that detector wants to send.
        :paramtype data: list[list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]]
        :keyword response_meta_data: Meta Data.
        :paramtype response_meta_data: ~azure.mgmt.web.v2023_01_01.models.ResponseMetaData
        """
        super().__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.issue_detected = issue_detected
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.abnormal_time_periods = abnormal_time_periods
        self.data = data
        self.response_meta_data = response_meta_data


class DiagnosticMetricSample(_serialization.Model):
    """Class representing Diagnostic Metric.

    :ivar timestamp: Time at which metric is measured.
    :vartype timestamp: ~datetime.datetime
    :ivar role_instance: Role Instance. Null if this counter is not per instance
     This is returned and should be whichever instance name we desire to be returned
     i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
    :vartype role_instance: str
    :ivar total: Total value of the metric. If multiple measurements are made this will have sum of
     all.
    :vartype total: float
    :ivar maximum: Maximum of the metric sampled during the time period.
    :vartype maximum: float
    :ivar minimum: Minimum of the metric sampled during the time period.
    :vartype minimum: float
    :ivar is_aggregated: Whether the values are aggregates across all workers or not.
    :vartype is_aggregated: bool
    """

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "role_instance": {"key": "roleInstance", "type": "str"},
        "total": {"key": "total", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "is_aggregated": {"key": "isAggregated", "type": "bool"},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        role_instance: Optional[str] = None,
        total: Optional[float] = None,
        maximum: Optional[float] = None,
        minimum: Optional[float] = None,
        is_aggregated: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timestamp: Time at which metric is measured.
        :paramtype timestamp: ~datetime.datetime
        :keyword role_instance: Role Instance. Null if this counter is not per instance
         This is returned and should be whichever instance name we desire to be returned
         i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
         where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
        :paramtype role_instance: str
        :keyword total: Total value of the metric. If multiple measurements are made this will have sum
         of all.
        :paramtype total: float
        :keyword maximum: Maximum of the metric sampled during the time period.
        :paramtype maximum: float
        :keyword minimum: Minimum of the metric sampled during the time period.
        :paramtype minimum: float
        :keyword is_aggregated: Whether the values are aggregates across all workers or not.
        :paramtype is_aggregated: bool
        """
        super().__init__(**kwargs)
        self.timestamp = timestamp
        self.role_instance = role_instance
        self.total = total
        self.maximum = maximum
        self.minimum = minimum
        self.is_aggregated = is_aggregated


class DiagnosticMetricSet(_serialization.Model):
    """Class representing Diagnostic Metric information.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar unit: Metric's unit.
    :vartype unit: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
    :vartype time_grain: str
    :ivar values: Collection of metric values for the selected period based on the
     {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
    :vartype values: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticMetricSample]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "values": {"key": "values", "type": "[DiagnosticMetricSample]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        unit: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["_models.DiagnosticMetricSample"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword unit: Metric's unit.
        :paramtype unit: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
        :paramtype time_grain: str
        :keyword values: Collection of metric values for the selected period based on the
         {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
        :paramtype values: list[~azure.mgmt.web.v2023_01_01.models.DiagnosticMetricSample]
        """
        super().__init__(**kwargs)
        self.name = name
        self.unit = unit
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class Dimension(_serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app,
    where instance name is dimension of the metric HTTP request.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar internal_name:
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox:
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword internal_name:
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox:
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class Domain(Resource):  # pylint: disable=too-many-instance-attributes
    """Information about a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar contact_admin: Administrative contact.
    :vartype contact_admin: ~azure.mgmt.web.v2023_01_01.models.Contact
    :ivar contact_billing: Billing contact.
    :vartype contact_billing: ~azure.mgmt.web.v2023_01_01.models.Contact
    :ivar contact_registrant: Registrant contact.
    :vartype contact_registrant: ~azure.mgmt.web.v2023_01_01.models.Contact
    :ivar contact_tech: Technical contact.
    :vartype contact_tech: ~azure.mgmt.web.v2023_01_01.models.Contact
    :ivar registration_status: Domain registration status. Known values are: "Active", "Awaiting",
     "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held", "Locked",
     "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown", "Unlocked",
     "Unparked", "Updated", and "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2023_01_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :ivar privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :ivar auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2023_01_01.models.HostName]
    :ivar consent: Legal agreement consent.
    :vartype consent: ~azure.mgmt.web.v2023_01_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2023_01_01.models.ResourceNotRenewableReason]
    :ivar dns_type: Current DNS type. Known values are: "AzureDns" and "DefaultDomainRegistrarDns".
    :vartype dns_type: str or ~azure.mgmt.web.v2023_01_01.models.DnsType
    :ivar dns_zone_id: Azure DNS Zone to use.
    :vartype dns_zone_id: str
    :ivar target_dns_type: Target DNS type (would be used for migration). Known values are:
     "AzureDns" and "DefaultDomainRegistrarDns".
    :vartype target_dns_type: str or ~azure.mgmt.web.v2023_01_01.models.DnsType
    :ivar auth_code:
    :vartype auth_code: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "registration_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "name_servers": {"readonly": True},
        "created_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "last_renewed_time": {"readonly": True},
        "ready_for_dns_record_management": {"readonly": True},
        "managed_host_names": {"readonly": True},
        "domain_not_renewable_reasons": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "contact_admin": {"key": "properties.contactAdmin", "type": "Contact"},
        "contact_billing": {"key": "properties.contactBilling", "type": "Contact"},
        "contact_registrant": {"key": "properties.contactRegistrant", "type": "Contact"},
        "contact_tech": {"key": "properties.contactTech", "type": "Contact"},
        "registration_status": {"key": "properties.registrationStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "name_servers": {"key": "properties.nameServers", "type": "[str]"},
        "privacy": {"key": "properties.privacy", "type": "bool"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "last_renewed_time": {"key": "properties.lastRenewedTime", "type": "iso-8601"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "ready_for_dns_record_management": {"key": "properties.readyForDnsRecordManagement", "type": "bool"},
        "managed_host_names": {"key": "properties.managedHostNames", "type": "[HostName]"},
        "consent": {"key": "properties.consent", "type": "DomainPurchaseConsent"},
        "domain_not_renewable_reasons": {"key": "properties.domainNotRenewableReasons", "type": "[str]"},
        "dns_type": {"key": "properties.dnsType", "type": "str"},
        "dns_zone_id": {"key": "properties.dnsZoneId", "type": "str"},
        "target_dns_type": {"key": "properties.targetDnsType", "type": "str"},
        "auth_code": {"key": "properties.authCode", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        contact_admin: Optional["_models.Contact"] = None,
        contact_billing: Optional["_models.Contact"] = None,
        contact_registrant: Optional["_models.Contact"] = None,
        contact_tech: Optional["_models.Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: bool = True,
        consent: Optional["_models.DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword contact_admin: Administrative contact.
        :paramtype contact_admin: ~azure.mgmt.web.v2023_01_01.models.Contact
        :keyword contact_billing: Billing contact.
        :paramtype contact_billing: ~azure.mgmt.web.v2023_01_01.models.Contact
        :keyword contact_registrant: Registrant contact.
        :paramtype contact_registrant: ~azure.mgmt.web.v2023_01_01.models.Contact
        :keyword contact_tech: Technical contact.
        :paramtype contact_tech: ~azure.mgmt.web.v2023_01_01.models.Contact
        :keyword privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
         otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        :keyword auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
         otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword consent: Legal agreement consent.
        :paramtype consent: ~azure.mgmt.web.v2023_01_01.models.DomainPurchaseConsent
        :keyword dns_type: Current DNS type. Known values are: "AzureDns" and
         "DefaultDomainRegistrarDns".
        :paramtype dns_type: str or ~azure.mgmt.web.v2023_01_01.models.DnsType
        :keyword dns_zone_id: Azure DNS Zone to use.
        :paramtype dns_zone_id: str
        :keyword target_dns_type: Target DNS type (would be used for migration). Known values are:
         "AzureDns" and "DefaultDomainRegistrarDns".
        :paramtype target_dns_type: str or ~azure.mgmt.web.v2023_01_01.models.DnsType
        :keyword auth_code:
        :paramtype auth_code: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainAvailabilityCheckResult(_serialization.Model):
    """Domain availability check result.

    :ivar name: Name of the domain.
    :vartype name: str
    :ivar available: :code:`<code>true</code>` if domain can be purchased using CreateDomain API;
     otherwise, :code:`<code>false</code>`.
    :vartype available: bool
    :ivar domain_type: Valid values are Regular domain: Azure will charge the full price of domain
     registration, SoftDeleted: Purchasing this domain will simply restore it and this operation
     will not cost anything. Known values are: "Regular" and "SoftDeleted".
    :vartype domain_type: str or ~azure.mgmt.web.v2023_01_01.models.DomainType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "available": {"key": "available", "type": "bool"},
        "domain_type": {"key": "domainType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available: Optional[bool] = None,
        domain_type: Optional[Union[str, "_models.DomainType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the domain.
        :paramtype name: str
        :keyword available: :code:`<code>true</code>` if domain can be purchased using CreateDomain
         API; otherwise, :code:`<code>false</code>`.
        :paramtype available: bool
        :keyword domain_type: Valid values are Regular domain: Azure will charge the full price of
         domain registration, SoftDeleted: Purchasing this domain will simply restore it and this
         operation will not cost anything. Known values are: "Regular" and "SoftDeleted".
        :paramtype domain_type: str or ~azure.mgmt.web.v2023_01_01.models.DomainType
        """
        super().__init__(**kwargs)
        self.name = name
        self.available = available
        self.domain_type = domain_type


class DomainCollection(_serialization.Model):
    """Collection of domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.Domain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Domain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Domain"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.Domain]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainControlCenterSsoRequest(_serialization.Model):
    """Single sign-on request information for domain management.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar url: URL where the single sign-on request is to be made.
    :vartype url: str
    :ivar post_parameter_key: Post parameter key.
    :vartype post_parameter_key: str
    :ivar post_parameter_value: Post parameter value. Client should use
     'application/x-www-form-urlencoded' encoding for this value.
    :vartype post_parameter_value: str
    """

    _validation = {
        "url": {"readonly": True},
        "post_parameter_key": {"readonly": True},
        "post_parameter_value": {"readonly": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "post_parameter_key": {"key": "postParameterKey", "type": "str"},
        "post_parameter_value": {"key": "postParameterValue", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.url = None
        self.post_parameter_key = None
        self.post_parameter_value = None


class DomainOwnershipIdentifier(ProxyOnlyResource):
    """Domain ownership Identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar ownership_id: Ownership Id.
    :vartype ownership_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "ownership_id": {"key": "properties.ownershipId", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, ownership_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword ownership_id: Ownership Id.
        :paramtype ownership_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.ownership_id = ownership_id


class DomainOwnershipIdentifierCollection(_serialization.Model):
    """Collection of domain ownership identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.DomainOwnershipIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DomainOwnershipIdentifier]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DomainOwnershipIdentifier"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.DomainOwnershipIdentifier]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar contact_admin: Administrative contact.
    :vartype contact_admin: ~azure.mgmt.web.v2023_01_01.models.Contact
    :ivar contact_billing: Billing contact.
    :vartype contact_billing: ~azure.mgmt.web.v2023_01_01.models.Contact
    :ivar contact_registrant: Registrant contact.
    :vartype contact_registrant: ~azure.mgmt.web.v2023_01_01.models.Contact
    :ivar contact_tech: Technical contact.
    :vartype contact_tech: ~azure.mgmt.web.v2023_01_01.models.Contact
    :ivar registration_status: Domain registration status. Known values are: "Active", "Awaiting",
     "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held", "Locked",
     "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown", "Unlocked",
     "Unparked", "Updated", and "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2023_01_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2023_01_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :ivar privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :ivar auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2023_01_01.models.HostName]
    :ivar consent: Legal agreement consent.
    :vartype consent: ~azure.mgmt.web.v2023_01_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2023_01_01.models.ResourceNotRenewableReason]
    :ivar dns_type: Current DNS type. Known values are: "AzureDns" and "DefaultDomainRegistrarDns".
    :vartype dns_type: str or ~azure.mgmt.web.v2023_01_01.models.DnsType
    :ivar dns_zone_id: Azure DNS Zone to use.
    :vartype dns_zone_id: str
    :ivar target_dns_type: Target DNS type (would be used for migration). Known values are:
     "AzureDns" and "DefaultDomainRegistrarDns".
    :vartype target_dns_type: str or ~azure.mgmt.web.v2023_01_01.models.DnsType
    :ivar auth_code:
    :vartype auth_code: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "registration_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "name_servers": {"readonly": True},
        "created_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "last_renewed_time": {"readonly": True},
        "ready_for_dns_record_management": {"readonly": True},
        "managed_host_names": {"readonly": True},
        "domain_not_renewable_reasons": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "contact_admin": {"key": "properties.contactAdmin", "type": "Contact"},
        "contact_billing": {"key": "properties.contactBilling", "type": "Contact"},
        "contact_registrant": {"key": "properties.contactRegistrant", "type": "Contact"},
        "contact_tech": {"key": "properties.contactTech", "type": "Contact"},
        "registration_status": {"key": "properties.registrationStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "name_servers": {"key": "properties.nameServers", "type": "[str]"},
        "privacy": {"key": "properties.privacy", "type": "bool"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "last_renewed_time": {"key": "properties.lastRenewedTime", "type": "iso-8601"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "ready_for_dns_record_management": {"key": "properties.readyForDnsRecordManagement", "type": "bool"},
        "managed_host_names": {"key": "properties.managedHostNames", "type": "[HostName]"},
        "consent": {"key": "properties.consent", "type": "DomainPurchaseConsent"},
        "domain_not_renewable_reasons": {"key": "properties.domainNotRenewableReasons", "type": "[str]"},
        "dns_type": {"key": "properties.dnsType", "type": "str"},
        "dns_zone_id": {"key": "properties.dnsZoneId", "type": "str"},
        "target_dns_type": {"key": "properties.targetDnsType", "type": "str"},
        "auth_code": {"key": "properties.authCode", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        contact_admin: Optional["_models.Contact"] = None,
        contact_billing: Optional["_models.Contact"] = None,
        contact_registrant: Optional["_models.Contact"] = None,
        contact_tech: Optional["_models.Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: bool = True,
        consent: Optional["_models.DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "_models.DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword contact_admin: Administrative contact.
        :paramtype contact_admin: ~azure.mgmt.web.v2023_01_01.models.Contact
        :keyword contact_billing: Billing contact.
        :paramtype contact_billing: ~azure.mgmt.web.v2023_01_01.models.Contact
        :keyword contact_registrant: Registrant contact.
        :paramtype contact_registrant: ~azure.mgmt.web.v2023_01_01.models.Contact
        :keyword contact_tech: Technical contact.
        :paramtype contact_tech: ~azure.mgmt.web.v2023_01_01.models.Contact
        :keyword privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
         otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        :keyword auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
         otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword consent: Legal agreement consent.
        :paramtype consent: ~azure.mgmt.web.v2023_01_01.models.DomainPurchaseConsent
        :keyword dns_type: Current DNS type. Known values are: "AzureDns" and
         "DefaultDomainRegistrarDns".
        :paramtype dns_type: str or ~azure.mgmt.web.v2023_01_01.models.DnsType
        :keyword dns_zone_id: Azure DNS Zone to use.
        :paramtype dns_zone_id: str
        :keyword target_dns_type: Target DNS type (would be used for migration). Known values are:
         "AzureDns" and "DefaultDomainRegistrarDns".
        :paramtype target_dns_type: str or ~azure.mgmt.web.v2023_01_01.models.DnsType
        :keyword auth_code:
        :paramtype auth_code: str
        """
        super().__init__(kind=kind, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainPurchaseConsent(_serialization.Model):
    """Domain purchase consent object, representing acceptance of applicable legal agreements.

    :ivar agreement_keys: List of applicable legal agreement keys. This list can be retrieved using
     ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
    :vartype agreement_keys: list[str]
    :ivar agreed_by: Client IP address.
    :vartype agreed_by: str
    :ivar agreed_at: Timestamp when the agreements were accepted.
    :vartype agreed_at: ~datetime.datetime
    """

    _attribute_map = {
        "agreement_keys": {"key": "agreementKeys", "type": "[str]"},
        "agreed_by": {"key": "agreedBy", "type": "str"},
        "agreed_at": {"key": "agreedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        agreement_keys: Optional[List[str]] = None,
        agreed_by: Optional[str] = None,
        agreed_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword agreement_keys: List of applicable legal agreement keys. This list can be retrieved
         using ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
        :paramtype agreement_keys: list[str]
        :keyword agreed_by: Client IP address.
        :paramtype agreed_by: str
        :keyword agreed_at: Timestamp when the agreements were accepted.
        :paramtype agreed_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.agreement_keys = agreement_keys
        self.agreed_by = agreed_by
        self.agreed_at = agreed_at


class DomainRecommendationSearchParameters(_serialization.Model):
    """Domain recommendation search parameters.

    :ivar keywords: Keywords to be used for generating domain recommendations.
    :vartype keywords: str
    :ivar max_domain_recommendations: Maximum number of recommendations.
    :vartype max_domain_recommendations: int
    """

    _attribute_map = {
        "keywords": {"key": "keywords", "type": "str"},
        "max_domain_recommendations": {"key": "maxDomainRecommendations", "type": "int"},
    }

    def __init__(
        self, *, keywords: Optional[str] = None, max_domain_recommendations: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword keywords: Keywords to be used for generating domain recommendations.
        :paramtype keywords: str
        :keyword max_domain_recommendations: Maximum number of recommendations.
        :paramtype max_domain_recommendations: int
        """
        super().__init__(**kwargs)
        self.keywords = keywords
        self.max_domain_recommendations = max_domain_recommendations


class EnabledConfig(_serialization.Model):
    """Enabled configuration.

    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class EndpointDependency(_serialization.Model):
    """A domain name that a service is reached at, including details of the current connection status.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
    :vartype endpoint_details: list[~azure.mgmt.web.v2023_01_01.models.EndpointDetail]
    """

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["_models.EndpointDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain_name: The domain name of the dependency.
        :paramtype domain_name: str
        :keyword endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
        :paramtype endpoint_details: list[~azure.mgmt.web.v2023_01_01.models.EndpointDetail]
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(_serialization.Model):
    """Current TCP connectivity information from the App Service Environment to a single endpoint.

    :ivar ip_address: An IP Address that Domain Name currently resolves to.
    :vartype ip_address: str
    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar latency: The time in milliseconds it takes for a TCP connection to be created from the
     App Service Environment to this IpAddress at this Port.
    :vartype latency: float
    :ivar is_accessible: Whether it is possible to create a TCP connection from the App Service
     Environment to this IpAddress at this Port.
    :vartype is_accessible: bool
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "latency": {"key": "latency", "type": "float"},
        "is_accessible": {"key": "isAccessible", "type": "bool"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        latency: Optional[float] = None,
        is_accessible: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_address: An IP Address that Domain Name currently resolves to.
        :paramtype ip_address: str
        :keyword port: The port an endpoint is connected to.
        :paramtype port: int
        :keyword latency: The time in milliseconds it takes for a TCP connection to be created from the
         App Service Environment to this IpAddress at this Port.
        :paramtype latency: float
        :keyword is_accessible: Whether it is possible to create a TCP connection from the App Service
         Environment to this IpAddress at this Port.
        :paramtype is_accessible: bool
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.latency = latency
        self.is_accessible = is_accessible


class EnvironmentVar(_serialization.Model):
    """Container App container environment variable.

    :ivar name: Environment variable name.
    :vartype name: str
    :ivar value: Non-secret environment variable value.
    :vartype value: str
    :ivar secret_ref: Name of the Container App secret from which to pull the environment variable
     value.
    :vartype secret_ref: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "secret_ref": {"key": "secretRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Environment variable name.
        :paramtype name: str
        :keyword value: Non-secret environment variable value.
        :paramtype value: str
        :keyword secret_ref: Name of the Container App secret from which to pull the environment
         variable value.
        :paramtype secret_ref: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref


class ErrorEntity(_serialization.Model):
    """Body of the error response returned from the API.

    :ivar extended_code: Type of error.
    :vartype extended_code: str
    :ivar message_template: Message template.
    :vartype message_template: str
    :ivar parameters: Parameters for the template.
    :vartype parameters: list[str]
    :ivar inner_errors: Inner errors.
    :vartype inner_errors: list[~azure.mgmt.web.v2023_01_01.models.ErrorEntity]
    :ivar details: Error Details.
    :vartype details: list[~azure.mgmt.web.v2023_01_01.models.ErrorEntity]
    :ivar target: The error target.
    :vartype target: str
    :ivar code: Basic error code.
    :vartype code: str
    :ivar message: Any details of the error.
    :vartype message: str
    """

    _attribute_map = {
        "extended_code": {"key": "extendedCode", "type": "str"},
        "message_template": {"key": "messageTemplate", "type": "str"},
        "parameters": {"key": "parameters", "type": "[str]"},
        "inner_errors": {"key": "innerErrors", "type": "[ErrorEntity]"},
        "details": {"key": "details", "type": "[ErrorEntity]"},
        "target": {"key": "target", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[List[str]] = None,
        inner_errors: Optional[List["_models.ErrorEntity"]] = None,
        details: Optional[List["_models.ErrorEntity"]] = None,
        target: Optional[str] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_code: Type of error.
        :paramtype extended_code: str
        :keyword message_template: Message template.
        :paramtype message_template: str
        :keyword parameters: Parameters for the template.
        :paramtype parameters: list[str]
        :keyword inner_errors: Inner errors.
        :paramtype inner_errors: list[~azure.mgmt.web.v2023_01_01.models.ErrorEntity]
        :keyword details: Error Details.
        :paramtype details: list[~azure.mgmt.web.v2023_01_01.models.ErrorEntity]
        :keyword target: The error target.
        :paramtype target: str
        :keyword code: Basic error code.
        :paramtype code: str
        :keyword message: Any details of the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.details = details
        self.target = target
        self.code = code
        self.message = message


class ErrorProperties(_serialization.Model):
    """Error properties indicate why the Logic service was not able to process the incoming request.
    The reason is provided in the error message.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponse(_serialization.Model):
    """Error response indicates Logic service is not able to process the incoming request. The error
    property contains the error details.

    :ivar error: The error properties.
    :vartype error: ~azure.mgmt.web.v2023_01_01.models.ErrorProperties
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorProperties"},
    }

    def __init__(self, *, error: Optional["_models.ErrorProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error properties.
        :paramtype error: ~azure.mgmt.web.v2023_01_01.models.ErrorProperties
        """
        super().__init__(**kwargs)
        self.error = error


class Experiments(_serialization.Model):
    """Routing rules in production experiments.

    :ivar ramp_up_rules: List of ramp-up rules.
    :vartype ramp_up_rules: list[~azure.mgmt.web.v2023_01_01.models.RampUpRule]
    """

    _attribute_map = {
        "ramp_up_rules": {"key": "rampUpRules", "type": "[RampUpRule]"},
    }

    def __init__(self, *, ramp_up_rules: Optional[List["_models.RampUpRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword ramp_up_rules: List of ramp-up rules.
        :paramtype ramp_up_rules: list[~azure.mgmt.web.v2023_01_01.models.RampUpRule]
        """
        super().__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class Expression(_serialization.Model):
    """The expression.

    :ivar text: The text.
    :vartype text: str
    :ivar value: Anything.
    :vartype value: any
    :ivar subexpressions: The sub expressions.
    :vartype subexpressions: list[~azure.mgmt.web.v2023_01_01.models.Expression]
    :ivar error: The azure resource error info.
    :vartype error: ~azure.mgmt.web.v2023_01_01.models.AzureResourceErrorInfo
    """

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "value": {"key": "value", "type": "object"},
        "subexpressions": {"key": "subexpressions", "type": "[Expression]"},
        "error": {"key": "error", "type": "AzureResourceErrorInfo"},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        value: Optional[Any] = None,
        subexpressions: Optional[List["_models.Expression"]] = None,
        error: Optional["_models.AzureResourceErrorInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword text: The text.
        :paramtype text: str
        :keyword value: Anything.
        :paramtype value: any
        :keyword subexpressions: The sub expressions.
        :paramtype subexpressions: list[~azure.mgmt.web.v2023_01_01.models.Expression]
        :keyword error: The azure resource error info.
        :paramtype error: ~azure.mgmt.web.v2023_01_01.models.AzureResourceErrorInfo
        """
        super().__init__(**kwargs)
        self.text = text
        self.value = value
        self.subexpressions = subexpressions
        self.error = error


class ExpressionRoot(Expression):
    """The expression root.

    :ivar text: The text.
    :vartype text: str
    :ivar value: Anything.
    :vartype value: any
    :ivar subexpressions: The sub expressions.
    :vartype subexpressions: list[~azure.mgmt.web.v2023_01_01.models.Expression]
    :ivar error: The azure resource error info.
    :vartype error: ~azure.mgmt.web.v2023_01_01.models.AzureResourceErrorInfo
    :ivar path: The path.
    :vartype path: str
    """

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "value": {"key": "value", "type": "object"},
        "subexpressions": {"key": "subexpressions", "type": "[Expression]"},
        "error": {"key": "error", "type": "AzureResourceErrorInfo"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        value: Optional[Any] = None,
        subexpressions: Optional[List["_models.Expression"]] = None,
        error: Optional["_models.AzureResourceErrorInfo"] = None,
        path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword text: The text.
        :paramtype text: str
        :keyword value: Anything.
        :paramtype value: any
        :keyword subexpressions: The sub expressions.
        :paramtype subexpressions: list[~azure.mgmt.web.v2023_01_01.models.Expression]
        :keyword error: The azure resource error info.
        :paramtype error: ~azure.mgmt.web.v2023_01_01.models.AzureResourceErrorInfo
        :keyword path: The path.
        :paramtype path: str
        """
        super().__init__(text=text, value=value, subexpressions=subexpressions, error=error, **kwargs)
        self.path = path


class ExpressionTraces(_serialization.Model):
    """The expression traces.

    :ivar value: Anything.
    :vartype value: any
    :ivar inputs:
    :vartype inputs: list[~azure.mgmt.web.v2023_01_01.models.ExpressionRoot]
    :ivar next_link: The link used to get the next page of recommendations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "object"},
        "inputs": {"key": "inputs", "type": "[ExpressionRoot]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[Any] = None,
        inputs: Optional[List["_models.ExpressionRoot"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Anything.
        :paramtype value: any
        :keyword inputs:
        :paramtype inputs: list[~azure.mgmt.web.v2023_01_01.models.ExpressionRoot]
        :keyword next_link: The link used to get the next page of recommendations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.inputs = inputs
        self.next_link = next_link


class ExtendedLocation(_serialization.Model):
    """Extended Location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of extended location.
    :vartype name: str
    :ivar type: Type of extended location.
    :vartype type: str
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of extended location.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = None


class Facebook(_serialization.Model):
    """The configuration settings of the Facebook provider.

    :ivar enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
     despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Facebook
     provider.
    :vartype registration: ~azure.mgmt.web.v2023_01_01.models.AppRegistration
    :ivar graph_api_version: The version of the Facebook api to be used while logging in.
    :vartype graph_api_version: str
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "AppRegistration"},
        "graph_api_version": {"key": "graphApiVersion", "type": "str"},
        "login": {"key": "login", "type": "LoginScopes"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.AppRegistration"] = None,
        graph_api_version: Optional[str] = None,
        login: Optional["_models.LoginScopes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Facebook
         provider.
        :paramtype registration: ~azure.mgmt.web.v2023_01_01.models.AppRegistration
        :keyword graph_api_version: The version of the Facebook api to be used while logging in.
        :paramtype graph_api_version: str
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.graph_api_version = graph_api_version
        self.login = login


class FileSystemApplicationLogsConfig(_serialization.Model):
    """Application logs to file system configuration.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2023_01_01.models.LogLevel
    """

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
    }

    def __init__(self, *, level: Optional[Union[str, "_models.LogLevel"]] = None, **kwargs: Any) -> None:
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", and
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2023_01_01.models.LogLevel
        """
        super().__init__(**kwargs)
        self.level = level


class FileSystemHttpLogsConfig(_serialization.Model):
    """Http logs to file system configuration.

    :ivar retention_in_mb: Maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
    :vartype retention_in_mb: int
    :ivar retention_in_days: Retention in days.
     Remove files older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _validation = {
        "retention_in_mb": {"maximum": 100, "minimum": 25},
    }

    _attribute_map = {
        "retention_in_mb": {"key": "retentionInMb", "type": "int"},
        "retention_in_days": {"key": "retentionInDays", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        retention_in_mb: Optional[int] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword retention_in_mb: Maximum size in megabytes that http log files can use.
         When reached old log files will be removed to make space for new ones.
         Value can range between 25 and 100.
        :paramtype retention_in_mb: int
        :keyword retention_in_days: Retention in days.
         Remove files older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.retention_in_mb = retention_in_mb
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class FileSystemTokenStore(_serialization.Model):
    """The configuration settings of the storage of the tokens if a file system is used.

    :ivar directory: The directory in which the tokens will be stored.
    :vartype directory: str
    """

    _attribute_map = {
        "directory": {"key": "directory", "type": "str"},
    }

    def __init__(self, *, directory: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword directory: The directory in which the tokens will be stored.
        :paramtype directory: str
        """
        super().__init__(**kwargs)
        self.directory = directory


class FlowAccessControlConfiguration(_serialization.Model):
    """The access control configuration.

    :ivar triggers: The access control configuration for invoking workflow triggers.
    :vartype triggers: ~azure.mgmt.web.v2023_01_01.models.FlowAccessControlConfigurationPolicy
    :ivar contents: The access control configuration for accessing workflow run contents.
    :vartype contents: ~azure.mgmt.web.v2023_01_01.models.FlowAccessControlConfigurationPolicy
    :ivar actions: The access control configuration for workflow actions.
    :vartype actions: ~azure.mgmt.web.v2023_01_01.models.FlowAccessControlConfigurationPolicy
    :ivar workflow_management: The access control configuration for workflow management.
    :vartype workflow_management:
     ~azure.mgmt.web.v2023_01_01.models.FlowAccessControlConfigurationPolicy
    """

    _attribute_map = {
        "triggers": {"key": "triggers", "type": "FlowAccessControlConfigurationPolicy"},
        "contents": {"key": "contents", "type": "FlowAccessControlConfigurationPolicy"},
        "actions": {"key": "actions", "type": "FlowAccessControlConfigurationPolicy"},
        "workflow_management": {"key": "workflowManagement", "type": "FlowAccessControlConfigurationPolicy"},
    }

    def __init__(
        self,
        *,
        triggers: Optional["_models.FlowAccessControlConfigurationPolicy"] = None,
        contents: Optional["_models.FlowAccessControlConfigurationPolicy"] = None,
        actions: Optional["_models.FlowAccessControlConfigurationPolicy"] = None,
        workflow_management: Optional["_models.FlowAccessControlConfigurationPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword triggers: The access control configuration for invoking workflow triggers.
        :paramtype triggers: ~azure.mgmt.web.v2023_01_01.models.FlowAccessControlConfigurationPolicy
        :keyword contents: The access control configuration for accessing workflow run contents.
        :paramtype contents: ~azure.mgmt.web.v2023_01_01.models.FlowAccessControlConfigurationPolicy
        :keyword actions: The access control configuration for workflow actions.
        :paramtype actions: ~azure.mgmt.web.v2023_01_01.models.FlowAccessControlConfigurationPolicy
        :keyword workflow_management: The access control configuration for workflow management.
        :paramtype workflow_management:
         ~azure.mgmt.web.v2023_01_01.models.FlowAccessControlConfigurationPolicy
        """
        super().__init__(**kwargs)
        self.triggers = triggers
        self.contents = contents
        self.actions = actions
        self.workflow_management = workflow_management


class FlowAccessControlConfigurationPolicy(_serialization.Model):
    """The access control configuration policy.

    :ivar allowed_caller_ip_addresses: The allowed caller IP address ranges.
    :vartype allowed_caller_ip_addresses: list[~azure.mgmt.web.v2023_01_01.models.IpAddressRange]
    :ivar open_authentication_policies: The authentication policies for workflow.
    :vartype open_authentication_policies:
     ~azure.mgmt.web.v2023_01_01.models.OpenAuthenticationAccessPolicies
    """

    _attribute_map = {
        "allowed_caller_ip_addresses": {"key": "allowedCallerIpAddresses", "type": "[IpAddressRange]"},
        "open_authentication_policies": {
            "key": "openAuthenticationPolicies",
            "type": "OpenAuthenticationAccessPolicies",
        },
    }

    def __init__(
        self,
        *,
        allowed_caller_ip_addresses: Optional[List["_models.IpAddressRange"]] = None,
        open_authentication_policies: Optional["_models.OpenAuthenticationAccessPolicies"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_caller_ip_addresses: The allowed caller IP address ranges.
        :paramtype allowed_caller_ip_addresses: list[~azure.mgmt.web.v2023_01_01.models.IpAddressRange]
        :keyword open_authentication_policies: The authentication policies for workflow.
        :paramtype open_authentication_policies:
         ~azure.mgmt.web.v2023_01_01.models.OpenAuthenticationAccessPolicies
        """
        super().__init__(**kwargs)
        self.allowed_caller_ip_addresses = allowed_caller_ip_addresses
        self.open_authentication_policies = open_authentication_policies


class FlowEndpoints(_serialization.Model):
    """The flow endpoints configuration.

    :ivar outgoing_ip_addresses: The outgoing ip address.
    :vartype outgoing_ip_addresses: list[~azure.mgmt.web.v2023_01_01.models.IpAddress]
    :ivar access_endpoint_ip_addresses: The access endpoint ip address.
    :vartype access_endpoint_ip_addresses: list[~azure.mgmt.web.v2023_01_01.models.IpAddress]
    """

    _attribute_map = {
        "outgoing_ip_addresses": {"key": "outgoingIpAddresses", "type": "[IpAddress]"},
        "access_endpoint_ip_addresses": {"key": "accessEndpointIpAddresses", "type": "[IpAddress]"},
    }

    def __init__(
        self,
        *,
        outgoing_ip_addresses: Optional[List["_models.IpAddress"]] = None,
        access_endpoint_ip_addresses: Optional[List["_models.IpAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword outgoing_ip_addresses: The outgoing ip address.
        :paramtype outgoing_ip_addresses: list[~azure.mgmt.web.v2023_01_01.models.IpAddress]
        :keyword access_endpoint_ip_addresses: The access endpoint ip address.
        :paramtype access_endpoint_ip_addresses: list[~azure.mgmt.web.v2023_01_01.models.IpAddress]
        """
        super().__init__(**kwargs)
        self.outgoing_ip_addresses = outgoing_ip_addresses
        self.access_endpoint_ip_addresses = access_endpoint_ip_addresses


class FlowEndpointsConfiguration(_serialization.Model):
    """The endpoints configuration.

    :ivar workflow: The workflow endpoints.
    :vartype workflow: ~azure.mgmt.web.v2023_01_01.models.FlowEndpoints
    :ivar connector: The connector endpoints.
    :vartype connector: ~azure.mgmt.web.v2023_01_01.models.FlowEndpoints
    """

    _attribute_map = {
        "workflow": {"key": "workflow", "type": "FlowEndpoints"},
        "connector": {"key": "connector", "type": "FlowEndpoints"},
    }

    def __init__(
        self,
        *,
        workflow: Optional["_models.FlowEndpoints"] = None,
        connector: Optional["_models.FlowEndpoints"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workflow: The workflow endpoints.
        :paramtype workflow: ~azure.mgmt.web.v2023_01_01.models.FlowEndpoints
        :keyword connector: The connector endpoints.
        :paramtype connector: ~azure.mgmt.web.v2023_01_01.models.FlowEndpoints
        """
        super().__init__(**kwargs)
        self.workflow = workflow
        self.connector = connector


class ForwardProxy(_serialization.Model):
    """The configuration settings of a forward proxy used to make the requests.

    :ivar convention: The convention used to determine the url of the request made. Known values
     are: "NoProxy", "Standard", and "Custom".
    :vartype convention: str or ~azure.mgmt.web.v2023_01_01.models.ForwardProxyConvention
    :ivar custom_host_header_name: The name of the header containing the host of the request.
    :vartype custom_host_header_name: str
    :ivar custom_proto_header_name: The name of the header containing the scheme of the request.
    :vartype custom_proto_header_name: str
    """

    _attribute_map = {
        "convention": {"key": "convention", "type": "str"},
        "custom_host_header_name": {"key": "customHostHeaderName", "type": "str"},
        "custom_proto_header_name": {"key": "customProtoHeaderName", "type": "str"},
    }

    def __init__(
        self,
        *,
        convention: Optional[Union[str, "_models.ForwardProxyConvention"]] = None,
        custom_host_header_name: Optional[str] = None,
        custom_proto_header_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword convention: The convention used to determine the url of the request made. Known values
         are: "NoProxy", "Standard", and "Custom".
        :paramtype convention: str or ~azure.mgmt.web.v2023_01_01.models.ForwardProxyConvention
        :keyword custom_host_header_name: The name of the header containing the host of the request.
        :paramtype custom_host_header_name: str
        :keyword custom_proto_header_name: The name of the header containing the scheme of the request.
        :paramtype custom_proto_header_name: str
        """
        super().__init__(**kwargs)
        self.convention = convention
        self.custom_host_header_name = custom_host_header_name
        self.custom_proto_header_name = custom_proto_header_name


class FrontEndConfiguration(_serialization.Model):
    """FrontEndConfiguration.

    :ivar kind: Known values are: "NodePort" and "LoadBalancer".
    :vartype kind: str or ~azure.mgmt.web.v2023_01_01.models.FrontEndServiceType
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Optional[Union[str, "_models.FrontEndServiceType"]] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Known values are: "NodePort" and "LoadBalancer".
        :paramtype kind: str or ~azure.mgmt.web.v2023_01_01.models.FrontEndServiceType
        """
        super().__init__(**kwargs)
        self.kind = kind


class FunctionAppMajorVersion(_serialization.Model):
    """Function App stack major version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_text: Function App stack major version (display only).
    :vartype display_text: str
    :ivar value: Function App stack major version name.
    :vartype value: str
    :ivar minor_versions: Minor versions associated with the major version.
    :vartype minor_versions: list[~azure.mgmt.web.v2023_01_01.models.FunctionAppMinorVersion]
    """

    _validation = {
        "display_text": {"readonly": True},
        "value": {"readonly": True},
        "minor_versions": {"readonly": True},
    }

    _attribute_map = {
        "display_text": {"key": "displayText", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "minor_versions": {"key": "minorVersions", "type": "[FunctionAppMinorVersion]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_text = None
        self.value = None
        self.minor_versions = None


class FunctionAppMinorVersion(_serialization.Model):
    """Function App stack minor version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_text: Function App stack (display only).
    :vartype display_text: str
    :ivar value: Function App stack name.
    :vartype value: str
    :ivar stack_settings: Settings associated with the minor version.
    :vartype stack_settings: ~azure.mgmt.web.v2023_01_01.models.FunctionAppRuntimes
    """

    _validation = {
        "display_text": {"readonly": True},
        "value": {"readonly": True},
        "stack_settings": {"readonly": True},
    }

    _attribute_map = {
        "display_text": {"key": "displayText", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "stack_settings": {"key": "stackSettings", "type": "FunctionAppRuntimes"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_text = None
        self.value = None
        self.stack_settings = None


class FunctionAppRuntimes(_serialization.Model):
    """Function App stack runtimes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar linux_runtime_settings: Linux-specific settings associated with the minor version.
    :vartype linux_runtime_settings: ~azure.mgmt.web.v2023_01_01.models.FunctionAppRuntimeSettings
    :ivar windows_runtime_settings: Windows-specific settings associated with the minor version.
    :vartype windows_runtime_settings:
     ~azure.mgmt.web.v2023_01_01.models.FunctionAppRuntimeSettings
    """

    _validation = {
        "linux_runtime_settings": {"readonly": True},
        "windows_runtime_settings": {"readonly": True},
    }

    _attribute_map = {
        "linux_runtime_settings": {"key": "linuxRuntimeSettings", "type": "FunctionAppRuntimeSettings"},
        "windows_runtime_settings": {"key": "windowsRuntimeSettings", "type": "FunctionAppRuntimeSettings"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.linux_runtime_settings = None
        self.windows_runtime_settings = None


class FunctionAppRuntimeSettings(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Function App runtime settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar runtime_version: Function App stack minor version (runtime only).
    :vartype runtime_version: str
    :ivar remote_debugging_supported: :code:`<code>true</code>` if remote debugging is supported
     for the stack; otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_supported: bool
    :ivar app_insights_settings: Application Insights settings associated with the minor version.
    :vartype app_insights_settings:
     ~azure.mgmt.web.v2023_01_01.models.AppInsightsWebAppStackSettings
    :ivar git_hub_action_settings: GitHub Actions settings associated with the minor version.
    :vartype git_hub_action_settings:
     ~azure.mgmt.web.v2023_01_01.models.GitHubActionWebAppStackSettings
    :ivar app_settings_dictionary: Application settings associated with the minor version.
    :vartype app_settings_dictionary: dict[str, str]
    :ivar site_config_properties_dictionary: Configuration settings associated with the minor
     version.
    :vartype site_config_properties_dictionary:
     ~azure.mgmt.web.v2023_01_01.models.SiteConfigPropertiesDictionary
    :ivar supported_functions_extension_versions: List of supported Functions extension versions.
    :vartype supported_functions_extension_versions: list[str]
    :ivar is_preview: :code:`<code>true</code>` if the stack is in preview; otherwise,
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if the stack should be hidden; otherwise,
     :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar end_of_life_date: End-of-life date for the minor version.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar is_auto_update: :code:`<code>true</code>` if the stack version is auto-updated;
     otherwise, :code:`<code>false</code>`.
    :vartype is_auto_update: bool
    :ivar is_early_access: :code:`<code>true</code>` if the minor version is early-access;
     otherwise, :code:`<code>false</code>`.
    :vartype is_early_access: bool
    :ivar is_default: :code:`<code>true</code>` if the minor version the default; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    """

    _validation = {
        "runtime_version": {"readonly": True},
        "remote_debugging_supported": {"readonly": True},
        "app_insights_settings": {"readonly": True},
        "git_hub_action_settings": {"readonly": True},
        "app_settings_dictionary": {"readonly": True},
        "site_config_properties_dictionary": {"readonly": True},
        "supported_functions_extension_versions": {"readonly": True},
        "is_preview": {"readonly": True},
        "is_deprecated": {"readonly": True},
        "is_hidden": {"readonly": True},
        "end_of_life_date": {"readonly": True},
        "is_auto_update": {"readonly": True},
        "is_early_access": {"readonly": True},
        "is_default": {"readonly": True},
    }

    _attribute_map = {
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "remote_debugging_supported": {"key": "remoteDebuggingSupported", "type": "bool"},
        "app_insights_settings": {"key": "appInsightsSettings", "type": "AppInsightsWebAppStackSettings"},
        "git_hub_action_settings": {"key": "gitHubActionSettings", "type": "GitHubActionWebAppStackSettings"},
        "app_settings_dictionary": {"key": "appSettingsDictionary", "type": "{str}"},
        "site_config_properties_dictionary": {
            "key": "siteConfigPropertiesDictionary",
            "type": "SiteConfigPropertiesDictionary",
        },
        "supported_functions_extension_versions": {"key": "supportedFunctionsExtensionVersions", "type": "[str]"},
        "is_preview": {"key": "isPreview", "type": "bool"},
        "is_deprecated": {"key": "isDeprecated", "type": "bool"},
        "is_hidden": {"key": "isHidden", "type": "bool"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "is_auto_update": {"key": "isAutoUpdate", "type": "bool"},
        "is_early_access": {"key": "isEarlyAccess", "type": "bool"},
        "is_default": {"key": "isDefault", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.runtime_version = None
        self.remote_debugging_supported = None
        self.app_insights_settings = None
        self.git_hub_action_settings = None
        self.app_settings_dictionary = None
        self.site_config_properties_dictionary = None
        self.supported_functions_extension_versions = None
        self.is_preview = None
        self.is_deprecated = None
        self.is_hidden = None
        self.end_of_life_date = None
        self.is_auto_update = None
        self.is_early_access = None
        self.is_default = None


class FunctionAppStack(ProxyOnlyResource):
    """Function App Stack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Function App stack location.
    :vartype location: str
    :ivar display_text: Function App stack (display only).
    :vartype display_text: str
    :ivar value: Function App stack name.
    :vartype value: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2023_01_01.models.FunctionAppMajorVersion]
    :ivar preferred_os: Function App stack preferred OS. Known values are: "Windows" and "Linux".
    :vartype preferred_os: str or ~azure.mgmt.web.v2023_01_01.models.StackPreferredOs
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "display_text": {"readonly": True},
        "value": {"readonly": True},
        "major_versions": {"readonly": True},
        "preferred_os": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "display_text": {"key": "properties.displayText", "type": "str"},
        "value": {"key": "properties.value", "type": "str"},
        "major_versions": {"key": "properties.majorVersions", "type": "[FunctionAppMajorVersion]"},
        "preferred_os": {"key": "properties.preferredOs", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.location = None
        self.display_text = None
        self.value = None
        self.major_versions = None
        self.preferred_os = None


class FunctionAppStackCollection(_serialization.Model):
    """Collection of Function app Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.FunctionAppStack]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FunctionAppStack]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.FunctionAppStack"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.FunctionAppStack]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class FunctionEnvelope(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Function information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar function_app_id: Function App ID.
    :vartype function_app_id: str
    :ivar script_root_path_href: Script root path URI.
    :vartype script_root_path_href: str
    :ivar script_href: Script URI.
    :vartype script_href: str
    :ivar config_href: Config URI.
    :vartype config_href: str
    :ivar test_data_href: Test data URI.
    :vartype test_data_href: str
    :ivar secrets_file_href: Secrets file URI.
    :vartype secrets_file_href: str
    :ivar href: Function URI.
    :vartype href: str
    :ivar config: Config information.
    :vartype config: JSON
    :ivar files: File list.
    :vartype files: dict[str, str]
    :ivar test_data: Test data used when testing via the Azure Portal.
    :vartype test_data: str
    :ivar invoke_url_template: The invocation URL.
    :vartype invoke_url_template: str
    :ivar language: The function language.
    :vartype language: str
    :ivar is_disabled: Gets or sets a value indicating whether the function is disabled.
    :vartype is_disabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "function_app_id": {"key": "properties.function_app_id", "type": "str"},
        "script_root_path_href": {"key": "properties.script_root_path_href", "type": "str"},
        "script_href": {"key": "properties.script_href", "type": "str"},
        "config_href": {"key": "properties.config_href", "type": "str"},
        "test_data_href": {"key": "properties.test_data_href", "type": "str"},
        "secrets_file_href": {"key": "properties.secrets_file_href", "type": "str"},
        "href": {"key": "properties.href", "type": "str"},
        "config": {"key": "properties.config", "type": "object"},
        "files": {"key": "properties.files", "type": "{str}"},
        "test_data": {"key": "properties.test_data", "type": "str"},
        "invoke_url_template": {"key": "properties.invoke_url_template", "type": "str"},
        "language": {"key": "properties.language", "type": "str"},
        "is_disabled": {"key": "properties.isDisabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        function_app_id: Optional[str] = None,
        script_root_path_href: Optional[str] = None,
        script_href: Optional[str] = None,
        config_href: Optional[str] = None,
        test_data_href: Optional[str] = None,
        secrets_file_href: Optional[str] = None,
        href: Optional[str] = None,
        config: Optional[JSON] = None,
        files: Optional[Dict[str, str]] = None,
        test_data: Optional[str] = None,
        invoke_url_template: Optional[str] = None,
        language: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword function_app_id: Function App ID.
        :paramtype function_app_id: str
        :keyword script_root_path_href: Script root path URI.
        :paramtype script_root_path_href: str
        :keyword script_href: Script URI.
        :paramtype script_href: str
        :keyword config_href: Config URI.
        :paramtype config_href: str
        :keyword test_data_href: Test data URI.
        :paramtype test_data_href: str
        :keyword secrets_file_href: Secrets file URI.
        :paramtype secrets_file_href: str
        :keyword href: Function URI.
        :paramtype href: str
        :keyword config: Config information.
        :paramtype config: JSON
        :keyword files: File list.
        :paramtype files: dict[str, str]
        :keyword test_data: Test data used when testing via the Azure Portal.
        :paramtype test_data: str
        :keyword invoke_url_template: The invocation URL.
        :paramtype invoke_url_template: str
        :keyword language: The function language.
        :paramtype language: str
        :keyword is_disabled: Gets or sets a value indicating whether the function is disabled.
        :paramtype is_disabled: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.function_app_id = function_app_id
        self.script_root_path_href = script_root_path_href
        self.script_href = script_href
        self.config_href = config_href
        self.test_data_href = test_data_href
        self.secrets_file_href = secrets_file_href
        self.href = href
        self.config = config
        self.files = files
        self.test_data = test_data
        self.invoke_url_template = invoke_url_template
        self.language = language
        self.is_disabled = is_disabled


class FunctionEnvelopeCollection(_serialization.Model):
    """Collection of Kudu function information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.FunctionEnvelope]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FunctionEnvelope]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.FunctionEnvelope"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.FunctionEnvelope]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class FunctionSecrets(_serialization.Model):
    """Function secrets.

    :ivar key: Secret key.
    :vartype key: str
    :ivar trigger_url: Trigger URL.
    :vartype trigger_url: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "trigger_url": {"key": "trigger_url", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, trigger_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Secret key.
        :paramtype key: str
        :keyword trigger_url: Trigger URL.
        :paramtype trigger_url: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.trigger_url = trigger_url


class GeoRegion(ProxyOnlyResource):
    """Geographical region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Region description.
    :vartype description: str
    :ivar display_name: Display name for region.
    :vartype display_name: str
    :ivar org_domain: Display name for region.
    :vartype org_domain: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
        "display_name": {"readonly": True},
        "org_domain": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "org_domain": {"key": "properties.orgDomain", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.description = None
        self.display_name = None
        self.org_domain = None


class GeoRegionCollection(_serialization.Model):
    """Collection of geographical regions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.GeoRegion]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GeoRegion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.GeoRegion"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.GeoRegion]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class GitHub(_serialization.Model):
    """The configuration settings of the GitHub provider.

    :ivar enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the GitHub provider.
    :vartype registration: ~azure.mgmt.web.v2023_01_01.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "ClientRegistration"},
        "login": {"key": "login", "type": "LoginScopes"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.ClientRegistration"] = None,
        login: Optional["_models.LoginScopes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the GitHub
         provider.
        :paramtype registration: ~azure.mgmt.web.v2023_01_01.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class GitHubActionCodeConfiguration(_serialization.Model):
    """The GitHub action code configuration.

    :ivar runtime_stack: Runtime stack is used to determine the workflow file content for code base
     apps.
    :vartype runtime_stack: str
    :ivar runtime_version: Runtime version is used to determine what build version to set in the
     workflow file.
    :vartype runtime_version: str
    """

    _attribute_map = {
        "runtime_stack": {"key": "runtimeStack", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
    }

    def __init__(
        self, *, runtime_stack: Optional[str] = None, runtime_version: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword runtime_stack: Runtime stack is used to determine the workflow file content for code
         base apps.
        :paramtype runtime_stack: str
        :keyword runtime_version: Runtime version is used to determine what build version to set in the
         workflow file.
        :paramtype runtime_version: str
        """
        super().__init__(**kwargs)
        self.runtime_stack = runtime_stack
        self.runtime_version = runtime_version


class GitHubActionConfiguration(_serialization.Model):
    """The GitHub action configuration.

    :ivar code_configuration: GitHub Action code configuration.
    :vartype code_configuration: ~azure.mgmt.web.v2023_01_01.models.GitHubActionCodeConfiguration
    :ivar container_configuration: GitHub Action container configuration.
    :vartype container_configuration:
     ~azure.mgmt.web.v2023_01_01.models.GitHubActionContainerConfiguration
    :ivar is_linux: This will help determine the workflow configuration to select.
    :vartype is_linux: bool
    :ivar generate_workflow_file: Workflow option to determine whether the workflow file should be
     generated and written to the repository.
    :vartype generate_workflow_file: bool
    """

    _attribute_map = {
        "code_configuration": {"key": "codeConfiguration", "type": "GitHubActionCodeConfiguration"},
        "container_configuration": {"key": "containerConfiguration", "type": "GitHubActionContainerConfiguration"},
        "is_linux": {"key": "isLinux", "type": "bool"},
        "generate_workflow_file": {"key": "generateWorkflowFile", "type": "bool"},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["_models.GitHubActionCodeConfiguration"] = None,
        container_configuration: Optional["_models.GitHubActionContainerConfiguration"] = None,
        is_linux: Optional[bool] = None,
        generate_workflow_file: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code_configuration: GitHub Action code configuration.
        :paramtype code_configuration: ~azure.mgmt.web.v2023_01_01.models.GitHubActionCodeConfiguration
        :keyword container_configuration: GitHub Action container configuration.
        :paramtype container_configuration:
         ~azure.mgmt.web.v2023_01_01.models.GitHubActionContainerConfiguration
        :keyword is_linux: This will help determine the workflow configuration to select.
        :paramtype is_linux: bool
        :keyword generate_workflow_file: Workflow option to determine whether the workflow file should
         be generated and written to the repository.
        :paramtype generate_workflow_file: bool
        """
        super().__init__(**kwargs)
        self.code_configuration = code_configuration
        self.container_configuration = container_configuration
        self.is_linux = is_linux
        self.generate_workflow_file = generate_workflow_file


class GitHubActionContainerConfiguration(_serialization.Model):
    """The GitHub action container configuration.

    :ivar server_url: The server URL for the container registry where the build will be hosted.
    :vartype server_url: str
    :ivar image_name: The image name for the build.
    :vartype image_name: str
    :ivar username: The username used to upload the image to the container registry.
    :vartype username: str
    :ivar password: The password used to upload the image to the container registry.
    :vartype password: str
    """

    _attribute_map = {
        "server_url": {"key": "serverUrl", "type": "str"},
        "image_name": {"key": "imageName", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_url: Optional[str] = None,
        image_name: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_url: The server URL for the container registry where the build will be hosted.
        :paramtype server_url: str
        :keyword image_name: The image name for the build.
        :paramtype image_name: str
        :keyword username: The username used to upload the image to the container registry.
        :paramtype username: str
        :keyword password: The password used to upload the image to the container registry.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.server_url = server_url
        self.image_name = image_name
        self.username = username
        self.password = password


class GitHubActionWebAppStackSettings(_serialization.Model):
    """GitHub Actions Web App stack settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_supported: :code:`<code>true</code>` if GitHub Actions is supported for the stack;
     otherwise, :code:`<code>false</code>`.
    :vartype is_supported: bool
    :ivar supported_version: The minor version that is supported for GitHub Actions.
    :vartype supported_version: str
    """

    _validation = {
        "is_supported": {"readonly": True},
        "supported_version": {"readonly": True},
    }

    _attribute_map = {
        "is_supported": {"key": "isSupported", "type": "bool"},
        "supported_version": {"key": "supportedVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.is_supported = None
        self.supported_version = None


class GlobalCsmSkuDescription(_serialization.Model):
    """A Global SKU Description.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service Tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Min, max, and default scale values of the SKU.
    :vartype capacity: ~azure.mgmt.web.v2023_01_01.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.web.v2023_01_01.models.Capability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[Capability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service Tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Min, max, and default scale values of the SKU.
        :paramtype capacity: ~azure.mgmt.web.v2023_01_01.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.web.v2023_01_01.models.Capability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.locations = locations
        self.capabilities = capabilities


class GlobalValidation(_serialization.Model):
    """The configuration settings that determines the validation flow of users using App Service
    Authentication/Authorization.

    :ivar require_authentication: :code:`<code>true</code>` if the authentication flow is required
     any request is made; otherwise, :code:`<code>false</code>`.
    :vartype require_authentication: bool
    :ivar unauthenticated_client_action: The action to take when an unauthenticated client attempts
     to access the app. Known values are: "RedirectToLoginPage", "AllowAnonymous", "Return401", and
     "Return403".
    :vartype unauthenticated_client_action: str or
     ~azure.mgmt.web.v2023_01_01.models.UnauthenticatedClientActionV2
    :ivar redirect_to_provider: The default authentication provider to use when multiple providers
     are configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage".
    :vartype redirect_to_provider: str
    :ivar excluded_paths: The paths for which unauthenticated flow would not be redirected to the
     login page.
    :vartype excluded_paths: list[str]
    """

    _attribute_map = {
        "require_authentication": {"key": "requireAuthentication", "type": "bool"},
        "unauthenticated_client_action": {"key": "unauthenticatedClientAction", "type": "str"},
        "redirect_to_provider": {"key": "redirectToProvider", "type": "str"},
        "excluded_paths": {"key": "excludedPaths", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        require_authentication: Optional[bool] = None,
        unauthenticated_client_action: Optional[Union[str, "_models.UnauthenticatedClientActionV2"]] = None,
        redirect_to_provider: Optional[str] = None,
        excluded_paths: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword require_authentication: :code:`<code>true</code>` if the authentication flow is
         required any request is made; otherwise, :code:`<code>false</code>`.
        :paramtype require_authentication: bool
        :keyword unauthenticated_client_action: The action to take when an unauthenticated client
         attempts to access the app. Known values are: "RedirectToLoginPage", "AllowAnonymous",
         "Return401", and "Return403".
        :paramtype unauthenticated_client_action: str or
         ~azure.mgmt.web.v2023_01_01.models.UnauthenticatedClientActionV2
        :keyword redirect_to_provider: The default authentication provider to use when multiple
         providers are configured.
         This setting is only needed if multiple providers are configured and the unauthenticated
         client
         action is set to "RedirectToLoginPage".
        :paramtype redirect_to_provider: str
        :keyword excluded_paths: The paths for which unauthenticated flow would not be redirected to
         the login page.
        :paramtype excluded_paths: list[str]
        """
        super().__init__(**kwargs)
        self.require_authentication = require_authentication
        self.unauthenticated_client_action = unauthenticated_client_action
        self.redirect_to_provider = redirect_to_provider
        self.excluded_paths = excluded_paths


class Google(_serialization.Model):
    """The configuration settings of the Google provider.

    :ivar enabled: :code:`<code>false</code>` if the Google provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Google provider.
    :vartype registration: ~azure.mgmt.web.v2023_01_01.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
    :ivar validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :vartype validation: ~azure.mgmt.web.v2023_01_01.models.AllowedAudiencesValidation
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "ClientRegistration"},
        "login": {"key": "login", "type": "LoginScopes"},
        "validation": {"key": "validation", "type": "AllowedAudiencesValidation"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.ClientRegistration"] = None,
        login: Optional["_models.LoginScopes"] = None,
        validation: Optional["_models.AllowedAudiencesValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Google provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Google
         provider.
        :paramtype registration: ~azure.mgmt.web.v2023_01_01.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
        :keyword validation: The configuration settings of the Azure Active Directory token validation
         flow.
        :paramtype validation: ~azure.mgmt.web.v2023_01_01.models.AllowedAudiencesValidation
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation


class HandlerMapping(_serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain
    extension.
    For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
    extension.

    :ivar extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :vartype extension: str
    :ivar script_processor: The absolute path to the FastCGI application.
    :vartype script_processor: str
    :ivar arguments: Command-line arguments to be passed to the script processor.
    :vartype arguments: str
    """

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
        "script_processor": {"key": "scriptProcessor", "type": "str"},
        "arguments": {"key": "arguments", "type": "str"},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        script_processor: Optional[str] = None,
        arguments: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extension: Requests with this extension will be handled using the specified FastCGI
         application.
        :paramtype extension: str
        :keyword script_processor: The absolute path to the FastCGI application.
        :paramtype script_processor: str
        :keyword arguments: Command-line arguments to be passed to the script processor.
        :paramtype arguments: str
        """
        super().__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentDeploymentInfo(_serialization.Model):
    """Information needed to create resources on an App Service Environment.

    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar location: Location of the App Service Environment.
    :vartype location: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the App Service Environment.
        :paramtype name: str
        :keyword location: Location of the App Service Environment.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location


class HostingEnvironmentDiagnostics(_serialization.Model):
    """Diagnostics for an App Service Environment.

    :ivar name: Name/identifier of the diagnostics.
    :vartype name: str
    :ivar diagnostics_output: Diagnostics output.
    :vartype diagnostics_output: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "diagnostics_output": {"key": "diagnosticsOutput", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, diagnostics_output: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name/identifier of the diagnostics.
        :paramtype name: str
        :keyword diagnostics_output: Diagnostics output.
        :paramtype diagnostics_output: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.diagnostics_output = diagnostics_output


class HostingEnvironmentProfile(_serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the App Service Environment.
    :vartype id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the App Service Environment.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class HostKeys(_serialization.Model):
    """Functions host level keys.

    :ivar master_key: Secret key.
    :vartype master_key: str
    :ivar function_keys: Host level function keys.
    :vartype function_keys: dict[str, str]
    :ivar system_keys: System keys.
    :vartype system_keys: dict[str, str]
    """

    _attribute_map = {
        "master_key": {"key": "masterKey", "type": "str"},
        "function_keys": {"key": "functionKeys", "type": "{str}"},
        "system_keys": {"key": "systemKeys", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        master_key: Optional[str] = None,
        function_keys: Optional[Dict[str, str]] = None,
        system_keys: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword master_key: Secret key.
        :paramtype master_key: str
        :keyword function_keys: Host level function keys.
        :paramtype function_keys: dict[str, str]
        :keyword system_keys: System keys.
        :paramtype system_keys: dict[str, str]
        """
        super().__init__(**kwargs)
        self.master_key = master_key
        self.function_keys = function_keys
        self.system_keys = system_keys


class HostName(_serialization.Model):
    """Details of a hostname derived from a domain.

    :ivar name: Name of the hostname.
    :vartype name: str
    :ivar site_names: List of apps the hostname is assigned to. This list will have more than one
     app only if the hostname is pointing to a Traffic Manager.
    :vartype site_names: list[str]
    :ivar azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
     assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
     app name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Type of the Azure resource the hostname is assigned to. Known values
     are: "Website" and "TrafficManager".
    :vartype azure_resource_type: str or ~azure.mgmt.web.v2023_01_01.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Type of the DNS record. Known values are: "CName" and
     "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2023_01_01.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Type of the hostname. Known values are: "Verified" and "Managed".
    :vartype host_name_type: str or ~azure.mgmt.web.v2023_01_01.models.HostNameType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "site_names": {"key": "siteNames", "type": "[str]"},
        "azure_resource_name": {"key": "azureResourceName", "type": "str"},
        "azure_resource_type": {"key": "azureResourceType", "type": "str"},
        "custom_host_name_dns_record_type": {"key": "customHostNameDnsRecordType", "type": "str"},
        "host_name_type": {"key": "hostNameType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        site_names: Optional[List[str]] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "_models.AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "_models.CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "_models.HostNameType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the hostname.
        :paramtype name: str
        :keyword site_names: List of apps the hostname is assigned to. This list will have more than
         one app only if the hostname is pointing to a Traffic Manager.
        :paramtype site_names: list[str]
        :keyword azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
         assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
         app name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Type of the Azure resource the hostname is assigned to. Known
         values are: "Website" and "TrafficManager".
        :paramtype azure_resource_type: str or ~azure.mgmt.web.v2023_01_01.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Type of the DNS record. Known values are: "CName"
         and "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.web.v2023_01_01.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Type of the hostname. Known values are: "Verified" and "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.web.v2023_01_01.models.HostNameType
        """
        super().__init__(**kwargs)
        self.name = name
        self.site_names = site_names
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type


class HostNameBinding(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """A hostname binding object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar site_name: App Service app name.
    :vartype site_name: str
    :ivar domain_id: Fully qualified ARM domain resource URI.
    :vartype domain_id: str
    :ivar azure_resource_name: Azure resource name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Azure resource type. Known values are: "Website" and
     "TrafficManager".
    :vartype azure_resource_type: str or ~azure.mgmt.web.v2023_01_01.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Custom DNS record type. Known values are: "CName" and
     "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2023_01_01.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Hostname type. Known values are: "Verified" and "Managed".
    :vartype host_name_type: str or ~azure.mgmt.web.v2023_01_01.models.HostNameType
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2023_01_01.models.SslState
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_ip": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "domain_id": {"key": "properties.domainId", "type": "str"},
        "azure_resource_name": {"key": "properties.azureResourceName", "type": "str"},
        "azure_resource_type": {"key": "properties.azureResourceType", "type": "str"},
        "custom_host_name_dns_record_type": {"key": "properties.customHostNameDnsRecordType", "type": "str"},
        "host_name_type": {"key": "properties.hostNameType", "type": "str"},
        "ssl_state": {"key": "properties.sslState", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "virtual_ip": {"key": "properties.virtualIP", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        site_name: Optional[str] = None,
        domain_id: Optional[str] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "_models.AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "_models.CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "_models.HostNameType"]] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        thumbprint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword site_name: App Service app name.
        :paramtype site_name: str
        :keyword domain_id: Fully qualified ARM domain resource URI.
        :paramtype domain_id: str
        :keyword azure_resource_name: Azure resource name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Azure resource type. Known values are: "Website" and
         "TrafficManager".
        :paramtype azure_resource_type: str or ~azure.mgmt.web.v2023_01_01.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Custom DNS record type. Known values are: "CName"
         and "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.web.v2023_01_01.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Hostname type. Known values are: "Verified" and "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.web.v2023_01_01.models.HostNameType
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2023_01_01.models.SslState
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        """
        super().__init__(kind=kind, **kwargs)
        self.site_name = site_name
        self.domain_id = domain_id
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type
        self.ssl_state = ssl_state
        self.thumbprint = thumbprint
        self.virtual_ip = None


class HostNameBindingCollection(_serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.HostNameBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HostNameBinding]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.HostNameBinding"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.HostNameBinding]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class HostNameSslState(_serialization.Model):
    """SSL-enabled hostname.

    :ivar name: Hostname.
    :vartype name: str
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2023_01_01.models.SslState
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :vartype to_update: bool
    :ivar host_type: Indicates whether the hostname is a standard or repository hostname. Known
     values are: "Standard" and "Repository".
    :vartype host_type: str or ~azure.mgmt.web.v2023_01_01.models.HostType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ssl_state": {"key": "sslState", "type": "str"},
        "virtual_ip": {"key": "virtualIP", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "to_update": {"key": "toUpdate", "type": "bool"},
        "host_type": {"key": "hostType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        virtual_ip: Optional[str] = None,
        thumbprint: Optional[str] = None,
        to_update: Optional[bool] = None,
        host_type: Optional[Union[str, "_models.HostType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Hostname.
        :paramtype name: str
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2023_01_01.models.SslState
        :keyword virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        :paramtype virtual_ip: str
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        :keyword to_update: Set to :code:`<code>true</code>` to update existing hostname.
        :paramtype to_update: bool
        :keyword host_type: Indicates whether the hostname is a standard or repository hostname. Known
         values are: "Standard" and "Repository".
        :paramtype host_type: str or ~azure.mgmt.web.v2023_01_01.models.HostType
        """
        super().__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HttpLogsConfig(_serialization.Model):
    """Http logs configuration.

    :ivar file_system: Http logs to file system configuration.
    :vartype file_system: ~azure.mgmt.web.v2023_01_01.models.FileSystemHttpLogsConfig
    :ivar azure_blob_storage: Http logs to azure blob storage configuration.
    :vartype azure_blob_storage: ~azure.mgmt.web.v2023_01_01.models.AzureBlobStorageHttpLogsConfig
    """

    _attribute_map = {
        "file_system": {"key": "fileSystem", "type": "FileSystemHttpLogsConfig"},
        "azure_blob_storage": {"key": "azureBlobStorage", "type": "AzureBlobStorageHttpLogsConfig"},
    }

    def __init__(
        self,
        *,
        file_system: Optional["_models.FileSystemHttpLogsConfig"] = None,
        azure_blob_storage: Optional["_models.AzureBlobStorageHttpLogsConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_system: Http logs to file system configuration.
        :paramtype file_system: ~azure.mgmt.web.v2023_01_01.models.FileSystemHttpLogsConfig
        :keyword azure_blob_storage: Http logs to azure blob storage configuration.
        :paramtype azure_blob_storage:
         ~azure.mgmt.web.v2023_01_01.models.AzureBlobStorageHttpLogsConfig
        """
        super().__init__(**kwargs)
        self.file_system = file_system
        self.azure_blob_storage = azure_blob_storage


class HttpScaleRule(_serialization.Model):
    """Container App container Custom scaling rule.

    :ivar metadata: Metadata properties to describe http scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~azure.mgmt.web.v2023_01_01.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Metadata properties to describe http scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~azure.mgmt.web.v2023_01_01.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.metadata = metadata
        self.auth = auth


class HttpSettings(_serialization.Model):
    """The configuration settings of the HTTP requests for authentication and authorization requests
    made against App Service Authentication/Authorization.

    :ivar require_https: :code:`<code>false</code>` if the authentication/authorization responses
     not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
    :vartype require_https: bool
    :ivar routes: The configuration settings of the paths HTTP requests.
    :vartype routes: ~azure.mgmt.web.v2023_01_01.models.HttpSettingsRoutes
    :ivar forward_proxy: The configuration settings of a forward proxy used to make the requests.
    :vartype forward_proxy: ~azure.mgmt.web.v2023_01_01.models.ForwardProxy
    """

    _attribute_map = {
        "require_https": {"key": "requireHttps", "type": "bool"},
        "routes": {"key": "routes", "type": "HttpSettingsRoutes"},
        "forward_proxy": {"key": "forwardProxy", "type": "ForwardProxy"},
    }

    def __init__(
        self,
        *,
        require_https: Optional[bool] = None,
        routes: Optional["_models.HttpSettingsRoutes"] = None,
        forward_proxy: Optional["_models.ForwardProxy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword require_https: :code:`<code>false</code>` if the authentication/authorization
         responses not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
        :paramtype require_https: bool
        :keyword routes: The configuration settings of the paths HTTP requests.
        :paramtype routes: ~azure.mgmt.web.v2023_01_01.models.HttpSettingsRoutes
        :keyword forward_proxy: The configuration settings of a forward proxy used to make the
         requests.
        :paramtype forward_proxy: ~azure.mgmt.web.v2023_01_01.models.ForwardProxy
        """
        super().__init__(**kwargs)
        self.require_https = require_https
        self.routes = routes
        self.forward_proxy = forward_proxy


class HttpSettingsRoutes(_serialization.Model):
    """The configuration settings of the paths HTTP requests.

    :ivar api_prefix: The prefix that should precede all the authentication/authorization paths.
    :vartype api_prefix: str
    """

    _attribute_map = {
        "api_prefix": {"key": "apiPrefix", "type": "str"},
    }

    def __init__(self, *, api_prefix: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword api_prefix: The prefix that should precede all the authentication/authorization paths.
        :paramtype api_prefix: str
        """
        super().__init__(**kwargs)
        self.api_prefix = api_prefix


class HybridConnection(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_bus_namespace: The name of the Service Bus namespace.
    :vartype service_bus_namespace: str
    :ivar relay_name: The name of the Service Bus relay.
    :vartype relay_name: str
    :ivar relay_arm_uri: The ARM URI to the Service Bus relay.
    :vartype relay_arm_uri: str
    :ivar hostname: The hostname of the endpoint.
    :vartype hostname: str
    :ivar port: The port of the endpoint.
    :vartype port: int
    :ivar send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the Service Bus key. This is used to authenticate to Service
     Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :vartype send_key_value: str
    :ivar service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :vartype service_bus_suffix: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "relay_name": {"key": "properties.relayName", "type": "str"},
        "relay_arm_uri": {"key": "properties.relayArmUri", "type": "str"},
        "hostname": {"key": "properties.hostname", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
        "service_bus_suffix": {"key": "properties.serviceBusSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_bus_namespace: Optional[str] = None,
        relay_name: Optional[str] = None,
        relay_arm_uri: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        send_key_name: Optional[str] = None,
        send_key_value: Optional[str] = None,
        service_bus_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_bus_namespace: The name of the Service Bus namespace.
        :paramtype service_bus_namespace: str
        :keyword relay_name: The name of the Service Bus relay.
        :paramtype relay_name: str
        :keyword relay_arm_uri: The ARM URI to the Service Bus relay.
        :paramtype relay_arm_uri: str
        :keyword hostname: The hostname of the endpoint.
        :paramtype hostname: str
        :keyword port: The port of the endpoint.
        :paramtype port: int
        :keyword send_key_name: The name of the Service Bus key which has Send permissions. This is
         used to authenticate to Service Bus.
        :paramtype send_key_name: str
        :keyword send_key_value: The value of the Service Bus key. This is used to authenticate to
         Service Bus. In ARM this key will not be returned
         normally, use the POST /listKeys API instead.
        :paramtype send_key_value: str
        :keyword service_bus_suffix: The suffix for the service bus endpoint. By default this is
         .servicebus.windows.net.
        :paramtype service_bus_suffix: str
        """
        super().__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class HybridConnectionCollection(_serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.HybridConnection]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HybridConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.HybridConnection"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.HybridConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "send_key_name": {"readonly": True},
        "send_key_value": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.send_key_name = None
        self.send_key_value = None


class HybridConnectionLimits(ProxyOnlyResource):
    """Hybrid Connection limits contract. This is used to return the plan limits of Hybrid
    Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar current: The current number of Hybrid Connections.
    :vartype current: int
    :ivar maximum: The maximum number of Hybrid Connections allowed.
    :vartype maximum: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "current": {"readonly": True},
        "maximum": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "current": {"key": "properties.current", "type": "int"},
        "maximum": {"key": "properties.maximum", "type": "int"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.current = None
        self.maximum = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar value: String representation of the identity.
    :vartype value: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "properties.id", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword value: String representation of the identity.
        :paramtype value: str
        """
        super().__init__(kind=kind, **kwargs)
        self.value = value


class IdentifierCollection(_serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Identifier]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Identifier"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.Identifier]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IdentityProviders(_serialization.Model):
    """The configuration settings of each of the identity providers used to configure App Service
    Authentication/Authorization.

    :ivar azure_active_directory: The configuration settings of the Azure Active directory
     provider.
    :vartype azure_active_directory: ~azure.mgmt.web.v2023_01_01.models.AzureActiveDirectory
    :ivar facebook: The configuration settings of the Facebook provider.
    :vartype facebook: ~azure.mgmt.web.v2023_01_01.models.Facebook
    :ivar git_hub: The configuration settings of the GitHub provider.
    :vartype git_hub: ~azure.mgmt.web.v2023_01_01.models.GitHub
    :ivar google: The configuration settings of the Google provider.
    :vartype google: ~azure.mgmt.web.v2023_01_01.models.Google
    :ivar legacy_microsoft_account: The configuration settings of the legacy Microsoft Account
     provider.
    :vartype legacy_microsoft_account: ~azure.mgmt.web.v2023_01_01.models.LegacyMicrosoftAccount
    :ivar twitter: The configuration settings of the Twitter provider.
    :vartype twitter: ~azure.mgmt.web.v2023_01_01.models.Twitter
    :ivar apple: The configuration settings of the Apple provider.
    :vartype apple: ~azure.mgmt.web.v2023_01_01.models.Apple
    :ivar azure_static_web_apps: The configuration settings of the Azure Static Web Apps provider.
    :vartype azure_static_web_apps: ~azure.mgmt.web.v2023_01_01.models.AzureStaticWebApps
    :ivar custom_open_id_connect_providers: The map of the name of the alias of each custom Open ID
     Connect provider to the
     configuration settings of the custom Open ID Connect provider.
    :vartype custom_open_id_connect_providers: dict[str,
     ~azure.mgmt.web.v2023_01_01.models.CustomOpenIdConnectProvider]
    """

    _attribute_map = {
        "azure_active_directory": {"key": "azureActiveDirectory", "type": "AzureActiveDirectory"},
        "facebook": {"key": "facebook", "type": "Facebook"},
        "git_hub": {"key": "gitHub", "type": "GitHub"},
        "google": {"key": "google", "type": "Google"},
        "legacy_microsoft_account": {"key": "legacyMicrosoftAccount", "type": "LegacyMicrosoftAccount"},
        "twitter": {"key": "twitter", "type": "Twitter"},
        "apple": {"key": "apple", "type": "Apple"},
        "azure_static_web_apps": {"key": "azureStaticWebApps", "type": "AzureStaticWebApps"},
        "custom_open_id_connect_providers": {
            "key": "customOpenIdConnectProviders",
            "type": "{CustomOpenIdConnectProvider}",
        },
    }

    def __init__(
        self,
        *,
        azure_active_directory: Optional["_models.AzureActiveDirectory"] = None,
        facebook: Optional["_models.Facebook"] = None,
        git_hub: Optional["_models.GitHub"] = None,
        google: Optional["_models.Google"] = None,
        legacy_microsoft_account: Optional["_models.LegacyMicrosoftAccount"] = None,
        twitter: Optional["_models.Twitter"] = None,
        apple: Optional["_models.Apple"] = None,
        azure_static_web_apps: Optional["_models.AzureStaticWebApps"] = None,
        custom_open_id_connect_providers: Optional[Dict[str, "_models.CustomOpenIdConnectProvider"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_active_directory: The configuration settings of the Azure Active directory
         provider.
        :paramtype azure_active_directory: ~azure.mgmt.web.v2023_01_01.models.AzureActiveDirectory
        :keyword facebook: The configuration settings of the Facebook provider.
        :paramtype facebook: ~azure.mgmt.web.v2023_01_01.models.Facebook
        :keyword git_hub: The configuration settings of the GitHub provider.
        :paramtype git_hub: ~azure.mgmt.web.v2023_01_01.models.GitHub
        :keyword google: The configuration settings of the Google provider.
        :paramtype google: ~azure.mgmt.web.v2023_01_01.models.Google
        :keyword legacy_microsoft_account: The configuration settings of the legacy Microsoft Account
         provider.
        :paramtype legacy_microsoft_account: ~azure.mgmt.web.v2023_01_01.models.LegacyMicrosoftAccount
        :keyword twitter: The configuration settings of the Twitter provider.
        :paramtype twitter: ~azure.mgmt.web.v2023_01_01.models.Twitter
        :keyword apple: The configuration settings of the Apple provider.
        :paramtype apple: ~azure.mgmt.web.v2023_01_01.models.Apple
        :keyword azure_static_web_apps: The configuration settings of the Azure Static Web Apps
         provider.
        :paramtype azure_static_web_apps: ~azure.mgmt.web.v2023_01_01.models.AzureStaticWebApps
        :keyword custom_open_id_connect_providers: The map of the name of the alias of each custom Open
         ID Connect provider to the
         configuration settings of the custom Open ID Connect provider.
        :paramtype custom_open_id_connect_providers: dict[str,
         ~azure.mgmt.web.v2023_01_01.models.CustomOpenIdConnectProvider]
        """
        super().__init__(**kwargs)
        self.azure_active_directory = azure_active_directory
        self.facebook = facebook
        self.git_hub = git_hub
        self.google = google
        self.legacy_microsoft_account = legacy_microsoft_account
        self.twitter = twitter
        self.apple = apple
        self.azure_static_web_apps = azure_static_web_apps
        self.custom_open_id_connect_providers = custom_open_id_connect_providers


class InboundEnvironmentEndpoint(_serialization.Model):
    """The IP Addresses and Ports that require inbound network access to and within the subnet of the
    App Service Environment.

    :ivar description: Short text describing the purpose of the network traffic.
    :vartype description: str
    :ivar endpoints: The IP addresses that network traffic will originate from in cidr notation.
    :vartype endpoints: list[str]
    :ivar ports: The ports that network traffic will arrive to the App Service Environment at.
    :vartype ports: list[str]
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[str]"},
        "ports": {"key": "ports", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        endpoints: Optional[List[str]] = None,
        ports: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Short text describing the purpose of the network traffic.
        :paramtype description: str
        :keyword endpoints: The IP addresses that network traffic will originate from in cidr notation.
        :paramtype endpoints: list[str]
        :keyword ports: The ports that network traffic will arrive to the App Service Environment at.
        :paramtype ports: list[str]
        """
        super().__init__(**kwargs)
        self.description = description
        self.endpoints = endpoints
        self.ports = ports


class InboundEnvironmentEndpointCollection(_serialization.Model):
    """Collection of Inbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.InboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.InboundEnvironmentEndpoint"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.InboundEnvironmentEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Ingress(_serialization.Model):
    """Container App Ingress configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar fqdn: Hostname.
    :vartype fqdn: str
    :ivar external: Bool indicating if app exposes an external http endpoint.
    :vartype external: bool
    :ivar target_port: Target Port in containers for traffic from ingress.
    :vartype target_port: int
    :ivar transport: Ingress transport protocol. Known values are: "auto", "http", and "http2".
    :vartype transport: str or ~azure.mgmt.web.v2023_01_01.models.IngressTransportMethod
    :ivar traffic:
    :vartype traffic: list[~azure.mgmt.web.v2023_01_01.models.TrafficWeight]
    :ivar allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false HTTP
     connections are automatically redirected to HTTPS connections.
    :vartype allow_insecure: bool
    """

    _validation = {
        "fqdn": {"readonly": True},
    }

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "external": {"key": "external", "type": "bool"},
        "target_port": {"key": "targetPort", "type": "int"},
        "transport": {"key": "transport", "type": "str"},
        "traffic": {"key": "traffic", "type": "[TrafficWeight]"},
        "allow_insecure": {"key": "allowInsecure", "type": "bool"},
    }

    def __init__(
        self,
        *,
        external: bool = False,
        target_port: Optional[int] = None,
        transport: Optional[Union[str, "_models.IngressTransportMethod"]] = None,
        traffic: Optional[List["_models.TrafficWeight"]] = None,
        allow_insecure: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword external: Bool indicating if app exposes an external http endpoint.
        :paramtype external: bool
        :keyword target_port: Target Port in containers for traffic from ingress.
        :paramtype target_port: int
        :keyword transport: Ingress transport protocol. Known values are: "auto", "http", and "http2".
        :paramtype transport: str or ~azure.mgmt.web.v2023_01_01.models.IngressTransportMethod
        :keyword traffic:
        :paramtype traffic: list[~azure.mgmt.web.v2023_01_01.models.TrafficWeight]
        :keyword allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false
         HTTP connections are automatically redirected to HTTPS connections.
        :paramtype allow_insecure: bool
        """
        super().__init__(**kwargs)
        self.fqdn = None
        self.external = external
        self.target_port = target_port
        self.transport = transport
        self.traffic = traffic
        self.allow_insecure = allow_insecure


class IpAddress(_serialization.Model):
    """The ip address.

    :ivar address: The address.
    :vartype address: str
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
    }

    def __init__(self, *, address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword address: The address.
        :paramtype address: str
        """
        super().__init__(**kwargs)
        self.address = address


class IpAddressRange(_serialization.Model):
    """The ip address range.

    :ivar address_range: The IP address range.
    :vartype address_range: str
    """

    _attribute_map = {
        "address_range": {"key": "addressRange", "type": "str"},
    }

    def __init__(self, *, address_range: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword address_range: The IP address range.
        :paramtype address_range: str
        """
        super().__init__(**kwargs)
        self.address_range = address_range


class IpSecurityRestriction(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """IP security restriction on an app.

    :ivar ip_address: IP address the security restriction is valid for.
     It can be in form of pure ipv4 address (required SubnetMask property) or
     CIDR notation such as ipv4/mask (leading bit match). For CIDR,
     SubnetMask property must not be specified.
    :vartype ip_address: str
    :ivar subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :vartype subnet_mask: str
    :ivar vnet_subnet_resource_id: Virtual network resource id.
    :vartype vnet_subnet_resource_id: str
    :ivar vnet_traffic_tag: (internal) Vnet traffic tag.
    :vartype vnet_traffic_tag: int
    :ivar subnet_traffic_tag: (internal) Subnet traffic tag.
    :vartype subnet_traffic_tag: int
    :ivar action: Allow or Deny access for this IP range.
    :vartype action: str
    :ivar tag: Defines what this IP filter will be used for. This is to support IP filtering on
     proxies. Known values are: "Default", "XffProxy", and "ServiceTag".
    :vartype tag: str or ~azure.mgmt.web.v2023_01_01.models.IpFilterTag
    :ivar priority: Priority of IP restriction rule.
    :vartype priority: int
    :ivar name: IP restriction rule name.
    :vartype name: str
    :ivar description: IP restriction rule description.
    :vartype description: str
    :ivar headers: IP restriction rule headers.
     X-Forwarded-Host
     (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
     The matching logic is ..


     * If the property is null or empty (default), all hosts(or lack of) are allowed.
     * A value is compared using ordinal-ignore-case (excluding port number).
     * Subdomain wildcards are permitted but don't match the root domain. For example,
     *.contoso.com matches the subdomain foo.contoso.com
       but not the root domain contoso.com or multi-level foo.bar.contoso.com
     * Unicode host names are allowed but are converted to Punycode for matching.

     X-Forwarded-For
     (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
     The matching logic is ..


     * If the property is null or empty (default), any forwarded-for chains (or lack of) are
     allowed.
     * If any address (excluding port number) in the chain (comma separated) matches the CIDR
     defined by the property.

     X-Azure-FDID and X-FD-HealthProbe.
     The matching logic is exact match.
    :vartype headers: dict[str, list[str]]
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet_mask": {"key": "subnetMask", "type": "str"},
        "vnet_subnet_resource_id": {"key": "vnetSubnetResourceId", "type": "str"},
        "vnet_traffic_tag": {"key": "vnetTrafficTag", "type": "int"},
        "subnet_traffic_tag": {"key": "subnetTrafficTag", "type": "int"},
        "action": {"key": "action", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "headers": {"key": "headers", "type": "{[str]}"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        subnet_mask: Optional[str] = None,
        vnet_subnet_resource_id: Optional[str] = None,
        vnet_traffic_tag: Optional[int] = None,
        subnet_traffic_tag: Optional[int] = None,
        action: Optional[str] = None,
        tag: Optional[Union[str, "_models.IpFilterTag"]] = None,
        priority: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        headers: Optional[Dict[str, List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_address: IP address the security restriction is valid for.
         It can be in form of pure ipv4 address (required SubnetMask property) or
         CIDR notation such as ipv4/mask (leading bit match). For CIDR,
         SubnetMask property must not be specified.
        :paramtype ip_address: str
        :keyword subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :paramtype subnet_mask: str
        :keyword vnet_subnet_resource_id: Virtual network resource id.
        :paramtype vnet_subnet_resource_id: str
        :keyword vnet_traffic_tag: (internal) Vnet traffic tag.
        :paramtype vnet_traffic_tag: int
        :keyword subnet_traffic_tag: (internal) Subnet traffic tag.
        :paramtype subnet_traffic_tag: int
        :keyword action: Allow or Deny access for this IP range.
        :paramtype action: str
        :keyword tag: Defines what this IP filter will be used for. This is to support IP filtering on
         proxies. Known values are: "Default", "XffProxy", and "ServiceTag".
        :paramtype tag: str or ~azure.mgmt.web.v2023_01_01.models.IpFilterTag
        :keyword priority: Priority of IP restriction rule.
        :paramtype priority: int
        :keyword name: IP restriction rule name.
        :paramtype name: str
        :keyword description: IP restriction rule description.
        :paramtype description: str
        :keyword headers: IP restriction rule headers.
         X-Forwarded-Host
         (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
         The matching logic is ..


         * If the property is null or empty (default), all hosts(or lack of) are allowed.
         * A value is compared using ordinal-ignore-case (excluding port number).
         * Subdomain wildcards are permitted but don't match the root domain. For example,
         *.contoso.com matches the subdomain foo.contoso.com
           but not the root domain contoso.com or multi-level foo.bar.contoso.com
         * Unicode host names are allowed but are converted to Punycode for matching.

         X-Forwarded-For
         (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
         The matching logic is ..


         * If the property is null or empty (default), any forwarded-for chains (or lack of) are
         allowed.
         * If any address (excluding port number) in the chain (comma separated) matches the CIDR
         defined by the property.

         X-Azure-FDID and X-FD-HealthProbe.
         The matching logic is exact match.
        :paramtype headers: dict[str, list[str]]
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask
        self.vnet_subnet_resource_id = vnet_subnet_resource_id
        self.vnet_traffic_tag = vnet_traffic_tag
        self.subnet_traffic_tag = subnet_traffic_tag
        self.action = action
        self.tag = tag
        self.priority = priority
        self.name = name
        self.description = description
        self.headers = headers


class JsonSchema(_serialization.Model):
    """The JSON schema.

    :ivar title: The JSON title.
    :vartype title: str
    :ivar content: The JSON content.
    :vartype content: str
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "content": {"key": "content", "type": "str"},
    }

    def __init__(self, *, title: Optional[str] = None, content: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword title: The JSON title.
        :paramtype title: str
        :keyword content: The JSON content.
        :paramtype content: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.content = content


class JwtClaimChecks(_serialization.Model):
    """The configuration settings of the checks that should be made while validating the JWT Claims.

    :ivar allowed_groups: The list of the allowed groups.
    :vartype allowed_groups: list[str]
    :ivar allowed_client_applications: The list of the allowed client applications.
    :vartype allowed_client_applications: list[str]
    """

    _attribute_map = {
        "allowed_groups": {"key": "allowedGroups", "type": "[str]"},
        "allowed_client_applications": {"key": "allowedClientApplications", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allowed_groups: Optional[List[str]] = None,
        allowed_client_applications: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_groups: The list of the allowed groups.
        :paramtype allowed_groups: list[str]
        :keyword allowed_client_applications: The list of the allowed client applications.
        :paramtype allowed_client_applications: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_groups = allowed_groups
        self.allowed_client_applications = allowed_client_applications


class KeyInfo(_serialization.Model):
    """Function key info.

    :ivar name: Key name.
    :vartype name: str
    :ivar value: Key value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Key name.
        :paramtype name: str
        :keyword value: Key value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class KeyValuePairStringObject(_serialization.Model):
    """KeyValuePairStringObject.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key:
    :vartype key: str
    :ivar value: Any object.
    :vartype value: JSON
    """

    _validation = {
        "key": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.key = None
        self.value = None


class KubeEnvironment(Resource):  # pylint: disable=too-many-instance-attributes
    """A Kubernetes cluster specialized for web workloads by Azure App Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: Extended Location.
    :vartype extended_location: ~azure.mgmt.web.v2023_01_01.models.ExtendedLocation
    :ivar provisioning_state: Provisioning state of the Kubernetes Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "Waiting", "InitializationInProgress",
     "InfrastructureSetupInProgress", "InfrastructureSetupComplete", "ScheduledForDelete",
     "UpgradeRequested", and "UpgradeFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2023_01_01.models.KubeEnvironmentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar internal_load_balancer_enabled: Only visible within Vnet/Subnet.
    :vartype internal_load_balancer_enabled: bool
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :ivar static_ip: Static IP of the KubeEnvironment.
    :vartype static_ip: str
    :ivar environment_type: Type of Kubernetes Environment. Only supported for Container App
     Environments with value as Managed.
    :vartype environment_type: str
    :ivar arc_configuration: Cluster configuration which determines the ARC cluster
     components types. Eg: Choosing between BuildService kind,
     FrontEnd Service ArtifactsStorageType etc.
    :vartype arc_configuration: ~azure.mgmt.web.v2023_01_01.models.ArcConfiguration
    :ivar app_logs_configuration: Cluster configuration which enables the log daemon to export
     app logs to a destination. Currently only "log-analytics" is
     supported.
    :vartype app_logs_configuration: ~azure.mgmt.web.v2023_01_01.models.AppLogsConfiguration
    :ivar container_apps_configuration: Cluster configuration for Container Apps Environments to
     configure Dapr Instrumentation Key and VNET Configuration.
    :vartype container_apps_configuration:
     ~azure.mgmt.web.v2023_01_01.models.ContainerAppsConfiguration
    :ivar aks_resource_id:
    :vartype aks_resource_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_errors": {"readonly": True},
        "default_domain": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_errors": {"key": "properties.deploymentErrors", "type": "str"},
        "internal_load_balancer_enabled": {"key": "properties.internalLoadBalancerEnabled", "type": "bool"},
        "default_domain": {"key": "properties.defaultDomain", "type": "str"},
        "static_ip": {"key": "properties.staticIp", "type": "str"},
        "environment_type": {"key": "properties.environmentType", "type": "str"},
        "arc_configuration": {"key": "properties.arcConfiguration", "type": "ArcConfiguration"},
        "app_logs_configuration": {"key": "properties.appLogsConfiguration", "type": "AppLogsConfiguration"},
        "container_apps_configuration": {
            "key": "properties.containerAppsConfiguration",
            "type": "ContainerAppsConfiguration",
        },
        "aks_resource_id": {"key": "properties.aksResourceID", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        internal_load_balancer_enabled: Optional[bool] = None,
        static_ip: Optional[str] = None,
        environment_type: Optional[str] = None,
        arc_configuration: Optional["_models.ArcConfiguration"] = None,
        app_logs_configuration: Optional["_models.AppLogsConfiguration"] = None,
        container_apps_configuration: Optional["_models.ContainerAppsConfiguration"] = None,
        aks_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: Extended Location.
        :paramtype extended_location: ~azure.mgmt.web.v2023_01_01.models.ExtendedLocation
        :keyword internal_load_balancer_enabled: Only visible within Vnet/Subnet.
        :paramtype internal_load_balancer_enabled: bool
        :keyword static_ip: Static IP of the KubeEnvironment.
        :paramtype static_ip: str
        :keyword environment_type: Type of Kubernetes Environment. Only supported for Container App
         Environments with value as Managed.
        :paramtype environment_type: str
        :keyword arc_configuration: Cluster configuration which determines the ARC cluster
         components types. Eg: Choosing between BuildService kind,
         FrontEnd Service ArtifactsStorageType etc.
        :paramtype arc_configuration: ~azure.mgmt.web.v2023_01_01.models.ArcConfiguration
        :keyword app_logs_configuration: Cluster configuration which enables the log daemon to export
         app logs to a destination. Currently only "log-analytics" is
         supported.
        :paramtype app_logs_configuration: ~azure.mgmt.web.v2023_01_01.models.AppLogsConfiguration
        :keyword container_apps_configuration: Cluster configuration for Container Apps Environments to
         configure Dapr Instrumentation Key and VNET Configuration.
        :paramtype container_apps_configuration:
         ~azure.mgmt.web.v2023_01_01.models.ContainerAppsConfiguration
        :keyword aks_resource_id:
        :paramtype aks_resource_id: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.provisioning_state = None
        self.deployment_errors = None
        self.internal_load_balancer_enabled = internal_load_balancer_enabled
        self.default_domain = None
        self.static_ip = static_ip
        self.environment_type = environment_type
        self.arc_configuration = arc_configuration
        self.app_logs_configuration = app_logs_configuration
        self.container_apps_configuration = container_apps_configuration
        self.aks_resource_id = aks_resource_id


class KubeEnvironmentCollection(_serialization.Model):
    """Collection of Kubernetes Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.KubeEnvironment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[KubeEnvironment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.KubeEnvironment"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.KubeEnvironment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class KubeEnvironmentPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a KubeEnvironment when patching.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the Kubernetes Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "Waiting", "InitializationInProgress",
     "InfrastructureSetupInProgress", "InfrastructureSetupComplete", "ScheduledForDelete",
     "UpgradeRequested", and "UpgradeFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2023_01_01.models.KubeEnvironmentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar internal_load_balancer_enabled: Only visible within Vnet/Subnet.
    :vartype internal_load_balancer_enabled: bool
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :ivar static_ip: Static IP of the KubeEnvironment.
    :vartype static_ip: str
    :ivar arc_configuration: Cluster configuration which determines the ARC cluster
     components types. Eg: Choosing between BuildService kind,
     FrontEnd Service ArtifactsStorageType etc.
    :vartype arc_configuration: ~azure.mgmt.web.v2023_01_01.models.ArcConfiguration
    :ivar app_logs_configuration: Cluster configuration which enables the log daemon to export
     app logs to a destination. Currently only "log-analytics" is
     supported.
    :vartype app_logs_configuration: ~azure.mgmt.web.v2023_01_01.models.AppLogsConfiguration
    :ivar container_apps_configuration: Cluster configuration for Container Apps Environments to
     configure Dapr Instrumentation Key and VNET Configuration.
    :vartype container_apps_configuration:
     ~azure.mgmt.web.v2023_01_01.models.ContainerAppsConfiguration
    :ivar aks_resource_id:
    :vartype aks_resource_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_errors": {"readonly": True},
        "default_domain": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_errors": {"key": "properties.deploymentErrors", "type": "str"},
        "internal_load_balancer_enabled": {"key": "properties.internalLoadBalancerEnabled", "type": "bool"},
        "default_domain": {"key": "properties.defaultDomain", "type": "str"},
        "static_ip": {"key": "properties.staticIp", "type": "str"},
        "arc_configuration": {"key": "properties.arcConfiguration", "type": "ArcConfiguration"},
        "app_logs_configuration": {"key": "properties.appLogsConfiguration", "type": "AppLogsConfiguration"},
        "container_apps_configuration": {
            "key": "properties.containerAppsConfiguration",
            "type": "ContainerAppsConfiguration",
        },
        "aks_resource_id": {"key": "properties.aksResourceID", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        internal_load_balancer_enabled: Optional[bool] = None,
        static_ip: Optional[str] = None,
        arc_configuration: Optional["_models.ArcConfiguration"] = None,
        app_logs_configuration: Optional["_models.AppLogsConfiguration"] = None,
        container_apps_configuration: Optional["_models.ContainerAppsConfiguration"] = None,
        aks_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword internal_load_balancer_enabled: Only visible within Vnet/Subnet.
        :paramtype internal_load_balancer_enabled: bool
        :keyword static_ip: Static IP of the KubeEnvironment.
        :paramtype static_ip: str
        :keyword arc_configuration: Cluster configuration which determines the ARC cluster
         components types. Eg: Choosing between BuildService kind,
         FrontEnd Service ArtifactsStorageType etc.
        :paramtype arc_configuration: ~azure.mgmt.web.v2023_01_01.models.ArcConfiguration
        :keyword app_logs_configuration: Cluster configuration which enables the log daemon to export
         app logs to a destination. Currently only "log-analytics" is
         supported.
        :paramtype app_logs_configuration: ~azure.mgmt.web.v2023_01_01.models.AppLogsConfiguration
        :keyword container_apps_configuration: Cluster configuration for Container Apps Environments to
         configure Dapr Instrumentation Key and VNET Configuration.
        :paramtype container_apps_configuration:
         ~azure.mgmt.web.v2023_01_01.models.ContainerAppsConfiguration
        :keyword aks_resource_id:
        :paramtype aks_resource_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.deployment_errors = None
        self.internal_load_balancer_enabled = internal_load_balancer_enabled
        self.default_domain = None
        self.static_ip = static_ip
        self.arc_configuration = arc_configuration
        self.app_logs_configuration = app_logs_configuration
        self.container_apps_configuration = container_apps_configuration
        self.aks_resource_id = aks_resource_id


class KubeEnvironmentProfile(_serialization.Model):
    """Specification for a Kubernetes Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the Kubernetes Environment.
    :vartype id: str
    :ivar name: Name of the Kubernetes Environment.
    :vartype name: str
    :ivar type: Resource type of the Kubernetes Environment.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the Kubernetes Environment.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class LegacyMicrosoftAccount(_serialization.Model):
    """The configuration settings of the legacy Microsoft Account provider.

    :ivar enabled: :code:`<code>false</code>` if the legacy Microsoft Account provider should not
     be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the legacy Microsoft
     Account provider.
    :vartype registration: ~azure.mgmt.web.v2023_01_01.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
    :ivar validation: The configuration settings of the legacy Microsoft Account provider token
     validation flow.
    :vartype validation: ~azure.mgmt.web.v2023_01_01.models.AllowedAudiencesValidation
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "ClientRegistration"},
        "login": {"key": "login", "type": "LoginScopes"},
        "validation": {"key": "validation", "type": "AllowedAudiencesValidation"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.ClientRegistration"] = None,
        login: Optional["_models.LoginScopes"] = None,
        validation: Optional["_models.AllowedAudiencesValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the legacy Microsoft Account provider should
         not be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the legacy
         Microsoft Account provider.
        :paramtype registration: ~azure.mgmt.web.v2023_01_01.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2023_01_01.models.LoginScopes
        :keyword validation: The configuration settings of the legacy Microsoft Account provider token
         validation flow.
        :paramtype validation: ~azure.mgmt.web.v2023_01_01.models.AllowedAudiencesValidation
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation


class LinuxJavaContainerSettings(_serialization.Model):
    """Linux Java Container settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar java11_runtime: Java 11 version (runtime only).
    :vartype java11_runtime: str
    :ivar java8_runtime: Java 8 version (runtime only).
    :vartype java8_runtime: str
    :ivar is_preview: :code:`<code>true</code>` if the stack is in preview; otherwise,
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if the stack should be hidden; otherwise,
     :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar end_of_life_date: End-of-life date for the minor version.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar is_auto_update: :code:`<code>true</code>` if the stack version is auto-updated;
     otherwise, :code:`<code>false</code>`.
    :vartype is_auto_update: bool
    :ivar is_early_access: :code:`<code>true</code>` if the minor version is early-access;
     otherwise, :code:`<code>false</code>`.
    :vartype is_early_access: bool
    """

    _validation = {
        "java11_runtime": {"readonly": True},
        "java8_runtime": {"readonly": True},
        "is_preview": {"readonly": True},
        "is_deprecated": {"readonly": True},
        "is_hidden": {"readonly": True},
        "end_of_life_date": {"readonly": True},
        "is_auto_update": {"readonly": True},
        "is_early_access": {"readonly": True},
    }

    _attribute_map = {
        "java11_runtime": {"key": "java11Runtime", "type": "str"},
        "java8_runtime": {"key": "java8Runtime", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
        "is_deprecated": {"key": "isDeprecated", "type": "bool"},
        "is_hidden": {"key": "isHidden", "type": "bool"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "is_auto_update": {"key": "isAutoUpdate", "type": "bool"},
        "is_early_access": {"key": "isEarlyAccess", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.java11_runtime = None
        self.java8_runtime = None
        self.is_preview = None
        self.is_deprecated = None
        self.is_hidden = None
        self.end_of_life_date = None
        self.is_auto_update = None
        self.is_early_access = None


class LocalizableString(_serialization.Model):
    """Localizable string object containing the name and a localized value.

    :ivar value: Non-localized name.
    :vartype value: str
    :ivar localized_value: Localized name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Non-localized name.
        :paramtype value: str
        :keyword localized_value: Localized name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LogAnalyticsConfiguration(_serialization.Model):
    """LogAnalyticsConfiguration.

    :ivar customer_id:
    :vartype customer_id: str
    :ivar shared_key:
    :vartype shared_key: str
    """

    _attribute_map = {
        "customer_id": {"key": "customerId", "type": "str"},
        "shared_key": {"key": "sharedKey", "type": "str"},
    }

    def __init__(self, *, customer_id: Optional[str] = None, shared_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword customer_id:
        :paramtype customer_id: str
        :keyword shared_key:
        :paramtype shared_key: str
        """
        super().__init__(**kwargs)
        self.customer_id = customer_id
        self.shared_key = shared_key


class Login(_serialization.Model):
    """The configuration settings of the login flow of users using App Service
    Authentication/Authorization.

    :ivar routes: The routes that specify the endpoints used for login and logout requests.
    :vartype routes: ~azure.mgmt.web.v2023_01_01.models.LoginRoutes
    :ivar token_store: The configuration settings of the token store.
    :vartype token_store: ~azure.mgmt.web.v2023_01_01.models.TokenStore
    :ivar preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
     request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
    :vartype preserve_url_fragments_for_logins: bool
    :ivar allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :vartype allowed_external_redirect_urls: list[str]
    :ivar cookie_expiration: The configuration settings of the session cookie's expiration.
    :vartype cookie_expiration: ~azure.mgmt.web.v2023_01_01.models.CookieExpiration
    :ivar nonce: The configuration settings of the nonce used in the login flow.
    :vartype nonce: ~azure.mgmt.web.v2023_01_01.models.Nonce
    """

    _attribute_map = {
        "routes": {"key": "routes", "type": "LoginRoutes"},
        "token_store": {"key": "tokenStore", "type": "TokenStore"},
        "preserve_url_fragments_for_logins": {"key": "preserveUrlFragmentsForLogins", "type": "bool"},
        "allowed_external_redirect_urls": {"key": "allowedExternalRedirectUrls", "type": "[str]"},
        "cookie_expiration": {"key": "cookieExpiration", "type": "CookieExpiration"},
        "nonce": {"key": "nonce", "type": "Nonce"},
    }

    def __init__(
        self,
        *,
        routes: Optional["_models.LoginRoutes"] = None,
        token_store: Optional["_models.TokenStore"] = None,
        preserve_url_fragments_for_logins: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        cookie_expiration: Optional["_models.CookieExpiration"] = None,
        nonce: Optional["_models.Nonce"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword routes: The routes that specify the endpoints used for login and logout requests.
        :paramtype routes: ~azure.mgmt.web.v2023_01_01.models.LoginRoutes
        :keyword token_store: The configuration settings of the token store.
        :paramtype token_store: ~azure.mgmt.web.v2023_01_01.models.TokenStore
        :keyword preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
         request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
        :paramtype preserve_url_fragments_for_logins: bool
        :keyword allowed_external_redirect_urls: External URLs that can be redirected to as part of
         logging in or logging out of the app. Note that the query string part of the URL is ignored.
         This is an advanced setting typically only needed by Windows Store application backends.
         Note that URLs within the current domain are always implicitly allowed.
        :paramtype allowed_external_redirect_urls: list[str]
        :keyword cookie_expiration: The configuration settings of the session cookie's expiration.
        :paramtype cookie_expiration: ~azure.mgmt.web.v2023_01_01.models.CookieExpiration
        :keyword nonce: The configuration settings of the nonce used in the login flow.
        :paramtype nonce: ~azure.mgmt.web.v2023_01_01.models.Nonce
        """
        super().__init__(**kwargs)
        self.routes = routes
        self.token_store = token_store
        self.preserve_url_fragments_for_logins = preserve_url_fragments_for_logins
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.cookie_expiration = cookie_expiration
        self.nonce = nonce


class LoginRoutes(_serialization.Model):
    """The routes that specify the endpoints used for login and logout requests.

    :ivar logout_endpoint: The endpoint at which a logout request should be made.
    :vartype logout_endpoint: str
    """

    _attribute_map = {
        "logout_endpoint": {"key": "logoutEndpoint", "type": "str"},
    }

    def __init__(self, *, logout_endpoint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword logout_endpoint: The endpoint at which a logout request should be made.
        :paramtype logout_endpoint: str
        """
        super().__init__(**kwargs)
        self.logout_endpoint = logout_endpoint


class LoginScopes(_serialization.Model):
    """The configuration settings of the login flow, including the scopes that should be requested.

    :ivar scopes: A list of the scopes that should be requested while authenticating.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        "scopes": {"key": "scopes", "type": "[str]"},
    }

    def __init__(self, *, scopes: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword scopes: A list of the scopes that should be requested while authenticating.
        :paramtype scopes: list[str]
        """
        super().__init__(**kwargs)
        self.scopes = scopes


class LogSpecification(_serialization.Model):
    """Log Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar blob_duration:
    :vartype blob_duration: str
    :ivar log_filter_pattern:
    :vartype log_filter_pattern: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
        "log_filter_pattern": {"key": "logFilterPattern", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        log_filter_pattern: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        :keyword log_filter_pattern:
        :paramtype log_filter_pattern: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration
        self.log_filter_pattern = log_filter_pattern


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of managed service identity. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    :ivar user_assigned_identities: The list of user assigned identities associated with the
     resource. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.web.v2023_01_01.models.UserAssignedIdentity]
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. Known values are: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The list of user assigned identities associated with the
         resource. The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.web.v2023_01_01.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None
        self.user_assigned_identities = user_assigned_identities


class MetricAvailability(_serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, blob_duration: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar display_description:
    :vartype display_description: str
    :ivar unit:
    :vartype unit: str
    :ivar aggregation_type:
    :vartype aggregation_type: str
    :ivar supports_instance_level_aggregation:
    :vartype supports_instance_level_aggregation: bool
    :ivar enable_regional_mdm_account:
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account:
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace:
    :vartype source_mdm_namespace: str
    :ivar metric_filter_pattern:
    :vartype metric_filter_pattern: str
    :ivar fill_gap_with_zero:
    :vartype fill_gap_with_zero: bool
    :ivar is_internal:
    :vartype is_internal: bool
    :ivar dimensions:
    :vartype dimensions: list[~azure.mgmt.web.v2023_01_01.models.Dimension]
    :ivar category:
    :vartype category: str
    :ivar availabilities:
    :vartype availabilities: list[~azure.mgmt.web.v2023_01_01.models.MetricAvailability]
    :ivar supported_time_grain_types:
    :vartype supported_time_grain_types: list[str]
    :ivar supported_aggregation_types:
    :vartype supported_aggregation_types: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supports_instance_level_aggregation": {"key": "supportsInstanceLevelAggregation", "type": "bool"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "bool"},
        "source_mdm_account": {"key": "sourceMdmAccount", "type": "str"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
        "metric_filter_pattern": {"key": "metricFilterPattern", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "is_internal": {"key": "isInternal", "type": "bool"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "category": {"key": "category", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[MetricAvailability]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[List["_models.MetricAvailability"]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword display_description:
        :paramtype display_description: str
        :keyword unit:
        :paramtype unit: str
        :keyword aggregation_type:
        :paramtype aggregation_type: str
        :keyword supports_instance_level_aggregation:
        :paramtype supports_instance_level_aggregation: bool
        :keyword enable_regional_mdm_account:
        :paramtype enable_regional_mdm_account: bool
        :keyword source_mdm_account:
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace:
        :paramtype source_mdm_namespace: str
        :keyword metric_filter_pattern:
        :paramtype metric_filter_pattern: str
        :keyword fill_gap_with_zero:
        :paramtype fill_gap_with_zero: bool
        :keyword is_internal:
        :paramtype is_internal: bool
        :keyword dimensions:
        :paramtype dimensions: list[~azure.mgmt.web.v2023_01_01.models.Dimension]
        :keyword category:
        :paramtype category: str
        :keyword availabilities:
        :paramtype availabilities: list[~azure.mgmt.web.v2023_01_01.models.MetricAvailability]
        :keyword supported_time_grain_types:
        :paramtype supported_time_grain_types: list[str]
        :keyword supported_aggregation_types:
        :paramtype supported_aggregation_types: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities
        self.supported_time_grain_types = supported_time_grain_types
        self.supported_aggregation_types = supported_aggregation_types


class MigrateMySqlRequest(ProxyOnlyResource):
    """MySQL migration request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar connection_string: Connection string to the remote MySQL database.
    :vartype connection_string: str
    :ivar migration_type: The type of migration operation to be done. Known values are:
     "LocalToRemote" and "RemoteToLocal".
    :vartype migration_type: str or ~azure.mgmt.web.v2023_01_01.models.MySqlMigrationType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "connection_string": {"key": "properties.connectionString", "type": "str"},
        "migration_type": {"key": "properties.migrationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string: Optional[str] = None,
        migration_type: Optional[Union[str, "_models.MySqlMigrationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword connection_string: Connection string to the remote MySQL database.
        :paramtype connection_string: str
        :keyword migration_type: The type of migration operation to be done. Known values are:
         "LocalToRemote" and "RemoteToLocal".
        :paramtype migration_type: str or ~azure.mgmt.web.v2023_01_01.models.MySqlMigrationType
        """
        super().__init__(kind=kind, **kwargs)
        self.connection_string = connection_string
        self.migration_type = migration_type


class MigrateMySqlStatus(ProxyOnlyResource):
    """MySQL migration status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar migration_operation_status: Status of the migration task. Known values are: "InProgress",
     "Failed", "Succeeded", "TimedOut", and "Created".
    :vartype migration_operation_status: str or ~azure.mgmt.web.v2023_01_01.models.OperationStatus
    :ivar operation_id: Operation ID for the migration task.
    :vartype operation_id: str
    :ivar local_my_sql_enabled: True if the web app has in app MySql enabled.
    :vartype local_my_sql_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "migration_operation_status": {"readonly": True},
        "operation_id": {"readonly": True},
        "local_my_sql_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "migration_operation_status": {"key": "properties.migrationOperationStatus", "type": "str"},
        "operation_id": {"key": "properties.operationId", "type": "str"},
        "local_my_sql_enabled": {"key": "properties.localMySqlEnabled", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.migration_operation_status = None
        self.operation_id = None
        self.local_my_sql_enabled = None


class MSDeploy(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """MSDeploy ARM PUT information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar package_uri: Package URI.
    :vartype package_uri: str
    :ivar connection_string: SQL Connection String.
    :vartype connection_string: str
    :ivar db_type: Database Type.
    :vartype db_type: str
    :ivar set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
     SetParameters is used.
    :vartype set_parameters_xml_file_uri: str
    :ivar set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
    :vartype set_parameters: dict[str, str]
    :ivar skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
     If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
     will not be deleted, and any App_Data directory in the source will be ignored.
     Setting is :code:`<code>false</code>` by default.
    :vartype skip_app_data: bool
    :ivar app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
     Setting is :code:`<code>false</code>` by default.
    :vartype app_offline: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "package_uri": {"key": "properties.packageUri", "type": "str"},
        "connection_string": {"key": "properties.connectionString", "type": "str"},
        "db_type": {"key": "properties.dbType", "type": "str"},
        "set_parameters_xml_file_uri": {"key": "properties.setParametersXmlFileUri", "type": "str"},
        "set_parameters": {"key": "properties.setParameters", "type": "{str}"},
        "skip_app_data": {"key": "properties.skipAppData", "type": "bool"},
        "app_offline": {"key": "properties.appOffline", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        package_uri: Optional[str] = None,
        connection_string: Optional[str] = None,
        db_type: Optional[str] = None,
        set_parameters_xml_file_uri: Optional[str] = None,
        set_parameters: Optional[Dict[str, str]] = None,
        skip_app_data: Optional[bool] = None,
        app_offline: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword package_uri: Package URI.
        :paramtype package_uri: str
        :keyword connection_string: SQL Connection String.
        :paramtype connection_string: str
        :keyword db_type: Database Type.
        :paramtype db_type: str
        :keyword set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
         SetParameters is used.
        :paramtype set_parameters_xml_file_uri: str
        :keyword set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is
         used.
        :paramtype set_parameters: dict[str, str]
        :keyword skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
         If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
         will not be deleted, and any App_Data directory in the source will be ignored.
         Setting is :code:`<code>false</code>` by default.
        :paramtype skip_app_data: bool
        :keyword app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
         Setting is :code:`<code>false</code>` by default.
        :paramtype app_offline: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.package_uri = package_uri
        self.connection_string = connection_string
        self.db_type = db_type
        self.set_parameters_xml_file_uri = set_parameters_xml_file_uri
        self.set_parameters = set_parameters
        self.skip_app_data = skip_app_data
        self.app_offline = app_offline


class MSDeployLog(ProxyOnlyResource):
    """MSDeploy log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entries: List of log entry messages.
    :vartype entries: list[~azure.mgmt.web.v2023_01_01.models.MSDeployLogEntry]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "entries": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "entries": {"key": "properties.entries", "type": "[MSDeployLogEntry]"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.entries = None


class MSDeployLogEntry(_serialization.Model):
    """MSDeploy log entry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: Timestamp of log entry.
    :vartype time: ~datetime.datetime
    :ivar type: Log entry type. Known values are: "Message", "Warning", and "Error".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.MSDeployLogEntryType
    :ivar message: Log entry message.
    :vartype message: str
    """

    _validation = {
        "time": {"readonly": True},
        "type": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "time": {"key": "time", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.time = None
        self.type = None
        self.message = None


class MSDeployStatus(ProxyOnlyResource):
    """MSDeploy ARM response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deployer: Username of deployer.
    :vartype deployer: str
    :ivar provisioning_state: Provisioning state. Known values are: "accepted", "running",
     "succeeded", "failed", and "canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2023_01_01.models.MSDeployProvisioningState
    :ivar start_time: Start time of deploy operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of deploy operation.
    :vartype end_time: ~datetime.datetime
    :ivar complete: Whether the deployment operation has completed.
    :vartype complete: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "deployer": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "complete": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deployer": {"key": "properties.deployer", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "complete": {"key": "properties.complete", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.deployer = None
        self.provisioning_state = None
        self.start_time = None
        self.end_time = None
        self.complete = None


class NameIdentifier(_serialization.Model):
    """Identifies an object.

    :ivar name: Name of the object.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the object.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class NameIdentifierCollection(_serialization.Model):
    """Collection of domain name identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.NameIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NameIdentifier]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.NameIdentifier"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.NameIdentifier]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NameValuePair(_serialization.Model):
    """Name value pair.

    :ivar name: Pair name.
    :vartype name: str
    :ivar value: Pair value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Pair name.
        :paramtype name: str
        :keyword value: Pair value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class NetworkFeatures(ProxyOnlyResource):
    """Full view of network features for an app (presently VNET integration and Hybrid Connections).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_network_name: The Virtual Network name.
    :vartype virtual_network_name: str
    :ivar virtual_network_connection: The Virtual Network summary view.
    :vartype virtual_network_connection: ~azure.mgmt.web.v2023_01_01.models.VnetInfo
    :ivar hybrid_connections: The Hybrid Connections summary view.
    :vartype hybrid_connections:
     list[~azure.mgmt.web.v2023_01_01.models.RelayServiceConnectionEntity]
    :ivar hybrid_connections_v2: The Hybrid Connection V2 (Service Bus) view.
    :vartype hybrid_connections_v2: list[~azure.mgmt.web.v2023_01_01.models.HybridConnection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_network_name": {"readonly": True},
        "virtual_network_connection": {"readonly": True},
        "hybrid_connections": {"readonly": True},
        "hybrid_connections_v2": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "virtual_network_name": {"key": "properties.virtualNetworkName", "type": "str"},
        "virtual_network_connection": {"key": "properties.virtualNetworkConnection", "type": "VnetInfo"},
        "hybrid_connections": {"key": "properties.hybridConnections", "type": "[RelayServiceConnectionEntity]"},
        "hybrid_connections_v2": {"key": "properties.hybridConnectionsV2", "type": "[HybridConnection]"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.virtual_network_name = None
        self.virtual_network_connection = None
        self.hybrid_connections = None
        self.hybrid_connections_v2 = None


class NetworkTrace(_serialization.Model):
    """Network trace.

    :ivar path: Local file path for the captured network trace file.
    :vartype path: str
    :ivar status: Current status of the network trace operation, same as Operation.Status
     (InProgress/Succeeded/Failed).
    :vartype status: str
    :ivar message: Detailed message of a network trace operation, e.g. error message in case of
     failure.
    :vartype message: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, path: Optional[str] = None, status: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword path: Local file path for the captured network trace file.
        :paramtype path: str
        :keyword status: Current status of the network trace operation, same as Operation.Status
         (InProgress/Succeeded/Failed).
        :paramtype status: str
        :keyword message: Detailed message of a network trace operation, e.g. error message in case of
         failure.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.status = status
        self.message = message


class Nonce(_serialization.Model):
    """The configuration settings of the nonce used in the login flow.

    :ivar validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
     completing the login flow; otherwise, :code:`<code>true</code>`.
    :vartype validate_nonce: bool
    :ivar nonce_expiration_interval: The time after the request is made when the nonce should
     expire.
    :vartype nonce_expiration_interval: str
    """

    _attribute_map = {
        "validate_nonce": {"key": "validateNonce", "type": "bool"},
        "nonce_expiration_interval": {"key": "nonceExpirationInterval", "type": "str"},
    }

    def __init__(
        self, *, validate_nonce: Optional[bool] = None, nonce_expiration_interval: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
         completing the login flow; otherwise, :code:`<code>true</code>`.
        :paramtype validate_nonce: bool
        :keyword nonce_expiration_interval: The time after the request is made when the nonce should
         expire.
        :paramtype nonce_expiration_interval: str
        """
        super().__init__(**kwargs)
        self.validate_nonce = validate_nonce
        self.nonce_expiration_interval = nonce_expiration_interval


class OpenAuthenticationAccessPolicies(_serialization.Model):
    """AuthenticationPolicy of type Open.

    :ivar policies: Open authentication policies.
    :vartype policies: dict[str, ~azure.mgmt.web.v2023_01_01.models.OpenAuthenticationAccessPolicy]
    """

    _attribute_map = {
        "policies": {"key": "policies", "type": "{OpenAuthenticationAccessPolicy}"},
    }

    def __init__(
        self, *, policies: Optional[Dict[str, "_models.OpenAuthenticationAccessPolicy"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword policies: Open authentication policies.
        :paramtype policies: dict[str,
         ~azure.mgmt.web.v2023_01_01.models.OpenAuthenticationAccessPolicy]
        """
        super().__init__(**kwargs)
        self.policies = policies


class OpenAuthenticationAccessPolicy(_serialization.Model):
    """Open authentication access policy defined by user.

    :ivar type: Type of provider for OAuth. "AAD"
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.OpenAuthenticationProviderType
    :ivar claims: The access policy claims.
    :vartype claims: list[~azure.mgmt.web.v2023_01_01.models.OpenAuthenticationPolicyClaim]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "claims": {"key": "claims", "type": "[OpenAuthenticationPolicyClaim]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.OpenAuthenticationProviderType"]] = None,
        claims: Optional[List["_models.OpenAuthenticationPolicyClaim"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of provider for OAuth. "AAD"
        :paramtype type: str or ~azure.mgmt.web.v2023_01_01.models.OpenAuthenticationProviderType
        :keyword claims: The access policy claims.
        :paramtype claims: list[~azure.mgmt.web.v2023_01_01.models.OpenAuthenticationPolicyClaim]
        """
        super().__init__(**kwargs)
        self.type = type
        self.claims = claims


class OpenAuthenticationPolicyClaim(_serialization.Model):
    """Open authentication policy claim.

    :ivar name: The name of the claim.
    :vartype name: str
    :ivar value: The value of the claim.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the claim.
        :paramtype name: str
        :keyword value: The value of the claim.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class OpenIdConnectClientCredential(_serialization.Model):
    """The authentication client credentials of the custom Open ID Connect provider.

    :ivar method: The method that should be used to authenticate the user. Default value is
     "ClientSecretPost".
    :vartype method: str
    :ivar client_secret_setting_name: The app setting that contains the client secret for the
     custom Open ID Connect provider.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        "method": {"key": "method", "type": "str"},
        "client_secret_setting_name": {"key": "clientSecretSettingName", "type": "str"},
    }

    def __init__(
        self,
        *,
        method: Optional[Literal["ClientSecretPost"]] = None,
        client_secret_setting_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword method: The method that should be used to authenticate the user. Default value is
         "ClientSecretPost".
        :paramtype method: str
        :keyword client_secret_setting_name: The app setting that contains the client secret for the
         custom Open ID Connect provider.
        :paramtype client_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.method = method
        self.client_secret_setting_name = client_secret_setting_name


class OpenIdConnectConfig(_serialization.Model):
    """The configuration settings of the endpoints used for the custom Open ID Connect provider.

    :ivar authorization_endpoint: The endpoint to be used to make an authorization request.
    :vartype authorization_endpoint: str
    :ivar token_endpoint: The endpoint to be used to request a token.
    :vartype token_endpoint: str
    :ivar issuer: The endpoint that issues the token.
    :vartype issuer: str
    :ivar certification_uri: The endpoint that provides the keys necessary to validate the token.
    :vartype certification_uri: str
    :ivar well_known_open_id_configuration: The endpoint that contains all the configuration
     endpoints for the provider.
    :vartype well_known_open_id_configuration: str
    """

    _attribute_map = {
        "authorization_endpoint": {"key": "authorizationEndpoint", "type": "str"},
        "token_endpoint": {"key": "tokenEndpoint", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "certification_uri": {"key": "certificationUri", "type": "str"},
        "well_known_open_id_configuration": {"key": "wellKnownOpenIdConfiguration", "type": "str"},
    }

    def __init__(
        self,
        *,
        authorization_endpoint: Optional[str] = None,
        token_endpoint: Optional[str] = None,
        issuer: Optional[str] = None,
        certification_uri: Optional[str] = None,
        well_known_open_id_configuration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authorization_endpoint: The endpoint to be used to make an authorization request.
        :paramtype authorization_endpoint: str
        :keyword token_endpoint: The endpoint to be used to request a token.
        :paramtype token_endpoint: str
        :keyword issuer: The endpoint that issues the token.
        :paramtype issuer: str
        :keyword certification_uri: The endpoint that provides the keys necessary to validate the
         token.
        :paramtype certification_uri: str
        :keyword well_known_open_id_configuration: The endpoint that contains all the configuration
         endpoints for the provider.
        :paramtype well_known_open_id_configuration: str
        """
        super().__init__(**kwargs)
        self.authorization_endpoint = authorization_endpoint
        self.token_endpoint = token_endpoint
        self.issuer = issuer
        self.certification_uri = certification_uri
        self.well_known_open_id_configuration = well_known_open_id_configuration


class OpenIdConnectLogin(_serialization.Model):
    """The configuration settings of the login flow of the custom Open ID Connect provider.

    :ivar name_claim_type: The name of the claim that contains the users name.
    :vartype name_claim_type: str
    :ivar scopes: A list of the scopes that should be requested while authenticating.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        "name_claim_type": {"key": "nameClaimType", "type": "str"},
        "scopes": {"key": "scopes", "type": "[str]"},
    }

    def __init__(
        self, *, name_claim_type: Optional[str] = None, scopes: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name_claim_type: The name of the claim that contains the users name.
        :paramtype name_claim_type: str
        :keyword scopes: A list of the scopes that should be requested while authenticating.
        :paramtype scopes: list[str]
        """
        super().__init__(**kwargs)
        self.name_claim_type = name_claim_type
        self.scopes = scopes


class OpenIdConnectRegistration(_serialization.Model):
    """The configuration settings of the app registration for the custom Open ID Connect provider.

    :ivar client_id: The client id of the custom Open ID Connect provider.
    :vartype client_id: str
    :ivar client_credential: The authentication credentials of the custom Open ID Connect provider.
    :vartype client_credential: ~azure.mgmt.web.v2023_01_01.models.OpenIdConnectClientCredential
    :ivar open_id_connect_configuration: The configuration settings of the endpoints used for the
     custom Open ID Connect provider.
    :vartype open_id_connect_configuration: ~azure.mgmt.web.v2023_01_01.models.OpenIdConnectConfig
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_credential": {"key": "clientCredential", "type": "OpenIdConnectClientCredential"},
        "open_id_connect_configuration": {"key": "openIdConnectConfiguration", "type": "OpenIdConnectConfig"},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_credential: Optional["_models.OpenIdConnectClientCredential"] = None,
        open_id_connect_configuration: Optional["_models.OpenIdConnectConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_id: The client id of the custom Open ID Connect provider.
        :paramtype client_id: str
        :keyword client_credential: The authentication credentials of the custom Open ID Connect
         provider.
        :paramtype client_credential: ~azure.mgmt.web.v2023_01_01.models.OpenIdConnectClientCredential
        :keyword open_id_connect_configuration: The configuration settings of the endpoints used for
         the custom Open ID Connect provider.
        :paramtype open_id_connect_configuration:
         ~azure.mgmt.web.v2023_01_01.models.OpenIdConnectConfig
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_credential = client_credential
        self.open_id_connect_configuration = open_id_connect_configuration


class Operation(_serialization.Model):
    """An operation on a resource.

    :ivar id: Operation ID.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar status: The current status of the operation. Known values are: "InProgress", "Failed",
     "Succeeded", "TimedOut", and "Created".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.OperationStatus
    :ivar errors: Any errors associate with the operation.
    :vartype errors: list[~azure.mgmt.web.v2023_01_01.models.ErrorEntity]
    :ivar created_time: Time when operation has started.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: Time when operation has been updated.
    :vartype modified_time: ~datetime.datetime
    :ivar expiration_time: Time when operation will expire.
    :vartype expiration_time: ~datetime.datetime
    :ivar geo_master_operation_id: Applicable only for stamp operation ids.
    :vartype geo_master_operation_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "errors": {"key": "errors", "type": "[ErrorEntity]"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "modified_time": {"key": "modifiedTime", "type": "iso-8601"},
        "expiration_time": {"key": "expirationTime", "type": "iso-8601"},
        "geo_master_operation_id": {"key": "geoMasterOperationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        errors: Optional[List["_models.ErrorEntity"]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        geo_master_operation_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Operation ID.
        :paramtype id: str
        :keyword name: Operation name.
        :paramtype name: str
        :keyword status: The current status of the operation. Known values are: "InProgress", "Failed",
         "Succeeded", "TimedOut", and "Created".
        :paramtype status: str or ~azure.mgmt.web.v2023_01_01.models.OperationStatus
        :keyword errors: Any errors associate with the operation.
        :paramtype errors: list[~azure.mgmt.web.v2023_01_01.models.ErrorEntity]
        :keyword created_time: Time when operation has started.
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time: Time when operation has been updated.
        :paramtype modified_time: ~datetime.datetime
        :keyword expiration_time: Time when operation will expire.
        :paramtype expiration_time: ~datetime.datetime
        :keyword geo_master_operation_id: Applicable only for stamp operation ids.
        :paramtype geo_master_operation_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.errors = errors
        self.created_time = created_time
        self.modified_time = modified_time
        self.expiration_time = expiration_time
        self.geo_master_operation_id = geo_master_operation_id


class OperationResultProperties(_serialization.Model):
    """The run operation result properties.

    :ivar start_time: The start time of the workflow scope repetition.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the workflow scope repetition.
    :vartype end_time: ~datetime.datetime
    :ivar correlation: The correlation properties.
    :vartype correlation: ~azure.mgmt.web.v2023_01_01.models.RunActionCorrelation
    :ivar status: The status of the workflow scope repetition. Known values are: "NotSpecified",
     "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
     "Faulted", "TimedOut", "Aborted", and "Ignored".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.WorkflowStatus
    :ivar code: The workflow scope repetition code.
    :vartype code: str
    :ivar error: Anything.
    :vartype error: any
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "correlation": {"key": "correlation", "type": "RunActionCorrelation"},
        "status": {"key": "status", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "error": {"key": "error", "type": "object"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["_models.RunActionCorrelation"] = None,
        status: Optional[Union[str, "_models.WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[Any] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: The start time of the workflow scope repetition.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the workflow scope repetition.
        :paramtype end_time: ~datetime.datetime
        :keyword correlation: The correlation properties.
        :paramtype correlation: ~azure.mgmt.web.v2023_01_01.models.RunActionCorrelation
        :keyword status: The status of the workflow scope repetition. Known values are: "NotSpecified",
         "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
         "Faulted", "TimedOut", "Aborted", and "Ignored".
        :paramtype status: str or ~azure.mgmt.web.v2023_01_01.models.WorkflowStatus
        :keyword code: The workflow scope repetition code.
        :paramtype code: str
        :keyword error: Anything.
        :paramtype error: any
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.correlation = correlation
        self.status = status
        self.code = code
        self.error = error


class OperationResult(OperationResultProperties):  # pylint: disable=too-many-instance-attributes
    """The operation result definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar start_time: The start time of the workflow scope repetition.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the workflow scope repetition.
    :vartype end_time: ~datetime.datetime
    :ivar correlation: The correlation properties.
    :vartype correlation: ~azure.mgmt.web.v2023_01_01.models.RunActionCorrelation
    :ivar status: The status of the workflow scope repetition. Known values are: "NotSpecified",
     "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
     "Faulted", "TimedOut", "Aborted", and "Ignored".
    :vartype status: str or ~azure.mgmt.web.v2023_01_01.models.WorkflowStatus
    :ivar code: The workflow scope repetition code.
    :vartype code: str
    :ivar error: Anything.
    :vartype error: any
    :ivar tracking_id: Gets the tracking id.
    :vartype tracking_id: str
    :ivar inputs: Gets the inputs.
    :vartype inputs: JSON
    :ivar inputs_link: Gets the link to inputs.
    :vartype inputs_link: ~azure.mgmt.web.v2023_01_01.models.ContentLink
    :ivar outputs: Gets the outputs.
    :vartype outputs: JSON
    :ivar outputs_link: Gets the link to outputs.
    :vartype outputs_link: ~azure.mgmt.web.v2023_01_01.models.ContentLink
    :ivar tracked_properties: Gets the tracked properties.
    :vartype tracked_properties: JSON
    :ivar retry_history: Gets the retry histories.
    :vartype retry_history: list[~azure.mgmt.web.v2023_01_01.models.RetryHistory]
    :ivar iteration_count:
    :vartype iteration_count: int
    """

    _validation = {
        "tracking_id": {"readonly": True},
        "inputs": {"readonly": True},
        "inputs_link": {"readonly": True},
        "outputs": {"readonly": True},
        "outputs_link": {"readonly": True},
        "tracked_properties": {"readonly": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "correlation": {"key": "correlation", "type": "RunActionCorrelation"},
        "status": {"key": "status", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "error": {"key": "error", "type": "object"},
        "tracking_id": {"key": "trackingId", "type": "str"},
        "inputs": {"key": "inputs", "type": "object"},
        "inputs_link": {"key": "inputsLink", "type": "ContentLink"},
        "outputs": {"key": "outputs", "type": "object"},
        "outputs_link": {"key": "outputsLink", "type": "ContentLink"},
        "tracked_properties": {"key": "trackedProperties", "type": "object"},
        "retry_history": {"key": "retryHistory", "type": "[RetryHistory]"},
        "iteration_count": {"key": "iterationCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        correlation: Optional["_models.RunActionCorrelation"] = None,
        status: Optional[Union[str, "_models.WorkflowStatus"]] = None,
        code: Optional[str] = None,
        error: Optional[Any] = None,
        retry_history: Optional[List["_models.RetryHistory"]] = None,
        iteration_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: The start time of the workflow scope repetition.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the workflow scope repetition.
        :paramtype end_time: ~datetime.datetime
        :keyword correlation: The correlation properties.
        :paramtype correlation: ~azure.mgmt.web.v2023_01_01.models.RunActionCorrelation
        :keyword status: The status of the workflow scope repetition. Known values are: "NotSpecified",
         "Paused", "Running", "Waiting", "Succeeded", "Skipped", "Suspended", "Cancelled", "Failed",
         "Faulted", "TimedOut", "Aborted", and "Ignored".
        :paramtype status: str or ~azure.mgmt.web.v2023_01_01.models.WorkflowStatus
        :keyword code: The workflow scope repetition code.
        :paramtype code: str
        :keyword error: Anything.
        :paramtype error: any
        :keyword retry_history: Gets the retry histories.
        :paramtype retry_history: list[~azure.mgmt.web.v2023_01_01.models.RetryHistory]
        :keyword iteration_count:
        :paramtype iteration_count: int
        """
        super().__init__(
            start_time=start_time,
            end_time=end_time,
            correlation=correlation,
            status=status,
            code=code,
            error=error,
            **kwargs
        )
        self.tracking_id = None
        self.inputs = None
        self.inputs_link = None
        self.outputs = None
        self.outputs_link = None
        self.tracked_properties = None
        self.retry_history = retry_history
        self.iteration_count = iteration_count


class OutboundEnvironmentEndpoint(_serialization.Model):
    """Endpoints accessed for a common purpose that the App Service Environment requires outbound
    network access to.

    :ivar category: The type of service accessed by the App Service Environment, e.g., Azure
     Storage, Azure SQL Database, and Azure Active Directory.
    :vartype category: str
    :ivar endpoints: The endpoints that the App Service Environment reaches the service at.
    :vartype endpoints: list[~azure.mgmt.web.v2023_01_01.models.EndpointDependency]
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["_models.EndpointDependency"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: The type of service accessed by the App Service Environment, e.g., Azure
         Storage, Azure SQL Database, and Azure Active Directory.
        :paramtype category: str
        :keyword endpoints: The endpoints that the App Service Environment reaches the service at.
        :paramtype endpoints: list[~azure.mgmt.web.v2023_01_01.models.EndpointDependency]
        """
        super().__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointCollection(_serialization.Model):
    """Collection of Outbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.OutboundEnvironmentEndpoint"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.OutboundEnvironmentEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonCounterCollection(_serialization.Model):
    """Collection of performance monitor counters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.PerfMonResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PerfMonResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.PerfMonResponse"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.PerfMonResponse]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonResponse(_serialization.Model):
    """Performance monitor API response.

    :ivar code: The response code.
    :vartype code: str
    :ivar message: The message.
    :vartype message: str
    :ivar data: The performance monitor counters.
    :vartype data: ~azure.mgmt.web.v2023_01_01.models.PerfMonSet
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "data": {"key": "data", "type": "PerfMonSet"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        data: Optional["_models.PerfMonSet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The response code.
        :paramtype code: str
        :keyword message: The message.
        :paramtype message: str
        :keyword data: The performance monitor counters.
        :paramtype data: ~azure.mgmt.web.v2023_01_01.models.PerfMonSet
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.data = data


class PerfMonSample(_serialization.Model):
    """Performance monitor sample in a set.

    :ivar time: Point in time for which counter was measured.
    :vartype time: ~datetime.datetime
    :ivar instance_name: Name of the server on which the measurement is made.
    :vartype instance_name: str
    :ivar value: Value of counter at a certain time.
    :vartype value: float
    """

    _attribute_map = {
        "time": {"key": "time", "type": "iso-8601"},
        "instance_name": {"key": "instanceName", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(
        self,
        *,
        time: Optional[datetime.datetime] = None,
        instance_name: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time: Point in time for which counter was measured.
        :paramtype time: ~datetime.datetime
        :keyword instance_name: Name of the server on which the measurement is made.
        :paramtype instance_name: str
        :keyword value: Value of counter at a certain time.
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.time = time
        self.instance_name = instance_name
        self.value = value


class PerfMonSet(_serialization.Model):
    """Metric information.

    :ivar name: Unique key name of the counter.
    :vartype name: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: Presented time grain.
    :vartype time_grain: str
    :ivar values: Collection of workers that are active during this time.
    :vartype values: list[~azure.mgmt.web.v2023_01_01.models.PerfMonSample]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "values": {"key": "values", "type": "[PerfMonSample]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["_models.PerfMonSample"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Unique key name of the counter.
        :paramtype name: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword time_grain: Presented time grain.
        :paramtype time_grain: str
        :keyword values: Collection of workers that are active during this time.
        :paramtype values: list[~azure.mgmt.web.v2023_01_01.models.PerfMonSample]
        """
        super().__init__(**kwargs)
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class PremierAddOn(Resource):  # pylint: disable=too-many-instance-attributes
    """Premier add-on.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on Product.
    :vartype product: str
    :ivar vendor: Premier add on Vendor.
    :vartype vendor: str
    :ivar marketplace_publisher: Premier add on Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Premier add on Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "properties.sku", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "marketplace_publisher": {"key": "properties.marketplacePublisher", "type": "str"},
        "marketplace_offer": {"key": "properties.marketplaceOffer", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on Product.
        :paramtype product: str
        :keyword vendor: Premier add on Vendor.
        :paramtype vendor: str
        :keyword marketplace_publisher: Premier add on Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Premier add on Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOffer(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Premier add-on offer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on offer Product.
    :vartype product: str
    :ivar vendor: Premier add on offer Vendor.
    :vartype vendor: str
    :ivar promo_code_required: :code:`<code>true</code>` if promotion code is required; otherwise,
     :code:`<code>false</code>`.
    :vartype promo_code_required: bool
    :ivar quota: Premier add on offer Quota.
    :vartype quota: int
    :ivar web_hosting_plan_restrictions: App Service plans this offer is restricted to. Known
     values are: "None", "Free", "Shared", "Basic", "Standard", and "Premium".
    :vartype web_hosting_plan_restrictions: str or
     ~azure.mgmt.web.v2023_01_01.models.AppServicePlanRestrictions
    :ivar privacy_policy_url: Privacy policy URL.
    :vartype privacy_policy_url: str
    :ivar legal_terms_url: Legal terms URL.
    :vartype legal_terms_url: str
    :ivar marketplace_publisher: Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "promo_code_required": {"key": "properties.promoCodeRequired", "type": "bool"},
        "quota": {"key": "properties.quota", "type": "int"},
        "web_hosting_plan_restrictions": {"key": "properties.webHostingPlanRestrictions", "type": "str"},
        "privacy_policy_url": {"key": "properties.privacyPolicyUrl", "type": "str"},
        "legal_terms_url": {"key": "properties.legalTermsUrl", "type": "str"},
        "marketplace_publisher": {"key": "properties.marketplacePublisher", "type": "str"},
        "marketplace_offer": {"key": "properties.marketplaceOffer", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        promo_code_required: Optional[bool] = None,
        quota: Optional[int] = None,
        web_hosting_plan_restrictions: Optional[Union[str, "_models.AppServicePlanRestrictions"]] = None,
        privacy_policy_url: Optional[str] = None,
        legal_terms_url: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on offer Product.
        :paramtype product: str
        :keyword vendor: Premier add on offer Vendor.
        :paramtype vendor: str
        :keyword promo_code_required: :code:`<code>true</code>` if promotion code is required;
         otherwise, :code:`<code>false</code>`.
        :paramtype promo_code_required: bool
        :keyword quota: Premier add on offer Quota.
        :paramtype quota: int
        :keyword web_hosting_plan_restrictions: App Service plans this offer is restricted to. Known
         values are: "None", "Free", "Shared", "Basic", "Standard", and "Premium".
        :paramtype web_hosting_plan_restrictions: str or
         ~azure.mgmt.web.v2023_01_01.models.AppServicePlanRestrictions
        :keyword privacy_policy_url: Privacy policy URL.
        :paramtype privacy_policy_url: str
        :keyword legal_terms_url: Legal terms URL.
        :paramtype legal_terms_url: str
        :keyword marketplace_publisher: Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super().__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.promo_code_required = promo_code_required
        self.quota = quota
        self.web_hosting_plan_restrictions = web_hosting_plan_restrictions
        self.privacy_policy_url = privacy_policy_url
        self.legal_terms_url = legal_terms_url
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOfferCollection(_serialization.Model):
    """Collection of premier add-on offers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.PremierAddOnOffer]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PremierAddOnOffer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.PremierAddOnOffer"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.PremierAddOnOffer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PremierAddOnPatchResource(ProxyOnlyResource):
    """ARM resource for a PremierAddOn.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on Product.
    :vartype product: str
    :ivar vendor: Premier add on Vendor.
    :vartype vendor: str
    :ivar marketplace_publisher: Premier add on Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Premier add on Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "marketplace_publisher": {"key": "properties.marketplacePublisher", "type": "str"},
        "marketplace_offer": {"key": "properties.marketplaceOffer", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on Product.
        :paramtype product: str
        :keyword vendor: Premier add on Vendor.
        :paramtype vendor: str
        :keyword marketplace_publisher: Premier add on Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Premier add on Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super().__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PrivateAccess(ProxyOnlyResource):
    """Description of the parameters of Private Access for a Web Site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar enabled: Whether private access is enabled or not.
    :vartype enabled: bool
    :ivar virtual_networks: The Virtual Networks (and subnets) allowed to access the site
     privately.
    :vartype virtual_networks: list[~azure.mgmt.web.v2023_01_01.models.PrivateAccessVirtualNetwork]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "virtual_networks": {"key": "properties.virtualNetworks", "type": "[PrivateAccessVirtualNetwork]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        virtual_networks: Optional[List["_models.PrivateAccessVirtualNetwork"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword enabled: Whether private access is enabled or not.
        :paramtype enabled: bool
        :keyword virtual_networks: The Virtual Networks (and subnets) allowed to access the site
         privately.
        :paramtype virtual_networks:
         list[~azure.mgmt.web.v2023_01_01.models.PrivateAccessVirtualNetwork]
        """
        super().__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.virtual_networks = virtual_networks


class PrivateAccessSubnet(_serialization.Model):
    """Description of a Virtual Network subnet that is useable for private site access.

    :ivar name: The name of the subnet.
    :vartype name: str
    :ivar key: The key (ID) of the subnet.
    :vartype key: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "key": {"key": "key", "type": "int"},
    }

    def __init__(self, *, name: Optional[str] = None, key: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the subnet.
        :paramtype name: str
        :keyword key: The key (ID) of the subnet.
        :paramtype key: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.key = key


class PrivateAccessVirtualNetwork(_serialization.Model):
    """Description of a Virtual Network that is useable for private site access.

    :ivar name: The name of the Virtual Network.
    :vartype name: str
    :ivar key: The key (ID) of the Virtual Network.
    :vartype key: int
    :ivar resource_id: The ARM uri of the Virtual Network.
    :vartype resource_id: str
    :ivar subnets: A List of subnets that access is allowed to on this Virtual Network. An empty
     array (but not null) is interpreted to mean that all subnets are allowed within this Virtual
     Network.
    :vartype subnets: list[~azure.mgmt.web.v2023_01_01.models.PrivateAccessSubnet]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "key": {"key": "key", "type": "int"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "subnets": {"key": "subnets", "type": "[PrivateAccessSubnet]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        key: Optional[int] = None,
        resource_id: Optional[str] = None,
        subnets: Optional[List["_models.PrivateAccessSubnet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the Virtual Network.
        :paramtype name: str
        :keyword key: The key (ID) of the Virtual Network.
        :paramtype key: int
        :keyword resource_id: The ARM uri of the Virtual Network.
        :paramtype resource_id: str
        :keyword subnets: A List of subnets that access is allowed to on this Virtual Network. An empty
         array (but not null) is interpreted to mean that all subnets are allowed within this Virtual
         Network.
        :paramtype subnets: list[~azure.mgmt.web.v2023_01_01.models.PrivateAccessSubnet]
        """
        super().__init__(**kwargs)
        self.name = name
        self.key = key
        self.resource_id = resource_id
        self.subnets = subnets


class PrivateEndpointConnectionCollection(_serialization.Model):
    """PrivateEndpointConnectionCollection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value:
     list[~azure.mgmt.web.v2023_01_01.models.RemotePrivateEndpointConnectionARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RemotePrivateEndpointConnectionARMResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RemotePrivateEndpointConnectionARMResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value:
         list[~azure.mgmt.web.v2023_01_01.models.RemotePrivateEndpointConnectionARMResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateLinkConnectionApprovalRequestResource(ProxyOnlyResource):  # pylint: disable=name-too-long
    """Private Endpoint Connection Approval ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar private_link_service_connection_state: The state of a private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.web.v2023_01_01.models.PrivateLinkConnectionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkConnectionState",
        },
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword private_link_service_connection_state: The state of a private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.web.v2023_01_01.models.PrivateLinkConnectionState
        """
        super().__init__(kind=kind, **kwargs)
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkConnectionState(_serialization.Model):
    """The state of a private link connection.

    :ivar status: Status of a private link connection.
    :vartype status: str
    :ivar description: Description of a private link connection.
    :vartype description: str
    :ivar actions_required: ActionsRequired for a private link connection.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of a private link connection.
        :paramtype status: str
        :keyword description: Description of a private link connection.
        :paramtype description: str
        :keyword actions_required: ActionsRequired for a private link connection.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PrivateLinkResource(_serialization.Model):
    """A private link resource.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar name: Name of a private link resource. Required.
    :vartype name: str
    :ivar type: Required.
    :vartype type: str
    :ivar properties: Properties of a private link resource. Required.
    :vartype properties: ~azure.mgmt.web.v2023_01_01.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"required": True},
        "name": {"required": True},
        "type": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        type: str,
        properties: "_models.PrivateLinkResourceProperties",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword name: Name of a private link resource. Required.
        :paramtype name: str
        :keyword type: Required.
        :paramtype type: str
        :keyword properties: Properties of a private link resource. Required.
        :paramtype properties: ~azure.mgmt.web.v2023_01_01.models.PrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.properties = properties


class PrivateLinkResourceProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: GroupId of a private link resource.
    :vartype group_id: str
    :ivar required_members: RequiredMembers of a private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: RequiredZoneNames of a private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "required_zone_names": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkResourcesWrapper(_serialization.Model):
    """Wrapper for a collection of private link resources.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.PrivateLinkResource]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: List["_models.PrivateLinkResource"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class ProcessInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Process Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: ARM Identifier for deployment.
    :vartype identifier: int
    :ivar deployment_name: Deployment name.
    :vartype deployment_name: str
    :ivar href: HRef URI.
    :vartype href: str
    :ivar minidump: Minidump URI.
    :vartype minidump: str
    :ivar is_profile_running: Is profile running?.
    :vartype is_profile_running: bool
    :ivar is_iis_profile_running: Is the IIS Profile running?.
    :vartype is_iis_profile_running: bool
    :ivar iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :vartype iis_profile_timeout_in_seconds: float
    :ivar parent: Parent process.
    :vartype parent: str
    :ivar children: Child process list.
    :vartype children: list[str]
    :ivar threads: Thread list.
    :vartype threads: list[~azure.mgmt.web.v2023_01_01.models.ProcessThreadInfo]
    :ivar open_file_handles: List of open files.
    :vartype open_file_handles: list[str]
    :ivar modules: List of modules.
    :vartype modules: list[~azure.mgmt.web.v2023_01_01.models.ProcessModuleInfo]
    :ivar file_name: File name of this process.
    :vartype file_name: str
    :ivar command_line: Command line.
    :vartype command_line: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar handle_count: Handle count.
    :vartype handle_count: int
    :ivar module_count: Module count.
    :vartype module_count: int
    :ivar thread_count: Thread count.
    :vartype thread_count: int
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar total_cpu_time: Total CPU time.
    :vartype total_cpu_time: str
    :ivar user_cpu_time: User CPU time.
    :vartype user_cpu_time: str
    :ivar privileged_cpu_time: Privileged CPU time.
    :vartype privileged_cpu_time: str
    :ivar working_set: Working set.
    :vartype working_set: int
    :ivar peak_working_set: Peak working set.
    :vartype peak_working_set: int
    :ivar private_memory: Private memory size.
    :vartype private_memory: int
    :ivar virtual_memory: Virtual memory size.
    :vartype virtual_memory: int
    :ivar peak_virtual_memory: Peak virtual memory usage.
    :vartype peak_virtual_memory: int
    :ivar paged_system_memory: Paged system memory.
    :vartype paged_system_memory: int
    :ivar non_paged_system_memory: Non-paged system memory.
    :vartype non_paged_system_memory: int
    :ivar paged_memory: Paged memory.
    :vartype paged_memory: int
    :ivar peak_paged_memory: Peak paged memory.
    :vartype peak_paged_memory: int
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    :ivar environment_variables: List of environment variables.
    :vartype environment_variables: dict[str, str]
    :ivar is_scm_site: Is this the SCM site?.
    :vartype is_scm_site: bool
    :ivar is_webjob: Is this a Web Job?.
    :vartype is_webjob: bool
    :ivar description: Description of process.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "int"},
        "deployment_name": {"key": "properties.deployment_name", "type": "str"},
        "href": {"key": "properties.href", "type": "str"},
        "minidump": {"key": "properties.minidump", "type": "str"},
        "is_profile_running": {"key": "properties.is_profile_running", "type": "bool"},
        "is_iis_profile_running": {"key": "properties.is_iis_profile_running", "type": "bool"},
        "iis_profile_timeout_in_seconds": {"key": "properties.iis_profile_timeout_in_seconds", "type": "float"},
        "parent": {"key": "properties.parent", "type": "str"},
        "children": {"key": "properties.children", "type": "[str]"},
        "threads": {"key": "properties.threads", "type": "[ProcessThreadInfo]"},
        "open_file_handles": {"key": "properties.open_file_handles", "type": "[str]"},
        "modules": {"key": "properties.modules", "type": "[ProcessModuleInfo]"},
        "file_name": {"key": "properties.file_name", "type": "str"},
        "command_line": {"key": "properties.command_line", "type": "str"},
        "user_name": {"key": "properties.user_name", "type": "str"},
        "handle_count": {"key": "properties.handle_count", "type": "int"},
        "module_count": {"key": "properties.module_count", "type": "int"},
        "thread_count": {"key": "properties.thread_count", "type": "int"},
        "start_time": {"key": "properties.start_time", "type": "iso-8601"},
        "total_cpu_time": {"key": "properties.total_cpu_time", "type": "str"},
        "user_cpu_time": {"key": "properties.user_cpu_time", "type": "str"},
        "privileged_cpu_time": {"key": "properties.privileged_cpu_time", "type": "str"},
        "working_set": {"key": "properties.working_set", "type": "int"},
        "peak_working_set": {"key": "properties.peak_working_set", "type": "int"},
        "private_memory": {"key": "properties.private_memory", "type": "int"},
        "virtual_memory": {"key": "properties.virtual_memory", "type": "int"},
        "peak_virtual_memory": {"key": "properties.peak_virtual_memory", "type": "int"},
        "paged_system_memory": {"key": "properties.paged_system_memory", "type": "int"},
        "non_paged_system_memory": {"key": "properties.non_paged_system_memory", "type": "int"},
        "paged_memory": {"key": "properties.paged_memory", "type": "int"},
        "peak_paged_memory": {"key": "properties.peak_paged_memory", "type": "int"},
        "time_stamp": {"key": "properties.time_stamp", "type": "iso-8601"},
        "environment_variables": {"key": "properties.environment_variables", "type": "{str}"},
        "is_scm_site": {"key": "properties.is_scm_site", "type": "bool"},
        "is_webjob": {"key": "properties.is_webjob", "type": "bool"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        deployment_name: Optional[str] = None,
        href: Optional[str] = None,
        minidump: Optional[str] = None,
        is_profile_running: Optional[bool] = None,
        is_iis_profile_running: Optional[bool] = None,
        iis_profile_timeout_in_seconds: Optional[float] = None,
        parent: Optional[str] = None,
        children: Optional[List[str]] = None,
        threads: Optional[List["_models.ProcessThreadInfo"]] = None,
        open_file_handles: Optional[List[str]] = None,
        modules: Optional[List["_models.ProcessModuleInfo"]] = None,
        file_name: Optional[str] = None,
        command_line: Optional[str] = None,
        user_name: Optional[str] = None,
        handle_count: Optional[int] = None,
        module_count: Optional[int] = None,
        thread_count: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_cpu_time: Optional[str] = None,
        user_cpu_time: Optional[str] = None,
        privileged_cpu_time: Optional[str] = None,
        working_set: Optional[int] = None,
        peak_working_set: Optional[int] = None,
        private_memory: Optional[int] = None,
        virtual_memory: Optional[int] = None,
        peak_virtual_memory: Optional[int] = None,
        paged_system_memory: Optional[int] = None,
        non_paged_system_memory: Optional[int] = None,
        paged_memory: Optional[int] = None,
        peak_paged_memory: Optional[int] = None,
        time_stamp: Optional[datetime.datetime] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        is_scm_site: Optional[bool] = None,
        is_webjob: Optional[bool] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword deployment_name: Deployment name.
        :paramtype deployment_name: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword minidump: Minidump URI.
        :paramtype minidump: str
        :keyword is_profile_running: Is profile running?.
        :paramtype is_profile_running: bool
        :keyword is_iis_profile_running: Is the IIS Profile running?.
        :paramtype is_iis_profile_running: bool
        :keyword iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
        :paramtype iis_profile_timeout_in_seconds: float
        :keyword parent: Parent process.
        :paramtype parent: str
        :keyword children: Child process list.
        :paramtype children: list[str]
        :keyword threads: Thread list.
        :paramtype threads: list[~azure.mgmt.web.v2023_01_01.models.ProcessThreadInfo]
        :keyword open_file_handles: List of open files.
        :paramtype open_file_handles: list[str]
        :keyword modules: List of modules.
        :paramtype modules: list[~azure.mgmt.web.v2023_01_01.models.ProcessModuleInfo]
        :keyword file_name: File name of this process.
        :paramtype file_name: str
        :keyword command_line: Command line.
        :paramtype command_line: str
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword handle_count: Handle count.
        :paramtype handle_count: int
        :keyword module_count: Module count.
        :paramtype module_count: int
        :keyword thread_count: Thread count.
        :paramtype thread_count: int
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword total_cpu_time: Total CPU time.
        :paramtype total_cpu_time: str
        :keyword user_cpu_time: User CPU time.
        :paramtype user_cpu_time: str
        :keyword privileged_cpu_time: Privileged CPU time.
        :paramtype privileged_cpu_time: str
        :keyword working_set: Working set.
        :paramtype working_set: int
        :keyword peak_working_set: Peak working set.
        :paramtype peak_working_set: int
        :keyword private_memory: Private memory size.
        :paramtype private_memory: int
        :keyword virtual_memory: Virtual memory size.
        :paramtype virtual_memory: int
        :keyword peak_virtual_memory: Peak virtual memory usage.
        :paramtype peak_virtual_memory: int
        :keyword paged_system_memory: Paged system memory.
        :paramtype paged_system_memory: int
        :keyword non_paged_system_memory: Non-paged system memory.
        :paramtype non_paged_system_memory: int
        :keyword paged_memory: Paged memory.
        :paramtype paged_memory: int
        :keyword peak_paged_memory: Peak paged memory.
        :paramtype peak_paged_memory: int
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        :keyword environment_variables: List of environment variables.
        :paramtype environment_variables: dict[str, str]
        :keyword is_scm_site: Is this the SCM site?.
        :paramtype is_scm_site: bool
        :keyword is_webjob: Is this a Web Job?.
        :paramtype is_webjob: bool
        :keyword description: Description of process.
        :paramtype description: str
        """
        super().__init__(kind=kind, **kwargs)
        self.identifier = None
        self.deployment_name = deployment_name
        self.href = href
        self.minidump = minidump
        self.is_profile_running = is_profile_running
        self.is_iis_profile_running = is_iis_profile_running
        self.iis_profile_timeout_in_seconds = iis_profile_timeout_in_seconds
        self.parent = parent
        self.children = children
        self.threads = threads
        self.open_file_handles = open_file_handles
        self.modules = modules
        self.file_name = file_name
        self.command_line = command_line
        self.user_name = user_name
        self.handle_count = handle_count
        self.module_count = module_count
        self.thread_count = thread_count
        self.start_time = start_time
        self.total_cpu_time = total_cpu_time
        self.user_cpu_time = user_cpu_time
        self.privileged_cpu_time = privileged_cpu_time
        self.working_set = working_set
        self.peak_working_set = peak_working_set
        self.private_memory = private_memory
        self.virtual_memory = virtual_memory
        self.peak_virtual_memory = peak_virtual_memory
        self.paged_system_memory = paged_system_memory
        self.non_paged_system_memory = non_paged_system_memory
        self.paged_memory = paged_memory
        self.peak_paged_memory = peak_paged_memory
        self.time_stamp = time_stamp
        self.environment_variables = environment_variables
        self.is_scm_site = is_scm_site
        self.is_webjob = is_webjob
        self.description = description


class ProcessInfoCollection(_serialization.Model):
    """Collection of Kudu process information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ProcessInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProcessInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ProcessInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ProcessInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessModuleInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Process Module Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar base_address: Base address. Used as module identifier in ARM resource URI.
    :vartype base_address: str
    :ivar file_name: File name.
    :vartype file_name: str
    :ivar href: HRef URI.
    :vartype href: str
    :ivar file_path: File path.
    :vartype file_path: str
    :ivar module_memory_size: Module memory size.
    :vartype module_memory_size: int
    :ivar file_version: File version.
    :vartype file_version: str
    :ivar file_description: File description.
    :vartype file_description: str
    :ivar product: Product name.
    :vartype product: str
    :ivar product_version: Product version.
    :vartype product_version: str
    :ivar is_debug: Is debug?.
    :vartype is_debug: bool
    :ivar language: Module language (locale).
    :vartype language: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "base_address": {"key": "properties.base_address", "type": "str"},
        "file_name": {"key": "properties.file_name", "type": "str"},
        "href": {"key": "properties.href", "type": "str"},
        "file_path": {"key": "properties.file_path", "type": "str"},
        "module_memory_size": {"key": "properties.module_memory_size", "type": "int"},
        "file_version": {"key": "properties.file_version", "type": "str"},
        "file_description": {"key": "properties.file_description", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "product_version": {"key": "properties.product_version", "type": "str"},
        "is_debug": {"key": "properties.is_debug", "type": "bool"},
        "language": {"key": "properties.language", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        base_address: Optional[str] = None,
        file_name: Optional[str] = None,
        href: Optional[str] = None,
        file_path: Optional[str] = None,
        module_memory_size: Optional[int] = None,
        file_version: Optional[str] = None,
        file_description: Optional[str] = None,
        product: Optional[str] = None,
        product_version: Optional[str] = None,
        is_debug: Optional[bool] = None,
        language: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword base_address: Base address. Used as module identifier in ARM resource URI.
        :paramtype base_address: str
        :keyword file_name: File name.
        :paramtype file_name: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword file_path: File path.
        :paramtype file_path: str
        :keyword module_memory_size: Module memory size.
        :paramtype module_memory_size: int
        :keyword file_version: File version.
        :paramtype file_version: str
        :keyword file_description: File description.
        :paramtype file_description: str
        :keyword product: Product name.
        :paramtype product: str
        :keyword product_version: Product version.
        :paramtype product_version: str
        :keyword is_debug: Is debug?.
        :paramtype is_debug: bool
        :keyword language: Module language (locale).
        :paramtype language: str
        """
        super().__init__(kind=kind, **kwargs)
        self.base_address = base_address
        self.file_name = file_name
        self.href = href
        self.file_path = file_path
        self.module_memory_size = module_memory_size
        self.file_version = file_version
        self.file_description = file_description
        self.product = product
        self.product_version = product_version
        self.is_debug = is_debug
        self.language = language


class ProcessModuleInfoCollection(_serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ProcessModuleInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProcessModuleInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ProcessModuleInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ProcessModuleInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessThreadInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Process Thread Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: Site extension ID.
    :vartype identifier: int
    :ivar href: HRef URI.
    :vartype href: str
    :ivar process: Process URI.
    :vartype process: str
    :ivar start_address: Start address.
    :vartype start_address: str
    :ivar current_priority: Current thread priority.
    :vartype current_priority: int
    :ivar priority_level: Thread priority level.
    :vartype priority_level: str
    :ivar base_priority: Base priority.
    :vartype base_priority: int
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar total_processor_time: Total processor time.
    :vartype total_processor_time: str
    :ivar user_processor_time: User processor time.
    :vartype user_processor_time: str
    :ivar state: Thread state.
    :vartype state: str
    :ivar wait_reason: Wait reason.
    :vartype wait_reason: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "identifier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "int"},
        "href": {"key": "properties.href", "type": "str"},
        "process": {"key": "properties.process", "type": "str"},
        "start_address": {"key": "properties.start_address", "type": "str"},
        "current_priority": {"key": "properties.current_priority", "type": "int"},
        "priority_level": {"key": "properties.priority_level", "type": "str"},
        "base_priority": {"key": "properties.base_priority", "type": "int"},
        "start_time": {"key": "properties.start_time", "type": "iso-8601"},
        "total_processor_time": {"key": "properties.total_processor_time", "type": "str"},
        "user_processor_time": {"key": "properties.user_processor_time", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "wait_reason": {"key": "properties.wait_reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        href: Optional[str] = None,
        process: Optional[str] = None,
        start_address: Optional[str] = None,
        current_priority: Optional[int] = None,
        priority_level: Optional[str] = None,
        base_priority: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_processor_time: Optional[str] = None,
        user_processor_time: Optional[str] = None,
        state: Optional[str] = None,
        wait_reason: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword process: Process URI.
        :paramtype process: str
        :keyword start_address: Start address.
        :paramtype start_address: str
        :keyword current_priority: Current thread priority.
        :paramtype current_priority: int
        :keyword priority_level: Thread priority level.
        :paramtype priority_level: str
        :keyword base_priority: Base priority.
        :paramtype base_priority: int
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword total_processor_time: Total processor time.
        :paramtype total_processor_time: str
        :keyword user_processor_time: User processor time.
        :paramtype user_processor_time: str
        :keyword state: Thread state.
        :paramtype state: str
        :keyword wait_reason: Wait reason.
        :paramtype wait_reason: str
        """
        super().__init__(kind=kind, **kwargs)
        self.identifier = None
        self.href = href
        self.process = process
        self.start_address = start_address
        self.current_priority = current_priority
        self.priority_level = priority_level
        self.base_priority = base_priority
        self.start_time = start_time
        self.total_processor_time = total_processor_time
        self.user_processor_time = user_processor_time
        self.state = state
        self.wait_reason = wait_reason


class ProcessThreadInfoCollection(_serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ProcessThreadInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProcessThreadInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ProcessThreadInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ProcessThreadInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PublicCertificate(ProxyOnlyResource):
    """Public certificate object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar blob: Public Certificate byte array.
    :vartype blob: bytes
    :ivar public_certificate_location: Public Certificate Location. Known values are:
     "CurrentUserMy", "LocalMachineMy", and "Unknown".
    :vartype public_certificate_location: str or
     ~azure.mgmt.web.v2023_01_01.models.PublicCertificateLocation
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "thumbprint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "blob": {"key": "properties.blob", "type": "bytearray"},
        "public_certificate_location": {"key": "properties.publicCertificateLocation", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        blob: Optional[bytes] = None,
        public_certificate_location: Optional[Union[str, "_models.PublicCertificateLocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword blob: Public Certificate byte array.
        :paramtype blob: bytes
        :keyword public_certificate_location: Public Certificate Location. Known values are:
         "CurrentUserMy", "LocalMachineMy", and "Unknown".
        :paramtype public_certificate_location: str or
         ~azure.mgmt.web.v2023_01_01.models.PublicCertificateLocation
        """
        super().__init__(kind=kind, **kwargs)
        self.blob = blob
        self.public_certificate_location = public_certificate_location
        self.thumbprint = None


class PublicCertificateCollection(_serialization.Model):
    """Collection of public certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.PublicCertificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PublicCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.PublicCertificate"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.PublicCertificate]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PublishingCredentialsPoliciesCollection(_serialization.Model):
    """Publishing Credentials Policies entity collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.CsmPublishingCredentialsPoliciesEntity]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmPublishingCredentialsPoliciesEntity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmPublishingCredentialsPoliciesEntity"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value:
         list[~azure.mgmt.web.v2023_01_01.models.CsmPublishingCredentialsPoliciesEntity]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :vartype is_push_enabled: bool
    :ivar tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
     whitelisted for use by the push registration endpoint.
    :vartype tag_whitelist_json: str
    :ivar tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :vartype tags_requiring_auth: str
    :ivar dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will
     be evaluated from user claims in the push registration endpoint.
    :vartype dynamic_tags_json: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_push_enabled": {"key": "properties.isPushEnabled", "type": "bool"},
        "tag_whitelist_json": {"key": "properties.tagWhitelistJson", "type": "str"},
        "tags_requiring_auth": {"key": "properties.tagsRequiringAuth", "type": "str"},
        "dynamic_tags_json": {"key": "properties.dynamicTagsJson", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        is_push_enabled: Optional[bool] = None,
        tag_whitelist_json: Optional[str] = None,
        tags_requiring_auth: Optional[str] = None,
        dynamic_tags_json: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :paramtype is_push_enabled: bool
        :keyword tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
         whitelisted for use by the push registration endpoint.
        :paramtype tag_whitelist_json: str
        :keyword tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
         user authentication to be used in the push registration endpoint.
         Tags can consist of alphanumeric characters and the following:
         '_', '@', '#', '.', ':', '-'.
         Validation should be performed at the PushRequestHandler.
        :paramtype tags_requiring_auth: str
        :keyword dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
         will be evaluated from user claims in the push registration endpoint.
        :paramtype dynamic_tags_json: str
        """
        super().__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class QueryUtterancesResult(_serialization.Model):
    """Result for utterances query.

    :ivar sample_utterance: A sample utterance.
    :vartype sample_utterance: ~azure.mgmt.web.v2023_01_01.models.SampleUtterance
    :ivar score: Score of a sample utterance.
    :vartype score: float
    """

    _attribute_map = {
        "sample_utterance": {"key": "sampleUtterance", "type": "SampleUtterance"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self,
        *,
        sample_utterance: Optional["_models.SampleUtterance"] = None,
        score: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sample_utterance: A sample utterance.
        :paramtype sample_utterance: ~azure.mgmt.web.v2023_01_01.models.SampleUtterance
        :keyword score: Score of a sample utterance.
        :paramtype score: float
        """
        super().__init__(**kwargs)
        self.sample_utterance = sample_utterance
        self.score = score


class QueryUtterancesResults(_serialization.Model):
    """Suggested utterances where the detector can be applicable.

    :ivar query: Search Query.
    :vartype query: str
    :ivar results: Array of utterance results for search query.
    :vartype results: list[~azure.mgmt.web.v2023_01_01.models.QueryUtterancesResult]
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "results": {"key": "results", "type": "[QueryUtterancesResult]"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        results: Optional[List["_models.QueryUtterancesResult"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query: Search Query.
        :paramtype query: str
        :keyword results: Array of utterance results for search query.
        :paramtype results: list[~azure.mgmt.web.v2023_01_01.models.QueryUtterancesResult]
        """
        super().__init__(**kwargs)
        self.query = query
        self.results = results


class QueueScaleRule(_serialization.Model):
    """Container App container Azure Queue based scaling rule.

    :ivar queue_name: Queue name.
    :vartype queue_name: str
    :ivar queue_length: Queue length.
    :vartype queue_length: int
    :ivar auth: Authentication secrets for the queue scale rule.
    :vartype auth: list[~azure.mgmt.web.v2023_01_01.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "queue_name": {"key": "queueName", "type": "str"},
        "queue_length": {"key": "queueLength", "type": "int"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        queue_name: Optional[str] = None,
        queue_length: Optional[int] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword queue_name: Queue name.
        :paramtype queue_name: str
        :keyword queue_length: Queue length.
        :paramtype queue_length: int
        :keyword auth: Authentication secrets for the queue scale rule.
        :paramtype auth: list[~azure.mgmt.web.v2023_01_01.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.queue_name = queue_name
        self.queue_length = queue_length
        self.auth = auth


class RampUpRule(_serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or
    to gradually change routing % based on performance.

    :ivar action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :vartype action_host_name: str
    :ivar reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :vartype reroute_percentage: float
    :ivar change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     \\n:code:`<code>MinReroutePercentage</code>` or
     :code:`<code>MaxReroutePercentage</code>`. Site metrics are checked every N minutes specified
     in :code:`<code>ChangeIntervalInMinutes</code>`.\\nCustom decision algorithm
     can be provided in TiPCallback site extension which URL can be specified in
     :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :vartype change_step: float
    :ivar change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :vartype change_interval_in_minutes: int
    :ivar min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
    :vartype min_reroute_percentage: float
    :ivar max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
    :vartype max_reroute_percentage: float
    :ivar change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :vartype change_decision_callback_url: str
    :ivar name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :vartype name: str
    """

    _attribute_map = {
        "action_host_name": {"key": "actionHostName", "type": "str"},
        "reroute_percentage": {"key": "reroutePercentage", "type": "float"},
        "change_step": {"key": "changeStep", "type": "float"},
        "change_interval_in_minutes": {"key": "changeIntervalInMinutes", "type": "int"},
        "min_reroute_percentage": {"key": "minReroutePercentage", "type": "float"},
        "max_reroute_percentage": {"key": "maxReroutePercentage", "type": "float"},
        "change_decision_callback_url": {"key": "changeDecisionCallbackUrl", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_host_name: Optional[str] = None,
        reroute_percentage: Optional[float] = None,
        change_step: Optional[float] = None,
        change_interval_in_minutes: Optional[int] = None,
        min_reroute_percentage: Optional[float] = None,
        max_reroute_percentage: Optional[float] = None,
        change_decision_callback_url: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_host_name: Hostname of a slot to which the traffic will be redirected if
         decided to. E.g. myapp-stage.azurewebsites.net.
        :paramtype action_host_name: str
        :keyword reroute_percentage: Percentage of the traffic which will be redirected to
         :code:`<code>ActionHostName</code>`.
        :paramtype reroute_percentage: float
        :keyword change_step: In auto ramp up scenario this is the step to add/remove from
         :code:`<code>ReroutePercentage</code>` until it reaches
         \\n:code:`<code>MinReroutePercentage</code>` or
         :code:`<code>MaxReroutePercentage</code>`. Site metrics are checked every N minutes specified
         in :code:`<code>ChangeIntervalInMinutes</code>`.\\nCustom decision algorithm
         can be provided in TiPCallback site extension which URL can be specified in
         :code:`<code>ChangeDecisionCallbackUrl</code>`.
        :paramtype change_step: float
        :keyword change_interval_in_minutes: Specifies interval in minutes to reevaluate
         ReroutePercentage.
        :paramtype change_interval_in_minutes: int
        :keyword min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
         stay.
        :paramtype min_reroute_percentage: float
        :keyword max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
         stay.
        :paramtype max_reroute_percentage: float
        :keyword change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
         site extension which URL can be specified. See TiPCallback site extension for the scaffold and
         contracts.
         https://www.siteextensions.net/packages/TiPCallback/.
        :paramtype change_decision_callback_url: str
        :keyword name: Name of the routing rule. The recommended name would be to point to the slot
         which will receive the traffic in the experiment.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class Recommendation(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Represents a recommendation result generated by the recommendation engine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar creation_time: Timestamp when this instance was created.
    :vartype creation_time: ~datetime.datetime
    :ivar recommendation_id: A GUID value that each recommendation object is associated with.
    :vartype recommendation_id: str
    :ivar resource_id: Full ARM resource ID string that this recommendation object is associated
     with.
    :vartype resource_id: str
    :ivar resource_scope: Name of a resource type this recommendation applies, e.g. Subscription,
     ServerFarm, Site. Known values are: "ServerFarm", "Subscription", and "WebSite".
    :vartype resource_scope: str or ~azure.mgmt.web.v2023_01_01.models.ResourceScopeType
    :ivar rule_name: Unique name of the rule.
    :vartype rule_name: str
    :ivar display_name: UI friendly name of the rule (may not be unique).
    :vartype display_name: str
    :ivar message: Recommendation text.
    :vartype message: str
    :ivar level: Level indicating how critical this recommendation can impact. Known values are:
     "Critical", "Warning", "Information", and "NonUrgentSuggestion".
    :vartype level: str or ~azure.mgmt.web.v2023_01_01.models.NotificationLevel
    :ivar channels: List of channels that this recommendation can apply. Known values are:
     "Notification", "Api", "Email", "Webhook", and "All".
    :vartype channels: str or ~azure.mgmt.web.v2023_01_01.models.Channels
    :ivar category_tags: The list of category tags that this recommendation belongs to.
    :vartype category_tags: list[str]
    :ivar action_name: Name of action recommended by this object.
    :vartype action_name: str
    :ivar enabled: True if this recommendation is still valid (i.e. "actionable"). False if it is
     invalid.
    :vartype enabled: int
    :ivar states: The list of states of this recommendation. If it's null then it should be
     considered "Active".
    :vartype states: list[str]
    :ivar start_time: The beginning time in UTC of a range that the recommendation refers to.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time in UTC of a range that the recommendation refers to.
    :vartype end_time: ~datetime.datetime
    :ivar next_notification_time: When to notify this recommendation next in UTC. Null means that
     this will never be notified anymore.
    :vartype next_notification_time: ~datetime.datetime
    :ivar notification_expiration_time: Date and time in UTC when this notification expires.
    :vartype notification_expiration_time: ~datetime.datetime
    :ivar notified_time: Last timestamp in UTC this instance was actually notified. Null means that
     this recommendation hasn't been notified yet.
    :vartype notified_time: ~datetime.datetime
    :ivar score: A metric value measured by the rule.
    :vartype score: float
    :ivar is_dynamic: True if this is associated with a dynamically added rule.
    :vartype is_dynamic: bool
    :ivar extension_name: Extension name of the portal if exists.
    :vartype extension_name: str
    :ivar blade_name: Deep link to a blade on the portal.
    :vartype blade_name: str
    :ivar forward_link: Forward link to an external document associated with the rule.
    :vartype forward_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "category_tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "recommendation_id": {"key": "properties.recommendationId", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "resource_scope": {"key": "properties.resourceScope", "type": "str"},
        "rule_name": {"key": "properties.ruleName", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "channels": {"key": "properties.channels", "type": "str"},
        "category_tags": {"key": "properties.categoryTags", "type": "[str]"},
        "action_name": {"key": "properties.actionName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "int"},
        "states": {"key": "properties.states", "type": "[str]"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "next_notification_time": {"key": "properties.nextNotificationTime", "type": "iso-8601"},
        "notification_expiration_time": {"key": "properties.notificationExpirationTime", "type": "iso-8601"},
        "notified_time": {"key": "properties.notifiedTime", "type": "iso-8601"},
        "score": {"key": "properties.score", "type": "float"},
        "is_dynamic": {"key": "properties.isDynamic", "type": "bool"},
        "extension_name": {"key": "properties.extensionName", "type": "str"},
        "blade_name": {"key": "properties.bladeName", "type": "str"},
        "forward_link": {"key": "properties.forwardLink", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        recommendation_id: Optional[str] = None,
        resource_id: Optional[str] = None,
        resource_scope: Optional[Union[str, "_models.ResourceScopeType"]] = None,
        rule_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        level: Optional[Union[str, "_models.NotificationLevel"]] = None,
        channels: Optional[Union[str, "_models.Channels"]] = None,
        action_name: Optional[str] = None,
        enabled: Optional[int] = None,
        states: Optional[List[str]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        next_notification_time: Optional[datetime.datetime] = None,
        notification_expiration_time: Optional[datetime.datetime] = None,
        notified_time: Optional[datetime.datetime] = None,
        score: Optional[float] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword creation_time: Timestamp when this instance was created.
        :paramtype creation_time: ~datetime.datetime
        :keyword recommendation_id: A GUID value that each recommendation object is associated with.
        :paramtype recommendation_id: str
        :keyword resource_id: Full ARM resource ID string that this recommendation object is associated
         with.
        :paramtype resource_id: str
        :keyword resource_scope: Name of a resource type this recommendation applies, e.g.
         Subscription, ServerFarm, Site. Known values are: "ServerFarm", "Subscription", and "WebSite".
        :paramtype resource_scope: str or ~azure.mgmt.web.v2023_01_01.models.ResourceScopeType
        :keyword rule_name: Unique name of the rule.
        :paramtype rule_name: str
        :keyword display_name: UI friendly name of the rule (may not be unique).
        :paramtype display_name: str
        :keyword message: Recommendation text.
        :paramtype message: str
        :keyword level: Level indicating how critical this recommendation can impact. Known values are:
         "Critical", "Warning", "Information", and "NonUrgentSuggestion".
        :paramtype level: str or ~azure.mgmt.web.v2023_01_01.models.NotificationLevel
        :keyword channels: List of channels that this recommendation can apply. Known values are:
         "Notification", "Api", "Email", "Webhook", and "All".
        :paramtype channels: str or ~azure.mgmt.web.v2023_01_01.models.Channels
        :keyword action_name: Name of action recommended by this object.
        :paramtype action_name: str
        :keyword enabled: True if this recommendation is still valid (i.e. "actionable"). False if it
         is invalid.
        :paramtype enabled: int
        :keyword states: The list of states of this recommendation. If it's null then it should be
         considered "Active".
        :paramtype states: list[str]
        :keyword start_time: The beginning time in UTC of a range that the recommendation refers to.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time in UTC of a range that the recommendation refers to.
        :paramtype end_time: ~datetime.datetime
        :keyword next_notification_time: When to notify this recommendation next in UTC. Null means
         that this will never be notified anymore.
        :paramtype next_notification_time: ~datetime.datetime
        :keyword notification_expiration_time: Date and time in UTC when this notification expires.
        :paramtype notification_expiration_time: ~datetime.datetime
        :keyword notified_time: Last timestamp in UTC this instance was actually notified. Null means
         that this recommendation hasn't been notified yet.
        :paramtype notified_time: ~datetime.datetime
        :keyword score: A metric value measured by the rule.
        :paramtype score: float
        :keyword is_dynamic: True if this is associated with a dynamically added rule.
        :paramtype is_dynamic: bool
        :keyword extension_name: Extension name of the portal if exists.
        :paramtype extension_name: str
        :keyword blade_name: Deep link to a blade on the portal.
        :paramtype blade_name: str
        :keyword forward_link: Forward link to an external document associated with the rule.
        :paramtype forward_link: str
        """
        super().__init__(kind=kind, **kwargs)
        self.creation_time = creation_time
        self.recommendation_id = recommendation_id
        self.resource_id = resource_id
        self.resource_scope = resource_scope
        self.rule_name = rule_name
        self.display_name = display_name
        self.message = message
        self.level = level
        self.channels = channels
        self.category_tags = None
        self.action_name = action_name
        self.enabled = enabled
        self.states = states
        self.start_time = start_time
        self.end_time = end_time
        self.next_notification_time = next_notification_time
        self.notification_expiration_time = notification_expiration_time
        self.notified_time = notified_time
        self.score = score
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class RecommendationCollection(_serialization.Model):
    """Collection of recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.Recommendation]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Recommendation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Recommendation"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.Recommendation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RecommendationRule(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Represents a recommendation rule that the recommendation engine can perform.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar recommendation_name: Unique name of the rule.
    :vartype recommendation_name: str
    :ivar display_name: UI friendly name of the rule.
    :vartype display_name: str
    :ivar message: Localized name of the rule (Good for UI).
    :vartype message: str
    :ivar recommendation_id: Recommendation ID of an associated recommendation object tied to the
     rule, if exists.
     If such an object doesn't exist, it is set to null.
    :vartype recommendation_id: str
    :ivar description: Localized detailed description of the rule.
    :vartype description: str
    :ivar action_name: Name of action that is recommended by this rule in string.
    :vartype action_name: str
    :ivar level: Level of impact indicating how critical this rule is. Known values are:
     "Critical", "Warning", "Information", and "NonUrgentSuggestion".
    :vartype level: str or ~azure.mgmt.web.v2023_01_01.models.NotificationLevel
    :ivar channels: List of available channels that this rule applies. Known values are:
     "Notification", "Api", "Email", "Webhook", and "All".
    :vartype channels: str or ~azure.mgmt.web.v2023_01_01.models.Channels
    :ivar category_tags: The list of category tags that this recommendation rule belongs to.
    :vartype category_tags: list[str]
    :ivar is_dynamic: True if this is associated with a dynamically added rule.
    :vartype is_dynamic: bool
    :ivar extension_name: Extension name of the portal if exists. Applicable to dynamic rule only.
    :vartype extension_name: str
    :ivar blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
    :vartype blade_name: str
    :ivar forward_link: Forward link to an external document associated with the rule. Applicable
     to dynamic rule only.
    :vartype forward_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "category_tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "recommendation_name": {"key": "properties.recommendationName", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "recommendation_id": {"key": "properties.recommendationId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "action_name": {"key": "properties.actionName", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "channels": {"key": "properties.channels", "type": "str"},
        "category_tags": {"key": "properties.categoryTags", "type": "[str]"},
        "is_dynamic": {"key": "properties.isDynamic", "type": "bool"},
        "extension_name": {"key": "properties.extensionName", "type": "str"},
        "blade_name": {"key": "properties.bladeName", "type": "str"},
        "forward_link": {"key": "properties.forwardLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        recommendation_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        recommendation_id: Optional[str] = None,
        description: Optional[str] = None,
        action_name: Optional[str] = None,
        level: Optional[Union[str, "_models.NotificationLevel"]] = None,
        channels: Optional[Union[str, "_models.Channels"]] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword recommendation_name: Unique name of the rule.
        :paramtype recommendation_name: str
        :keyword display_name: UI friendly name of the rule.
        :paramtype display_name: str
        :keyword message: Localized name of the rule (Good for UI).
        :paramtype message: str
        :keyword recommendation_id: Recommendation ID of an associated recommendation object tied to
         the rule, if exists.
         If such an object doesn't exist, it is set to null.
        :paramtype recommendation_id: str
        :keyword description: Localized detailed description of the rule.
        :paramtype description: str
        :keyword action_name: Name of action that is recommended by this rule in string.
        :paramtype action_name: str
        :keyword level: Level of impact indicating how critical this rule is. Known values are:
         "Critical", "Warning", "Information", and "NonUrgentSuggestion".
        :paramtype level: str or ~azure.mgmt.web.v2023_01_01.models.NotificationLevel
        :keyword channels: List of available channels that this rule applies. Known values are:
         "Notification", "Api", "Email", "Webhook", and "All".
        :paramtype channels: str or ~azure.mgmt.web.v2023_01_01.models.Channels
        :keyword is_dynamic: True if this is associated with a dynamically added rule.
        :paramtype is_dynamic: bool
        :keyword extension_name: Extension name of the portal if exists. Applicable to dynamic rule
         only.
        :paramtype extension_name: str
        :keyword blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
        :paramtype blade_name: str
        :keyword forward_link: Forward link to an external document associated with the rule.
         Applicable to dynamic rule only.
        :paramtype forward_link: str
        """
        super().__init__(kind=kind, **kwargs)
        self.recommendation_name = recommendation_name
        self.display_name = display_name
        self.message = message
        self.recommendation_id = recommendation_id
        self.description = description
        self.action_name = action_name
        self.level = level
        self.channels = channels
        self.category_tags = None
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class RecurrenceSchedule(_serialization.Model):
    """The recurrence schedule.

    :ivar minutes: The minutes.
    :vartype minutes: list[int]
    :ivar hours: The hours.
    :vartype hours: list[int]
    :ivar week_days: The days of the week.
    :vartype week_days: list[str or ~azure.mgmt.web.v2023_01_01.models.DaysOfWeek]
    :ivar month_days: The month days.
    :vartype month_days: list[int]
    :ivar monthly_occurrences: The monthly occurrences.
    :vartype monthly_occurrences:
     list[~azure.mgmt.web.v2023_01_01.models.RecurrenceScheduleOccurrence]
    """

    _attribute_map = {
        "minutes": {"key": "minutes", "type": "[int]"},
        "hours": {"key": "hours", "type": "[int]"},
        "week_days": {"key": "weekDays", "type": "[str]"},
        "month_days": {"key": "monthDays", "type": "[int]"},
        "monthly_occurrences": {"key": "monthlyOccurrences", "type": "[RecurrenceScheduleOccurrence]"},
    }

    def __init__(
        self,
        *,
        minutes: Optional[List[int]] = None,
        hours: Optional[List[int]] = None,
        week_days: Optional[List[Union[str, "_models.DaysOfWeek"]]] = None,
        month_days: Optional[List[int]] = None,
        monthly_occurrences: Optional[List["_models.RecurrenceScheduleOccurrence"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minutes: The minutes.
        :paramtype minutes: list[int]
        :keyword hours: The hours.
        :paramtype hours: list[int]
        :keyword week_days: The days of the week.
        :paramtype week_days: list[str or ~azure.mgmt.web.v2023_01_01.models.DaysOfWeek]
        :keyword month_days: The month days.
        :paramtype month_days: list[int]
        :keyword monthly_occurrences: The monthly occurrences.
        :paramtype monthly_occurrences:
         list[~azure.mgmt.web.v2023_01_01.models.RecurrenceScheduleOccurrence]
        """
        super().__init__(**kwargs)
        self.minutes = minutes
        self.hours = hours
        self.week_days = week_days
        self.month_days = month_days
        self.monthly_occurrences = monthly_occurrences


class RecurrenceScheduleOccurrence(_serialization.Model):
    """The recurrence schedule occurrence.

    :ivar day: The day of the week. Known values are: "Sunday", "Monday", "Tuesday", "Wednesday",
     "Thursday", "Friday", and "Saturday".
    :vartype day: str or ~azure.mgmt.web.v2023_01_01.models.DayOfWeek
    :ivar occurrence: The occurrence.
    :vartype occurrence: int
    """

    _attribute_map = {
        "day": {"key": "day", "type": "str"},
        "occurrence": {"key": "occurrence", "type": "int"},
    }

    def __init__(
        self, *, day: Optional[Union[str, "_models.DayOfWeek"]] = None, occurrence: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword day: The day of the week. Known values are: "Sunday", "Monday", "Tuesday",
         "Wednesday", "Thursday", "Friday", and "Saturday".
        :paramtype day: str or ~azure.mgmt.web.v2023_01_01.models.DayOfWeek
        :keyword occurrence: The occurrence.
        :paramtype occurrence: int
        """
        super().__init__(**kwargs)
        self.day = day
        self.occurrence = occurrence


class RegenerateActionParameter(_serialization.Model):
    """The access key regenerate action content.

    :ivar key_type: The key type. Known values are: "NotSpecified", "Primary", and "Secondary".
    :vartype key_type: str or ~azure.mgmt.web.v2023_01_01.models.KeyType
    """

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
    }

    def __init__(self, *, key_type: Optional[Union[str, "_models.KeyType"]] = None, **kwargs: Any) -> None:
        """
        :keyword key_type: The key type. Known values are: "NotSpecified", "Primary", and "Secondary".
        :paramtype key_type: str or ~azure.mgmt.web.v2023_01_01.models.KeyType
        """
        super().__init__(**kwargs)
        self.key_type = key_type


class RegistryCredentials(_serialization.Model):
    """Container App Private Registry.

    :ivar server: Container Registry Server.
    :vartype server: str
    :ivar username: Container Registry Username.
    :vartype username: str
    :ivar password_secret_ref: The name of the Secret that contains the registry login password.
    :vartype password_secret_ref: str
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password_secret_ref": {"key": "passwordSecretRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        username: Optional[str] = None,
        password_secret_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server: Container Registry Server.
        :paramtype server: str
        :keyword username: Container Registry Username.
        :paramtype username: str
        :keyword password_secret_ref: The name of the Secret that contains the registry login password.
        :paramtype password_secret_ref: str
        """
        super().__init__(**kwargs)
        self.server = server
        self.username = username
        self.password_secret_ref = password_secret_ref


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after the
     new certificate is issued.
    :vartype delay_existing_revoke_in_hours: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "delay_existing_revoke_in_hours": {"key": "properties.delayExistingRevokeInHours", "type": "int"},
        "csr": {"key": "properties.csr", "type": "str"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        delay_existing_revoke_in_hours: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after
         the new certificate is issued.
        :paramtype delay_existing_revoke_in_hours: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.delay_existing_revoke_in_hours = delay_existing_revoke_in_hours
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RelayServiceConnectionEntity(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Hybrid Connection for an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entity_name:
    :vartype entity_name: str
    :ivar entity_connection_string:
    :vartype entity_connection_string: str
    :ivar resource_type:
    :vartype resource_type: str
    :ivar resource_connection_string:
    :vartype resource_connection_string: str
    :ivar hostname:
    :vartype hostname: str
    :ivar port:
    :vartype port: int
    :ivar biztalk_uri:
    :vartype biztalk_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "entity_name": {"key": "properties.entityName", "type": "str"},
        "entity_connection_string": {"key": "properties.entityConnectionString", "type": "str"},
        "resource_type": {"key": "properties.resourceType", "type": "str"},
        "resource_connection_string": {"key": "properties.resourceConnectionString", "type": "str"},
        "hostname": {"key": "properties.hostname", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "biztalk_uri": {"key": "properties.biztalkUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        entity_name: Optional[str] = None,
        entity_connection_string: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_connection_string: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        biztalk_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword entity_name:
        :paramtype entity_name: str
        :keyword entity_connection_string:
        :paramtype entity_connection_string: str
        :keyword resource_type:
        :paramtype resource_type: str
        :keyword resource_connection_string:
        :paramtype resource_connection_string: str
        :keyword hostname:
        :paramtype hostname: str
        :keyword port:
        :paramtype port: int
        :keyword biztalk_uri:
        :paramtype biztalk_uri: str
        """
        super().__init__(kind=kind, **kwargs)
        self.entity_name = entity_name
        self.entity_connection_string = entity_connection_string
        self.resource_type = resource_type
        self.resource_connection_string = resource_connection_string
        self.hostname = hostname
        self.port = port
        self.biztalk_uri = biztalk_uri


class RemotePrivateEndpointConnection(ProxyOnlyResource):
    """A remote private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :ivar private_endpoint: PrivateEndpoint of a remote private endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.web.v2023_01_01.models.ArmIdWrapper
    :ivar private_link_service_connection_state: The state of a private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.web.v2023_01_01.models.PrivateLinkConnectionState
    :ivar ip_addresses: Private IPAddresses mapped to the remote private endpoint.
    :vartype ip_addresses: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "ArmIdWrapper"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkConnectionState",
        },
        "ip_addresses": {"key": "properties.ipAddresses", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_endpoint: Optional["_models.ArmIdWrapper"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkConnectionState"] = None,
        ip_addresses: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword private_endpoint: PrivateEndpoint of a remote private endpoint connection.
        :paramtype private_endpoint: ~azure.mgmt.web.v2023_01_01.models.ArmIdWrapper
        :keyword private_link_service_connection_state: The state of a private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.web.v2023_01_01.models.PrivateLinkConnectionState
        :keyword ip_addresses: Private IPAddresses mapped to the remote private endpoint.
        :paramtype ip_addresses: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.ip_addresses = ip_addresses


class RemotePrivateEndpointConnectionARMResource(ProxyOnlyResource):  # pylint: disable=name-too-long
    """Remote Private Endpoint Connection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :ivar private_endpoint: PrivateEndpoint of a remote private endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.web.v2023_01_01.models.ArmIdWrapper
    :ivar private_link_service_connection_state: The state of a private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.web.v2023_01_01.models.PrivateLinkConnectionState
    :ivar ip_addresses: Private IPAddresses mapped to the remote private endpoint.
    :vartype ip_addresses: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "ArmIdWrapper"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkConnectionState",
        },
        "ip_addresses": {"key": "properties.ipAddresses", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_endpoint: Optional["_models.ArmIdWrapper"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkConnectionState"] = None,
        ip_addresses: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword private_endpoint: PrivateEndpoint of a remote private endpoint connection.
        :paramtype private_endpoint: ~azure.mgmt.web.v2023_01_01.models.ArmIdWrapper
        :keyword private_link_service_connection_state: The state of a private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.web.v2023_01_01.models.PrivateLinkConnectionState
        :keyword ip_addresses: Private IPAddresses mapped to the remote private endpoint.
        :paramtype ip_addresses: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.ip_addresses = ip_addresses


class Rendering(_serialization.Model):
    """Instructions for rendering the data.

    :ivar type: Rendering Type. Known values are: "NoGraph", "Table", "TimeSeries",
     "TimeSeriesPerInstance", "PieChart", "DataSummary", "Email", "Insights", "DynamicInsight",
     "Markdown", "Detector", "DropDown", "Card", "Solution", "Guage", "Form", "ChangeSets",
     "ChangeAnalysisOnboarding", "ChangesView", "AppInsight", "DependencyGraph", "DownTime",
     "SummaryCard", "SearchComponent", and "AppInsightEnablement".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.RenderingType
    :ivar title: Title of data.
    :vartype title: str
    :ivar description: Description of the data that will help it be interpreted.
    :vartype description: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RenderingType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Rendering Type. Known values are: "NoGraph", "Table", "TimeSeries",
         "TimeSeriesPerInstance", "PieChart", "DataSummary", "Email", "Insights", "DynamicInsight",
         "Markdown", "Detector", "DropDown", "Card", "Solution", "Guage", "Form", "ChangeSets",
         "ChangeAnalysisOnboarding", "ChangesView", "AppInsight", "DependencyGraph", "DownTime",
         "SummaryCard", "SearchComponent", and "AppInsightEnablement".
        :paramtype type: str or ~azure.mgmt.web.v2023_01_01.models.RenderingType
        :keyword title: Title of data.
        :paramtype title: str
        :keyword description: Description of the data that will help it be interpreted.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.title = title
        self.description = description


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "csr": {"key": "properties.csr", "type": "str"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RepetitionIndex(_serialization.Model):
    """The workflow run action repetition index.

    All required parameters must be populated in order to send to server.

    :ivar scope_name: The scope.
    :vartype scope_name: str
    :ivar item_index: The index. Required.
    :vartype item_index: int
    """

    _validation = {
        "item_index": {"required": True},
    }

    _attribute_map = {
        "scope_name": {"key": "scopeName", "type": "str"},
        "item_index": {"key": "itemIndex", "type": "int"},
    }

    def __init__(self, *, item_index: int, scope_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword scope_name: The scope.
        :paramtype scope_name: str
        :keyword item_index: The index. Required.
        :paramtype item_index: int
        """
        super().__init__(**kwargs)
        self.scope_name = scope_name
        self.item_index = item_index


class Request(_serialization.Model):
    """A request.

    :ivar headers: A list of all the headers attached to the request.
    :vartype headers: JSON
    :ivar uri: The destination for the request.
    :vartype uri: str
    :ivar method: The HTTP method used for the request.
    :vartype method: str
    """

    _attribute_map = {
        "headers": {"key": "headers", "type": "object"},
        "uri": {"key": "uri", "type": "str"},
        "method": {"key": "method", "type": "str"},
    }

    def __init__(
        self, *, headers: Optional[JSON] = None, uri: Optional[str] = None, method: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword headers: A list of all the headers attached to the request.
        :paramtype headers: JSON
        :keyword uri: The destination for the request.
        :paramtype uri: str
        :keyword method: The HTTP method used for the request.
        :paramtype method: str
        """
        super().__init__(**kwargs)
        self.headers = headers
        self.uri = uri
        self.method = method


class WorkflowResource(_serialization.Model):
    """The base resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class RequestHistory(WorkflowResource):
    """The request history.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The request history properties.
    :vartype properties: ~azure.mgmt.web.v2023_01_01.models.RequestHistoryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "RequestHistoryProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.RequestHistoryProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The resource location.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The request history properties.
        :paramtype properties: ~azure.mgmt.web.v2023_01_01.models.RequestHistoryProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class RequestHistoryListResult(_serialization.Model):
    """The list of workflow request histories.

    :ivar value: A list of workflow request histories.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.RequestHistory]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RequestHistory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RequestHistory"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of workflow request histories.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.RequestHistory]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RequestHistoryProperties(_serialization.Model):
    """The request history.

    :ivar start_time: The time the request started.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time the request ended.
    :vartype end_time: ~datetime.datetime
    :ivar request: The request.
    :vartype request: ~azure.mgmt.web.v2023_01_01.models.Request
    :ivar response: The response.
    :vartype response: ~azure.mgmt.web.v2023_01_01.models.Response
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "request": {"key": "request", "type": "Request"},
        "response": {"key": "response", "type": "Response"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        request: Optional["_models.Request"] = None,
        response: Optional["_models.Response"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: The time the request started.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The time the request ended.
        :paramtype end_time: ~datetime.datetime
        :keyword request: The request.
        :paramtype request: ~azure.mgmt.web.v2023_01_01.models.Request
        :keyword response: The response.
        :paramtype response: ~azure.mgmt.web.v2023_01_01.models.Response
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.request = request
        self.response = response


class RequestsBasedTrigger(_serialization.Model):
    """Trigger based on total requests.

    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(self, *, count: Optional[int] = None, time_interval: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceCollection(_serialization.Model):
    """Collection of resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[str]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List[str], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceConfig(_serialization.Model):
    """Function app resource requirements.

    :ivar cpu: Required CPU in cores, e.g. 0.5.
    :vartype cpu: float
    :ivar memory: Required memory, e.g. "1Gi".
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "float"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, cpu: Optional[float] = None, memory: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cpu: Required CPU in cores, e.g. 0.5.
        :paramtype cpu: float
        :keyword memory: Required memory, e.g. "1Gi".
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class ResourceHealthMetadata(ProxyOnlyResource):
    """Used for getting ResourceHealthCheck settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar category: The category that the resource matches in the RHC Policy File.
    :vartype category: str
    :ivar signal_availability: Is there a health signal for the resource.
    :vartype signal_availability: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "signal_availability": {"key": "properties.signalAvailability", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        category: Optional[str] = None,
        signal_availability: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword category: The category that the resource matches in the RHC Policy File.
        :paramtype category: str
        :keyword signal_availability: Is there a health signal for the resource.
        :paramtype signal_availability: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.category = category
        self.signal_availability = signal_availability


class ResourceHealthMetadataCollection(_serialization.Model):
    """Collection of resource health metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ResourceHealthMetadata]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceHealthMetadata]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceHealthMetadata"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ResourceHealthMetadata]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricAvailability(_serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        "time_grain": {"readonly": True},
        "retention": {"readonly": True},
    }

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2023_01_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "unit": {"readonly": True},
        "primary_aggregation_type": {"readonly": True},
        "metric_availabilities": {"readonly": True},
        "resource_uri": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "unit": {"key": "properties.unit", "type": "str"},
        "primary_aggregation_type": {"key": "properties.primaryAggregationType", "type": "str"},
        "metric_availabilities": {"key": "properties.metricAvailabilities", "type": "[ResourceMetricAvailability]"},
        "resource_uri": {"key": "properties.resourceUri", "type": "str"},
        "properties": {"key": "properties.properties", "type": "{str}"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.properties = None


class ResourceMetricDefinitionCollection(_serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceMetricDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceMetricDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ResourceMetricDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceNameAvailability(_serialization.Model):
    """Information regarding availability of a resource name.

    :ivar name_available: :code:`<code>true</code>` indicates name is valid and available.
     :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
    :vartype name_available: bool
    :ivar reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure App
     Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
     already in use and is therefore unavailable. Known values are: "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.web.v2023_01_01.models.InAvailabilityReasonType
    :ivar message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.InAvailabilityReasonType"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: :code:`<code>true</code>` indicates name is valid and available.
         :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
        :paramtype name_available: bool
        :keyword reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure
         App Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
         already in use and is therefore unavailable. Known values are: "Invalid" and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.web.v2023_01_01.models.InAvailabilityReasonType
        :keyword message: If reason == invalid, provide the user with the reason why the given name is
         invalid, and provide the resource naming requirements so that the user can select a valid name.
         If reason == AlreadyExists, explain that resource name is already in use, and direct them to
         select a different name.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class ResourceNameAvailabilityRequest(_serialization.Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to server.

    :ivar name: Resource name to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification. Required. Known values are: "Site", "Slot",
     "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
     "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers".
    :vartype type: str or ~azure.mgmt.web.v2023_01_01.models.CheckNameResourceTypes
    :ivar is_fqdn: Is fully qualified domain name.
    :vartype is_fqdn: bool
    :ivar environment_id: Azure Resource Manager ID of the customer's selected Container Apps
     Environment on which to host the Function app. This must be of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}.  # pylint: disable=line-too-long
    :vartype environment_id: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_fqdn": {"key": "isFqdn", "type": "bool"},
        "environment_id": {"key": "environmentId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.CheckNameResourceTypes"],
        is_fqdn: Optional[bool] = None,
        environment_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name to verify. Required.
        :paramtype name: str
        :keyword type: Resource type used for verification. Required. Known values are: "Site", "Slot",
         "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
         "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers".
        :paramtype type: str or ~azure.mgmt.web.v2023_01_01.models.CheckNameResourceTypes
        :keyword is_fqdn: Is fully qualified domain name.
        :paramtype is_fqdn: bool
        :keyword environment_id: Azure Resource Manager ID of the customer's selected Container Apps
         Environment on which to host the Function app. This must be of the form
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}.  # pylint: disable=line-too-long
        :paramtype environment_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.is_fqdn = is_fqdn
        self.environment_id = environment_id


class ResourceReference(_serialization.Model):
    """The resource reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class Response(_serialization.Model):
    """A response.

    :ivar headers: A list of all the headers attached to the response.
    :vartype headers: JSON
    :ivar status_code: The status code of the response.
    :vartype status_code: int
    :ivar body_link: Details on the location of the body content.
    :vartype body_link: ~azure.mgmt.web.v2023_01_01.models.ContentLink
    """

    _attribute_map = {
        "headers": {"key": "headers", "type": "object"},
        "status_code": {"key": "statusCode", "type": "int"},
        "body_link": {"key": "bodyLink", "type": "ContentLink"},
    }

    def __init__(
        self,
        *,
        headers: Optional[JSON] = None,
        status_code: Optional[int] = None,
        body_link: Optional["_models.ContentLink"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword headers: A list of all the headers attached to the response.
        :paramtype headers: JSON
        :keyword status_code: The status code of the response.
        :paramtype status_code: int
        :keyword body_link: Details on the location of the body content.
        :paramtype body_link: ~azure.mgmt.web.v2023_01_01.models.ContentLink
        """
        super().__init__(**kwargs)
        self.headers = headers
        self.status_code = status_code
        self.body_link = body_link


class ResponseMessageEnvelopeRemotePrivateEndpointConnection(
    _serialization.Model
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Message envelope that contains the common Azure resource manager properties and the resource
    provider specific content.

    :ivar id: Resource Id. Typically ID is populated only for responses to GET requests. Caller is
     responsible for passing in this
     value for GET requests only.
     For example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}.
    :vartype id: str
    :ivar name: Name of resource.
    :vartype name: str
    :ivar type: Type of resource e.g "Microsoft.Web/sites".
    :vartype type: str
    :ivar location: Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
    :vartype location: str
    :ivar tags: Tags associated with resource.
    :vartype tags: dict[str, str]
    :ivar plan: Azure resource manager plan.
    :vartype plan: ~azure.mgmt.web.v2023_01_01.models.ArmPlan
    :ivar properties: Resource specific properties.
    :vartype properties: ~azure.mgmt.web.v2023_01_01.models.RemotePrivateEndpointConnection
    :ivar sku: SKU description of the resource.
    :vartype sku: ~azure.mgmt.web.v2023_01_01.models.SkuDescription
    :ivar status: Azure-AsyncOperation Status info.
    :vartype status: str
    :ivar error: Azure-AsyncOperation Error info.
    :vartype error: ~azure.mgmt.web.v2023_01_01.models.ErrorEntity
    :ivar identity: MSI resource.
    :vartype identity: ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentity
    :ivar zones: Logical Availability Zones the service is hosted in.
    :vartype zones: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "ArmPlan"},
        "properties": {"key": "properties", "type": "RemotePrivateEndpointConnection"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorEntity"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.ArmPlan"] = None,
        properties: Optional["_models.RemotePrivateEndpointConnection"] = None,
        sku: Optional["_models.SkuDescription"] = None,
        status: Optional[str] = None,
        error: Optional["_models.ErrorEntity"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        zones: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id. Typically ID is populated only for responses to GET requests. Caller
         is responsible for passing in this
         value for GET requests only.
         For example:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}.
        :paramtype id: str
        :keyword name: Name of resource.
        :paramtype name: str
        :keyword type: Type of resource e.g "Microsoft.Web/sites".
        :paramtype type: str
        :keyword location: Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
        :paramtype location: str
        :keyword tags: Tags associated with resource.
        :paramtype tags: dict[str, str]
        :keyword plan: Azure resource manager plan.
        :paramtype plan: ~azure.mgmt.web.v2023_01_01.models.ArmPlan
        :keyword properties: Resource specific properties.
        :paramtype properties: ~azure.mgmt.web.v2023_01_01.models.RemotePrivateEndpointConnection
        :keyword sku: SKU description of the resource.
        :paramtype sku: ~azure.mgmt.web.v2023_01_01.models.SkuDescription
        :keyword status: Azure-AsyncOperation Status info.
        :paramtype status: str
        :keyword error: Azure-AsyncOperation Error info.
        :paramtype error: ~azure.mgmt.web.v2023_01_01.models.ErrorEntity
        :keyword identity: MSI resource.
        :paramtype identity: ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentity
        :keyword zones: Logical Availability Zones the service is hosted in.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.tags = tags
        self.plan = plan
        self.properties = properties
        self.sku = sku
        self.status = status
        self.error = error
        self.identity = identity
        self.zones = zones


class ResponseMetaData(_serialization.Model):
    """ResponseMetaData.

    :ivar data_source: Source of the Data.
    :vartype data_source: ~azure.mgmt.web.v2023_01_01.models.DataSource
    """

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "DataSource"},
    }

    def __init__(self, *, data_source: Optional["_models.DataSource"] = None, **kwargs: Any) -> None:
        """
        :keyword data_source: Source of the Data.
        :paramtype data_source: ~azure.mgmt.web.v2023_01_01.models.DataSource
        """
        super().__init__(**kwargs)
        self.data_source = data_source


class RestoreRequest(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Description of a restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar storage_account_url: SAS URL to the container.
    :vartype storage_account_url: str
    :ivar blob_name: Name of a blob which contains the backup.
    :vartype blob_name: str
    :ivar overwrite: :code:`<code>true</code>` if the restore operation can overwrite target app;
     otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to restore
     over an existing app.
    :vartype overwrite: bool
    :ivar site_name: Name of an app.
    :vartype site_name: str
    :ivar databases: Collection of databases which should be restored. This list has to match the
     list of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2023_01_01.models.DatabaseBackupSetting]
    :ivar ignore_conflicting_host_names: Changes a logic when restoring an app with custom domains.
     :code:`<code>true</code>` to remove custom domains automatically. If
     :code:`<code>false</code>`, custom domains are added to
     the app's object when it is being restored, but that might fail due to conflicts during the
     operation.
    :vartype ignore_conflicting_host_names: bool
    :ivar ignore_databases: Ignore the databases and only restore the site content.
    :vartype ignore_databases: bool
    :ivar app_service_plan: Specify app service plan that will own restored site.
    :vartype app_service_plan: str
    :ivar operation_type: Operation type. Known values are: "Default", "Clone", "Relocation",
     "Snapshot", and "CloudFS".
    :vartype operation_type: str or ~azure.mgmt.web.v2023_01_01.models.BackupRestoreOperationType
    :ivar adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
     should be set in new app; otherwise, :code:`<code>false</code>`.
    :vartype adjust_connection_strings: bool
    :ivar hosting_environment: App Service Environment name, if needed (only when restoring an app
     to an App Service Environment).
    :vartype hosting_environment: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "storage_account_url": {"key": "properties.storageAccountUrl", "type": "str"},
        "blob_name": {"key": "properties.blobName", "type": "str"},
        "overwrite": {"key": "properties.overwrite", "type": "bool"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "databases": {"key": "properties.databases", "type": "[DatabaseBackupSetting]"},
        "ignore_conflicting_host_names": {"key": "properties.ignoreConflictingHostNames", "type": "bool"},
        "ignore_databases": {"key": "properties.ignoreDatabases", "type": "bool"},
        "app_service_plan": {"key": "properties.appServicePlan", "type": "str"},
        "operation_type": {"key": "properties.operationType", "type": "str"},
        "adjust_connection_strings": {"key": "properties.adjustConnectionStrings", "type": "bool"},
        "hosting_environment": {"key": "properties.hostingEnvironment", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        storage_account_url: Optional[str] = None,
        blob_name: Optional[str] = None,
        overwrite: Optional[bool] = None,
        site_name: Optional[str] = None,
        databases: Optional[List["_models.DatabaseBackupSetting"]] = None,
        ignore_conflicting_host_names: bool = False,
        ignore_databases: bool = False,
        app_service_plan: Optional[str] = None,
        operation_type: Union[str, "_models.BackupRestoreOperationType"] = "Default",
        adjust_connection_strings: Optional[bool] = None,
        hosting_environment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword storage_account_url: SAS URL to the container.
        :paramtype storage_account_url: str
        :keyword blob_name: Name of a blob which contains the backup.
        :paramtype blob_name: str
        :keyword overwrite: :code:`<code>true</code>` if the restore operation can overwrite target
         app; otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to
         restore over an existing app.
        :paramtype overwrite: bool
        :keyword site_name: Name of an app.
        :paramtype site_name: str
        :keyword databases: Collection of databases which should be restored. This list has to match
         the list of databases included in the backup.
        :paramtype databases: list[~azure.mgmt.web.v2023_01_01.models.DatabaseBackupSetting]
        :keyword ignore_conflicting_host_names: Changes a logic when restoring an app with custom
         domains. :code:`<code>true</code>` to remove custom domains automatically. If
         :code:`<code>false</code>`, custom domains are added to
         the app's object when it is being restored, but that might fail due to conflicts during the
         operation.
        :paramtype ignore_conflicting_host_names: bool
        :keyword ignore_databases: Ignore the databases and only restore the site content.
        :paramtype ignore_databases: bool
        :keyword app_service_plan: Specify app service plan that will own restored site.
        :paramtype app_service_plan: str
        :keyword operation_type: Operation type. Known values are: "Default", "Clone", "Relocation",
         "Snapshot", and "CloudFS".
        :paramtype operation_type: str or ~azure.mgmt.web.v2023_01_01.models.BackupRestoreOperationType
        :keyword adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
         should be set in new app; otherwise, :code:`<code>false</code>`.
        :paramtype adjust_connection_strings: bool
        :keyword hosting_environment: App Service Environment name, if needed (only when restoring an
         app to an App Service Environment).
        :paramtype hosting_environment: str
        """
        super().__init__(kind=kind, **kwargs)
        self.storage_account_url = storage_account_url
        self.blob_name = blob_name
        self.overwrite = overwrite
        self.site_name = site_name
        self.databases = databases
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.ignore_databases = ignore_databases
        self.app_service_plan = app_service_plan
        self.operation_type = operation_type
        self.adjust_connection_strings = adjust_connection_strings
        self.hosting_environment = hosting_environment


class RetryHistory(_serialization.Model):
    """The retry history.

    :ivar start_time: Gets the start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Gets the end time.
    :vartype end_time: ~datetime.datetime
    :ivar code: Gets the status code.
    :vartype code: str
    :ivar client_request_id: Gets the client request Id.
    :vartype client_request_id: str
    :ivar service_request_id: Gets the service request Id.
    :vartype service_request_id: str
    :ivar error: Gets the error response.
    :vartype error: ~azure.mgmt.web.v2023_01_01.models.ErrorResponse
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "code": {"key": "code", "type": "str"},
        "client_request_id": {"key": "clientRequestId", "type": "str"},
        "service_request_id": {"key": "serviceRequestId", "type": "str"},
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        code: Optional[str] = None,
        client_request_id: Optional[str] = None,
        service_request_id: Optional[str] = None,
        error: Optional["_models.ErrorResponse"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Gets the start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Gets the end time.
        :paramtype end_time: ~datetime.datetime
        :keyword code: Gets the status code.
        :paramtype code: str
        :keyword client_request_id: Gets the client request Id.
        :paramtype client_request_id: str
        :keyword service_request_id: Gets the service request Id.
        :paramtype service_request_id: str
        :keyword error: Gets the error response.
        :paramtype error: ~azure.mgmt.web.v2023_01_01.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.code = code
        self.client_request_id = client_request_id
        self.service_request_id = service_request_id
        self.error = error


class Revision(Resource):  # pylint: disable=too-many-instance-attributes
    """Container App Revision.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar created_time: Timestamp describing when the revision was created
     by controller.
    :vartype created_time: ~datetime.datetime
    :ivar fqdn: Fully qualified domain name of the revision.
    :vartype fqdn: str
    :ivar template: Container App Revision Template with all possible settings and the
     defaults if user did not provide them. The defaults are populated
     as they were at the creation time.
    :vartype template: ~azure.mgmt.web.v2023_01_01.models.Template
    :ivar active: Boolean describing if the Revision is Active.
    :vartype active: bool
    :ivar replicas: Number of pods currently running for this revision.
    :vartype replicas: int
    :ivar traffic_weight: Traffic weight assigned to this revision.
    :vartype traffic_weight: int
    :ivar provisioning_error: Optional Field - Platform Error Message.
    :vartype provisioning_error: str
    :ivar health_state: Current health State of the revision. Known values are: "Healthy",
     "Unhealthy", and "None".
    :vartype health_state: str or ~azure.mgmt.web.v2023_01_01.models.RevisionHealthState
    :ivar provisioning_state: Current provisioning State of the revision. Known values are:
     "Provisioning", "Provisioned", "Failed", "Deprovisioning", and "Deprovisioned".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2023_01_01.models.RevisionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "created_time": {"readonly": True},
        "fqdn": {"readonly": True},
        "template": {"readonly": True},
        "active": {"readonly": True},
        "replicas": {"readonly": True},
        "traffic_weight": {"readonly": True},
        "provisioning_error": {"readonly": True},
        "health_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "template": {"key": "properties.template", "type": "Template"},
        "active": {"key": "properties.active", "type": "bool"},
        "replicas": {"key": "properties.replicas", "type": "int"},
        "traffic_weight": {"key": "properties.trafficWeight", "type": "int"},
        "provisioning_error": {"key": "properties.provisioningError", "type": "str"},
        "health_state": {"key": "properties.healthState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, location: str, kind: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.created_time = None
        self.fqdn = None
        self.template = None
        self.active = None
        self.replicas = None
        self.traffic_weight = None
        self.provisioning_error = None
        self.health_state = None
        self.provisioning_state = None


class RevisionCollection(_serialization.Model):
    """Container App Revisions collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.Revision]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Revision]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Revision"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.Revision]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RunCorrelation(_serialization.Model):
    """The correlation properties.

    :ivar client_tracking_id: The client tracking identifier.
    :vartype client_tracking_id: str
    :ivar client_keywords: The client keywords.
    :vartype client_keywords: list[str]
    """

    _attribute_map = {
        "client_tracking_id": {"key": "clientTrackingId", "type": "str"},
        "client_keywords": {"key": "clientKeywords", "type": "[str]"},
    }

    def __init__(
        self, *, client_tracking_id: Optional[str] = None, client_keywords: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword client_tracking_id: The client tracking identifier.
        :paramtype client_tracking_id: str
        :keyword client_keywords: The client keywords.
        :paramtype client_keywords: list[str]
        """
        super().__init__(**kwargs)
        self.client_tracking_id = client_tracking_id
        self.client_keywords = client_keywords


class RunActionCorrelation(RunCorrelation):
    """The workflow run action correlation properties.

    :ivar client_tracking_id: The client tracking identifier.
    :vartype client_tracking_id: str
    :ivar client_keywords: The client keywords.
    :vartype client_keywords: list[str]
    :ivar action_tracking_id: The action tracking identifier.
    :vartype action_tracking_id: str
    """

    _attribute_map = {
        "client_tracking_id": {"key": "clientTrackingId", "type": "str"},
        "client_keywords": {"key": "clientKeywords", "type": "[str]"},
        "action_tracking_id": {"key": "actionTrackingId", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_tracking_id: Optional[str] = None,
        client_keywords: Optional[List[str]] = None,
        action_tracking_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_tracking_id: The client tracking identifier.
        :paramtype client_tracking_id: str
        :keyword client_keywords: The client keywords.
        :paramtype client_keywords: list[str]
        :keyword action_tracking_id: The action tracking identifier.
        :paramtype action_tracking_id: str
        """
        super().__init__(client_tracking_id=client_tracking_id, client_keywords=client_keywords, **kwargs)
        self.action_tracking_id = action_tracking_id


class SampleUtterance(_serialization.Model):
    """Sample utterance.

    :ivar text: Text attribute of sample utterance.
    :vartype text: str
    :ivar links: Links attribute of sample utterance.
    :vartype links: list[str]
    :ivar qid: Question id of sample utterance (for stackoverflow questions titles).
    :vartype qid: str
    """

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "links": {"key": "links", "type": "[str]"},
        "qid": {"key": "qid", "type": "str"},
    }

    def __init__(
        self, *, text: Optional[str] = None, links: Optional[List[str]] = None, qid: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword text: Text attribute of sample utterance.
        :paramtype text: str
        :keyword links: Links attribute of sample utterance.
        :paramtype links: list[str]
        :keyword qid: Question id of sample utterance (for stackoverflow questions titles).
        :paramtype qid: str
        """
        super().__init__(**kwargs)
        self.text = text
        self.links = links
        self.qid = qid


class Scale(_serialization.Model):
    """Container App scaling configurations.

    :ivar min_replicas: Optional. Minimum number of container replicas.
    :vartype min_replicas: int
    :ivar max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
    :vartype max_replicas: int
    :ivar rules: Scaling rules.
    :vartype rules: list[~azure.mgmt.web.v2023_01_01.models.ScaleRule]
    """

    _attribute_map = {
        "min_replicas": {"key": "minReplicas", "type": "int"},
        "max_replicas": {"key": "maxReplicas", "type": "int"},
        "rules": {"key": "rules", "type": "[ScaleRule]"},
    }

    def __init__(
        self,
        *,
        min_replicas: Optional[int] = None,
        max_replicas: Optional[int] = None,
        rules: Optional[List["_models.ScaleRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_replicas: Optional. Minimum number of container replicas.
        :paramtype min_replicas: int
        :keyword max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not
         set.
        :paramtype max_replicas: int
        :keyword rules: Scaling rules.
        :paramtype rules: list[~azure.mgmt.web.v2023_01_01.models.ScaleRule]
        """
        super().__init__(**kwargs)
        self.min_replicas = min_replicas
        self.max_replicas = max_replicas
        self.rules = rules


class ScaleRule(_serialization.Model):
    """Container App container scaling rule.

    :ivar name: Scale Rule Name.
    :vartype name: str
    :ivar azure_queue: Azure Queue based scaling.
    :vartype azure_queue: ~azure.mgmt.web.v2023_01_01.models.QueueScaleRule
    :ivar custom: Custom scale rule.
    :vartype custom: ~azure.mgmt.web.v2023_01_01.models.CustomScaleRule
    :ivar http: HTTP requests based scaling.
    :vartype http: ~azure.mgmt.web.v2023_01_01.models.HttpScaleRule
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "azure_queue": {"key": "azureQueue", "type": "QueueScaleRule"},
        "custom": {"key": "custom", "type": "CustomScaleRule"},
        "http": {"key": "http", "type": "HttpScaleRule"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        azure_queue: Optional["_models.QueueScaleRule"] = None,
        custom: Optional["_models.CustomScaleRule"] = None,
        http: Optional["_models.HttpScaleRule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Scale Rule Name.
        :paramtype name: str
        :keyword azure_queue: Azure Queue based scaling.
        :paramtype azure_queue: ~azure.mgmt.web.v2023_01_01.models.QueueScaleRule
        :keyword custom: Custom scale rule.
        :paramtype custom: ~azure.mgmt.web.v2023_01_01.models.CustomScaleRule
        :keyword http: HTTP requests based scaling.
        :paramtype http: ~azure.mgmt.web.v2023_01_01.models.HttpScaleRule
        """
        super().__init__(**kwargs)
        self.name = name
        self.azure_queue = azure_queue
        self.custom = custom
        self.http = http


class ScaleRuleAuth(_serialization.Model):
    """Auth Secrets for Container App Scale Rule.

    :ivar secret_ref: Name of the Container App secret from which to pull the auth params.
    :vartype secret_ref: str
    :ivar trigger_parameter: Trigger Parameter that uses the secret.
    :vartype trigger_parameter: str
    """

    _attribute_map = {
        "secret_ref": {"key": "secretRef", "type": "str"},
        "trigger_parameter": {"key": "triggerParameter", "type": "str"},
    }

    def __init__(
        self, *, secret_ref: Optional[str] = None, trigger_parameter: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secret_ref: Name of the Container App secret from which to pull the auth params.
        :paramtype secret_ref: str
        :keyword trigger_parameter: Trigger Parameter that uses the secret.
        :paramtype trigger_parameter: str
        """
        super().__init__(**kwargs)
        self.secret_ref = secret_ref
        self.trigger_parameter = trigger_parameter


class Secret(_serialization.Model):
    """Container App Secret.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Secret Name.
        :paramtype name: str
        :keyword value: Secret Value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class SecretsCollection(_serialization.Model):
    """Container App Secrets Collection ARM resource.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.ContainerAppSecret]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ContainerAppSecret]"},
    }

    def __init__(self, *, value: List["_models.ContainerAppSecret"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.ContainerAppSecret]
        """
        super().__init__(**kwargs)
        self.value = value


class ServiceSpecification(_serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :ivar metric_specifications:
    :vartype metric_specifications: list[~azure.mgmt.web.v2023_01_01.models.MetricSpecification]
    :ivar log_specifications:
    :vartype log_specifications: list[~azure.mgmt.web.v2023_01_01.models.LogSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications:
        :paramtype metric_specifications: list[~azure.mgmt.web.v2023_01_01.models.MetricSpecification]
        :keyword log_specifications:
        :paramtype log_specifications: list[~azure.mgmt.web.v2023_01_01.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class Site(Resource):  # pylint: disable=too-many-instance-attributes
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentity
    :ivar extended_location: Extended Location.
    :vartype extended_location: ~azure.mgmt.web.v2023_01_01.models.ExtendedLocation
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal" and "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2023_01_01.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", and "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2023_01_01.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2023_01_01.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".  # pylint: disable=line-too-long
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: Hyper-V sandbox.
    :vartype is_xenon: bool
    :ivar hyper_v: Hyper-V sandbox.
    :vartype hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
     traffic to have Virtual Network Security Groups and User Defined Routes applied.
    :vartype vnet_route_all_enabled: bool
    :ivar vnet_image_pull_enabled: To enable pulling image over Virtual Network.
    :vartype vnet_image_pull_enabled: bool
    :ivar vnet_content_share_enabled: To enable accessing content over virtual network.
    :vartype vnet_content_share_enabled: bool
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2023_01_01.models.SiteConfig
    :ivar dapr_config: Dapr configuration of the app.
    :vartype dapr_config: ~azure.mgmt.web.v2023_01_01.models.DaprConfig
    :ivar workload_profile_name: Workload profile name for function app to execute on.
    :vartype workload_profile_name: str
    :ivar resource_config: Function app resource requirements.
    :vartype resource_config: ~azure.mgmt.web.v2023_01_01.models.ResourceConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar client_cert_mode: This composes with ClientCertEnabled setting.


     * ClientCertEnabled: false means ClientCert is ignored.
     * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
     accepted. Known values are: "Required", "Optional", and "OptionalInteractiveUser".
    :vartype client_cert_mode: str or ~azure.mgmt.web.v2023_01_01.models.ClientCertMode
    :ivar client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :vartype client_cert_exclusion_paths: str
    :ivar end_to_end_encryption_enabled: Whether to use end to end encryption between the FrontEnd
     and the Worker.
    :vartype end_to_end_encryption_enabled: bool
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar custom_domain_verification_id: Unique identifier that verifies the custom domains
     assigned to the app. Customer will add this id to a txt record for verification.
    :vartype custom_domain_verification_id: str
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2023_01_01.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2023_01_01.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    :ivar redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
     "ActiveActive", and "GeoRedundant".
    :vartype redundancy_mode: str or ~azure.mgmt.web.v2023_01_01.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :ivar public_network_access: Property to allow or block all public traffic. Allowed Values:
     'Enabled', 'Disabled' or an empty string.
    :vartype public_network_access: str
    :ivar storage_account_required: Checks if Customer provided storage account is required.
    :vartype storage_account_required: bool
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet to
     be joined by Regional VNET Integration.
     This must be of the form
     /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype virtual_network_subnet_id: str
    :ivar managed_environment_id: Azure Resource Manager ID of the customer's selected Managed
     Environment on which to host this app. This must be of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}.  # pylint: disable=line-too-long
    :vartype managed_environment_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "host_names": {"readonly": True},
        "repository_site_name": {"readonly": True},
        "usage_state": {"readonly": True},
        "enabled_host_names": {"readonly": True},
        "availability_state": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "traffic_manager_host_names": {"readonly": True},
        "target_swap_slot": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "possible_outbound_ip_addresses": {"readonly": True},
        "suspended_till": {"readonly": True},
        "max_number_of_workers": {"readonly": True},
        "resource_group": {"readonly": True},
        "is_default_container": {"readonly": True},
        "default_host_name": {"readonly": True},
        "slot_swap_status": {"readonly": True},
        "in_progress_operation_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "state": {"key": "properties.state", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "repository_site_name": {"key": "properties.repositorySiteName", "type": "str"},
        "usage_state": {"key": "properties.usageState", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "enabled_host_names": {"key": "properties.enabledHostNames", "type": "[str]"},
        "availability_state": {"key": "properties.availabilityState", "type": "str"},
        "host_name_ssl_states": {"key": "properties.hostNameSslStates", "type": "[HostNameSslState]"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "vnet_route_all_enabled": {"key": "properties.vnetRouteAllEnabled", "type": "bool"},
        "vnet_image_pull_enabled": {"key": "properties.vnetImagePullEnabled", "type": "bool"},
        "vnet_content_share_enabled": {"key": "properties.vnetContentShareEnabled", "type": "bool"},
        "site_config": {"key": "properties.siteConfig", "type": "SiteConfig"},
        "dapr_config": {"key": "properties.daprConfig", "type": "DaprConfig"},
        "workload_profile_name": {"key": "properties.workloadProfileName", "type": "str"},
        "resource_config": {"key": "properties.resourceConfig", "type": "ResourceConfig"},
        "traffic_manager_host_names": {"key": "properties.trafficManagerHostNames", "type": "[str]"},
        "scm_site_also_stopped": {"key": "properties.scmSiteAlsoStopped", "type": "bool"},
        "target_swap_slot": {"key": "properties.targetSwapSlot", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "client_affinity_enabled": {"key": "properties.clientAffinityEnabled", "type": "bool"},
        "client_cert_enabled": {"key": "properties.clientCertEnabled", "type": "bool"},
        "client_cert_mode": {"key": "properties.clientCertMode", "type": "str"},
        "client_cert_exclusion_paths": {"key": "properties.clientCertExclusionPaths", "type": "str"},
        "end_to_end_encryption_enabled": {"key": "properties.endToEndEncryptionEnabled", "type": "bool"},
        "host_names_disabled": {"key": "properties.hostNamesDisabled", "type": "bool"},
        "custom_domain_verification_id": {"key": "properties.customDomainVerificationId", "type": "str"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "str"},
        "possible_outbound_ip_addresses": {"key": "properties.possibleOutboundIpAddresses", "type": "str"},
        "container_size": {"key": "properties.containerSize", "type": "int"},
        "daily_memory_time_quota": {"key": "properties.dailyMemoryTimeQuota", "type": "int"},
        "suspended_till": {"key": "properties.suspendedTill", "type": "iso-8601"},
        "max_number_of_workers": {"key": "properties.maxNumberOfWorkers", "type": "int"},
        "cloning_info": {"key": "properties.cloningInfo", "type": "CloningInfo"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "is_default_container": {"key": "properties.isDefaultContainer", "type": "bool"},
        "default_host_name": {"key": "properties.defaultHostName", "type": "str"},
        "slot_swap_status": {"key": "properties.slotSwapStatus", "type": "SlotSwapStatus"},
        "https_only": {"key": "properties.httpsOnly", "type": "bool"},
        "redundancy_mode": {"key": "properties.redundancyMode", "type": "str"},
        "in_progress_operation_id": {"key": "properties.inProgressOperationId", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "storage_account_required": {"key": "properties.storageAccountRequired", "type": "bool"},
        "key_vault_reference_identity": {"key": "properties.keyVaultReferenceIdentity", "type": "str"},
        "virtual_network_subnet_id": {"key": "properties.virtualNetworkSubnetId", "type": "str"},
        "managed_environment_id": {"key": "properties.managedEnvironmentId", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        vnet_route_all_enabled: Optional[bool] = None,
        vnet_image_pull_enabled: Optional[bool] = None,
        vnet_content_share_enabled: Optional[bool] = None,
        site_config: Optional["_models.SiteConfig"] = None,
        dapr_config: Optional["_models.DaprConfig"] = None,
        workload_profile_name: Optional[str] = None,
        resource_config: Optional["_models.ResourceConfig"] = None,
        scm_site_also_stopped: bool = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_mode: Optional[Union[str, "_models.ClientCertMode"]] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        end_to_end_encryption_enabled: Optional[bool] = None,
        host_names_disabled: Optional[bool] = None,
        custom_domain_verification_id: Optional[str] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "_models.RedundancyMode"]] = None,
        public_network_access: Optional[str] = None,
        storage_account_required: Optional[bool] = None,
        key_vault_reference_identity: Optional[str] = None,
        virtual_network_subnet_id: Optional[str] = None,
        managed_environment_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentity
        :keyword extended_location: Extended Location.
        :paramtype extended_location: ~azure.mgmt.web.v2023_01_01.models.ExtendedLocation
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2023_01_01.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".  # pylint: disable=line-too-long
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: Hyper-V sandbox.
        :paramtype is_xenon: bool
        :keyword hyper_v: Hyper-V sandbox.
        :paramtype hyper_v: bool
        :keyword vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
         traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :paramtype vnet_route_all_enabled: bool
        :keyword vnet_image_pull_enabled: To enable pulling image over Virtual Network.
        :paramtype vnet_image_pull_enabled: bool
        :keyword vnet_content_share_enabled: To enable accessing content over virtual network.
        :paramtype vnet_content_share_enabled: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2023_01_01.models.SiteConfig
        :keyword dapr_config: Dapr configuration of the app.
        :paramtype dapr_config: ~azure.mgmt.web.v2023_01_01.models.DaprConfig
        :keyword workload_profile_name: Workload profile name for function app to execute on.
        :paramtype workload_profile_name: str
        :keyword resource_config: Function app resource requirements.
        :paramtype resource_config: ~azure.mgmt.web.v2023_01_01.models.ResourceConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword client_cert_mode: This composes with ClientCertEnabled setting.


         * ClientCertEnabled: false means ClientCert is ignored.
         * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
         * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
         accepted. Known values are: "Required", "Optional", and "OptionalInteractiveUser".
        :paramtype client_cert_mode: str or ~azure.mgmt.web.v2023_01_01.models.ClientCertMode
        :keyword client_cert_exclusion_paths: client certificate authentication comma-separated
         exclusion paths.
        :paramtype client_cert_exclusion_paths: str
        :keyword end_to_end_encryption_enabled: Whether to use end to end encryption between the
         FrontEnd and the Worker.
        :paramtype end_to_end_encryption_enabled: bool
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword custom_domain_verification_id: Unique identifier that verifies the custom domains
         assigned to the app. Customer will add this id to a txt record for verification.
        :paramtype custom_domain_verification_id: str
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2023_01_01.models.CloningInfo
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        :keyword redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
         "ActiveActive", and "GeoRedundant".
        :paramtype redundancy_mode: str or ~azure.mgmt.web.v2023_01_01.models.RedundancyMode
        :keyword public_network_access: Property to allow or block all public traffic. Allowed Values:
         'Enabled', 'Disabled' or an empty string.
        :paramtype public_network_access: str
        :keyword storage_account_required: Checks if Customer provided storage account is required.
        :paramtype storage_account_required: bool
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet
         to be joined by Regional VNET Integration.
         This must be of the form
         /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype virtual_network_subnet_id: str
        :keyword managed_environment_id: Azure Resource Manager ID of the customer's selected Managed
         Environment on which to host this app. This must be of the form
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}.  # pylint: disable=line-too-long
        :paramtype managed_environment_id: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.extended_location = extended_location
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc = None
        self.vnet_route_all_enabled = vnet_route_all_enabled
        self.vnet_image_pull_enabled = vnet_image_pull_enabled
        self.vnet_content_share_enabled = vnet_content_share_enabled
        self.site_config = site_config
        self.dapr_config = dapr_config
        self.workload_profile_name = workload_profile_name
        self.resource_config = resource_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_mode = client_cert_mode
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.end_to_end_encryption_enabled = end_to_end_encryption_enabled
        self.host_names_disabled = host_names_disabled
        self.custom_domain_verification_id = custom_domain_verification_id
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id = None
        self.public_network_access = public_network_access
        self.storage_account_required = storage_account_required
        self.key_vault_reference_identity = key_vault_reference_identity
        self.virtual_network_subnet_id = virtual_network_subnet_id
        self.managed_environment_id = managed_environment_id


class SiteAuthSettings(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Configuration settings for the Azure App Service Authentication / Authorization feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :vartype runtime_version: str
    :ivar unauthenticated_client_action: The action to take when an unauthenticated client attempts
     to access the app. Known values are: "RedirectToLoginPage" and "AllowAnonymous".
    :vartype unauthenticated_client_action: str or
     ~azure.mgmt.web.v2023_01_01.models.UnauthenticatedClientAction
    :ivar token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
     security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :vartype token_store_enabled: bool
    :ivar allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :vartype allowed_external_redirect_urls: list[str]
    :ivar default_provider: The default authentication provider to use when multiple providers are
     configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage". Known values are: "AzureActiveDirectory", "Facebook",
     "Google", "MicrosoftAccount", "Twitter", and "Github".
    :vartype default_provider: str or
     ~azure.mgmt.web.v2023_01_01.models.BuiltInAuthenticationProvider
    :ivar token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :vartype token_refresh_extension_hours: float
    :ivar client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_id: str
    :ivar client_secret: The Client Secret of this relying party application (in Azure Active
     Directory, this is also referred to as the Key).
     This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
     flow is used to authenticate end users.
     Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_secret: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret of the
     relying party application.
    :vartype client_secret_setting_name: str
    :ivar client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :vartype client_secret_certificate_thumbprint: str
    :ivar issuer: The OpenID Connect Issuer URI that represents the entity which issues access
     tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://sts.windows.net/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :vartype issuer: str
    :ivar validate_issuer: Gets a value indicating whether the issuer should be a valid HTTPS url
     and be validated as such.
    :vartype validate_issuer: bool
    :ivar allowed_audiences: Allowed audience values to consider when validating JSON Web Tokens
     issued by
     Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
     an
     allowed audience, regardless of this setting.
    :vartype allowed_audiences: list[str]
    :ivar additional_login_params: Login parameters to send to the OpenID Connect authorization
     endpoint when
     a user logs in. Each parameter must be in the form "key=value".
    :vartype additional_login_params: list[str]
    :ivar aad_claims_authorization: Gets a JSON string containing the Azure AD Acl settings.
    :vartype aad_claims_authorization: str
    :ivar google_client_id: The OpenID Connect Client ID for the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_client_id: str
    :ivar google_client_secret: The client secret associated with the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_client_secret: str
    :ivar google_client_secret_setting_name: The app setting name that contains the client secret
     associated with
     the Google web application.
    :vartype google_client_secret_setting_name: str
    :ivar google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
     Sign-In authentication.
     This setting is optional. If not specified, "openid", "profile", and "email" are used as
     default scopes.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_o_auth_scopes: list[str]
    :ivar facebook_app_id: The App ID of the Facebook app used for login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_app_id: str
    :ivar facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_app_secret: str
    :ivar facebook_app_secret_setting_name: The app setting name that contains the app secret used
     for Facebook Login.
    :vartype facebook_app_secret_setting_name: str
    :ivar facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Facebook
     Login authentication.
     This setting is optional.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_o_auth_scopes: list[str]
    :ivar git_hub_client_id: The Client Id of the GitHub app used for login.
     This setting is required for enabling Github login.
    :vartype git_hub_client_id: str
    :ivar git_hub_client_secret: The Client Secret of the GitHub app used for Github Login.
     This setting is required for enabling Github login.
    :vartype git_hub_client_secret: str
    :ivar git_hub_client_secret_setting_name: The app setting name that contains the client secret
     of the Github
     app used for GitHub Login.
    :vartype git_hub_client_secret_setting_name: str
    :ivar git_hub_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of GitHub
     Login authentication.
     This setting is optional.
    :vartype git_hub_o_auth_scopes: list[str]
    :ivar twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
     sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype twitter_consumer_key: str
    :ivar twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application used
     for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype twitter_consumer_secret: str
    :ivar twitter_consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a
     consumer secret of the Twitter
     application used for sign-in.
    :vartype twitter_consumer_secret_setting_name: str
    :ivar microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
     for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :vartype microsoft_account_client_id: str
    :ivar microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the app
     used for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :vartype microsoft_account_client_secret: str
    :ivar microsoft_account_client_secret_setting_name: The app setting name containing the OAuth
     2.0 client secret that was created for the
     app used for authentication.
    :vartype microsoft_account_client_secret_setting_name: str
    :ivar microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
     Microsoft Account authentication.
     This setting is optional. If not specified, "wl.basic" is used as the default scope.
     Microsoft Account Scopes and permissions documentation:
     https://msdn.microsoft.com/en-us/library/dn631845.aspx.
    :vartype microsoft_account_o_auth_scopes: list[str]
    :ivar is_auth_from_file: "true" if the auth config settings should be read from a file,
     "false" otherwise.
    :vartype is_auth_from_file: str
    :ivar auth_file_path: The path of the config file containing auth settings.
     If the path is relative, base will the site's root directory.
    :vartype auth_file_path: str
    :ivar config_version: The ConfigVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of the control plane for Authentication /
     Authorization.
    :vartype config_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "runtime_version": {"key": "properties.runtimeVersion", "type": "str"},
        "unauthenticated_client_action": {"key": "properties.unauthenticatedClientAction", "type": "str"},
        "token_store_enabled": {"key": "properties.tokenStoreEnabled", "type": "bool"},
        "allowed_external_redirect_urls": {"key": "properties.allowedExternalRedirectUrls", "type": "[str]"},
        "default_provider": {"key": "properties.defaultProvider", "type": "str"},
        "token_refresh_extension_hours": {"key": "properties.tokenRefreshExtensionHours", "type": "float"},
        "client_id": {"key": "properties.clientId", "type": "str"},
        "client_secret": {"key": "properties.clientSecret", "type": "str"},
        "client_secret_setting_name": {"key": "properties.clientSecretSettingName", "type": "str"},
        "client_secret_certificate_thumbprint": {"key": "properties.clientSecretCertificateThumbprint", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "validate_issuer": {"key": "properties.validateIssuer", "type": "bool"},
        "allowed_audiences": {"key": "properties.allowedAudiences", "type": "[str]"},
        "additional_login_params": {"key": "properties.additionalLoginParams", "type": "[str]"},
        "aad_claims_authorization": {"key": "properties.aadClaimsAuthorization", "type": "str"},
        "google_client_id": {"key": "properties.googleClientId", "type": "str"},
        "google_client_secret": {"key": "properties.googleClientSecret", "type": "str"},
        "google_client_secret_setting_name": {"key": "properties.googleClientSecretSettingName", "type": "str"},
        "google_o_auth_scopes": {"key": "properties.googleOAuthScopes", "type": "[str]"},
        "facebook_app_id": {"key": "properties.facebookAppId", "type": "str"},
        "facebook_app_secret": {"key": "properties.facebookAppSecret", "type": "str"},
        "facebook_app_secret_setting_name": {"key": "properties.facebookAppSecretSettingName", "type": "str"},
        "facebook_o_auth_scopes": {"key": "properties.facebookOAuthScopes", "type": "[str]"},
        "git_hub_client_id": {"key": "properties.gitHubClientId", "type": "str"},
        "git_hub_client_secret": {"key": "properties.gitHubClientSecret", "type": "str"},
        "git_hub_client_secret_setting_name": {"key": "properties.gitHubClientSecretSettingName", "type": "str"},
        "git_hub_o_auth_scopes": {"key": "properties.gitHubOAuthScopes", "type": "[str]"},
        "twitter_consumer_key": {"key": "properties.twitterConsumerKey", "type": "str"},
        "twitter_consumer_secret": {"key": "properties.twitterConsumerSecret", "type": "str"},
        "twitter_consumer_secret_setting_name": {"key": "properties.twitterConsumerSecretSettingName", "type": "str"},
        "microsoft_account_client_id": {"key": "properties.microsoftAccountClientId", "type": "str"},
        "microsoft_account_client_secret": {"key": "properties.microsoftAccountClientSecret", "type": "str"},
        "microsoft_account_client_secret_setting_name": {
            "key": "properties.microsoftAccountClientSecretSettingName",
            "type": "str",
        },
        "microsoft_account_o_auth_scopes": {"key": "properties.microsoftAccountOAuthScopes", "type": "[str]"},
        "is_auth_from_file": {"key": "properties.isAuthFromFile", "type": "str"},
        "auth_file_path": {"key": "properties.authFilePath", "type": "str"},
        "config_version": {"key": "properties.configVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        runtime_version: Optional[str] = None,
        unauthenticated_client_action: Optional[Union[str, "_models.UnauthenticatedClientAction"]] = None,
        token_store_enabled: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        default_provider: Optional[Union[str, "_models.BuiltInAuthenticationProvider"]] = None,
        token_refresh_extension_hours: Optional[float] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        client_secret_certificate_thumbprint: Optional[str] = None,
        issuer: Optional[str] = None,
        validate_issuer: Optional[bool] = None,
        allowed_audiences: Optional[List[str]] = None,
        additional_login_params: Optional[List[str]] = None,
        aad_claims_authorization: Optional[str] = None,
        google_client_id: Optional[str] = None,
        google_client_secret: Optional[str] = None,
        google_client_secret_setting_name: Optional[str] = None,
        google_o_auth_scopes: Optional[List[str]] = None,
        facebook_app_id: Optional[str] = None,
        facebook_app_secret: Optional[str] = None,
        facebook_app_secret_setting_name: Optional[str] = None,
        facebook_o_auth_scopes: Optional[List[str]] = None,
        git_hub_client_id: Optional[str] = None,
        git_hub_client_secret: Optional[str] = None,
        git_hub_client_secret_setting_name: Optional[str] = None,
        git_hub_o_auth_scopes: Optional[List[str]] = None,
        twitter_consumer_key: Optional[str] = None,
        twitter_consumer_secret: Optional[str] = None,
        twitter_consumer_secret_setting_name: Optional[str] = None,
        microsoft_account_client_id: Optional[str] = None,
        microsoft_account_client_secret: Optional[str] = None,
        microsoft_account_client_secret_setting_name: Optional[str] = None,
        microsoft_account_o_auth_scopes: Optional[List[str]] = None,
        is_auth_from_file: Optional[str] = None,
        auth_file_path: Optional[str] = None,
        config_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
         enabled for the current app; otherwise, :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword runtime_version: The RuntimeVersion of the Authentication / Authorization feature in
         use for the current app.
         The setting in this value can control the behavior of certain features in the Authentication /
         Authorization module.
        :paramtype runtime_version: str
        :keyword unauthenticated_client_action: The action to take when an unauthenticated client
         attempts to access the app. Known values are: "RedirectToLoginPage" and "AllowAnonymous".
        :paramtype unauthenticated_client_action: str or
         ~azure.mgmt.web.v2023_01_01.models.UnauthenticatedClientAction
        :keyword token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
         security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
          The default is :code:`<code>false</code>`.
        :paramtype token_store_enabled: bool
        :keyword allowed_external_redirect_urls: External URLs that can be redirected to as part of
         logging in or logging out of the app. Note that the query string part of the URL is ignored.
         This is an advanced setting typically only needed by Windows Store application backends.
         Note that URLs within the current domain are always implicitly allowed.
        :paramtype allowed_external_redirect_urls: list[str]
        :keyword default_provider: The default authentication provider to use when multiple providers
         are configured.
         This setting is only needed if multiple providers are configured and the unauthenticated
         client
         action is set to "RedirectToLoginPage". Known values are: "AzureActiveDirectory", "Facebook",
         "Google", "MicrosoftAccount", "Twitter", and "Github".
        :paramtype default_provider: str or
         ~azure.mgmt.web.v2023_01_01.models.BuiltInAuthenticationProvider
        :keyword token_refresh_extension_hours: The number of hours after session token expiration that
         a session token can be used to
         call the token refresh API. The default is 72 hours.
        :paramtype token_refresh_extension_hours: float
        :keyword client_id: The Client ID of this relying party application, known as the client_id.
         This setting is required for enabling OpenID Connection authentication with Azure Active
         Directory or
         other 3rd party OpenID Connect providers.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_id: str
        :keyword client_secret: The Client Secret of this relying party application (in Azure Active
         Directory, this is also referred to as the Key).
         This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
         flow is used to authenticate end users.
         Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_secret: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret of
         the relying party application.
        :paramtype client_secret_setting_name: str
        :keyword client_secret_certificate_thumbprint: An alternative to the client secret, that is the
         thumbprint of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret. It is also optional.
        :paramtype client_secret_certificate_thumbprint: str
        :keyword issuer: The OpenID Connect Issuer URI that represents the entity which issues access
         tokens for this application.
         When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
         https://sts.windows.net/{tenant-guid}/.
         This URI is a case-sensitive identifier for the token issuer.
         More information on OpenID Connect Discovery:
         http://openid.net/specs/openid-connect-discovery-1_0.html.
        :paramtype issuer: str
        :keyword validate_issuer: Gets a value indicating whether the issuer should be a valid HTTPS
         url and be validated as such.
        :paramtype validate_issuer: bool
        :keyword allowed_audiences: Allowed audience values to consider when validating JSON Web Tokens
         issued by
         Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
         an
         allowed audience, regardless of this setting.
        :paramtype allowed_audiences: list[str]
        :keyword additional_login_params: Login parameters to send to the OpenID Connect authorization
         endpoint when
         a user logs in. Each parameter must be in the form "key=value".
        :paramtype additional_login_params: list[str]
        :keyword aad_claims_authorization: Gets a JSON string containing the Azure AD Acl settings.
        :paramtype aad_claims_authorization: str
        :keyword google_client_id: The OpenID Connect Client ID for the Google web application.
         This setting is required for enabling Google Sign-In.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_client_id: str
        :keyword google_client_secret: The client secret associated with the Google web application.
         This setting is required for enabling Google Sign-In.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_client_secret: str
        :keyword google_client_secret_setting_name: The app setting name that contains the client
         secret associated with
         the Google web application.
        :paramtype google_client_secret_setting_name: str
        :keyword google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
         Sign-In authentication.
         This setting is optional. If not specified, "openid", "profile", and "email" are used as
         default scopes.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_o_auth_scopes: list[str]
        :keyword facebook_app_id: The App ID of the Facebook app used for login.
         This setting is required for enabling Facebook Login.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_app_id: str
        :keyword facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
         This setting is required for enabling Facebook Login.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_app_secret: str
        :keyword facebook_app_secret_setting_name: The app setting name that contains the app secret
         used for Facebook Login.
        :paramtype facebook_app_secret_setting_name: str
        :keyword facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
         Facebook Login authentication.
         This setting is optional.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_o_auth_scopes: list[str]
        :keyword git_hub_client_id: The Client Id of the GitHub app used for login.
         This setting is required for enabling Github login.
        :paramtype git_hub_client_id: str
        :keyword git_hub_client_secret: The Client Secret of the GitHub app used for Github Login.
         This setting is required for enabling Github login.
        :paramtype git_hub_client_secret: str
        :keyword git_hub_client_secret_setting_name: The app setting name that contains the client
         secret of the Github
         app used for GitHub Login.
        :paramtype git_hub_client_secret_setting_name: str
        :keyword git_hub_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of GitHub
         Login authentication.
         This setting is optional.
        :paramtype git_hub_o_auth_scopes: list[str]
        :keyword twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
         sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype twitter_consumer_key: str
        :keyword twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application
         used for sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype twitter_consumer_secret: str
        :keyword twitter_consumer_secret_setting_name: The app setting name that contains the OAuth
         1.0a consumer secret of the Twitter
         application used for sign-in.
        :paramtype twitter_consumer_secret_setting_name: str
        :keyword microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
         for authentication.
         This setting is required for enabling Microsoft Account authentication.
         Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
        :paramtype microsoft_account_client_id: str
        :keyword microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the
         app used for authentication.
         This setting is required for enabling Microsoft Account authentication.
         Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
        :paramtype microsoft_account_client_secret: str
        :keyword microsoft_account_client_secret_setting_name: The app setting name containing the
         OAuth 2.0 client secret that was created for the
         app used for authentication.
        :paramtype microsoft_account_client_secret_setting_name: str
        :keyword microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part
         of Microsoft Account authentication.
         This setting is optional. If not specified, "wl.basic" is used as the default scope.
         Microsoft Account Scopes and permissions documentation:
         https://msdn.microsoft.com/en-us/library/dn631845.aspx.
        :paramtype microsoft_account_o_auth_scopes: list[str]
        :keyword is_auth_from_file: "true" if the auth config settings should be read from a file,
         "false" otherwise.
        :paramtype is_auth_from_file: str
        :keyword auth_file_path: The path of the config file containing auth settings.
         If the path is relative, base will the site's root directory.
        :paramtype auth_file_path: str
        :keyword config_version: The ConfigVersion of the Authentication / Authorization feature in use
         for the current app.
         The setting in this value can control the behavior of the control plane for Authentication /
         Authorization.
        :paramtype config_version: str
        """
        super().__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version
        self.unauthenticated_client_action = unauthenticated_client_action
        self.token_store_enabled = token_store_enabled
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.default_provider = default_provider
        self.token_refresh_extension_hours = token_refresh_extension_hours
        self.client_id = client_id
        self.client_secret = client_secret
        self.client_secret_setting_name = client_secret_setting_name
        self.client_secret_certificate_thumbprint = client_secret_certificate_thumbprint
        self.issuer = issuer
        self.validate_issuer = validate_issuer
        self.allowed_audiences = allowed_audiences
        self.additional_login_params = additional_login_params
        self.aad_claims_authorization = aad_claims_authorization
        self.google_client_id = google_client_id
        self.google_client_secret = google_client_secret
        self.google_client_secret_setting_name = google_client_secret_setting_name
        self.google_o_auth_scopes = google_o_auth_scopes
        self.facebook_app_id = facebook_app_id
        self.facebook_app_secret = facebook_app_secret
        self.facebook_app_secret_setting_name = facebook_app_secret_setting_name
        self.facebook_o_auth_scopes = facebook_o_auth_scopes
        self.git_hub_client_id = git_hub_client_id
        self.git_hub_client_secret = git_hub_client_secret
        self.git_hub_client_secret_setting_name = git_hub_client_secret_setting_name
        self.git_hub_o_auth_scopes = git_hub_o_auth_scopes
        self.twitter_consumer_key = twitter_consumer_key
        self.twitter_consumer_secret = twitter_consumer_secret
        self.twitter_consumer_secret_setting_name = twitter_consumer_secret_setting_name
        self.microsoft_account_client_id = microsoft_account_client_id
        self.microsoft_account_client_secret = microsoft_account_client_secret
        self.microsoft_account_client_secret_setting_name = microsoft_account_client_secret_setting_name
        self.microsoft_account_o_auth_scopes = microsoft_account_o_auth_scopes
        self.is_auth_from_file = is_auth_from_file
        self.auth_file_path = auth_file_path
        self.config_version = config_version


class SiteAuthSettingsV2(ProxyOnlyResource):
    """Configuration settings for the Azure App Service Authentication / Authorization V2 feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar platform: The configuration settings of the platform of App Service
     Authentication/Authorization.
    :vartype platform: ~azure.mgmt.web.v2023_01_01.models.AuthPlatform
    :ivar global_validation: The configuration settings that determines the validation flow of
     users using App Service Authentication/Authorization.
    :vartype global_validation: ~azure.mgmt.web.v2023_01_01.models.GlobalValidation
    :ivar identity_providers: The configuration settings of each of the identity providers used to
     configure App Service Authentication/Authorization.
    :vartype identity_providers: ~azure.mgmt.web.v2023_01_01.models.IdentityProviders
    :ivar login: The configuration settings of the login flow of users using App Service
     Authentication/Authorization.
    :vartype login: ~azure.mgmt.web.v2023_01_01.models.Login
    :ivar http_settings: The configuration settings of the HTTP requests for authentication and
     authorization requests made against App Service Authentication/Authorization.
    :vartype http_settings: ~azure.mgmt.web.v2023_01_01.models.HttpSettings
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "platform": {"key": "properties.platform", "type": "AuthPlatform"},
        "global_validation": {"key": "properties.globalValidation", "type": "GlobalValidation"},
        "identity_providers": {"key": "properties.identityProviders", "type": "IdentityProviders"},
        "login": {"key": "properties.login", "type": "Login"},
        "http_settings": {"key": "properties.httpSettings", "type": "HttpSettings"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        platform: Optional["_models.AuthPlatform"] = None,
        global_validation: Optional["_models.GlobalValidation"] = None,
        identity_providers: Optional["_models.IdentityProviders"] = None,
        login: Optional["_models.Login"] = None,
        http_settings: Optional["_models.HttpSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword platform: The configuration settings of the platform of App Service
         Authentication/Authorization.
        :paramtype platform: ~azure.mgmt.web.v2023_01_01.models.AuthPlatform
        :keyword global_validation: The configuration settings that determines the validation flow of
         users using App Service Authentication/Authorization.
        :paramtype global_validation: ~azure.mgmt.web.v2023_01_01.models.GlobalValidation
        :keyword identity_providers: The configuration settings of each of the identity providers used
         to configure App Service Authentication/Authorization.
        :paramtype identity_providers: ~azure.mgmt.web.v2023_01_01.models.IdentityProviders
        :keyword login: The configuration settings of the login flow of users using App Service
         Authentication/Authorization.
        :paramtype login: ~azure.mgmt.web.v2023_01_01.models.Login
        :keyword http_settings: The configuration settings of the HTTP requests for authentication and
         authorization requests made against App Service Authentication/Authorization.
        :paramtype http_settings: ~azure.mgmt.web.v2023_01_01.models.HttpSettings
        """
        super().__init__(kind=kind, **kwargs)
        self.platform = platform
        self.global_validation = global_validation
        self.identity_providers = identity_providers
        self.login = login
        self.http_settings = http_settings


class SiteCloneability(_serialization.Model):
    """Represents whether or not an app is cloneable.

    :ivar result: Name of app. Known values are: "Cloneable", "PartiallyCloneable", and
     "NotCloneable".
    :vartype result: str or ~azure.mgmt.web.v2023_01_01.models.CloneAbilityResult
    :ivar blocking_features: List of features enabled on app that prevent cloning.
    :vartype blocking_features: list[~azure.mgmt.web.v2023_01_01.models.SiteCloneabilityCriterion]
    :ivar unsupported_features: List of features enabled on app that are non-blocking but cannot be
     cloned. The app can still be cloned
     but the features in this list will not be set up on cloned app.
    :vartype unsupported_features:
     list[~azure.mgmt.web.v2023_01_01.models.SiteCloneabilityCriterion]
    :ivar blocking_characteristics: List of blocking application characteristics.
    :vartype blocking_characteristics:
     list[~azure.mgmt.web.v2023_01_01.models.SiteCloneabilityCriterion]
    """

    _attribute_map = {
        "result": {"key": "result", "type": "str"},
        "blocking_features": {"key": "blockingFeatures", "type": "[SiteCloneabilityCriterion]"},
        "unsupported_features": {"key": "unsupportedFeatures", "type": "[SiteCloneabilityCriterion]"},
        "blocking_characteristics": {"key": "blockingCharacteristics", "type": "[SiteCloneabilityCriterion]"},
    }

    def __init__(
        self,
        *,
        result: Optional[Union[str, "_models.CloneAbilityResult"]] = None,
        blocking_features: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        unsupported_features: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        blocking_characteristics: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword result: Name of app. Known values are: "Cloneable", "PartiallyCloneable", and
         "NotCloneable".
        :paramtype result: str or ~azure.mgmt.web.v2023_01_01.models.CloneAbilityResult
        :keyword blocking_features: List of features enabled on app that prevent cloning.
        :paramtype blocking_features:
         list[~azure.mgmt.web.v2023_01_01.models.SiteCloneabilityCriterion]
        :keyword unsupported_features: List of features enabled on app that are non-blocking but cannot
         be cloned. The app can still be cloned
         but the features in this list will not be set up on cloned app.
        :paramtype unsupported_features:
         list[~azure.mgmt.web.v2023_01_01.models.SiteCloneabilityCriterion]
        :keyword blocking_characteristics: List of blocking application characteristics.
        :paramtype blocking_characteristics:
         list[~azure.mgmt.web.v2023_01_01.models.SiteCloneabilityCriterion]
        """
        super().__init__(**kwargs)
        self.result = result
        self.blocking_features = blocking_features
        self.unsupported_features = unsupported_features
        self.blocking_characteristics = blocking_characteristics


class SiteCloneabilityCriterion(_serialization.Model):
    """An app cloneability criterion.

    :ivar name: Name of criterion.
    :vartype name: str
    :ivar description: Description of criterion.
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of criterion.
        :paramtype name: str
        :keyword description: Description of criterion.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description


class SiteConfig(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar power_shell_version: Version of PowerShell.
    :vartype power_shell_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar windows_fx_version: Xenon App Framework and version.
    :vartype windows_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :vartype acr_use_managed_identity_creds: bool
    :ivar acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :vartype acr_user_managed_identity_id: str
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
    :ivar metadata: Application metadata. This property cannot be retrieved, since it may contain
     secrets.
    :vartype metadata: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2023_01_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2023_01_01.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2023_01_01.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", "VSO", and "VSTSRM".
    :vartype scm_type: str or ~azure.mgmt.web.v2023_01_01.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
     "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2023_01_01.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2023_01_01.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash", and
     "PerSiteRoundRobin".
    :vartype load_balancing: str or ~azure.mgmt.web.v2023_01_01.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2023_01_01.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2023_01_01.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2023_01_01.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
     traffic to have Virtual Network Security Groups and User Defined Routes applied.
    :vartype vnet_route_all_enabled: bool
    :ivar vnet_private_ports_count: The number of private ports assigned to this app. These will be
     assigned dynamically on runtime.
    :vartype vnet_private_ports_count: int
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2023_01_01.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2023_01_01.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2023_01_01.models.ApiDefinitionInfo
    :ivar api_management_config: Azure API management settings linked to the app.
    :vartype api_management_config: ~azure.mgmt.web.v2023_01_01.models.ApiManagementConfig
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar managed_service_identity_id: Managed Service Identity Id.
    :vartype managed_service_identity_id: int
    :ivar x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :vartype x_managed_service_identity_id: int
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar ip_security_restrictions: IP security restrictions for main.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2023_01_01.models.IpSecurityRestriction]
    :ivar ip_security_restrictions_default_action: Default action for main access restriction if no
     rules are matched. Known values are: "Allow" and "Deny".
    :vartype ip_security_restrictions_default_action: str or
     ~azure.mgmt.web.v2023_01_01.models.DefaultAction
    :ivar scm_ip_security_restrictions: IP security restrictions for scm.
    :vartype scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2023_01_01.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions_default_action: Default action for scm access restriction if
     no rules are matched. Known values are: "Allow" and "Deny".
    :vartype scm_ip_security_restrictions_default_action: str or
     ~azure.mgmt.web.v2023_01_01.models.DefaultAction
    :ivar scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :vartype scm_ip_security_restrictions_use_main: bool
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", and "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2023_01_01.models.SupportedTlsVersions
    :ivar min_tls_cipher_suite: The minimum strength TLS cipher suite allowed for an application.
     Known values are: "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256",
     "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
     "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
     "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
     "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
     "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384",
     "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256",
     "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", and
     "TLS_RSA_WITH_AES_128_CBC_SHA".
    :vartype min_tls_cipher_suite: str or ~azure.mgmt.web.v2023_01_01.models.TlsCipherSuites
    :ivar scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required for
     SSL requests for SCM site. Known values are: "1.0", "1.1", and "1.2".
    :vartype scm_min_tls_version: str or ~azure.mgmt.web.v2023_01_01.models.SupportedTlsVersions
    :ivar ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly", and
     "Disabled".
    :vartype ftps_state: str or ~azure.mgmt.web.v2023_01_01.models.FtpsState
    :ivar pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :vartype pre_warmed_instance_count: int
    :ivar function_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to the Consumption and Elastic Premium Plans.
    :vartype function_app_scale_limit: int
    :ivar elastic_web_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to apps in plans where ElasticScaleEnabled is
     :code:`<code>true</code>`.
    :vartype elastic_web_app_scale_limit: int
    :ivar health_check_path: Health check path.
    :vartype health_check_path: str
    :ivar functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
     functions runtime scale monitoring is enabled. When enabled,
     the ScaleController will not monitor event sources directly, but will instead call to the
     runtime to get scale status.
    :vartype functions_runtime_scale_monitoring_enabled: bool
    :ivar website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible
     with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence
     over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a
     quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows,
     expects one of the time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows
     NT\\CurrentVersion\\Time Zones.
    :vartype website_time_zone: str
    :ivar minimum_elastic_instance_count: Number of minimum instance count for a site
     This setting only applies to the Elastic Plans.
    :vartype minimum_elastic_instance_count: int
    :ivar azure_storage_accounts: List of Azure Storage Accounts.
    :vartype azure_storage_accounts: dict[str,
     ~azure.mgmt.web.v2023_01_01.models.AzureStorageInfoValue]
    :ivar public_network_access: Property to allow or block all public traffic.
    :vartype public_network_access: str
    """

    _validation = {
        "machine_key": {"readonly": True},
        "pre_warmed_instance_count": {"maximum": 10, "minimum": 0},
        "function_app_scale_limit": {"minimum": 0},
        "elastic_web_app_scale_limit": {"minimum": 0},
        "minimum_elastic_instance_count": {"maximum": 20, "minimum": 0},
    }

    _attribute_map = {
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
        "default_documents": {"key": "defaultDocuments", "type": "[str]"},
        "net_framework_version": {"key": "netFrameworkVersion", "type": "str"},
        "php_version": {"key": "phpVersion", "type": "str"},
        "python_version": {"key": "pythonVersion", "type": "str"},
        "node_version": {"key": "nodeVersion", "type": "str"},
        "power_shell_version": {"key": "powerShellVersion", "type": "str"},
        "linux_fx_version": {"key": "linuxFxVersion", "type": "str"},
        "windows_fx_version": {"key": "windowsFxVersion", "type": "str"},
        "request_tracing_enabled": {"key": "requestTracingEnabled", "type": "bool"},
        "request_tracing_expiration_time": {"key": "requestTracingExpirationTime", "type": "iso-8601"},
        "remote_debugging_enabled": {"key": "remoteDebuggingEnabled", "type": "bool"},
        "remote_debugging_version": {"key": "remoteDebuggingVersion", "type": "str"},
        "http_logging_enabled": {"key": "httpLoggingEnabled", "type": "bool"},
        "acr_use_managed_identity_creds": {"key": "acrUseManagedIdentityCreds", "type": "bool"},
        "acr_user_managed_identity_id": {"key": "acrUserManagedIdentityID", "type": "str"},
        "logs_directory_size_limit": {"key": "logsDirectorySizeLimit", "type": "int"},
        "detailed_error_logging_enabled": {"key": "detailedErrorLoggingEnabled", "type": "bool"},
        "publishing_username": {"key": "publishingUsername", "type": "str"},
        "app_settings": {"key": "appSettings", "type": "[NameValuePair]"},
        "metadata": {"key": "metadata", "type": "[NameValuePair]"},
        "connection_strings": {"key": "connectionStrings", "type": "[ConnStringInfo]"},
        "machine_key": {"key": "machineKey", "type": "SiteMachineKey"},
        "handler_mappings": {"key": "handlerMappings", "type": "[HandlerMapping]"},
        "document_root": {"key": "documentRoot", "type": "str"},
        "scm_type": {"key": "scmType", "type": "str"},
        "use32_bit_worker_process": {"key": "use32BitWorkerProcess", "type": "bool"},
        "web_sockets_enabled": {"key": "webSocketsEnabled", "type": "bool"},
        "always_on": {"key": "alwaysOn", "type": "bool"},
        "java_version": {"key": "javaVersion", "type": "str"},
        "java_container": {"key": "javaContainer", "type": "str"},
        "java_container_version": {"key": "javaContainerVersion", "type": "str"},
        "app_command_line": {"key": "appCommandLine", "type": "str"},
        "managed_pipeline_mode": {"key": "managedPipelineMode", "type": "str"},
        "virtual_applications": {"key": "virtualApplications", "type": "[VirtualApplication]"},
        "load_balancing": {"key": "loadBalancing", "type": "str"},
        "experiments": {"key": "experiments", "type": "Experiments"},
        "limits": {"key": "limits", "type": "SiteLimits"},
        "auto_heal_enabled": {"key": "autoHealEnabled", "type": "bool"},
        "auto_heal_rules": {"key": "autoHealRules", "type": "AutoHealRules"},
        "tracing_options": {"key": "tracingOptions", "type": "str"},
        "vnet_name": {"key": "vnetName", "type": "str"},
        "vnet_route_all_enabled": {"key": "vnetRouteAllEnabled", "type": "bool"},
        "vnet_private_ports_count": {"key": "vnetPrivatePortsCount", "type": "int"},
        "cors": {"key": "cors", "type": "CorsSettings"},
        "push": {"key": "push", "type": "PushSettings"},
        "api_definition": {"key": "apiDefinition", "type": "ApiDefinitionInfo"},
        "api_management_config": {"key": "apiManagementConfig", "type": "ApiManagementConfig"},
        "auto_swap_slot_name": {"key": "autoSwapSlotName", "type": "str"},
        "local_my_sql_enabled": {"key": "localMySqlEnabled", "type": "bool"},
        "managed_service_identity_id": {"key": "managedServiceIdentityId", "type": "int"},
        "x_managed_service_identity_id": {"key": "xManagedServiceIdentityId", "type": "int"},
        "key_vault_reference_identity": {"key": "keyVaultReferenceIdentity", "type": "str"},
        "ip_security_restrictions": {"key": "ipSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "ip_security_restrictions_default_action": {"key": "ipSecurityRestrictionsDefaultAction", "type": "str"},
        "scm_ip_security_restrictions": {"key": "scmIpSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "scm_ip_security_restrictions_default_action": {"key": "scmIpSecurityRestrictionsDefaultAction", "type": "str"},
        "scm_ip_security_restrictions_use_main": {"key": "scmIpSecurityRestrictionsUseMain", "type": "bool"},
        "http20_enabled": {"key": "http20Enabled", "type": "bool"},
        "min_tls_version": {"key": "minTlsVersion", "type": "str"},
        "min_tls_cipher_suite": {"key": "minTlsCipherSuite", "type": "str"},
        "scm_min_tls_version": {"key": "scmMinTlsVersion", "type": "str"},
        "ftps_state": {"key": "ftpsState", "type": "str"},
        "pre_warmed_instance_count": {"key": "preWarmedInstanceCount", "type": "int"},
        "function_app_scale_limit": {"key": "functionAppScaleLimit", "type": "int"},
        "elastic_web_app_scale_limit": {"key": "elasticWebAppScaleLimit", "type": "int"},
        "health_check_path": {"key": "healthCheckPath", "type": "str"},
        "functions_runtime_scale_monitoring_enabled": {"key": "functionsRuntimeScaleMonitoringEnabled", "type": "bool"},
        "website_time_zone": {"key": "websiteTimeZone", "type": "str"},
        "minimum_elastic_instance_count": {"key": "minimumElasticInstanceCount", "type": "int"},
        "azure_storage_accounts": {"key": "azureStorageAccounts", "type": "{AzureStorageInfoValue}"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: str = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        power_shell_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        acr_use_managed_identity_creds: Optional[bool] = None,
        acr_user_managed_identity_id: Optional[str] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["_models.NameValuePair"]] = None,
        metadata: Optional[List["_models.NameValuePair"]] = None,
        connection_strings: Optional[List["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[List["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_route_all_enabled: Optional[bool] = None,
        vnet_private_ports_count: Optional[int] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        api_management_config: Optional["_models.ApiManagementConfig"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: bool = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        key_vault_reference_identity: Optional[str] = None,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        ip_security_restrictions_default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        scm_ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: bool = True,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        min_tls_cipher_suite: Optional[Union[str, "_models.TlsCipherSuites"]] = None,
        scm_min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "_models.FtpsState"]] = None,
        pre_warmed_instance_count: Optional[int] = None,
        function_app_scale_limit: Optional[int] = None,
        elastic_web_app_scale_limit: Optional[int] = None,
        health_check_path: Optional[str] = None,
        functions_runtime_scale_monitoring_enabled: Optional[bool] = None,
        website_time_zone: Optional[str] = None,
        minimum_elastic_instance_count: Optional[int] = None,
        azure_storage_accounts: Optional[Dict[str, "_models.AzureStorageInfoValue"]] = None,
        public_network_access: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword power_shell_version: Version of PowerShell.
        :paramtype power_shell_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword windows_fx_version: Xenon App Framework and version.
        :paramtype windows_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
        :paramtype acr_use_managed_identity_creds: bool
        :keyword acr_user_managed_identity_id: If using user managed identity, the user managed
         identity ClientId.
        :paramtype acr_user_managed_identity_id: str
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
        :keyword metadata: Application metadata. This property cannot be retrieved, since it may
         contain secrets.
        :paramtype metadata: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2023_01_01.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2023_01_01.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", "VSO", and "VSTSRM".
        :paramtype scm_type: str or ~azure.mgmt.web.v2023_01_01.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2023_01_01.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2023_01_01.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash", and
         "PerSiteRoundRobin".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2023_01_01.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2023_01_01.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2023_01_01.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2023_01_01.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
         traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :paramtype vnet_route_all_enabled: bool
        :keyword vnet_private_ports_count: The number of private ports assigned to this app. These will
         be assigned dynamically on runtime.
        :paramtype vnet_private_ports_count: int
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2023_01_01.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2023_01_01.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2023_01_01.models.ApiDefinitionInfo
        :keyword api_management_config: Azure API management settings linked to the app.
        :paramtype api_management_config: ~azure.mgmt.web.v2023_01_01.models.ApiManagementConfig
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword managed_service_identity_id: Managed Service Identity Id.
        :paramtype managed_service_identity_id: int
        :keyword x_managed_service_identity_id: Explicit Managed Service Identity Id.
        :paramtype x_managed_service_identity_id: int
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword ip_security_restrictions: IP security restrictions for main.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2023_01_01.models.IpSecurityRestriction]
        :keyword ip_security_restrictions_default_action: Default action for main access restriction if
         no rules are matched. Known values are: "Allow" and "Deny".
        :paramtype ip_security_restrictions_default_action: str or
         ~azure.mgmt.web.v2023_01_01.models.DefaultAction
        :keyword scm_ip_security_restrictions: IP security restrictions for scm.
        :paramtype scm_ip_security_restrictions:
         list[~azure.mgmt.web.v2023_01_01.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions_default_action: Default action for scm access restriction
         if no rules are matched. Known values are: "Allow" and "Deny".
        :paramtype scm_ip_security_restrictions_default_action: str or
         ~azure.mgmt.web.v2023_01_01.models.DefaultAction
        :keyword scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :paramtype scm_ip_security_restrictions_use_main: bool
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", and "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2023_01_01.models.SupportedTlsVersions
        :keyword min_tls_cipher_suite: The minimum strength TLS cipher suite allowed for an
         application. Known values are: "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256",
         "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
         "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
         "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
         "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
         "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384",
         "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256",
         "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", and
         "TLS_RSA_WITH_AES_128_CBC_SHA".
        :paramtype min_tls_cipher_suite: str or ~azure.mgmt.web.v2023_01_01.models.TlsCipherSuites
        :keyword scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required
         for SSL requests for SCM site. Known values are: "1.0", "1.1", and "1.2".
        :paramtype scm_min_tls_version: str or ~azure.mgmt.web.v2023_01_01.models.SupportedTlsVersions
        :keyword ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly",
         and "Disabled".
        :paramtype ftps_state: str or ~azure.mgmt.web.v2023_01_01.models.FtpsState
        :keyword pre_warmed_instance_count: Number of preWarmed instances.
         This setting only applies to the Consumption and Elastic Plans.
        :paramtype pre_warmed_instance_count: int
        :keyword function_app_scale_limit: Maximum number of workers that a site can scale out to.
         This setting only applies to the Consumption and Elastic Premium Plans.
        :paramtype function_app_scale_limit: int
        :keyword elastic_web_app_scale_limit: Maximum number of workers that a site can scale out to.
         This setting only applies to apps in plans where ElasticScaleEnabled is
         :code:`<code>true</code>`.
        :paramtype elastic_web_app_scale_limit: int
        :keyword health_check_path: Health check path.
        :paramtype health_check_path: str
        :keyword functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
         functions runtime scale monitoring is enabled. When enabled,
         the ScaleController will not monitor event sources directly, but will instead call to the
         runtime to get scale status.
        :paramtype functions_runtime_scale_monitoring_enabled: bool
        :keyword website_time_zone: Sets the time zone a site uses for generating timestamps.
         Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes
         precedence over this config. For Linux, expects tz database values
         https://www.iana.org/time-zones (for a quick reference see
         https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the
         time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows
         NT\\CurrentVersion\\Time Zones.
        :paramtype website_time_zone: str
        :keyword minimum_elastic_instance_count: Number of minimum instance count for a site
         This setting only applies to the Elastic Plans.
        :paramtype minimum_elastic_instance_count: int
        :keyword azure_storage_accounts: List of Azure Storage Accounts.
        :paramtype azure_storage_accounts: dict[str,
         ~azure.mgmt.web.v2023_01_01.models.AzureStorageInfoValue]
        :keyword public_network_access: Property to allow or block all public traffic.
        :paramtype public_network_access: str
        """
        super().__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.power_shell_version = power_shell_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.acr_use_managed_identity_creds = acr_use_managed_identity_creds
        self.acr_user_managed_identity_id = acr_user_managed_identity_id
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.metadata = metadata
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.vnet_route_all_enabled = vnet_route_all_enabled
        self.vnet_private_ports_count = vnet_private_ports_count
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.api_management_config = api_management_config
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.key_vault_reference_identity = key_vault_reference_identity
        self.ip_security_restrictions = ip_security_restrictions
        self.ip_security_restrictions_default_action = ip_security_restrictions_default_action
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_default_action = scm_ip_security_restrictions_default_action
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version
        self.min_tls_cipher_suite = min_tls_cipher_suite
        self.scm_min_tls_version = scm_min_tls_version
        self.ftps_state = ftps_state
        self.pre_warmed_instance_count = pre_warmed_instance_count
        self.function_app_scale_limit = function_app_scale_limit
        self.elastic_web_app_scale_limit = elastic_web_app_scale_limit
        self.health_check_path = health_check_path
        self.functions_runtime_scale_monitoring_enabled = functions_runtime_scale_monitoring_enabled
        self.website_time_zone = website_time_zone
        self.minimum_elastic_instance_count = minimum_elastic_instance_count
        self.azure_storage_accounts = azure_storage_accounts
        self.public_network_access = public_network_access


class SiteConfigPropertiesDictionary(_serialization.Model):
    """Site config properties dictionary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar use32_bit_worker_process: :code:`<code>true</code>` if use32BitWorkerProcess should be
     set to true for the stack; otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar linux_fx_version: LinuxFxVersion configuration setting.
    :vartype linux_fx_version: str
    :ivar java_version: JavaVersion configuration setting.
    :vartype java_version: str
    :ivar power_shell_version: PowerShellVersion configuration setting.
    :vartype power_shell_version: str
    """

    _validation = {
        "use32_bit_worker_process": {"readonly": True},
        "linux_fx_version": {"readonly": True},
        "java_version": {"readonly": True},
        "power_shell_version": {"readonly": True},
    }

    _attribute_map = {
        "use32_bit_worker_process": {"key": "use32BitWorkerProcess", "type": "bool"},
        "linux_fx_version": {"key": "linuxFxVersion", "type": "str"},
        "java_version": {"key": "javaVersion", "type": "str"},
        "power_shell_version": {"key": "powerShellVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.use32_bit_worker_process = None
        self.linux_fx_version = None
        self.java_version = None
        self.power_shell_version = None


class SiteConfigResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Web app configuration ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar power_shell_version: Version of PowerShell.
    :vartype power_shell_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar windows_fx_version: Xenon App Framework and version.
    :vartype windows_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :vartype acr_use_managed_identity_creds: bool
    :ivar acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :vartype acr_user_managed_identity_id: str
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
    :ivar metadata: Application metadata. This property cannot be retrieved, since it may contain
     secrets.
    :vartype metadata: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2023_01_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2023_01_01.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2023_01_01.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", "VSO", and "VSTSRM".
    :vartype scm_type: str or ~azure.mgmt.web.v2023_01_01.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
     "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2023_01_01.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2023_01_01.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash", and
     "PerSiteRoundRobin".
    :vartype load_balancing: str or ~azure.mgmt.web.v2023_01_01.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2023_01_01.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2023_01_01.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2023_01_01.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
     traffic to have Virtual Network Security Groups and User Defined Routes applied.
    :vartype vnet_route_all_enabled: bool
    :ivar vnet_private_ports_count: The number of private ports assigned to this app. These will be
     assigned dynamically on runtime.
    :vartype vnet_private_ports_count: int
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2023_01_01.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2023_01_01.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2023_01_01.models.ApiDefinitionInfo
    :ivar api_management_config: Azure API management settings linked to the app.
    :vartype api_management_config: ~azure.mgmt.web.v2023_01_01.models.ApiManagementConfig
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar managed_service_identity_id: Managed Service Identity Id.
    :vartype managed_service_identity_id: int
    :ivar x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :vartype x_managed_service_identity_id: int
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar ip_security_restrictions: IP security restrictions for main.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2023_01_01.models.IpSecurityRestriction]
    :ivar ip_security_restrictions_default_action: Default action for main access restriction if no
     rules are matched. Known values are: "Allow" and "Deny".
    :vartype ip_security_restrictions_default_action: str or
     ~azure.mgmt.web.v2023_01_01.models.DefaultAction
    :ivar scm_ip_security_restrictions: IP security restrictions for scm.
    :vartype scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2023_01_01.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions_default_action: Default action for scm access restriction if
     no rules are matched. Known values are: "Allow" and "Deny".
    :vartype scm_ip_security_restrictions_default_action: str or
     ~azure.mgmt.web.v2023_01_01.models.DefaultAction
    :ivar scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :vartype scm_ip_security_restrictions_use_main: bool
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", and "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2023_01_01.models.SupportedTlsVersions
    :ivar min_tls_cipher_suite: The minimum strength TLS cipher suite allowed for an application.
     Known values are: "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256",
     "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
     "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
     "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
     "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
     "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384",
     "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256",
     "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", and
     "TLS_RSA_WITH_AES_128_CBC_SHA".
    :vartype min_tls_cipher_suite: str or ~azure.mgmt.web.v2023_01_01.models.TlsCipherSuites
    :ivar scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required for
     SSL requests for SCM site. Known values are: "1.0", "1.1", and "1.2".
    :vartype scm_min_tls_version: str or ~azure.mgmt.web.v2023_01_01.models.SupportedTlsVersions
    :ivar ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly", and
     "Disabled".
    :vartype ftps_state: str or ~azure.mgmt.web.v2023_01_01.models.FtpsState
    :ivar pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :vartype pre_warmed_instance_count: int
    :ivar function_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to the Consumption and Elastic Premium Plans.
    :vartype function_app_scale_limit: int
    :ivar elastic_web_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to apps in plans where ElasticScaleEnabled is
     :code:`<code>true</code>`.
    :vartype elastic_web_app_scale_limit: int
    :ivar health_check_path: Health check path.
    :vartype health_check_path: str
    :ivar functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
     functions runtime scale monitoring is enabled. When enabled,
     the ScaleController will not monitor event sources directly, but will instead call to the
     runtime to get scale status.
    :vartype functions_runtime_scale_monitoring_enabled: bool
    :ivar website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible
     with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence
     over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a
     quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows,
     expects one of the time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows
     NT\\CurrentVersion\\Time Zones.
    :vartype website_time_zone: str
    :ivar minimum_elastic_instance_count: Number of minimum instance count for a site
     This setting only applies to the Elastic Plans.
    :vartype minimum_elastic_instance_count: int
    :ivar azure_storage_accounts: List of Azure Storage Accounts.
    :vartype azure_storage_accounts: dict[str,
     ~azure.mgmt.web.v2023_01_01.models.AzureStorageInfoValue]
    :ivar public_network_access: Property to allow or block all public traffic.
    :vartype public_network_access: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "machine_key": {"readonly": True},
        "pre_warmed_instance_count": {"maximum": 10, "minimum": 0},
        "function_app_scale_limit": {"minimum": 0},
        "elastic_web_app_scale_limit": {"minimum": 0},
        "minimum_elastic_instance_count": {"maximum": 20, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "number_of_workers": {"key": "properties.numberOfWorkers", "type": "int"},
        "default_documents": {"key": "properties.defaultDocuments", "type": "[str]"},
        "net_framework_version": {"key": "properties.netFrameworkVersion", "type": "str"},
        "php_version": {"key": "properties.phpVersion", "type": "str"},
        "python_version": {"key": "properties.pythonVersion", "type": "str"},
        "node_version": {"key": "properties.nodeVersion", "type": "str"},
        "power_shell_version": {"key": "properties.powerShellVersion", "type": "str"},
        "linux_fx_version": {"key": "properties.linuxFxVersion", "type": "str"},
        "windows_fx_version": {"key": "properties.windowsFxVersion", "type": "str"},
        "request_tracing_enabled": {"key": "properties.requestTracingEnabled", "type": "bool"},
        "request_tracing_expiration_time": {"key": "properties.requestTracingExpirationTime", "type": "iso-8601"},
        "remote_debugging_enabled": {"key": "properties.remoteDebuggingEnabled", "type": "bool"},
        "remote_debugging_version": {"key": "properties.remoteDebuggingVersion", "type": "str"},
        "http_logging_enabled": {"key": "properties.httpLoggingEnabled", "type": "bool"},
        "acr_use_managed_identity_creds": {"key": "properties.acrUseManagedIdentityCreds", "type": "bool"},
        "acr_user_managed_identity_id": {"key": "properties.acrUserManagedIdentityID", "type": "str"},
        "logs_directory_size_limit": {"key": "properties.logsDirectorySizeLimit", "type": "int"},
        "detailed_error_logging_enabled": {"key": "properties.detailedErrorLoggingEnabled", "type": "bool"},
        "publishing_username": {"key": "properties.publishingUsername", "type": "str"},
        "app_settings": {"key": "properties.appSettings", "type": "[NameValuePair]"},
        "metadata": {"key": "properties.metadata", "type": "[NameValuePair]"},
        "connection_strings": {"key": "properties.connectionStrings", "type": "[ConnStringInfo]"},
        "machine_key": {"key": "properties.machineKey", "type": "SiteMachineKey"},
        "handler_mappings": {"key": "properties.handlerMappings", "type": "[HandlerMapping]"},
        "document_root": {"key": "properties.documentRoot", "type": "str"},
        "scm_type": {"key": "properties.scmType", "type": "str"},
        "use32_bit_worker_process": {"key": "properties.use32BitWorkerProcess", "type": "bool"},
        "web_sockets_enabled": {"key": "properties.webSocketsEnabled", "type": "bool"},
        "always_on": {"key": "properties.alwaysOn", "type": "bool"},
        "java_version": {"key": "properties.javaVersion", "type": "str"},
        "java_container": {"key": "properties.javaContainer", "type": "str"},
        "java_container_version": {"key": "properties.javaContainerVersion", "type": "str"},
        "app_command_line": {"key": "properties.appCommandLine", "type": "str"},
        "managed_pipeline_mode": {"key": "properties.managedPipelineMode", "type": "str"},
        "virtual_applications": {"key": "properties.virtualApplications", "type": "[VirtualApplication]"},
        "load_balancing": {"key": "properties.loadBalancing", "type": "str"},
        "experiments": {"key": "properties.experiments", "type": "Experiments"},
        "limits": {"key": "properties.limits", "type": "SiteLimits"},
        "auto_heal_enabled": {"key": "properties.autoHealEnabled", "type": "bool"},
        "auto_heal_rules": {"key": "properties.autoHealRules", "type": "AutoHealRules"},
        "tracing_options": {"key": "properties.tracingOptions", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vnet_route_all_enabled": {"key": "properties.vnetRouteAllEnabled", "type": "bool"},
        "vnet_private_ports_count": {"key": "properties.vnetPrivatePortsCount", "type": "int"},
        "cors": {"key": "properties.cors", "type": "CorsSettings"},
        "push": {"key": "properties.push", "type": "PushSettings"},
        "api_definition": {"key": "properties.apiDefinition", "type": "ApiDefinitionInfo"},
        "api_management_config": {"key": "properties.apiManagementConfig", "type": "ApiManagementConfig"},
        "auto_swap_slot_name": {"key": "properties.autoSwapSlotName", "type": "str"},
        "local_my_sql_enabled": {"key": "properties.localMySqlEnabled", "type": "bool"},
        "managed_service_identity_id": {"key": "properties.managedServiceIdentityId", "type": "int"},
        "x_managed_service_identity_id": {"key": "properties.xManagedServiceIdentityId", "type": "int"},
        "key_vault_reference_identity": {"key": "properties.keyVaultReferenceIdentity", "type": "str"},
        "ip_security_restrictions": {"key": "properties.ipSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "ip_security_restrictions_default_action": {
            "key": "properties.ipSecurityRestrictionsDefaultAction",
            "type": "str",
        },
        "scm_ip_security_restrictions": {
            "key": "properties.scmIpSecurityRestrictions",
            "type": "[IpSecurityRestriction]",
        },
        "scm_ip_security_restrictions_default_action": {
            "key": "properties.scmIpSecurityRestrictionsDefaultAction",
            "type": "str",
        },
        "scm_ip_security_restrictions_use_main": {"key": "properties.scmIpSecurityRestrictionsUseMain", "type": "bool"},
        "http20_enabled": {"key": "properties.http20Enabled", "type": "bool"},
        "min_tls_version": {"key": "properties.minTlsVersion", "type": "str"},
        "min_tls_cipher_suite": {"key": "properties.minTlsCipherSuite", "type": "str"},
        "scm_min_tls_version": {"key": "properties.scmMinTlsVersion", "type": "str"},
        "ftps_state": {"key": "properties.ftpsState", "type": "str"},
        "pre_warmed_instance_count": {"key": "properties.preWarmedInstanceCount", "type": "int"},
        "function_app_scale_limit": {"key": "properties.functionAppScaleLimit", "type": "int"},
        "elastic_web_app_scale_limit": {"key": "properties.elasticWebAppScaleLimit", "type": "int"},
        "health_check_path": {"key": "properties.healthCheckPath", "type": "str"},
        "functions_runtime_scale_monitoring_enabled": {
            "key": "properties.functionsRuntimeScaleMonitoringEnabled",
            "type": "bool",
        },
        "website_time_zone": {"key": "properties.websiteTimeZone", "type": "str"},
        "minimum_elastic_instance_count": {"key": "properties.minimumElasticInstanceCount", "type": "int"},
        "azure_storage_accounts": {"key": "properties.azureStorageAccounts", "type": "{AzureStorageInfoValue}"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: str = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        power_shell_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        acr_use_managed_identity_creds: Optional[bool] = None,
        acr_user_managed_identity_id: Optional[str] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["_models.NameValuePair"]] = None,
        metadata: Optional[List["_models.NameValuePair"]] = None,
        connection_strings: Optional[List["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[List["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_route_all_enabled: Optional[bool] = None,
        vnet_private_ports_count: Optional[int] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        api_management_config: Optional["_models.ApiManagementConfig"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: bool = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        key_vault_reference_identity: Optional[str] = None,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        ip_security_restrictions_default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        scm_ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: bool = True,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        min_tls_cipher_suite: Optional[Union[str, "_models.TlsCipherSuites"]] = None,
        scm_min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "_models.FtpsState"]] = None,
        pre_warmed_instance_count: Optional[int] = None,
        function_app_scale_limit: Optional[int] = None,
        elastic_web_app_scale_limit: Optional[int] = None,
        health_check_path: Optional[str] = None,
        functions_runtime_scale_monitoring_enabled: Optional[bool] = None,
        website_time_zone: Optional[str] = None,
        minimum_elastic_instance_count: Optional[int] = None,
        azure_storage_accounts: Optional[Dict[str, "_models.AzureStorageInfoValue"]] = None,
        public_network_access: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword power_shell_version: Version of PowerShell.
        :paramtype power_shell_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword windows_fx_version: Xenon App Framework and version.
        :paramtype windows_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
        :paramtype acr_use_managed_identity_creds: bool
        :keyword acr_user_managed_identity_id: If using user managed identity, the user managed
         identity ClientId.
        :paramtype acr_user_managed_identity_id: str
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
        :keyword metadata: Application metadata. This property cannot be retrieved, since it may
         contain secrets.
        :paramtype metadata: list[~azure.mgmt.web.v2023_01_01.models.NameValuePair]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2023_01_01.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2023_01_01.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", "VSO", and "VSTSRM".
        :paramtype scm_type: str or ~azure.mgmt.web.v2023_01_01.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2023_01_01.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2023_01_01.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash", and
         "PerSiteRoundRobin".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2023_01_01.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2023_01_01.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2023_01_01.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2023_01_01.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
         traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :paramtype vnet_route_all_enabled: bool
        :keyword vnet_private_ports_count: The number of private ports assigned to this app. These will
         be assigned dynamically on runtime.
        :paramtype vnet_private_ports_count: int
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2023_01_01.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2023_01_01.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2023_01_01.models.ApiDefinitionInfo
        :keyword api_management_config: Azure API management settings linked to the app.
        :paramtype api_management_config: ~azure.mgmt.web.v2023_01_01.models.ApiManagementConfig
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword managed_service_identity_id: Managed Service Identity Id.
        :paramtype managed_service_identity_id: int
        :keyword x_managed_service_identity_id: Explicit Managed Service Identity Id.
        :paramtype x_managed_service_identity_id: int
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword ip_security_restrictions: IP security restrictions for main.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2023_01_01.models.IpSecurityRestriction]
        :keyword ip_security_restrictions_default_action: Default action for main access restriction if
         no rules are matched. Known values are: "Allow" and "Deny".
        :paramtype ip_security_restrictions_default_action: str or
         ~azure.mgmt.web.v2023_01_01.models.DefaultAction
        :keyword scm_ip_security_restrictions: IP security restrictions for scm.
        :paramtype scm_ip_security_restrictions:
         list[~azure.mgmt.web.v2023_01_01.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions_default_action: Default action for scm access restriction
         if no rules are matched. Known values are: "Allow" and "Deny".
        :paramtype scm_ip_security_restrictions_default_action: str or
         ~azure.mgmt.web.v2023_01_01.models.DefaultAction
        :keyword scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :paramtype scm_ip_security_restrictions_use_main: bool
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", and "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2023_01_01.models.SupportedTlsVersions
        :keyword min_tls_cipher_suite: The minimum strength TLS cipher suite allowed for an
         application. Known values are: "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256",
         "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
         "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
         "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
         "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
         "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384",
         "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256",
         "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", and
         "TLS_RSA_WITH_AES_128_CBC_SHA".
        :paramtype min_tls_cipher_suite: str or ~azure.mgmt.web.v2023_01_01.models.TlsCipherSuites
        :keyword scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required
         for SSL requests for SCM site. Known values are: "1.0", "1.1", and "1.2".
        :paramtype scm_min_tls_version: str or ~azure.mgmt.web.v2023_01_01.models.SupportedTlsVersions
        :keyword ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly",
         and "Disabled".
        :paramtype ftps_state: str or ~azure.mgmt.web.v2023_01_01.models.FtpsState
        :keyword pre_warmed_instance_count: Number of preWarmed instances.
         This setting only applies to the Consumption and Elastic Plans.
        :paramtype pre_warmed_instance_count: int
        :keyword function_app_scale_limit: Maximum number of workers that a site can scale out to.
         This setting only applies to the Consumption and Elastic Premium Plans.
        :paramtype function_app_scale_limit: int
        :keyword elastic_web_app_scale_limit: Maximum number of workers that a site can scale out to.
         This setting only applies to apps in plans where ElasticScaleEnabled is
         :code:`<code>true</code>`.
        :paramtype elastic_web_app_scale_limit: int
        :keyword health_check_path: Health check path.
        :paramtype health_check_path: str
        :keyword functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
         functions runtime scale monitoring is enabled. When enabled,
         the ScaleController will not monitor event sources directly, but will instead call to the
         runtime to get scale status.
        :paramtype functions_runtime_scale_monitoring_enabled: bool
        :keyword website_time_zone: Sets the time zone a site uses for generating timestamps.
         Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes
         precedence over this config. For Linux, expects tz database values
         https://www.iana.org/time-zones (for a quick reference see
         https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the
         time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows
         NT\\CurrentVersion\\Time Zones.
        :paramtype website_time_zone: str
        :keyword minimum_elastic_instance_count: Number of minimum instance count for a site
         This setting only applies to the Elastic Plans.
        :paramtype minimum_elastic_instance_count: int
        :keyword azure_storage_accounts: List of Azure Storage Accounts.
        :paramtype azure_storage_accounts: dict[str,
         ~azure.mgmt.web.v2023_01_01.models.AzureStorageInfoValue]
        :keyword public_network_access: Property to allow or block all public traffic.
        :paramtype public_network_access: str
        """
        super().__init__(kind=kind, **kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.power_shell_version = power_shell_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.acr_use_managed_identity_creds = acr_use_managed_identity_creds
        self.acr_user_managed_identity_id = acr_user_managed_identity_id
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.metadata = metadata
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.vnet_route_all_enabled = vnet_route_all_enabled
        self.vnet_private_ports_count = vnet_private_ports_count
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.api_management_config = api_management_config
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.key_vault_reference_identity = key_vault_reference_identity
        self.ip_security_restrictions = ip_security_restrictions
        self.ip_security_restrictions_default_action = ip_security_restrictions_default_action
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_default_action = scm_ip_security_restrictions_default_action
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version
        self.min_tls_cipher_suite = min_tls_cipher_suite
        self.scm_min_tls_version = scm_min_tls_version
        self.ftps_state = ftps_state
        self.pre_warmed_instance_count = pre_warmed_instance_count
        self.function_app_scale_limit = function_app_scale_limit
        self.elastic_web_app_scale_limit = elastic_web_app_scale_limit
        self.health_check_path = health_check_path
        self.functions_runtime_scale_monitoring_enabled = functions_runtime_scale_monitoring_enabled
        self.website_time_zone = website_time_zone
        self.minimum_elastic_instance_count = minimum_elastic_instance_count
        self.azure_storage_accounts = azure_storage_accounts
        self.public_network_access = public_network_access


class SiteConfigResourceCollection(_serialization.Model):
    """Collection of site configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.SiteConfigResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SiteConfigResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SiteConfigResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.SiteConfigResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteConfigurationSnapshotInfo(ProxyOnlyResource):
    """A snapshot of a web app configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: ~datetime.datetime
    :ivar snapshot_id: The id of the snapshot.
    :vartype snapshot_id: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "time": {"readonly": True},
        "snapshot_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "time": {"key": "properties.time", "type": "iso-8601"},
        "snapshot_id": {"key": "properties.snapshotId", "type": "int"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.time = None
        self.snapshot_id = None


class SiteConfigurationSnapshotInfoCollection(_serialization.Model):
    """Collection of metadata for the app configuration snapshots that can be restored.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.SiteConfigurationSnapshotInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SiteConfigurationSnapshotInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SiteConfigurationSnapshotInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.SiteConfigurationSnapshotInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteExtensionInfo(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Site Extension Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar extension_id: Site extension ID.
    :vartype extension_id: str
    :ivar title:
    :vartype title: str
    :ivar extension_type: Site extension type. Known values are: "Gallery" and "WebRoot".
    :vartype extension_type: str or ~azure.mgmt.web.v2023_01_01.models.SiteExtensionType
    :ivar summary: Summary description.
    :vartype summary: str
    :ivar description: Detailed description.
    :vartype description: str
    :ivar version: Version information.
    :vartype version: str
    :ivar extension_url: Extension URL.
    :vartype extension_url: str
    :ivar project_url: Project URL.
    :vartype project_url: str
    :ivar icon_url: Icon URL.
    :vartype icon_url: str
    :ivar license_url: License URL.
    :vartype license_url: str
    :ivar feed_url: Feed URL.
    :vartype feed_url: str
    :ivar authors: List of authors.
    :vartype authors: list[str]
    :ivar installer_command_line_params: Installer command line parameters.
    :vartype installer_command_line_params: str
    :ivar published_date_time: Published timestamp.
    :vartype published_date_time: ~datetime.datetime
    :ivar download_count: Count of downloads.
    :vartype download_count: int
    :ivar local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
     version; :code:`<code>false</code>` otherwise.
    :vartype local_is_latest_version: bool
    :ivar local_path: Local path.
    :vartype local_path: str
    :ivar installed_date_time: Installed timestamp.
    :vartype installed_date_time: ~datetime.datetime
    :ivar provisioning_state: Provisioning state.
    :vartype provisioning_state: str
    :ivar comment: Site Extension comment.
    :vartype comment: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "extension_id": {"key": "properties.extension_id", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "extension_type": {"key": "properties.extension_type", "type": "str"},
        "summary": {"key": "properties.summary", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "extension_url": {"key": "properties.extension_url", "type": "str"},
        "project_url": {"key": "properties.project_url", "type": "str"},
        "icon_url": {"key": "properties.icon_url", "type": "str"},
        "license_url": {"key": "properties.license_url", "type": "str"},
        "feed_url": {"key": "properties.feed_url", "type": "str"},
        "authors": {"key": "properties.authors", "type": "[str]"},
        "installer_command_line_params": {"key": "properties.installer_command_line_params", "type": "str"},
        "published_date_time": {"key": "properties.published_date_time", "type": "iso-8601"},
        "download_count": {"key": "properties.download_count", "type": "int"},
        "local_is_latest_version": {"key": "properties.local_is_latest_version", "type": "bool"},
        "local_path": {"key": "properties.local_path", "type": "str"},
        "installed_date_time": {"key": "properties.installed_date_time", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "comment": {"key": "properties.comment", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        extension_id: Optional[str] = None,
        title: Optional[str] = None,
        extension_type: Optional[Union[str, "_models.SiteExtensionType"]] = None,
        summary: Optional[str] = None,
        description: Optional[str] = None,
        version: Optional[str] = None,
        extension_url: Optional[str] = None,
        project_url: Optional[str] = None,
        icon_url: Optional[str] = None,
        license_url: Optional[str] = None,
        feed_url: Optional[str] = None,
        authors: Optional[List[str]] = None,
        installer_command_line_params: Optional[str] = None,
        published_date_time: Optional[datetime.datetime] = None,
        download_count: Optional[int] = None,
        local_is_latest_version: Optional[bool] = None,
        local_path: Optional[str] = None,
        installed_date_time: Optional[datetime.datetime] = None,
        provisioning_state: Optional[str] = None,
        comment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword extension_id: Site extension ID.
        :paramtype extension_id: str
        :keyword title:
        :paramtype title: str
        :keyword extension_type: Site extension type. Known values are: "Gallery" and "WebRoot".
        :paramtype extension_type: str or ~azure.mgmt.web.v2023_01_01.models.SiteExtensionType
        :keyword summary: Summary description.
        :paramtype summary: str
        :keyword description: Detailed description.
        :paramtype description: str
        :keyword version: Version information.
        :paramtype version: str
        :keyword extension_url: Extension URL.
        :paramtype extension_url: str
        :keyword project_url: Project URL.
        :paramtype project_url: str
        :keyword icon_url: Icon URL.
        :paramtype icon_url: str
        :keyword license_url: License URL.
        :paramtype license_url: str
        :keyword feed_url: Feed URL.
        :paramtype feed_url: str
        :keyword authors: List of authors.
        :paramtype authors: list[str]
        :keyword installer_command_line_params: Installer command line parameters.
        :paramtype installer_command_line_params: str
        :keyword published_date_time: Published timestamp.
        :paramtype published_date_time: ~datetime.datetime
        :keyword download_count: Count of downloads.
        :paramtype download_count: int
        :keyword local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
         version; :code:`<code>false</code>` otherwise.
        :paramtype local_is_latest_version: bool
        :keyword local_path: Local path.
        :paramtype local_path: str
        :keyword installed_date_time: Installed timestamp.
        :paramtype installed_date_time: ~datetime.datetime
        :keyword provisioning_state: Provisioning state.
        :paramtype provisioning_state: str
        :keyword comment: Site Extension comment.
        :paramtype comment: str
        """
        super().__init__(kind=kind, **kwargs)
        self.extension_id = extension_id
        self.title = title
        self.extension_type = extension_type
        self.summary = summary
        self.description = description
        self.version = version
        self.extension_url = extension_url
        self.project_url = project_url
        self.icon_url = icon_url
        self.license_url = license_url
        self.feed_url = feed_url
        self.authors = authors
        self.installer_command_line_params = installer_command_line_params
        self.published_date_time = published_date_time
        self.download_count = download_count
        self.local_is_latest_version = local_is_latest_version
        self.local_path = local_path
        self.installed_date_time = installed_date_time
        self.provisioning_state = provisioning_state
        self.comment = comment


class SiteExtensionInfoCollection(_serialization.Model):
    """Collection of Kudu site extension information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2023_01_01.models.SiteExtensionInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SiteExtensionInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SiteExtensionInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2023_01_01.models.SiteExtensionInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteLimits(_serialization.Model):
    """Metric limits set on an app.

    :ivar max_percentage_cpu: Maximum allowed CPU usage percentage.
    :vartype max_percentage_cpu: float
    :ivar max_memory_in_mb: Maximum allowed memory usage in MB.
    :vartype max_memory_in_mb: int
    :ivar max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :vartype max_disk_size_in_mb: int
    """

    _attribute_map = {
        "max_percentage_cpu": {"key": "maxPercentageCpu", "type": "float"},
        "max_memory_in_mb": {"key": "maxMemoryInMb", "type": "int"},
        "max_disk_size_in_mb": {"key": "maxDiskSizeInMb", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_percentage_cpu: Optional[float] = None,
        max_memory_in_mb: Optional[int] = None,
        max_disk_size_in_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_percentage_cpu: Maximum allowed CPU usage percentage.
        :paramtype max_percentage_cpu: float
        :keyword max_memory_in_mb: Maximum allowed memory usage in MB.
        :paramtype max_memory_in_mb: int
        :keyword max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :paramtype max_disk_size_in_mb: int
        """
        super().__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteLogsConfig(ProxyOnlyResource):
    """Configuration of App Service site logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar application_logs: Application logs configuration.
    :vartype application_logs: ~azure.mgmt.web.v2023_01_01.models.ApplicationLogsConfig
    :ivar http_logs: HTTP logs configuration.
    :vartype http_logs: ~azure.mgmt.web.v2023_01_01.models.HttpLogsConfig
    :ivar failed_requests_tracing: Failed requests tracing configuration.
    :vartype failed_requests_tracing: ~azure.mgmt.web.v2023_01_01.models.EnabledConfig
    :ivar detailed_error_messages: Detailed error messages configuration.
    :vartype detailed_error_messages: ~azure.mgmt.web.v2023_01_01.models.EnabledConfig
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "application_logs": {"key": "properties.applicationLogs", "type": "ApplicationLogsConfig"},
        "http_logs": {"key": "properties.httpLogs", "type": "HttpLogsConfig"},
        "failed_requests_tracing": {"key": "properties.failedRequestsTracing", "type": "EnabledConfig"},
        "detailed_error_messages": {"key": "properties.detailedErrorMessages", "type": "EnabledConfig"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        application_logs: Optional["_models.ApplicationLogsConfig"] = None,
        http_logs: Optional["_models.HttpLogsConfig"] = None,
        failed_requests_tracing: Optional["_models.EnabledConfig"] = None,
        detailed_error_messages: Optional["_models.EnabledConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword application_logs: Application logs configuration.
        :paramtype application_logs: ~azure.mgmt.web.v2023_01_01.models.ApplicationLogsConfig
        :keyword http_logs: HTTP logs configuration.
        :paramtype http_logs: ~azure.mgmt.web.v2023_01_01.models.HttpLogsConfig
        :keyword failed_requests_tracing: Failed requests tracing configuration.
        :paramtype failed_requests_tracing: ~azure.mgmt.web.v2023_01_01.models.EnabledConfig
        :keyword detailed_error_messages: Detailed error messages configuration.
        :paramtype detailed_error_messages: ~azure.mgmt.web.v2023_01_01.models.EnabledConfig
        """
        super().__init__(kind=kind, **kwargs)
        self.application_logs = application_logs
        self.http_logs = http_logs
        self.failed_requests_tracing = failed_requests_tracing
        self.detailed_error_messages = detailed_error_messages


class SiteMachineKey(_serialization.Model):
    """MachineKey of an app.

    :ivar validation: MachineKey validation.
    :vartype validation: str
    :ivar validation_key: Validation key.
    :vartype validation_key: str
    :ivar decryption: Algorithm used for decryption.
    :vartype decryption: str
    :ivar decryption_key: Decryption key.
    :vartype decryption_key: str
    """

    _attribute_map = {
        "validation": {"key": "validation", "type": "str"},
        "validation_key": {"key": "validationKey", "type": "str"},
        "decryption": {"key": "decryption", "type": "str"},
        "decryption_key": {"key": "decryptionKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        validation: Optional[str] = None,
        validation_key: Optional[str] = None,
        decryption: Optional[str] = None,
        decryption_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword validation: MachineKey validation.
        :paramtype validation: str
        :keyword validation_key: Validation key.
        :paramtype validation_key: str
        :keyword decryption: Algorithm used for decryption.
        :paramtype decryption: str
        :keyword decryption_key: Decryption key.
        :paramtype decryption_key: str
        """
        super().__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SitePatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal" and "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2023_01_01.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", and "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2023_01_01.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2023_01_01.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".  # pylint: disable=line-too-long
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: Hyper-V sandbox.
    :vartype is_xenon: bool
    :ivar hyper_v: Hyper-V sandbox.
    :vartype hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2023_01_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar client_cert_mode: This composes with ClientCertEnabled setting.


     * ClientCertEnabled: false means ClientCert is ignored.
     * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
     accepted. Known values are: "Required", "Optional", and "OptionalInteractiveUser".
    :vartype client_cert_mode: str or ~azure.mgmt.web.v2023_01_01.models.ClientCertMode
    :ivar client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :vartype client_cert_exclusion_paths: str
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar custom_domain_verification_id: Unique identifier that verifies the custom domains
     assigned to the app. Customer will add this id to a txt record for verification.
    :vartype custom_domain_verification_id: str
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2023_01_01.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2023_01_01.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    :ivar redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
     "ActiveActive", and "GeoRedundant".
    :vartype redundancy_mode: str or ~azure.mgmt.web.v2023_01_01.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :ivar storage_account_required: Checks if Customer provided storage account is required.
    :vartype storage_account_required: bool
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet to
     be joined by Regional VNET Integration.
     This must be of the form
     /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype virtual_network_subnet_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "host_names": {"readonly": True},
        "repository_site_name": {"readonly": True},
        "usage_state": {"readonly": True},
        "enabled_host_names": {"readonly": True},
        "availability_state": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "traffic_manager_host_names": {"readonly": True},
        "target_swap_slot": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "possible_outbound_ip_addresses": {"readonly": True},
        "suspended_till": {"readonly": True},
        "max_number_of_workers": {"readonly": True},
        "resource_group": {"readonly": True},
        "is_default_container": {"readonly": True},
        "default_host_name": {"readonly": True},
        "slot_swap_status": {"readonly": True},
        "in_progress_operation_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "state": {"key": "properties.state", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "repository_site_name": {"key": "properties.repositorySiteName", "type": "str"},
        "usage_state": {"key": "properties.usageState", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "enabled_host_names": {"key": "properties.enabledHostNames", "type": "[str]"},
        "availability_state": {"key": "properties.availabilityState", "type": "str"},
        "host_name_ssl_states": {"key": "properties.hostNameSslStates", "type": "[HostNameSslState]"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "site_config": {"key": "properties.siteConfig", "type": "SiteConfig"},
        "traffic_manager_host_names": {"key": "properties.trafficManagerHostNames", "type": "[str]"},
        "scm_site_also_stopped": {"key": "properties.scmSiteAlsoStopped", "type": "bool"},
        "target_swap_slot": {"key": "properties.targetSwapSlot", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "client_affinity_enabled": {"key": "properties.clientAffinityEnabled", "type": "bool"},
        "client_cert_enabled": {"key": "properties.clientCertEnabled", "type": "bool"},
        "client_cert_mode": {"key": "properties.clientCertMode", "type": "str"},
        "client_cert_exclusion_paths": {"key": "properties.clientCertExclusionPaths", "type": "str"},
        "host_names_disabled": {"key": "properties.hostNamesDisabled", "type": "bool"},
        "custom_domain_verification_id": {"key": "properties.customDomainVerificationId", "type": "str"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "str"},
        "possible_outbound_ip_addresses": {"key": "properties.possibleOutboundIpAddresses", "type": "str"},
        "container_size": {"key": "properties.containerSize", "type": "int"},
        "daily_memory_time_quota": {"key": "properties.dailyMemoryTimeQuota", "type": "int"},
        "suspended_till": {"key": "properties.suspendedTill", "type": "iso-8601"},
        "max_number_of_workers": {"key": "properties.maxNumberOfWorkers", "type": "int"},
        "cloning_info": {"key": "properties.cloningInfo", "type": "CloningInfo"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "is_default_container": {"key": "properties.isDefaultContainer", "type": "bool"},
        "default_host_name": {"key": "properties.defaultHostName", "type": "str"},
        "slot_swap_status": {"key": "properties.slotSwapStatus", "type": "SlotSwapStatus"},
        "https_only": {"key": "properties.httpsOnly", "type": "bool"},
        "redundancy_mode": {"key": "properties.redundancyMode", "type": "str"},
        "in_progress_operation_id": {"key": "properties.inProgressOperationId", "type": "str"},
        "storage_account_required": {"key": "properties.storageAccountRequired", "type": "bool"},
        "key_vault_reference_identity": {"key": "properties.keyVaultReferenceIdentity", "type": "str"},
        "virtual_network_subnet_id": {"key": "properties.virtualNetworkSubnetId", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        site_config: Optional["_models.SiteConfig"] = None,
        scm_site_also_stopped: bool = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_mode: Optional[Union[str, "_models.ClientCertMode"]] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        host_names_disabled: Optional[bool] = None,
        custom_domain_verification_id: Optional[str] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "_models.RedundancyMode"]] = None,
        storage_account_required: Optional[bool] = None,
        key_vault_reference_identity: Optional[str] = None,
        virtual_network_subnet_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2023_01_01.models.ManagedServiceIdentity
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2023_01_01.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".  # pylint: disable=line-too-long
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: Hyper-V sandbox.
        :paramtype is_xenon: bool
        :keyword hyper_v: Hyper-V sandbox.
        :paramtype hyper_v: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2023_01_01.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2023_01_01.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword client_cert_mode: This composes with ClientCertEnabled setting.


         * ClientCertEnabled: false means ClientCert is ignored.
         * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
         * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
         accepted. Known values are: "Required", "Optional", and "OptionalInteractiveUser".
        :paramtype client_cert_mode: str or ~azure.mgmt.web.v2023_01_01.models.ClientCertMode
        :keyword client_cert_exclusion_paths: client certificate authentication comma-separated
         exclusion paths.
        :paramtype client_cert_exclusion_paths: str
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword custom_domain_verification_id: Unique identifier that verifies the custom domains
         assigned to the app. Customer will add this id to a txt record for verification.
        :paramtype custom_domain_verification_id: str
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2023_01_01.models.CloningInfo
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        :keyword redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
         "ActiveActive", and "GeoRedundant".
        :paramtype redundancy_mode: str or ~azure.mgmt.web.v2023_01_01.models.RedundancyMode
        :keyword storage_account_required: Checks if Customer provided storage account is required.
        :paramtype storage_account_required: bool
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet
         to be joined by Regional VNET Integration.
         This must be of the form
         /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype virtual_network_subnet_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.identity = identity
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_mode = client_cert_mode
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.host_names_disabled = host_names_disabled
        self.custom_domain_verification_id = custom_domain_verification_id
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id = None
        self.storage_account_required = storage_account_required
        self.key_vault_reference_identity = key_vault_reference_identity
        self.virtual_network_subnet_id = virtual_network_subnet_id


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar local_log_errors: Local log_errors setting.
    :vartype local_log_errors: str
    :ivar master_log_errors: Master log_errors setting.
    :vartype master_log_errors: str
    :ivar local_log_errors_max_length: Local log_errors_max_len setting.
    :vartype local_log_errors_max_length: str
    :ivar master_log_errors_max_length: Master log_errors_max_len setting.
    :vartype master_log_errors_max_length: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "local_log_errors": {"key": "properties.localLogErrors", "type": "str"},
        "master_log_errors": {"key": "properties.masterLogErrors", "type": "str"},
        "local_log_errors_max_length": {"key": "properties.localLogErrorsMaxLength", "type": "str"},
        "master_log_errors_max_length": {"key": "properties.masterLogErrorsMaxLength", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        local_log_errors: Optional[str] = None,
        master_log_errors: Optional[str] = None,
        local_log_errors_max_length: Optional[str] = None,
        master_log_errors_max_length: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword local_log_errors: Local log_errors setting.
        :paramtype local_log_errors: str
        :keyword master_log_errors: Master log_errors setting.
        :paramtype master_log_errors: str
        :keyword local_log_errors_max_length: Local log_errors_max_len setting.
        :paramtype local_log_errors_max_length: str
        :keyword master_log_errors_max_length: Master log_errors_max_len setting.
        :paramtype master_log_errors_max_length: str
        """
        super().__init__(kind=kind, **kwargs)
        self.local_log_errors = local_log_errors
        self.master_log_errors = master_log_errors
        self.local_log_errors_max_length = local_log_errors_max_length
        self.master_log_errors_max_length = master_log_errors_max_length


class SiteSeal(_serialization.Model):
    """Site seal.

    All required parameters must be populated in order to send to server.

    :ivar html: HTML snippet. Required.
    :vartype html: str
    """

    _validation = {
        "html": {"required": True},
    }

    _attribute_map = {
        "html": {"key": "html", "type": "str"},
    }

    def __init__(self, *, html: str, **kwargs: Any) -> None:
        """
        :keyword html: HTML snippet. Required.
        :paramtype html: str
        """
        super().__init__(**kwargs)
        self.html = html


class SiteSealRequest(_serialization.Model):
    """Site seal request.

    :ivar light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
     otherwise, use the default color theme.
    :vartype light_theme: bool
    :ivar locale: Locale of site seal.
    :vartype locale: str
    """

    _attribute_map = {
        "light_theme": {"key": "lightTheme", "type": "bool"},
        "locale": {"key": "locale", "type": "str"},
    }

    def __init__(self, *, light_theme: Optional[bool] = None, locale: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
         otherwise, use the default color theme.
        :paramtype light_theme: bool
        :keyword locale: Locale of site seal.
        :paramtype locale: str
        """
        super().__init__(**kwargs)
        self.light_theme = light_theme
        self.locale = locale


class SiteSourceControl(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Source control configuration for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar repo_url: Repository or source control URL.
    :vartype repo_url: str
    :ivar branch: Name of branch to use for deployment.
    :vartype branch: str
    :ivar is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
     :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
     online repos like GitHub).
    :vartype is_manual_integration: bool
    :ivar is_git_hub_action: :code:`<code>true</code>` if this is deployed via GitHub action.
    :vartype is_git_hub_action: bool
    :ivar deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
     otherwise, :code:`<code>false</code>`.
    :vartype deployment_rollback_enabled: bool
    :ivar is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
     :code:`<code>false</code>` for a Git repository.
    :vartype is_mercurial: bool
    :ivar git_hub_action_configuration: If GitHub Action is selected, than the associated
     configuration.
    :vartype git_hub_action_configuration:
     ~azure.mgmt.web.v2023_01_01.models.GitHubActionConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "repo_url": {"key": "properties.repoUrl", "type": "str"},
        "branch": {"key": "properties.branch", "type": "str"},
        "is_manual_integration": {"key": "properties.isManualIntegration", "type": "bool"},
        "is_git_hub_action": {"key": "properties.isGitHubAction", "type": "bool"},
        "deployment_rollback_enabled": {"key": "properties.deploymentRollbackEnabled", "type": "bool"},
        "is_mercurial": {"key": "properties.isMercurial", "type": "bool"},
        "git_hub_action_configuration": {
            "key": "properties.gitHubActionConfiguration",
            "type": "GitHubActionConfiguration",
        },
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        is_manual_integration: Optional[bool] = None,
        is_git_hub_action: Optional[bool] = None,
        deployment_rollback_enabled: Optional[bool] = None,
        is_mercurial: Optional[bool] = None,
        git_hub_action_configuration: Optional["_models.GitHubActionConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword repo_url: Repository or source control URL.
        :paramtype repo_url: str
        :keyword branch: Name of branch to use for deployment.
        :paramtype branch: str
        :keyword is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
         :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
         online repos like GitHub).
        :paramtype is_manual_integration: bool
        :keyword is_git_hub_action: :code:`<code>true</code>` if this is deployed via GitHub action.
        :paramtype is_git_hub_action: bool
        :keyword deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
         otherwise, :code:`<code>false</code>`.
        :paramtype deployment_rollback_enabled: bool
        :keyword is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
         :code:`<code>false</code>` for a Git repository.
        :paramtype is_mercurial: bool
        :keyword git_hub_action_configuration: If GitHub Action is selected, th