# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class DataSource(Model):
    """Data source object contains configuration to collect telemetry and one or
    more sinks to send that telemetry data to.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Datasource kind. Possible values include:
     'PerformanceCounter', 'ETWProviders', 'WindowsEventLogs'
    :type kind: str or ~azure.mgmt.monitor.v2018_06_01_preview.models.enum
    :param configuration: Required.
    :type configuration:
     ~azure.mgmt.monitor.v2018_06_01_preview.models.DataSourceConfiguration
    :param sinks: Required.
    :type sinks:
     list[~azure.mgmt.monitor.v2018_06_01_preview.models.SinkConfiguration]
    """

    _validation = {
        'kind': {'required': True},
        'configuration': {'required': True},
        'sinks': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'DataSourceConfiguration'},
        'sinks': {'key': 'sinks', 'type': '[SinkConfiguration]'},
    }

    def __init__(self, **kwargs):
        super(DataSource, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.configuration = kwargs.get('configuration', None)
        self.sinks = kwargs.get('sinks', None)


class DataSourceConfiguration(Model):
    """DataSourceConfiguration.

    :param providers: ETW providers configuration
    :type providers:
     list[~azure.mgmt.monitor.v2018_06_01_preview.models.EtwProviderConfiguration]
    :param perf_counters: Performance counter configuration
    :type perf_counters:
     list[~azure.mgmt.monitor.v2018_06_01_preview.models.PerformanceCounterConfiguration]
    :param event_logs: Windows event logs configuration.
    :type event_logs:
     list[~azure.mgmt.monitor.v2018_06_01_preview.models.EventLogConfiguration]
    """

    _attribute_map = {
        'providers': {'key': 'providers', 'type': '[EtwProviderConfiguration]'},
        'perf_counters': {'key': 'perfCounters', 'type': '[PerformanceCounterConfiguration]'},
        'event_logs': {'key': 'eventLogs', 'type': '[EventLogConfiguration]'},
    }

    def __init__(self, **kwargs):
        super(DataSourceConfiguration, self).__init__(**kwargs)
        self.providers = kwargs.get('providers', None)
        self.perf_counters = kwargs.get('perf_counters', None)
        self.event_logs = kwargs.get('event_logs', None)


class ErrorResponse(Model):
    """Describes the format of Error response.

    :param code: Error code
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class EtwEventConfiguration(Model):
    """EtwEventConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param id: Required.
    :type id: int
    :param filter:
    :type filter: str
    """

    _validation = {
        'name': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'int'},
        'filter': {'key': 'filter', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EtwEventConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.filter = kwargs.get('filter', None)


class EtwProviderConfiguration(Model):
    """EtwProviderConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param events: Required.
    :type events:
     list[~azure.mgmt.monitor.v2018_06_01_preview.models.EtwEventConfiguration]
    """

    _validation = {
        'id': {'required': True},
        'events': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'events': {'key': 'events', 'type': '[EtwEventConfiguration]'},
    }

    def __init__(self, **kwargs):
        super(EtwProviderConfiguration, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.events = kwargs.get('events', None)


class EventLogConfiguration(Model):
    """EventLogConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param log_name: Required.
    :type log_name: str
    :param filter:
    :type filter: str
    """

    _validation = {
        'log_name': {'required': True},
    }

    _attribute_map = {
        'log_name': {'key': 'logName', 'type': 'str'},
        'filter': {'key': 'filter', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EventLogConfiguration, self).__init__(**kwargs)
        self.log_name = kwargs.get('log_name', None)
        self.filter = kwargs.get('filter', None)


class Resource(Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class GuestDiagnosticSettingsAssociationResource(Resource):
    """Virtual machine guest diagnostic settings resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param guest_diagnostic_settings_name: Required. The guest diagnostic
     settings name.
    :type guest_diagnostic_settings_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'guest_diagnostic_settings_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'guest_diagnostic_settings_name': {'key': 'properties.guestDiagnosticSettingsName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GuestDiagnosticSettingsAssociationResource, self).__init__(**kwargs)
        self.guest_diagnostic_settings_name = kwargs.get('guest_diagnostic_settings_name', None)


class GuestDiagnosticSettingsAssociationResourcePatch(Model):
    """Guest diagnostic setting resource for patch operations.

    All required parameters must be populated in order to send to Azure.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param guest_diagnostic_settings_name: Required. The guest diagnostic
     settings name.
    :type guest_diagnostic_settings_name: str
    """

    _validation = {
        'guest_diagnostic_settings_name': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'guest_diagnostic_settings_name': {'key': 'properties.guestDiagnosticSettingsName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GuestDiagnosticSettingsAssociationResourcePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.guest_diagnostic_settings_name = kwargs.get('guest_diagnostic_settings_name', None)


class GuestDiagnosticSettingsPatchResource(Model):
    """An diagnostic settings object for the body of patch operations.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param os_type: Operating system type for the configuration. Possible
     values include: 'Windows', 'Linux'
    :type os_type: str or ~azure.mgmt.monitor.v2018_06_01_preview.models.enum
    :param data_sources: the array of data source object which are configured
     to collect and send data
    :type data_sources:
     list[~azure.mgmt.monitor.v2018_06_01_preview.models.DataSource]
    :param proxy_setting:
    :type proxy_setting: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': '[DataSource]'},
        'proxy_setting': {'key': 'properties.proxySetting', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GuestDiagnosticSettingsPatchResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.os_type = kwargs.get('os_type', None)
        self.data_sources = kwargs.get('data_sources', None)
        self.proxy_setting = kwargs.get('proxy_setting', None)


class GuestDiagnosticSettingsResource(Resource):
    """Virtual machine guest diagnostics settings resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param os_type: Operating system type for the configuration. Possible
     values include: 'Windows', 'Linux'
    :type os_type: str or ~azure.mgmt.monitor.v2018_06_01_preview.models.enum
    :param data_sources: the array of data source object which are configured
     to collect and send data
    :type data_sources:
     list[~azure.mgmt.monitor.v2018_06_01_preview.models.DataSource]
    :param proxy_setting:
    :type proxy_setting: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': '[DataSource]'},
        'proxy_setting': {'key': 'properties.proxySetting', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GuestDiagnosticSettingsResource, self).__init__(**kwargs)
        self.os_type = kwargs.get('os_type', None)
        self.data_sources = kwargs.get('data_sources', None)
        self.proxy_setting = kwargs.get('proxy_setting', None)


class PerformanceCounterConfiguration(Model):
    """PerformanceCounterConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param sampling_period: Required.
    :type sampling_period: str
    :param instance:
    :type instance: str
    """

    _validation = {
        'name': {'required': True},
        'sampling_period': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sampling_period': {'key': 'samplingPeriod', 'type': 'str'},
        'instance': {'key': 'instance', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PerformanceCounterConfiguration, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.sampling_period = kwargs.get('sampling_period', None)
        self.instance = kwargs.get('instance', None)


class SinkConfiguration(Model):
    """SinkConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Possible values include: 'EventHub',
     'ApplicationInsights', 'LogAnalytics'
    :type kind: str or ~azure.mgmt.monitor.v2018_06_01_preview.models.enum
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SinkConfiguration, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
