import os
import re

from setuptools import find_packages, setup


with open(os.path.join(os.path.abspath(os.path.dirname(
        __file__)), 'aiohttp_security', '__init__.py'), 'r', encoding='latin1') as fp:
    try:
        version = re.findall(r"^__version__ = '([^']+)'$", fp.read(), re.M)[0]
    except IndexError:
        raise RuntimeError('Unable to determine version.')


def read(f):
    return open(os.path.join(os.path.dirname(__file__), f)).read().strip()


install_requires = ["aiohttp>=3.9"]
tests_require = install_requires + ['pytest']
extras_require = {'session': 'aiohttp-session'}


setup(name='aiohttp-security',
      version=version,
      description=("security for aiohttp.web"),
      long_description='\n\n'.join((read("README.rst"), read("CHANGES.rst"))),
      long_description_content_type="text/x-rst",
      classifiers=[
          'License :: OSI Approved :: Apache Software License',
          'Intended Audience :: Developers',
          'Programming Language :: Python',
          'Programming Language :: Python :: 3',
          "Programming Language :: Python :: 3.8",
          "Programming Language :: Python :: 3.9",
          "Programming Language :: Python :: 3.10",
          "Programming Language :: Python :: 3.11",
          "Programming Language :: Python :: 3.12",
          'Topic :: Internet :: WWW/HTTP',
          'Framework :: AsyncIO',
      ],
      author='Andrew Svetlov',
      author_email='andrew.svetlov@gmail.com',
      url='https://github.com/aio-libs/aiohttp_security/',
      license='Apache 2',
      packages=find_packages(),
      install_requires=install_requires,
      tests_require=tests_require,
      include_package_data=True,
      extras_require=extras_require)
