# _private_dict.py
# This file is autogenerated by "make_private_dict_alt.py",
# from private elements list maintained by the GDCM project
# (http://gdcm.svn.sf.net/viewvc/gdcm/trunk/Source/DataDictionary/privatedicts.xml).
# Downloaded on 2010-01-22.
# See the license.txt file for license information on pydicom, and GDCM.

# This is a dictionary of DICOM dictionaries.
# The outer dictionary key is the Private Creator name ("owner"),
# the inner dictionary is a map of DICOM tag to 
# (VR, type, name, is_retired)

private_dictionaries = \
{'1.2.840.113663.1': {'0029xx00': ('US', '1', 'Unknown', ''),
                      '0029xx01': ('US', '1', 'Unknown', '')},
 '1.2.840.113681': {'0019xx10': ('ST', '1', 'CR Image Params Common', ''),
                    '0019xx11': ('ST', '1', 'CR Image IP Params Single', ''),
                    '0019xx12': ('ST', '1', 'CR Image IP Params Left', ''),
                    '0019xx13': ('ST', '1', 'CR Image IP Params Right', '')},
 '1.2.840.113708.794.1.1.2.0': {'0087xx10': ('CS', '1', 'Media Type', ''),
                                '0087xx20': ('CS', '1', 'Media Location', ''),
                                '0087xx30': ('ST',
                                             '1',
                                             'Storage File ID',
                                             ''),
                                '0087xx40': ('DS',
                                             '1',
                                             'Study or Image Size in MB',
                                             ''),
                                '0087xx50': ('IS',
                                             '1',
                                             'Estimated Retrieve Time',
                                             '')},
 '2.16.840.1.114059.1.1.6.1.50.1': {'0029xx20': ('LT',
                                                 '1',
                                                 'Description',
                                                 ''),
                                    '0029xx21': ('ST',
                                                 '1',
                                                 'Orientation',
                                                 ''),
                                    '0029xx22': ('ST',
                                                 '1',
                                                 'Parameter 1',
                                                 ''),
                                    '0029xx23': ('ST',
                                                 '1',
                                                 'Parameter 2',
                                                 ''),
                                    '0029xx24': ('LO', '1', 'Teeth', ''),
                                    '0029xx25': ('LO', '1', 'Jaw', ''),
                                    '0029xx26': ('LO', '1', 'Quadrant', ''),
                                    '0029xx27': ('LO', '1', 'CRC', '')},
 'A.L.I. Technologies, Inc.': {'3711xx01': ('LO', '1', 'Filename', ''),
                               '3711xx02': ('OB',
                                            '1',
                                            'Data Blob of a Visit',
                                            ''),
                               '3711xx03': ('US', '1', 'Revision Number', ''),
                               '3711xx04': ('UL', '1', 'Unix Timestamp', ''),
                               '3711xx05': ('IS', '1', 'Bag ID', ''),
                               '3711xx0c': ('UI',
                                            '1',
                                            'Original Study UID',
                                            ''),
                               '3711xx0d': ('US',
                                            '1',
                                            'Overlay Grayscale Value',
                                            ''),
                               '3711xx0e': ('CS',
                                            '1',
                                            'Anonymization Status',
                                            '')},
 'ACUSON': {'0009xx00': ('IS', '1', 'Unknown', ''),
            '0009xx01': ('IS', '1', 'Unknown', ''),
            '0009xx02': ('UN', '1', 'Unknown', ''),
            '0009xx03': ('UN', '1', 'Unknown', ''),
            '0009xx04': ('UN', '1', 'Unknown', ''),
            '0009xx05': ('UN', '1', 'Unknown', ''),
            '0009xx06': ('UN', '1', 'Unknown', ''),
            '0009xx07': ('UN', '1', 'Unknown', ''),
            '0009xx08': ('LT', '1', 'Unknown', ''),
            '0009xx09': ('LT', '1', 'Unknown', ''),
            '0009xx0a': ('IS', '1', 'Unknown', ''),
            '0009xx0b': ('IS', '1', 'Unknown', ''),
            '0009xx0c': ('IS', '1', 'Unknown', ''),
            '0009xx0d': ('IS', '1', 'Unknown', ''),
            '0009xx0e': ('IS', '1', 'Unknown', ''),
            '0009xx0f': ('UN', '1', 'Unknown', ''),
            '0009xx10': ('IS', '1', 'Unknown', ''),
            '0009xx11': ('UN', '1', 'Unknown', ''),
            '0009xx12': ('IS', '1', 'Unknown', ''),
            '0009xx13': ('IS', '1', 'Unknown', ''),
            '0009xx14': ('LT', '1', 'Unknown', ''),
            '0009xx15': ('UN', '1', 'Unknown', '')},
 'ACUSON: 1.2.840.11386.1.0': {'7fdfxx00': ('IS',
                                            '1',
                                            'Lossy Compression Ratio',
                                            ''),
                               '7fdfxx01': ('US', '1', 'Image Format', ''),
                               '7fdfxx02': ('US',
                                            '1',
                                            'Acuson Region Type',
                                            ''),
                               '7fdfxx0b': ('UL',
                                            '1',
                                            'Acuson Image Apex X',
                                            ''),
                               '7fdfxx0c': ('UL',
                                            '1',
                                            'Acuson Image Apex Y',
                                            ''),
                               '7fdfxx0d': ('IS', '1', 'B-Color-On Flag', '')},
 'ACUSON:1.2.840.113680.1.0:0921': {'0009xx20': ('UN', '1', 'View Name', ''),
                                    '0009xx2a': ('UN', '1', 'View List', '')},
 'ACUSON:1.2.840.113680.1.0:7f10': {'7fdfxx00': ('UN',
                                                 '1',
                                                 'Lossy Compression Ratio',
                                                 ''),
                                    '7fdfxx01': ('UN',
                                                 '1',
                                                 'Image Format',
                                                 ''),
                                    '7fdfxx02': ('UN',
                                                 '1',
                                                 'Acuson Region Type',
                                                 ''),
                                    '7fdfxx0b': ('UN',
                                                 '1',
                                                 'Acuson Image Apex X',
                                                 ''),
                                    '7fdfxx0c': ('UN',
                                                 '1',
                                                 'Acuson Image Apex Y',
                                                 ''),
                                    '7fdfxx0d': ('UN',
                                                 '1',
                                                 'B-Color-On Flag',
                                                 ''),
                                    '7fdfxx0e': ('UN',
                                                 '1',
                                                 'Acuson Mechanical Apex X',
                                                 ''),
                                    '7fdfxx0f': ('UN',
                                                 '1',
                                                 'Acuson Mechanical Apex Y',
                                                 ''),
                                    '7fdfxx10': ('UN',
                                                 '1',
                                                 'Acquisition Type:',
                                                 ''),
                                    '7fdfxx18': ('UN',
                                                 '1',
                                                 'Transformation Matrix Sequence',
                                                 ''),
                                    '7fdfxx20': ('UN', '1', 'Left angle', ''),
                                    '7fdfxx22': ('UN',
                                                 '1',
                                                 'Right angle',
                                                 ''),
                                    '7fdfxx24': ('UN',
                                                 '1',
                                                 'Color Map Family',
                                                 ''),
                                    '7fdfxx25': ('UN',
                                                 '1',
                                                 'Full Colormap.',
                                                 ''),
                                    '7fdfxx26': ('UN',
                                                 '1',
                                                 'Color Invert',
                                                 ''),
                                    '7fdfxx27': ('UN',
                                                 '1',
                                                 'Color Baseline',
                                                 ''),
                                    '7fdfxx28': ('UN',
                                                 '1',
                                                 'CD Color Mix Points X1',
                                                 ''),
                                    '7fdfxx29': ('UN',
                                                 '1',
                                                 'CD Color Mix Points Y1',
                                                 ''),
                                    '7fdfxx2a': ('UN',
                                                 '1',
                                                 'CD Color Mix Points X2',
                                                 ''),
                                    '7fdfxx2b': ('UN',
                                                 '1',
                                                 'CD Color Mix Points Y2',
                                                 ''),
                                    '7fdfxx2c': ('UN',
                                                 '1',
                                                 'Color Accent',
                                                 ''),
                                    '7fdfxx30': ('UN',
                                                 '1',
                                                 'Persistence SQ',
                                                 ''),
                                    '7fdfxx31': ('UN',
                                                 '1',
                                                 'Persistence Mode',
                                                 ''),
                                    '7fdfxx32': ('UN',
                                                 '1',
                                                 'Persistence Coefficient Mode',
                                                 ''),
                                    '7fdfxx33': ('UN',
                                                 '1',
                                                 'Alpha coefficient',
                                                 ''),
                                    '7fdfxx34': ('UN',
                                                 '1',
                                                 'Gamma coefficient',
                                                 ''),
                                    '7fdfxx35': ('UN',
                                                 '1',
                                                 'Persistence Time Flag',
                                                 ''),
                                    '7fdfxx36': ('UN',
                                                 '1',
                                                 'Persistence adaptive flag',
                                                 ''),
                                    '7fdfxx37': ('UN',
                                                 '1',
                                                 'Persistence Frame Rate',
                                                 ''),
                                    '7fdfxx38': ('UN',
                                                 '1',
                                                 'Persistence ID',
                                                 ''),
                                    '7fdfxx40': ('UN',
                                                 '1',
                                                 'Observation Date Time SQ',
                                                 ''),
                                    '7fdfxx50': ('UN',
                                                 '1',
                                                 'Capture Type Name',
                                                 ''),
                                    '7fdfxx52': ('UN',
                                                 '1',
                                                 'Capture Type Number',
                                                 ''),
                                    '7fdfxx54': ('UN',
                                                 '1',
                                                 'Number of Capture Types',
                                                 ''),
                                    '7fdfxx60': ('UN',
                                                 '1',
                                                 'CD Steering Angle',
                                                 ''),
                                    '7fdfxx61': ('UN', '1', 'CD PRI', ''),
                                    '7fdfxx62': ('UN',
                                                 '1',
                                                 'CD Dynamic Range',
                                                 ''),
                                    '7fdfxx63': ('UN',
                                                 '1',
                                                 'CD Velocity Scale Min',
                                                 ''),
                                    '7fdfxx64': ('UN',
                                                 '1',
                                                 'CD Velocity Scale Max',
                                                 ''),
                                    '7fdfxx65': ('UN',
                                                 '1',
                                                 'CD Color Mode',
                                                 ''),
                                    '7fdfxx66': ('UN',
                                                 '1',
                                                 'CD Frequency',
                                                 ''),
                                    '7fdfxx67': ('UN', '1', 'CD Balance', ''),
                                    '7fdfxx68': ('UN', '1', 'CD Delta', ''),
                                    '7fdfxx69': ('UN',
                                                 '1',
                                                 'CD Pan Box Min X0',
                                                 ''),
                                    '7fdfxx6a': ('UN',
                                                 '1',
                                                 'CD Pan Box Min Y0',
                                                 ''),
                                    '7fdfxx6b': ('UN',
                                                 '1',
                                                 'CD Pan Box Min X1',
                                                 ''),
                                    '7fdfxx6c': ('UN',
                                                 '1',
                                                 'CD Pan Box Min Y1',
                                                 ''),
                                    '7fdfxx6d': ('UN',
                                                 '1',
                                                 'CPS Map Type',
                                                 ''),
                                    '7fdfxx6e': ('UN',
                                                 '1',
                                                 'CPS Map Data',
                                                 ''),
                                    '7fdfxx6f': ('UN',
                                                 '1',
                                                 'CPS Balance Setting',
                                                 ''),
                                    '7fdfxx70': ('UN',
                                                 '1',
                                                 '3DCard Step Angle',
                                                 ''),
                                    '7fdfxx71': ('UN',
                                                 '1',
                                                 '3DCard Xdcr Angle',
                                                 ''),
                                    '7fdfxx72': ('UN',
                                                 '1',
                                                 'B-mode Frequency',
                                                 ''),
                                    '7fdfxx73': ('UN',
                                                 '1',
                                                 'B-mode Dynamic Range',
                                                 ''),
                                    '7fdfxx74': ('UN',
                                                 '1',
                                                 'B-mode Frame Rate',
                                                 ''),
                                    '7fdfxx75': ('UN',
                                                 '1',
                                                 'B-mode Space Time',
                                                 ''),
                                    '7fdfxx76': ('UN',
                                                 '1',
                                                 'B-mode Persistence',
                                                 ''),
                                    '7fdfxx77': ('UN',
                                                 '1',
                                                 'B-mode Display Depth Start',
                                                 ''),
                                    '7fdfxx78': ('UN',
                                                 '1',
                                                 'B-mode Display Depth End',
                                                 ''),
                                    '7fdfxx79': ('UN',
                                                 '1',
                                                 'B-mode Res Mode',
                                                 ''),
                                    '7fdfxx7a': ('UN',
                                                 '1',
                                                 'B-mode Preset Application',
                                                 ''),
                                    '7fdfxx7b': ('UN',
                                                 '1',
                                                 'Image Spec Name',
                                                 ''),
                                    '7fdfxx7c': ('UN',
                                                 '1',
                                                 'B Preset Image Look',
                                                 ''),
                                    '7fdfxx7d': ('UN',
                                                 '1',
                                                 'B-mode Post Processing',
                                                 ''),
                                    '7fdfxx7e': ('UN', '1', 'B Edge', ''),
                                    '7fdfxx7f': ('UN', '1', 'B Delta', ''),
                                    '7fdfxx80': ('UN',
                                                 '1',
                                                 'B-mode 1D Post Processing Curve',
                                                 ''),
                                    '7fdfxx81': ('UN',
                                                 '1',
                                                 'B-mode Delta (ECRI) Map Diagonal',
                                                 ''),
                                    '7fdfxx82': ('UN',
                                                 '1',
                                                 'Bytes Per Timestamp',
                                                 ''),
                                    '7fdfxx83': ('UN',
                                                 '1',
                                                 'Microseconds in unit timestamp',
                                                 ''),
                                    '7fdfxx84': ('UN',
                                                 '1',
                                                 'Start Stopwatch Timestamp',
                                                 ''),
                                    '7fdfxx85': ('UN',
                                                 '1',
                                                 'Acoustic Frame Timestamp',
                                                 ''),
                                    '7fdfxx86': ('UN',
                                                 '1',
                                                 'R-Wave Timestamp',
                                                 ''),
                                    '7fdfxx87': ('UN',
                                                 '1',
                                                 'Last Destruction Timestamp',
                                                 ''),
                                    '7fdfxx88': ('UN',
                                                 '1',
                                                 'Pixels Per Second',
                                                 ''),
                                    '7fdfxx89': ('UN',
                                                 '1',
                                                 'ECG Reference Timestamp',
                                                 ''),
                                    '7fdfxx8a': ('UN',
                                                 '1',
                                                 'ECG Sampling Interval (milliseconds)',
                                                 ''),
                                    '7fdfxx8b': ('UN',
                                                 '1',
                                                 'ECG Sample Count',
                                                 ''),
                                    '7fdfxx8c': ('UN',
                                                 '1',
                                                 'ECG Sample Size',
                                                 ''),
                                    '7fdfxx8d': ('UN',
                                                 '1',
                                                 'ECG Data Value',
                                                 ''),
                                    '7fdfxx8e': ('UN',
                                                 '1',
                                                 'Contrast/Active Image Indicator',
                                                 ''),
                                    '7fdfxx8f': ('UN',
                                                 '1',
                                                 'Live Dual Mode Indicator',
                                                 ''),
                                    '7fdfxx90': ('UN',
                                                 '1',
                                                 '3DCard Clipset ID',
                                                 ''),
                                    '7fdfxx91': ('UN',
                                                 '1',
                                                 '3DCard HRWave Min',
                                                 ''),
                                    '7fdfxx92': ('UN',
                                                 '1',
                                                 '3DCard HRWave Max',
                                                 ''),
                                    '7fdfxx93': ('UN',
                                                 '1',
                                                 'Perspective Capture Type',
                                                 ''),
                                    '7fdfxxf1': ('UN',
                                                 '1',
                                                 'Trigger Mask.',
                                                 ''),
                                    '7fdfxxf2': ('UN',
                                                 '1',
                                                 'Study Directory',
                                                 ''),
                                    '7fdfxxf3': ('UN',
                                                 '1',
                                                 'Last Modify Date',
                                                 ''),
                                    '7fdfxxf4': ('UN',
                                                 '1',
                                                 'Last Modify Time',
                                                 ''),
                                    '7fdfxxf5': ('UN',
                                                 '1',
                                                 'Teaching Study',
                                                 ''),
                                    '7fdfxxf6': ('UN',
                                                 '1',
                                                 'Series Base UID',
                                                 '')},
 'ACUSON:1.2.840.113680.1.0:7ffe': {'7fdfxx00': ('UN',
                                                 '1',
                                                 'Data Padding',
                                                 '')},
 'ADAC_IMG': {'0019xx02': ('IS', '1', 'Ver200 ADAC Pegasys File Size', ''),
              '0019xx10': ('LO', '2', 'ADAC Header Signature', ''),
              '0019xx11': ('US', '1', 'Number of ADAC Headers', ''),
              '0019xx12': ('IS', '1-n', 'ADAC Header/Image Sizes', ''),
              '0019xx20': ('OB', '1', 'ADAC Pegasys Headers', ''),
              '0019xx21': ('US', '1', 'Ver200 Number of ADAC Headers', ''),
              '0019xx41': ('IS', '1-n', 'Ver200 ADAC Header/Image Size', ''),
              '0019xx61': ('OB', '1', 'Ver200 ADAC Pegasys Headers', ''),
              '7043xx00': ('SH', '1', 'Cardiac Stress State', ''),
              '7043xx10': ('LO', '1', 'Philips NM Private Group', '')},
 'AEGIS_DICOM_2.00': {'0003xx00': ('US', '1-n', 'Unknown', ''),
                      '0005xx00': ('US', '1-n', 'Unknown', ''),
                      '0009xx00': ('US', '1-n', 'Unknown', ''),
                      '0019xx00': ('US', '1-n', 'Unknown', ''),
                      '0029xx00': ('US', '1-n', 'Unknown', ''),
                      '1369xx00': ('US', '1-n', 'Unknown', '')},
 'AGFA': {'0009xx10': ('LO', '1', 'Unknown', ''),
          '0009xx11': ('LO', '1', 'Unknown', ''),
          '0009xx13': ('LO', '1', 'Unknown', ''),
          '0009xx14': ('LO', '1', 'Unknown', ''),
          '0009xx15': ('LO', '1', 'Unknown', ''),
          '0019xx10': ('SH', '1', 'Private Identification Code', ''),
          '0019xx11': ('LO', '3', 'Identification Data (Note 2)', ''),
          '0019xx13': ('LO', '1', 'Sensitometry Name', ''),
          '0019xx14': ('ST', '3', 'Window/Level List (Note 3)', ''),
          '0019xx15': ('LO', '1', 'Dose Monitoring List', ''),
          '0019xx16': ('LO', '3', 'Other Info (Note 5)', ''),
          '0019xx1a': ('LO', '1', 'Clipped Exposure Deviation', ''),
          '0019xx1b': ('LO', '1', 'Logarithmic PLT Full Scale', ''),
          '0019xx60': ('US', '1', 'Total number of series', ''),
          '0019xx61': ('SH', '1', 'Session Number', ''),
          '0019xx62': ('SH', '1', 'ID Station name', ''),
          '0019xx65': ('US',
                       '1',
                       'Number of images in study to be transmitted (only sent with autoverify: on)',
                       ''),
          '0019xx70': ('US', '1', 'Total number of images', ''),
          '0019xx80': ('ST', '1', 'Geometrical Transformations', ''),
          '0019xx81': ('ST', '1', 'Roam Origin', ''),
          '0019xx82': ('US', '1', 'Zoom factor', ''),
          '0019xx93': ('CS', '1', 'Status', '')},
 'AGFA PACS Archive Mirroring 1.0': {'0031xx00': ('CS', '1', 'Unknown', ''),
                                     '0031xx01': ('UL', '1', 'Unknown', '')},
 'AGFA-AG_HPState': {'0071xx18': ('SQ', '1', 'Unknown', ''),
                     '0071xx19': ('SQ', '1', 'Unknown', ''),
                     '0071xx1a': ('SQ', '1', 'Unknown', ''),
                     '0071xx1c': ('SQ', '1', 'Unknown', ''),
                     '0071xx1e': ('SQ', '1', 'Unknown', ''),
                     '0071xx20': ('FL', '1-n', 'Unknown', ''),
                     '0071xx21': ('FD', '1-n', 'Unknown', ''),
                     '0071xx22': ('FD', '1-n', 'Unknown', ''),
                     '0071xx23': ('FD', '1-n', 'Unknown', ''),
                     '0071xx24': ('FD', '1', 'Unknown', ''),
                     '0073xx23': ('SH', '1', 'Unknown', ''),
                     '0073xx24': ('SQ', '1', 'Unknown', ''),
                     '0073xx28': ('SQ', '1', 'Unknown', ''),
                     '0073xx80': ('FL', '1', 'Unknown', ''),
                     '0075xx10': ('LO', '1', 'Unknown', ''),
                     '0087xx01': ('LO', '1', 'Unknown', ''),
                     '0087xx02': ('LO', '1', 'Unknown', '')},
 'AGFA_ADC_Compact': {'0019xx05': ('ST',
                                   '1',
                                   'Data stream from cassette',
                                   ''),
                      '0019xx10': ('LO',
                                   '1',
                                   'Private Identification Code',
                                   ''),
                      '0019xx30': ('ST', '1', 'Set of destination types', ''),
                      '0019xx40': ('ST', '1', 'Set of destination Ids', ''),
                      '0019xx50': ('ST', '1', 'Set of processing codes', ''),
                      '0019xx60': ('US',
                                   '1',
                                   'Number of series in study',
                                   ''),
                      '0019xx61': ('US', '1', 'Session Number', ''),
                      '0019xx62': ('SH', '1', 'ID station name', ''),
                      '0019xx70': ('US',
                                   '1',
                                   'Number of images in series',
                                   ''),
                      '0019xx71': ('US', '1', 'Break condition', ''),
                      '0019xx72': ('US', '1', 'Wait (or Hold) flag', ''),
                      '0019xx73': ('US', '1', 'ScanRes flag', ''),
                      '0019xx74': ('SH', '1', 'Operation code', ''),
                      '0019xx95': ('CS', '1', 'Image quality', '')},
 'ALOKA:1.2.392.200039.103.2': {'0009xx00': ('SH', '1', 'Unknown', ''),
                                '0009xx04': ('US', '1-n', 'Unknown', ''),
                                '0009xx06': ('US', '1-n', 'Unknown', ''),
                                '0009xx0a': ('SH', '1', 'Unknown', ''),
                                '0009xx20': ('CS', '1', 'Unknown', ''),
                                '0009xx22': ('CS', '1', 'Unknown', ''),
                                '0009xx24': ('CS', '1', 'Unknown', ''),
                                '0009xx26': ('IS', '1', 'Unknown', ''),
                                '0009xx28': ('IS', '1', 'Unknown', ''),
                                '0009xx2a': ('DS', '1', 'Unknown', ''),
                                '0009xx30': ('FD', '1', 'Unknown', ''),
                                '0009xx32': ('DS', '1', 'Unknown', ''),
                                '0009xx34': ('CS', '1', 'Unknown', ''),
                                '0019xx08': ('FD', '1', 'Unknown', ''),
                                '0019xx0c': ('CS', '1', 'Unknown', ''),
                                '0019xx0e': ('DS', '1', 'Unknown', ''),
                                '0019xx18': ('SL', '1', 'Unknown', ''),
                                '0019xx1a': ('SL', '1', 'Unknown', ''),
                                '0019xx40': ('SS', '1', 'Unknown', ''),
                                '0019xx46': ('US', '1', 'Unknown', ''),
                                '0019xx50': ('SL', '1', 'Unknown', ''),
                                '0019xx52': ('DS', '1', 'Unknown', ''),
                                '0019xx54': ('DS', '1', 'Unknown', ''),
                                '0019xx56': ('FD', '1', 'Unknown', '')},
 'AMI Annotations_01': {'3101xx10': ('SQ',
                                     '1',
                                     'AMI Annotation Sequence (RET)',
                                     '')},
 'AMI Annotations_02': {'3101xx20': ('SQ',
                                     '1',
                                     'AMI Annotation Sequence (RET)',
                                     '')},
 'AMI ImageContextExt_01': {'3107xxa0': ('CS',
                                         '1',
                                         'AMI Window Function (RET)',
                                         ''),
                            '3107xxb0': ('DS',
                                         '1',
                                         'AMI Window Slope (RET)',
                                         '')},
 'AMI ImageContext_01': {'3109xx10': ('CS',
                                      '1',
                                      'AMI Window Invert (RET)',
                                      ''),
                         '3109xx20': ('IS',
                                      '1',
                                      'AMI Window Center (RET)',
                                      ''),
                         '3109xx30': ('IS',
                                      '1',
                                      'AMI Window Widith (RET)',
                                      ''),
                         '3109xx40': ('CS',
                                      '1',
                                      'AMI Pixel Aspect Ratio Swap (RET)',
                                      ''),
                         '3109xx50': ('CS',
                                      '1',
                                      'AMI Enable Averaging (RET)',
                                      ''),
                         '3109xx60': ('CS', '1', 'AMI Quality (RET)', ''),
                         '3109xx70': ('CS',
                                      '1',
                                      'AMI Viewport Annotation Level (RET)',
                                      ''),
                         '3109xx80': ('CS',
                                      '1',
                                      'AMI Show Image Annotation (RET)',
                                      ''),
                         '3109xx90': ('CS',
                                      '1',
                                      'AMI Show Image Overlay (RET)',
                                      '')},
 'AMI ImageTransform_01': {'3107xx10': ('DS',
                                        '1',
                                        'AMI Transformation Matrix (RET)',
                                        ''),
                           '3107xx20': ('DS',
                                        '1',
                                        'AMI Center Offset (RET)',
                                        ''),
                           '3107xx30': ('DS',
                                        '1',
                                        'AMI Magnification (RET)',
                                        ''),
                           '3107xx40': ('CS',
                                        '1',
                                        'AMI Magnification Type (RET)',
                                        ''),
                           '3107xx50': ('DS',
                                        '1',
                                        'AMI Displayed Area (RET)',
                                        ''),
                           '3107xx60': ('DS',
                                        '1',
                                        'AMI Calibration Factor (RET)',
                                        '')},
 'AMI Sequence AnnotElements_01': {'3105xx10': ('DS',
                                                '1',
                                                'AMI Annotation Element Position',
                                                ''),
                                   '3105xx20': ('LT',
                                                '1',
                                                'AMI Annotation Element Text',
                                                '')},
 'AMI Sequence Annotations_01': {'3103xx10': ('CS',
                                              '1',
                                              'AMI Annotation Sequence (RET)',
                                              ''),
                                 '3103xx20': ('UI',
                                              '1',
                                              'AMI Annotation UID (RET)',
                                              ''),
                                 '3103xx30': ('US',
                                              '1',
                                              'AMI Annotation Color (RET)',
                                              ''),
                                 '3103xx40': ('FD', '1', 'FontSize', ''),
                                 '3103xx50': ('CS',
                                              '1',
                                              'AMI Annotation Line Style (RET)',
                                              ''),
                                 '3103xx60': ('SQ',
                                              '1',
                                              'AMI Annotation Elements (RET)',
                                              ''),
                                 '3103xx70': ('SH',
                                              '1',
                                              'AMI Annotation Label (RET)',
                                              ''),
                                 '3103xx80': ('PN',
                                              '1',
                                              'AMI Annotation Creator (RET)',
                                              ''),
                                 '3103xx90': ('PN',
                                              '1',
                                              'AMI Annotation Modifiers (RET)',
                                              ''),
                                 '3103xxa0': ('DA',
                                              '1',
                                              'AMI Annotation Creation Date (RET)',
                                              ''),
                                 '3103xxb0': ('TM',
                                              '1',
                                              'AMI Annotation Creation Time (RET)',
                                              ''),
                                 '3103xxc0': ('DA',
                                              '1',
                                              'AMI Annotation Modification Dates (RET)',
                                              ''),
                                 '3103xxd0': ('TM',
                                              '1',
                                              'AMI Annotation Mofification Times (RET)',
                                              ''),
                                 '3103xxe0': ('US',
                                              '1',
                                              'AMI Annotation Frame Number (RET)',
                                              '')},
 'AMI Sequence Annotations_02': {'3103xx10': ('CS',
                                              '1',
                                              'AMI Annotation Sequence (RET)',
                                              ''),
                                 '3103xx20': ('UI',
                                              '1',
                                              'AMI Annotation UID (RET)',
                                              ''),
                                 '3103xx30': ('US',
                                              '1',
                                              'AMI Annotation Color (RET)',
                                              ''),
                                 '3103xx50': ('CS',
                                              '1',
                                              'AMI Annotation Line Style (RET)',
                                              ''),
                                 '3103xx60': ('SQ',
                                              '1',
                                              'AMI Annotation Elements (RET)',
                                              ''),
                                 '3103xx70': ('SH',
                                              '1',
                                              'AMI Annotation Label (RET)',
                                              ''),
                                 '3103xx80': ('PN',
                                              '1',
                                              'AMI Annotation Creator (RET)',
                                              ''),
                                 '3103xx90': ('PN',
                                              '1',
                                              'AMI Annotation Modifiers (RET)',
                                              ''),
                                 '3103xxa0': ('DA',
                                              '1',
                                              'AMI Annotation Creation Date (RET)',
                                              ''),
                                 '3103xxb0': ('TM',
                                              '1',
                                              'AMI Annotation Creation Time (RET)',
                                              ''),
                                 '3103xxc0': ('DA',
                                              '1',
                                              'AMI Annotation Modification Dates (RET)',
                                              ''),
                                 '3103xxd0': ('TM',
                                              '1',
                                              'AMI Annotation Modification Times (RET)',
                                              ''),
                                 '3103xxe0': ('US',
                                              '1',
                                              'AMI Annotation Frame Number (RET)',
                                              '')},
 'AMI StudyExtensions_01': {'3111xx01': ('UL',
                                         '1',
                                         'AMI Last Released Annot Label (RET)',
                                         '')},
 'AMICAS0': {'0023xx01': ('UI', '1', '', ''),
             '0023xx08': ('US', '1', '', ''),
             '0023xx10': ('US', '1', '', ''),
             '0023xx16': ('SL', '1', '', '')},
 'APEX_PRIVATE': {'0027xx10': ('LO', '1', 'Private Creator', ''),
                  '0027xx11': ('DS', '1', 'Bed Position', '')},
 'ATL HDI V1.0': {'0009xx00': ('UN', '1', 'Private', ''),
                  '0009xx10': ('UN', '1', 'Private', ''),
                  '0009xx20': ('UN', '1', 'Private', ''),
                  '0009xx30': ('UN', '1', 'Private', ''),
                  '0009xx40': ('UN', '1', 'Private', ''),
                  '0009xx50': ('UN', '1', 'Private', ''),
                  '0009xx60': ('UN', '1', 'Private', ''),
                  '0009xx70': ('UN', '1', 'Private', ''),
                  '0009xx80': ('UN', '1', 'Private', ''),
                  '0009xx90': ('UN', '1', 'Private', ''),
                  '0009xx91': ('UN', '1', 'Private', ''),
                  '0029xx30': ('UN', '1', 'Loop Mode', ''),
                  '0029xx31': ('UN', '1', 'Trigger mode', ''),
                  '0029xx32': ('UN', '1', 'Number of Loops', ''),
                  '0029xx33': ('UN', '1', 'Loop Indexes', ''),
                  '0029xx34': ('UN', '1', 'Loop Heart Rates', ''),
                  '0029xx35': ('UN', '1', 'Medications', '')},
 'ATL PRIVATE TAGS': {'0029xx30': ('UL', '1', 'Loop Mode', ''),
                      '0029xx31': ('UL', '1', 'Trigger mode', ''),
                      '0029xx32': ('UL', '1', 'Number of Loops', ''),
                      '0029xx33': ('DS', '1-n', 'Loop Indexes', ''),
                      '0029xx34': ('DS', '1-n', 'Loop Heart Rates', ''),
                      '0029xx35': ('LO', '1', 'Medications', '')},
 'Acuson X500': {'0009xx20': ('UN', '1', '(a)View Name', ''),
                 '0009xx2a': ('UN', '1', 'View List', ''),
                 '0011xx10': ('UN', '1', 'Siemens Medical', ''),
                 '0011xx11': ('UN', '1', 'DIMAQ Software', ''),
                 '0011xx20': ('UN', '1', 'Private Data', ''),
                 '0011xx21': ('UN', '1', 'Private Data', ''),
                 '0013xx10': ('UN', '1', 'Siemens Medical', ''),
                 '0013xx11': ('UN', '1', 'DIMAQ Software', ''),
                 '0013xx20': ('UN', '1', 'Private Data', ''),
                 '0015xx10': ('UN', '1', 'Siemens Medical', ''),
                 '0015xx11': ('UN', '1', 'DIMAQ Software', ''),
                 '0015xx20': ('UN', '1', 'Private Data', ''),
                 '0017xx10': ('UN', '1', 'Siemens Medical', ''),
                 '0017xx11': ('UN', '1', 'DIMAQ Software', ''),
                 '0017xx20': ('UN', '1', 'Private Data', ''),
                 '0019xx20': ('UN', '1', 'Import Structured', '')},
 'Agfa ADC NX': {'0019xx09': ('SQ', '1', 'Unknown', ''),
                 '0019xxf5': ('CS', '1', 'Cassette Orientation', ''),
                 '0019xxf6': ('DS', '1', 'Plate Sensitivity', ''),
                 '0019xxf7': ('DS', '1', 'Plate Erasability', ''),
                 '0019xxf8': ('IS', '1', 'Unknown', ''),
                 '0019xxfe': ('CS', '1', 'Unknown', '')},
 'AgilityRuntime': {'0029xx11': ('CS', '1', 'Unknown', ''),
                    '0029xx12': ('US', '1', 'Unknown', ''),
                    '0029xx13': ('US', '1', 'Unknown', ''),
                    '0029xx14': ('US', '1', 'Unknown', ''),
                    '0029xx1f': ('US', '1', 'Unknown', '')},
 'Applicare/Centricity Radiology Web/Version 1.0': {'4109xx01': ('SH',
                                                                 '1',
                                                                 'Mammography Laterality',
                                                                 ''),
                                                    '4109xx02': ('SH',
                                                                 '1',
                                                                 'Mammography View Name',
                                                                 ''),
                                                    '4109xx03': ('SH',
                                                                 '1',
                                                                 'Mammography View Modifier',
                                                                 '')},
 'Applicare/Centricity Radiology Web/Version 2.0': {'4111xx01': ('CS',
                                                                 '1',
                                                                 'Secondary Spine Label',
                                                                 ''),
                                                    '4111xx02': ('IS',
                                                                 '1',
                                                                 'Additional tags for Presentation State',
                                                                 '')},
 'Applicare/Print/Version 5.1': {'4101xx01': ('UL', '1', '<internal', ''),
                                 '4101xx02': ('SQ', '1', '<internal', ''),
                                 '4101xx03': ('LO', '1', '<internal', ''),
                                 '4101xx04': ('UL', '1', '<internal', ''),
                                 '4101xx05': ('FD', '1', '<internal', ''),
                                 '4101xx06': ('US', '1', '<internal', ''),
                                 '4101xx07': ('US', '1', '<internal', ''),
                                 '4101xx08': ('US', '1', '<internal', ''),
                                 '4101xx09': ('US', '1', '<internal', '')},
 'Applicare/RadStore/Version 1.0': {'3113xx01': ('SL', '1', 'OBSOLETE', ''),
                                    '3113xx02': ('SL', '1', 'Id1', ''),
                                    '3113xx03': ('SL', '1', 'Id2', ''),
                                    '3113xx04': ('SL', '1', 'Id3', ''),
                                    '3113xx11': ('LO', '1', 'OBSOLETE', ''),
                                    '3113xx12': ('CS', '1', 'State', ''),
                                    '3113xx13': ('DT',
                                                 '1',
                                                 'DateLastModified',
                                                 ''),
                                    '3113xx14': ('DT',
                                                 '1',
                                                 'DateLastAccessed',
                                                 ''),
                                    '3113xx15': ('CS', '1', 'OBSOLETE', ''),
                                    '3113xx16': ('FD', '1', 'ByteSize', ''),
                                    '3113xx17': ('LO', '1', 'LibraryId', ''),
                                    '3113xx18': ('LO', '1', 'Pathnames', ''),
                                    '3113xx19': ('LO', '1', 'DriverPath', ''),
                                    '3113xx1a': ('LO', '1', 'Source', ''),
                                    '3113xx1b': ('LO',
                                                 '1',
                                                 'Destination',
                                                 ''),
                                    '3113xx1c': ('SL', '1', 'MediumId', ''),
                                    '3113xx1d': ('LO', '1', 'ArchiveId', ''),
                                    '3113xx1e': ('LO', '1', 'Origin', ''),
                                    '3113xx21': ('SL', '1', 'Version', ''),
                                    '3113xx22': ('SL', '1', 'OBSOLETE', ''),
                                    '3113xx23': ('ST',
                                                 '1',
                                                 'InstanceFileLocation',
                                                 ''),
                                    '3113xx31': ('IS', '1', 'OBSOLETE', ''),
                                    '3113xx32': ('IS', '1', 'OBSOLETE', ''),
                                    '3113xx33': ('IS', '1', 'OBSOLETE', ''),
                                    '3113xx35': ('LO',
                                                 '1',
                                                 'ImageMediumLocation',
                                                 ''),
                                    '3113xx36': ('LO',
                                                 '1',
                                                 'ImageMediumLabel',
                                                 ''),
                                    '3113xx37': ('CS',
                                                 '1',
                                                 'ImageMediumState',
                                                 ''),
                                    '3113xx38': ('LO',
                                                 '1',
                                                 'SeriesMediumLocation',
                                                 ''),
                                    '3113xx39': ('LO',
                                                 '1',
                                                 'SeriesMediumLabel',
                                                 ''),
                                    '3113xx3a': ('CS',
                                                 '1',
                                                 'SeriesMediumState',
                                                 ''),
                                    '3113xx3b': ('LO',
                                                 '1',
                                                 'StudyMediumLocation',
                                                 ''),
                                    '3113xx3c': ('LO',
                                                 '1',
                                                 'StudyMediumLabel',
                                                 ''),
                                    '3113xx3d': ('CS',
                                                 '1',
                                                 'StudyMediumState',
                                                 ''),
                                    '3113xx52': ('CS', '1', 'StudyState', ''),
                                    '3113xx53': ('CS',
                                                 '1',
                                                 'SeriesState',
                                                 ''),
                                    '3113xx55': ('CS',
                                                 '1',
                                                 'ImageStateText',
                                                 ''),
                                    '3113xx56': ('CS',
                                                 '1',
                                                 'SeriesStateText',
                                                 ''),
                                    '3113xx57': ('CS',
                                                 '1',
                                                 'StudyStateText',
                                                 ''),
                                    '3113xx60': ('DT', '1', 'Expiration', ''),
                                    '3113xx69': ('AT',
                                                 '1',
                                                 'DeletedTags',
                                                 '')},
 'Applicare/RadWorks/Version 5.0': {'3109xx01': ('ST', '1', '<internal', ''),
                                    '3109xx02': ('SH',
                                                 '1',
                                                 'NEW/SEEN Status',
                                                 ''),
                                    '3109xx03': ('CS',
                                                 '1',
                                                 'Delete Lock',
                                                 ''),
                                    '3109xx04': ('CS', '1', '<internal', ''),
                                    '3109xx05': ('CS', '1', '<internal', ''),
                                    '3109xx06': ('CS', '1', '<internal', ''),
                                    '3109xx07': ('UL', '1', '<internal', ''),
                                    '3109xx08': ('LO',
                                                 '1',
                                                 'Receive Origin',
                                                 ''),
                                    '3109xx09': ('LO', '1', 'Folder', ''),
                                    '3109xx0a': ('DA',
                                                 '1',
                                                 'Receive Date',
                                                 ''),
                                    '3109xx0b': ('TM',
                                                 '1',
                                                 'Receive Time',
                                                 ''),
                                    '3109xx0c': ('CS', '1', 'Prior', ''),
                                    '3109xx0d': ('CS', '1', 'STAT Study', ''),
                                    '3109xx0e': ('CS', '1', '<internal', ''),
                                    '3109xx10': ('CS', '1', '<internal', ''),
                                    '3109xx11': ('LO', '1', '<internal', ''),
                                    '3109xx12': ('LO', '1', '<internal', ''),
                                    '3109xx13': ('DA', '1', '<internal', ''),
                                    '3109xx14': ('TM', '1', '<internal', ''),
                                    '3109xx19': ('LO', '1', '<internal', ''),
                                    '3109xx20': ('UI', '1', '<internal', ''),
                                    '3109xx21': ('CS', '1', '<internal', ''),
                                    '3109xx22': ('AE', '1', '<internal', ''),
                                    '3109xx23': ('US', '1', '<internal', ''),
                                    '3109xx24': ('LO', '1', '<internal', ''),
                                    '3109xx25': ('LO', '1', '<internal', ''),
                                    '3109xx26': ('UI', '1', '<internal', ''),
                                    '3109xx27': ('SQ', '1', '<internal', ''),
                                    '3109xx28': ('LO', '1', '<internal', ''),
                                    '3109xx29': ('LO', '1', '<internal', ''),
                                    '3109xx2a': ('LO', '1', 'Send Flag', ''),
                                    '3109xx2b': ('LO', '1', 'Print Flag', ''),
                                    '3109xx2c': ('LO',
                                                 '1',
                                                 'Archive Flag',
                                                 ''),
                                    '3109xx30': ('LO', '1', '<internal', ''),
                                    '3109xx31': ('CS', '1', '<internal', ''),
                                    '3109xx32': ('CS', '1', '<internal', ''),
                                    '3109xx33': ('CS',
                                                 '1',
                                                 'Request Storage Commitment',
                                                 ''),
                                    '3109xx34': ('CS',
                                                 '1',
                                                 'Requested Compression',
                                                 ''),
                                    '3109xx35': ('SQ', '1', '<internal', ''),
                                    '3109xx36': ('LO', '1', '<internal', ''),
                                    '3109xx37': ('UI', '1', '<internal', ''),
                                    '3109xx38': ('SH', '1', '<internal', ''),
                                    '3109xx39': ('SH', '1', '<internal', ''),
                                    '3109xx40': ('IS', '1', '<internal', ''),
                                    '3109xx41': ('CS', '1', '<internal', ''),
                                    '3109xx42': ('CS', '1', '<internal', ''),
                                    '3109xx43': ('CS',
                                                 '1',
                                                 'Archive Status',
                                                 ''),
                                    '3109xxee': ('UI', '1', '<internal', ''),
                                    '3109xxef': ('CS', '1', '<internal', '')},
 'Applicare/RadWorks/Version 6.0': {'4103xx01': ('AT',
                                                 '1',
                                                 'Internal: non-existent tags',
                                                 ''),
                                    '4103xx02': ('UI',
                                                 '1',
                                                 'Internal: non-existent objects',
                                                 ''),
                                    '4105xx01': ('CS',
                                                 '1',
                                                 'Annotation Type',
                                                 ''),
                                    '4105xx02': ('DS',
                                                 '1',
                                                 'Annotation Value',
                                                 ''),
                                    '4105xx03': ('UI',
                                                 '1',
                                                 'Cutline Image UID',
                                                 ''),
                                    '4105xx04': ('UI',
                                                 '1',
                                                 'Cutline Set UID',
                                                 ''),
                                    '4105xx05': ('US',
                                                 '1',
                                                 'Annotation Color',
                                                 ''),
                                    '4105xx06': ('CS',
                                                 '1',
                                                 'Annotation Line Style',
                                                 ''),
                                    '4105xx07': ('SH',
                                                 '1',
                                                 'Annotation Label',
                                                 ''),
                                    '4105xx08': ('PN',
                                                 '1',
                                                 'Annotation Creator',
                                                 ''),
                                    '4105xx09': ('DA',
                                                 '1',
                                                 'Annotation Creation Date',
                                                 ''),
                                    '4105xx0a': ('TM',
                                                 '1',
                                                 'Annotation Creation Time',
                                                 ''),
                                    '4105xx0b': ('SQ',
                                                 '1',
                                                 'Annotation Modification Sequence',
                                                 ''),
                                    '4105xx0c': ('PN',
                                                 '1',
                                                 'Annotation Modifier',
                                                 ''),
                                    '4105xx0d': ('DA',
                                                 '1',
                                                 'Annotation Modification Date',
                                                 ''),
                                    '4105xx0e': ('TM',
                                                 '1',
                                                 'Annotation Modification Time',
                                                 ''),
                                    '4105xx0f': ('LO',
                                                 '1',
                                                 'Palette Color LUT Name',
                                                 ''),
                                    '4105xx10': ('US',
                                                 '1',
                                                 'Annotation Number',
                                                 ''),
                                    '4107xx01': ('SQ',
                                                 '1',
                                                 'Requested Palette Color LUT',
                                                 '')},
 'Applicare/RadWorks/Version 6.0/Summary': {'3109xx11': ('ST',
                                                         '1',
                                                         'Receive Origin Description',
                                                         ''),
                                            '3109xx12': ('ST',
                                                         '1',
                                                         'Receive Origin Description',
                                                         '')},
 'Applicare/Workflow/Version 1.0': {'3113xx01': ('CS', '1', '<internal', ''),
                                    '3113xx10': ('SH', '1', '<internal', ''),
                                    '3113xx11': ('SH', '1', '<internal', ''),
                                    '3113xx12': ('LO', '1', '<internal', ''),
                                    '3113xx15': ('SH', '1', '<internal', ''),
                                    '3113xx16': ('SH', '1', '<internal', ''),
                                    '3113xx17': ('LO', '1', '<internal', ''),
                                    '3113xx20': ('SH', '1', '<internal', ''),
                                    '3113xx21': ('SH', '1', '<internal', ''),
                                    '3113xx22': ('LO', '1', '<internal', ''),
                                    '3113xx25': ('SH', '1', '<internal', ''),
                                    '3113xx26': ('SH', '1', '<internal', ''),
                                    '3113xx27': ('LO', '1', '<internal', ''),
                                    '3113xx30': ('UI', '1', '<internal', ''),
                                    '3113xx31': ('UI', '1', '<internal', ''),
                                    '3113xxe0': ('CS', '1', '<internal', ''),
                                    '3113xxe1': ('CS', '1', '<internal', ''),
                                    '3113xxe2': ('CS', '1', '<internal', '')},
 'BRIT Systems, Inc.': {'0021xx00': ('SQ',
                                     '1',
                                     'Person Information Sequence',
                                     ''),
                        '0021xx01': ('LO', '1', 'Person ID', ''),
                        '0021xx02': ('PN', '1', 'Person Name', ''),
                        '0021xx03': ('LO', '1', 'Person Role', ''),
                        '0021xx04': ('SH', '1', 'Person Home Phone', ''),
                        '0021xx05': ('SH', '1', 'Person Work Phone', ''),
                        '0021xx06': ('SH', '1', 'Person Cell Phone', ''),
                        '0021xx07': ('SH', '1', 'Person Pager Phone', ''),
                        '0021xx08': ('SH', '1', 'Person Fax Phone', ''),
                        '0021xx09': ('LO', '1', 'Person EMail', ''),
                        '0021xx0a': ('ST', '1', 'Person Address', ''),
                        '0021xx0b': ('LO', '1', 'Person Password', ''),
                        '0021xx0c': ('SH', '1', 'Person Emergency Phone', ''),
                        '0021xx0d': ('LO', '1', 'Physician ID', ''),
                        '0021xx11': ('LO', '1', 'Original Patient ID', ''),
                        '0021xx12': ('UI',
                                     '1',
                                     'Original Study Instance UID',
                                     ''),
                        '0021xx13': ('UI',
                                     '1',
                                     'Original Series Instance UID',
                                     ''),
                        '0021xx14': ('LO',
                                     '1',
                                     'Master Accession Number',
                                     ''),
                        '0021xx15': ('LO', '1', 'Order Category', ''),
                        '0021xx16': ('LO', '1', 'Patient ICN', ''),
                        '0021xx17': ('LO', '1', 'Patient DFS', ''),
                        '0021xx18': ('LO', '1', 'Patient Class', ''),
                        '0021xx19': ('LO', '1', 'Patient Type', ''),
                        '0021xx1f': ('LT', '1', 'Generic String', ''),
                        '0021xx20': ('LO', '1', 'QC Study Assigned By', ''),
                        '0021xx21': ('LO', '1', 'QC Study Split By', ''),
                        '0021xx22': ('LO', '1', 'QC Study Moved By', ''),
                        '0021xx23': ('LO', '1', 'QC Study Edited By', ''),
                        '0021xx24': ('LO', '1', 'QC Series Split By', ''),
                        '0021xx25': ('LO', '1', 'QC Series Moved By', ''),
                        '0021xx26': ('LO', '1', 'QC Series Edited By', ''),
                        '0021xx27': ('LO', '1', 'QC Image Moved By', ''),
                        '0021xx28': ('LO', '1', 'QC Image Edited By', ''),
                        '0021xx30': ('LO', '1', 'QC Done Time', ''),
                        '0021xx31': ('LO',
                                     '1',
                                     'QC Last Modification Time',
                                     ''),
                        '0021xx32': ('LO', '1', 'QC Image Accepted By', ''),
                        '0021xx33': ('LO', '1', 'QC Image Rejected By', ''),
                        '0021xx34': ('DA', '1', 'QC Done Date', ''),
                        '0021xx50': ('LO', '1', 'QC Deletion Requested', ''),
                        '0021xx90': ('AE',
                                     '1',
                                     'Original Sender AE Title',
                                     ''),
                        '0021xx91': ('LO', '1', 'Software Title', ''),
                        '0021xx92': ('SH', '1', 'Software Version', ''),
                        '0021xx93': ('LO', '1', 'Serial Number', ''),
                        '0021xxa0': ('SQ', '1', 'Object Action Sequence', ''),
                        '0021xxa1': ('ST', '1', 'Object Action', ''),
                        '0021xxa2': ('DA', '1', 'Object Action Date', ''),
                        '0021xxa3': ('TM', '1', 'Object Action Time', ''),
                        '0021xxa5': ('AE', '1', 'Local AE Title', ''),
                        '0021xxa6': ('SH', '1', 'Local IP Address', ''),
                        '0021xxa7': ('AE', '1', 'Remote AE Title', ''),
                        '0021xxa8': ('SH', '1', 'Remote IP Address', '')},
 'BioPri': {'0009xx00': ('LO', '1', 'Unknown', ''),
            '0009xx01': ('UN', '1', 'Unknown', ''),
            '0009xx02': ('UN', '1', 'Unknown', ''),
            '0009xx03': ('LO', '1-n', 'Unknown', ''),
            '0009xx04': ('LO', '1', 'Unknown', ''),
            '0009xx05': ('LO', '1', 'Unknown', ''),
            '0009xx07': ('LO', '1', 'Unknown', ''),
            '0009xx08': ('LO', '1', 'Unknown', ''),
            '0009xx09': ('LO', '1', 'Unknown', ''),
            '0009xx10': ('UN', '1', 'Unknown', '')},
 'BioPri3D': {'001110xx': ('UN', '1', 'Private Segmentation Data', ''),
              '006310xx': ('UN', '1', 'Private Creator', '')},
 'BrainLAB_BeamProfile': {'3411xx01': ('SQ',
                                       '1',
                                       'Beam Profile Sequence',
                                       ''),
                          '3411xx02': ('IS', '1', 'Beam Profile Number', ''),
                          '3411xx03': ('SQ',
                                       '1',
                                       'Beam Parameter Sequence',
                                       ''),
                          '3411xx04': ('UT',
                                       '1',
                                       'Parameter Description',
                                       ''),
                          '3411xx05': ('OB', '1', 'Parameter Data', ''),
                          '3411xx06': ('IS',
                                       '1',
                                       'Referenced Beam Profile Number',
                                       '')},
 'BrainLAB_Conversion': {'0009xx01': ('LO', '1', 'Export Platform Name', ''),
                         '0009xx02': ('OB', '1', 'Export Platform Data', '')},
 'BrainLAB_PatientSetup': {'3273xx00': ('DS', '3', 'Isocenter Position', ''),
                           '3273xx01': ('CS', '1', 'Patient Position', '')},
 'CAMTRONICS': {'0029xx10': ('LT', '1', 'Commentline', ''),
                '0029xx20': ('DS', '1', 'Edge Enhancement Coefficient', ''),
                '0029xx50': ('LT', '1', 'Scene Text', ''),
                '0029xx60': ('LT', '1', 'Image Text', ''),
                '0029xx70': ('IS', '1', 'Pixel Shift Horizontal', ''),
                '0029xx80': ('IS', '1', 'Pixel Shift Vertical', ''),
                '0029xx90': ('IS', '1', 'Unknown', '')},
 'CAMTRONICS IP': {'0029xx10': ('LT', '1', 'Unknown', ''),
                   '0029xx20': ('UN', '1', 'Unknown', ''),
                   '0029xx30': ('UN', '1', 'Unknown', ''),
                   '0029xx40': ('UN', '1', 'Unknown', '')},
 'CARDIO-D.R. 1.0': {'0009xx00': ('UL', '1', 'File Location', ''),
                     '0009xx01': ('UL', '1', 'File Size', ''),
                     '0009xx40': ('SQ', '1', 'Alternate Image Sequence', ''),
                     '0019xx00': ('CS', '1-2', 'Image Blanking Shape', ''),
                     '0019xx02': ('IS',
                                  '1',
                                  'Image Blanking Left Vertical Edge',
                                  ''),
                     '0019xx04': ('IS',
                                  '1',
                                  'Image Blanking Right Vertical Edge',
                                  ''),
                     '0019xx06': ('IS',
                                  '1',
                                  'Image Blanking Upper Horizontal Edge',
                                  ''),
                     '0019xx08': ('IS',
                                  '1',
                                  'Image Blanking Lower Horizontal Edge',
                                  ''),
                     '0019xx10': ('IS',
                                  '2',
                                  'Center Of Circular Image Blanking',
                                  ''),
                     '0019xx12': ('IS',
                                  '1',
                                  'Radius Of Circular Image Blanking',
                                  ''),
                     '0019xx30': ('UL', '1', 'Maximum Frame Size', ''),
                     '0021xx13': ('IS', '1', 'Image Sequence Number', ''),
                     '0029xx00': ('SQ',
                                  '1',
                                  'Standard Edge Enhancement Sequence',
                                  ''),
                     '0029xx01': ('US', '2', 'Convolution Kernel Size', ''),
                     '0029xx02': ('US',
                                  '1-n',
                                  'Convolution Kernel Coefficients',
                                  ''),
                     '0029xx03': ('FL', '1', 'Edge Enhancement Gain', '')},
 'CARDIO-SMS 1.0': {'0009xx02': ('OB', '1', 'Private Data', ''),
                    '0009xx03': ('OB', '1', 'Private Data', ''),
                    '0009xx04': ('OB', '1', 'Private Data', ''),
                    '0009xx05': ('OB', '1', 'Private Data', ''),
                    '0009xx06': ('OB', '1', 'Private Data', ''),
                    '0009xx08': ('OB', '1', 'ACOM flags', ''),
                    '0009xx0a': ('UN', '1', 'Private Data', ''),
                    '0009xx0b': ('UN', '1', 'Private Data', ''),
                    '0009xx0c': ('UN', '1', 'Private Data', ''),
                    '0029xx80': ('SQ', '1', 'Private Data', ''),
                    '0031xx01': ('UN', '1', 'Private Data stream', '')},
 'CEMAX-ICON': {'0019xx00': ('LT', '1', 'CR Processing Parameters', ''),
                '0019xx10': ('LO', '1', 'CR Exposure Menu Code', ''),
                '0019xx20': ('LO', '1', 'CR Exposure Menu String', ''),
                '0019xx30': ('LO', '1', 'CR EDR Mode', ''),
                '0019xx40': ('LO', '1', 'CR Latitude', ''),
                '0019xx50': ('LO', '1', 'CR Group Number', ''),
                '0019xx60': ('LO', '1', 'CR Equipment ID', ''),
                '0019xx70': ('LO', '1', 'CR Image Serial Number', ''),
                '0019xx80': ('LO', '1', 'CR Bar Code Number', ''),
                '0019xx90': ('LO', '1', 'CR Film Output Exposure', ''),
                '0029xx00': ('LO', '1', 'Key Image', ''),
                '0029xx10': ('LT', '1-n', 'Note', ''),
                '0029xx20': ('SQ', '1', 'Annotation Sequence', ''),
                '0029xx30': ('IS', '1', 'X Start Position', ''),
                '0029xx40': ('IS', '1', 'Y Start Position', ''),
                '0029xx50': ('IS', '1', 'X End Position', ''),
                '0029xx60': ('IS', '1', 'Y End Position', ''),
                '0029xx70': ('LO', '1', 'Annotation Text', ''),
                '0029xx80': ('IS', '1', 'Which Marker', ''),
                '0029xx90': ('SQ', '1', 'Annotation Sequence', ''),
                '0029xx91': ('IS', '1-n', 'X Coordinates', ''),
                '0029xx92': ('IS', '1-n', 'Y Coordinates', ''),
                '0029xx93': ('IS', '1', 'Annotation Type', ''),
                '0029xx94': ('IS', '1', 'Number of points', ''),
                '0029xx95': ('IS', '1', 'Fill Type', ''),
                '3033xx00': ('CS', '1', 'Study Priority Status', '')},
 'Canon Inc.': {'0019xx10': ('OB', '1', 'Canon Internal Data 1', ''),
                '0019xx13': ('UN', '1', 'Unknown', ''),
                '0019xx15': ('DS', '2', 'Unknown', ''),
                '0019xx16': ('UN', '1', 'Unknown', ''),
                '0019xx17': ('DS', '1', 'Unknown', ''),
                '0019xx18': ('UN', '1', 'Unknown', ''),
                '0019xx19': ('UN', '1', 'Unknown', ''),
                '0019xx1a': ('UN', '1', 'Unknown', ''),
                '0019xx1b': ('LO', '1', 'Unknown', ''),
                '0019xx1c': ('IS', '1', 'Unknown', ''),
                '0019xx1e': ('IS', '1', 'Unknown', ''),
                '0019xx1f': ('UN', '1', 'Unknown', ''),
                '0019xx21': ('IS', '1', 'Unknown', ''),
                '0019xx60': ('US', '1', 'Performed number of series', ''),
                '0019xx70': ('US', '1', 'Performed number of images', ''),
                '0019xx7f': ('OB', '1', 'Canon Internal Data 111', '')},
 'DIDI TO PCR 1.1': {'0019xx00': ('LT', '1', 'Post Mode String', ''),
                     '0019xx01': ('LT', '1', 'Post Data', ''),
                     '0019xx10': ('LT', '1', 'Image Header', ''),
                     '0019xx22': ('LO', '1', 'Route AET', ''),
                     '0019xx23': ('DS', '1', 'PCR Print Scale', ''),
                     '0019xx24': ('ST', '1', 'PCR Print Job End', ''),
                     '0019xx25': ('IS', '1', 'PCR No Film Copies', ''),
                     '0019xx26': ('IS', '1', 'PCR Film Layout Position', ''),
                     '0019xx27': ('ST', '1', 'PCR Print Report Name', ''),
                     '0019xx70': ('ST', '1', 'RAD Protocol Printer', ''),
                     '0019xx71': ('ST', '1', 'RAD Protocol Medium', ''),
                     '0019xx80': ('LO', '1', 'Original Filename', ''),
                     '0019xx81': ('SH', '1', 'Filter Type', ''),
                     '0019xx82': ('LT', '1', 'Stitching', ''),
                     '0019xx89': ('IS', '1', 'Exposure Index', ''),
                     '0019xx8a': ('IS', '1', 'Collimator X', ''),
                     '0019xx8b': ('IS', '1', 'Collimator Y', ''),
                     '0019xx8c': ('LO', '1', 'Print Marker', ''),
                     '0019xx8d': ('LO', '1', 'RGDV Name', ''),
                     '0019xx8e': ('LO', '1', 'Acqd Sensitivity', ''),
                     '0019xx8f': ('LO', '1', 'Processing Category', ''),
                     '0019xx90': ('LO', '1', 'Unprocessed Flag', ''),
                     '0019xx91': ('DS', '2', 'Key Values', ''),
                     '0019xx92': ('LO',
                                  '1',
                                  'Destination Postprocessing Function',
                                  ''),
                     '0019xxa0': ('LO', '1', 'Version', ''),
                     '0019xxa1': ('LO', '1', 'Ranging Mode', ''),
                     '0019xxa2': ('DS', '1', 'Abdomen Brightness', ''),
                     '0019xxa3': ('DS', '1', 'Fixed Brightness', ''),
                     '0019xxa4': ('DS', '1', 'Detail Contrast', ''),
                     '0019xxa5': ('DA', '1', 'Contrast Balance', ''),
                     '0019xxa6': ('DS', '1', 'Structure Boost', ''),
                     '0019xxa7': ('DS', '1', 'Structure Preference', ''),
                     '0019xxa8': ('DS', '1', 'Noise Robustness', ''),
                     '0019xxa9': ('DS', '1', 'Noise Dose Limit', ''),
                     '0019xxaa': ('DS', '1', 'Noise Dose Step', ''),
                     '0019xxab': ('DS', '1', 'Noise Frequency Limit', ''),
                     '0019xxac': ('DS', '1', 'Weak Contrast Limit', ''),
                     '0019xxad': ('DS', '1', 'Strong Contrast Limit', ''),
                     '0019xxae': ('DS', '1', 'Structure Boost Offset', ''),
                     '0019xxaf': ('LO', '1', 'Smooth Gain', ''),
                     '0019xxb0': ('LO', '1', 'Measure Field 1', ''),
                     '0019xxb1': ('LO', '1', 'Measure Field 2', ''),
                     '0019xxb2': ('IS', '1', 'Key Percentile 1', ''),
                     '0019xxb3': ('IS', '1', 'Key Percentile 2', ''),
                     '0019xxb4': ('IS', '1', 'Density LUT', ''),
                     '0019xxb5': ('DS', '1', 'Brightness', ''),
                     '0019xxb6': ('DS', '1', 'Gamma', ''),
                     '0089xx10': ('SQ', '1', 'Stamp Image Sequence', '')},
 'DIGISCAN IMAGE': {'0029xx31': ('US', '1-n', 'Unknown', ''),
                    '0029xx32': ('US', '1-n', 'Unknown', ''),
                    '0029xx33': ('LO', '1', 'Unknown', ''),
                    '0029xx34': ('LO', '1', 'Unknown', '')},
 'DLX_ANNOT_01': {'70xxxx04': ('ST', '1', 'Text_annotation', ''),
                  '70xxxx05': ('IS', '2', 'Box', ''),
                  '70xxxx07': ('IS', '2', 'Arrow end', '')},
 'DLX_EXAMS_01': {'0015xx01': ('DS', '1', 'Stenos_calibr_ratio;', ''),
                  '0015xx02': ('DS', '1', 'Stenos_magnification;', ''),
                  '0015xx03': ('DS', '1', 'Cardiac_calibr_ratio;', '')},
 'DLX_LKUP_01': {'60xxxx01': ('LT',
                              '3',
                              'Gray Palette color lookup table descriptor',
                              ''),
                 '60xxxx02': ('LT',
                              '1',
                              'Gray Palette color lookup table data',
                              '')},
 'DLX_PATNT_01': {'0011xx01': ('LT', '1', 'patient DOB', '')},
 'DLX_SERIE_01': {'0019xx01': ('DS', '1', 'Angle Value 1', ''),
                  '0019xx02': ('DS', '1', 'Angle Value 2', ''),
                  '0019xx03': ('DS', '1', 'Angle Value 3', ''),
                  '0019xx04': ('CS', '1', 'Angle Label 1', ''),
                  '0019xx05': ('CS', '1', 'Angle Label 2', ''),
                  '0019xx06': ('CS', '1', 'Angle Label 3', ''),
                  '0019xx07': ('ST', '1', 'Adx Procedure Name', ''),
                  '0019xx08': ('ST', '1', 'Adx Exam Name', ''),
                  '0019xx09': ('SH', '1', 'Adx Patient Size', ''),
                  '0019xx0a': ('IS', '1', 'Adx Record View', ''),
                  '0019xx10': ('DS', '1', 'Adx Injector Delay', ''),
                  '0019xx11': ('CS', '1', 'Adx Auto Inject', ''),
                  '0019xx14': ('IS', '1', 'Adx Acq Mode', ''),
                  '0019xx15': ('CS', '1', 'Adx Camera Rotation Enable', ''),
                  '0019xx16': ('CS', '1', 'Adx Reverse Sweep', ''),
                  '0019xx17': ('IS', '1', 'User Spatial Filter Strength', ''),
                  '0019xx18': ('IS', '1', 'User Zoom Factor', ''),
                  '0019xx19': ('IS', '1', 'X Zoom', ''),
                  '0019xx1a': ('IS', '1', 'Y Zoom', ''),
                  '0019xx1b': ('DS', '1', 'Adx Focus', ''),
                  '0019xx1c': ('CS', '1', 'Adx Dose', ''),
                  '0019xx1d': ('IS', '1', 'Side Mark', ''),
                  '0019xx1e': ('IS', '1', 'Percent Landscape', ''),
                  '0019xx1f': ('DS', '1', 'Adx Exposure Duration', ''),
                  '0019xx20': ('SH', '1', 'Ip Address', ''),
                  '0019xx21': ('DS', '1', 'Table Vertical Position', ''),
                  '0019xx22': ('DS', '1', 'Table Longitudinal Position', ''),
                  '0019xx23': ('DS', '1', 'Table Lateral Position', ''),
                  '0019xx24': ('DS',
                               '1',
                               'Lambda cm Pincushion Distortion',
                               ''),
                  '0019xx25': ('DS', '1', 'Slope LV Regression', ''),
                  '0019xx26': ('DS', '1', 'Intercept LV Regression', ''),
                  '0019xx27': ('DS', '1', 'Image chain FWHM psf mm min', ''),
                  '0019xx28': ('DS', '1', 'Image chain FWHM psf mm max', '')},
 'DL_INTERNAL_USE': {'0015xx8f': ('IS', '1', 'Unknown', '')},
 'DR Systems, Inc.': {'4453xx01': ('LO', '1', 'DR Exam ID', ''),
                      '4453xx02': ('LO', '1', 'DR Image Type', ''),
                      '4453xx04': ('LO', '1', 'DR File Type', ''),
                      '4453xx05': ('LO', '1', 'DR File Suffix', ''),
                      '4453xx0a': ('UN', '1', 'DR Annotation Type', ''),
                      '4453xx0c': ('SQ',
                                   '1',
                                   'DR Original Instance UID Sequence',
                                   '')},
 'ELGEMS_XPERT': {'7fa1xx00': ('OB',
                               '1',
                               'XPert Composite Report Item buffer',
                               ''),
                  '7fa1xx10': ('OB',
                               '1',
                               'Xpert Composite Report Item Identificator',
                               '')},
 'ELSCINT1': {'0003xx01': ('OW', '1', 'Offset List Structure', ''),
              '00e1xx01': ('US', '1', 'Data Dictionary Version', ''),
              '00e1xx05': ('IS', '1', 'Unknown', ''),
              '00e1xx06': ('IS', '1', 'Unknown', ''),
              '00e1xx07': ('IS', '1', 'Unknown', ''),
              '00e1xx14': ('CS', '1', 'Unknown', ''),
              '00e1xx18': ('OB', '1', 'Unknown', ''),
              '00e1xx21': ('DS', '1', 'Unknown', ''),
              '00e1xx22': ('DS', '2', 'Presentation Relative Center', ''),
              '00e1xx23': ('DS', '2', 'Presentation Relative Part', ''),
              '00e1xx24': ('CS', '1', 'Presentation Horizontal Invert', ''),
              '00e1xx25': ('CS', '1', 'Unknown', ''),
              '00e1xx30': ('UI', '1', 'Unknown', ''),
              '00e1xx31': ('CS', '1', 'Unknown', ''),
              '00e1xx32': ('US', '2', 'Unknown', ''),
              '00e1xx37': ('DS', '1', 'Unknown', ''),
              '00e1xx39': ('SQ', '1', 'Unknown', ''),
              '00e1xx3f': ('CS', '1', 'Unknown', ''),
              '00e1xx40': ('SH', '1', 'Image Label', ''),
              '00e1xx41': ('DS', '1', 'Unknown', ''),
              '00e1xx42': ('LO', '1', 'Unknown', ''),
              '00e1xx43': ('IS', '1', 'Unknown', ''),
              '00e1xx50': ('DS', '1', 'Acquisition Duration', ''),
              '00e1xx51': ('SH', '1', 'Unknown', ''),
              '00e1xx60': ('CS', '1', 'Unknown', ''),
              '00e1xx61': ('LO', '1', 'Protocol File Name', ''),
              '00e1xx62': ('CS', '1', 'Unknown', ''),
              '00e1xx63': ('SH', '1', 'Patient Language', ''),
              '00e1xx65': ('LO', '1', 'Patient Data Modification Date', ''),
              '00e1xx6a': ('IS', '1', 'Unknown', ''),
              '00e1xx6b': ('IS', '1', 'Unknown', ''),
              '00e1xxa0': ('LO', '1', 'Unknown', ''),
              '00e1xxc2': ('UI', '1', 'Unknown', ''),
              '01e1xx18': ('OB', '1', 'Unknown', ''),
              '01e1xx21': ('ST', '1', 'Unknown', ''),
              '01e1xx34': ('IS', '1', 'Unknown', ''),
              '01f1xx01': ('CS', '1', 'Acquisition Type', ''),
              '01f1xx02': ('CS', '1', 'Unknown', ''),
              '01f1xx03': ('CS', '1', 'Concurrent Slices Generation', ''),
              '01f1xx04': ('CS', '1', 'Angular Sampling Density', ''),
              '01f1xx05': ('DS', '1', 'Reconstruction Arc', ''),
              '01f1xx07': ('DS', '1', 'Table Velocity', ''),
              '01f1xx08': ('DS', '1', 'Acquisition Length', ''),
              '01f1xx0a': ('US', '1', 'Edge Enhancement Weight', ''),
              '01f1xx0c': ('DS', '2', 'Scanner Relative Center', ''),
              '01f1xx0d': ('DS', '1', 'Rotation Angle', ''),
              '01f1xx0e': ('FL', '1', 'Unknown', ''),
              '01f1xx26': ('DS', '1', 'Pitch', ''),
              '01f1xx27': ('DS', '1', 'Rotation Time', ''),
              '01f1xx28': ('DS', '1', 'Unknown', ''),
              '01f1xx30': ('US', '1', 'Unknown', ''),
              '01f1xx32': ('CS', '1', 'Image View Convention', ''),
              '01f1xx33': ('DS', '1', 'Unknown', ''),
              '01f1xx36': ('CS', '1', 'Unknown', ''),
              '01f1xx37': ('DS', '1', 'Unknown', ''),
              '01f1xx38': ('LO', '1', 'Unknown', ''),
              '01f1xx39': ('LO', '1', 'Unknown', ''),
              '01f1xx40': ('CS', '1', 'Unknown', ''),
              '01f1xx42': ('SH', '1', 'Unknown', ''),
              '01f1xx43': ('LO', '1', 'Unknown', ''),
              '01f1xx44': ('OW', '1', 'Unknown', ''),
              '01f1xx45': ('IS', '1', 'Unknown', ''),
              '01f1xx46': ('FL', '1', 'Unknown', ''),
              '01f1xx47': ('SH', '1', 'Unknown', ''),
              '01f1xx49': ('DS', '1', 'Unknown', ''),
              '01f1xx4a': ('SH', '1', 'Unknown', ''),
              '01f1xx4b': ('SH', '1', 'Unknown', ''),
              '01f1xx4c': ('SH', '1', 'Unknown', ''),
              '01f1xx4d': ('SH', '1', 'Unknown', ''),
              '01f1xx4e': ('LO', '1', 'Unknown', ''),
              '01f1xx53': ('SH', '1', 'Unknown', ''),
              '01f3xx01': ('SQ', '1', 'Unknown', ''),
              '01f3xx02': ('SS', '1', 'Unknown', ''),
              '01f3xx03': ('FL', '2', 'Unknown', ''),
              '01f3xx04': ('FL', '1', 'Unknown', ''),
              '01f3xx11': ('SQ', '1', 'PS Sequence', ''),
              '01f3xx12': ('SS', '1', 'Unknown', ''),
              '01f3xx13': ('FL', '2', 'Unknown', ''),
              '01f3xx14': ('FL', '1', 'Unknown', ''),
              '01f3xx15': ('US', '1', 'Unknown', ''),
              '01f3xx16': ('FL', '1', 'Unknown', ''),
              '01f3xx17': ('FL', '1', 'Unknown', ''),
              '01f3xx18': ('SH', '1', 'Unknown', ''),
              '01f3xx19': ('FL', '1', 'Unknown', ''),
              '01f3xx23': ('US', '1', 'Unknown', ''),
              '01f3xx24': ('IS', '2', 'Unknown', ''),
              '01f7xx10': ('OB', '1', 'Unknown', ''),
              '01f7xx11': ('OW', '1', 'Unknown', ''),
              '01f7xx13': ('OW', '1', 'Unknown', ''),
              '01f7xx14': ('OW', '1', 'Unknown', ''),
              '01f7xx15': ('OW', '1', 'Unknown', ''),
              '01f7xx16': ('OW', '1', 'Unknown', ''),
              '01f7xx17': ('OW', '1', 'Unknown', ''),
              '01f7xx18': ('OW', '1', 'Unknown', ''),
              '01f7xx19': ('OW', '1', 'Unknown', ''),
              '01f7xx1a': ('OW', '1', 'Unknown', ''),
              '01f7xx1b': ('OW', '1', 'Unknown', ''),
              '01f7xx1c': ('OW', '1', 'Unknown', ''),
              '01f7xx1e': ('OW', '1', 'Unknown', ''),
              '01f7xx1f': ('OW', '1', 'Unknown', ''),
              '01f7xx22': ('UI', '1', 'Unknown', ''),
              '01f7xx23': ('OW', '1', 'Unknown', ''),
              '01f7xx25': ('OW', '1', 'Unknown', ''),
              '01f7xx26': ('OW', '1', 'Unknown', ''),
              '01f7xx27': ('OW', '1', 'Unknown', ''),
              '01f7xx28': ('OW', '1', 'Unknown', ''),
              '01f7xx29': ('OW', '1', 'Unknown', ''),
              '01f7xx2b': ('OW', '1', 'Unknown', ''),
              '01f7xx2c': ('OW', '1', 'Unknown', ''),
              '01f7xx2d': ('OW', '1', 'Unknown', ''),
              '01f7xx2e': ('OW', '1', 'Unknown', ''),
              '01f7xx30': ('OW', '1', 'Unknown', ''),
              '01f7xx31': ('OW', '1', 'Unknown', ''),
              '01f7xx70': ('OW', '1', 'Unknown', ''),
              '01f7xx73': ('OW', '1', 'Unknown', ''),
              '01f7xx74': ('OW', '1', 'Unknown', ''),
              '01f7xx75': ('OW', '1', 'Unknown', ''),
              '0601xx00': ('SH', '1', 'Implementation Version', ''),
              '0601xx20': ('DS', '1', 'Relative Table Position', ''),
              '0601xx21': ('DS', '1', 'Relative Table Height', ''),
              '0601xx30': ('SH', '1', 'Surview Direction', ''),
              '0601xx31': ('DS', '1', 'Surview Length', ''),
              '0601xx50': ('SH', '1', 'Image View Type', ''),
              '0601xx70': ('DS', '1', 'Batch Number', ''),
              '0601xx71': ('DS', '1', 'Batch Size', ''),
              '0601xx72': ('DS', '1', 'Batch Slice Number', ''),
              '07a1xx01': ('UL', '1', 'number of series in study', ''),
              '07a1xx02': ('UL', '1', 'number of images in series', ''),
              '07a1xx03': ('UL', '1', 'last update time', ''),
              '07a1xx04': ('UL', '1', 'last update date', ''),
              '07a1xx07': ('US', '3', 'Unknown', ''),
              '07a1xx08': ('DS', '1-n', 'Unknown', ''),
              '07a1xx09': ('OW', '1', 'Unknown', ''),
              '07a1xx0a': ('OB', '1', 'Tamar Compressed Pixel Data', ''),
              '07a1xx0c': ('US', '1', 'Unknown', ''),
              '07a1xx10': ('LO', '1', 'Tamar Software Version', ''),
              '07a1xx11': ('CS', '1', 'Tamar Compression Type', ''),
              '07a1xx12': ('FL', '1-n', 'Unknown', ''),
              '07a1xx13': ('UL', '1', 'Unknown', ''),
              '07a1xx14': ('LO', '1', 'protection flag', ''),
              '07a1xx16': ('FL', '1-n', 'Unknown', ''),
              '07a1xx18': ('SQ', '1', 'Unknown', ''),
              '07a1xx19': ('FL', '1', 'Unknown', ''),
              '07a1xx1c': ('FL', '1-n', 'Unknown', ''),
              '07a1xx2a': ('CS', '1', 'Tamar Study Status', ''),
              '07a1xx2b': ('CS', '1', 'Unknown', ''),
              '07a1xx36': ('AE', '1', 'Tamar Source Ae', ''),
              '07a1xx40': ('CS', '1', 'Tamar Study Body Part', ''),
              '07a1xx43': ('IS', '1', 'Unknown', ''),
              '07a1xx50': ('US', '1', 'Tamar Site Id', ''),
              '07a1xx56': ('US', '1', 'Unknown', ''),
              '07a1xx75': ('LO', '2', 'Unknown', ''),
              '07a1xx85': ('UL', '1', 'Tamar Translate Flags', ''),
              '07a1xx9f': ('CS', '1', 'Unknown', ''),
              '07a3xx01': ('LO', '1', 'Tamar Exe Software Version', ''),
              '07a3xx03': ('CS', '1', 'Tamar Study Has Sticky Note', ''),
              '07a3xx05': ('CS', '1', 'Unknown', ''),
              '07a3xx06': ('CS', '1', 'Unknown', ''),
              '07a3xx10': ('LO', '1', 'Tamar Original Curve Desc', ''),
              '07a3xx34': ('SH', '1', 'Tamar Study Age', ''),
              '07a3xx43': ('DS', '1-n', 'Unknown', ''),
              '07a3xx55': ('SH', '1', 'Unknown', ''),
              '07a3xx61': ('LT', '1', 'Unknown', ''),
              '07a3xx62': ('SQ', '1', 'Unknown', ''),
              '07a3xx63': ('SQ', '1', 'Unknown', ''),
              '07a3xx64': ('IS', '1-n', 'Unknown', ''),
              '07a3xx66': ('IS', '1', 'Unknown', ''),
              '07a3xx99': ('CS', '1', 'Unknown', ''),
              '07a3xx9c': ('CS', '1', 'Unknown', ''),
              '07a3xx9f': ('CS', '1', 'Unknown', ''),
              '5001xx70': ('SQ', '1', 'Unknown', ''),
              '5001xx71': ('SH', '1', 'Unknown', ''),
              '5001xx80': ('SQ', '1', 'Unknown', ''),
              '5001xx81': ('SH', '1', 'Unknown', ''),
              '5001xx82': ('US', '3', 'Unknown', ''),
              '5001xx83': ('FL', '1-n', 'Unknown', ''),
              '5001xx84': ('SQ', '1', 'Unknown', ''),
              '6001xx10': ('CS', '1', 'Text Overlay Flag', ''),
              '7fdfxxf0': ('OB', '1', 'Unknown', ''),
              '7fdfxxff': ('SH', '1', 'Unknown', '')},
 'EMAGEON JPEG2K INFO': {'0009xx00': ('SQ', '1', 'Unknown', ''),
                         '0009xx01': ('DT', '1', 'Unknown', '')},
 'EMAGEON STUDY HOME': {'0009xx00': ('LO', '1', 'Unknown', ''),
                        '0009xx01': ('LO', '1', 'Unknown', '')},
 'Eclispe 60': {'0029xx30': ('UL', '1', 'Private data', ''),
                '0029xx31': ('UL', '1', 'Private data', ''),
                '0029xx32': ('UL', '1', 'Private data', ''),
                '0029xx33': ('DS', '1', 'Private data', ''),
                '0029xx34': ('DS', '1', 'Private data', ''),
                '0029xx36': ('SL', '1', 'Private data', ''),
                '0029xx40': ('CS', '1', 'Private data', ''),
                '0029xx50': ('CS', '1', 'Private data', ''),
                '0029xx51': ('UL', '1', 'Private data', ''),
                '0029xx52': ('UL', '1', 'Private data', ''),
                '0029xx53': ('DS', '1', 'Private data', ''),
                '0029xx54': ('UL', '1', 'Private data', ''),
                '0029xx55': ('FL', '1', 'Private data', ''),
                '0029xx56': ('US', '1', 'Private data', ''),
                '0029xx60': ('LO', '1', 'Private data', ''),
                '0031xx30': ('UL', '1', 'Private data', ''),
                '0031xx31': ('UL', '1', 'Private data', ''),
                '0031xx32': ('LO', '1', 'Private data', ''),
                '0031xx33': ('UL', '1', 'Private data', ''),
                '0031xx34': ('UL', '1', 'Private data', ''),
                '0031xx35': ('UL', '1', 'Private data', ''),
                '200dxx01': ('LO', '1', 'Private data', ''),
                '200dxx02': ('LO', '1', 'Private data', ''),
                '200dxx03': ('LO', '1', 'Private data', ''),
                '200dxx04': ('LO', '1', 'Private data', ''),
                '200dxx05': ('LO', '1', 'Private data', ''),
                '200dxx06': ('LO', '1', 'Private data', ''),
                '200dxx07': ('LO', '1', 'Private data', ''),
                '200dxx08': ('LO', '1', 'Private data', ''),
                '200dxx09': ('LO', '1', 'Private data', ''),
                '200dxx0a': ('IS', '1', 'Private data', ''),
                '200dxx0b': ('OB', '1', 'Private data', ''),
                '200dxx0c': ('IS', '1', 'Private data', ''),
                '200dxx0d': ('UL', '1', 'Private data', ''),
                '200dxx0e': ('IS', '1', 'Private data', ''),
                '200dxx0f': ('IS', '1', 'Private data', ''),
                '200dxx10': ('IS', '1', 'Private data', ''),
                '200dxx11': ('IS', '1', 'Private data', ''),
                '200dxx12': ('OB', '1', 'Private data', ''),
                '200dxx13': ('IS', '1', 'Private data', ''),
                '200dxx14': ('IS', '1', 'Private data', ''),
                '200dxx15': ('IS', '1', 'Private data', ''),
                '200dxx1a': ('IS', '1', 'Private data', ''),
                '200dxx1b': ('IS', '1', 'Private data', ''),
                '200dxx20': ('SQ', '1', 'Private data', ''),
                '200dxx27': ('FD', '1', 'Private data', ''),
                '200dxx28': ('FD', '1', 'Private data', ''),
                '200dxx30': ('LO', '1', 'Private data', ''),
                '200dxx31': ('LO', '1', 'Private data', ''),
                '200dxx32': ('LO', '1', 'Private data', ''),
                '200dxx33': ('LO', '1', 'Private data', ''),
                '200dxx34': ('LO', '1', 'Private data', ''),
                '200dxx35': ('LO', '1', 'Private data', ''),
                '200dxx36': ('LO', '1', 'Private data', ''),
                '200dxx37': ('LO', '1', 'Private data', ''),
                '200dxx38': ('LO', '1', 'Private data', ''),
                '200dxx39': ('LO', '1', 'Private data', ''),
                '200dxx3a': ('LO', '1', 'Private data', ''),
                '200dxx50': ('CS', '1', 'Private data', ''),
                '200dxx51': ('CS', '1', 'Private data', ''),
                '200dxx52': ('FD', '1', 'Private data', ''),
                '200dxx53': ('CS', '1', 'Private data', ''),
                '200dxx54': ('CS', '1', 'Private data', ''),
                '200dxx55': ('FD', '1', 'Private data', ''),
                '200dxx56': ('FD', '1', 'Private data', ''),
                '200dxx57': ('FD', '1', 'Private data', ''),
                '200dxx58': ('IS', '1', 'Private data', ''),
                '200dxx59': ('FD', '1', 'Private data', ''),
                '200dxx5a': ('FD', '1', 'Private data', ''),
                '200dxx5d': ('CS', '1', 'Private data', ''),
                '200dxx5e': ('CS', '1', 'Private data', ''),
                '200dxxff': ('IS', '1', 'Private data', ''),
                '7777xx01': ('DA', '1', 'Private data', ''),
                '7777xx02': ('CS', '1', 'Private data', ''),
                '7777xx03': ('LO', '1', 'Private data', ''),
                '7777xx10': ('LO', '1', 'Private data', ''),
                '7777xx14': ('LT', '1', 'Private data', '')},
 'FDMS 1.0': {'0009xx04': ('SH', '1', 'Image Control Unit', ''),
              '0009xx05': ('OW', '1', 'Image UID', ''),
              '0009xx06': ('OW', '1', 'Route Image UID', ''),
              '0009xx08': ('UL',
                           '1',
                           'Image Display Information Version No.',
                           ''),
              '0009xx09': ('UL', '1', 'Patient Information Version No.', ''),
              '0009xx0c': ('OW', '1', 'Film UID', ''),
              '0009xx10': ('CS', '1', 'Exposure Unit Type Code', ''),
              '0009xx80': ('LO', '1', 'Kanji Hospital Name', ''),
              '0009xx90': ('ST', '1', 'Distribution Code', ''),
              '0009xx92': ('SH', '1', 'Kanji Department Name', ''),
              '0009xxf0': ('CS', '1', 'Blackening Process Flag', ''),
              '0009xxf1': ('ST', '1', 'Processing Information Flag', ''),
              '0019xx15': ('LO', '1', 'Kanji Body Part for Exposure', ''),
              '0019xx30': ('LO', '1', 'Menu Character String', ''),
              '0019xx32': ('LO', '1', 'Kanji Menu Name', ''),
              '0019xx40': ('CS', '1', 'Image Processing Type', ''),
              '0019xx50': ('CS', '1', 'EDR Mode', ''),
              '0019xx60': ('SH', '1', "Radiographer's Code", ''),
              '0019xx70': ('IS', '1', 'Split Exposure Format', ''),
              '0019xx71': ('IS', '1', 'No. of Split Exposure Frames', ''),
              '0019xx80': ('IS', '1', 'Reading Position Specification', ''),
              '0019xx81': ('IS', '1', 'Reading Sensitivity Center', ''),
              '0019xx90': ('SH',
                           '1',
                           'Film Annotation Character String 1',
                           ''),
              '0019xx91': ('SH',
                           '1',
                           'Film Annotation Character String 2',
                           ''),
              '0019xxa0': ('SQ', '1', 'Exposure Status Sequence', ''),
              '0019xxa1': ('CS', '1', 'Exposure Status', ''),
              '0019xxa2': ('CS', '1', 'Exposure Kind', ''),
              '0021xx10': ('CS', '1', 'FCR Image ID', ''),
              '0021xx30': ('CS', '1', 'Set No.', ''),
              '0021xx40': ('IS', '1', 'Image No. in the Set', ''),
              '0021xx50': ('CS', '1', 'Pair Processing Information', ''),
              '0021xx70': ('IS', '1', 'Film Number within the Series', ''),
              '0021xx80': ('OB',
                           '1',
                           'Equipment Type-Specific Information',
                           ''),
              '0021xx90': ('CS', '1', 'LUT Number', ''),
              '0023xx10': ('SQ', '1', 'Unknown', ''),
              '0023xx20': ('SQ', '1', 'Unknown', ''),
              '0023xx30': ('SQ', '1', 'Unknown', ''),
              '0025xx10': ('US',
                           '1',
                           'Relative Light Emission Amount Sk',
                           ''),
              '0025xx11': ('US',
                           '1',
                           'Term of Correction for Each IP Type St',
                           ''),
              '0025xx12': ('US', '1', 'Reading Gain Gp', ''),
              '0025xx13': ('US', '1', 'Unknown', ''),
              '0025xx15': ('CS', '1', 'Unknown', ''),
              '0025xx20': ('US', '2', 'Unknown', ''),
              '0025xx21': ('US', '1', 'Unknown', ''),
              '0025xx30': ('US', '1', 'Unknown', ''),
              '0025xx31': ('SS', '1', 'Unknown', ''),
              '0025xx32': ('US', '1', 'Unknown', ''),
              '0025xx33': ('SS', '1', 'Unknown', ''),
              '0025xx34': ('SS', '1', 'Unknown', ''),
              '0025xx40': ('US', '1', 'Unknown', ''),
              '0025xx41': ('US', '1', 'Unknown', ''),
              '0025xx42': ('US', '1', 'Unknown', ''),
              '0025xx43': ('US', '1', 'Unknown', ''),
              '0025xx50': ('US', '1', 'Unknown', ''),
              '0025xx51': ('US', '1', 'Unknown', ''),
              '0025xx52': ('US', '1', 'Unknown', ''),
              '0025xx53': ('US', '1', 'Unknown', ''),
              '0025xx60': ('US', '1', 'Unknown', ''),
              '0025xx61': ('US', '1', 'Unknown', ''),
              '0025xx62': ('US', '1', 'Unknown', ''),
              '0025xx63': ('CS', '1', 'Unknown', ''),
              '0025xx70': ('US', '1', 'Unknown', ''),
              '0025xx71': ('US', '1', 'Unknown', ''),
              '0025xx72': ('US', '1', 'Unknown', ''),
              '0025xx73': ('US', '6', 'Unknown', ''),
              '0025xx74': ('US', '6', 'Unknown', ''),
              '0025xx80': ('US', '1', 'Unknown', ''),
              '0025xx81': ('US', '1', 'Unknown', ''),
              '0025xx82': ('US', '1', 'Unknown', ''),
              '0025xx83': ('US', '6', 'Unknown', ''),
              '0025xx84': ('US', '6', 'Unknown', ''),
              '0025xx90': ('US', '1', 'Unknown', ''),
              '0025xx91': ('US', '1', 'Unknown', ''),
              '0025xx92': ('US', '1', 'Unknown', ''),
              '0025xx93': ('US', '1', 'Unknown', ''),
              '0025xx94': ('US', '1', 'Unknown', ''),
              '0025xx95': ('US', '1', 'Unknown', ''),
              '0025xx96': ('CS', '1', 'Unknown', ''),
              '0025xxa0': ('US', '1', 'Unknown', ''),
              '0025xxa1': ('SS', '1', 'Unknown', ''),
              '0025xxa2': ('US', '1', 'Unknown', ''),
              '0025xxa3': ('SS', '1', 'Unknown', ''),
              '0027xx10': ('SQ', '1', 'Unknown', ''),
              '0027xx20': ('SQ', '1', 'Unknown', ''),
              '0027xx30': ('SQ', '1', 'Unknown', ''),
              '0027xx40': ('SQ', '1', 'Unknown', ''),
              '0027xx50': ('SQ', '1', 'Unknown', ''),
              '0027xx60': ('SQ', '1', 'Unknown', ''),
              '0027xx70': ('SQ', '1', 'Unknown', ''),
              '0027xx80': ('SQ', '1', 'Unknown', ''),
              '0027xxa0': ('IS', '1', 'Unknown', ''),
              '0027xxa1': ('CS', '2', 'Unknown', ''),
              '0027xxa2': ('CS', '2', 'Unknown', ''),
              '0027xxa3': ('SS', '1-n', 'Unknown', ''),
              '0029xx20': ('CS', '1', 'Image Scanning Direction', ''),
              '0029xx25': ('CS',
                           '1',
                           'Image Rotation/Reversal Information',
                           ''),
              '0029xx30': ('CS', '1', 'Extended Reading Size Value', ''),
              '0029xx34': ('US', '1', 'Mag./Reduc. Ratio', ''),
              '0029xx44': ('CS', '1', 'Line Density Code', ''),
              '0029xx50': ('CS', '1', 'Data Compression Code', ''),
              '0032xx32': ('PN', '1', 'Requesting Physician', ''),
              '0032xx33': ('LO', '1', 'Requesting Service', ''),
              '2011xx00': ('CS', '1', 'Trim Density', ''),
              '2011xx01': ('IS', '1', 'Trim Width', ''),
              '2011xx02': ('CS', '1', 'Image Mag./Reduc. Range', ''),
              '2011xx10': ('CS', '1', 'Image Display Format', ''),
              '2011xx11': ('CS', '1', 'Image Position Specifying Flag', ''),
              '2011xx20': ('OW',
                           '1',
                           'Interpolation A-VRS System Format',
                           ''),
              '50f1xx06': ('CS', '1', 'Energy Subtraction Param.', ''),
              '50f1xx07': ('CS', '1', 'Subtraction Registration Result', ''),
              '50f1xx08': ('CS', '1', 'Energy Subtraction Param. 2', ''),
              '50f1xx09': ('SL', '1', 'Afin Conversion Coefficient', ''),
              '50f1xx0a': ('SH', '1', 'FNC Parameters', ''),
              '50f1xx10': ('CS', '1', 'Film Output Format', ''),
              '50f1xx20': ('CS',
                           '1',
                           'Image Processing Modification Flag',
                           '')},
 'FFP DATA': {'0009xx01': ('UN', '1', 'CR Header Information', '')},
 'GDCM CONFORMANCE TESTS': {'4d4dxx01': ('SQ',
                                         '1',
                                         'Array Container Sequence',
                                         ''),
                            '4d4dxx02': ('OB', '1', '0-Filled Array', '')},
 'GE ??? From Adantage Review CS': {'0019xx30': ('LO',
                                                 '1',
                                                 'CR EDR Mode',
                                                 ''),
                                    '0019xx40': ('LO',
                                                 '1',
                                                 'CR Latitude',
                                                 ''),
                                    '0019xx50': ('LO',
                                                 '1',
                                                 'CR Group Number',
                                                 ''),
                                    '0019xx70': ('LO',
                                                 '1',
                                                 'CR Image Serial Number',
                                                 ''),
                                    '0019xx80': ('LO',
                                                 '1',
                                                 'CR Bar Code Number',
                                                 ''),
                                    '0019xx90': ('LO',
                                                 '1',
                                                 'CR Film Output Exposures',
                                                 '')},
 'GE LUT Asymmetry Parameter': {'0045xx67': ('DS', '1', 'LUT Assymetry', '')},
 'GEHC_CT_ADVAPP_001': {'0053xx20': ('IS', '1', 'Unknown', ''),
                        '0053xx40': ('SH', '1', 'Unknown', ''),
                        '0053xx41': ('SH', '1', 'Unknown', ''),
                        '0053xx42': ('LO', '1', 'Unknown', ''),
                        '0053xx43': ('SH', '1', 'Unknown', ''),
                        '0053xx60': ('SH', '1', 'Unknown', ''),
                        '0053xx62': ('SH', '1', 'Unknown', '')},
 'GEIIS': {'0009xx10': ('SQ', '1', 'GE IIS Thumbnail Sequence', ''),
           '0009xx12': ('IS', '1', 'Unknown', ''),
           '0029xx10': ('UL', '1', 'Shift Count', ''),
           '0029xx12': ('UL', '1', 'Offset', ''),
           '0029xx14': ('UL', '1', 'Actual Frame Number', ''),
           '004bxx13': ('IS', '1', 'Unknown', ''),
           '004bxx15': ('LT', '1', 'Unknown', ''),
           '0905xx30': ('LO', '1', 'Assigning Authority For Patient ID', ''),
           '0907xx10': ('UI', '1', 'Original Study Instance UID', ''),
           '0907xx20': ('UI', '1', 'Original Series Instance UID', ''),
           '0907xx30': ('UI', '1', 'Original SOP Instance UID', ''),
           '7fd1xx10': ('UL', '1', 'GE IIS Compression ID', ''),
           '7fd1xx20': ('UL', '1', 'GE IIS Multiframe Offsets', ''),
           '7fd1xx30': ('UL', '1', 'Unknown', ''),
           '7fd1xx40': ('UL', '1-n', 'Unknown', ''),
           '7fd1xx50': ('UL', '1-n', 'Unknown', ''),
           '7fd1xx60': ('UL', '1-n', 'Unknown', '')},
 'GEIIS PACS': {'0903xx10': ('US', '1', 'Reject Image Flag', ''),
                '0903xx11': ('US', '1', 'Significant Flag', ''),
                '0903xx12': ('US', '1', 'Confidential Flag', ''),
                '0903xx20': ('CS', '1', 'Unknown', ''),
                '0907xx21': ('US', '1', 'GEIIS_PREFETCH_ALGORITHM', ''),
                '0907xx22': ('US', '1', 'GEIIS_LIMIT_RECENT_STUDIES', ''),
                '0907xx23': ('US', '1', 'GEIIS_LIMIT_OLDEST_STUDIES', ''),
                '0907xx24': ('US', '1', 'GEIIS_LIMIT_RECENT_MONTHS', ''),
                '0907xx31': ('UI', '1-n', 'GEIIS_EXCLUDE_STUDY_UIDS', '')},
 'GEMS-IT/Centricity RA600/7.0': {'4113xx10': ('UI',
                                               '1',
                                               'Number of images in study',
                                               '')},
 'GEMS_0039': {'0039xx95': ('LO', '1', 'Unknown', '')},
 'GEMS_3DSTATE_001': {'0047xxd6': ('ST', '1', 'General Description', ''),
                      '0047xxd7': ('CS', '1', 'TDRT', ''),
                      '0047xxd8': ('US', '1', 'NVRP', ''),
                      '0047xxd9': ('US', '1', 'CVRPN', ''),
                      '0047xxda': ('SQ',
                                   '1',
                                   'Volume Rendering Presets Sequence',
                                   ''),
                      '0047xxdb': ('LO', '1', 'Preset Name', ''),
                      '0047xxdc': ('SS', '1-n', 'Opacity Curve X', ''),
                      '0047xxdd': ('FL', '1-n', 'Opacity Curve Y', ''),
                      '0047xxde': ('US', '1', 'NOCP', ''),
                      '0047xxdf': ('SS', '1-n', 'Color Curve X', ''),
                      '0047xxe1': ('US', '1', 'NCCP', ''),
                      '0047xxe2': ('CS', '1', 'GSA', ''),
                      '0047xxe3': ('CS', '1', 'VRSF', ''),
                      '0047xxe4': ('FL', '1', 'AF', ''),
                      '0047xxe5': ('FL', '1', 'DF', ''),
                      '0047xxe6': ('FL', '1', 'SCF', ''),
                      '0047xxe7': ('FL', '1', 'SPF', ''),
                      '0047xxe8': ('FL',
                                   '24',
                                   'Orthogonal Clipping Planes',
                                   ''),
                      '0047xxe9': ('FL', '3', 'CP', ''),
                      '0047xxea': ('DS', '3', 'CFP', ''),
                      '0047xxeb': ('DS', '3', 'CVU', ''),
                      '0047xxec': ('FL', '1', 'RFOV', ''),
                      '0047xxed': ('CS', '1', 'PPRP', ''),
                      '0047xxee': ('DS', '1', '3DWW', ''),
                      '0047xxef': ('DS', '1', '3DWL', ''),
                      '0047xxf0': ('CS', '1', 'BBV', ''),
                      '0047xxf1': ('CS', '1', 'ERF', ''),
                      '0047xxf2': ('US', '1', 'TDRMS', ''),
                      '0047xxf3': ('FL', '1', 'TDSSS', '')},
 'GEMS_ACQU_01': {'0009xx24': ('DS', '1', 'Unknown', ''),
                  '0009xx25': ('US', '1', 'Unknown', ''),
                  '0009xx3e': ('US', '1', 'Unknown', ''),
                  '0009xx3f': ('US', '1', 'Unknown', ''),
                  '0009xx42': ('US', '1', 'Unknown', ''),
                  '0009xx43': ('US', '1', 'Unknown', ''),
                  '0009xxf8': ('US', '1', 'Unknown', ''),
                  '0009xxfb': ('IS', '1', 'Unknown', ''),
                  '001910xx': ('LO', '1', 'Private Element Creator', ''),
                  '0019xx01': ('LT', '1', 'Unknown', ''),
                  '0019xx02': ('SL', '1', 'Detector Channel', ''),
                  '0019xx03': ('DS', '1', 'Cell number at Theta', ''),
                  '0019xx04': ('DS', '1', 'Cell spacing', ''),
                  '0019xx05': ('LT', '1', 'Unknown', ''),
                  '0019xx06': ('UN', '1', 'Unknown', ''),
                  '0019xx0e': ('US', '1', 'Unknown', ''),
                  '0019xx0f': ('DS', '1', 'Horiz. Frame of ref.', ''),
                  '0019xx11': ('SS', '1', 'Series contrast', ''),
                  '0019xx12': ('SS', '1', 'Last pseq', ''),
                  '0019xx13': ('SS', '1', 'Start number for baseline', ''),
                  '0019xx14': ('SS', '1', 'End number for baseline', ''),
                  '0019xx15': ('SS',
                               '1',
                               'Start number for enhanced scans',
                               ''),
                  '0019xx16': ('SS',
                               '1',
                               'End number for enhanced scans',
                               ''),
                  '0019xx17': ('SS', '1', 'Series plane', ''),
                  '0019xx18': ('LO', '1', 'First scan ras', ''),
                  '0019xx19': ('DS', '1', 'First scan location', ''),
                  '0019xx1a': ('LO', '1', 'Last scan ras', ''),
                  '0019xx1b': ('DS', '1', 'Last scan loc', ''),
                  '0019xx1e': ('DS', '1', 'Display field of view', ''),
                  '0019xx20': ('DS', '1', 'Unknown', ''),
                  '0019xx22': ('DS', '1', 'Unknown', ''),
                  '0019xx23': ('DS', '1', 'Table Speed [mm/rotation]', ''),
                  '0019xx24': ('DS', '1', 'Mid Scan Time [sec]', ''),
                  '0019xx25': ('SS', '1', 'Mid scan flag', ''),
                  '0019xx26': ('SL', '1', 'Tube Azimuth [degree]', ''),
                  '0019xx27': ('DS', '1', 'Rotation Speed [msec]', ''),
                  '0019xx2a': ('DS', '1', 'x-ray On position', ''),
                  '0019xx2b': ('DS', '1', 'x-ray Off position', ''),
                  '0019xx2c': ('SL', '1', 'Number of triggers', ''),
                  '0019xx2d': ('US', '1', 'Unknown', ''),
                  '0019xx2e': ('DS', '1', 'Angle of first view', ''),
                  '0019xx2f': ('DS', '1', 'Trigger frequency', ''),
                  '0019xx39': ('SS', '1', 'SFOV Type', ''),
                  '0019xx3a': ('IS', '1', 'Unknown', ''),
                  '0019xx3b': ('LT', '1', 'Unknown', ''),
                  '0019xx3c': ('UN', '1', 'Unknown', ''),
                  '0019xx3e': ('UN', '1', 'Unknown', ''),
                  '0019xx3f': ('UN', '1', 'Unknown', ''),
                  '0019xx40': ('SS', '1', 'Stat recon flag', ''),
                  '0019xx41': ('SS', '1', 'Compute type', ''),
                  '0019xx42': ('SS', '1', 'Segment Number', ''),
                  '0019xx43': ('SS', '1', 'Total Segments Required', ''),
                  '0019xx44': ('DS', '1', 'Interscan delay', ''),
                  '0019xx47': ('SS', '1', 'View compression factor', ''),
                  '0019xx48': ('US', '1', 'Unknown', ''),
                  '0019xx49': ('US', '1', 'Unknown', ''),
                  '0019xx4a': ('SS', '1', 'Total no. of ref channels', ''),
                  '0019xx4b': ('SL', '1', 'Data size for scan data', ''),
                  '0019xx52': ('SS', '1', 'Recon post proc. Flag', ''),
                  '0019xx54': ('UN', '1', 'Unknown', ''),
                  '0019xx57': ('SS', '1', 'CT water number', ''),
                  '0019xx58': ('SS', '1', 'CT bone number', ''),
                  '0019xx5a': ('FL', '1', 'Acquisition Duration', ''),
                  '0019xx5d': ('US', '1', 'Unknown', ''),
                  '0019xx5e': ('SL', '1', 'Number of channels (1...512)', ''),
                  '0019xx5f': ('SL', '1', 'Increment between channels', ''),
                  '0019xx60': ('SL', '1', 'Starting view', ''),
                  '0019xx61': ('SL', '1', 'Number of views', ''),
                  '0019xx62': ('SL', '1', 'Increment between views', ''),
                  '0019xx6a': ('SS',
                               '1',
                               'Dependent on #views processed',
                               ''),
                  '0019xx6b': ('SS',
                               '1',
                               'Field of view in detector cells',
                               ''),
                  '0019xx70': ('SS',
                               '1',
                               'Value of back projection button',
                               ''),
                  '0019xx71': ('SS',
                               '1',
                               'Set if fatq estimates were used',
                               ''),
                  '0019xx72': ('DS', '1', 'Z chan avg over views', ''),
                  '0019xx73': ('DS',
                               '1',
                               'Avg of left ref chans over views',
                               ''),
                  '0019xx74': ('DS', '1', 'Max left chan over views', ''),
                  '0019xx75': ('DS',
                               '1',
                               'Avg of right ref chans over views',
                               ''),
                  '0019xx76': ('DS', '1', 'Max right chan over views', ''),
                  '0019xx7d': ('DS', '1', 'Second echo', ''),
                  '0019xx7e': ('SS', '1', 'Number of echoes', ''),
                  '0019xx7f': ('DS', '1', 'Table delta', ''),
                  '0019xx81': ('SS', '1', 'Contiguous', ''),
                  '0019xx82': ('US', '1', 'Unknown', ''),
                  '0019xx83': ('DS', '1', 'Unknown', ''),
                  '0019xx84': ('DS', '1', 'Peak SAR', ''),
                  '0019xx85': ('SS', '1', 'Monitor SAR', ''),
                  '0019xx86': ('US', '1', 'Unknown', ''),
                  '0019xx87': ('DS', '1', 'Cardiac repetition time', ''),
                  '0019xx88': ('SS', '1', 'Images per cardiac cycle', ''),
                  '0019xx8a': ('SS', '1', 'Actual receive gain analog', ''),
                  '0019xx8b': ('SS', '1', 'Actual receive gain digital', ''),
                  '0019xx8d': ('DS', '1', 'Delay after trigger', ''),
                  '0019xx8f': ('SS', '1', 'Swappf', ''),
                  '0019xx90': ('SS', '1', 'Pause Interval', ''),
                  '0019xx91': ('DS', '1', 'Pause Time', ''),
                  '0019xx92': ('SL', '1', 'Slice offset on freq axis', ''),
                  '0019xx93': ('DS',
                               '1',
                               'Auto Prescan Center Frequency',
                               ''),
                  '0019xx94': ('SS', '1', 'Auto Prescan Transmit Gain', ''),
                  '0019xx95': ('SS',
                               '1',
                               'Auto Prescan Analog receiver gain',
                               ''),
                  '0019xx96': ('SS',
                               '1',
                               'Auto Prescan Digital receiver gain',
                               ''),
                  '0019xx97': ('SL', '1', 'Bitmap defining CVs', ''),
                  '0019xx98': ('SS', '1', 'Center freq. Method', ''),
                  '0019xx99': ('US', '1', 'Unknown', ''),
                  '0019xx9b': ('SS', '1', 'Pulse Sequence Mode', ''),
                  '0019xx9c': ('LO', '1', 'Pulse Sequence Name', ''),
                  '0019xx9d': ('DT', '1', 'Pulse Sequence Date', ''),
                  '0019xx9e': ('LO', '1', 'Internal Pulse Sequence Name', ''),
                  '0019xx9f': ('SS', '1', 'Transmitting Coil Type', ''),
                  '0019xxa0': ('SS', '1', 'Surface Coil Type', ''),
                  '0019xxa1': ('SS', '1', 'Extremity Coil flag', ''),
                  '0019xxa2': ('SL', '1', 'Raw data run number', ''),
                  '0019xxa3': ('UL', '1', 'Calibrated Field strength', ''),
                  '0019xxa4': ('SS', '1', 'SAT fat/water/bone', ''),
                  '0019xxa5': ('DS', '1', 'Receive bandwidth', ''),
                  '0019xxa7': ('DS', '1', 'User data 0', ''),
                  '0019xxa8': ('DS', '1', 'User data 1', ''),
                  '0019xxa9': ('DS', '1', 'User data 2', ''),
                  '0019xxaa': ('DS', '1', 'User data 3', ''),
                  '0019xxab': ('DS', '1', 'User data 4', ''),
                  '0019xxac': ('DS', '1', 'User data 5', ''),
                  '0019xxad': ('DS', '1', 'User data 6', ''),
                  '0019xxae': ('DS', '1', 'User data 7', ''),
                  '0019xxaf': ('DS', '1', 'User data 8', ''),
                  '0019xxb0': ('DS', '1', 'User data 9', ''),
                  '0019xxb1': ('DS', '1', 'User data 10', ''),
                  '0019xxb2': ('DS', '1', 'User data 11', ''),
                  '0019xxb3': ('DS', '1', 'User data 12', ''),
                  '0019xxb4': ('DS', '1', 'User data 13', ''),
                  '0019xxb5': ('DS', '1', 'User data 14', ''),
                  '0019xxb6': ('DS', '1', 'User data 15', ''),
                  '0019xxb7': ('DS', '1', 'User data 16', ''),
                  '0019xxb8': ('DS', '1', 'User data 17', ''),
                  '0019xxb9': ('DS', '1', 'User data 18', ''),
                  '0019xxba': ('DS', '1', 'User data 19', ''),
                  '0019xxbb': ('DS', '1', 'User data 20', ''),
                  '0019xxbc': ('DS', '1', 'User data 21', ''),
                  '0019xxbd': ('DS', '1', 'User data 22', ''),
                  '0019xxbe': ('DS', '1', 'Projection angle', ''),
                  '0019xxc0': ('SS', '1', 'Saturation planes', ''),
                  '0019xxc1': ('SS', '1', 'Surface coil intensity', ''),
                  '0019xxc2': ('SS', '1', 'SAT location R', ''),
                  '0019xxc3': ('SS', '1', 'SAT location L', ''),
                  '0019xxc4': ('SS', '1', 'SAT location A', ''),
                  '0019xxc5': ('SS', '1', 'SAT location P', ''),
                  '0019xxc6': ('SS', '1', 'SAT location H', ''),
                  '0019xxc7': ('SS', '1', 'SAT location F', ''),
                  '0019xxc8': ('SS', '1', 'SAT thickness R/L', ''),
                  '0019xxc9': ('SS', '1', 'SAT thickness A/P', ''),
                  '0019xxca': ('SS', '1', 'SAT thickness H/F', ''),
                  '0019xxcb': ('SS', '1', 'Phase Contrast flow axis', ''),
                  '0019xxcc': ('SS', '1', 'Velocity encoding', ''),
                  '0019xxcd': ('SS', '1', 'Thickness disclaimer', ''),
                  '0019xxce': ('SS', '1', 'Prescan type', ''),
                  '0019xxcf': ('SS', '1', 'Prescan status', ''),
                  '0019xxd0': ('SH', '1', 'Raw data type', ''),
                  '0019xxd2': ('SS', '1', 'Projection Algorithm', ''),
                  '0019xxd3': ('SH', '1', 'Projection Algorithm Name', ''),
                  '0019xxd4': ('US', '1', 'Unknown', ''),
                  '0019xxd5': ('SS', '1', 'Fractional echo', ''),
                  '0019xxd6': ('SS', '1', 'Prep pulse', ''),
                  '0019xxd7': ('SS', '1', 'Cardiac phase number', ''),
                  '0019xxd8': ('SS', '1', 'Variable echoflag', ''),
                  '0019xxd9': ('DS',
                               '1',
                               'Concatenated SAT {# DTI Diffusion Dir., release 9.0 & below}',
                               ''),
                  '0019xxda': ('SS', '1', 'Reference channel used', ''),
                  '0019xxdb': ('DS', '1', 'Back projector coefficient', ''),
                  '0019xxdc': ('SS',
                               '1',
                               'Primary speed correction used',
                               ''),
                  '0019xxdd': ('SS', '1', 'Overrange correction used', ''),
                  '0019xxde': ('DS', '1', 'Dynamic Z alpha value', ''),
                  '0019xxdf': ('DS',
                               '1',
                               'User data 23 {# DTI Diffusion Dir., release 9.0 & below}',
                               ''),
                  '0019xxe0': ('DS',
                               '1',
                               'User data 24 {# DTI Diffusion Dir., release 10.0 & above}',
                               ''),
                  '0019xxe1': ('DS', '1', 'Unknown', ''),
                  '0019xxe2': ('DS', '1', 'Velocity Encode Scale', ''),
                  '0019xxe3': ('LT', '1', 'Unknown', ''),
                  '0019xxe4': ('LT', '1', 'Unknown', ''),
                  '0019xxe5': ('IS', '1', 'Unknown', ''),
                  '0019xxe6': ('US', '1', 'Unknown', ''),
                  '0019xxe8': ('DS', '1', 'Unknown', ''),
                  '0019xxe9': ('DS', '1', 'Unknown', ''),
                  '0019xxeb': ('DS', '1', 'Unknown', ''),
                  '0019xxec': ('US', '1', 'Unknown', ''),
                  '0019xxf0': ('UN', '1', 'Unknown', ''),
                  '0019xxf1': ('LT', '1', 'Unknown', ''),
                  '0019xxf2': ('SS', '1', 'Fast phases', ''),
                  '0019xxf3': ('LT', '1', 'Unknown', ''),
                  '0019xxf4': ('LT', '1', 'Unknown', ''),
                  '0019xxf9': ('DS', '1', 'Transmit gain', '')},
 'GEMS_ACRQA_1.0 BLOCK1': {'0023xx00': ('LO',
                                        '1',
                                        'CR Exposure Menu Code',
                                        ''),
                           '0023xx10': ('LO',
                                        '1',
                                        'CR Exposure Menu String',
                                        ''),
                           '0023xx20': ('LO', '1', 'CR EDR Mode', ''),
                           '0023xx30': ('LO', '1', 'CR Latitude', ''),
                           '0023xx40': ('LO', '1', 'CR Group Number', ''),
                           '0023xx50': ('US',
                                        '1',
                                        'CR Image Serial Number',
                                        ''),
                           '0023xx60': ('LO', '1', 'CR Bar Code Number', ''),
                           '0023xx70': ('LO',
                                        '1',
                                        'CR Film Output Exposure',
                                        ''),
                           '0023xx80': ('LO', '1', 'CR Film Format', ''),
                           '0023xx90': ('LO', '1', 'CR S-Shift String', '')},
 'GEMS_ACRQA_1.0 BLOCK2': {'0023xx00': ('US', '1', 'CR S-Shift', ''),
                           '0023xx10': ('DS', '1', 'CR C-Shift', ''),
                           '0023xx20': ('DS', '1', 'CR GT', ''),
                           '0023xx30': ('DS', '1', 'CR GA', ''),
                           '0023xx40': ('DS', '1', 'CR GC', ''),
                           '0023xx50': ('DS', '1', 'CR GS', ''),
                           '0023xx60': ('DS', '1', 'CR RT', ''),
                           '0023xx70': ('DS', '1', 'CR RE', ''),
                           '0023xx80': ('US', '1', 'CR RN', ''),
                           '0023xx90': ('DS', '1', 'CR DRT', '')},
 'GEMS_ACRQA_1.0 BLOCK3': {'0023xx00': ('DS', '1', 'CR DRE', ''),
                           '0023xx10': ('US', '1', 'CR DRN', ''),
                           '0023xx20': ('DS', '1', 'CR ORE', ''),
                           '0023xx30': ('US', '1', 'CR ORN', ''),
                           '0023xx40': ('US', '1', 'CR ORD', ''),
                           '0023xx50': ('LO', '1', 'CR Cassette Size', ''),
                           '0023xx60': ('LO', '1', 'CR Machine ID', ''),
                           '0023xx70': ('LO', '1', 'CR Machine Type', ''),
                           '0023xx80': ('LO', '1', 'CR Technician Code', ''),
                           '0023xx90': ('LO', '1', 'CR ES Parameters', '')},
 'GEMS_ACRQA_2.0 BLOCK1': {'0023xx00': ('LO',
                                        '1',
                                        'CR Exposure Menu Code',
                                        ''),
                           '0023xx10': ('LO',
                                        '1',
                                        'CR Exposure Menu String',
                                        ''),
                           '0023xx20': ('LO', '1', 'CR EDR Mode', ''),
                           '0023xx30': ('LO', '1', 'CR Latitude', ''),
                           '0023xx40': ('LO', '1', 'CR Group Number', ''),
                           '0023xx50': ('US',
                                        '1',
                                        'CR Image Serial Number',
                                        ''),
                           '0023xx60': ('LO', '1', 'CR Bar Code Number', ''),
                           '0023xx70': ('LO',
                                        '1',
                                        'CR Film Output Exposure',
                                        ''),
                           '0023xx80': ('LO', '1', 'CR Film Format', ''),
                           '0023xx90': ('LO', '1', 'CR S Shift String', '')},
 'GEMS_ACRQA_2.0 BLOCK2': {'0023xx00': ('US', '1', 'CR S Shift', ''),
                           '0023xx10': ('LO', '1', 'CR C Shift', ''),
                           '0023xx20': ('LO', '1', 'CR GT', ''),
                           '0023xx30': ('DS', '1', 'CR GA', ''),
                           '0023xx40': ('DS', '1', 'CR GC', ''),
                           '0023xx50': ('DS', '1', 'CR GS', ''),
                           '0023xx60': ('LO', '1', 'CR RT', ''),
                           '0023xx70': ('DS', '1', 'CR RE', ''),
                           '0023xx80': ('US', '1', 'CR RN', ''),
                           '0023xx90': ('DS', '1', 'CR DRT', '')},
 'GEMS_ACRQA_2.0 BLOCK3': {'0023xx00': ('DS', '1', 'CR DRE', ''),
                           '0023xx10': ('US', '1', 'CR DRN', ''),
                           '0023xx20': ('DS', '1', 'CR ORE', ''),
                           '0023xx30': ('US', '1', 'CR ORN', ''),
                           '0023xx40': ('US', '1', 'CR ORD', ''),
                           '0023xx50': ('LO', '1', 'CR Cassette Size', ''),
                           '0023xx60': ('LO', '1', 'CR Machine ID', ''),
                           '0023xx70': ('LO', '1', 'CR Machine Type', ''),
                           '0023xx80': ('LO', '1', 'CR Technician Code', ''),
                           '0023xx90': ('LO',
                                        '1',
                                        'CR Energy Subtraction Parameters',
                                        ''),
                           '0023xxf0': ('LO',
                                        '1',
                                        'CR Distribution Code',
                                        ''),
                           '0023xxff': ('US', '1', 'CR Shutters Applied', '')},
 'GEMS_ADWSoft_3D1': {'0047xx01': ('SQ',
                                   '1',
                                   'Reconstruction Parameters Sequence',
                                   ''),
                      '0047xx49': ('UL', '3-n', 'Volume Color', ''),
                      '0047xx50': ('UL', '1', 'Volume Voxel Count', ''),
                      '0047xx51': ('UL', '1-n', 'Volume Segment Count', ''),
                      '0047xx53': ('US', '1', 'Volume Slice Size', ''),
                      '0047xx54': ('US', '1', 'Volume Slice Count', ''),
                      '0047xx55': ('SL', '1', 'Volume Threshold Value', ''),
                      '0047xx57': ('DS', '1', 'Volume Voxel Ratio', ''),
                      '0047xx58': ('DS', '1', 'Volume Voxel Size', ''),
                      '0047xx59': ('US', '1', 'Volume Z Position Size', ''),
                      '0047xx60': ('DS', '9', 'Volume Base Line', ''),
                      '0047xx61': ('DS', '3', 'Volume Center Point', ''),
                      '0047xx63': ('SL', '1', 'Volume Skew Base', ''),
                      '0047xx64': ('DS',
                                   '9',
                                   'Volume Registration Transform Rotation Matrix',
                                   ''),
                      '0047xx65': ('DS',
                                   '3',
                                   'Volume Registration Transform Translation Vector',
                                   ''),
                      '0047xx66': ('DS', '1', 'Volume Tilt', ''),
                      '0047xx70': ('DS', '1-n', 'KPV List', ''),
                      '0047xx71': ('IS',
                                   '1-n',
                                   'X-Ray Tube Current List',
                                   ''),
                      '0047xx72': ('IS', '1-n', 'Exposure List', ''),
                      '0047xx80': ('LO',
                                   '1',
                                   'Acquisition DLX Identifier',
                                   ''),
                      '0047xx81': ('IS',
                                   '1',
                                   'Acquisition DLX 2D Series Count',
                                   ''),
                      '0047xx85': ('SQ',
                                   '1',
                                   'Acquisition DLX 2D Series Sequence',
                                   ''),
                      '0047xx89': ('DS',
                                   '1-n',
                                   'Contrast Agent Volume List',
                                   ''),
                      '0047xx8a': ('US', '1', 'Number Of Injections', ''),
                      '0047xx8b': ('US', '1', 'Frame Count', ''),
                      '0047xx91': ('LO',
                                   '1',
                                   'XA 3D Reconstruction Algorithm Name',
                                   ''),
                      '0047xx92': ('CS',
                                   '1',
                                   'XA 3D Reconstruction Algorithm Version',
                                   ''),
                      '0047xx93': ('DA', '1', 'DLX Calibration Date', ''),
                      '0047xx94': ('TM', '1', 'DLX Calibration Time', ''),
                      '0047xx95': ('CS', '1', 'DLX Calibration Status', ''),
                      '0047xx96': ('IS', '1-n', 'Used Frames', ''),
                      '0047xx98': ('US', '1', 'Transform Count', ''),
                      '0047xx99': ('SQ', '1', 'Transform Sequence', ''),
                      '0047xx9a': ('DS',
                                   '9',
                                   'Transform Rotation Matrix',
                                   ''),
                      '0047xx9b': ('DS',
                                   '3',
                                   'Transform Translation Vector',
                                   ''),
                      '0047xx9c': ('LO', '1', 'Transform Label', ''),
                      '0047xxb0': ('SQ', '1', 'Wireframe List', ''),
                      '0047xxb1': ('US', '1', 'Wireframe Count', ''),
                      '0047xxb2': ('US', '1', 'Location System', ''),
                      '0047xxb5': ('LO', '1', 'Wireframe Name', ''),
                      '0047xxb6': ('LO', '1', 'Wireframe Group Name', ''),
                      '0047xxb7': ('LO', '1', 'Wireframe Color', ''),
                      '0047xxb8': ('SL', '1', 'Wireframe Attributes', ''),
                      '0047xxb9': ('SL', '1', 'Wireframe Point Count', ''),
                      '0047xxba': ('SL', '1', 'Wireframe Timestamp', ''),
                      '0047xxbb': ('SQ', '1', 'Wireframe Point List', ''),
                      '0047xxbc': ('DS',
                                   '3',
                                   'Wireframe Points Coordinates',
                                   ''),
                      '0047xxc0': ('DS',
                                   '3',
                                   'Volume Upper Left High Corner RAS',
                                   ''),
                      '0047xxc1': ('DS',
                                   '9',
                                   'Volume Slice To RAS Rotation Matrix',
                                   ''),
                      '0047xxc2': ('DS',
                                   '1',
                                   'Volume Upper Left High Corner TLOC',
                                   ''),
                      '0047xxd1': ('OB', '1', 'Volume Segment List', ''),
                      '0047xxd2': ('OB', '1', 'Volume Gradient List', ''),
                      '0047xxd3': ('OB', '1', 'Volume Density List', ''),
                      '0047xxd4': ('OB', '1', 'Volume Z Position List', ''),
                      '0047xxd5': ('OB',
                                   '1',
                                   'Volume Original Index List',
                                   ''),
                      '0047xxf4': ('LO', '1-n', 'Volume Name(s)', ''),
                      '0047xxf5': ('DS', '1-n', 'Min original density', ''),
                      '0047xxf6': ('DS', '1-n', 'Max original density', ''),
                      '0047xxf7': ('DS', '1-n', 'Min Converted Density', ''),
                      '0047xxf8': ('DS', '1-n', 'Max Converted Density', ''),
                      '0047xxf9': ('LO', '1', 'Protocol Film Name', ''),
                      '0047xxfa': ('US', '1', 'Protocol Resolution', ''),
                      '0047xxfb': ('US', '1', 'Phase Number (percent)', ''),
                      '0047xxfc': ('OB',
                                   '1',
                                   'Volume midscan times list',
                                   ''),
                      '0047xxfd': ('OB',
                                   '1',
                                   'Volume Registered Phases List',
                                   ''),
                      '0047xxfe': ('LO', '1', 'Protocol Name', ''),
                      '0047xxff': ('LO', '1', 'Protocol Title', '')},
 'GEMS_ADWSoft_3D2': {'0057xx01': ('OB',
                                   '1',
                                   'Cardiac Reconstruction Algorithm List',
                                   ''),
                      '0057xx02': ('OB',
                                   '1',
                                   'Average Heart Rate for Image List',
                                   ''),
                      '0057xx03': ('OB', '1', 'Temporal Resolution List', ''),
                      '0057xx04': ('LT', '1', 'Layout View Preset', '')},
 'GEMS_ADWSoft_DPO': {'0039xx80': ('IS', '1', 'Private Entity Number', ''),
                      '0039xx85': ('DA', '1', 'Private Entity Date', ''),
                      '0039xx90': ('TM', '1', 'Private Entity Time', ''),
                      '0039xx95': ('LO',
                                   '1',
                                   'Private Entity Launch Command',
                                   ''),
                      '0039xxaa': ('CS', '1', 'Private Entity Type', '')},
 'GEMS_ADWSoft_DPO1': {'0039xx80': ('IS', '1', 'Private Entity Number', ''),
                       '0039xx85': ('DA', '1', 'Private Entity Date', ''),
                       '0039xx90': ('TM', '1', 'Private Entity Time', ''),
                       '0039xx95': ('LO',
                                    '1',
                                    'Private Entity Launch Command',
                                    ''),
                       '0039xxaa': ('CS', '1', 'Private Entity Type', '')},
 'GEMS_AWSOFT_CD1': {'0039xx65': ('UI', '1', 'Reference to Study UID', ''),
                     '0039xx70': ('UI', '1', 'Reference to Series UID', ''),
                     '0039xx75': ('IS',
                                  '1',
                                  'Reference to Original Instance',
                                  ''),
                     '0039xx80': ('IS', '1', 'DPO Number', ''),
                     '0039xx85': ('DA', '1', 'DPO Date', ''),
                     '0039xx90': ('TM', '1', 'DPO Time', ''),
                     '0039xx95': ('LO', '1', 'DPO Invocation String', ''),
                     '0039xxaa': ('CS', '1', 'DPO type', ''),
                     '0039xxff': ('OB', '1', 'DPO data', '')},
 'GEMS_AWSoft_SB1': {'0039xx50': ('UI', '1', 'Reference to Study UID', ''),
                     '0039xx51': ('UI', '1', 'Reference to Series UID', ''),
                     '0039xx52': ('IS',
                                  '1',
                                  'Reference to Original Instance Number',
                                  ''),
                     '0039xx95': ('LO',
                                  '1',
                                  'Private Entity Launch Command',
                                  '')},
 'GEMS_CTHD_01': {'0033xx02': ('UN', '1', 'Unknown', '')},
 'GEMS_CT_CARDIAC_001': {'0049xx01': ('SQ', '1', 'CT Cardiac Sequence', ''),
                         '0049xx02': ('CS', '1', 'HeartRateAtConfirm', ''),
                         '0049xx03': ('FL',
                                      '1',
                                      'AvgHeartRatePriorToConfirm',
                                      ''),
                         '0049xx04': ('CS',
                                      '1',
                                      'MinHeartRatePriorToConfirm',
                                      ''),
                         '0049xx05': ('CS',
                                      '1',
                                      'MaxHeartRatePriorToConfirm',
                                      ''),
                         '0049xx06': ('FL',
                                      '1',
                                      'StdDevHeartRatePriorToConfirm',
                                      ''),
                         '0049xx07': ('US',
                                      '1',
                                      'NumHeartRateSamplesPriorToConfirm',
                                      ''),
                         '0049xx08': ('CS',
                                      '1',
                                      'AutoHeartRateDetectPredict',
                                      ''),
                         '0049xx09': ('CS',
                                      '1',
                                      'SystemOptimizedHeartRate',
                                      ''),
                         '0049xx0a': ('ST', '1', 'EkgMonitorType', ''),
                         '0049xx0b': ('CS', '1', 'NumReconSectors', ''),
                         '0049xx0c': ('FL', '256', 'RpeakTimeStamps', '')},
 'GEMS_CT_HINO_01': {'004bxx01': ('DS', '1-n', 'Beam Thickess', ''),
                     '004bxx02': ('DS', '1-n', 'R Time', ''),
                     '004bxx03': ('IS', '1', 'HBC Number', '')},
 'GEMS_CT_VES_01': {'0051xx01': ('SQ', '1', 'CTVESSequence', '')},
 'GEMS_DLX_DOSE_01': {'0027xx01': ('SQ',
                                   '1',
                                   'Private Radiation Dose Sequence',
                                   ''),
                      '0027xx02': ('IS', '1', 'Run Number', ''),
                      '0027xx03': ('TM', '1', 'Run Time', ''),
                      '0027xx04': ('IS', '1', 'Number of Frames', ''),
                      '0027xx05': ('DS', '1', 'Frames per Second', ''),
                      '0027xx06': ('CS', '1', 'Plane', ''),
                      '0027xx07': ('DS', '1', 'KV', ''),
                      '0027xx08': ('DS', '1', 'MA', ''),
                      '0027xx09': ('DS', '1', 'Mas', ''),
                      '0027xx10': ('DS', '1', 'Ms', ''),
                      '0027xx11': ('DS', '1', 'Angulation', ''),
                      '0027xx12': ('DS', '1', 'Rotation', ''),
                      '0027xx13': ('DS', '1', 'Focal Distance', ''),
                      '0027xx14': ('DS', '1', 'Image Intensifier Mode', '')},
 'GEMS_DL_FRAME_01': {'0025xx02': ('IS', '1', 'Frame Id', ''),
                      '0025xx03': ('DS',
                                   '1',
                                   'Distance Source To Detector',
                                   ''),
                      '0025xx04': ('DS',
                                   '1',
                                   'Distance Source To Patient',
                                   ''),
                      '0025xx05': ('DS', '1', 'Distance Source To Skin', ''),
                      '0025xx06': ('DS', '1', 'Positioner Primary Angle', ''),
                      '0025xx07': ('DS',
                                   '1',
                                   'Positioner Secondary Angle',
                                   ''),
                      '0025xx08': ('IS', '1', 'Beam Orientation', ''),
                      '0025xx09': ('DS', '1', 'Larm Angle', ''),
                      '0025xx0a': ('SQ', '1', 'Frame Sequence', ''),
                      '0025xx0b': ('DS', '1', 'Target Cnr', ''),
                      '0025xx10': ('DS', '1', 'Pivot Angle', ''),
                      '0025xx1a': ('DS', '1', 'Arc Angle', ''),
                      '0025xx1b': ('DS', '1', 'Table Vertical Position', ''),
                      '0025xx1c': ('DS',
                                   '1',
                                   'Table Longitudinal Position',
                                   ''),
                      '0025xx1d': ('DS', '1', 'Table Lateral Position', ''),
                      '0025xx1e': ('IS', '1', 'Beam Cover Area', ''),
                      '0025xx1f': ('DS', '1', 'Kvp Actual', ''),
                      '0025xx20': ('DS', '1', 'Mas Actual', ''),
                      '0025xx21': ('DS', '1', 'Pw Actual', ''),
                      '0025xx22': ('DS', '1', 'Kvp Commanded', ''),
                      '0025xx23': ('DS', '1', 'Mas Commanded', ''),
                      '0025xx24': ('DS', '1', 'Pw Commanded', ''),
                      '0025xx25': ('CS', '1', 'Grid', ''),
                      '0025xx26': ('DS', '1', 'Sensor Feedback', ''),
                      '0025xx27': ('DS', '1', 'Target Entrance Dose', ''),
                      '0025xx28': ('DS', '1', 'Cnr Commanded', ''),
                      '0025xx29': ('DS', '1', 'Contrast Commanded', ''),
                      '0025xx2a': ('DS', '1', 'Ept Actual', ''),
                      '0025xx2b': ('IS', '1', 'Spectral Filter Znb', ''),
                      '0025xx2c': ('DS', '1', 'Spectral Filter Weight', ''),
                      '0025xx2d': ('DS', '1', 'Spectral Filter Density', ''),
                      '0025xx2e': ('IS',
                                   '1',
                                   'Spectral Filter Thickness',
                                   ''),
                      '0025xx2f': ('IS', '1', 'Spectral Filter Status', ''),
                      '0025xx30': ('IS', '1', 'Fov Dimension', ''),
                      '0025xx33': ('IS', '1', 'Fov Origin', ''),
                      '0025xx34': ('IS',
                                   '1',
                                   'Collimator Left Vertical Edge',
                                   ''),
                      '0025xx35': ('IS',
                                   '1',
                                   'Collimator Right Vertical Edge',
                                   ''),
                      '0025xx36': ('IS',
                                   '1',
                                   'Collimator Up Horizontal Edge',
                                   ''),
                      '0025xx37': ('IS',
                                   '1',
                                   'Collimator Low Horizontal Edge',
                                   ''),
                      '0025xx38': ('IS',
                                   '1',
                                   'Vertices Polygonal Collimator',
                                   ''),
                      '0025xx39': ('IS', '1', 'Contour Filter Distance', ''),
                      '0025xx3a': ('UL', '1', 'Contour Filter Angle', ''),
                      '0025xx3b': ('CS', '1', 'Table Rotation Status', ''),
                      '0025xx3c': ('CS', '1', 'Internal Label Frame', '')},
 'GEMS_DL_IMG_01': {'0019xx0b': ('DS', '1', 'Fov Dimension Double', ''),
                    '0019xx0c': ('FL', '2-2n', 'LV Diastolic contour', ''),
                    '0019xx0d': ('FL', '2-2n', 'LV Systolic contour', ''),
                    '0019xx2b': ('FL', '1', 'Distance to table top', ''),
                    '0019xx30': ('LO', '1', 'Image File Name', ''),
                    '0019xx31': ('IS',
                                 '1',
                                 'Default Spatial Filter Family',
                                 ''),
                    '0019xx32': ('IS',
                                 '1',
                                 'Default Spatial Filter Strength',
                                 ''),
                    '0019xx33': ('DS', '1', 'Min Saturation Dose', ''),
                    '0019xx34': ('DS', '1', 'Detector Gain', ''),
                    '0019xx35': ('DS', '1', 'Patient Dose Limit', ''),
                    '0019xx36': ('DS', '1', 'Preproc Image Rate Max', ''),
                    '0019xx37': ('CS', '1', 'Sensor Roi Shape', ''),
                    '0019xx38': ('DS', '1', 'Sensor Roi x Position', ''),
                    '0019xx39': ('DS', '1', 'Sensor Roi y Position', ''),
                    '0019xx3a': ('DS', '1', 'Sensor Roi x Size', ''),
                    '0019xx3b': ('DS', '1', 'Sensor Roi y Size', ''),
                    '0019xx3d': ('DS', '1', 'Noise Sensitivity', ''),
                    '0019xx3e': ('DS', '1', 'Sharp Sensitivity', ''),
                    '0019xx3f': ('DS', '1', 'Contrast Sensitivity', ''),
                    '0019xx40': ('DS', '1', 'Lag Sensitivity', ''),
                    '0019xx41': ('CS', '1', 'Tube', ''),
                    '0019xx42': ('US', '1', 'Detector Size Rows', ''),
                    '0019xx43': ('US', '1', 'Detector Size Columns', ''),
                    '0019xx44': ('DS', '1', 'Min Object Size', ''),
                    '0019xx45': ('DS', '1', 'Max Object Size', ''),
                    '0019xx46': ('DS', '1', 'Max Object Speed', ''),
                    '0019xx47': ('CS', '1', 'Object Back Motion', ''),
                    '0019xx48': ('UL', '1', 'Exposure Trajectory Family', ''),
                    '0019xx49': ('DS', '1', 'Window Time Duration', ''),
                    '0019xx4a': ('CS',
                                 '1',
                                 'Positioner Angle Display Mode',
                                 ''),
                    '0019xx4b': ('IS', '1', 'Detector Origin', ''),
                    '0019xx4c': ('CS', '1', 'Unknown', ''),
                    '0019xx4e': ('DS',
                                 '1',
                                 'Default Brightness Contrast',
                                 ''),
                    '0019xx4f': ('DS', '1', 'User Brightness Contrast', ''),
                    '0019xx50': ('IS', '1', 'Source Series Number', ''),
                    '0019xx51': ('IS', '1', 'Source Image Number', ''),
                    '0019xx52': ('IS', '1', 'Source Frame Number', ''),
                    '0019xx53': ('UI', '1', 'Source Series Item Id', ''),
                    '0019xx54': ('UI', '1', 'Source Image Item Id', ''),
                    '0019xx55': ('UI', '1', 'Source Frame Item Id', ''),
                    '0019xx80': ('DS', '1', 'Image Dose', ''),
                    '0019xx81': ('US', '1', 'Calibration Frame', ''),
                    '0019xx82': ('CS', '1', 'Calibration Object', ''),
                    '0019xx83': ('DS', '1', 'Calibration Object Size mm', ''),
                    '0019xx84': ('FL', '1', 'Calibration Factor', ''),
                    '0019xx85': ('DA', '1', 'Calibration Date', ''),
                    '0019xx86': ('TM', '1', 'Calibration Time', ''),
                    '0019xx87': ('US', '1', 'Calibration Accuracy', ''),
                    '0019xx88': ('CS', '1', 'Calibration Extended', ''),
                    '0019xx89': ('US', '1', 'Calibration Image Original', ''),
                    '0019xx8a': ('US', '1', 'Calibration Frame Original', ''),
                    '0019xx8b': ('US',
                                 '1',
                                 'Calibration Number Of Points Uif',
                                 ''),
                    '0019xx8c': ('US', '1', 'Calibration Points Row', ''),
                    '0019xx8d': ('US', '1', 'Calibration Points Column', ''),
                    '0019xx8e': ('FL',
                                 '1',
                                 'Calibration Magnification Ratio',
                                 ''),
                    '0019xx8f': ('LO', '1', 'Calibration Sw Version', ''),
                    '0019xx90': ('LO',
                                 '1',
                                 'Extend Calibration Sw Version',
                                 ''),
                    '0019xx91': ('IS', '1', 'Calibration Return Code', ''),
                    '0019xx92': ('DS', '1', 'Detector Rotation Angle', ''),
                    '0019xx93': ('CS', '1', 'Spatial Change', ''),
                    '0019xx94': ('CS', '1', 'Inconsistent Flag', ''),
                    '0019xx95': ('CS', '1', 'Image Sweep', ''),
                    '0019xx96': ('CS', '1', 'Internal Label Image', ''),
                    '0019xx97': ('DS', '1', 'Angle 1 Increment', ''),
                    '0019xx98': ('DS', '1', 'Angle 2 Increment', ''),
                    '0019xx99': ('DS', '1', 'Angle 3 Increment', ''),
                    '0019xx9a': ('DS', '1', 'Sensor Feedback', ''),
                    '0019xx9b': ('CS', '1', 'Grid', ''),
                    '0019xx9c': ('FL', '1', 'Default Mask Pixel Shift', ''),
                    '0019xx9d': ('CS', '1', 'Applicable Review Mode', ''),
                    '0019xx9e': ('DS', '1', 'Log Lut Control Points', ''),
                    '0019xx9f': ('DS', '1', 'Exp Lut Control Points', ''),
                    '0019xxa0': ('DS', '1', 'ABD Value', ''),
                    '0019xxa1': ('DS', '1', 'Sub Window Center', ''),
                    '0019xxa2': ('DS', '1', 'Sub Window Width', ''),
                    '0019xxa3': ('DS', '1', 'Image Rotation', ''),
                    '0019xxa4': ('CS', '1', 'Auto Injection Enabled', ''),
                    '0019xxa5': ('CS', '1', 'Injection Phase', ''),
                    '0019xxa6': ('DS', '1', 'Injection Delay', ''),
                    '0019xxa7': ('IS',
                                 '1',
                                 'Reference Injection Frame Number',
                                 ''),
                    '0019xxa8': ('DS', '1', 'Injection Duration', ''),
                    '0019xxa9': ('DS', '1', 'EPT', ''),
                    '0019xxaa': ('CS', '1', 'Can Downscan 512', ''),
                    '0019xxab': ('IS',
                                 '1',
                                 'Current Spatial Filter Strength',
                                 ''),
                    '0019xxac': ('DS', '1', 'Brightness Sensitivity', ''),
                    '0019xxad': ('DS',
                                 '1',
                                 'Exp Lut NOSUB Control Points',
                                 ''),
                    '0019xxae': ('LO', '1-n', 'SUB operator LUTs names', ''),
                    '0019xxaf': ('DS', '1-n', 'kVp actual vector', ''),
                    '0019xxb0': ('DS', '1-n', 'mAs actual vector', ''),
                    '0019xxb1': ('LO',
                                 '1',
                                 'Acquisition Mode Description',
                                 ''),
                    '0019xxb2': ('LO',
                                 '1',
                                 'Acquisition Mode Display Label',
                                 ''),
                    '0019xxb3': ('LO',
                                 '1',
                                 'Acquisition Protocol User Name',
                                 ''),
                    '0019xxb8': ('FL',
                                 '1',
                                 'Recommended display frame rate float',
                                 ''),
                    '0019xxb9': ('FL', '1-n', 'ABD Vector', ''),
                    '0019xxba': ('CS', '1', 'Acquisition region', ''),
                    '0019xxbb': ('CS', '1', 'Acquisition SUB mode', ''),
                    '0019xxbc': ('FL', '1', 'Unknown', ''),
                    '0019xxbd': ('CS',
                                 '1-n',
                                 'Table rotation status vector',
                                 ''),
                    '0019xxbe': ('FL',
                                 '1-n',
                                 'Source to image distance per frame vector',
                                 ''),
                    '0019xxc2': ('DS', '1-n', 'pw actual vector', ''),
                    '0019xxc4': ('IS', '1', 'Spectral filter thickness', ''),
                    '0019xxc5': ('FL',
                                 '1',
                                 'Preselected pivot rotation speed',
                                 ''),
                    '0019xxc7': ('CS', '1', 'Patient position per image', ''),
                    '0019xxc8': ('CS', '1', '3D structure of interest', ''),
                    '0019xxc9': ('CS',
                                 '1',
                                 '3D calibration out of date flag',
                                 ''),
                    '0019xxca': ('IS',
                                 '1',
                                 '3Dspin expected number of frames',
                                 ''),
                    '0019xxd4': ('FL', '1', 'Detection gain value', ''),
                    '0019xxd5': ('FL', '1', 'mR mAs calibration value', ''),
                    '0019xxdc': ('LO', '1', 'DRM LUT file name', ''),
                    '0019xxdd': ('DS', '1-n', 'DRM Strength', ''),
                    '0019xxde': ('CS', '1', 'Acquisition Plane', ''),
                    '0019xxdf': ('FL',
                                 '1-n',
                                 'LP off longitudinal position Z',
                                 ''),
                    '0019xxe0': ('FL', '1', 'DAP of currect record', ''),
                    '0019xxe1': ('FL', '1', 'Pivot Lateral Angle', ''),
                    '0019xxe2': ('FL', '1', 'Carm Lateral Angle', ''),
                    '0019xxe3': ('FL',
                                 '1-n',
                                 'Pivot Lateral Angle increment',
                                 ''),
                    '0019xxe4': ('FL',
                                 '1-n',
                                 'Carm Lateral Angle increment',
                                 ''),
                    '0019xxe7': ('FL',
                                 '1',
                                 'LP off long pos Z first frame',
                                 ''),
                    '0019xxe8': ('FL',
                                 '1-n',
                                 'LP off long pos Z increment',
                                 ''),
                    '0019xxe9': ('FL',
                                 '1-n',
                                 'Source to detector distance per frame vector',
                                 ''),
                    '0019xxea': ('FL', '1', 'Unknown', ''),
                    '0019xxeb': ('FL', '1', 'Unknown', ''),
                    '0019xxec': ('FL', '1', 'Unknown', ''),
                    '0019xxed': ('FL', '1', 'Unknown', '')},
 'GEMS_DL_PATNT_01': {'0011xx80': ('UI', '1', 'Patient Instance Uid', ''),
                      '0011xx81': ('IS', '1', 'Last Study Number', ''),
                      '0011xx82': ('CS', '1', 'Patient Repaired', ''),
                      '0011xx83': ('CS', '1', 'Lock Demographics', '')},
 'GEMS_DL_SERIES': {'0015xx87': ('IS', '1', 'Number of images', ''),
                    '0019xx0b': ('DS', '1-2', 'fov dimension double', ''),
                    '0019xx31': ('IS',
                                 '1',
                                 'default spatial filter family',
                                 ''),
                    '0019xx32': ('IS',
                                 '1',
                                 'default spatial filter strength',
                                 ''),
                    '0019xx4b': ('IS', '2', 'Detector origin', ''),
                    '0019xx4e': ('DS', '2', 'def_bright_contr', ''),
                    '0019xx4f': ('DS', '2', 'user_bright_contr', ''),
                    '0019xx81': ('US', '1', 'Calibration frame', ''),
                    '0019xx82': ('CS', '1', 'Calibration object', ''),
                    '0019xx83': ('DS', '1', 'Calibration object size mm', ''),
                    '0019xx84': ('FL', '1', 'Calibration factor', ''),
                    '0019xx85': ('DA', '1', 'Calibration date', ''),
                    '0019xx86': ('TM', '1', 'Calibration time', ''),
                    '0019xx87': ('US', '1', 'Calibration accuracy', ''),
                    '0019xx88': ('CS', '1', 'Calibration extended', ''),
                    '0019xx89': ('US', '1', 'Calibration image original', ''),
                    '0019xx8a': ('US', '1', 'Calibration frame original', ''),
                    '0019xx8b': ('US', '1', 'Calibration nb points uif', ''),
                    '0019xx8c': ('US', '1-n', 'Calibration points row', ''),
                    '0019xx8d': ('US',
                                 '1-n',
                                 'Calibration points column',
                                 ''),
                    '0019xx8e': ('FL', '1', 'Calibration mag ratio', ''),
                    '0019xx8f': ('LO', '1', 'Calibration sw version', ''),
                    '0019xx90': ('LO', '1', 'Extend calib sw version', ''),
                    '0019xx91': ('IS', '1', 'Calibration return code', ''),
                    '0019xx92': ('DS', '1', 'detector_rot_angle', ''),
                    '0019xx93': ('CS', '1', 'Spatial change', ''),
                    '0019xx95': ('CS', '2', 'Image sweep', ''),
                    '0019xx97': ('DS', '1-n', 'Angle 1 increment', ''),
                    '0019xx98': ('DS', '1-n', 'Angle 2 increment', ''),
                    '0019xx99': ('DS', '1-n', 'Angle 3 increment', ''),
                    '0019xx9a': ('DS', '1-n', 'sensor feedback', ''),
                    '0019xx9d': ('CS', '1', 'applicable review mode', ''),
                    '0019xx9e': ('DS', '1-n', 'log LUT control points', ''),
                    '0019xx9f': ('DS',
                                 '1-n',
                                 'exp LUT SUB control points',
                                 ''),
                    '0019xxa0': ('DS', '1', 'ABD value', ''),
                    '0019xxa1': ('DS', '1', 'Sub window center', ''),
                    '0019xxa2': ('DS', '1', 'Sub window width', ''),
                    '0019xxa4': ('CS', '1', 'Auto injection enabled', ''),
                    '0019xxa5': ('CS', '1', 'injection phase', ''),
                    '0019xxa6': ('DS', '1', 'injection delay', ''),
                    '0019xxa7': ('IS',
                                 '1',
                                 'reference injection frame number',
                                 ''),
                    '0019xxa9': ('DS', '1-n', 'EPT', ''),
                    '0019xxaa': ('CS', '1', 'can downscan 512', ''),
                    '0019xxab': ('IS',
                                 '1',
                                 'current spatial filter strength',
                                 ''),
                    '0019xxad': ('DS',
                                 '1-n',
                                 'exp LUT NOSUB control points',
                                 ''),
                    '0019xxae': ('LO', '1-n', 'SUB operator LUTs names', ''),
                    '0019xxc4': ('IS',
                                 '1',
                                 'Default spatial filter family',
                                 ''),
                    '0019xxc5': ('FL',
                                 '1',
                                 'Preselected pivot rotation speed',
                                 ''),
                    '0019xxc7': ('CS', '1', 'Patient position per image', ''),
                    '0019xxc8': ('CS', '1', '3D structure of interest', ''),
                    '0019xxc9': ('CS',
                                 '1',
                                 '3D calibration out of date flag',
                                 ''),
                    '0019xxca': ('IS',
                                 '1',
                                 '3Dspin expected number of frames',
                                 ''),
                    '0019xxd4': ('FL', '1', 'Detection gain value', ''),
                    '0019xxd5': ('FL', '1', 'mR mAs calibration value', ''),
                    '0019xxdc': ('LO', '1', 'DRM LUT file name', ''),
                    '0019xxdd': ('DS', '1-n', 'DRM Strength', '')},
 'GEMS_DL_SERIES_01': {'0015xx85': ('LO', '1', 'Series File Name', ''),
                       '0015xx87': ('IS', '1', 'Number Of Images', ''),
                       '0015xx8c': ('CS', '1', 'Sent Flag', ''),
                       '0015xx8d': ('US', '1', 'Item Locked', ''),
                       '0019xx4c': ('CS', '1', 'internal label', ''),
                       '0019xx4d': ('CS', '1', 'browser hide', '')},
 'GEMS_DL_STUDY_01': {'0015xx80': ('DS', '1', 'Study Dose', ''),
                      '0015xx81': ('DS', '1', 'Study Total Dap', ''),
                      '0015xx82': ('DS', '1', 'Study Fluoro Dap', ''),
                      '0015xx83': ('IS', '1', 'Study Fluoro Time', ''),
                      '0015xx84': ('DS', '1', 'Study Record Dap', ''),
                      '0015xx85': ('IS', '1', 'Study Record Time', ''),
                      '0015xx86': ('IS', '1', 'Last Xa Number', ''),
                      '0015xx88': ('PN', '1', 'Default Operator Name', ''),
                      '0015xx89': ('PN',
                                   '1',
                                   'Default Performing Physician Name',
                                   ''),
                      '0015xx8a': ('CS',
                                   '1',
                                   'Default Patient Orientation',
                                   ''),
                      '0015xx8b': ('IS', '1', 'Last Sc Number', ''),
                      '0015xx8e': ('UI',
                                   '1',
                                   'Common Series Instance Uid',
                                   ''),
                      '0015xx8f': ('IS', '1', 'Study Number', ''),
                      '0015xx92': ('FL', '1', 'Study dose Frontal', ''),
                      '0015xx93': ('FL', '1', 'Study total dap Frontal', ''),
                      '0015xx94': ('FL', '1', 'Study fluoro dap frontal', ''),
                      '0015xx95': ('IS',
                                   '1',
                                   'Study fluoro time frontal',
                                   ''),
                      '0015xx96': ('FL', '1', 'Study record dap frontal', ''),
                      '0015xx97': ('IS',
                                   '1',
                                   'Study record time frontal',
                                   ''),
                      '0015xx98': ('FL', '1', 'Study dose lateral', ''),
                      '0015xx99': ('FL', '1', 'Study total dap lateral', ''),
                      '0015xx9a': ('FL', '1', 'Study fluoro dap lateral', ''),
                      '0015xx9b': ('IS',
                                   '1',
                                   'Study fluoro time lateral',
                                   ''),
                      '0015xx9c': ('FL', '1', 'Study record dap leteral', ''),
                      '0015xx9d': ('IS',
                                   '1',
                                   'Study record time lateral',
                                   '')},
 'GEMS_DRS_1': {'0037xx10': ('LO', '1', 'Refering Department', ''),
                '0037xx20': ('US', '1', 'Screen Number', ''),
                '0037xx40': ('SH', '1', 'Left Orientation', ''),
                '0037xx42': ('SH', '1', 'Right Orientation', ''),
                '0037xx50': ('CS', '1', 'Inversion', ''),
                '0037xx60': ('US', '1', 'DSA', '')},
 'GEMS_FALCON_03': {'0045xx55': ('DS', '8', 'A_Coefficients', ''),
                    '0045xx62': ('IS', '1', 'User Window Center', ''),
                    '0045xx63': ('IS', '1', 'User Window Width', ''),
                    '0045xx65': ('IS',
                                 '1',
                                 'Requested Detector Entrance Dose',
                                 ''),
                    '0045xx67': ('DS',
                                 '3',
                                 'VOI LUT Assymmetry parameter beta',
                                 ''),
                    '0045xx69': ('IS', '1', 'Collimator rotation', ''),
                    '0045xx72': ('DS', '1', 'Collimator Width', ''),
                    '0045xx73': ('DS', '1', 'Collimator Height', '')},
 'GEMS_FUNCTOOL_01': {'0051xx01': ('LO',
                                   '1',
                                   'Functional Proc Group Name',
                                   ''),
                      '0051xx02': ('LO',
                                   '1',
                                   'Functional Processing Name',
                                   ''),
                      '0051xx03': ('SL', '1', 'Bias of Functional Image', ''),
                      '0051xx04': ('FL',
                                   '1',
                                   'Scale of Functional Image',
                                   ''),
                      '0051xx05': ('SL',
                                   '1',
                                   'Length of Parameters String',
                                   ''),
                      '0051xx06': ('LT',
                                   '1',
                                   'Store Parameters string, delimited by character ESC=0x1B (27)',
                                   ''),
                      '0051xx07': ('LO', '1', 'Functional Image Version', ''),
                      '0051xx08': ('SL', '1', 'Store Color Ramp', ''),
                      '0051xx09': ('SL',
                                   '1',
                                   'Store Width of Functional Image',
                                   ''),
                      '0051xx0a': ('SL',
                                   '1',
                                   'Store level of Functional Image',
                                   ''),
                      '0051xx0b': ('FL',
                                   '1',
                                   'Store B-Value with Functional Image',
                                   '')},
 'GEMS_GDXE_ATHENAV2_INTERNAL_USE': {'7fdfxx10': ('LT',
                                                  '1',
                                                  'PPS Stream',
                                                  ''),
                                     '7fdfxx11': ('LT',
                                                  '1',
                                                  'Pixel Data References (temporary)',
                                                  ''),
                                     '7fdfxx20': ('SS',
                                                  '1',
                                                  'Auto Push Tag',
                                                  ''),
                                     '7fdfxx25': ('CS',
                                                  '1',
                                                  'PPS Status',
                                                  '')},
 'GEMS_GDXE_FALCON_04': {'0011xx03': ('UI', '1', 'Processed Series UID', ''),
                         '0011xx04': ('CS', '1', 'Acquisition Type', ''),
                         '0011xx05': ('UI', '1', 'Acquisition UID', ''),
                         '0011xx06': ('DS', '1', 'Image Dose', ''),
                         '0011xx07': ('FL', '1', 'Study Dose', ''),
                         '0011xx08': ('FL', '1', 'Study DAP', ''),
                         '0011xx09': ('SL', '1', 'Non-Digital Exposures', ''),
                         '0011xx10': ('SL', '1', 'Total Exposures', ''),
                         '0011xx11': ('LT', '1', 'ROI', ''),
                         '0011xx12': ('LT', '1', 'Patient Size String', ''),
                         '0011xx13': ('UI', '1', 'SPS UID', ''),
                         '0011xx14': ('UI', '1', 'Unknown', ''),
                         '0011xx15': ('DS', '1', 'Detector ARC Gain', ''),
                         '0011xx16': ('LT', '1', 'Processing Debug Info', ''),
                         '0011xx17': ('CS', '1', 'Override mode', ''),
                         '0011xx19': ('DS', '1', 'Film Speed Selection', ''),
                         '0011xx27': ('UN', '1', 'Unknown', ''),
                         '0011xx28': ('UN', '1', 'Unknown', ''),
                         '0011xx29': ('UN', '1', 'Unknown', ''),
                         '0011xx30': ('UN', '1', 'Unknown', ''),
                         '0011xx31': ('IS',
                                      '8',
                                      'Detected Field of View',
                                      ''),
                         '0011xx32': ('IS',
                                      '8',
                                      'Adjusted Field of View',
                                      ''),
                         '0011xx33': ('DS',
                                      '1',
                                      'Detected Exposure Index',
                                      ''),
                         '0011xx34': ('DS',
                                      '1',
                                      'Compensated Detector Exposure',
                                      ''),
                         '0011xx35': ('DS',
                                      '1',
                                      'Uncompensated Detector Exposure',
                                      ''),
                         '0011xx36': ('DS',
                                      '1',
                                      'Median Anatomy Count Value',
                                      ''),
                         '0011xx37': ('DS',
                                      '2',
                                      'DEI lower and upper limit values',
                                      ''),
                         '0011xx38': ('SL',
                                      '6',
                                      'Shift Vector for Pasting',
                                      ''),
                         '0011xx39': ('CS',
                                      '1',
                                      'Image Number in Pasting',
                                      ''),
                         '0011xx40': ('SL', '1', 'Pasting Overlap', ''),
                         '0011xx41': ('IS',
                                      '24',
                                      'Sub-image Collimator Vertices',
                                      ''),
                         '0011xx42': ('LO', '1', 'View IP', ''),
                         '0011xx43': ('IS',
                                      '24',
                                      'Key-stone Co-ordinates',
                                      ''),
                         '0011xx44': ('CS', '1', 'Receptor Type', ''),
                         '0011xx46': ('LO', '1-n', 'Unknown', ''),
                         '0011xx47': ('DS', '1', 'Unknown', '')},
 'GEMS_GENIE_1': {'0009xx01': ('SH', '1', 'Unknown', ''),
                  '0009xx10': ('LO', '1', 'Study Name', ''),
                  '0009xx11': ('SL', '1', 'Study Flags', ''),
                  '0009xx12': ('SL', '1', 'Study Type', ''),
                  '0009xx1e': ('UI', '1', 'Dataset UID', ''),
                  '0009xx20': ('LO', '1', 'Series Object Name', ''),
                  '0009xx21': ('SL', '1', 'Series Flags', ''),
                  '0009xx22': ('SH', '1', 'User Orientation', ''),
                  '0009xx23': ('SL', '1', 'Initiation Type', ''),
                  '0009xx24': ('SL', '1', 'Initiation Delay', ''),
                  '0009xx25': ('SL', '1', 'Initiation Count Rate', ''),
                  '0009xx26': ('SL', '1', 'Number Energy Sets', ''),
                  '0009xx27': ('SL', '1', 'Number Detectors', ''),
                  '0009xx28': ('SL', '1', 'Number RR Windows', ''),
                  '0009xx29': ('SL', '1', 'Number MG Time Slots', ''),
                  '0009xx2a': ('SL', '1', 'Number View Sets', ''),
                  '0009xx2b': ('LO', '1', 'Trigger History UID', ''),
                  '0009xx2c': ('LO', '1', 'Series Comments', ''),
                  '0009xx2d': ('SL', '1', 'Track Beat Average', ''),
                  '0009xx2e': ('FD', '1', 'Distance Prescribed', ''),
                  '0009xx2f': ('SL', '1', 'Table Direction', ''),
                  '0009xx30': ('LO', '1', 'Unknown', ''),
                  '0009xx33': ('FD', '1', 'Rotational Continuous Speed', ''),
                  '0009xx34': ('SL', '1', 'Gantry Motion Type (retired)', ''),
                  '0009xx35': ('SL', '1', 'Gantry Locus Type', ''),
                  '0009xx37': ('SL', '1', 'Starting Heart Rate', ''),
                  '0009xx38': ('SL', '1', 'RR Window Width', ''),
                  '0009xx39': ('SL', '1', 'RR Window Offset', ''),
                  '0009xx3a': ('SL', '1', 'Percent Cycle Imaged', ''),
                  '0009xx40': ('PN', '1', 'Patient Object Name', ''),
                  '0009xx41': ('SL', '1', 'Patient Flags', ''),
                  '0009xx42': ('DA', '1', 'Patient Creation Date', ''),
                  '0009xx43': ('TM', '1', 'Patient Creation Time', ''),
                  '0009xx44': ('SL', '1', 'Num Views Acquired (retired)', ''),
                  '0009xx45': ('LT', '1', 'Unknown', ''),
                  '0011xx0a': ('SL', '1', 'Series Type', ''),
                  '0011xx0b': ('SL', '1', 'Effective Series Duration', ''),
                  '0011xx0c': ('SL', '1', 'Num Beats', ''),
                  '0011xx0d': ('LO', '1', 'Radio Nuclide Name', ''),
                  '0011xx10': ('LO', '1', 'Dataset Object Name', ''),
                  '0011xx11': ('IS', '1', 'Dataset Modified', ''),
                  '0011xx12': ('LO', '1-n', 'Dataset Name', ''),
                  '0011xx13': ('SL', '1', 'Dataset Type', ''),
                  '0011xx14': ('SH', '1', 'Completion Time', ''),
                  '0011xx15': ('SL', '1', 'Detector Number', ''),
                  '0011xx16': ('SL', '1', 'Energy Number', ''),
                  '0011xx17': ('SL', '1', 'RR Interval Window Number', ''),
                  '0011xx18': ('SL', '1', 'MG Bin Number', ''),
                  '0011xx19': ('FD', '1', 'Radius Of Rotation', ''),
                  '0011xx1a': ('SL', '1', 'Detector Count Zone', ''),
                  '0011xx1b': ('SL', '1', 'Num Energy Windows', ''),
                  '0011xx1c': ('SL', '4', 'Energy Offset', ''),
                  '0011xx1d': ('SL', '1', 'Energy Range', ''),
                  '0011xx1e': ('SL', '4', 'Energy Width (retired)', ''),
                  '0011xx1f': ('SL', '1', 'Image Orientation', ''),
                  '0011xx21': ('DS', '1', 'Acq Zoom (retired)', ''),
                  '0011xx22': ('DS', '1', 'Acq Pan (retired)', ''),
                  '0011xx23': ('SL', '1', 'Use FOV Mask', ''),
                  '0011xx24': ('SL', '1', 'FOV Mask Y Cutoff Distance', ''),
                  '0011xx25': ('SL', '1', 'FOV Mask Cutoff Angle', ''),
                  '0011xx26': ('SL', '1', 'Table Orientation', ''),
                  '0011xx27': ('SL', '2', 'ROI Top Left', ''),
                  '0011xx28': ('SL', '2', 'ROI Bottom Right', ''),
                  '0011xx29': ('SL', '1', 'Uniformity Mean', ''),
                  '0011xx2a': ('FD', '1', 'Phase Duration (retired)', ''),
                  '0011xx2c': ('FD', '1', 'View X Adjustment', ''),
                  '0011xx2d': ('FD', '1', 'View Y Adjustment', ''),
                  '0011xx2e': ('SL', '1', 'Pixel Overflow Flag', ''),
                  '0011xx2f': ('SL', '1', 'Overflow Level', ''),
                  '0011xx30': ('LO', '1', 'Picture Object Name', ''),
                  '0011xx31': ('LO', '1', 'Acquisition Parent UID', ''),
                  '0011xx32': ('LO', '1', 'Processing Parent UID', ''),
                  '0011xx33': ('LO', '1', 'Energy Correct Name', ''),
                  '0011xx34': ('LO', '1', 'Spatial Correct Name', ''),
                  '0011xx35': ('LO', '1', 'Tuning Calib Name', ''),
                  '0011xx36': ('LO', '1', 'Uniformity Correct Name', ''),
                  '0011xx37': ('LT',
                               '1',
                               'Acquisition Specific Correction Name',
                               ''),
                  '0011xx38': ('SL', '1', 'Byte Order', ''),
                  '0011xx39': ('SL', '1', 'Compression Type', ''),
                  '0011xx3a': ('SL', '1', 'Picture Format', ''),
                  '0011xx3b': ('FD', '1', 'Pixel Scale', ''),
                  '0011xx3c': ('FD', '1', 'Pixel Offset', ''),
                  '0011xx3d': ('SL', '4', 'Energy Peak (retired)', ''),
                  '0011xx3e': ('SL', '1', 'FOV Shape', ''),
                  '0011xx3f': ('SL', '1', 'Dataset Flags', ''),
                  '0011xx40': ('LO', '1', 'Viewing Object Name', ''),
                  '0011xx41': ('SL', '1', 'Orientation Angle', ''),
                  '0011xx42': ('FD', '1', 'Rotation Angle', ''),
                  '0011xx43': ('SL', '1', 'Window Inverse Flag', ''),
                  '0011xx44': ('FD', '1', 'Threshold Center', ''),
                  '0011xx45': ('FD', '1', 'Threshold Width', ''),
                  '0011xx46': ('SL', '1', 'Interpolation Type', ''),
                  '0011xx50': ('LO', '1', 'Where Object Name', ''),
                  '0011xx55': ('FD', '1', 'Period', ''),
                  '0011xx56': ('FD', '1', 'Elapsed Time', ''),
                  '0011xx57': ('FD', '2', 'FOV', ''),
                  '0011xx61': ('SL', '1', 'Image Size', ''),
                  '0011xx62': ('FD', '1', 'Linear FOV', ''),
                  '0011xx63': ('FD', '1', 'Spatial Offset', ''),
                  '0011xx64': ('FD', '1', 'Spatial Orientation', ''),
                  '0011xx65': ('LO', '1', 'Reference Dataset UID', ''),
                  '0011xx66': ('SH', '1', 'Starcam Reference Dataset', ''),
                  '0011xx67': ('SL', '1', 'Reference Frame Number', ''),
                  '0011xx68': ('SL', '1', 'Cursor Length', ''),
                  '0011xx69': ('SL', '1', 'Number of Cursors', ''),
                  '0011xx6a': ('SL', '1', 'Cursor Coordinates', ''),
                  '0011xx6b': ('SL', '1', 'Recon Options Flag', ''),
                  '0011xx6c': ('FD', '1', 'Motion Threshold', ''),
                  '0011xx6d': ('UI', '1', 'Motion Curve UID', ''),
                  '0011xx6e': ('SL', '1', 'Recon Type', ''),
                  '0011xx6f': ('SL', '1', 'Pre Filter Type', ''),
                  '0011xx71': ('SL', '1', 'Back Proj Filter Type', ''),
                  '0011xx72': ('SL', '1', 'Recon Arc', ''),
                  '0011xx73': ('FD', '1', 'Recon Pan AP Offset', ''),
                  '0011xx74': ('FD', '1', 'Recon Pan LR Offset', ''),
                  '0011xx75': ('FD', '1', 'Recon Area', ''),
                  '0011xx76': ('SL', '1', 'Start View', ''),
                  '0011xx77': ('SL', '1', 'Attenuation Type', ''),
                  '0011xx78': ('SL', '1', 'Dual Energy Processing', ''),
                  '0011xx79': ('SH', '1', 'Pre Filter Param', ''),
                  '0011xx7a': ('SH', '1', 'Pre Filter Param 2', ''),
                  '0011xx7b': ('SH', '1', 'Back Proj Filter Param', ''),
                  '0011xx7c': ('SH', '1', 'Back Proj Filter Param 2', ''),
                  '0011xx7d': ('SH', '1', 'Attenuation Coef', ''),
                  '0011xx7e': ('SL', '1', 'Ref Slice Width', ''),
                  '0011xx7f': ('FD', '1', 'Ref Trans Pixel Volume', ''),
                  '0011xx81': ('SH', '1', 'Attenuation Threshold', ''),
                  '0011xx82': ('FD', '1', 'Interpolation Distance', ''),
                  '0011xx83': ('FD', '1', 'Interpolation Center X', ''),
                  '0011xx84': ('FD', '1', 'Interpolation Center Y', ''),
                  '0011xx85': ('SL', '1', 'Quant Filter Flag', ''),
                  '0011xx86': ('SL', '1', 'Head Conversion', ''),
                  '0011xx87': ('SL', '1', 'Slice Width Pixels', ''),
                  '0011xx88': ('SL', '1', 'Rfmtr Trans Ref', ''),
                  '0011xx89': ('FD', '1', 'Rfmtr Trans Ref mm', ''),
                  '0011xx8a': ('SL', '1', 'Two Line Trans Ref', ''),
                  '0011xx8b': ('SL', '1', 'Three-D Zero', ''),
                  '0011xx8c': ('SL', '1', 'Three-D Zero Length', ''),
                  '0011xx8d': ('SL', '1', 'Three-D Zero In', ''),
                  '0013xx10': ('FD', '2', 'Digital FOV', ''),
                  '0013xx11': ('SL', '1', 'Source Translator', ''),
                  '0013xx12': ('UL', '1', 'RAL Flags', ''),
                  '0013xx13': ('SQ', '1', 'Xeleris Frame Sequence', ''),
                  '0013xx14': ('SL', '1', 'Original Image Num', ''),
                  '0013xx15': ('FD', '1', 'Fscalar', ''),
                  '0013xx16': ('SL', '1', 'AutoTrack Peak', ''),
                  '0013xx17': ('SL', '1', 'AutoTrack Width', ''),
                  '0013xx18': ('FD', '1', 'Transmission Scan Time', ''),
                  '0013xx19': ('FD', '1', 'Transmission Mask Width', ''),
                  '0013xx1a': ('FD', '1', 'Copper Attenuator Thickness', ''),
                  '0013xx1b': ('FD', '1', 'Det Ang Separation', ''),
                  '0013xx1c': ('SL', '1', 'Axial Acceptance Angle', ''),
                  '0013xx1d': ('SL', '1', 'Theta Acceptance Value', ''),
                  '0013xx1e': ('FD', '1-n', 'Tomo View Offset', ''),
                  '0013xx20': ('FD', '1', 'Accepted Beats Time', ''),
                  '0013xx21': ('FD', '2', 'Threshold', ''),
                  '0013xx22': ('FD', '2', 'Linear Depth', ''),
                  '0013xx23': ('LO', '1', 'Unif Date Time', ''),
                  '0013xx24': ('SL', '1', 'Series Accepted Beats', ''),
                  '0013xx25': ('SL', '1', 'Series Rejected Beats', ''),
                  '0013xx26': ('LT', '1', 'Study Comments', ''),
                  '0015xx10': ('SL', '1', 'Frame Termination Condition', ''),
                  '0015xx11': ('SL', '1', 'Frame Termination Value', ''),
                  '0015xx12': ('SL', '1', 'Num ECT Phases', ''),
                  '0015xx13': ('SL', '1', 'Num WB Scans', ''),
                  '0015xx14': ('SL', '1', 'ECT Phase Num', ''),
                  '0015xx15': ('SL', '1', 'WB Scan Num', ''),
                  '0015xx16': ('SL', '1', 'Comb Head Number', ''),
                  '0015xx17': ('UL', '1', 'Preceding Beat', ''),
                  '0019xx5f': ('SQ', '1', 'Unknown', ''),
                  '0033xx07': ('SQ', '1-n', 'Orig SOP Instance UID', ''),
                  '0033xx08': ('CS', '1', 'Xeleris Data Object Type', ''),
                  '0033xx10': ('SL', '1', 'Modified', ''),
                  '0033xx11': ('LO', '1', 'Name', ''),
                  '0033xx16': ('LO', '1', 'ProtocolDataUID', ''),
                  '0033xx17': ('SH', '1', 'Date', ''),
                  '0033xx18': ('SH', '1', 'Time', ''),
                  '0033xx19': ('UL', '1', 'ProtocoldataFlags', ''),
                  '0033xx1a': ('UL', '1', 'ProtocolName', ''),
                  '0033xx1b': ('LO', '1', 'RelevantDataUID', ''),
                  '0033xx1c': ('LO', '1', 'BulkData', ''),
                  '0033xx1d': ('SL', '1-n', 'IntData', ''),
                  '0033xx1e': ('FD', '1-n', 'DoubleData', ''),
                  '0033xx1f': ('OB', '1', 'StringData', ''),
                  '0033xx20': ('LT', '1-n', 'BulkDataFormat', ''),
                  '0033xx21': ('LT', '1-n', 'IntDataFormat', ''),
                  '0033xx22': ('LT', '1-n', 'DoubleDataFormat', ''),
                  '0033xx23': ('LT', '1-n', 'StringDataFormat', ''),
                  '0033xx24': ('LT', '1', 'Description', ''),
                  '0033xx30': ('UL', '1', 'Allocate trigger buffer', ''),
                  '0033xx33': ('UL', '1', 'Number of triggers', ''),
                  '0033xx34': ('UL', '1', 'Trigger size', ''),
                  '0033xx35': ('UL', '1', 'Trigger data size', ''),
                  '0033xx36': ('OB', '1-n', 'Trigger data', ''),
                  '0035xx01': ('FD', '1-n', 'Start Angle', ''),
                  '0055xx12': ('SQ',
                               '1',
                               'Xeleris Energy Window Information Sequence',
                               ''),
                  '0055xx13': ('SQ',
                               '1',
                               'Xeleris Energy Window Range Sequence',
                               ''),
                  '0055xx22': ('SQ',
                               '1',
                               'Xeleris Detector Information Sequence',
                               ''),
                  '0055xx52': ('SQ',
                               '1',
                               'Xeleris Rotation Information Sequence',
                               ''),
                  '0055xx62': ('SQ',
                               '1',
                               'Xeleris Gated Information Sequence',
                               ''),
                  '0055xx63': ('SQ',
                               '1',
                               'Xeleris Data Information Sequence',
                               ''),
                  '0055xx64': ('SQ', '1', 'SDODoubleData SQ', ''),
                  '0055xx65': ('SQ', '1', 'Unknown', ''),
                  '5001xx01': ('SL', '1', 'Modified', ''),
                  '5001xx02': ('LO', '1', 'Name', ''),
                  '5001xx03': ('SL', '1', 'Cid', ''),
                  '5001xx04': ('SL', '1', 'Srid', ''),
                  '5001xx05': ('LO', '1', 'SOPClassUID', ''),
                  '5001xx06': ('LO', '1', 'SOPInstanceUID', ''),
                  '5001xx07': ('SL', '1', 'CurveType', ''),
                  '5001xx08': ('SL', '1', 'GraphType', ''),
                  '5001xx09': ('LO', '1', 'Legend', ''),
                  '5001xx0a': ('LO', '1', 'XUnits', ''),
                  '5001xx0b': ('LO', '1', 'YUnits', ''),
                  '5001xx0c': ('SL', '1', 'Edit', ''),
                  '5001xx0d': ('SL', '1', 'Suspend', ''),
                  '5001xx0e': ('SL', '1', 'StyleLine', ''),
                  '5001xx0f': ('SL', '1', 'StyleFill', ''),
                  '5001xx10': ('LO', '1', 'StyleColour', ''),
                  '5001xx11': ('SL', '1', 'StyleWidth', ''),
                  '5001xx12': ('SL', '1', 'StylePoint', ''),
                  '5001xx13': ('LO', '1', 'StylePColour', ''),
                  '5001xx14': ('SL', '1', 'StylePSize', ''),
                  '5001xx15': ('SL', '1', 'Segments', ''),
                  '5001xx16': ('SL', '1', 'SegType', ''),
                  '5001xx17': ('FD', '1-n', 'SegStart', ''),
                  '5001xx18': ('FD', '1-n', 'SegEnd', ''),
                  '5001xx19': ('SL', '1-n', 'SegStyleLine', ''),
                  '5001xx1a': ('SL', '1-n', 'SegStyleFill', ''),
                  '5001xx1b': ('LO', '1', 'SegStyleColour', ''),
                  '5001xx1c': ('SL', '1-n', 'SegStyleWidth', ''),
                  '5001xx1d': ('SL', '1-n', 'SegStylePoint', ''),
                  '5001xx1e': ('SL', '1', 'SegStylePColour', ''),
                  '5001xx1f': ('SL', '1', 'SegStylePSize', ''),
                  '5001xx20': ('LO', '1', 'SegName', ''),
                  '5001xx21': ('SL', '1-n', 'SegAllowDirInt', ''),
                  '5001xx22': ('SL', '1', 'TextAnnots', ''),
                  '5001xx23': ('FD', '1-n', 'TxtX', ''),
                  '5001xx24': ('FD', '1-n', 'TxtY', ''),
                  '5001xx25': ('LO', '1', 'TxtText', ''),
                  '5001xx26': ('LO', '1', 'TxtName', ''),
                  '5001xx30': ('LO', '1', 'ROIName', ''),
                  '5001xx31': ('LO', '1', 'DerivedFromImageUID', ''),
                  '5001xx32': ('SL', '1-n', 'DerivedFromImages', ''),
                  '5001xx33': ('UL', '1', 'CurveFlags', ''),
                  '5001xx34': ('LO', '1', 'CurveName', ''),
                  '5001xx35': ('LO', '1', 'DatasetName', ''),
                  '5001xx36': ('LO', '1', 'CurveUID', ''),
                  '5001xx37': ('FD', '1', 'ROIArea', ''),
                  '5001xx38': ('SL', '1', 'Modified', ''),
                  '5001xx39': ('LO', '1', 'Name', ''),
                  '5001xx3a': ('LO', '1', 'Software version', ''),
                  '5001xx3b': ('SH', '1', 'StartDate', ''),
                  '5001xx3c': ('SH', '1', 'CompletionDate', ''),
                  '5001xx3d': ('LO', '1', 'DetectorName', ''),
                  '5001xx41': ('SL', '1', 'Modified', ''),
                  '5001xx42': ('LO', '1', 'Name', ''),
                  '5001xx43': ('SL', '1', 'Name', ''),
                  '5001xx44': ('SL', '1', 'Name', ''),
                  '5001xx45': ('LO', '1', 'SOPClassUID', ''),
                  '5001xx46': ('LO', '1', 'SOPInstanceUID', ''),
                  '5001xx47': ('LO', '1', 'NormalColor', ''),
                  '5001xx48': ('LT', '1', 'NameFont', ''),
                  '5001xx49': ('SL', '1', 'FillPattern', ''),
                  '5001xx4a': ('SL', '1', 'LineStyle', ''),
                  '5001xx4b': ('SL', '1', 'LineDashLength', ''),
                  '5001xx4c': ('SL', '1', 'LineThickness', ''),
                  '5001xx4d': ('SL', '1', 'Interactivity', ''),
                  '5001xx4e': ('SL', '1', 'NamePos', ''),
                  '5001xx4f': ('SL', '1', 'NameDisplay', ''),
                  '5001xx50': ('LO', '1', 'Label', ''),
                  '5001xx51': ('SL', '1-n', 'BpSeg', ''),
                  '5001xx52': ('US', '1-n', 'BpSegPairs', ''),
                  '5001xx53': ('SL', '1', 'SeedSpace', ''),
                  '5001xx54': ('FD', '1-n', 'Seeds', ''),
                  '5001xx55': ('SL', '1-n', 'Shape', ''),
                  '5001xx56': ('FD', '1-n', 'ShapeTilt', ''),
                  '5001xx59': ('SL', '1-n', 'ShapePtsSpace', ''),
                  '5001xx5a': ('SL', '1-n', 'ShapeCtrlPtsCounts', ''),
                  '5001xx5b': ('FD', '1-n', 'ShapeCtrlPts', ''),
                  '5001xx5c': ('SL', '1', 'ShapeCPSpace', ''),
                  '5001xx5d': ('SL', '1', 'ROIFlags', ''),
                  '5001xx5e': ('SL', '1', 'FrameNumber', ''),
                  '5001xx5f': ('SL', '1', 'Id', ''),
                  '5001xx60': ('LO', '1-n', 'DatasetROIMapping', '')},
 'GEMS_GNHD_01': {'0033xx01': ('UN', '1', 'Unknown', ''),
                  '0033xx02': ('UN', '1', 'Unknown', '')},
 'GEMS_HELIOS_01': {'0045xx01': ('SS',
                                 '1',
                                 'Number of Macro Rows in Detector',
                                 ''),
                    '0045xx02': ('FL', '1', 'Macro width at ISO Center', ''),
                    '0045xx03': ('SS', '1', 'DAS type', ''),
                    '0045xx04': ('SS', '1', 'DAS gain', ''),
                    '0045xx05': ('SS', '1', 'DAS Temprature', ''),
                    '0045xx06': ('CS', '1', 'Table Direction', ''),
                    '0045xx07': ('FL', '1', 'Z smoothing Factor', ''),
                    '0045xx08': ('SS', '1', 'View Weighting Mode', ''),
                    '0045xx09': ('SS', '1', 'Sigma Row number', ''),
                    '0045xx0a': ('FL', '1', 'Minimum DAS value', ''),
                    '0045xx0b': ('FL', '1', 'Maximum Offset Value', ''),
                    '0045xx0c': ('SS', '1', 'Number of Views shifted', ''),
                    '0045xx0d': ('SS', '1', 'Z tracking Flag', ''),
                    '0045xx0e': ('FL', '1', 'Mean Z error', ''),
                    '0045xx0f': ('FL', '1', 'Z tracking Error', ''),
                    '0045xx10': ('SS', '1', 'Start View 2A', ''),
                    '0045xx11': ('SS', '1', 'Number of Views 2A', ''),
                    '0045xx12': ('SS', '1', 'Start View 1A', ''),
                    '0045xx13': ('SS', '1', 'Sigma Mode', ''),
                    '0045xx14': ('SS', '1', 'Number of Views 1A', ''),
                    '0045xx15': ('SS', '1', 'Start View 2B', ''),
                    '0045xx16': ('SS', '1', 'Number Views 2B', ''),
                    '0045xx17': ('SS', '1', 'Start View 1B', ''),
                    '0045xx18': ('SS', '1', 'Number of Views 1B', ''),
                    '0045xx19': ('SS', '1', 'Air Calibration Date', ''),
                    '0045xx1a': ('SS', '1', 'Air Calibration Time', ''),
                    '0045xx1b': ('SS', '1', 'Phantom Calibration Date', ''),
                    '0045xx1c': ('SS', '1', 'Phantom Calibration Time', ''),
                    '0045xx1d': ('SS', '1', 'Z Slope Calibration Date', ''),
                    '0045xx1e': ('SS', '1', 'Z Slope Calibration Time', ''),
                    '0045xx1f': ('SS',
                                 '1',
                                 'Cross Talk Calibration Date',
                                 ''),
                    '0045xx20': ('SS',
                                 '1',
                                 'Cross Talk Calibration Time',
                                 ''),
                    '0045xx21': ('SS', '1', 'Iterbone Flag', ''),
                    '0045xx22': ('SS', '1', 'Perisstaltic Flag', ''),
                    '0045xx30': ('CS', '1', 'CardiacReconAlgorithm', ''),
                    '0045xx31': ('CS', '1', 'AvgHeartRateForImage', ''),
                    '0045xx32': ('FL', '1', 'TemporalResolution', ''),
                    '0045xx33': ('CS', '1', 'PctRpeakDelay', ''),
                    '0045xx34': ('CS', '1', 'ActualPctRpeakDelay', ''),
                    '0045xx36': ('CS', '1', 'EkgFullMaStartPhase', ''),
                    '0045xx37': ('CS', '1', 'EkgFullMaEndPhase', ''),
                    '0045xx38': ('CS', '1', 'EkgModulationMaxMa', ''),
                    '0045xx39': ('CS', '1', 'EkgModulationMinMa', ''),
                    '0045xx3b': ('LO',
                                 '1',
                                 'NoiseReductionImageFilterDesc',
                                 '')},
 'GEMS_HINO_CT_01': {'004bxx01': ('DS', '1-n', 'Beam Thickness', ''),
                     '004bxx02': ('DS', '1-n', 'R Time', ''),
                     '004bxx03': ('IS', '1', 'HBC number', '')},
 'GEMS_IDEN_01': {'000910xx': ('LO', '1', 'Private Element Creator', ''),
                  '0009xx01': ('LO', '1', 'Full fidelity', ''),
                  '0009xx02': ('SH', '1', 'Suite id', ''),
                  '0009xx04': ('SH', '1', 'Product id', ''),
                  '0009xx17': ('LT', '1', 'Series Description', ''),
                  '0009xx1a': ('US', '1', 'Unknown', ''),
                  '0009xx20': ('US', '1', 'Unknown', ''),
                  '0009xx27': ('SL', '1', 'Image actual date', ''),
                  '0009xx2f': ('SH', '1', 'Unknown', ''),
                  '0009xx30': ('SH', '1', 'Service id', ''),
                  '0009xx31': ('SH', '1', 'Mobile location number', ''),
                  '0009xxe2': ('LT',
                               '1-n',
                               'Image Type (ORIGINAL\\PROSPECTIVE ...)',
                               ''),
                  '0009xxe3': ('UI', '1', 'Equipment UID', ''),
                  '0009xxe6': ('SH', '1', 'Genesis Version - now', ''),
                  '0009xxe7': ('UL', '1', 'Exam Record checksum', ''),
                  '0009xxe8': ('SH', '1', 'Series Suite Id', ''),
                  '0009xxe9': ('SL',
                               '1',
                               'Actual series data time stamp',
                               '')},
 'GEMS_IMAG_01': {'002710xx': ('LO', '1', 'Private Element Creator', ''),
                  '0027xx06': ('SL', '1', 'Image archive flag', ''),
                  '0027xx10': ('SS', '1', 'Scout Type', ''),
                  '0027xx1c': ('SL', '1', 'Vma mamp', ''),
                  '0027xx1d': ('SS', '1', 'Vma phase', ''),
                  '0027xx1e': ('SL', '1', 'Vma mod', ''),
                  '0027xx1f': ('SL', '1', 'Vma clip', ''),
                  '0027xx20': ('SS', '1', 'Smart scan ON/OFF flag', ''),
                  '0027xx30': ('SH', '1', 'Foreign Image Revision', ''),
                  '0027xx31': ('SS', '1', 'Imaging Mode', ''),
                  '0027xx32': ('SS', '1', 'Pulse Sequence', ''),
                  '0027xx33': ('SL', '1', 'Imaging Options', ''),
                  '0027xx35': ('SS', '1', 'Plane Type', ''),
                  '0027xx36': ('SL', '1', 'Oblique Plane', ''),
                  '0027xx40': ('SH', '1', 'RAS letter of image location', ''),
                  '0027xx41': ('FL', '1', 'Image location', ''),
                  '0027xx42': ('FL',
                               '1',
                               'Center R coord of plane image',
                               ''),
                  '0027xx43': ('FL',
                               '1',
                               'Center A coord of plane image',
                               ''),
                  '0027xx44': ('FL',
                               '1',
                               'Center S coord of plane image',
                               ''),
                  '0027xx45': ('FL', '1', 'Normal R coord', ''),
                  '0027xx46': ('FL', '1', 'Normal A coord', ''),
                  '0027xx47': ('FL', '1', 'Normal S coord', ''),
                  '0027xx48': ('FL', '1', 'R Coord of Top Right Corner', ''),
                  '0027xx49': ('FL', '1', 'A Coord of Top Right Corner', ''),
                  '0027xx4a': ('FL', '1', 'S Coord of Top Right Corner', ''),
                  '0027xx4b': ('FL',
                               '1',
                               'R Coord of Bottom Right Corner',
                               ''),
                  '0027xx4c': ('FL',
                               '1',
                               'A Coord of Bottom Right Corner',
                               ''),
                  '0027xx4d': ('FL',
                               '1',
                               'S Coord of Bottom Right Corner',
                               ''),
                  '0027xx50': ('FL', '1', 'Scan Start Location', ''),
                  '0027xx51': ('FL', '1', 'Scan End Location', ''),
                  '0027xx52': ('SH', '1', 'RAS letter for side of image', ''),
                  '0027xx53': ('SH',
                               '1',
                               'RAS letter for anterior/posterior',
                               ''),
                  '0027xx54': ('SH',
                               '1',
                               'RAS letter for scout start loc',
                               ''),
                  '0027xx55': ('SH', '1', 'RAS letter for scout end loc', ''),
                  '0027xx60': ('FL', '1', 'Image dimension - X', ''),
                  '0027xx61': ('FL', '1', 'Image dimension - Y', ''),
                  '0027xx62': ('FL', '1', 'Number of Excitations', ''),
                  '0029xx15': ('SL', '1', 'Lower range of Pixels1', ''),
                  '0029xx16': ('SL', '1', 'Lower range of Pixels1', ''),
                  '0029xx17': ('SL', '1', 'Lower range of Pixels2', ''),
                  '0029xx18': ('SL', '1', 'Upper range of Pixels2', ''),
                  '0029xx1a': ('SL',
                               '1',
                               'Len of tot hdr in bytes No longer supported',
                               ''),
                  '0029xx26': ('SS', '1', 'Version of the hdr struct', ''),
                  '0029xx34': ('SL', '1', 'Advantage comp. Overflow', ''),
                  '0029xx35': ('SL', '1', 'Advantage comp. Underflow', '')},
 'GEMS_IMPS_01': {'002910xx': ('LO', '1', 'Private Element Creator', ''),
                  '0029xx04': ('SL', '1', 'Lower range of Pixels1', ''),
                  '0029xx05': ('DS', '1', 'Lower range of Pixels1', ''),
                  '0029xx06': ('DS', '1', 'Lower range of Pixels1', ''),
                  '0029xx07': ('SL', '1', 'Lower range of Pixels1', ''),
                  '0029xx08': ('SH', '1', 'Lower range of Pixels1', ''),
                  '0029xx09': ('SH', '1', 'Lower range of Pixels1', ''),
                  '0029xx0a': ('SS', '1', 'Lower range of Pixels1', ''),
                  '0029xx15': ('SL', '1', 'Lower range of Pixels1', ''),
                  '0029xx16': ('SL', '1', 'Upper range of Pixels1', ''),
                  '0029xx17': ('SL', '1', 'Lower range of Pixels2', ''),
                  '0029xx18': ('SL', '1', 'Upper range of Pixels2', ''),
                  '0029xx1a': ('SL', '1', 'Len of tot hdr in bytes', ''),
                  '0029xx26': ('SS', '1', 'Version of the hdr struct', ''),
                  '0029xx34': ('SL', '1', 'Advantage comp. Overflow', ''),
                  '0029xx35': ('SL', '1', 'Advantage comp. Underflow', ''),
                  '0043xx13': ('SS', '5', 'Decon kernel parameters', '')},
 'GEMS_IQTB_IDEN_47': {'0047xx01': ('SH', '1', 'Image Path', ''),
                       '0047xx02': ('UL', '1', 'Image Date/Time', ''),
                       '0047xx03': ('UL', '1', 'Queue Sequence Number', ''),
                       '0047xx04': ('UL', '1', 'Recon Sequence ID', '')},
 'GEMS_IT_US_REPORT': {'0045xx11': ('OW', '1', 'Vivid excel file', ''),
                       '0045xx12': ('OW', '1', 'Vivid CHM file', ''),
                       '0045xx13': ('OW', '1', 'Vivid PDF file', '')},
 'GEMS_LUNAR_RAW': {'7003xx01': ('ST', '1', 'enCORE File Name', ''),
                    '7003xx02': ('OB', '1', 'enCORE File Data', ''),
                    '7003xx03': ('UL', '1', 'enCORE File Length', ''),
                    '7003xx04': ('LO', '1', 'enCORE File Modified Time', '')},
 'GEMS_MR_RAW_01': {'7001xx01': ('OB', '1', 'rdb_hdr_rec', ''),
                    '7001xx02': ('OB', '1', 'rdb_hdr_per_pass_tab', ''),
                    '7001xx03': ('OB', '1', 'rdb_hdr_unlock_raw', ''),
                    '7001xx04': ('OB', '1', 'rdb_hdr_data_acq_tab', ''),
                    '7001xx05': ('OB', '1', 'rdb_hdr_nex_tab', ''),
                    '7001xx06': ('OB', '1', 'rdb_hdr_nex_abort_tab', ''),
                    '7001xx07': ('OB', '1', 'rdb_hdr_tool', ''),
                    '7001xx08': ('OB', '1', 'rdb_raw_data', ''),
                    '7001xx09': ('OB', '1', 'SSP save', ''),
                    '7001xx0a': ('OB', '1', 'UDA save', ''),
                    '7001xx0b': ('OB', '1', 'rdb_chemsat_data', '')},
 'GEMS_PARM_01': {'004310xx': ('LO', '1', 'Private Element Creator', ''),
                  '0043xx01': ('SS', '1', 'Bitmap of prescan options', ''),
                  '0043xx02': ('SS', '1', 'Gradient offset in X', ''),
                  '0043xx03': ('SS', '1', 'Gradient offset in Y', ''),
                  '0043xx04': ('SS', '1', 'Gradient offset in Z', ''),
                  '0043xx05': ('SS',
                               '1',
                               'Img is original or unoriginal',
                               ''),
                  '0043xx06': ('SS', '1', 'Number of EPI shots', ''),
                  '0043xx07': ('SS', '1', 'Views per segment', ''),
                  '0043xx08': ('SS', '1', 'Respiratory rate, bpm', ''),
                  '0043xx09': ('SS', '1', 'Respiratory trigger point', ''),
                  '0043xx0a': ('SS', '1', 'Type of receiver used', ''),
                  '0043xx0b': ('DS',
                               '1',
                               'DB/dt Peak rate of change of gradient field',
                               ''),
                  '0043xx0c': ('DS',
                               '1',
                               'dB/dt Limits in units of percent',
                               ''),
                  '0043xx0d': ('DS', '1', 'PSD estimated limit', ''),
                  '0043xx0e': ('DS',
                               '1',
                               'PSD estimated limit in tesla per second',
                               ''),
                  '0043xx0f': ('DS', '1', 'Saravghead', ''),
                  '0043xx10': ('US', '1', 'Window value', ''),
                  '0043xx11': ('US', '1', 'Total input views', ''),
                  '0043xx12': ('SS', '3', 'X-ray chain', ''),
                  '0043xx13': ('SS', '5', 'Decon kernel parameters', ''),
                  '0043xx14': ('SS', '3', 'Calibration parameters', ''),
                  '0043xx15': ('SS', '3', 'Total output views', ''),
                  '0043xx16': ('SS', '5', 'Number of overranges', ''),
                  '0043xx17': ('DS', '1', 'IBH image scale factors', ''),
                  '0043xx18': ('DS', '3', 'BBH coefficients', ''),
                  '0043xx19': ('SS',
                               '1',
                               'Number of BBH chains to blend',
                               ''),
                  '0043xx1a': ('SL', '1', 'Starting channel number', ''),
                  '0043xx1b': ('SS', '1', 'Ppscan parameters', ''),
                  '0043xx1c': ('SS', '1', 'GE image integrity', ''),
                  '0043xx1d': ('SS', '1', 'Level value', ''),
                  '0043xx1e': ('DS', '1', 'Delta Start Time [msec]', ''),
                  '0043xx1f': ('SL', '1', 'Max overranges in a view', ''),
                  '0043xx20': ('DS', '1', 'Avg overranges all views', ''),
                  '0043xx21': ('SS', '1', 'Corrected after glow terms', ''),
                  '0043xx25': ('SS', '6', 'Reference channels', ''),
                  '0043xx26': ('US', '6', 'No views ref chans blocked', ''),
                  '0043xx27': ('SH', '1', 'Scan Pitch Ratio', ''),
                  '0043xx28': ('OB', '1', 'Unique image iden', ''),
                  '0043xx29': ('OB', '1', 'Histogram tables', ''),
                  '0043xx2a': ('OB', '1', 'User defined data', ''),
                  '0043xx2b': ('SS', '4', 'Private Scan Options', ''),
                  '0043xx2c': ('SS', '1', 'Effective echo spacing', ''),
                  '0043xx2d': ('SH',
                               '1',
                               'Filter Mode (String slop field 1 in legacy GE MR',
                               ''),
                  '0043xx2e': ('SH', '1', 'String slop field 2', ''),
                  '0043xx2f': ('SS',
                               '1',
                               'Image Type (real, imaginary, phase, magnitude)',
                               ''),
                  '0043xx30': ('SS', '1', 'Vas collapse flag', ''),
                  '0043xx31': ('DS', '2', 'Recon Center Coordinates', ''),
                  '0043xx32': ('SS', '1', 'Vas flags', ''),
                  '0043xx33': ('FL', '1', 'Neg_scanspacing', ''),
                  '0043xx34': ('IS', '1', 'Offset Frequency', ''),
                  '0043xx35': ('UL', '1', 'User_usage_tag', ''),
                  '0043xx36': ('UL', '1', 'User_fill_map_MSW', ''),
                  '0043xx37': ('UL', '1', 'User_fill_map_LSW', ''),
                  '0043xx38': ('FL',
                               '24',
                               'User data 25...User data 48 {User48=Effective Resolution for spiral}',
                               ''),
                  '0043xx39': ('IS', '4', 'Slop_int_6... slop_int_9', ''),
                  '0043xx40': ('FL', '4', 'Trigger on position', ''),
                  '0043xx41': ('FL', '4', 'Degree of rotation', ''),
                  '0043xx42': ('SL', '4', 'DAS trigger source', ''),
                  '0043xx43': ('SL', '4', 'DAS fpa gain', ''),
                  '0043xx44': ('SL', '4', 'DAS output source', ''),
                  '0043xx45': ('SL', '4', 'DAS ad input', ''),
                  '0043xx46': ('SL', '4', 'DAS cal mode', ''),
                  '0043xx47': ('SL', '4', 'DAS cal frequency', ''),
                  '0043xx48': ('SL', '4', 'DAS reg xm', ''),
                  '0043xx49': ('SL', '4', 'DAS auto zero', ''),
                  '0043xx4a': ('SS', '4', 'Starting channel of view', ''),
                  '0043xx4b': ('SL', '4', 'DAS xm pattern', ''),
                  '0043xx4c': ('SS', '4', 'TGGC trigger mode', ''),
                  '0043xx4d': ('FL', '4', 'Start scan to X-ray on delay', ''),
                  '0043xx4e': ('FL', '4', 'Duration of X-ray on', ''),
                  '0043xx60': ('IS', '8', 'Slop_int_10...slop_int_17', ''),
                  '0043xx61': ('UI', '1', 'Scanner Study Entity UID', ''),
                  '0043xx62': ('SH', '1', 'Scanner Study ID', ''),
                  '0043xx63': ('SH', '1', 'Raw Data ID', ''),
                  '0043xx64': ('CS', '1-n', 'Image Filter', ''),
                  '0043xx65': ('US', '1', 'Motion Correction Indicator', ''),
                  '0043xx66': ('US', '1', 'Helical Correction Indicator', ''),
                  '0043xx67': ('US', '1', 'IBO Correction Indicator', ''),
                  '0043xx68': ('US', '1', 'XT Correction Indicator', ''),
                  '0043xx69': ('US', '1', 'Q-cal Correction Indicator', ''),
                  '0043xx6a': ('US', '1', 'AV Correction Indicator', ''),
                  '0043xx6b': ('US', '1', 'L-MDK Correction Indicator', ''),
                  '0043xx6c': ('IS', '1', 'Detector Row', ''),
                  '0043xx6d': ('IS', '1', 'Area Size', ''),
                  '0043xx6e': ('SH', '1', 'Auto mA Mode', ''),
                  '0043xx6f': ('DS',
                               '3-4',
                               'Scanner Table Entry (single gradient coil systems only)/Scanner Table Entry + Gradient Coil Selected',
                               ''),
                  '0043xx70': ('LO', '1', 'Paradigm Name', ''),
                  '0043xx71': ('ST', '1', 'Paradigm Description', ''),
                  '0043xx72': ('UI', '1', 'Paradigm UID', ''),
                  '0043xx73': ('US', '1', 'Experiment Type', ''),
                  '0043xx74': ('US', '1', '#rest volumes', ''),
                  '0043xx75': ('US', '1', '#active volumes', ''),
                  '0043xx76': ('US', '1', '#dummy scans', ''),
                  '0043xx77': ('SH', '1', 'Application Name', ''),
                  '0043xx78': ('SH', '1', 'Application Version', ''),
                  '0043xx79': ('US', '1', 'Slices Per Volume', ''),
                  '0043xx7a': ('US', '1', 'Expected Time Points', ''),
                  '0043xx7b': ('FL', '1-n', 'Regressor Values', ''),
                  '0043xx7c': ('FL', '1', 'Delay after slice group', ''),
                  '0043xx7d': ('US', '1', 'Recon mode flag word', ''),
                  '0043xx7e': ('LO', '1-n', 'PACC specific information', ''),
                  '0043xx7f': ('DS', '1-n', 'Reserved', ''),
                  '0043xx80': ('LO', '1-n', 'Coil ID Data', ''),
                  '0043xx81': ('LO', '1', 'GE Coil Name', ''),
                  '0043xx82': ('LO',
                               '1-n',
                               'System Configuration Information',
                               ''),
                  '0043xx83': ('DS', '1-2', 'Asset R Factors', ''),
                  '0043xx84': ('LO', '5', 'Additional Asset Data', ''),
                  '0043xx85': ('UT', '1', 'Debug Data (text format)', ''),
                  '0043xx86': ('OB', '1', 'Debug Data (binary format)', ''),
                  '0043xx87': ('UT', '1', 'Reserved', ''),
                  '0043xx88': ('UI',
                               '1',
                               'PURE Acquisition Calibration Series UID',
                               ''),
                  '0043xx89': ('LO',
                               '3',
                               'Governing Body, dB/dt, and SAR definition',
                               ''),
                  '0043xx8a': ('CS',
                               '1',
                               'Private In-Plane Phase Encoding Direction',
                               ''),
                  '0043xx8b': ('OB', '1', 'FMRI Binary Data Block', ''),
                  '0043xx8c': ('DS', '6', 'Voxel Location', ''),
                  '0043xx8d': ('DS', '7-7n', 'SAT Band Locations', ''),
                  '0043xx8e': ('DS', '3', 'Spectro Prescan Values', ''),
                  '0043xx8f': ('DS', '3', 'Spectro Parameters', ''),
                  '0043xx90': ('LO', '1-n', 'SAR Definition', ''),
                  '0043xx91': ('DS', '1-n', 'SAR value', ''),
                  '0043xx92': ('LO', '1', 'Image Error Text', ''),
                  '0043xx93': ('DS',
                               '1-n',
                               'Spectro Quantitation Values',
                               ''),
                  '0043xx94': ('DS', '1-n', 'Spectro Ratio Values', ''),
                  '0043xx95': ('LO', '1', 'Prescan Reuse String', ''),
                  '0043xx96': ('CS', '1', 'Content Qualification', ''),
                  '0043xx97': ('LO', '8', 'Image Filtering Parameters', ''),
                  '0043xx98': ('UI',
                               '1',
                               'ASSET Acquisition Calibration Series UID',
                               ''),
                  '0043xx99': ('LO', '1-n', 'Extended Options', ''),
                  '0043xx9a': ('IS', '1', 'Rx Stack Identification', ''),
                  '0051xx0a': ('SL',
                               '1',
                               'Store level of Functional Image',
                               ''),
                  '0051xx0b': ('FL',
                               '1',
                               'Store B-Value with Functional Image',
                               ''),
                  '2001xx10': ('UI', '1', 'DICOM Implementation UID', ''),
                  '2001xx11': ('SH', '1', 'DICOM Implementation Version', ''),
                  '2001xx12': ('UI',
                               '1',
                               'Within-DICOM-Implementation SOP Instance UID',
                               ''),
                  '2001xx13': ('SH', '1', 'Application Name', ''),
                  '2001xx14': ('SH', '1', 'Application Version', ''),
                  '2001xx15': ('SH', '1', 'Compatibility Version', ''),
                  '2001xx21': ('UI', '1-n', 'Referenced Series UID', ''),
                  '2001xx31': ('US', '1', 'Number of Objects Averaged', ''),
                  '2001xx41': ('US',
                               '1',
                               'Number of Expected Time Points',
                               ''),
                  '2001xx51': ('US', '1', 'Number of Slices Per Volume', ''),
                  '2001xx60': ('US', '1', 'BW Image Type', ''),
                  '2001xx61': ('US', '1', 'Experiment Type', ''),
                  '2001xx71': ('UI', '1', 'Paradigm UID', ''),
                  '2001xx72': ('LO', '1', 'Paradigm Name', ''),
                  '2001xx73': ('ST', '1', 'Paradigm Description', ''),
                  '2001xx80': ('OB', '1', 'Contrast', ''),
                  '2001xx81': ('FL', '1-n', 'Regressor Values', ''),
                  '2001xx86': ('US', '1', 'Number of Degrees of Freedom', ''),
                  '2001xx8a': ('FL', '1', 'Z Threshold', ''),
                  '2001xx8b': ('FL', '1', 'p Threshold', ''),
                  '2001xxa0': ('FL', '1-n', 'Motion Parameters', ''),
                  '2001xxa1': ('FL', '1-n', 'Registration Parameters', ''),
                  '2001xxa2': ('FL', '1-n', 'Subject Data', ''),
                  '2001xxb0': ('OB', '1', 'DTI Parameters', ''),
                  '2001xxc0': ('OB', '1', 'Paradigm Info', '')},
 'GEMS_PATI_01': {'001110xx': ('LO', '1', 'Private Element Creator', ''),
                  '0011xx10': ('SS', '1', 'Patient Status', '')},
 'GEMS_PETD_01': {'0009xx01': ('LO',
                               '2',
                               'GE Discovery PET Implementation Version Name',
                               ''),
                  '0009xx02': ('LO', '1', 'PET patient_id', ''),
                  '0009xx03': ('SH', '1', 'PET compatible_version', ''),
                  '0009xx04': ('SH',
                               '1',
                               'GE Advance Patient.software_version',
                               ''),
                  '0009xx05': ('DT', '1', 'PET patient_datetime', ''),
                  '0009xx06': ('SL', '1', 'PET type', ''),
                  '0009xx07': ('UI', '1', 'PET exam_id', ''),
                  '0009xx08': ('SH', '1', 'PET compatible_version', ''),
                  '0009xx09': ('SH', '1', 'PET software_version', ''),
                  '0009xx0a': ('UI', '1', 'PET scan_id', ''),
                  '0009xx0b': ('SH', '1', 'PET compatible_version', ''),
                  '0009xx0c': ('SH', '1', 'PET software_version', ''),
                  '0009xx0d': ('DT', '1', 'PET scan_datetime', ''),
                  '0009xx0e': ('DT', '1', 'PET scan_ready', ''),
                  '0009xx0f': ('ST', '1', 'PET scan_description', ''),
                  '0009xx10': ('LO', '1', 'PET hospital_name', ''),
                  '0009xx11': ('LO', '1', 'PET scanner_desc', ''),
                  '0009xx12': ('LO', '1', 'PET manufacturer', ''),
                  '0009xx13': ('UI', '1', 'PET for_identifier', ''),
                  '0009xx14': ('LO', '1', 'PET landmark_name', ''),
                  '0009xx15': ('SH', '1', 'PET landmark_abbrev', ''),
                  '0009xx16': ('SL', '1', 'PET patient_position', ''),
                  '0009xx17': ('SL', '1', 'PET scan_perspective', ''),
                  '0009xx18': ('SL', '1', 'PET scan_type', ''),
                  '0009xx19': ('SL', '1', 'PET scan_mode', ''),
                  '0009xx1a': ('SL', '1', 'PET start_condition', ''),
                  '0009xx1b': ('SL', '1', 'PET start_cond_data', ''),
                  '0009xx1c': ('SL', '1', 'PET sel_stop_cond', ''),
                  '0009xx1d': ('SL', '1', 'PET sel_stop_cond_data', ''),
                  '0009xx1e': ('SL', '1', 'PET collect_deadtime', ''),
                  '0009xx1f': ('SL', '1', 'PET collect_singles', ''),
                  '0009xx20': ('SL', '1', 'PET collect_countrate', ''),
                  '0009xx21': ('SL', '1', 'PET countrate_period', ''),
                  '0009xx22': ('SL', '1', 'PET delayed_events', ''),
                  '0009xx23': ('SL', '1', 'PET delayed_bias', ''),
                  '0009xx24': ('SL', '1', 'PET word_size', ''),
                  '0009xx25': ('SL', '1', 'PET axial_acceptance', ''),
                  '0009xx26': ('SL', '1', 'PET axial_angle_3d', ''),
                  '0009xx27': ('SL', '1', 'PET theta_compression', ''),
                  '0009xx28': ('SL', '1', 'PET axial_compression', ''),
                  '0009xx29': ('FL', '1', 'PET gantry_tilt_angle', ''),
                  '0009xx2a': ('SL', '1', 'PET collimation', ''),
                  '0009xx2b': ('SL', '1', 'PET scan_fov', ''),
                  '0009xx2c': ('SL', '1', 'PET axial_fov', ''),
                  '0009xx2d': ('SL', '1', 'PET event_separation', ''),
                  '0009xx2e': ('SL', '1', 'PET mask_width', ''),
                  '0009xx2f': ('SL', '1', 'PET binning_mode', ''),
                  '0009xx30': ('SL', '1', 'PET trig_rej_method', ''),
                  '0009xx31': ('SL', '1', 'PET number_for_reject', ''),
                  '0009xx32': ('SL', '1', 'PET lower_reject_limit', ''),
                  '0009xx33': ('SL', '1', 'PET upper_reject_limit', ''),
                  '0009xx34': ('SL', '1', 'PET triggers_acquired', ''),
                  '0009xx35': ('SL', '1', 'PET triggers_rejected', ''),
                  '0009xx36': ('LO', '1', 'PET tracer_name', ''),
                  '0009xx37': ('LO', '1', 'PET batch_description', ''),
                  '0009xx38': ('FL', '1', 'PET tracer_activity', ''),
                  '0009xx39': ('DT', '1', 'PET meas_datetime', ''),
                  '0009xx3a': ('FL', '1', 'PET pre_inj_volume', ''),
                  '0009xx3b': ('DT', '1', 'PET admin_datetime', ''),
                  '0009xx3c': ('FL', '1', 'PET post_inj_activity', ''),
                  '0009xx3d': ('DT', '1', 'PET post_inj_datetime', ''),
                  '0009xx3e': ('SH', '1', 'PET radionuclide_name', ''),
                  '0009xx3f': ('FL', '1', 'PET half_life', ''),
                  '0009xx40': ('FL', '1', 'PET positron_fraction', ''),
                  '0009xx41': ('SL', '1', 'PET source1_holder', ''),
                  '0009xx42': ('FL', '1', 'PET source1_activity', ''),
                  '0009xx43': ('DT', '1', 'PET source1_meas_dt', ''),
                  '0009xx44': ('SH', '1', 'PET source1_radnuclide', ''),
                  '0009xx45': ('FL', '1', 'PET source1_half_life', ''),
                  '0009xx46': ('SL', '1', 'PET source2_holder', ''),
                  '0009xx47': ('FL', '1', 'PET source2_activity', ''),
                  '0009xx48': ('DT', '1', 'PET source2_meas_dt', ''),
                  '0009xx49': ('SH', '1', 'PET source2_radnuclide', ''),
                  '0009xx4a': ('FL', '1', 'PET source2_half_life', ''),
                  '0009xx4b': ('SL', '1', 'PET source_speed', ''),
                  '0009xx4c': ('FL', '1', 'PET source_location', ''),
                  '0009xx4d': ('SL', '1', 'PET emission_present', ''),
                  '0009xx4e': ('SL', '1', 'PET lower_axial_acc', ''),
                  '0009xx4f': ('SL', '1', 'PET upper_axial_acc', ''),
                  '0009xx50': ('SL', '1', 'PET lower_coinc_limit', ''),
                  '0009xx51': ('SL', '1', 'PET upper_coinc_limit', ''),
                  '0009xx52': ('SL', '1', 'PET coinc_delay_offset', ''),
                  '0009xx53': ('SL', '1', 'PET coinc_output_mode', ''),
                  '0009xx54': ('SL', '1', 'PET upper_energy_limit', ''),
                  '0009xx55': ('SL', '1', 'PET lower_energy_limit', ''),
                  '0009xx56': ('UI', '1', 'PET normal_cal_id', ''),
                  '0009xx57': ('UI', '1', 'PET normal_2d_cal_id', ''),
                  '0009xx58': ('UI', '1', 'PET blank_cal_id', ''),
                  '0009xx59': ('UI', '1', 'PET wc_cal_id', ''),
                  '0009xx5a': ('SL', '1', 'PET derived', ''),
                  '0009xx5b': ('LO', '1', 'PET contrast_agent', ''),
                  '0009xx5c': ('UI', '1', 'PET frame_id', ''),
                  '0009xx5d': ('UI', '1', 'PET scan_id', ''),
                  '0009xx5e': ('UI', '1', 'PET exam_id', ''),
                  '0009xx5f': ('LO', '1', 'PET patient_id', ''),
                  '0009xx60': ('SH', '1', 'PET compatible_version', ''),
                  '0009xx61': ('SH', '1', 'PET software_version', ''),
                  '0009xx62': ('ST', '1', 'PET where_is_frame', ''),
                  '0009xx63': ('SL', '1', 'PET frame_size', ''),
                  '0009xx64': ('SL', '1', 'PET file_exists', ''),
                  '0009xx65': ('SL', '1', 'PET patient_entry', ''),
                  '0009xx66': ('FL', '1', 'PET table_height', ''),
                  '0009xx67': ('FL', '1', 'PET table_z_position', ''),
                  '0009xx68': ('DT', '1', 'PET landmark_datetime', ''),
                  '0009xx69': ('SL', '1', 'PET slice_count', ''),
                  '0009xx6a': ('FL', '1', 'PET start_location', ''),
                  '0009xx6b': ('SL', '1', 'PET acq_delay', ''),
                  '0009xx6c': ('DT', '1', 'PET acq_start', ''),
                  '0009xx6d': ('SL', '1', 'PET acq_duration', ''),
                  '0009xx6e': ('SL', '1', 'PET acq_bin_dur', ''),
                  '0009xx6f': ('SL', '1', 'PET acq_bin_start', ''),
                  '0009xx70': ('SL', '1', 'PET actual_stop_cond', ''),
                  '0009xx71': ('FD', '1', 'PET total_prompts', ''),
                  '0009xx72': ('FD', '1', 'PET total_delays', ''),
                  '0009xx73': ('SL', '1', 'PET frame_valid', ''),
                  '0009xx74': ('SL', '1', 'PET validity_info', ''),
                  '0009xx75': ('SL', '1', 'PET archived', ''),
                  '0009xx76': ('SL', '1', 'PET compression', ''),
                  '0009xx77': ('SL', '1', 'PET uncompressed_size', ''),
                  '0009xx78': ('SL', '1', 'PET accum_bin_dur', ''),
                  '0009xx79': ('SH', '1', 'PET compatible_version', ''),
                  '0009xx7a': ('SH', '1', 'PET software_version', ''),
                  '0009xx7b': ('DT', '1', 'PET is_datetime', ''),
                  '0009xx7c': ('SL', '1', 'PET is_source', ''),
                  '0009xx7d': ('SL', '1', 'PET is_contents', ''),
                  '0009xx7e': ('SL', '1', 'PET is_type', ''),
                  '0009xx7f': ('DS', '3', 'PET is_reference', ''),
                  '0009xx80': ('SL', '1', 'PET multi_patient', ''),
                  '0009xx81': ('SL', '1', 'PET number_of_normals', ''),
                  '0009xx82': ('UI', '1', 'PET color_map_id', ''),
                  '0009xx83': ('SL', '1', 'PET window_level_type', ''),
                  '0009xx84': ('FL', '1', 'PET rotate', ''),
                  '0009xx85': ('SL', '1', 'PET flip', ''),
                  '0009xx86': ('FL', '1', 'PET zoom', ''),
                  '0009xx87': ('SL', '1', 'PET pan_x', ''),
                  '0009xx88': ('SL', '1', 'PET pan_y', ''),
                  '0009xx89': ('FL', '1', 'PET window_level_min', ''),
                  '0009xx8a': ('FL', '1', 'PET window_level_max', ''),
                  '0009xx8b': ('SL', '1', 'PET recon_method', ''),
                  '0009xx8c': ('SL', '1', 'PET attenuation', ''),
                  '0009xx8d': ('FL', '1', 'PET atten_coefficient', ''),
                  '0009xx8e': ('SL', '1', 'PET bp_filter', ''),
                  '0009xx8f': ('FL', '1', 'PET bp_filter_cutoff', ''),
                  '0009xx90': ('SL', '1', 'PET bp_filter_order', ''),
                  '0009xx91': ('FL', '1', 'PET bp_center_l', ''),
                  '0009xx92': ('FL', '1', 'PET bp_center_p', ''),
                  '0009xx93': ('SL', '1', 'PET atten_smooth', ''),
                  '0009xx94': ('SL', '1', 'PET atten_smooth_param', ''),
                  '0009xx95': ('SL', '1', 'PET angle_smooth_param', ''),
                  '0009xx96': ('UI', '1', 'PET wellcountercal_id', ''),
                  '0009xx97': ('UI', '1', 'PET trans_scan_id', ''),
                  '0009xx98': ('UI', '1', 'PET norm_cal_id', ''),
                  '0009xx99': ('UI', '1', 'PET blnk_cal_id', ''),
                  '0009xx9a': ('FL', '1', 'PET cac_edge_threshold', ''),
                  '0009xx9b': ('FL', '1', 'PET cac_skull_offset', ''),
                  '0009xx9c': ('UI', '1', 'PET emiss_sub_id', ''),
                  '0009xx9d': ('SL', '1', 'PET radial_filter_3d', ''),
                  '0009xx9e': ('FL', '1', 'PET radial_cutoff_3d', ''),
                  '0009xx9f': ('SL', '1', 'PET axial_filter_3d', ''),
                  '0009xxa0': ('FL', '1', 'PET axial_cutoff_3d', ''),
                  '0009xxa1': ('FL', '1', 'PET axial_start', ''),
                  '0009xxa2': ('FL', '1', 'PET axial_spacing', ''),
                  '0009xxa3': ('SL', '1', 'PET axial_angles_used', ''),
                  '0009xxa4': ('SH', '1', 'PET compatible_version', ''),
                  '0009xxa5': ('SH', '1', 'PET software_version', ''),
                  '0009xxa6': ('SL', '1', 'PET slice_number', ''),
                  '0009xxa7': ('FL', '1', 'PET total_counts', ''),
                  '0009xxa8': ('OB', '1', 'PET other_atts', ''),
                  '0009xxa9': ('SL', '1', 'PET other_atts_size', ''),
                  '0009xxaa': ('SL', '1', 'PET archived', ''),
                  '0009xxab': ('FL', '1', 'PET bp_center_x', ''),
                  '0009xxac': ('FL', '1', 'PET bp_center_y', ''),
                  '0009xxad': ('UI', '1', 'PET trans_frame_id', ''),
                  '0009xxae': ('UI', '1', 'PET tpluse_frame_id', ''),
                  '0009xxb1': ('FL', '1', 'PET profile_spacing', ''),
                  '0009xxb2': ('SL', '1', 'PET ir_num_iterations', ''),
                  '0009xxb3': ('SL', '1', 'PET ir_num_subsets', ''),
                  '0009xxb4': ('FL', '1', 'PET ir_recon_fov', ''),
                  '0009xxb5': ('SL', '1', 'PET ir_corr_model', ''),
                  '0009xxb6': ('SL', '1', 'PET ir_loop_filter', ''),
                  '0009xxb7': ('FL', '1', 'PET ir_pre_filt_parm', ''),
                  '0009xxb8': ('SL', '1', 'PET ir_loop_filt_parm', ''),
                  '0009xxb9': ('FL', '1', 'PET response_filt_parm', ''),
                  '0009xxba': ('SL', '1', 'PET post_filter', ''),
                  '0009xxbb': ('FL', '1', 'PET post_filt_parm', ''),
                  '0009xxbc': ('SL', '1', 'PET ir_regularize', ''),
                  '0009xxbd': ('FL', '1', 'PET regularize_parm', ''),
                  '0009xxbe': ('SL', '1', 'PET ac_bp_filter', ''),
                  '0009xxbf': ('FL', '1', 'PET ac_bp_filt_cut_off', ''),
                  '0009xxc0': ('SL', '1', 'PET ac_bp_filt_order', ''),
                  '0009xxc1': ('SL', '1', 'PET ac_img_smooth', ''),
                  '0009xxc2': ('FL', '1', 'PET ac_img_smooth_parm', ''),
                  '0009xxc3': ('SL', '1', 'PET scatter_method', ''),
                  '0009xxc4': ('SL', '1', 'PET scatter_num_iter', ''),
                  '0009xxc5': ('FL', '1', 'PET scatter_parm', ''),
                  '0009xxc6': ('FL', '1', 'PET seg_qc_parm', ''),
                  '0009xxc7': ('SL', '1', 'PET overlap', ''),
                  '0009xxc8': ('UI', '1', 'PET ovlp_frm_id', ''),
                  '0009xxc9': ('UI', '1', 'PET ovlp_trans_frm_id', ''),
                  '0009xxca': ('UI', '1', 'PET ovlp_tpulse_frm_id', ''),
                  '0009xxcb': ('FL', '1', 'PET vqc_x_axis_trans', ''),
                  '0009xxcc': ('FL', '1', 'PET vqc_x_axis_tilt', ''),
                  '0009xxcd': ('FL', '1', 'PET vqc_y_axis_trans', ''),
                  '0009xxce': ('FL', '1', 'PET vqc_y_axis_swivel', ''),
                  '0009xxcf': ('FL', '1', 'PET vqc_z_axis_trans', ''),
                  '0009xxd0': ('FL', '1', 'PET vqc_z_axis_roll', ''),
                  '0009xxd1': ('LO', '1', 'PET ctac_conv_scale', ''),
                  '0009xxd2': ('UI', '1', 'PET image_set_id', ''),
                  '0009xxd3': ('SL', '1', 'PET constrast_route', ''),
                  '0009xxd4': ('LO', '1', 'PET ctac_conv_scale', ''),
                  '0009xxd5': ('FL', '1', 'PET loop_filter_parm', ''),
                  '0009xxd6': ('FL', '1', 'PET image_one_loc', ''),
                  '0009xxd7': ('FL', '1', 'PET image_index_loc', ''),
                  '0009xxd8': ('SL', '1', 'PET frame_number', ''),
                  '0009xxd9': ('SL', '1', 'PET list_file_exists', ''),
                  '0009xxda': ('ST', '1', 'PET where_is_list_frame', ''),
                  '0009xxdb': ('SL', '1', 'PET ir_z_filter_flag', ''),
                  '0009xxdc': ('FL', '1', 'PET ir_z_filter_ratio', ''),
                  '0009xxdd': ('US', '1', 'PET num_of_rr_interval', ''),
                  '0009xxde': ('US', '1', 'PET num_of_time_slots', ''),
                  '0009xxdf': ('US', '1', 'PET num_of_slices', ''),
                  '0009xxe0': ('US', '1', 'PET num_of_time_slices', ''),
                  '0009xxe1': ('SL', '1', 'PET unlisted_scan', ''),
                  '0009xxe2': ('SL', '1', 'PET rest_stress', ''),
                  '0009xxe3': ('FL', '1', 'PET phase percentage', ''),
                  '0009xxe4': ('ST', '1', 'Recon Protocol', ''),
                  '0009xxe5': ('FL', '1', 'PET left shift', ''),
                  '0009xxe6': ('FL', '1', 'PET posterior shift', ''),
                  '0009xxe7': ('FL', '1', 'PET superior shift', ''),
                  '0009xxe8': ('SL', '1', 'PET acq_bin_num', ''),
                  '0009xxe9': ('FL', '1', 'PET acq_bin_dur_percent', ''),
                  '0009xxea': ('SL', '1', '3D Filter flag', ''),
                  '0009xxeb': ('FL', '1', '3D Filter cutoff', ''),
                  '0009xxec': ('SL', '1', '3D Filter order', ''),
                  '0009xxf0': ('UI', '1', 'Reformat group', ''),
                  '0011xx01': ('SQ', '1', 'GE Advance ROI Sequence', ''),
                  '0011xx02': ('UI', '1', 'GE Advance ROI.roi_id', ''),
                  '0011xx03': ('UI', '1', 'GE Advance ROI.image_id', ''),
                  '0011xx04': ('SH',
                               '1',
                               'GE Advance ROI.compatible_version',
                               ''),
                  '0011xx05': ('SH',
                               '1',
                               'GE Advance ROI.software_version',
                               ''),
                  '0011xx06': ('LO', '1', 'GE Advance ROI.roi_name', ''),
                  '0011xx07': ('DT', '1', 'GE Advance ROI.roi_datetime', ''),
                  '0011xx08': ('SL', '1', 'GE Advance ROI.roi_type', ''),
                  '0011xx09': ('FL', '1', 'GE Advance ROI.center_x', ''),
                  '0011xx0a': ('FL', '1', 'GE Advance ROI.center_y', ''),
                  '0011xx0b': ('FL', '1', 'GE Advance ROI.width', ''),
                  '0011xx0c': ('FL', '1', 'GE Advance ROI.height', ''),
                  '0011xx0d': ('FL', '1', 'GE Advance ROI.angle', ''),
                  '0011xx0e': ('SL',
                               '1',
                               'GE Advance ROI.number_of_points',
                               ''),
                  '0011xx0f': ('OB', '1', 'GE Advance ROI.roi_data', ''),
                  '0011xx10': ('SL', '1', 'GE Advance ROI.roi_size', ''),
                  '0011xx11': ('LO', '1', 'GE Advance ROI.color', ''),
                  '0011xx12': ('SL', '1', 'GE Advance ROI.line_type', ''),
                  '0011xx13': ('SL', '1', 'GE Advance ROI.line_width', ''),
                  '0011xx14': ('SL', '1', 'GE Advance ROI.roi_number', ''),
                  '0011xx15': ('SL', '1', 'GE Advance ROI.convex', ''),
                  '0011xx16': ('SL',
                               '1',
                               'GE Advance ROI.atten_corr_flag',
                               ''),
                  '0011xx18': ('OB', '1', 'Unknown', ''),
                  '0013xx01': ('SQ',
                               '1',
                               'GE Advance Annotation Sequence',
                               ''),
                  '0013xx02': ('UI',
                               '1',
                               'GE Advance Annotation.annotation_id',
                               ''),
                  '0013xx03': ('UI',
                               '1',
                               'GE Advance Annotation.image_id',
                               ''),
                  '0013xx04': ('SH',
                               '1',
                               'GE Advance Annotation.compatible_version',
                               ''),
                  '0013xx05': ('SH',
                               '1',
                               'GE Advance Annotation.software_version',
                               ''),
                  '0013xx06': ('SL', '1', 'GE Advance Annotation.type', ''),
                  '0013xx07': ('LO',
                               '1',
                               'GE Advance Annotation.font_name',
                               ''),
                  '0013xx08': ('SH',
                               '1',
                               'GE Advance Annotation.font_size',
                               ''),
                  '0013xx09': ('LO',
                               '1',
                               'GE Advance Annotation.foreground_color',
                               ''),
                  '0013xx0a': ('LO',
                               '1',
                               'GE Advance Annotation.background_color',
                               ''),
                  '0013xx0b': ('SL',
                               '1',
                               'GE Advance Annotation.coordinate_system',
                               ''),
                  '0013xx0c': ('FL',
                               '1',
                               'GE Advance Annotation.start_x',
                               ''),
                  '0013xx0d': ('FL',
                               '1',
                               'GE Advance Annotation.start_y',
                               ''),
                  '0013xx0e': ('FL', '1', 'GE Advance Annotation.end_x', ''),
                  '0013xx0f': ('FL', '1', 'GE Advance Annotation.end_y', ''),
                  '0013xx10': ('SL',
                               '1',
                               'GE Advance Annotation.start_symbol',
                               ''),
                  '0013xx11': ('SL',
                               '1',
                               'GE Advance Annotation.end_symbol',
                               ''),
                  '0013xx12': ('OB',
                               '1',
                               'GE Advance Annotation.annotation_data',
                               ''),
                  '0013xx13': ('SL',
                               '1',
                               'GE Advance Annotation.annotation_size',
                               ''),
                  '0013xx14': ('LO',
                               '1',
                               'GE Advance Annotation.label_id',
                               ''),
                  '0017xx01': ('UI', '1', 'PET correction_cal_id', ''),
                  '0017xx02': ('SH', '1', 'PET compatible_version', ''),
                  '0017xx03': ('SH', '1', 'PET software_version', ''),
                  '0017xx04': ('DT', '1', 'PET cal_datetime', ''),
                  '0017xx05': ('LO', '1', 'PET cal_description', ''),
                  '0017xx06': ('SL', '1', 'PET cal_type', ''),
                  '0017xx07': ('ST', '1', 'PET where_is_corr', ''),
                  '0017xx08': ('SL', '1', 'PET corr_file_size', ''),
                  '0017xx09': ('LO', '1', 'PET scan_id', ''),
                  '0017xx0a': ('DT', '1', 'PET scan_datetime', ''),
                  '0017xx0b': ('LO', '1', 'PET norm_2d_cal_id', ''),
                  '0017xx0c': ('SH', '1', 'PET hosp_identifier', ''),
                  '0017xx0d': ('SL', '1', 'PET archived', ''),
                  '0019xx01': ('UI', '1', 'PET wc_cal_id', ''),
                  '0019xx02': ('SH', '1', 'PET compatible_version', ''),
                  '0019xx03': ('SH', '1', 'PET software_version', ''),
                  '0019xx04': ('DT', '1', 'PET cal_datetime', ''),
                  '0019xx05': ('SL', '1', 'PET cal_type', ''),
                  '0019xx06': ('LO', '1', 'PET cal_description', ''),
                  '0019xx07': ('LO', '1', 'PET cal_hardware', ''),
                  '0019xx08': ('OB', '1', 'PET coefficients', ''),
                  '0019xx09': ('FL', '1', 'PET activity_factor_hr', ''),
                  '0019xx0a': ('FL', '1', 'PET activity_factor_hs', ''),
                  '0019xx0b': ('FL', '1', 'PET activity_factor_3d', ''),
                  '0019xx0c': ('LO', '1', 'PET scan_id', ''),
                  '0019xx0d': ('DT', '1', 'PET scan_datetime', ''),
                  '0019xx0e': ('SH', '1', 'PET hosp_identifier', ''),
                  '0019xx0f': ('FL', '1', 'PET meas_activity', ''),
                  '0019xx10': ('DT', '1', 'PET meas_datetime', ''),
                  '0019xx11': ('SL', '1', 'PET axial_filter_3d', ''),
                  '0019xx12': ('FL', '1', 'PET axial_cutoff_3d', ''),
                  '0019xx13': ('SL', '1', 'PET default_flag', ''),
                  '0019xx14': ('SL', '1', 'PET archived', ''),
                  '0019xx15': ('SL', '1', 'PET wc_cal_rec_method', ''),
                  '0019xx16': ('SL', '1', 'PET activity_factor_2d', ''),
                  '0019xx17': ('SL', '1', 'PET isotope', ''),
                  '0021xx01': ('US', '1', 'PET raw_data_type', ''),
                  '0021xx02': ('UL', '1', 'PET raw_data_size', ''),
                  '0023xx01': ('OB', '1', 'raw_data_blob', ''),
                  '0023xx02': ('OB', '1', 'PET raw_data_blob', ''),
                  '5001xx01': ('UI', '1', 'GE Advance Curve.curve_id', ''),
                  '5001xx02': ('SH',
                               '1',
                               'GE Advance Curve.compatible_version',
                               ''),
                  '5001xx03': ('SH',
                               '1',
                               'GE Advance Curve.software_version',
                               ''),
                  '5001xx04': ('SL',
                               '1',
                               'GE Advance Curve.statistics_type',
                               ''),
                  '5001xx05': ('LT', '1', 'GE Advance Curve.how_derived', ''),
                  '5001xx06': ('SL',
                               '1',
                               'GE Advance Curve.how_derived_size',
                               ''),
                  '5001xx07': ('SL',
                               '1',
                               'GE Advance Curve.multi_patient',
                               ''),
                  '5001xx08': ('SL', '1', 'GE Advance Curve.deadtime', ''),
                  '5003xx01': ('SQ', '1', 'GE Advance Graph Sequence', ''),
                  '5003xx02': ('UI', '1', 'GE Advance Graph.graph_id', ''),
                  '5003xx03': ('SH',
                               '1',
                               'GE Advance Graph.compatible_version',
                               ''),
                  '5003xx04': ('SH',
                               '1',
                               'GE Advance Graph.software_version',
                               ''),
                  '5003xx05': ('LO', '1', 'GE Advance Graph.title', ''),
                  '5003xx06': ('DT',
                               '1',
                               'GE Advance Graph.graph_datetime',
                               ''),
                  '5003xx07': ('ST',
                               '1',
                               'GE Advance Graph.graph_description',
                               ''),
                  '5003xx08': ('LO',
                               '1',
                               'GE Advance Graph.title_font_name',
                               ''),
                  '5003xx09': ('SH',
                               '1',
                               'GE Advance Graph.title_font_size',
                               ''),
                  '5003xx0a': ('LO', '1', 'GE Advance Graph.footer', ''),
                  '5003xx0b': ('SH',
                               '1',
                               'GE Advance Graph.footer_font_size',
                               ''),
                  '5003xx0c': ('LO',
                               '1',
                               'GE Advance Graph.foreground_color',
                               ''),
                  '5003xx0d': ('LO',
                               '1',
                               'GE Advance Graph.background_color',
                               ''),
                  '5003xx0e': ('SL',
                               '1',
                               'GE Advance Graph.graph_border',
                               ''),
                  '5003xx0f': ('SL', '1', 'GE Advance Graph.graph_width', ''),
                  '5003xx10': ('SL',
                               '1',
                               'GE Advance Graph.graph_height',
                               ''),
                  '5003xx11': ('SL', '1', 'GE Advance Graph.grid', ''),
                  '5003xx12': ('LO',
                               '1',
                               'GE Advance Graph.label_font_name',
                               ''),
                  '5003xx13': ('SH',
                               '1',
                               'GE Advance Graph.label_font_size',
                               ''),
                  '5003xx14': ('LO', '1', 'GE Advance Graph.axes_color', ''),
                  '5003xx15': ('LO',
                               '1',
                               'GE Advance Graph.x_axis_label',
                               ''),
                  '5003xx16': ('SL',
                               '1',
                               'GE Advance Graph.x_axis_units',
                               ''),
                  '5003xx17': ('FL',
                               '1',
                               'GE Advance Graph.x_major_tics',
                               ''),
                  '5003xx18': ('FL', '1', 'GE Advance Graph.x_axis_min', ''),
                  '5003xx19': ('FL', '1', 'GE Advance Graph.x_axis_max', ''),
                  '5003xx1a': ('LO',
                               '1',
                               'GE Advance Graph.y_axis_label',
                               ''),
                  '5003xx1b': ('SL',
                               '1',
                               'GE Advance Graph.y_axis_units',
                               ''),
                  '5003xx1c': ('FL',
                               '1',
                               'GE Advance Graph.y_major_tics',
                               ''),
                  '5003xx1d': ('FL', '1', 'GE Advance Graph.y_axis_min', ''),
                  '5003xx1e': ('FL', '1', 'GE Advance Graph.y_axis_max', ''),
                  '5003xx1f': ('LO',
                               '1',
                               'GE Advance Graph.legend_font_name',
                               ''),
                  '5003xx20': ('SH',
                               '1',
                               'GE Advance Graph.legend_font_size',
                               ''),
                  '5003xx21': ('SL',
                               '1',
                               'GE Advance Graph.legend_location_x',
                               ''),
                  '5003xx22': ('SL',
                               '1',
                               'GE Advance Graph.legend_location_y',
                               ''),
                  '5003xx23': ('SL',
                               '1',
                               'GE Advance Graph.legend_width',
                               ''),
                  '5003xx24': ('SL',
                               '1',
                               'GE Advance Graph.legend_height',
                               ''),
                  '5003xx25': ('SL',
                               '1',
                               'GE Advance Graph.legend_border',
                               ''),
                  '5003xx26': ('SL',
                               '1',
                               'GE Advance Graph.multi_patient',
                               ''),
                  '5005xx01': ('SQ',
                               '1',
                               'GE Advance CurvePresentation Sequence',
                               ''),
                  '5005xx02': ('UI',
                               '1',
                               'GE Advance CurvePresentation.curvepresent_id',
                               ''),
                  '5005xx03': ('UI',
                               '1',
                               'GE Advance CurvePresentation.graph_id',
                               ''),
                  '5005xx04': ('UI',
                               '1',
                               'GE Advance CurvePresentation.curve_id',
                               ''),
                  '5005xx05': ('SH',
                               '1',
                               'GE Advance CurvePresentation.compatible_version',
                               ''),
                  '5005xx06': ('SH',
                               '1',
                               'GE Advance CurvePresentation.software_version',
                               ''),
                  '5005xx07': ('LO',
                               '1',
                               'GE Advance CurvePresentation.curve_label',
                               ''),
                  '5005xx08': ('LO',
                               '1',
                               'GE Advance CurvePresentation.color',
                               ''),
                  '5005xx09': ('SL',
                               '1',
                               'GE Advance CurvePresentation.line_type',
                               ''),
                  '5005xx0a': ('SL',
                               '1',
                               'GE Advance CurvePresentation.line_width',
                               ''),
                  '5005xx0b': ('SL',
                               '1',
                               'GE Advance CurvePresentation.point_symbol',
                               ''),
                  '5005xx0c': ('SL',
                               '1',
                               'GE Advance CurvePresentation.point_symbol_dim',
                               ''),
                  '5005xx0d': ('LO',
                               '1',
                               'GE Advance CurvePresentation.point_color',
                               '')},
 'GEMS_QVA_PHOTO_01': {'0009xx60': ('FL',
                                    '1',
                                    'Dodge End Diastolic Volume ml',
                                    ''),
                       '0009xx61': ('FL',
                                    '1',
                                    'Dodge End Systolic Volume ml',
                                    ''),
                       '0009xx62': ('FL', '1', 'Dodge Stroke Volume ml', ''),
                       '0009xx63': ('IS', '1', 'Dodge Ejection Fraction', ''),
                       '0009xx64': ('FL',
                                    '1',
                                    'Simpson End Diastolic Volume ml',
                                    ''),
                       '0009xx65': ('FL',
                                    '1',
                                    'Simpson End Systolic Volume ml',
                                    ''),
                       '0009xx66': ('FL',
                                    '1',
                                    'Simpson Stroke Volume ml',
                                    ''),
                       '0009xx67': ('IS',
                                    '1',
                                    'Simpson Ejection Fraction',
                                    ''),
                       '0009xx68': ('FL',
                                    '1',
                                    'CFX Single Hypokinesia in Region',
                                    ''),
                       '0009xx69': ('FL',
                                    '1',
                                    'CFX Single Hyperkinesia in Opposite Region',
                                    ''),
                       '0009xx6a': ('IS',
                                    '1',
                                    'CFX Single Total LV contour Percent',
                                    ''),
                       '0009xx6b': ('FL',
                                    '1',
                                    'CFX Multiple Hypokinesia in Region',
                                    ''),
                       '0009xx6c': ('FL',
                                    '1',
                                    'CFX Multiple Hyperkinesia in Opposite Region',
                                    ''),
                       '0009xx6d': ('IS',
                                    '1',
                                    'CFX Multiple Total LV contour Percent',
                                    ''),
                       '0009xx6e': ('FL',
                                    '1',
                                    'RCA Single Hypokinesia in Region',
                                    ''),
                       '0009xx6f': ('FL',
                                    '1',
                                    'RCA Single Hyperkinesia in Opposite Region',
                                    ''),
                       '0009xx70': ('IS',
                                    '1',
                                    'RCA Single Total LV contour Percent',
                                    ''),
                       '0009xx71': ('FL',
                                    '1',
                                    'RCA Multiple Hypokinesia in Region',
                                    ''),
                       '0009xx72': ('FL',
                                    '1',
                                    'RCA Multiple Hyperkinesia in Opposite Region',
                                    ''),
                       '0009xx73': ('IS',
                                    '1',
                                    'RCA Multiple Total LV contour Percent',
                                    ''),
                       '0009xx74': ('FL',
                                    '1',
                                    'LAD Single Hypokinesia in Region',
                                    ''),
                       '0009xx75': ('FL',
                                    '1',
                                    'LAD Single Hyperkinesia in Opposite Region',
                                    ''),
                       '0009xx76': ('IS',
                                    '1',
                                    'LAD Single Total LV contour Percent',
                                    ''),
                       '0009xx77': ('FL',
                                    '1',
                                    'LAD Multiple Hypokinesia in Region',
                                    ''),
                       '0009xx78': ('FL',
                                    '1',
                                    'LAD Multiple Hyperkinesia in Opposite Region',
                                    ''),
                       '0009xx79': ('IS',
                                    '1',
                                    'LAD Multiple Total LV contour Percent',
                                    ''),
                       '0009xx7a': ('FL',
                                    '1',
                                    'Dodge End Diastolic Volume ml/m2',
                                    ''),
                       '0009xx7c': ('FL',
                                    '1',
                                    'Dodge End Systolic Volume ml/m2',
                                    ''),
                       '0009xx7e': ('FL',
                                    '1',
                                    'Dodge Stroke Volume ml/m2',
                                    ''),
                       '0009xx80': ('FL',
                                    '1',
                                    'Simpson End Diastolic Volume ml/m2',
                                    ''),
                       '0009xx82': ('FL',
                                    '1',
                                    'Simpson End Systolic Volume ml/m2',
                                    ''),
                       '0009xx84': ('FL',
                                    '1',
                                    'Simpson Stroke Volume ml/m2',
                                    '')},
 'GEMS_RELA_01': {'002110xx': ('LO', '1', 'Private Element Creator', ''),
                  '0021xx03': ('SS', '1', 'Series from which Prescribed', ''),
                  '0021xx05': ('SH', '1', 'Genesis Version - now', ''),
                  '0021xx07': ('UL', '1', 'Series Record checksum', ''),
                  '0021xx15': ('US', '1', 'Unknown', ''),
                  '0021xx16': ('SS', '1', 'Unknown', ''),
                  '0021xx18': ('SH', '1', 'Genesis version - Now', ''),
                  '0021xx19': ('UL', '1', 'Acq recon record checksum', ''),
                  '0021xx20': ('DS', '1', 'Table start location', ''),
                  '0021xx35': ('SS', '1', 'Series from which prescribed', ''),
                  '0021xx36': ('SS', '1', 'Image from which prescribed', ''),
                  '0021xx37': ('SS', '1', 'Screen Format', ''),
                  '0021xx4a': ('LO',
                               '1',
                               'Anatomical reference for scout',
                               ''),
                  '0021xx4e': ('US', '1', 'Unknown', ''),
                  '0021xx4f': ('SS', '1', 'Locations in acquisition', ''),
                  '0021xx50': ('SS', '1', 'Graphically prescribed', ''),
                  '0021xx51': ('DS', '1', 'Rotation from source x rot', ''),
                  '0021xx52': ('DS', '1', 'Rotation from source y rot', ''),
                  '0021xx53': ('DS', '1', 'Rotation from source z rot', ''),
                  '0021xx54': ('SH', '3', 'Image position', ''),
                  '0021xx55': ('SH', '6', 'Image orientation', ''),
                  '0021xx56': ('SL', '1', 'Num 3D slabs', ''),
                  '0021xx57': ('SL', '1', 'Locs per 3D slab', ''),
                  '0021xx58': ('SL', '1', 'Overlaps', ''),
                  '0021xx59': ('SL', '1', 'Image Filtering 0.5/0.2T', ''),
                  '0021xx5a': ('SL', '1', 'Diffusion direction', ''),
                  '0021xx5b': ('DS', '1', 'Tagging Flip Angle', ''),
                  '0021xx5c': ('DS', '1', 'Tagging Orientation', ''),
                  '0021xx5d': ('DS', '1', 'Tag Spacing', ''),
                  '0021xx5e': ('DS', '1', 'RTIA_timer', ''),
                  '0021xx5f': ('DS', '1', 'Fps', ''),
                  '0021xx70': ('LT', '1', 'Unknown', ''),
                  '0021xx71': ('LT', '1', 'Unknown', ''),
                  '0021xx81': ('DS', '1', 'Auto window/level alpha', ''),
                  '0021xx82': ('DS', '1', 'Auto window/level beta', ''),
                  '0021xx83': ('DS', '1', 'Auto window/level window', ''),
                  '0021xx84': ('DS', '1', 'Auto window/level level', ''),
                  '0021xx90': ('SS', '1', 'Tube focal spot position', ''),
                  '0021xx91': ('SS', '1', 'Biopsy position', ''),
                  '0021xx92': ('FL', '1', 'Biopsy T location', ''),
                  '0021xx93': ('FL', '1', 'Biopsy ref location', '')},
 'GEMS_RTEN_01': {'0249xx11': ('DA', '1', 'Plan Creation Date', ''),
                  '0249xx13': ('TM', '1', 'Plan Creation Time', ''),
                  '0249xx14': ('PN', '1', 'Operator Name', ''),
                  '0249xx16': ('LO', '1', 'Plan Comment', ''),
                  '0249xx18': ('SQ', '1', 'Plan Image Sequence', ''),
                  '0249xx1a': ('LO', '1', 'Exam/Series/Image Identifier', ''),
                  '0249xx1b': ('IS', '1', 'Additional Image Identifier', ''),
                  '0249xx1c': ('CS', '1', 'Build Resolution', ''),
                  '0249xx20': ('SQ', '1', 'Structure Sequence', ''),
                  '0249xx22': ('SH', '1', 'Structure Name', ''),
                  '0249xx24': ('CS', '1', 'Structure Type', ''),
                  '0249xx28': ('CS', '1', 'Structure Color', ''),
                  '0249xx30': ('SQ', '1', 'Slab Sequence', ''),
                  '0249xx32': ('SQ', '1', 'Slab Image Sequence', ''),
                  '0249xx36': ('DS', '1', 'Z Plus Thickness', ''),
                  '0249xx38': ('DS', '1', 'Z Minus Thickness', ''),
                  '0249xx3a': ('DS', '3-n', 'Slab Shape', ''),
                  '0249xx40': ('SQ', '1', 'Marker Sequence', ''),
                  '0249xx42': ('SH', '1', 'Marker Name', ''),
                  '0249xx44': ('CS', '1', 'Marker Color', ''),
                  '0249xx46': ('DS', '3', 'Marker Position', ''),
                  '0249xx50': ('SQ', '1', 'Beam Group Sequence', ''),
                  '0249xx51': ('SH', '1', 'Group Name', ''),
                  '0249xx52': ('CS', '1-n', 'Group Properties', ''),
                  '0249xx54': ('SQ', '1', 'Beam Sequence', ''),
                  '0249xx60': ('SQ', '1', 'Machine Reference Sequence', ''),
                  '0249xx62': ('SH', '1', 'Machine Name', ''),
                  '0249xx64': ('SH', '1', 'Beam Name', ''),
                  '0249xx66': ('CS', '1', 'Particle Type', ''),
                  '0249xx68': ('DS', '1', 'Nominal Particle Energy', ''),
                  '0249xx70': ('SQ', '1', 'Block Sequence', ''),
                  '0249xx72': ('LO', '1', 'Block Name', ''),
                  '0249xx74': ('DS', '2-n', 'Block Shape', ''),
                  '0249xx80': ('SQ', '1', 'Cutout Sequence', ''),
                  '0249xx82': ('LO', '1', 'Cutout Name', ''),
                  '0249xx84': ('DS', '2-n', 'Cutout Shape', ''),
                  '0249xx90': ('SH', '1', 'Collimator Name', ''),
                  '0249xx92': ('CS', '1', 'Collimator Type', ''),
                  '0249xxa0': ('SQ', '1', 'Dynamic Segment Sequence', ''),
                  '0249xxa2': ('DS', '1', 'Table Angle', ''),
                  '0249xxa4': ('DS', '1', 'Gantry Angle', ''),
                  '0249xxa6': ('DS', '1', 'Collimator Angle', ''),
                  '0249xxa8': ('DS', '3', 'Isocenter Position', ''),
                  '0249xxa9': ('DS', '1', 'Source-Surface Distance', ''),
                  '0249xxaa': ('DS', '1', 'X Symmetric Opening', ''),
                  '0249xxac': ('DS', '1', 'Y Symmetric Opening', ''),
                  '0249xxae': ('DS', '1', 'X Positive Jaw Position', ''),
                  '0249xxb0': ('DS', '1', 'X Negative Jaw Position', ''),
                  '0249xxb2': ('DS', '1', 'Y Positive Jaw Position', ''),
                  '0249xxb4': ('DS', '1', 'Y Negative Jaw Position', ''),
                  '0249xxb6': ('DS', '2-n', 'Leaf Positions', ''),
                  '0249xxd0': ('CS', '1', 'Treatment Position', '')},
 'GEMS_SENO_02': {'0045xx04': ('CS', '1', 'AES', ''),
                  '0045xx06': ('DS', '1', 'Stereo angle', ''),
                  '0045xx09': ('DS', '1', 'Real Magnification Factor', ''),
                  '0045xx0b': ('CS', '1', 'Senograph Type', ''),
                  '0045xx0c': ('DS', '1', 'Integration Time', ''),
                  '0045xx0d': ('DS', '1', 'ROI Origin X and Y', ''),
                  '0045xx11': ('DS', '2', 'Receptor Size cm X and Y', ''),
                  '0045xx12': ('IS', '2', 'Receptor Size Pixels X and Y', ''),
                  '0045xx13': ('ST', '1', 'Screen', ''),
                  '0045xx14': ('DS', '1', 'Pixel Pitch Microns', ''),
                  '0045xx15': ('IS', '1', 'Pixel Depth Bits', ''),
                  '0045xx16': ('IS', '2', 'Binning Factor X and Y', ''),
                  '0045xx1b': ('LO', '1', 'Clinical View', ''),
                  '0045xx1d': ('DS', '1', 'Mean Of Raw Gray Levels', ''),
                  '0045xx1e': ('DS', '1', 'Mean Of Offset Gray Levels', ''),
                  '0045xx1f': ('DS',
                               '1',
                               'Mean Of Corrected Gray Levels',
                               ''),
                  '0045xx20': ('DS', '1', 'Estimated Anat mean', ''),
                  '0045xx21': ('DS',
                               '1',
                               'Mean Of Log Region Gray Levels',
                               ''),
                  '0045xx22': ('DS',
                               '1',
                               'Standard Deviation Of Raw Gray Levels',
                               ''),
                  '0045xx23': ('DS',
                               '1',
                               'Standard Deviation Of Corrected Gray Levels',
                               ''),
                  '0045xx24': ('DS',
                               '1',
                               'Standard Deviation Of Region Gray Levels',
                               ''),
                  '0045xx25': ('DS',
                               '1',
                               'Standard Deviation Of Log Region Gray Levels',
                               ''),
                  '0045xx26': ('OB', '1', 'MAO Buffer', ''),
                  '0045xx27': ('IS', '1', 'Set Number', ''),
                  '0045xx28': ('CS',
                               '1',
                               'WindowingType (LINEAR or GAMMA)',
                               ''),
                  '0045xx29': ('DS', '2', 'Windowing parameters', ''),
                  '0045xx2a': ('IS', '1', '2DLocX', ''),
                  '0045xx2b': ('IS', '1', '2DLocY', ''),
                  '0045xx39': ('US', '1', 'Vignette Rows', ''),
                  '0045xx3a': ('US', '1', 'Vignette Columns', ''),
                  '0045xx3b': ('US', '1', 'Vignette Bits Allocated', ''),
                  '0045xx3c': ('US', '1', 'Vignette Bits Stored', ''),
                  '0045xx3d': ('US', '1', 'Vignette High Bit', ''),
                  '0045xx3e': ('US',
                               '1',
                               'Vignette Pixel Representation',
                               ''),
                  '0045xx3f': ('OB', '1', 'Vignette Pixel Data', ''),
                  '0045xx49': ('DS', '1', 'Radiological Thickness', ''),
                  '0045xx50': ('UI', '1', 'SC Instance UID', ''),
                  '0045xx51': ('UI', '1', 'SC series UID', ''),
                  '0045xx52': ('IS', '1', 'Raw Diagnostic Low', ''),
                  '0045xx53': ('IS', '1', 'Raw Diagnostic High', ''),
                  '0045xx54': ('DS', '1', 'Exponent', ''),
                  '0045xx55': ('IS', '1', 'A Coefficients', ''),
                  '0045xx56': ('DS', '1', 'Noise Reduction Sensitivity', ''),
                  '0045xx57': ('DS', '1', 'Noise Reduction Threshold', ''),
                  '0045xx58': ('DS', '1', 'mu', ''),
                  '0045xx59': ('IS', '1', 'Threshold', ''),
                  '0045xx60': ('IS', '4', 'Breast ROI X', ''),
                  '0045xx61': ('IS', '4', 'Breast ROI Y', ''),
                  '0045xx62': ('IS', '1', 'User Window Center', ''),
                  '0045xx63': ('IS', '1', 'User Window Width', ''),
                  '0045xx64': ('IS', '1', 'Segm Threshold', ''),
                  '0045xx65': ('IS', '1', 'Detector Entrance Dose', ''),
                  '0045xx66': ('IS',
                               '1',
                               'Asymmetrical Collimation Information',
                               ''),
                  '0045xx71': ('OB', '1', 'STX buffer', ''),
                  '0045xx72': ('DS', '2', 'Image Crop point', '')},
 'GEMS_SERS_01': {'002510xx': ('LO', '1', 'Private Element Creator', ''),
                  '0025xx06': ('SS', '1', 'Last pulse sequence used', ''),
                  '0025xx07': ('SL', '1', 'Images in Series', ''),
                  '0025xx10': ('SL', '1', 'Landmark Counter', ''),
                  '0025xx11': ('SS', '1', 'Number of Acquisitions', ''),
                  '0025xx14': ('SL',
                               '1',
                               'Indicates no. of updates to header',
                               ''),
                  '0025xx17': ('SL', '1', 'Series Complete Flag', ''),
                  '0025xx18': ('SL', '1', 'Number of images archived', ''),
                  '0025xx19': ('SL', '1', 'Last image number used', ''),
                  '0025xx1a': ('SH',
                               '1',
                               'Primary Receiver Suite and Host',
                               ''),
                  '0025xx1b': ('OB',
                               '1',
                               'Protocol Data Block (compressed)',
                               '')},
 'GEMS_STDY_01': {'002310xx': ('LO', '1', 'Private Element Creator', ''),
                  '0023xx01': ('SL', '1', 'Number of series in Study', ''),
                  '0023xx02': ('SL', '1', 'Number of unarchived Series', ''),
                  '0023xx10': ('SS', '1', 'Reference image field', ''),
                  '0023xx50': ('SS', '1', 'Summary image', ''),
                  '0023xx70': ('FD',
                               '1',
                               'Start time(secs) in first axial',
                               ''),
                  '0023xx74': ('SL', '1', 'No. of updates to header', ''),
                  '0023xx7d': ('SS',
                               '1',
                               'Indicates study has complete info (DICOM/genesis)',
                               '')},
 'GEMS_Ultrasound_ImageGroup_001': {'6003xx10': ('SQ', '1', 'Unknown', ''),
                                    '6003xx11': ('OB', '1', 'Unknown', '')},
 'GEMS_Ultrasound_MovieGroup_001': {'7fe1xx01': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx02': ('LO', '1', 'Unknown', ''),
                                    '7fe1xx03': ('UL', '1', 'Unknown', ''),
                                    '7fe1xx08': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx10': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx12': ('LO', '1', 'Unknown', ''),
                                    '7fe1xx18': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx20': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx24': ('SH', '1', 'Unknown', ''),
                                    '7fe1xx26': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx36': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx37': ('UL', '1', 'Unknown', ''),
                                    '7fe1xx43': ('OB', '1', 'Unknown', ''),
                                    '7fe1xx48': ('FD', '1-2', 'Unknown', ''),
                                    '7fe1xx49': ('UL', '1', 'Unknown', ''),
                                    '7fe1xx51': ('FL', '1', 'Unknown', ''),
                                    '7fe1xx52': ('FD', '1', 'Unknown', ''),
                                    '7fe1xx53': ('UL', '1', 'Unknown', ''),
                                    '7fe1xx54': ('SL', '1', 'Unknown', ''),
                                    '7fe1xx55': ('OB', '1', 'Unknown', ''),
                                    '7fe1xx57': ('LT', '1', 'Unknown', ''),
                                    '7fe1xx60': ('OB', '1', 'Unknown', ''),
                                    '7fe1xx61': ('OW', '1', 'Unknown', ''),
                                    '7fe1xx70': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx71': ('UL', '1', 'Unknown', ''),
                                    '7fe1xx72': ('LO', '1', 'Unknown', ''),
                                    '7fe1xx73': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx74': ('LO', '1', 'Unknown', ''),
                                    '7fe1xx75': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx77': ('FD', '1-n', 'Unknown', ''),
                                    '7fe1xx79': ('SL', '1', 'Unknown', ''),
                                    '7fe1xx83': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx84': ('LO', '1', 'Unknown', ''),
                                    '7fe1xx85': ('SQ', '1', 'Unknown', ''),
                                    '7fe1xx86': ('SL', '4', 'Unknown', ''),
                                    '7fe1xx87': ('FD', '4', 'Unknown', ''),
                                    '7fe1xx88': ('FD', '1', 'Unknown', '')},
 'GEMS_VXTLSTATE_001': {'0057xx05': ('SQ', '1', 'Volumes_info', ''),
                        '0057xx06': ('SQ', '1', 'Image_UIDs', ''),
                        '0057xx07': ('DT', '1', 'SUV_ScanTime', ''),
                        '0057xx08': ('DT', '1', 'SUV_AdministredTime', ''),
                        '0057xx09': ('DT', '1', 'SUV_MeasuredTime', ''),
                        '0057xx10': ('DT', '1', 'SUV_PostInjectedTime', ''),
                        '0057xx11': ('FL', '1', 'SUV_TracerActivity', ''),
                        '0057xx12': ('FL',
                                     '1',
                                     'SUV_PostInjectedActivity',
                                     ''),
                        '0057xx13': ('FL', '1', 'SUV_HalfLife', ''),
                        '0057xx14': ('LO', '1', 'SState_Version', ''),
                        '0057xx15': ('SQ', '1', 'SegList_Seq', ''),
                        '0057xx16': ('IS', '1', 'SegList_Count', ''),
                        '0057xx17': ('OB', '1', 'SegList_List', ''),
                        '0057xx18': ('LO', '1', 'SegList_Name', ''),
                        '0057xx19': ('LO', '1', 'Volume_Filename', ''),
                        '0057xx20': ('LO', '1', 'SegList_Label', ''),
                        '0057xx21': ('SQ', '1', 'Bookmark_Seq', ''),
                        '0057xx22': ('LT', '1', 'Bookmark', ''),
                        '0057xx23': ('FL', '3', 'Cursor_position', ''),
                        '0057xx24': ('UL', '3-n', 'Color_Value_Field', ''),
                        '0057xx25': ('IS', '1', 'Count', ''),
                        '0057xx26': ('SQ', '1', 'Views_info', ''),
                        '0057xx27': ('LT', '1', 'View_Slot', ''),
                        '0057xx28': ('IS', '1', 'Wireframe_Size', ''),
                        '0057xx29': ('UT', '1', 'Wireframe', ''),
                        '0057xx30': ('IS', '1', 'Annotation_Size', ''),
                        '0057xx31': ('LT', '1', 'Annotation', ''),
                        '0057xx32': ('IS', '1', 'Slider_State', ''),
                        '0057xx33': ('LO', '1', 'Proto_Name', ''),
                        '0057xx34': ('LO', '1', 'Proto_Title', ''),
                        '0057xx35': ('LO', '1', 'Proto_FilmName', ''),
                        '0057xx36': ('LO', '1', 'Proto_Step', ''),
                        '0057xx38': ('LT', '1', 'SegList_Slots', ''),
                        '0057xx39': ('IS', '1', 'VT_Points_Size', ''),
                        '0057xx40': ('LT', '1', 'VT_Points', ''),
                        '0057xx41': ('IS', '1', 'VT_Meas_Size', ''),
                        '0057xx42': ('LT', '1', 'VT_Meas', ''),
                        '0057xx43': ('IS', '1', 'VT_Tree_Size', ''),
                        '0057xx44': ('UT', '1', 'VT_Tree', ''),
                        '0057xx46': ('IS', '1', 'VT_Preset_Size', ''),
                        '0057xx47': ('LT', '1', 'VT_Preset', ''),
                        '0057xx48': ('IS', '1', 'VT_State_Size', ''),
                        '0057xx49': ('LT', '1', 'VT_State', ''),
                        '0057xx50': ('IS', '1', 'Preferences_Size', ''),
                        '0057xx51': ('LT', '1', 'Preferences', ''),
                        '0057xx52': ('IS', '1', 'Volume_ZComb_Filter', ''),
                        '0057xx53': ('IS', '1', 'HTML_Page_Size', ''),
                        '0057xx54': ('LT', '1', 'HTML_Page', ''),
                        '0057xx55': ('FL', '3', 'Camera_Position', ''),
                        '0057xx56': ('IS', '1', 'Slider_Size', ''),
                        '0057xx57': ('LT', '1', 'Slider', ''),
                        '0057xx58': ('LO', '1', 'SegList_Pretty_Name', '')},
 'GEMS_VXTL_USERDATA_01': {'0047xx11': ('LT', '1', 'Unknown', '')},
 'GEMS_XELPRV_01': {'0033xx08': ('CS', '1', 'Object Type', ''),
                    '0033xx10': ('SL', '1', 'Modified', ''),
                    '0033xx11': ('LO', '1', 'Name', ''),
                    '0033xx14': ('LO', '1', 'StudyId', ''),
                    '0033xx16': ('LO', '1', 'ProtocolDataUID', ''),
                    '0033xx17': ('SH', '1', 'Date', ''),
                    '0033xx18': ('SH', '1', 'Time', ''),
                    '0033xx19': ('UL', '1', 'ProtocoldataFlags', ''),
                    '0033xx1a': ('LO', '1', 'ProtocolName', ''),
                    '0033xx1b': ('LO', '1', 'StudyId', ''),
                    '0033xx1c': ('OB', '1', 'BulkData', ''),
                    '0033xx1d': ('SL', '1-n', 'IntData', ''),
                    '0033xx1e': ('FD', '1-n', 'DoubleData', ''),
                    '0033xx1f': ('OB', '1', 'StringData', ''),
                    '0033xx20': ('OB', '1', 'BulkDataFormat', ''),
                    '0033xx21': ('OB', '1', 'IntDataFormat', ''),
                    '0033xx22': ('OB', '1', 'DoubleDataFormat', ''),
                    '0033xx23': ('OB', '1', 'StringDataFormat', ''),
                    '0033xx24': ('LT', '1', 'Description', ''),
                    '0033xx28': ('LO', '1', 'RTName', ''),
                    '0033xx29': ('LT', '1', 'RTSpecification', ''),
                    '0033xx2a': ('UL', '1', 'ReviewTemplatesFlags', ''),
                    '0033xx2b': ('LT', '1', 'DataValidationSpec', ''),
                    '0033xx2c': ('LT', '1', 'Description', ''),
                    '0033xx2d': ('LT', '1', 'IconDescription', ''),
                    '0033xx50': ('SQ', '1', 'ProtocoldataSQ', ''),
                    '0033xx51': ('UI', '1', 'PDOSOPClassUID', ''),
                    '0033xx52': ('UI', '1', 'PDOSOPInstanceUID', ''),
                    '0033xx60': ('SQ', '1', 'ReviewtemplateSQ', ''),
                    '0033xx61': ('UI', '1', 'RTOSOPClassUID', ''),
                    '0033xx62': ('UI', '1', 'RTOSOPInstanceUID', ''),
                    '0033xx70': ('SQ', '1', 'SeriesdataSQ', ''),
                    '0033xx71': ('UI', '1', 'SDOSOPClassUID', ''),
                    '0033xx72': ('UI', '1', 'SDOSOPInstanceUID', ''),
                    '0033xx73': ('SQ', '1', 'SDODoubleDataSQ', ''),
                    '0057xx01': ('SQ', '1', 'ROISQ', ''),
                    '0057xx02': ('UI', '1', 'SOPClassUID', ''),
                    '0057xx03': ('UI', '1', 'SOPInstanceUID', ''),
                    '0057xx10': ('IS', '1', 'ROINumber', ''),
                    '0057xx11': ('UI', '1', 'Dimentions', ''),
                    '0057xx12': ('UI', '1', 'Points', ''),
                    '0057xx13': ('UI', '1', 'Type', ''),
                    '0057xx14': ('UI', '1', 'Description', ''),
                    '0057xx15': ('UI', '1', 'Data value Representation', ''),
                    '0057xx16': ('UI', '1', 'Label', ''),
                    '0057xx17': ('UI', '1', 'Data', ''),
                    '0057xx41': ('SL', '1', 'Modified', ''),
                    '0057xx42': ('LO', '1', 'Name', ''),
                    '0057xx43': ('SL', '1', 'Rid', ''),
                    '0057xx45': ('LO', '1', 'SOPClassUID', ''),
                    '0057xx46': ('LO', '1', 'SOPInstanceUID', ''),
                    '0057xx47': ('LO', '1', 'Normal Colour', ''),
                    '0057xx48': ('LT', '1', 'NameFont', ''),
                    '0057xx49': ('SL', '1', 'FillPattern', ''),
                    '0057xx4a': ('SL', '1', 'LineStyle', ''),
                    '0057xx4b': ('SL', '1', 'LineDashLength', ''),
                    '0057xx4c': ('SL', '1', 'LineThickness', ''),
                    '0057xx4d': ('SL', '1', 'Interactivity', ''),
                    '0057xx4e': ('SL', '1', 'NamePos', ''),
                    '0057xx4f': ('SL', '1', 'NameDisplay', ''),
                    '0057xx50': ('LO', '1', 'Label', ''),
                    '0057xx51': ('SL', '1-n', 'BpSeg', ''),
                    '0057xx52': ('US', '1-n', 'BpSegpairs', ''),
                    '0057xx53': ('SL', '1', 'SeedSpace', ''),
                    '0057xx54': ('FD', '1-n', 'Seeds', ''),
                    '0057xx55': ('SL', '1-n', 'Shape', ''),
                    '0057xx56': ('FD', '1-n', 'ShapeTilt', ''),
                    '0057xx59': ('SL', '1-n', 'ShapePtsSpace', ''),
                    '0057xx5a': ('SL', '1-n', 'ShapeCtrlPtsCount', ''),
                    '0057xx5b': ('FD', '1-n', 'Shap CtrlPts', ''),
                    '0057xx5c': ('SL', '1', 'ShapeCPSpace', ''),
                    '0057xx5d': ('UL', '1-n', 'ROIFlags', ''),
                    '0057xx5e': ('UL', '1', 'FrameNumber', ''),
                    '0057xx60': ('LO', '1-n', 'DatasetROIMapping', '')},
 'GEMS_XR3DCAL_01': {'0021xx01': ('IS', '1', '3Dcal image rows', ''),
                     '0021xx02': ('IS', '1', '3Dcal image columns', ''),
                     '0021xx03': ('FL', '1', '3Dcal field of view', ''),
                     '0021xx04': ('DA', '1', '3Dcal acquisition date', ''),
                     '0021xx05': ('TM', '1', '3Dcal acquisition time', ''),
                     '0021xx06': ('DA',
                                  '1',
                                  '3Dcal calibration processing date',
                                  ''),
                     '0021xx07': ('TM',
                                  '1',
                                  '3Dcal calibration processing time',
                                  ''),
                     '0021xx08': ('FL', '1', '3Dcal L arm angle', ''),
                     '0021xx09': ('FL',
                                  '1-n',
                                  '3Dcal Pivot angle vector',
                                  ''),
                     '0021xx0a': ('FL', '1', '3Dcal C arm angle', ''),
                     '0021xx0b': ('SQ', '1', '3Dcal matrix sequence', ''),
                     '0021xx0c': ('LO', '1-n', '3Dcal matrix elements', ''),
                     '0021xx0d': ('LO', '1', '3Dcal algorithm version', ''),
                     '0021xx0e': ('FL', '1', '3Dcal 3D frame unit size', ''),
                     '0021xx0f': ('LO', '1', '3Dcal calibration mode', ''),
                     '0021xx10': ('FL',
                                  '1',
                                  '3Dcal image frame origin row',
                                  ''),
                     '0021xx11': ('FL',
                                  '1',
                                  '3Dcal image frame origin column',
                                  ''),
                     '0021xx12': ('IS',
                                  '1',
                                  '3Dcal positioner pivot rotation speed',
                                  ''),
                     '0021xx13': ('IS', '1', '3Dcal number of images', ''),
                     '0021xx14': ('UI', '1', '3Dcal Instance UID', ''),
                     '0021xx15': ('FL', '2', '3Dcal image pixel spacing', ''),
                     '0021xx16': ('CS', '1', '3Dcal centering mode', '')},
 'GEMS_YMHD_01': {'0033xx05': ('UN', '1', 'Unknown', ''),
                  '0033xx06': ('UN', '1', 'Unknown', '')},
 'GE_GENESIS_REV3.0': {'0019xx39': ('SS', '1', 'Axial Type', ''),
                       '0019xx8f': ('SS',
                                    '1',
                                    'Swap Phase / Frequency Axis',
                                    ''),
                       '0019xx9c': ('SS', '1', 'Pulse Sequence Name', ''),
                       '0019xx9f': ('SS', '1', 'Coil Type', ''),
                       '0019xxa4': ('SS', '1', 'SAT fat/water/none', ''),
                       '0019xxc0': ('SS',
                                    '1',
                                    'Bitmap of SAT Selections',
                                    ''),
                       '0019xxc1': ('SS',
                                    '1',
                                    'Surfacel Coil Iintensity Correction Flag',
                                    ''),
                       '0019xxcb': ('SS',
                                    '1',
                                    'Phase Contrast Flow Axis',
                                    ''),
                       '0019xxcc': ('SS',
                                    '1',
                                    'Phase Contrast Velocity Encoding',
                                    ''),
                       '0019xxd5': ('SS', '1', 'Fractional Echo', ''),
                       '0019xxd8': ('SS', '1', 'Variable Echo Flag', ''),
                       '0019xxd9': ('DS', '1', 'Concatenated Sat', ''),
                       '0019xxf2': ('SS', '1', 'Number of Phases', ''),
                       '0043xx1e': ('DS', '1', 'Delta Start Time', ''),
                       '0043xx27': ('SH', '1', 'Pitch Ratio', '')},
 'GE_GROUP': {'6005xx10': ('UT', '1', 'Unknown', '')},
 'HMC - CT - ID': {'0009xx00': ('UN',
                                '1',
                                'Image ID Information (e.g. Patient Name, Patient ID)',
                                ''),
                   '0009xx01': ('UN',
                                '1',
                                'Image ID Information (e.g. Patient Comment)',
                                '')},
 'HOLOGIC': {'0011xx00': ('LO', '1', 'Hx Questionnaire', ''),
             '0021xx01': ('LT', '1', 'Image Analysis Data in XML', ''),
             '0023xx00': ('LO', '1', 'Encoding Scheme Version', ''),
             '0023xx01': ('LO', '1', 'P File Name', ''),
             '0023xx02': ('OB', '1', 'P File Data', ''),
             '0023xx03': ('UL', '1', 'P File Length', ''),
             '0023xx04': ('OB', '1', 'R File Data', ''),
             '0023xx05': ('UL', '1', 'R File Length', '')},
 'HOLOGIC, Inc.': {'0019xx06': ('LO', '1', 'Unknown', ''),
                   '0019xx07': ('SH', '1', 'Unknown', ''),
                   '0019xx08': ('LO', '1', 'Unknown', ''),
                   '0019xx16': ('DS', '1', 'Unknown', ''),
                   '0019xx26': ('LO', '1', 'Unknown', ''),
                   '0019xx27': ('SH', '1', 'Unknown', ''),
                   '0019xx28': ('LO', '1', 'Unknown', ''),
                   '0019xx29': ('LO', '1', 'Unknown', ''),
                   '0019xx30': ('US', '1', 'Unknown', ''),
                   '0019xx31': ('US', '1', 'Unknown', ''),
                   '0019xx32': ('US', '1', 'Unknown', ''),
                   '0019xx33': ('US', '1', 'Unknown', ''),
                   '0019xx34': ('US', '1', 'Unknown', ''),
                   '0019xx35': ('US', '1', 'Unknown', ''),
                   '0019xx37': ('LO', '1', 'Unknown', ''),
                   '0019xx40': ('DS', '1', 'Unknown', ''),
                   '0019xx41': ('DS', '1', 'Unknown', ''),
                   '0019xx42': ('IS', '1', 'Unknown', ''),
                   '0019xx43': ('IS', '1', 'Unknown', ''),
                   '0019xx44': ('IS', '1', 'Unknown', ''),
                   '0019xx45': ('IS', '1', 'Unknown', ''),
                   '0019xx46': ('IS', '1', 'Unknown', ''),
                   '0019xx70': ('DS', '1', 'Unknown', ''),
                   '0019xx85': ('IS', '1', 'Unknown', ''),
                   '0019xx90': ('DS', '1', 'Unknown', ''),
                   '7e01xx01': ('LO', '1', 'Unknown', ''),
                   '7e01xx02': ('LO', '1', 'Unknown', ''),
                   '7e01xx10': ('SQ', '1', 'Unknown', ''),
                   '7e01xx11': ('SQ', '1', 'Unknown', ''),
                   '7e01xx12': ('OB', '1', 'Unknown', ''),
                   '7f01xx01': ('LO', '1', 'Unknown', ''),
                   '7f01xx02': ('SH', '1', 'Unknown', ''),
                   '7f01xx10': ('SQ', '1', 'Unknown', ''),
                   '7f01xx12': ('OB', '1', 'Unknown', '')},
 'Hologic': {'0011xx00': ('LO', '1', 'Hx Questionnaire', ''),
             '0021xx01': ('LT', '1', 'Image Analysis Data in XML', ''),
             '0023xx00': ('LO', '1', 'Encoding Scheme Version', ''),
             '0023xx01': ('LO', '1', 'P File Name', ''),
             '0023xx02': ('OB', '1', 'P File Data', ''),
             '0023xx03': ('UL', '1', 'P File Length', ''),
             '0023xx04': ('OB', '1', 'R File Data', ''),
             '0023xx05': ('UL', '1', 'R File Length', '')},
 'IDEXX': {'0011xx00': ('LO', '1', 'Breed Name', ''),
           '0011xx01': ('LO', '1', 'Species Name', ''),
           '0011xx02': ('PN', '1', 'Owner', '')},
 'IMS s.r.l. Biopsy Private Code': {'1269xx01': ('IS',
                                                 '1',
                                                 'Biopsy Image',
                                                 ''),
                                    '1269xx10': ('IS',
                                                 '1-n',
                                                 'Biopsy Markers X',
                                                 ''),
                                    '1269xx11': ('IS',
                                                 '1-n',
                                                 'Biopsy Markers Y',
                                                 ''),
                                    '1269xx12': ('IS',
                                                 '1',
                                                 'Biopsy Markers Number',
                                                 ''),
                                    '1269xx20': ('IS',
                                                 '1',
                                                 'Biopsy Area Left Border',
                                                 ''),
                                    '1269xx21': ('IS',
                                                 '1',
                                                 'Biopsy Area Right Border',
                                                 ''),
                                    '1269xx22': ('IS',
                                                 '1',
                                                 'Biopsy Area Top Border',
                                                 ''),
                                    '1269xx23': ('IS',
                                                 '1',
                                                 'Biopsy Area Bottom Border',
                                                 '')},
 'IMS s.r.l. Mammography Private Code': {'1271xx01': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx02': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx10': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx11': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx12': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx13': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx20': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx21': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx22': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx38': ('LO',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx39': ('US',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx40': ('US',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx41': ('LO',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx42': ('LT',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx45': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx46': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx47': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx48': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx49': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx50': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx51': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx52': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx53': ('LO',
                                                      '1',
                                                      'Unknown',
                                                      ''),
                                         '1271xx54': ('IS',
                                                      '1',
                                                      'Unknown',
                                                      '')},
 'INFINITT_FMX': {'0015xx10': ('LO', '1', 'Unknown', ''),
                  '0015xx11': ('LO', '1', 'Unknown', '')},
 'INTEGRIS 1.0': {'0009xx08': ('CS', '1', 'Exposure Channel', ''),
                  '0009xx32': ('TM', '1', 'Exposure Start Time', ''),
                  '0019xx00': ('LO', '1', 'APR Name', ''),
                  '0019xx40': ('DS', '1', 'Frame Rate', ''),
                  '0021xx12': ('IS', '1', 'Exposure Number', ''),
                  '0029xx00': ('SQ', '1', 'Edge Enhancement Sequence', ''),
                  '0029xx01': ('US', '2', 'Convolution Kernel Size', ''),
                  '0029xx02': ('US',
                               '1-n',
                               'Convolution Kernel Coefficients',
                               ''),
                  '0029xx03': ('FL', '1', 'Edge Enhancement Gain', ''),
                  '0029xx08': ('IS', '1', 'Number of Exposure Results', ''),
                  '0041xx20': ('DS', '1', 'Accumulated Fluoroscopy Dose', ''),
                  '0041xx30': ('DS', '1', 'Accumulated Exposure Dose', ''),
                  '0041xx40': ('DS', '1', 'Total Dose', ''),
                  '0041xx41': ('US', '1', 'Total Number of Frames', ''),
                  '0041xx50': ('SQ',
                               '1',
                               'Exposure Information Sequence',
                               '')},
 'INTELERAD MEDICAL SYSTEMS': {'3f01xx01': ('LO',
                                            '1',
                                            'Institution Code',
                                            ''),
                               '3f01xx02': ('LO',
                                            '1',
                                            'Routed Transfer AE',
                                            ''),
                               '3f01xx03': ('LO', '1', 'Source AE', ''),
                               '3f01xx04': ('LO',
                                            '1',
                                            'Deferred Validation',
                                            ''),
                               '3f01xx05': ('LO', '1', 'Series Owner', '')},
 'ISG shadow': {'0029xx70': ('IS', '1', 'Unknown', ''),
                '0029xx80': ('IS', '1', 'Unknown', ''),
                '0029xx90': ('IS', '1', 'Unknown', '')},
 'ISI': {'0009xx01': ('SQ', '1', 'SIENET General Purpose IMGF', '')},
 'Image (ID, Version, Size, Dump, GUID)': {'8003xx00': ('LO', '1', 'ID', ''),
                                           '8003xx10': ('LO',
                                                        '1',
                                                        'Version',
                                                        ''),
                                           '8003xx20': ('UL',
                                                        '1',
                                                        'Size',
                                                        ''),
                                           '8003xx30': ('OB',
                                                        '1',
                                                        'Dump',
                                                        ''),
                                           '8003xx40': ('LO',
                                                        '1',
                                                        'GUID',
                                                        '')},
 'Imaging Dynamics Company Ltd.': {'4321xx05': ('UN', '1', 'Custom Tag', ''),
                                   '4321xx10': ('UN', '1', 'Custom Tag', ''),
                                   '4321xx41': ('CS', '1', 'Unknown', ''),
                                   '4321xx42': ('US', '1', 'Unknown', ''),
                                   '4321xx50': ('DS', '1', 'Custom Tag', ''),
                                   '4321xx51': ('DS', '1', 'Custom Tag', ''),
                                   '4321xx64': ('LO', '1', 'Custom Tag', '')},
 'KINETDX': {'0021xxa5': ('US', '1', 'Unknown', ''),
             '0021xxa8': ('LO', '1', 'Unknown', ''),
             '0021xxaa': ('OB', '1', 'Unknown', '')},
 'KINETDX_GRAPHICS': {'0021xxa4': ('LT', '1', 'Unknown', '')},
 'KRETZ_US': {'7fe1xx01': ('OB', '1', 'Unknown', '')},
 'Kodak Image Information': {'0029xx15': ('LO', '1', 'Unknown', ''),
                             '0029xx16': ('LO', '1', 'Unknown', ''),
                             '0029xx17': ('LO', '1', 'Unknown', ''),
                             '0029xx18': ('UT', '1', 'Unknown', ''),
                             '0029xx19': ('IS', '1', 'Unknown', ''),
                             '0029xx1a': ('IS', '1', 'Unknown', '')},
 'LODOX_STATSCAN': {'0019xx01': ('IS', '1-n', 'Unknown', ''),
                    '0019xx02': ('IS', '1', 'Unknown', ''),
                    '0019xx03': ('DS', '1', 'Unknown', ''),
                    '0019xx04': ('DS', '1', 'Unknown', ''),
                    '0019xx05': ('DS', '1', 'Unknown', ''),
                    '0019xx06': ('DS', '1', 'Unknown', ''),
                    '0019xx07': ('DS', '1', 'Unknown', ''),
                    '0019xx08': ('DS', '1', 'Unknown', '')},
 'LORAD Selenia': {'0019xx06': ('OB', '1', 'Paddle ID', ''),
                   '0019xx07': ('OB', '1', 'Paddle Position', ''),
                   '0019xx08': ('OB', '1', 'Collimation Size', ''),
                   '0019xx26': ('OB', '1', 'Unknown', ''),
                   '0019xx27': ('OB', '1', 'Unknown', ''),
                   '0019xx28': ('OB', '1', 'Unknown', ''),
                   '0019xx29': ('OB', '1', 'Unknown', ''),
                   '0019xx30': ('OB', '1', 'Unknown', ''),
                   '0019xx31': ('OB', '1', 'Unknown', ''),
                   '0019xx32': ('OB', '1', 'Unknown', ''),
                   '0019xx33': ('OB', '1', 'Unknown', ''),
                   '0019xx34': ('OB', '1', 'Unknown', ''),
                   '0019xx35': ('OB', '1', 'Unknown', ''),
                   '0019xx40': ('OB', '1', 'Unknown', ''),
                   '0019xx41': ('OB', '1', 'Unknown', ''),
                   '0019xx50': ('OB', '1', 'Unknown', ''),
                   '0019xx51': ('OB', '1', 'Unknown', ''),
                   '0019xx52': ('OB', '1', 'Unknown', ''),
                   '0019xx53': ('OB', '1', 'Unknown', ''),
                   '0019xx70': ('OB', '1', 'Unknown', ''),
                   '0019xx71': ('OB', '1', 'Unknown', '')},
 'MAROTECH Inc.': {'0037xx01': ('LO', '1', 'Some kind of version number', ''),
                   '0037xx21': ('US', '1', 'Icon Row', ''),
                   '0037xx22': ('US', '1', 'Icon Col', ''),
                   '0037xx23': ('OB', '1', 'JPEG Compressed Icon', '')},
 'MDS NORDION OTP ANATOMY MODELLING': {'3005xx00': ('SQ', '1', 'Unknown', ''),
                                       '3005xx02': ('CS', '1', 'Unknown', ''),
                                       '3005xx04': ('DS', '1', 'Unknown', ''),
                                       '3005xx06': ('DS', '1', 'Unknown', ''),
                                       '3005xx08': ('DS', '1', 'Unknown', ''),
                                       '3005xx0a': ('CS', '1', 'Unknown', ''),
                                       '3005xx0c': ('CS', '1', 'Unknown', ''),
                                       '3005xx0e': ('CS', '1', 'Unknown', ''),
                                       '3005xx10': ('DS', '1', 'Unknown', ''),
                                       '3005xx12': ('DS', '1', 'Unknown', '')},
 'MEDIFACE': {'0021xx01': ('UN', '1', 'Unknown', ''),
              '0021xx10': ('UN', '1', 'Unknown', ''),
              '0021xx11': ('UN', '1', 'Unknown', ''),
              '0021xx12': ('UN', '1', 'Unknown', ''),
              '0021xx21': ('UN', '1', 'Unknown', ''),
              '0021xx22': ('UN', '1', 'Unknown', ''),
              '0021xx30': ('UN', '1', 'Unknown', ''),
              '0021xx31': ('UN', '1', 'Unknown', ''),
              '0021xx40': ('UN', '1', 'Unknown', ''),
              '0021xx41': ('UN', '1', 'Unknown', ''),
              '0021xx42': ('UN', '1', 'Unknown', ''),
              '0021xx50': ('UN', '1', 'Unknown', ''),
              '0021xx51': ('UN', '1', 'Unknown', ''),
              '0021xx52': ('UN', '1', 'Unknown', ''),
              '0021xx60': ('UN', '1', 'Unknown', ''),
              '0021xxf1': ('UN', '1', 'Unknown', ''),
              '0021xxf2': ('UN', '1', 'Unknown', ''),
              '0029xx01': ('UL', '1', 'Unknown', ''),
              '0029xx10': ('DS', '1', 'Window Center', ''),
              '0029xx11': ('DS', '1', 'Window Width', ''),
              '0029xx20': ('DS', '1', 'Unknown', ''),
              '0029xx21': ('UL', '1', 'Unknown', ''),
              '0029xx22': ('DS', '2', 'Unknown', ''),
              '0029xx30': ('LT', '1', 'Unknown', '')},
 'MERGE TECHNOLOGIES, INC.': {'0009xx00': ('OB', '1', 'Unknown', '')},
 'MITRA LINKED ATTRIBUTES 1.0': {'0031xx20': ('IS', '1', 'Unknown', '')},
 'MITRA MARKUP 1.0': {'0029xx00': ('LO', '1-n', 'Unknown', ''),
                      '0029xx01': ('LO', '1-n', 'Unknown', '')},
 'MITRA OBJECT ATTRIBUTES 1.0': {'0033xx02': ('LO', '1', 'Unknown', ''),
                                 '0033xx04': ('LO', '1', 'Unknown', ''),
                                 '0033xx06': ('LO', '1', 'Unknown', ''),
                                 '0033xx08': ('LO', '1', 'Unknown', ''),
                                 '0033xx0a': ('LO', '1', 'Unknown', '')},
 'MITRA OBJECT DOCUMENT 1.0': {'0029xx00': ('OB', '1', 'Unknown', '')},
 'MITRA OBJECT UTF8 ATTRIBUTES 1.0': {'0033xx02': ('OB', '1', 'Unknown', ''),
                                      '0033xx04': ('CS',
                                                   '1',
                                                   'Study Description',
                                                   ''),
                                      '0033xx06': ('OB', '1', 'Unknown', ''),
                                      '0033xx08': ('OB', '1', 'Unknown', ''),
                                      '0033xx0a': ('OB', '1', 'Unknown', ''),
                                      '0033xx0c': ('LO',
                                                   '1',
                                                   'Reason for Study',
                                                   ''),
                                      '0033xx0e': ('OB', '1', 'Unknown', ''),
                                      '0033xx13': ('PN',
                                                   '1',
                                                   "Patient's Name",
                                                   ''),
                                      '0033xx14': ('OB', '1', 'Unknown', ''),
                                      '0033xx15': ('OB', '1', 'Unknown', ''),
                                      '0033xx16': ('OB', '1', 'Unknown', ''),
                                      '0033xx19': ('PN',
                                                   '1',
                                                   "Referring Physician's Name",
                                                   '')},
 'MITRA PRESENTATION 1.0': {'0029xx00': ('LO', '1', 'Unknown', ''),
                            '0029xx01': ('UN', '1', 'Unknown', ''),
                            '0029xx02': ('UN', '1', 'Unknown', ''),
                            '0029xx03': ('LO', '1', 'Unknown', '')},
 'MMCPrivate': {'0009xx48': ('LO', '1', 'Unknown', ''),
                '0009xx4e': ('LO', '1', 'Unknown', ''),
                '0011xx01': ('LO', '1', 'Unknown', ''),
                '0019xx01': ('LO', '1', 'Unknown', ''),
                '0019xx02': ('LO', '1', 'Unknown', ''),
                '0019xx03': ('SH', '1', 'Unknown', ''),
                '0019xx04': ('DS', '1', 'Unknown', ''),
                '0019xx05': ('LO', '1', 'Unknown', ''),
                '0019xx08': ('DS', '1', 'Unknown', ''),
                '0019xx09': ('DS', '1', 'Unknown', ''),
                '0019xx0a': ('LO', '1', 'Unknown', ''),
                '0019xx0b': ('DS', '1', 'Unknown', ''),
                '0019xx0c': ('LO', '1', 'Unknown', ''),
                '0019xx0f': ('IS', '1', 'Unknown', ''),
                '0019xx10': ('LO', '1', 'Unknown', ''),
                '0029xx01': ('IS', '1', 'Unknown', ''),
                '0029xx02': ('IS', '1', 'Unknown', ''),
                '0029xx05': ('LO', '1', 'Unknown', ''),
                '0029xx06': ('LO', '1', 'Unknown', ''),
                '0029xx08': ('LO', '1', 'Unknown', ''),
                '0029xx09': ('LO', '1', 'Unknown', ''),
                '0029xx0a': ('LO', '1', 'Unknown', ''),
                '0029xx0b': ('LO', '1', 'Unknown', ''),
                '0029xx0c': ('LO', '1', 'Unknown', ''),
                '0029xx0d': ('LO', '1', 'Unknown', ''),
                '0029xx0e': ('LO', '1', 'Unknown', ''),
                '0029xx0f': ('LO', '1', 'Unknown', ''),
                '0029xx10': ('LO', '1', 'Unknown', ''),
                '0029xx11': ('LO', '1', 'Unknown', ''),
                '0029xx12': ('LO', '1', 'Unknown', ''),
                '0029xx13': ('LO', '1', 'Unknown', ''),
                '0029xx14': ('LO', '1', 'Unknown', ''),
                '0029xx15': ('LO', '1', 'Unknown', ''),
                '0029xx16': ('LO', '1', 'Unknown', ''),
                '0029xx17': ('LO', '1', 'Unknown', ''),
                '0029xx18': ('LO', '1', 'Unknown', ''),
                '0029xx1c': ('LO', '1', 'Unknown', ''),
                '0029xx20': ('IS', '1', 'Unknown', ''),
                '0029xx21': ('DS', '1', 'Unknown', ''),
                '0029xx22': ('ST', '1', 'Unknown', ''),
                '0029xx23': ('LO', '1', 'Unknown', ''),
                '0029xx24': ('DS', '1', 'Unknown', ''),
                '0029xx25': ('DS', '1', 'Unknown', ''),
                '0029xx26': ('DS', '1', 'Unknown', ''),
                '0029xx27': ('DS', '1', 'Unknown', ''),
                '0029xx28': ('DS', '1', 'Unknown', ''),
                '0029xx29': ('DS', '1', 'Unknown', ''),
                '0029xx2a': ('DS', '1', 'Unknown', ''),
                '0029xx2b': ('DS', '1', 'Unknown', ''),
                '0029xx2c': ('DS', '1', 'Unknown', ''),
                '0029xx2d': ('DS', '1', 'Unknown', ''),
                '0029xx2e': ('DS', '1', 'Unknown', ''),
                '0029xx2f': ('OB', '1', 'Unknown', '')},
 'Mayo/IBM Archive Project': {'0021xx01': ('UN', '1', 'Unknown', ''),
                              '0021xx10': ('UN', '1', 'Unknown', ''),
                              '0021xx11': ('UN', '1', 'Unknown', ''),
                              '0021xx12': ('UN', '1', 'Unknown', ''),
                              '0021xx13': ('UN', '1', 'Unknown', ''),
                              '0021xx14': ('UN', '1', 'Unknown', ''),
                              '0021xx15': ('UN', '1', 'Unknown', ''),
                              '0021xx16': ('UN', '1', 'Unknown', ''),
                              '0021xx17': ('UN', '1', 'Unknown', ''),
                              '0021xx18': ('UN', '1', 'Unknown', ''),
                              '0021xx19': ('UN', '1', 'Unknown', ''),
                              '0021xx1a': ('UN', '1', 'Unknown', ''),
                              '0021xx1b': ('UN', '1', 'Unknown', ''),
                              '0021xx1c': ('UN', '1', 'Unknown', ''),
                              '0021xx1d': ('UN', '1', 'Unknown', ''),
                              '0021xx1e': ('UN', '1', 'Unknown', ''),
                              '0021xx1f': ('UN', '1', 'Unknown', ''),
                              '0021xx20': ('UN', '1', 'Unknown', ''),
                              '0021xx40': ('UN', '1', 'Unknown', ''),
                              '0021xx41': ('UN', '1', 'Unknown', ''),
                              '0021xx50': ('UN', '1', 'Unknown', ''),
                              '0021xx60': ('UN', '1', 'Unknown', ''),
                              '0021xx65': ('UN', '1', 'Unknown', '')},
 'MeVis BreastCare': {'0019xx01': ('LO', '1', 'Unknown', ''),
                      '0071xx01': ('LO', '1', 'Unknown', '')},
 'MeVis eD: Geometry Information': {'0009xx11': ('UN',
                                                 '1',
                                                 'GeoScannerOrigin',
                                                 ''),
                                    '0009xx21': ('UN', '1', 'SlicesID', '')},
 'MeVis eD: Slice Information': {'0009xx10': ('UN',
                                              '1',
                                              'SlicesSOPInstanceUID',
                                              '')},
 'MeVis eD: Timepoint Information': {'0009xx10': ('UN',
                                                  '1',
                                                  'TPDateTime',
                                                  ''),
                                     '0009xx11': ('UN',
                                                  '1',
                                                  'TPDateTimeType',
                                                  ''),
                                     '0009xx12': ('UN',
                                                  '1',
                                                  'TPSeriesDescription',
                                                  ''),
                                     '0009xx13': ('UN',
                                                  '1',
                                                  'TPGradientDirections',
                                                  ''),
                                     '0009xx21': ('UN',
                                                  '1',
                                                  'GeometryID',
                                                  '')},
 'MeVis eatDicom': {'0009xx10': ('UN', '1', 'EatDicomVersion', ''),
                    '0009xx11': ('UN', '1', 'EatDicomOptions', ''),
                    '0009xx21': ('UN', '1', 'TimepointsID', '')},
 'MedIns HP Extensions': {'5473xx03': ('LO', '1', 'Unknown', '')},
 'Mitra Markup 1.0': {'0029xx00': ('OB', '1-n', 'Markup1', ''),
                      '0029xx01': ('OB', '1-n', 'Markup2', ''),
                      '0029xx02': ('OB', '1-n', 'Markup3', ''),
                      '0029xx03': ('OB', '1-n', 'Markup4', ''),
                      '0029xx04': ('OB', '1-n', 'Markup5', ''),
                      '0029xx05': ('OB', '1-n', 'Markup6', ''),
                      '0029xx06': ('OB', '1-n', 'Markup7', ''),
                      '0029xx07': ('OB', '1-n', 'Markup8', ''),
                      '0029xx08': ('OB', '1-n', 'Markup9', ''),
                      '0029xx09': ('OB', '1-n', 'Markup10', ''),
                      '0029xx10': ('OB', '1-n', 'Markup11', ''),
                      '0029xx11': ('OB', '1-n', 'Markup12', ''),
                      '0029xx12': ('OB', '1', 'Markup13', ''),
                      '0029xx13': ('OB', '1', 'Markup14', ''),
                      '0029xx14': ('OB', '1', 'Markup15', '')},
 'Mitra Object Document 1.0': {'0029xx00': ('OB',
                                            '1',
                                            'IMPAX object document',
                                            ''),
                               '0029xx10': ('OB',
                                            '1',
                                            'IMPAX markup XML stored',
                                            '')},
 'Mitra Presentation 1.0': {'0029xx00': ('CS', '1', 'Mitra Rotation', ''),
                            '0029xx01': ('LO', '1', 'Mitra Window Width', ''),
                            '0029xx02': ('LO',
                                         '1',
                                         'Mitra Window Centre',
                                         ''),
                            '0029xx03': ('IS', '1', 'Mitra Invert', ''),
                            '0029xx04': ('IS', '1', 'Mitra Has Tabstop', ''),
                            '0029xx05': ('CS', '1', 'Smooth Rotation', '')},
 'Mortara_Inc': {'1455xx00': ('OW', '1', 'ELI Interpretation Vector', ''),
                 '1455xx01': ('UN', '1', 'Custom ID', ''),
                 '1455xx02': ('UT', '1', 'Race', ''),
                 '1455xx03': ('UT', '1', 'Social Security Number', ''),
                 '1455xx04': ('UT', '1', 'Attending Physician', ''),
                 '1455xx05': ('UT', '1', 'Procedural Diagnosis', ''),
                 '1455xx06': ('UT', '1', 'Note1', ''),
                 '1455xx07': ('UT', '1', 'Note2', ''),
                 '1455xx08': ('LO', '1', 'Order Request Number', ''),
                 '1455xx10': ('LO', '1', 'Manufacturer Name', '')},
 'NUD_PRIVATE': {'7777xx02': ('UT', '1', 'Interfile', ''),
                 '7777xx05': ('IS', '1', 'Unknown', '')},
 'ObjectModel (ID, Version, Place, PlaceDescription)': {'8101xx00': ('LO',
                                                                     '1',
                                                                     'ID',
                                                                     ''),
                                                        '8101xx10': ('LO',
                                                                     '1',
                                                                     'Version',
                                                                     '')},
 'PAPYRUS': {'0009xx00': ('LT', '1', 'Original File Name', ''),
             '0009xx10': ('LT', '1', 'Original File Location', ''),
             '0009xx18': ('LT', '1', 'Data Set Identifier', ''),
             '0041xx00': ('LT', '1-n', 'Papyrus Comments', ''),
             '0041xx10': ('US', '1', 'Folder Type', ''),
             '0041xx11': ('LT', '1', 'Patient Folder Data Set ID', ''),
             '0041xx20': ('LT', '1', 'Folder Name', ''),
             '0041xx30': ('DA', '1', 'Creation Date', ''),
             '0041xx32': ('TM', '1', 'Creation Time', ''),
             '0041xx34': ('DA', '1', 'Modified Date', ''),
             '0041xx36': ('TM', '1', 'Modified Time', ''),
             '0041xx40': ('LT', '1-n', 'Owner Name', ''),
             '0041xx50': ('LT', '1', 'Folder Status', ''),
             '0041xx60': ('UL', '1', 'Number of Images', ''),
             '0041xx62': ('UL', '1', 'Number of Other', ''),
             '0041xxa0': ('LT', '1-n', 'External Folder Element DSID', ''),
             '0041xxa1': ('US',
                          '1-n',
                          'External Folder Element Data Set Type',
                          ''),
             '0041xxa2': ('LT',
                          '1-n',
                          'External Folder Element File Location',
                          ''),
             '0041xxa3': ('UL', '1-n', 'External Folder Element Length', ''),
             '0041xxb0': ('LT', '1-n', 'Internal Folder Element DSID', ''),
             '0041xxb1': ('US',
                          '1-n',
                          'Internal Folder Element Data Set Type',
                          ''),
             '0041xxb2': ('UL', '1-n', 'Internal Offset To Data Set', ''),
             '0041xxb3': ('UL', '1-n', 'Internal Offset To Image', '')},
 'PAPYRUS 3.0': {'0041xx00': ('LT', '1', 'Comments', ''),
                 '0041xx10': ('SQ', '1', 'Pointer Sequence', ''),
                 '0041xx11': ('UL', '1', 'Image Pointer', ''),
                 '0041xx12': ('UL', '1', 'Pixel Offset', ''),
                 '0041xx13': ('SQ', '1', 'Image Identifier Sequence', ''),
                 '0041xx14': ('SQ',
                              '1',
                              'External PAPYRUS-File Reference Sequence',
                              ''),
                 '0041xx15': ('US', '1', 'Number of images', ''),
                 '0041xx21': ('UI', '1', 'Referenced SOP Class UID', ''),
                 '0041xx22': ('UI', '1', 'Referenced SOP Instance UID', ''),
                 '0041xx31': ('LO', '1', 'Referenced File Name', ''),
                 '0041xx32': ('LO', '1-n', 'Referenced File Path', ''),
                 '0041xx41': ('UI',
                              '1',
                              'Referenced Image SOP Class UID',
                              ''),
                 '0041xx42': ('UI',
                              '1',
                              'Referenced Image SOP Instance UID',
                              ''),
                 '0041xx50': ('SQ', '1', 'Image Sequence', ''),
                 '60xxxx00': ('IS', '1', 'Overlay ID', ''),
                 '60xxxx01': ('LT', '1-n', 'Linked Overlays', ''),
                 '60xxxx10': ('US', '1', 'Overlay Rows', ''),
                 '60xxxx11': ('US', '1', 'Overlay Columns', ''),
                 '60xxxx40': ('LO', '1', 'Overlay Type', ''),
                 '60xxxx50': ('US', '1-n', 'Overlay Origin', ''),
                 '60xxxx60': ('LO', '1', 'Editable', ''),
                 '60xxxx70': ('LO', '1', 'Overlay Font', ''),
                 '60xxxx72': ('LO', '1', 'Overlay Style', ''),
                 '60xxxx74': ('US', '1', 'Overlay Font Size', ''),
                 '60xxxx76': ('LO', '1', 'Overlay Color', ''),
                 '60xxxx78': ('US', '1', 'Shadow Size', ''),
                 '60xxxx80': ('LO', '1', 'Fill Pattern', ''),
                 '60xxxx82': ('US', '1', 'Overlay Pen Size', ''),
                 '60xxxxa0': ('LO', '1', 'Label', ''),
                 '60xxxxa2': ('LT', '1', 'Post It Text', ''),
                 '60xxxxa4': ('US', '2', 'Anchor Point', ''),
                 '60xxxxb0': ('LO', '1', 'ROI Type', ''),
                 '60xxxxb2': ('LT', '1', 'Attached Annotation', ''),
                 '60xxxxba': ('US', '1-n', 'Contour Points', ''),
                 '60xxxxbc': ('US', '1-n', 'Mask Data', ''),
                 '60xxxxc0': ('SQ', '1', 'UIN Overlay Sequence', '')},
 'PHILIPS MR': {'0009xx10': ('LO', '1', 'SPI Release', ''),
                '0009xx12': ('LO', '1', 'Unknown', '')},
 'PHILIPS MR R5.5/PART': {'0019xx00': ('DS', '1', 'Field of View', '')},
 'PHILIPS MR R5.6/PART': {'0019xx00': ('DS', '1', 'Field of View', '')},
 'PHILIPS MR SPECTRO;1': {'0019xx01': ('US', '1', 'Unknown', ''),
                          '0019xx02': ('US', '1', 'Unknown', ''),
                          '0019xx03': ('US', '1', 'Unknown', ''),
                          '0019xx04': ('US', '1', 'Unknown', ''),
                          '0019xx05': ('US', '1', 'Unknown', ''),
                          '0019xx06': ('US', '1', 'Unknown', ''),
                          '0019xx07': ('IS', '1', 'Unknown', ''),
                          '0019xx08': ('IS', '1', 'Unknown', ''),
                          '0019xx09': ('IS', '1', 'Unknown', ''),
                          '0019xx10': ('IS', '1', 'Unknown', ''),
                          '0019xx12': ('IS', '1', 'Unknown', ''),
                          '0019xx13': ('IS', '1', 'Unknown', ''),
                          '0019xx14': ('US', '1', 'Unknown', ''),
                          '0019xx15': ('US', '1-n', 'Unknown', ''),
                          '0019xx16': ('IS', '1', 'Unknown', ''),
                          '0019xx17': ('IS', '1', 'Unknown', ''),
                          '0019xx18': ('UN', '1', 'Unknown', ''),
                          '0019xx20': ('IS', '1', 'Unknown', ''),
                          '0019xx21': ('IS', '1', 'Unknown', ''),
                          '0019xx22': ('IS', '1', 'Unknown', ''),
                          '0019xx23': ('IS', '1', 'Unknown', ''),
                          '0019xx24': ('IS', '1', 'Unknown', ''),
                          '0019xx25': ('IS', '1', 'Unknown', ''),
                          '0019xx26': ('IS', '1', 'Unknown', ''),
                          '0019xx27': ('IS', '1', 'Unknown', ''),
                          '0019xx28': ('IS', '1', 'Unknown', ''),
                          '0019xx29': ('IS', '1-n', 'Unknown', ''),
                          '0019xx31': ('US', '1', 'Unknown', ''),
                          '0019xx32': ('US', '1', 'Unknown', ''),
                          '0019xx41': ('LT', '1', 'Unknown', ''),
                          '0019xx42': ('IS', '2', 'Unknown', ''),
                          '0019xx43': ('IS', '2', 'Unknown', ''),
                          '0019xx45': ('US', '1', 'Unknown', ''),
                          '0019xx46': ('US', '1', 'Unknown', ''),
                          '0019xx47': ('IS', '1', 'Unknown', ''),
                          '0019xx48': ('IS', '1', 'Unknown', ''),
                          '0019xx49': ('US', '1', 'Unknown', ''),
                          '0019xx50': ('UN', '1', 'Unknown', ''),
                          '0019xx60': ('US', '1', 'Unknown', ''),
                          '0019xx61': ('US', '1', 'Unknown', ''),
                          '0019xx70': ('UN', '1', 'Unknown', ''),
                          '0019xx71': ('IS', '1-n', 'Unknown', ''),
                          '0019xx72': ('US', '1', 'Unknown', ''),
                          '0019xx73': ('US', '1', 'Unknown', ''),
                          '0019xx74': ('US', '1', 'Unknown', ''),
                          '0019xx76': ('US', '1', 'Unknown', ''),
                          '0019xx77': ('US', '1', 'Unknown', ''),
                          '0019xx78': ('US', '1', 'Unknown', ''),
                          '0019xx79': ('US', '1', 'Unknown', ''),
                          '0019xx80': ('IS', '1', 'Unknown', '')},
 'PHILIPS MR/LAST': {'0019xx09': ('DS', '1', 'Main Magnetic Field', ''),
                     '0019xx0e': ('IS', '1', 'Flow Compensation', ''),
                     '0019xxb1': ('IS', '1', 'Minimum RR Interval', ''),
                     '0019xxb2': ('IS', '1', 'Maximum RR Interval', ''),
                     '0019xxb3': ('IS', '1', 'Number of Rejections', ''),
                     '0019xxb4': ('IS', '1-n', 'Number of RR Intervals', ''),
                     '0019xxb5': ('IS', '1', 'Arrhythmia Rejection', ''),
                     '0019xxb7': ('IS', '1', 'Unknown', ''),
                     '0019xxc0': ('DS', '1-n', 'Unknown', ''),
                     '0019xxc6': ('IS', '1', 'Cycled Multiple Slice', ''),
                     '0019xxce': ('IS', '1', 'REST', ''),
                     '0019xxd5': ('DS', '1', 'Unknown', ''),
                     '0019xxd6': ('IS', '1', 'Fourier Interpolation', ''),
                     '0019xxd9': ('IS', '1-n', 'Unknown', ''),
                     '0019xxe0': ('IS', '1', 'Prepulse', ''),
                     '0019xxe1': ('DS', '1', 'Prepulse Delay', ''),
                     '0019xxe2': ('IS', '1', 'Unknown', ''),
                     '0019xxe3': ('DS', '1', 'Unknown', ''),
                     '0019xxe4': ('IS', '1', 'Unknown', ''),
                     '0019xxe5': ('DS', '1', 'Unknown', ''),
                     '0019xxf0': ('LT', '1', 'WS Protocol String 1', ''),
                     '0019xxf1': ('LT', '1', 'WS Protocol String 2', ''),
                     '0019xxf2': ('LT', '1', 'WS Protocol String 3', ''),
                     '0019xxf3': ('LT', '1', 'WS Protocol String 4', ''),
                     '0021xx00': ('IS', '1', 'Unknown', ''),
                     '0021xx10': ('IS', '1', 'Unknown', ''),
                     '0021xx20': ('IS', '1', 'Unknown', ''),
                     '0021xx21': ('DS', '1', 'Slice Gap', ''),
                     '0021xx22': ('DS', '1', 'Stack Radial Angle', ''),
                     '0027xx00': ('US', '1', 'Unknown', ''),
                     '0027xx11': ('US', '1-n', 'Unknown', ''),
                     '0027xx12': ('DS', '1-n', 'Unknown', ''),
                     '0027xx13': ('DS', '1-n', 'Unknown', ''),
                     '0027xx14': ('DS', '1-n', 'Unknown', ''),
                     '0027xx15': ('DS', '1-n', 'Unknown', ''),
                     '0027xx16': ('LO', '1', 'Unknown', ''),
                     '0029xx10': ('DS', '1', 'FP Min', ''),
                     '0029xx20': ('DS', '1', 'FP Max', ''),
                     '0029xx30': ('DS', '1', 'Scaled Minimum', ''),
                     '0029xx40': ('DS', '1', 'Scaled Maximum', ''),
                     '0029xx50': ('DS', '1', 'Window Minimum', ''),
                     '0029xx60': ('DS', '1', 'Window Maximum', ''),
                     '0029xx61': ('IS', '1', 'Unknown', ''),
                     '0029xx62': ('IS', '1', 'Unknown', ''),
                     '0029xx70': ('DS', '1', 'Unknown', ''),
                     '0029xx71': ('DS', '1', 'Unknown', ''),
                     '0029xx72': ('IS', '1', 'Unknown', ''),
                     '0029xx80': ('IS', '2', 'View Center', ''),
                     '0029xx81': ('IS', '2', 'View Size', ''),
                     '0029xx82': ('IS', '1', 'View Zoom', ''),
                     '0029xx83': ('IS', '1', 'View Transform', ''),
                     '0041xx07': ('LO', '1', 'Unknown', ''),
                     '0041xx09': ('DS', '1', 'Unknown', ''),
                     '6001xx00': ('LT', '1', 'Unknown', '')},
 'PHILIPS MR/PART': {'0019xx00': ('DS', '1', 'Field of View', ''),
                     '0019xx01': ('IS', '1-n', 'Stack Type', ''),
                     '0019xx02': ('IS', '1-n', 'Unknown', ''),
                     '0019xx03': ('DS', '1', 'Unknown', ''),
                     '0019xx05': ('DS', '1', 'CC Angulation', ''),
                     '0019xx06': ('DS', '1', 'AP Angulation', ''),
                     '0019xx07': ('DS', '1', 'LR Angulation', ''),
                     '0019xx08': ('IS', '1', 'Patient Orientation 1', ''),
                     '0019xx09': ('IS', '1', 'Patient Orientation', ''),
                     '0019xx0a': ('IS', '1', 'Slice Orientation', ''),
                     '0019xx0b': ('DS', '1', 'LR Offcenter', ''),
                     '0019xx0c': ('DS', '1', 'CC Offcenter', ''),
                     '0019xx0d': ('DS', '1', 'AP Offcenter', ''),
                     '0019xx0e': ('DS', '1', 'Unknown', ''),
                     '0019xx0f': ('IS', '1', 'Number of Slices', ''),
                     '0019xx10': ('DS', '1', 'Slice Factor', ''),
                     '0019xx11': ('DS', '1-n', 'Echo Times', ''),
                     '0019xx14': ('CS', '1', 'Unknown', ''),
                     '0019xx15': ('IS', '1', 'Dynamic Study', ''),
                     '0019xx18': ('DS', '1', 'Heartbeat Interval', ''),
                     '0019xx19': ('DS', '1', 'Repetition Time FFE', ''),
                     '0019xx1a': ('DS', '1', 'FFE Flip Angle', ''),
                     '0019xx1b': ('IS', '1', 'Number of Scans', ''),
                     '0019xx1c': ('CS', '1', 'Unknown', ''),
                     '0019xx1d': ('CS', '1', 'Unknown', ''),
                     '0019xx1e': ('DS', '1', 'Unknown', ''),
                     '0019xx21': ('DS', '1-n', 'Unknown', ''),
                     '0019xx22': ('DS', '1', 'Dynamic Scan Time Begin', ''),
                     '0019xx23': ('DS', '1-n', 'Unknown', ''),
                     '0019xx24': ('IS', '1', 'Unknown', ''),
                     '0019xx25': ('DS', '1-n', 'Unknown', ''),
                     '0019xx26': ('DS', '1-n', 'Unknown', ''),
                     '0019xx27': ('DS', '1-n', 'Unknown', ''),
                     '0019xx28': ('CS', '1', 'Unknown', ''),
                     '0019xx29': ('DS', '1-n', 'Unknown', ''),
                     '0019xx30': ('LO', '1-n', 'Unknown', ''),
                     '0019xx31': ('DS', '1-n', 'Unknown', ''),
                     '0019xx40': ('US', '1', 'Unknown', ''),
                     '0019xx45': ('IS', '1', 'Reconstruction Resolution', ''),
                     '0019xx50': ('IS', '1', 'Unknown', ''),
                     '0019xx51': ('DS', '1', 'Unknown', ''),
                     '0019xx52': ('DS', '1', 'Unknown', ''),
                     '0019xx53': ('IS', '1', 'Unknown', ''),
                     '0019xx54': ('DS', '1', 'Unknown', ''),
                     '0019xx55': ('DS', '1', 'Unknown', ''),
                     '0019xx56': ('DS', '1', 'Unknown', ''),
                     '0019xx57': ('US', '1', 'Unknown', ''),
                     '0019xx58': ('DS', '1', 'Unknown', ''),
                     '0019xx59': ('US', '1', 'Unknown', ''),
                     '0019xx60': ('DS', '1', 'Unknown', ''),
                     '0019xx61': ('DS', '1', 'Unknown', ''),
                     '0019xx62': ('DS', '1', 'Unknown', ''),
                     '0019xx63': ('DS', '1', 'Unknown', ''),
                     '0019xx64': ('DS', '1', 'Repetition Time SE', ''),
                     '0019xx65': ('DS', '1', 'Repetition Time IR', ''),
                     '0019xx66': ('US', '1', 'Unknown', ''),
                     '0019xx67': ('US', '1', 'Unknown', ''),
                     '0019xx69': ('IS', '1', 'Number of Phases', ''),
                     '0019xx6a': ('IS', '1', 'Cardiac Frequency', ''),
                     '0019xx6b': ('DS', '1', 'Inversion Delay', ''),
                     '0019xx6c': ('DS', '1', 'Gate Delay', ''),
                     '0019xx6d': ('DS', '1', 'Gate Width', ''),
                     '0019xx6e': ('DS', '1', 'Trigger Delay Time', ''),
                     '0019xx70': ('DS', '1-n', 'Unknown', ''),
                     '0019xx80': ('IS', '1', 'Number of Chemical Shifts', ''),
                     '0019xx81': ('DS', '1', 'Chemical Shift', ''),
                     '0019xx84': ('IS', '1', 'Number of Rows', ''),
                     '0019xx85': ('IS', '1', 'Number of Samples', ''),
                     '0019xx8a': ('CS', '1', 'Unknown', ''),
                     '0019xx8b': ('CS', '1', 'Unknown', ''),
                     '0019xx8c': ('CS', '1', 'Unknown', ''),
                     '0019xx8d': ('CS', '1', 'Unknown', ''),
                     '0019xx8e': ('CS', '1', 'Unknown', ''),
                     '0019xx8f': ('CS', '1', 'Unknown', ''),
                     '0019xx94': ('LO',
                                  '1',
                                  'Magnetization Transfer Contrast',
                                  ''),
                     '0019xx95': ('LO',
                                  '1',
                                  'Spectral Presaturation With Inversion Recovery',
                                  ''),
                     '0019xx96': ('IS', '1', 'Unknown', ''),
                     '0019xx97': ('LO', '1', 'Unknown', ''),
                     '0019xx99': ('LO', '1', 'Unknown', ''),
                     '0019xxa0': ('IS', '1', 'Unknown', ''),
                     '0019xxa1': ('DS', '1', 'Unknown', ''),
                     '0019xxa3': ('DS', '1', 'Unknown', ''),
                     '0019xxa4': ('CS', '1', 'Unknown', ''),
                     '0019xxb4': ('DS', '1', 'Unknown', ''),
                     '0019xxb5': ('DS', '1', 'Unknown', ''),
                     '0019xxb6': ('DS', '1', 'Unknown', ''),
                     '0019xxc0': ('DS', '1', 'Trigger Delay Times', ''),
                     '0019xxc8': ('IS', '1', 'Unknown', ''),
                     '0019xxc9': ('IS',
                                  '1',
                                  'Foldover Direction Transverse',
                                  ''),
                     '0019xxca': ('IS',
                                  '1',
                                  'Foldover Direction Sagittal',
                                  ''),
                     '0019xxcb': ('IS',
                                  '1',
                                  'Foldover Direction Coronal',
                                  ''),
                     '0019xxcc': ('IS', '1', 'Unknown', ''),
                     '0019xxcd': ('IS', '1', 'Unknown', ''),
                     '0019xxce': ('IS', '1', 'Unknown', ''),
                     '0019xxcf': ('IS', '1', 'Number of Echoes', ''),
                     '0019xxd0': ('IS', '1', 'Scan Resolution', ''),
                     '0019xxd1': ('US', '1', 'Unknown', ''),
                     '0019xxd2': ('LO', '2', 'Water Fat Shift', ''),
                     '0019xxd3': ('DS', '1', 'Unknown', ''),
                     '0019xxd4': ('IS', '1', 'Artifact Reduction', ''),
                     '0019xxd5': ('IS', '1', 'Unknown', ''),
                     '0019xxd6': ('IS', '1', 'Unknown', ''),
                     '0019xxd7': ('DS', '1', 'Scan Percentage', ''),
                     '0019xxd8': ('IS', '1', 'Halfscan', ''),
                     '0019xxd9': ('IS', '1', 'EPI Factor', ''),
                     '0019xxda': ('IS', '1', 'Turbo Factor', ''),
                     '0019xxdb': ('IS', '1', 'Unknown', ''),
                     '0019xxe0': ('IS',
                                  '1',
                                  'Percentage of Scan Completed',
                                  ''),
                     '0019xxe1': ('DS', '1', 'Prepulse Delay', ''),
                     '0019xxe3': ('DS', '1', 'Phase Contrast Velocity', ''),
                     '0019xxf0': ('IS', '1', 'Unknown', ''),
                     '0019xxf6': ('CS', '1', 'Unknown', ''),
                     '0019xxf7': ('CS', '1', 'Unknown', ''),
                     '0019xxf8': ('CS', '1', 'Unknown', ''),
                     '0019xxf9': ('CS', '1', 'Unknown', ''),
                     '0019xxfa': ('CS', '1', 'Unknown', ''),
                     '0019xxfb': ('CS', '1', 'Unknown', ''),
                     '0019xxfc': ('IS', '1', 'Resonance Frequency', ''),
                     '0021xx00': ('DA', '1', 'Scan Date', ''),
                     '0021xx06': ('LO', '1', 'Unknown', ''),
                     '0021xx07': ('DT', '1', 'Unknown', ''),
                     '0021xx08': ('LO', '1', 'Unknown', ''),
                     '0021xx09': ('CS', '1', 'Unknown', ''),
                     '0021xx0a': ('CS', '1', 'Unknown', ''),
                     '0021xx0f': ('LO', '1', 'Unknown', ''),
                     '0021xx10': ('IS', '1', 'Image Type', ''),
                     '0021xx13': ('CS', '1', 'Unknown', ''),
                     '0021xx14': ('LO', '1', 'Unknown', ''),
                     '0021xx15': ('US', '1', 'Unknown', ''),
                     '0021xx20': ('IS', '1', 'Slice Number', ''),
                     '0021xx21': ('IS', '1', 'Slice Gap', ''),
                     '0021xx30': ('IS', '1', 'Echo Number', ''),
                     '0021xx31': ('DS', '1', 'Patient Reference ID', ''),
                     '0021xx35': ('IS', '1', 'Chemical Shift Number', ''),
                     '0021xx40': ('IS', '1', 'Phase Number', ''),
                     '0021xx50': ('IS', '1', 'Dynamic Scan Number', ''),
                     '0021xx60': ('IS', '1', 'Number of Rows In Object', ''),
                     '0021xx61': ('IS', '1-n', 'Row Number', ''),
                     '0021xx62': ('IS', '1-n', 'Unknown', ''),
                     '0029xx00': ('DS', '2', 'Unknown', ''),
                     '0029xx04': ('US', '1', 'Unknown', ''),
                     '0029xx10': ('DS', '1', 'Unknown', ''),
                     '0029xx11': ('DS', '1', 'Unknown', ''),
                     '0029xx20': ('LO', '1', 'Unknown', ''),
                     '0029xx31': ('DS', '2', 'Unknown', ''),
                     '0029xx32': ('DS', '2', 'Unknown', ''),
                     '0029xx50': ('DS', '1', 'Unknown', ''),
                     '0029xx51': ('DS', '1', 'Unknown', ''),
                     '0029xx52': ('DS', '1', 'Unknown', ''),
                     '0029xx53': ('DS', '1', 'Unknown', ''),
                     '0029xxc3': ('IS', '1', 'Scan Resolution', ''),
                     '0029xxc4': ('IS', '1', 'Field of View', ''),
                     '0029xxd5': ('LT', '1', 'Slice Thickness', '')},
 'PHILIPS MR/PART 12': {'0009xx10': ('US', '1', 'Unknown', '')},
 'PHILIPS MR/PART 6': {'0019xx10': ('IS', '1', 'Unknown', '')},
 'PHILIPS MR/PART 7': {'0019xx00': ('IS', '1', 'Unknown', '')},
 'PHILIPS NM -Private': {'7051xx00': ('US', '1', 'Current Segment', ''),
                         '7051xx01': ('US', '1', 'Number of Segments', ''),
                         '7051xx02': ('FL',
                                      '1',
                                      'Segment Start Position',
                                      ''),
                         '7051xx03': ('FL', '1', 'Segment Stop Position', ''),
                         '7051xx04': ('FL',
                                      '1',
                                      'Rel. COR offset - X dir.',
                                      ''),
                         '7051xx05': ('FL',
                                      '1',
                                      'Rel. COR offset - Z dir.',
                                      ''),
                         '7051xx06': ('US',
                                      '1',
                                      'Current Rotation Number',
                                      ''),
                         '7051xx07': ('US', '1', 'Number of Rotations', ''),
                         '7051xx10': ('DS',
                                      '1',
                                      'Alignment Translations',
                                      ''),
                         '7051xx11': ('DS', '1', 'Alignment Rotations', ''),
                         '7051xx12': ('DS', '1', 'Alignment Timestamp', '')},
 'PHILIPS UNDOCUMENTED': {'5503xx12': ('SL', '1', 'Slice Thickness', ''),
                          '5503xx24': ('UT', '1', 'Plane', ''),
                          '5503xx30': ('SS', '1', 'Number of Slices', ''),
                          '5503xxa5': ('UT', '1', 'Prepulse', ''),
                          '5503xxae': ('SS', '1', 'Contrast Agent Flag', ''),
                          '5503xxbb': ('SL', '1', 'Coil ID', ''),
                          '5503xxc2': ('UT', '1', 'Anatomy', ''),
                          '5503xxc3': ('UT', '1', 'Indication', '')},
 'PHILIPS UNKNOWN': {'2001xx01': ('UN', '1', 'MRSeriesNrOfEchoes', ''),
                     '2001xx02': ('UN',
                                  '1',
                                  'MRSeriesScanningTechniqueDescription',
                                  ''),
                     '2001xx05': ('UN', '1', 'StackSequence', ''),
                     '2001xx06': ('UN', '1', 'Examination Source', ''),
                     '2001xx07': ('UN', '1', 'MRSeriesAcquisitionNumber', ''),
                     '2001xx08': ('UN', '1', 'MRSeriesNrOfDynamicScans', ''),
                     '2005xx02': ('UN',
                                  '1',
                                  'MRSeriesNrOfChemicalShifts',
                                  ''),
                     '2005xx03': ('UN', '1', 'MRSeriesRepetitionTime', ''),
                     '2005xx36': ('UN', '1', 'MRVolumeSelection', '')},
 'PHILIPS-MR-1': {'0019xx11': ('IS', '1', 'Chemical Shift Number', ''),
                  '0019xx12': ('IS', '1', 'Phase Number (Philips)', ''),
                  '0021xx01': ('IS', '1', 'Reconstruction Number', ''),
                  '0021xx02': ('IS', '1', 'Slice Number', '')},
 'PMOD_1': {'0055xx01': ('FD', '1-n', 'Frame Start Times Vector', ''),
            '0055xx02': ('FD', '3-3n', 'Frame Positions Vector', ''),
            '0055xx03': ('FD', '6-6n', 'Frame Orientations Vector', ''),
            '0055xx04': ('FD', '1-n', 'Frame Durations (ms) Vector', ''),
            '0055xx05': ('FD', '1-n', 'Frame Rescale Slope Vector', '')},
 'PMOD_GENPET': {'7fe1xx01': ('UT', '1', 'Slices Names', ''),
                 '7fe1xx02': ('UT', '1', 'Gene Codes', ''),
                 '7fe1xx03': ('UT', '1', 'Gene Labels', '')},
 'PMS-THORA-5.1': {'0089xx20': ('SQ', '1', 'Stamp Image Sequence', '')},
 'PMTF INFORMATION DATA': {'0029xx01': ('SQ', '1', 'Unknown', ''),
                           '0029xx31': ('LO', '1', 'PMTF Information 1', ''),
                           '0029xx32': ('UL', '1', 'PMTF Information 2', ''),
                           '0029xx33': ('UL', '1', 'PMTF Information 3', ''),
                           '0029xx34': ('CS', '1', 'PMTF Information 4', ''),
                           '0029xx89': ('LO', '1', 'Unknown', ''),
                           '0029xx90': ('OB', '1', 'Unknown', ''),
                           '7015xx73': ('SQ', '1', 'Unknown', '')},
 'POLYTRON-SMS 2.5': {'0009xx02': ('UN', '1', 'Private Data 1', ''),
                      '0009xx03': ('UN', '1', 'Private Data 2', ''),
                      '0009xx04': ('UN', '1', 'Private Data 3', ''),
                      '0009xx06': ('UN', '1', 'Private Data 3', ''),
                      '0009xx10': ('UN', '1', 'Private Data 4', ''),
                      '0009xx11': ('UN', '1', 'Private Data 5', ''),
                      '0009xx12': ('UN', '1', 'Private Data 6', ''),
                      '0089xx10': ('UN', '1', 'Private Data', '')},
 'PRIVATE ORIGINAL ATTRIBUTES': {'0021xx01': ('SQ',
                                              '1',
                                              'Private Original Attribute Sequence',
                                              ''),
                                 '0021xx05': ('DT',
                                              '1',
                                              'Replacement Date and Time',
                                              ''),
                                 '0021xx10': ('LO',
                                              '1',
                                              'Replacement Originator Name',
                                              ''),
                                 '0021xx12': ('LO',
                                              '1',
                                              'Replacement Reason',
                                              ''),
                                 '0021xx70': ('PN',
                                              '1-n',
                                              "Original Operators'Name",
                                              '')},
 'Philips EV Imaging DD 017': {'2007xxc1': ('UI',
                                            '1',
                                            '? SOP Instance UID ?',
                                            ''),
                               '2007xxc2': ('DA', '1', 'Unknown', ''),
                               '2007xxc3': ('TM', '1', 'Unknown', ''),
                               '2007xxc4': ('UL', '1', 'Unknown', '')},
 'Philips EV Imaging DD 019': {'2007xx00': ('LO', '1', 'Unknown', ''),
                               '2007xx01': ('UT', '1', 'Unknown', '')},
 'Philips EV Imaging DD 021': {'2007xx04': ('SL',
                                            '1',
                                            'Vol Seg Edit Connectivity',
                                            '')},
 'Philips EV Imaging DD 022': {'2007xx00': ('ST', '1', '', ''),
                               '2007xx12': ('UN',
                                            '1',
                                            'Volume Sequence Capture',
                                            ''),
                               '2007xx17': ('UN',
                                            '1',
                                            'Original SOP Instance',
                                            ''),
                               '2007xx33': ('LO', '1', '', ''),
                               '2007xx34': ('CS', '1', '', '')},
 'Philips EnVisor': {'7777xx01': ('DA',
                                  '1',
                                  "Date 3D/PanView internal 'dataset' file was acquired",
                                  ''),
                     '7777xx02': ('CS', '1', 'Type of 3D or PanView', ''),
                     '7777xx03': ('LO',
                                  '1',
                                  'Internal 3D/PanView software version number',
                                  ''),
                     '7777xx14': ('LT', '1', 'Private string', '')},
 'Philips Imaging DD 001': {'2001xx01': ('FL', '1', 'Chemical Shift', ''),
                            '2001xx02': ('IS',
                                         '1',
                                         'Chemical Shift Number MR',
                                         ''),
                            '2001xx03': ('FL', '1', 'Diffusion B-Factor', ''),
                            '2001xx04': ('CS',
                                         '1',
                                         'Diffusion Direction',
                                         ''),
                            '2001xx05': ('SS', '1', 'Unknown', ''),
                            '2001xx06': ('CS', '1', 'Image Enhanced', ''),
                            '2001xx07': ('CS', '1', 'Image Type ED ES', ''),
                            '2001xx08': ('IS', '1', 'Phase Number', ''),
                            '2001xx09': ('FL', '1', 'Unknown', ''),
                            '2001xx0a': ('IS', '1', 'Slice Number MR', ''),
                            '2001xx0b': ('CS', '1', 'Slice Orientation', ''),
                            '2001xx0c': ('CS', '1', 'Unknown', ''),
                            '2001xx0e': ('CS', '1', 'Unknown', ''),
                            '2001xx0f': ('SS', '1', 'Unknown', ''),
                            '2001xx10': ('CS', '1', 'Cardiac Sync', ''),
                            '2001xx11': ('FL',
                                         '1',
                                         'Diffusion Echo Time',
                                         ''),
                            '2001xx12': ('CS', '1', 'Dynamic Series', ''),
                            '2001xx13': ('SL', '1', 'EPI Factor', ''),
                            '2001xx14': ('SL', '1', 'Number of Echoes', ''),
                            '2001xx15': ('SS',
                                         '1',
                                         'Number of Locations',
                                         ''),
                            '2001xx16': ('SS',
                                         '1',
                                         'Number of PC Directions',
                                         ''),
                            '2001xx17': ('SL',
                                         '1',
                                         'Number of Phases MR',
                                         ''),
                            '2001xx18': ('SL',
                                         '1',
                                         'Number of Slices MR',
                                         ''),
                            '2001xx19': ('CS',
                                         '1',
                                         'Partial Matrix Scanned',
                                         ''),
                            '2001xx1a': ('FL', '1-n', 'PC Velocity', ''),
                            '2001xx1b': ('FL', '1', 'Prepulse Delay', ''),
                            '2001xx1c': ('CS', '1', 'Prepulse Type', ''),
                            '2001xx1d': ('IS',
                                         '1',
                                         'Reconstruction Number MR',
                                         ''),
                            '2001xx1e': ('CS', '1', 'Unknown', ''),
                            '2001xx1f': ('CS', '1', 'Respiration Sync', ''),
                            '2001xx20': ('LO',
                                         '1',
                                         'Scanning Technique Description MR',
                                         ''),
                            '2001xx21': ('CS', '1', 'SPIR', ''),
                            '2001xx22': ('FL', '1', 'Water Fat Shift', ''),
                            '2001xx23': ('DS', '1', 'Flip Angle Philips', ''),
                            '2001xx24': ('CS', '1', 'Interactive', ''),
                            '2001xx25': ('SH',
                                         '1',
                                         'Echo Time Display MR',
                                         ''),
                            '2001xx26': ('CS',
                                         '1',
                                         'Presentation State Subtraction Active',
                                         ''),
                            '2001xx28': ('FL',
                                         '1',
                                         'Edge Enhancement Gain Factor Sub',
                                         ''),
                            '2001xx29': ('FL',
                                         '1',
                                         'Edge Enhancement Gain Factor Non Sub',
                                         ''),
                            '2001xx2a': ('CS',
                                         '1',
                                         'Edge Enhancement Taste Adapt Sub',
                                         ''),
                            '2001xx2b': ('CS',
                                         '1',
                                         'Edge Enhancement Taste Non Sub',
                                         ''),
                            '2001xx2c': ('FL',
                                         '1',
                                         'Harmonization Factor',
                                         ''),
                            '2001xx2d': ('SS',
                                         '1',
                                         'Number of Stack Slices',
                                         ''),
                            '2001xx2f': ('FL', '1', 'Harmonization Gain', ''),
                            '2001xx30': ('UL',
                                         '1',
                                         'Log Subtraction Gain Step',
                                         ''),
                            '2001xx31': ('US',
                                         '1',
                                         'Mixing NR of Mask Image Numbers',
                                         ''),
                            '2001xx32': ('FL',
                                         '1-n',
                                         'Stack Radial Angle',
                                         ''),
                            '2001xx33': ('CS',
                                         '1-n',
                                         'Stack Radial Axis',
                                         ''),
                            '2001xx34': ('CS',
                                         '1',
                                         'Mixing Mask Operation',
                                         ''),
                            '2001xx35': ('SS',
                                         '1-n',
                                         'Stack Slice Number',
                                         ''),
                            '2001xx36': ('CS', '1-n', 'Stack Type', ''),
                            '2001xx37': ('CS',
                                         '1',
                                         'Mixing Operation Type',
                                         ''),
                            '2001xx39': ('FL', '1', 'Unknown', ''),
                            '2001xx3a': ('CS', '1', 'Pixel Shift', ''),
                            '2001xx3d': ('UL', '1', 'Unknown', ''),
                            '2001xx3f': ('CS',
                                         '1',
                                         'Interpolation Method',
                                         ''),
                            '2001xx42': ('CS',
                                         '1',
                                         'Substraction Land Marking Active',
                                         ''),
                            '2001xx46': ('CS', '1', 'Graphic Line Style', ''),
                            '2001xx47': ('FL', '1', 'Graphic Line Width', ''),
                            '2001xx48': ('SS',
                                         '1',
                                         'Graphic Annotation ID',
                                         ''),
                            '2001xx4b': ('CS',
                                         '1',
                                         'Poly Line Interpolation Method',
                                         ''),
                            '2001xx4c': ('CS',
                                         '1',
                                         'Poly Line Begin Point Style',
                                         ''),
                            '2001xx4d': ('CS',
                                         '1',
                                         'Poly Line End Point Style',
                                         ''),
                            '2001xx4e': ('CS',
                                         '1',
                                         'Window Smoothing Taste',
                                         ''),
                            '2001xx4f': ('FD',
                                         '1',
                                         'Harmonization Offset',
                                         ''),
                            '2001xx50': ('LO', '1', 'Unknown', ''),
                            '2001xx52': ('UI', '1', 'Unknown', ''),
                            '2001xx53': ('CS', '1', 'Window Invert', ''),
                            '2001xx55': ('CS', '1', 'Graphic Line Color', ''),
                            '2001xx56': ('CS',
                                         '1',
                                         'Graphic Type (Private)',
                                         ''),
                            '2001xx5a': ('ST',
                                         '1',
                                         'Graphic Annotation Model',
                                         ''),
                            '2001xx5d': ('ST',
                                         '1',
                                         'Measurement Text Units',
                                         ''),
                            '2001xx5e': ('ST',
                                         '1',
                                         'Measurement Text Type',
                                         ''),
                            '2001xx5f': ('SQ', '1', 'Stack Sequence', ''),
                            '2001xx60': ('SL', '1', 'Number of Stacks', ''),
                            '2001xx61': ('CS', '1', 'Unknown', ''),
                            '2001xx62': ('CS', '1', 'Unknown', ''),
                            '2001xx63': ('CS', '1', 'Examination Source', ''),
                            '2001xx64': ('SH', '1', 'Text Type', ''),
                            '2001xx65': ('SQ', '1', 'Unknown', ''),
                            '2001xx67': ('CS', '1', 'Unknown', ''),
                            '2001xx68': ('SQ', '1', 'Unknown', ''),
                            '2001xx69': ('SQ',
                                         '1',
                                         'Display Shutter Sequence',
                                         ''),
                            '2001xx6a': ('SQ', '1', 'Unknown', ''),
                            '2001xx6b': ('SQ',
                                         '1',
                                         'Has Edge Enhancement Sequence',
                                         ''),
                            '2001xx6d': ('LO', '1', 'Text Font', ''),
                            '2001xx6e': ('SH', '1', 'Series Type', ''),
                            '2001xx6f': ('SQ', '1', 'Mixing Sequence', ''),
                            '2001xx71': ('CS', '1', 'Unknown', ''),
                            '2001xx73': ('SQ',
                                         '1',
                                         'Referenced Mask Image Sequence',
                                         ''),
                            '2001xx74': ('DS',
                                         '1-n',
                                         'Window Center Sub',
                                         ''),
                            '2001xx75': ('DS', '1-n', 'Window Width Sub', ''),
                            '2001xx76': ('UL', '1', 'Unknown', ''),
                            '2001xx77': ('CS', '1', 'GL TrafoType', ''),
                            '2001xx79': ('SQ',
                                         '1',
                                         'Harmonisation Sequence',
                                         ''),
                            '2001xx7a': ('FL', '1', 'Unknown', ''),
                            '2001xx7b': ('IS', '1', 'Acquisition Number', ''),
                            '2001xx7e': ('US',
                                         '1',
                                         'Edge Enhancement Gain Taste',
                                         ''),
                            '2001xx7f': ('US',
                                         '1',
                                         'Edge Enhancement Gain Taste Sub',
                                         ''),
                            '2001xx80': ('LO',
                                         '1',
                                         'Text Anchor Point Alignment',
                                         ''),
                            '2001xx81': ('IS',
                                         '1',
                                         'Number of Dynamic Scans',
                                         ''),
                            '2001xx82': ('IS', '1', 'Echo Train Length', ''),
                            '2001xx83': ('DS', '1', 'Imaging Frequency', ''),
                            '2001xx84': ('DS', '1', 'Inversion Time', ''),
                            '2001xx85': ('DS',
                                         '1',
                                         'Magnetic Field Strength',
                                         ''),
                            '2001xx86': ('IS', '1', 'Unknown', ''),
                            '2001xx87': ('SH', '1', 'Imaged Nucleus', ''),
                            '2001xx88': ('DS', '1', 'Number of Averages', ''),
                            '2001xx89': ('DS', '1', 'Phase FOV Percent', ''),
                            '2001xx8a': ('DS', '1', 'Sampling Percent', ''),
                            '2001xx8b': ('SH', '1', 'Unknown', ''),
                            '2001xx93': ('LO', '1', 'Text Style', ''),
                            '2001xx94': ('LO',
                                         '1',
                                         'Processing Order Specialization',
                                         ''),
                            '2001xx97': ('SH', '1', 'Nucleus', ''),
                            '2001xx9a': ('SQ',
                                         '1',
                                         'Graphic Number Sequence',
                                         ''),
                            '2001xx9b': ('UL', '1', 'Graphic Number', ''),
                            '2001xx9c': ('LO', '1', 'Unknown', ''),
                            '2001xx9d': ('LO',
                                         '1',
                                         'PIIM Substraction Type',
                                         ''),
                            '2001xx9f': ('US',
                                         '2',
                                         'Pixel Processing Kernel Size',
                                         ''),
                            '2001xxa1': ('CS', '1', 'Is Raw Image', ''),
                            '2001xxa2': ('US',
                                         '1',
                                         'LOG Substraction Curve Taste',
                                         ''),
                            '2001xxa3': ('UL',
                                         '1',
                                         'Text Color Foreground',
                                         ''),
                            '2001xxa4': ('UL',
                                         '1',
                                         'Text Color Background',
                                         ''),
                            '2001xxa5': ('UL', '1', 'Text Color Shadow', ''),
                            '2001xxc1': ('LO',
                                         '1',
                                         'Nested Object Type Name',
                                         ''),
                            '2001xxcc': ('ST', '1', 'Unknown', ''),
                            '2001xxda': ('CS', '1', 'Unknown', ''),
                            '2001xxf1': ('FL',
                                         '1-n',
                                         'Prospective Motion Correction',
                                         ''),
                            '2001xxf2': ('FL',
                                         '1',
                                         'Retrospective Motion Correction',
                                         ''),
                            '2005xx14': ('CS', '1', 'Diffusion', ''),
                            '2005xx20': ('SL',
                                         '1',
                                         'Number of Chemical Shifts',
                                         ''),
                            '2005xx30': ('FL', '1', 'Repetition Time', ''),
                            '2005xx33': ('FL', '1', 'Scan Duration', ''),
                            '2005xx35': ('CS', '1', 'Data Type', ''),
                            '2005xx8b': ('SH', '1', 'Transmitting Coil', ''),
                            '2005xx9f': ('CS',
                                         '1',
                                         'Spectral Selective Excitation Pulse',
                                         ''),
                            '2005xxa1': ('CS', '1', 'Syncra Scan Type', '')},
 'Philips Imaging DD 002': {'2001xx01': ('US', '1', 'Unknown', ''),
                            '2001xx02': ('FD', '1', 'Unknown', ''),
                            '2001xx13': ('SS', '1', 'Unknown', ''),
                            '2001xx14': ('FD', '1', 'Unknown', ''),
                            '2001xx15': ('FD', '1', 'Unknown', ''),
                            '2001xx16': ('FD', '1', 'Unknown', ''),
                            '2001xx17': ('FD', '1', 'Unknown', ''),
                            '2001xx18': ('CS', '1', 'Unknown', ''),
                            '2001xx19': ('FD', '1', 'Unknown', ''),
                            '2001xx1a': ('FD', '1', 'Unknown', ''),
                            '2001xx1b': ('FD', '1', 'Unknown', ''),
                            '2001xx1c': ('FD', '1', 'Unknown', ''),
                            '2001xx1d': ('FD', '1', 'Unknown', ''),
                            '2001xx1e': ('FD', '1', 'Unknown', ''),
                            '2001xx1f': ('FD', '1', 'Unknown', ''),
                            '2001xx20': ('FD', '1', 'Unknown', ''),
                            '2001xx21': ('FD', '1', 'Unknown', ''),
                            '2001xx22': ('FD', '1', 'Unknown', ''),
                            '2001xx23': ('FD', '1', 'Unknown', ''),
                            '2001xx24': ('FD', '1', 'Unknown', ''),
                            '2001xx25': ('FD', '1', 'Unknown', ''),
                            '2001xx26': ('FD', '1', 'Unknown', ''),
                            '2001xx27': ('FD', '1', 'Unknown', ''),
                            '2001xx28': ('US', '1', 'Unknown', ''),
                            '2001xx29': ('US', '1', 'Unknown', ''),
                            '2001xx2a': ('US', '1', 'Unknown', ''),
                            '2001xx2b': ('SS', '1', 'Unknown', ''),
                            '2001xx2c': ('FD', '1', 'Unknown', ''),
                            '2001xx2d': ('FD', '1', 'Unknown', ''),
                            '2001xx2e': ('SS', '1', 'Unknown', ''),
                            '2001xx2f': ('SS', '1', 'Unknown', ''),
                            '2001xx30': ('SS', '1', 'Unknown', ''),
                            '2001xx31': ('SS', '1', 'Unknown', ''),
                            '2001xx32': ('SS', '1', 'Unknown', ''),
                            '2001xx33': ('SS', '1', 'Unknown', ''),
                            '2001xx34': ('SS', '1', 'Unknown', ''),
                            '2001xx35': ('FD', '1', 'Unknown', ''),
                            '2001xx36': ('FD', '1', 'Unknown', ''),
                            '2001xx37': ('FD', '1', 'Unknown', ''),
                            '2001xx39': ('CS', '1', 'Unknown', ''),
                            '2001xx3a': ('SQ', '1', 'Unknown', ''),
                            '2001xx3b': ('SQ', '1', 'Unknown', ''),
                            '2001xx3c': ('SQ', '1', 'Unknown', ''),
                            '2001xx3d': ('SQ', '1', 'Unknown', ''),
                            '2001xx3e': ('SS', '1', 'Unknown', ''),
                            '2001xx3f': ('SS', '1', 'Unknown', ''),
                            '2001xx40': ('SS', '1', 'Unknown', '')},
 'Philips Imaging DD 065': {'4007xx00': ('CS', '1', 'Unknown', '')},
 'Philips Imaging DD 067': {'4001xx00': ('SQ', '1', 'Unknown', ''),
                            '4001xx01': ('CS', '1', 'Unknown', ''),
                            '4001xx08': ('CS', '1', 'Unknown', '')},
 'Philips Imaging DD 070': {'4001xx10': ('SQ', '1', 'Unknown', ''),
                            '4001xx11': ('SQ', '1', 'Unknown', ''),
                            '4001xx12': ('SQ', '1', 'Unknown', ''),
                            '4001xx16': ('ST', '1', 'Unknown', ''),
                            '4001xx17': ('ST', '1', 'Unknown', ''),
                            '4001xx18': ('ST', '1', 'Unknown', ''),
                            '4001xx1c': ('SQ', '1', 'Unknown', ''),
                            '4001xx1d': ('LT', '1', 'Unknown', '')},
 'Philips Imaging DD 073': {'4007xx48': ('FL', '1', 'Unknown', '')},
 'Philips Imaging DD 129': {'2001xx00': ('SQ', '1', 'Unknown', ''),
                            '2001xx01': ('SQ', '1', 'Unknown', '')},
 'Philips MR Imaging DD 001': {'2005xx00': ('FL', '1', 'Unknown', ''),
                               '2005xx01': ('FL', '1', 'Unknown', ''),
                               '2005xx02': ('FL', '1', 'Unknown', ''),
                               '2005xx04': ('CS', '1', 'Unknown', ''),
                               '2005xx05': ('CS',
                                            '1',
                                            'Synergy Reconstruction Type',
                                            ''),
                               '2005xx08': ('FL', '1', 'Unknown', ''),
                               '2005xx09': ('FL', '1', 'Unknown', ''),
                               '2005xx0a': ('FL', '1', 'Unknown', ''),
                               '2005xx0b': ('FL', '1', 'Unknown', ''),
                               '2005xx0c': ('FL', '1', 'Unknown', ''),
                               '2005xx0d': ('FL', '1', 'Unknown', ''),
                               '2005xx0e': ('FL', '1', 'Unknown', ''),
                               '2005xx0f': ('DS', '1', 'Window Center', ''),
                               '2005xx10': ('DS', '1', 'Window Width', ''),
                               '2005xx11': ('CS', '1', 'Unknown', ''),
                               '2005xx12': ('CS', '1', 'Unknown', ''),
                               '2005xx13': ('CS', '1', 'Unknown', ''),
                               '2005xx14': ('CS', '1', 'Unknown', ''),
                               '2005xx15': ('CS', '1', 'Unknown', ''),
                               '2005xx16': ('CS', '1', 'Unknown', ''),
                               '2005xx17': ('CS', '1', 'Unknown', ''),
                               '2005xx18': ('LO', '1', 'Unknown', ''),
                               '2005xx19': ('CS', '1', 'Unknown', ''),
                               '2005xx1a': ('SS', '1', 'Unknown', ''),
                               '2005xx1b': ('CS', '1', 'Unknown', ''),
                               '2005xx1c': ('CS', '1', 'Unknown', ''),
                               '2005xx1d': ('SS', '1', 'Unknown', ''),
                               '2005xx1e': ('SH', '1', 'Unknown', ''),
                               '2005xx1f': ('SH', '1', 'Unknown', ''),
                               '2005xx20': ('SL',
                                            '1',
                                            'Number of Chemical Shift',
                                            ''),
                               '2005xx21': ('SS', '1', 'Unknown', ''),
                               '2005xx22': ('IS', '1', 'Unknown', ''),
                               '2005xx23': ('SS', '1', 'Unknown', ''),
                               '2005xx25': ('SS', '1', 'Unknown', ''),
                               '2005xx26': ('CS', '1', 'Unknown', ''),
                               '2005xx27': ('CS', '1', 'Unknown', ''),
                               '2005xx28': ('CS', '1', 'Unknown', ''),
                               '2005xx29': ('CS', '1', 'Unknown', ''),
                               '2005xx2a': ('IS', '1', 'Unknown', ''),
                               '2005xx2b': ('SS', '1', 'Unknown', ''),
                               '2005xx2c': ('CS', '1', 'Unknown', ''),
                               '2005xx2d': ('IS', '1', 'Unknown', ''),
                               '2005xx2e': ('CS', '1', 'Unknown', ''),
                               '2005xx2f': ('CS', '1', 'Unknown', ''),
                               '2005xx30': ('FL', '1', 'Repetition Time', ''),
                               '2005xx31': ('CS', '1', 'Unknown', ''),
                               '2005xx32': ('CS', '1', 'Unknown', ''),
                               '2005xx33': ('FL',
                                            '1',
                                            'Acquisition Duration',
                                            ''),
                               '2005xx34': ('CS', '1', 'Unknown', ''),
                               '2005xx35': ('CS', '1', 'Unknown', ''),
                               '2005xx36': ('CS', '1', 'Unknown', ''),
                               '2005xx37': ('CS', '1', 'Unknown', ''),
                               '2005xx38': ('CS', '1', 'Unknown', ''),
                               '2005xx39': ('CS', '1', 'Unknown', ''),
                               '2005xx3a': ('SH', '1', 'Unknown', ''),
                               '2005xx3b': ('CS', '1', 'Unknown', ''),
                               '2005xx3c': ('CS', '1', 'Unknown', ''),
                               '2005xx3d': ('SS', '1', 'Unknown', ''),
                               '2005xx3e': ('SL', '1-n', 'Unknown', ''),
                               '2005xx48': ('IS', '1', 'Unknown', ''),
                               '2005xx49': ('IS', '1', 'Unknown', ''),
                               '2005xx4a': ('IS', '1', 'Unknown', ''),
                               '2005xx4b': ('IS', '1', 'Unknown', ''),
                               '2005xx4c': ('CS', '1', 'Unknown', ''),
                               '2005xx4d': ('CS', '1', 'Unknown', ''),
                               '2005xx4e': ('FL', '1', 'Unknown', ''),
                               '2005xx4f': ('FL', '1', 'Unknown', ''),
                               '2005xx50': ('FL', '1', 'Unknown', ''),
                               '2005xx51': ('FL', '1', 'Unknown', ''),
                               '2005xx52': ('CS', '1', 'Unknown', ''),
                               '2005xx53': ('CS', '1', 'Unknown', ''),
                               '2005xx54': ('FL', '1', 'Unknown', ''),
                               '2005xx55': ('FL', '1', 'Unknown', ''),
                               '2005xx56': ('FL', '1', 'Unknown', ''),
                               '2005xx57': ('FL', '1', 'Unknown', ''),
                               '2005xx58': ('FL', '1', 'Unknown', ''),
                               '2005xx59': ('FL', '1', 'Unknown', ''),
                               '2005xx5a': ('FL', '1', 'Unknown', ''),
                               '2005xx5b': ('FL', '1', 'Unknown', ''),
                               '2005xx5c': ('FL', '1', 'Unknown', ''),
                               '2005xx5d': ('CS', '1', 'Unknown', ''),
                               '2005xx5e': ('CS', '1', 'Unknown', ''),
                               '2005xx5f': ('CS', '1', 'Unknown', ''),
                               '2005xx60': ('IS', '1', 'Unknown', ''),
                               '2005xx61': ('CS', '1', 'Unknown', ''),
                               '2005xx63': ('SS', '1', 'Unknown', ''),
                               '2005xx64': ('IS', '1', 'Unknown', ''),
                               '2005xx65': ('IS', '1', 'Unknown', ''),
                               '2005xx66': ('CS', '1', 'Unknown', ''),
                               '2005xx67': ('IS', '1', 'Unknown', ''),
                               '2005xx68': ('CS', '1', 'Unknown', ''),
                               '2005xx69': ('FL', '1', 'Unknown', ''),
                               '2005xx6a': ('FL', '1', 'Unknown', ''),
                               '2005xx6b': ('FL', '1', 'Unknown', ''),
                               '2005xx6c': ('FL', '1', 'Unknown', ''),
                               '2005xx6d': ('FL', '1', 'Unknown', ''),
                               '2005xx6e': ('CS', '1', 'Unknown', ''),
                               '2005xx6f': ('CS', '1', 'Unknown', ''),
                               '2005xx70': ('LO', '1', 'Unknown', ''),
                               '2005xx71': ('FL', '1', 'Unknown', ''),
                               '2005xx72': ('FL', '1', 'Unknown', ''),
                               '2005xx73': ('FL', '1', 'Unknown', ''),
                               '2005xx74': ('FL', '1', 'Unknown', ''),
                               '2005xx75': ('FL', '1', 'Unknown', ''),
                               '2005xx76': ('FL', '1', 'Unknown', ''),
                               '2005xx78': ('FL', '1', 'Unknown', ''),
                               '2005xx79': ('FL', '1', 'Unknown', ''),
                               '2005xx7a': ('FL', '1', 'Unknown', ''),
                               '2005xx7b': ('CS', '1', 'Unknown', ''),
                               '2005xx7e': ('FL', '1', 'Unknown', ''),
                               '2005xx80': ('SQ', '1', 'Unknown', ''),
                               '2005xx81': ('CS', '1', 'Unknown', ''),
                               '2005xx83': ('SQ', '1', 'Unknown', ''),
                               '2005xx84': ('SQ', '1', 'Unknown', ''),
                               '2005xx85': ('SQ', '1', 'Unknown', ''),
                               '2005xx86': ('SS', '1', 'Unknown', ''),
                               '2005xx9e': ('SQ', '1', 'Unknown', ''),
                               '2005xx9f': ('CS', '1', 'Unknown', ''),
                               '2005xxa0': ('FL', '1', 'Unknown', ''),
                               '2005xxa1': ('CS',
                                            '1',
                                            'Syncra Scan Type',
                                            ''),
                               '2005xxa2': ('CS', '1', 'Unknown', ''),
                               '2005xxa3': ('IS', '1', 'Unknown', ''),
                               '2005xxa4': ('IS', '1', 'Unknown', ''),
                               '2005xxa5': ('IS', '1', 'Unknown', ''),
                               '2005xxa6': ('IS', '1', 'Unknown', ''),
                               '2005xxa7': ('CS', '1', 'Unknown', ''),
                               '2005xxa8': ('DS', '1', 'Unknown', ''),
                               '2005xxa9': ('CS', '1', 'Unknown', ''),
                               '2005xxb0': ('FL',
                                            '1',
                                            'Diffusion Direction RL',
                                            ''),
                               '2005xxb1': ('FL',
                                            '1',
                                            'Diffusion Direction AP',
                                            ''),
                               '2005xxb2': ('FL',
                                            '1',
                                            'Diffusion Direction FH',
                                            ''),
                               '2005xxc0': ('CS', '1', 'Unknown', '')},
 'Philips MR Imaging DD 002': {'2005xx32': ('SQ', '1', 'Unknown', ''),
                               '2005xx37': ('LO', '1', 'Unknown', ''),
                               '2005xx38': ('LO', '1', 'Unknown', ''),
                               '2005xx39': ('LO', '1', 'Unknown', ''),
                               '2005xx40': ('LO', '1', 'Unknown', ''),
                               '2005xx41': ('LO', '1', 'Unknown', ''),
                               '2005xx43': ('SL', '1', 'Unknown', ''),
                               '2005xx44': ('OW', '1', 'Unknown', ''),
                               '2005xx47': ('CS', '1', 'Unknown', ''),
                               '2005xx99': ('UL', '1', 'Unknown', '')},
 'Philips MR Imaging DD 003': {'2005xx00': ('UL', '1', 'Unknown', ''),
                               '2005xx01': ('UL', '1', 'Unknown', ''),
                               '2005xx13': ('UL', '1', 'Unknown', ''),
                               '2005xx34': ('SL', '1', 'Unknown', ''),
                               '2005xx45': ('SS', '1', 'Unknown', ''),
                               '2005xx49': ('SS', '1', 'Unknown', ''),
                               '2005xx51': ('SS', '1', 'Unknown', ''),
                               '2005xx52': ('SS', '1', 'Unknown', ''),
                               '2005xx53': ('SS', '1', 'Unknown', ''),
                               '2005xx56': ('SS', '1', 'Unknown', ''),
                               '2005xx57': ('SS', '1', 'Unknown', ''),
                               '2005xx81': ('UI', '1', 'Unknown', ''),
                               '2005xx82': ('CS', '1', 'Unknown', '')},
 'Philips MR Imaging DD 004': {'2005xx00': ('SS', '1', 'Unknown', ''),
                               '2005xx01': ('SS', '1', 'Unknown', ''),
                               '2005xx02': ('SS', '1', 'Unknown', ''),
                               '2005xx03': ('SS', '1', 'Unknown', ''),
                               '2005xx04': ('SS', '1', 'Unknown', ''),
                               '2005xx05': ('SS', '1', 'Unknown', ''),
                               '2005xx06': ('SS', '1', 'Unknown', ''),
                               '2005xx07': ('FL', '1', 'Unknown', ''),
                               '2005xx08': ('FL', '1', 'Unknown', ''),
                               '2005xx09': ('FL', '1', 'Unknown', ''),
                               '2005xx10': ('FL', '1', 'Unknown', ''),
                               '2005xx12': ('FL', '1', 'Unknown', ''),
                               '2005xx13': ('SS', '1', 'Unknown', ''),
                               '2005xx14': ('SS', '1', 'Unknown', ''),
                               '2005xx15': ('SS', '1', 'Unknown', ''),
                               '2005xx16': ('SS', '1', 'Unknown', ''),
                               '2005xx17': ('SS', '1', 'Unknown', ''),
                               '2005xx25': ('CS', '1', 'Unknown', ''),
                               '2005xx26': ('FL', '1', 'Unknown', ''),
                               '2005xx27': ('CS', '1', 'Unknown', ''),
                               '2005xx28': ('CS', '1', 'Unknown', ''),
                               '2005xx29': ('FL', '1', 'Unknown', ''),
                               '2005xx30': ('CS', '1-n', 'Unknown', ''),
                               '2005xx31': ('SS', '1', 'Unknown', ''),
                               '2005xx33': ('FL', '3', 'Unknown', ''),
                               '2005xx34': ('CS', '1', 'Unknown', ''),
                               '2005xx35': ('CS', '1', 'Unknown', ''),
                               '2005xx36': ('FL', '1', 'Unknown', ''),
                               '2005xx37': ('FL', '1', 'Unknown', ''),
                               '2005xx38': ('FL', '1', 'Unknown', ''),
                               '2005xx39': ('SS', '2', 'Unknown', ''),
                               '2005xx40': ('CS', '1', 'Unknown', ''),
                               '2005xx41': ('CS', '1', 'Unknown', ''),
                               '2005xx42': ('CS', '1', 'Unknown', ''),
                               '2005xx43': ('CS', '1', 'Unknown', ''),
                               '2005xx44': ('SS', '1-n', 'Unknown', ''),
                               '2005xx45': ('CS', '1', 'Unknown', ''),
                               '2005xx46': ('CS', '1', 'Unknown', ''),
                               '2005xx47': ('FL', '1', 'Unknown', ''),
                               '2005xx48': ('CS', '1', 'Unknown', ''),
                               '2005xx49': ('FL', '1', 'Unknown', ''),
                               '2005xx50': ('FL', '2', 'Unknown', ''),
                               '2005xx51': ('SS', '1', 'Unknown', ''),
                               '2005xx52': ('SS', '1', 'Unknown', ''),
                               '2005xx53': ('LO', '1-n', 'Unknown', ''),
                               '2005xx54': ('CS', '1', 'Unknown', ''),
                               '2005xx55': ('FL', '1-n', 'Unknown', ''),
                               '2005xx56': ('CS', '1', 'Unknown', ''),
                               '2005xx57': ('SS', '1', 'Unknown', ''),
                               '2005xx58': ('LO', '1', 'Unknown', ''),
                               '2005xx59': ('FL', '1', 'Unknown', ''),
                               '2005xx60': ('FL', '1', 'Unknown', ''),
                               '2005xx61': ('FL', '2', 'Unknown', ''),
                               '2005xx62': ('FL', '1', 'Unknown', ''),
                               '2005xx63': ('FL', '1', 'Unknown', ''),
                               '2005xx64': ('CS', '1', 'Unknown', ''),
                               '2005xx70': ('SS', '1', 'Unknown', ''),
                               '2005xx71': ('SQ', '1', 'Unknown', ''),
                               '2005xx72': ('SS', '1', 'Unknown', ''),
                               '2005xx73': ('SS', '1', 'Unknown', ''),
                               '2005xx74': ('SS', '1', 'Unknown', ''),
                               '2005xx75': ('SS', '1', 'Unknown', ''),
                               '2005xx76': ('SS', '1', 'Unknown', ''),
                               '2005xx77': ('SS', '1', 'Unknown', ''),
                               '2005xx78': ('SS', '1', 'Unknown', ''),
                               '2005xx79': ('SS', '1', 'Unknown', ''),
                               '2005xx81': ('IS', '1', 'Unknown', ''),
                               '2005xx82': ('UL', '1', 'Unknown', ''),
                               '2005xx89': ('SQ', '1', 'Unknown', ''),
                               '2005xx90': ('CS', '1', 'Unknown', ''),
                               '2005xx91': ('PN', '1', 'Unknown', ''),
                               '2005xx92': ('IS', '1', 'Unknown', ''),
                               '2005xx93': ('IS', '1', 'Unknown', ''),
                               '2005xx95': ('UI', '1', 'Unknown', ''),
                               '2005xx96': ('CS', '1', 'Unknown', ''),
                               '2005xx97': ('LO', '1', 'Unknown', ''),
                               '2005xx98': ('CS', '1', 'Unknown', ''),
                               '2005xx99': ('CS', '1', 'Unknown', '')},
 'Philips MR Imaging DD 005': {'2005xx00': ('CS', '1', 'Unknown', ''),
                               '2005xx01': ('UL', '1', 'Unknown', ''),
                               '2005xx02': ('SQ', '1', 'Unknown', ''),
                               '2005xx03': ('UL', '1', 'Unknown', ''),
                               '2005xx06': ('SS', '1', 'Unknown', ''),
                               '2005xx07': ('SS', '1', 'Unknown', ''),
                               '2005xx09': ('DS', '1', 'Unknown', ''),
                               '2005xx0a': ('DS', '1', 'Unknown', ''),
                               '2005xx0b': ('LO', '1', 'Unknown', ''),
                               '2005xx0e': ('SQ', '1', 'Unknown', ''),
                               '2005xx0f': ('SQ', '1', 'Unknown', ''),
                               '2005xx10': ('IS', '1', 'Unknown', ''),
                               '2005xx11': ('UI', '1', 'Unknown', ''),
                               '2005xx12': ('IS', '1', 'Unknown', ''),
                               '2005xx13': ('IS', '1', 'Unknown', ''),
                               '2005xx14': ('SL', '1', 'Unknown', ''),
                               '2005xx15': ('SL', '1', 'Unknown', ''),
                               '2005xx16': ('CS', '1', 'Unknown', ''),
                               '2005xx18': ('CS', '3', 'Unknown', ''),
                               '2005xx19': ('CS', '3', 'Unknown', ''),
                               '2005xx1a': ('CS', '1', 'Unknown', ''),
                               '2005xx1b': ('IS', '1', 'Unknown', ''),
                               '2005xx1c': ('IS', '1', 'Unknown', ''),
                               '2005xx1d': ('IS', '1', 'Unknown', ''),
                               '2005xx1e': ('UL', '1', 'Unknown', ''),
                               '2005xx1f': ('UL', '1', 'Unknown', ''),
                               '2005xx20': ('UL', '1', 'Unknown', ''),
                               '2005xx21': ('UL', '1', 'Unknown', ''),
                               '2005xx22': ('UL', '1', 'Unknown', ''),
                               '2005xx23': ('UL', '1', 'Unknown', ''),
                               '2005xx24': ('UL', '1', 'Unknown', ''),
                               '2005xx25': ('UL', '1', 'Unknown', ''),
                               '2005xx26': ('CS', '1', 'Unknown', ''),
                               '2005xx27': ('CS', '1', 'Unknown', ''),
                               '2005xx28': ('SL', '1', 'Unknown', ''),
                               '2005xx2a': ('CS', '1', 'Unknown', ''),
                               '2005xx2b': ('CS', '1', 'Unknown', ''),
                               '2005xx2c': ('CS', '1', 'Unknown', ''),
                               '2005xx2d': ('CS', '1', 'Unknown', ''),
                               '2005xx2e': ('FL', '1', 'Unknown', ''),
                               '2005xx2f': ('FL', '1', 'Unknown', ''),
                               '2005xx30': ('FL', '1', 'Unknown', ''),
                               '2005xx31': ('FL', '1', 'Unknown', ''),
                               '2005xx32': ('CS', '1', 'Unknown', ''),
                               '2005xx35': ('CS', '1', 'Unknown', ''),
                               '2005xx36': ('UI', '1', 'Unknown', ''),
                               '2005xx37': ('CS', '1', 'Unknown', ''),
                               '2005xx38': ('LT', '1', 'Unknown', ''),
                               '2005xx39': ('LT', '1', 'Unknown', ''),
                               '2005xx3a': ('LT', '1', 'Unknown', ''),
                               '2005xx3b': ('CS', '1', 'Unknown', ''),
                               '2005xx3c': ('FL', '1', 'Unknown', ''),
                               '2005xx3d': ('FL', '1', 'Unknown', ''),
                               '2005xx3e': ('FL', '1', 'Unknown', ''),
                               '2005xx3f': ('CS', '1', 'Unknown', ''),
                               '2005xx40': ('FL', '1', 'Unknown', ''),
                               '2005xx41': ('FL', '1', 'Unknown', ''),
                               '2005xx42': ('FL', '1', 'Unknown', ''),
                               '2005xx43': ('FL', '1', 'Unknown', ''),
                               '2005xx44': ('IS', '1', 'Unknown', ''),
                               '2005xx45': ('CS', '1', 'Unknown', ''),
                               '2005xx46': ('FL', '1', 'Unknown', ''),
                               '2005xx47': ('FL', '1', 'Unknown', ''),
                               '2005xx48': ('FL', '1', 'Unknown', ''),
                               '2005xx49': ('FL', '1', 'Unknown', ''),
                               '2005xx4a': ('FL', '1', 'Unknown', ''),
                               '2005xx4b': ('FL', '1', 'Unknown', ''),
                               '2005xx4c': ('FL', '1', 'Unknown', ''),
                               '2005xx4d': ('CS', '1', 'Unknown', ''),
                               '2005xx4e': ('CS', '1', 'Unknown', ''),
                               '2005xx4f': ('CS', '1', 'Unknown', ''),
                               '2005xx50': ('SS', '1', 'Unknown', '')},
 'Philips NM Private Group': {'7043xx00': ('SH', '1', 'Unknown', '')},
 'Philips PET Private Group': {'0511xx00': ('US', '1', 'Unknown', ''),
                               '0511xx01': ('US', '1', 'Unknown', ''),
                               '0511xx02': ('OB', '1', 'Unknown', ''),
                               '0511xx03': ('OB', '1', 'Unknown', ''),
                               '0511xx32': ('DS', '1', 'Unknown', ''),
                               '0511xx50': ('DS', '1', 'Unknown', ''),
                               '7053xx00': ('DS',
                                            '1',
                                            'SUV Scale Factor',
                                            ''),
                               '7053xx01': ('OB', '1', 'Private', ''),
                               '7053xx02': ('OB', '1', 'Private', ''),
                               '7053xx03': ('ST',
                                            '1',
                                            'Original image file name',
                                            ''),
                               '7053xx04': ('OB', '1', 'File Data', ''),
                               '7053xx05': ('LO',
                                            '1',
                                            'Worklist Info File Name',
                                            ''),
                               '7053xx06': ('OB', '1', 'Unknown', ''),
                               '7053xx07': ('SQ',
                                            '1',
                                            'Acquisition File Sequence',
                                            ''),
                               '7053xx08': ('SQ', '1', 'Unknown', ''),
                               '7053xx09': ('DS',
                                            '1',
                                            'Activity Concentration Scale Factor',
                                            ''),
                               '7053xx0f': ('UL', '1', 'Segment Size', ''),
                               '7053xx10': ('US', '1', 'Segment Number', ''),
                               '7053xx11': ('US',
                                            '1',
                                            'Number of Segments',
                                            ''),
                               '7053xx12': ('SQ',
                                            '1',
                                            'File Data Sequence',
                                            ''),
                               '7053xx13': ('SS', '1', 'Unknown', ''),
                               '7053xx14': ('SS', '1', 'Unknown', ''),
                               '7053xx15': ('SS', '1', 'Unknown', ''),
                               '7053xx16': ('SS', '1', 'Unknown', ''),
                               '7053xx17': ('SS', '1', 'Unknown', ''),
                               '7053xx18': ('SS', '1', 'Unknown', ''),
                               '7053xxc2': ('UI', '1', 'Unknown', '')},
 'Philips RAD Imaging DD 001': {'200bxx00': ('PN', '1', 'Unknown', ''),
                                '200bxx01': ('US', '1', 'Unknown', ''),
                                '200bxx02': ('US', '1', 'Unknown', ''),
                                '200bxx05': ('IS', '1', 'Unknown', ''),
                                '200bxx11': ('LO', '1', 'Unknown', ''),
                                '200bxx27': ('DT', '1', 'Unknown', ''),
                                '200bxx28': ('DS', '1', 'Unknown', ''),
                                '200bxx29': ('DS', '1', 'Unknown', ''),
                                '200bxx2a': ('UL', '1', 'Unknown', ''),
                                '200bxx2b': ('DA', '1', 'Unknown', ''),
                                '200bxx2c': ('TM', '1', 'Unknown', ''),
                                '200bxx2d': ('LO', '1', 'Unknown', ''),
                                '200bxx3b': ('LO', '1', 'Unknown', ''),
                                '200bxx40': ('SH', '1', 'Unknown', ''),
                                '200bxx41': ('SH', '1', 'Unknown', ''),
                                '200bxx42': ('UI', '1', 'Unknown', ''),
                                '200bxx43': ('UI', '1', 'Unknown', ''),
                                '200bxx47': ('DA', '1', 'Unknown', ''),
                                '200bxx48': ('SH', '1', 'Unknown', ''),
                                '200bxx4c': ('SH', '1', 'Unknown', ''),
                                '200bxx4d': ('SH', '1', 'Unknown', ''),
                                '200bxx4f': ('DT', '1', 'Unknown', ''),
                                '200bxx52': ('CS', '1', 'Unknown', '')},
 'Philips RAD Imaging DD 097': {'200bxx00': ('ST', '1', 'Unknown', ''),
                                '200bxx01': ('CS', '1', 'Unknown', ''),
                                '200bxx02': ('SS', '1', 'Unknown', ''),
                                '200bxx50': ('SS', '1', 'Unknown', ''),
                                '200bxx51': ('SS', '1', 'Unknown', ''),
                                '200bxx52': ('SS', '1', 'Unknown', ''),
                                '200bxx53': ('SS', '1', 'Unknown', ''),
                                '200bxx54': ('ST', '1', 'Unknown', ''),
                                '200bxx60': ('LT', '1', 'Unknown', ''),
                                '200bxx63': ('LT', '1', 'Unknown', ''),
                                '200bxx65': ('SS', '1', 'Unknown', ''),
                                '200bxx6e': ('US', '1', 'Unknown', ''),
                                '200bxx72': ('FD', '1', 'Unknown', ''),
                                '200bxx73': ('SS', '1', 'Unknown', ''),
                                '200bxx74': ('IS', '1', 'Unknown', ''),
                                '200bxx75': ('CS', '1', 'Unknown', ''),
                                '200bxx76': ('SH', '1', 'Unknown', ''),
                                '200bxx78': ('IS', '1-n', 'Unknown', ''),
                                '200bxx79': ('IS', '1', 'Unknown', ''),
                                '200bxx7a': ('IS', '1', 'Unknown', ''),
                                '200bxx7b': ('US', '1', 'Unknown', ''),
                                '200bxx7c': ('US', '1', 'Unknown', ''),
                                '200bxx7d': ('IS', '1-n', 'Unknown', ''),
                                '200bxx7e': ('UI', '1', 'Unknown', ''),
                                '200bxx81': ('LO', '1', 'Unknown', ''),
                                '200bxx82': ('LO', '1', 'Unknown', ''),
                                '200bxx85': ('IS', '1', 'Unknown', ''),
                                '200bxx86': ('CS', '1', 'Unknown', ''),
                                '200bxx88': ('CS', '1', 'Unknown', ''),
                                '200bxx89': ('LT', '1', 'Unknown', ''),
                                '200bxx90': ('DS', '1', 'Unknown', ''),
                                '200bxx96': ('SH', '1', 'Unknown', ''),
                                '200bxx99': ('SH', '1', 'Unknown', ''),
                                '200bxx9a': ('FD', '1', 'Unknown', ''),
                                '200bxx9b': ('FD', '1', 'Unknown', ''),
                                '200bxxa0': ('LT', '1', 'Unknown', '')},
 'Philips US Imaging 60': {'0031xx30': ('UL', '1', 'Private data', ''),
                           '0031xx31': ('UL', '1', 'Private data', '')},
 'Philips US Imaging DD 109': {'200dxx00': ('US', '1', 'Unknown', ''),
                               '200dxx01': ('SQ', '1', 'Unknown', ''),
                               '200dxx02': ('ST', '1', 'Unknown', ''),
                               '200dxx03': ('CS', '1', 'Unknown', ''),
                               '200dxx04': ('SL', '4', 'Unknown', ''),
                               '200dxx05': ('UL', '3', 'Unknown', ''),
                               '200dxx06': ('UL', '3', 'Unknown', ''),
                               '200dxx07': ('CS', '1', 'Unknown', ''),
                               '200dxx08': ('CS', '1', 'Unknown', ''),
                               '200dxx09': ('OB', '1', 'Unknown', ''),
                               '200dxx0a': ('UL', '1', 'Unknown', ''),
                               '200dxx0b': ('OB', '1', 'Unknown', ''),
                               '200dxx0c': ('UL', '1', 'Unknown', ''),
                               '200dxx0d': ('SQ', '1', 'Unknown', ''),
                               '200dxx0e': ('CS', '1', 'Unknown', ''),
                               '200dxx0f': ('LO', '1', 'Unknown', ''),
                               '200dxx10': ('SL', '1', 'Unknown', ''),
                               '200dxx11': ('LO', '1', 'Unknown', ''),
                               '200dxx12': ('SL', '1', 'Unknown', '')},
 'Philips US Imaging DD 113': {'200dxx01': ('LO', '1', 'Unknown', ''),
                               '200dxx02': ('UL', '1', 'Unknown', ''),
                               '200dxx03': ('UL', '1', 'Unknown', ''),
                               '200dxx04': ('UL', '1', 'Unknown', ''),
                               '200dxx05': ('UL', '1', 'Unknown', ''),
                               '200dxx06': ('UL', '1', 'Unknown', ''),
                               '200dxx07': ('CS', '1', 'Unknown', ''),
                               '200dxx09': ('UL', '1', 'Unknown', ''),
                               '200dxx0b': ('CS', '1', 'Unknown', ''),
                               '200dxx0c': ('UL', '1', 'Unknown', ''),
                               '200dxx0d': ('UL', '1', 'Unknown', ''),
                               '200dxx0e': ('UL', '1', 'Unknown', ''),
                               '200dxx0f': ('DS', '1', 'Unknown', ''),
                               '200dxx10': ('DS', '1', 'Unknown', ''),
                               '200dxx11': ('SL', '1', 'Unknown', ''),
                               '200dxx12': ('UL', '1', 'Unknown', ''),
                               '200dxx13': ('FL', '1-n', 'Unknown', ''),
                               '200dxx14': ('US', '1', 'Unknown', ''),
                               '200dxx15': ('UL', '1', 'Unknown', ''),
                               '200dxx17': ('FD', '1', 'Unknown', ''),
                               '200dxx18': ('FD', '1', 'Unknown', ''),
                               '200dxx19': ('FD', '1', 'Unknown', ''),
                               '200dxx1a': ('FD', '1', 'Unknown', ''),
                               '200dxx1b': ('FD', '1', 'Unknown', ''),
                               '200dxx1c': ('FD', '1', 'Unknown', ''),
                               '200dxx1d': ('UL', '1', 'Unknown', ''),
                               '200dxx1e': ('UL', '1', 'Unknown', ''),
                               '200dxx1f': ('FD', '1', 'Unknown', ''),
                               '200dxx20': ('FD', '1', 'Unknown', ''),
                               '200dxx21': ('FD', '1', 'Unknown', '')},
 'Philips US Private 3D': {'200dxx02': ('IS',
                                        '1',
                                        'Threedpr Echo Vision Setting',
                                        ''),
                           '200dxx03': ('IS',
                                        '1',
                                        'Threedpr Color Vision Setting',
                                        ''),
                           '200dxx04': ('IS',
                                        '1',
                                        'Threedpr Transparency',
                                        ''),
                           '200dxx06': ('FD',
                                        '1',
                                        'Threedpr Vision Vol Brightness',
                                        ''),
                           '200dxx08': ('IS',
                                        '1',
                                        'Threedpr Low Threshold',
                                        ''),
                           '200dxx09': ('IS',
                                        '1',
                                        'Threedpr Image Layout',
                                        ''),
                           '200dxx0a': ('IS',
                                        '1',
                                        'Threedpr Xres Filtering Enabled',
                                        ''),
                           '200dxx0b': ('IS',
                                        '1',
                                        'Threedpr Echo Twod Chroma Map Enabled',
                                        ''),
                           '200dxx0c': ('IS',
                                        '1',
                                        'Threedpr Box Outlined Enabled',
                                        ''),
                           '200dxx0d': ('IS',
                                        '1',
                                        'Threedpr Smoothing Enabled',
                                        ''),
                           '200dxx0e': ('IS',
                                        '1',
                                        'Threedpr Reference Graphic Enabled',
                                        ''),
                           '200dxx0f': ('IS',
                                        '1',
                                        'Threedpr Map Inverted',
                                        ''),
                           '200dxx10': ('IS',
                                        '1',
                                        'Threedpr Color Stream Display Enabled',
                                        ''),
                           '200dxx11': ('IS',
                                        '1',
                                        'Threedpr Echo Stream Display Enabled',
                                        ''),
                           '200dxx12': ('LO',
                                        '1',
                                        'Vdb Param Color 3d Estimate Scale(2)',
                                        ''),
                           '200dxx13': ('LO',
                                        '1',
                                        'Vdb Param Color 3d Estimate Apex Position (1)',
                                        ''),
                           '200dxx14': ('LO',
                                        '1',
                                        'Vdb Param Color 3d Estimate Color Offset',
                                        ''),
                           '200dxx15': ('LO',
                                        '1',
                                        'Vdb Param Echo 3d Estimate Dimension(2)',
                                        ''),
                           '200dxx16': ('SQ',
                                        '1',
                                        'Private Native Threed Data Sequence(1)',
                                        ''),
                           '200dxx17': ('IS',
                                        '1',
                                        'Threedpr Basic Vol Brightness',
                                        ''),
                           '200dxx18': ('LO',
                                        '1',
                                        'Vdb Param Echo 3d Estimate Apex Position (2)',
                                        ''),
                           '200dxx1a': ('IS',
                                        '1',
                                        'Threedpr Echo Smoothing',
                                        ''),
                           '200dxx1b': ('IS',
                                        '1',
                                        'Threedpr Color Smoothing',
                                        ''),
                           '200dxx1e': ('IS',
                                        '1',
                                        'Threedpr Num Completed Trim Planes',
                                        ''),
                           '200dxx1f': ('IS', '1', 'Threedpr Depth', ''),
                           '200dxx20': ('SQ',
                                        '1',
                                        'Private Native Data Stream Array',
                                        ''),
                           '200dxx21': ('IS',
                                        '1',
                                        'Threedpr Wall Filter',
                                        ''),
                           '200dxx23': ('FD', '1', 'Threedpr Baseline', ''),
                           '200dxx24': ('FD', '1', 'Threedpr Gain', ''),
                           '200dxx25': ('FD', '1', 'Threedpr Compress', ''),
                           '200dxx26': ('FD',
                                        '1',
                                        'Threedpr Light Brightness',
                                        ''),
                           '200dxx27': ('FD',
                                        '1',
                                        'Threedpr Elevation Scale Factor',
                                        ''),
                           '200dxx28': ('FD',
                                        '1',
                                        'Threedpr Zoom Factor',
                                        ''),
                           '200dxx29': ('FD',
                                        '1',
                                        'Threedpr Color Write Priority',
                                        ''),
                           '200dxx2a': ('FD',
                                        '1',
                                        'Threedpr Rotation Angle X',
                                        ''),
                           '200dxx2b': ('FD',
                                        '1',
                                        'Threedpr Rotation Angle Y',
                                        ''),
                           '200dxx2c': ('FD',
                                        '1',
                                        'Threedpr Data Voi Center',
                                        ''),
                           '200dxx2d': ('FD',
                                        '1',
                                        'Threedpr View Translation',
                                        ''),
                           '200dxx2e': ('FD',
                                        '1',
                                        'Threedpr Data Voi Min Point',
                                        ''),
                           '200dxx2f': ('FD',
                                        '1',
                                        'Threedpr Data Voi Max Point',
                                        ''),
                           '200dxx30': ('FD',
                                        '1',
                                        'Threedpr Box Crop Min Point',
                                        ''),
                           '200dxx31': ('FD',
                                        '1',
                                        'Threedpr Box Crop Max Point',
                                        ''),
                           '200dxx32': ('FD',
                                        '1',
                                        'Threedpr Mpr Rotation Matrix',
                                        ''),
                           '200dxx33': ('FD',
                                        '1',
                                        'Threedpr Vol Rotation Matrix',
                                        ''),
                           '200dxx34': ('FD',
                                        '1',
                                        'Threedpr Trim Plane Equation',
                                        ''),
                           '200dxx35': ('IS',
                                        '1',
                                        'Threedpr Subpage Data Version',
                                        ''),
                           '200dxx36': ('IS',
                                        '1',
                                        'Threedpr Is Arbitrary Crop',
                                        ''),
                           '200dxx37': ('IS',
                                        '1',
                                        'Threedpr Arbitrary Crop Dist From Center',
                                        ''),
                           '200dxx38': ('FD',
                                        '1',
                                        'Threedpr Arbitrary Crop Rotation Matrix',
                                        ''),
                           '200dxx39': ('FD', '1', 'Threedpr Color Gain', ''),
                           '200dxx40': ('IS',
                                        '1',
                                        'Threedpr Color Wall Filter Index',
                                        ''),
                           '200dxx41': ('IS',
                                        '1',
                                        'Threedpr Cursor Enabled',
                                        ''),
                           '200dxx42': ('IS',
                                        '1',
                                        'Threedpr Bondbox Graphic Enabled',
                                        '')},
 'Philips X-ray Imaging DD 001': {'2003xx00': ('CS', '1', 'Unknown', ''),
                                  '2003xx01': ('LO', '1', 'Unknown', ''),
                                  '2003xx02': ('FD', '3', 'Unknown', ''),
                                  '2003xx03': ('LO', '1', 'Unknown', ''),
                                  '2003xx04': ('SQ',
                                               '1',
                                               'Private enhanced Table Sequence',
                                               ''),
                                  '2003xx06': ('SL', '1', 'Unknown', ''),
                                  '2003xx09': ('SL', '1', 'Unknown', ''),
                                  '2003xx10': ('LO', '1', 'Unknown', ''),
                                  '2003xx11': ('SL', '1', 'Unknown', ''),
                                  '2003xx12': ('SL', '1', 'Unknown', ''),
                                  '2003xx13': ('SL', '1', 'Unknown', ''),
                                  '2003xx14': ('FD', '1', 'Unknown', ''),
                                  '2003xx15': ('FD', '1', 'Unknown', ''),
                                  '2003xx16': ('SL', '1', 'Unknown', ''),
                                  '2003xx17': ('SL', '1', 'Unknown', ''),
                                  '2003xx18': ('SL', '1', 'Unknown', ''),
                                  '2003xx19': ('SL', '1', 'Unknown', ''),
                                  '2003xx22': ('SL', '1', 'Unknown', ''),
                                  '2003xx24': ('FD', '4', 'Unknown', ''),
                                  '2003xx25': ('SL', '1', 'Unknown', ''),
                                  '2003xx26': ('SL', '1', 'Unknown', ''),
                                  '2003xx27': ('SH', '1', 'Unknown', ''),
                                  '2003xx28': ('SH', '1', 'Unknown', ''),
                                  '2003xx29': ('FD', '1', 'Unknown', ''),
                                  '2003xx2a': ('LO', '1', 'Unknown', ''),
                                  '2003xx2b': ('FD', '1', 'Unknown', ''),
                                  '2003xx2c': ('SH', '1', 'Unknown', ''),
                                  '2003xx2d': ('SL', '1-n', 'Unknown', ''),
                                  '2003xx2e': ('SQ', '1', 'Unknown', ''),
                                  '2003xx2f': ('CS',
                                               '1',
                                               'IsResolvePatientMixApplied',
                                               ''),
                                  '2003xx30': ('CS', '1', 'Unknown', ''),
                                  '2003xx31': ('CS', '1', 'Unknown', ''),
                                  '2003xx32': ('UI', '1', 'Unknown', '')},
 'Picker MR Private Group': {'7101xx00': ('OB', '1', 'Unknown', ''),
                             '7101xx01': ('SL', '1', 'Unknown', ''),
                             '7101xx02': ('OB', '1', 'Unknown', ''),
                             '7101xx03': ('SL', '1', 'Unknown', ''),
                             '7101xx04': ('SH', '1', 'Unknown', ''),
                             '7101xx05': ('SH', '2', 'Unknown', ''),
                             '7101xx06': ('SH', '4', 'Unknown', ''),
                             '7101xx10': ('DS', '1', 'Unknown', '')},
 'Picker NM Private Group': {'7001xx01': ('UI', '1', 'Private', ''),
                             '7001xx02': ('OB', '1', 'Private', ''),
                             '7001xx03': ('OB', '1', 'Private', ''),
                             '7001xx04': ('OB', '1', 'Private', ''),
                             '7001xx05': ('OB', '1', 'Private', ''),
                             '7001xx06': ('OB', '1', 'Private', ''),
                             '7001xx07': ('OB', '1', 'Private', ''),
                             '7001xx08': ('OB', '1', 'Private', ''),
                             '7001xx09': ('OB', '1', 'Private', ''),
                             '7001xx10': ('SQ', '1', 'Private', ''),
                             '7001xx11': ('LO', '1', 'Private', ''),
                             '7001xx12': ('OB', '1', 'Private', ''),
                             '7001xx13': ('US', '1', 'Private', ''),
                             '7001xx14': ('OB', '1', 'Private', ''),
                             '7001xx15': ('OB', '1', 'Private', ''),
                             '7001xx16': ('OB', '1', 'Private', ''),
                             '7001xx17': ('LO',
                                          '1',
                                          'Contains a text string that includes some of the same information that appears on the Odyssey Clinical Index (image directory) for this Image.',
                                          ''),
                             '7043xx00': ('SH', '1', 'Private.', '')},
 'QCA': {'0009xx00': ('CS', '1', 'Analysis Type', ''),
         '0009xx04': ('LO', '1', 'Segment Name', ''),
         '0009xx12': ('DS', '1', 'Pre Catheter size', ''),
         '0009xx13': ('DS', '1', 'Pre Reference Diameter', ''),
         '0009xx14': ('DS', '1', 'Pre Minimum Lumen Diameter', ''),
         '0009xx15': ('DS', '1', 'Pre Average Diameter', ''),
         '0009xx16': ('DS', '1', 'Pre Stenosis Length', ''),
         '0009xx17': ('DS', '1', 'Pre Stenosis %', ''),
         '0009xx18': ('DS', '1', 'Pre Geometric Area Reduction %', ''),
         '0009xx22': ('DS', '1', 'Post Catheter Size', ''),
         '0009xx23': ('DS', '1', 'Post Reference Diameter', ''),
         '0009xx24': ('DS', '1', 'Post Minimum Lumen Diameter', ''),
         '0009xx25': ('DS', '1', 'Post Average Diameter', ''),
         '0009xx26': ('DS', '1', 'Post Stenosis Length', ''),
         '0009xx27': ('DS', '1', 'Post Stenosis %', ''),
         '0009xx28': ('DS', '1', 'Post Geometric Area Reduction %', '')},
 'QCA_RESULTS': {'0009xx00': ('CS', '1', 'Analysis Views', ''),
                 '0009xx10': ('LO', '1', 'Segment', ''),
                 '0009xx11': ('LO', '1', 'Pre Catheter Name', ''),
                 '0009xx12': ('DS', '1', 'Pre Catheter Size', ''),
                 '0009xx13': ('DS', '1', 'Pre Reference Diameter', ''),
                 '0009xx14': ('DS', '1', 'Pre Minimum Lumen Diameter', ''),
                 '0009xx15': ('DS', '1', 'Pre Average Diameter', ''),
                 '0009xx16': ('DS', '1', 'Pre Stenosis Length', ''),
                 '0009xx17': ('IS', '1', 'Pre Stenosis %', ''),
                 '0009xx18': ('IS',
                              '1',
                              'Pre Geometric Area Reduction %',
                              ''),
                 '0009xx21': ('LO', '1', 'Post Catheter Name', ''),
                 '0009xx22': ('DS', '1', 'Post Catheter Size', ''),
                 '0009xx23': ('DS', '1', 'Post Reference Diameter', ''),
                 '0009xx24': ('DS', '1', 'Post Minimum Lumen Diameter', ''),
                 '0009xx25': ('DS', '1', 'Post Average Diameter', ''),
                 '0009xx26': ('DS', '1', 'Post Stenosis Length', ''),
                 '0009xx27': ('IS', '1', 'Post Stenosis %', ''),
                 '0009xx28': ('IS',
                              '1',
                              'Post Geometric Area Reduction %',
                              ''),
                 '0009xx40': ('IS', '1', 'Calibration Frame', ''),
                 '0009xx41': ('IS', '1', 'End Diastolic Frame', ''),
                 '0009xx42': ('IS', '1', 'End Systolic Frame', ''),
                 '0009xx43': ('DS', '1', 'End Diastolic Volume', ''),
                 '0009xx44': ('DS', '1', 'End Systolic Volume', ''),
                 '0009xx45': ('DS', '1', 'Stroke Volume', ''),
                 '0009xx47': ('DS', '1', 'Ejection Fraction', ''),
                 '0009xx48': ('DS', '1', 'Body Surface Area', ''),
                 '0009xx49': ('SH', '1', 'Artery Territory Region', ''),
                 '0009xx50': ('IS', '1', 'Number of Diseased Vessels', ''),
                 '0009xx51': ('DS', '1', 'Hypokinesis in Region', ''),
                 '0009xx52': ('DS',
                              '1',
                              'Hyperkinesis in Opposite Region',
                              ''),
                 '0009xx53': ('IS', '1', 'Percent Total LV Hypokinesis', ''),
                 '0009xx55': ('DS', '1', 'Calibration Factor', '')},
 'QUASAR_INTERNAL_USE': {'0009xx01': ('UL', '1-n', 'Rate Vector', ''),
                         '0009xx02': ('UL', '1-n', 'Count Vector', ''),
                         '0009xx03': ('UL', '1-n', 'Time Vector', ''),
                         '0009xx07': ('US', '1-n', 'Angle Vector', ''),
                         '0009xx08': ('US', '1', 'Camera Shape', ''),
                         '0009xx10': ('US', '1', 'WholeBody Spots', ''),
                         '0009xx11': ('US', '1', 'Worklist Flag', ''),
                         '0009xx12': ('LO', '1', 'Unknown', ''),
                         '0009xx13': ('ST', '1', 'Sequence Type', ''),
                         '0009xx14': ('ST', '1', 'Sequence Name', ''),
                         '0009xx15': ('UL', '1', 'Avr RR Time Vector', ''),
                         '0009xx16': ('UL', '1', 'Low Limit Vector', ''),
                         '0009xx17': ('UL', '1', 'High Limit Vector', ''),
                         '0009xx18': ('UL', '1', 'Begin Index Vector', ''),
                         '0009xx19': ('UL', '1', 'End Index Vector', ''),
                         '0009xx1a': ('UL', '1', 'Raw Time Vector', ''),
                         '0009xx1b': ('LO', '1', 'Image Type String', ''),
                         '0009xx1d': ('US', '1', 'Unknown', ''),
                         '0009xx1e': ('ST', '1', 'Unknown', ''),
                         '0009xx22': ('FL', '1', 'Unknown', ''),
                         '0009xx23': ('US', '1', 'Unknown', ''),
                         '0009xx39': ('UI', '1', 'Unknown', ''),
                         '0009xx40': ('DA', '1', 'Unknown', ''),
                         '0009xx41': ('TM', '1', 'Unknown', ''),
                         '0009xx42': ('LO', '1', 'Unknown', ''),
                         '0009xx44': ('SH', '1', 'Unknown', ''),
                         '0037xx10': ('SQ', '1', 'Unknown', ''),
                         '0037xx1b': ('LO', '1', 'Unknown', ''),
                         '0037xx30': ('LO', '1', 'Unknown', ''),
                         '0037xx40': ('LO', '1', 'Unknown', ''),
                         '0037xx50': ('LO', '1', 'Unknown', ''),
                         '0037xx60': ('LO', '1', 'Unknown', ''),
                         '0037xx70': ('LO', '1', 'Unknown', '')},
 'QVA': {'0009xx40': ('IS', '1', 'Calibration Frame', ''),
         '0009xx41': ('IS', '1', 'End Diastolic Frame', ''),
         '0009xx42': ('IS', '1', 'End Systolic Frame', ''),
         '0009xx43': ('DS', '1', 'End Diastolic Volume', ''),
         '0009xx44': ('DS', '1', 'End Systolic Volume', ''),
         '0009xx45': ('DS', '1', 'Stroke Volume', ''),
         '0009xx46': ('DS', '1', 'Cardiac Output', ''),
         '0009xx47': ('DS', '1', 'Ejection Fraction', ''),
         '0009xx48': ('DS', '1', 'Body Surface Area', ''),
         '0009xx49': ('SH', '1', 'Artery Territory Region', ''),
         '0009xx50': ('IS', '1', 'Number of Diseased Vessels', ''),
         '0009xx51': ('DS', '1', 'Hypokinesis in Region', ''),
         '0009xx52': ('DS', '1', 'Hyperkinesis in Region', ''),
         '0009xx53': ('IS',
                      '1',
                      'percent of chords with hyperkinesis <- 2 SD',
                      ''),
         '0009xx54': ('IS',
                      '1',
                      'percent of chords with alkinesis/dyskinesis',
                      ''),
         '0009xx55': ('DS', '1', 'Calibration Factor', '')},
 'REPORT_FROM_APP': {'0039xx95': ('LO', '1', 'Unknown', '')},
 'RadWorksMarconi': {'0029xx24': ('US', '1', '<internal', '')},
 'RadWorksTBR': {'3111xx02': ('CS', '1', 'AMI Compression Type (RET)', ''),
                 '3111xxff': ('SQ', '1', '<internal', '')},
 'SCHICK TECHNOLOGIES - Change Item Creator ID': {'0021xx01': ('UI',
                                                               '1',
                                                               'Change List Item UID',
                                                               ''),
                                                  '0021xx02': ('US',
                                                               '1',
                                                               'Operation',
                                                               ''),
                                                  '0021xx03': ('DT',
                                                               '1',
                                                               'Date',
                                                               ''),
                                                  '0021xx04': ('PN',
                                                               '1',
                                                               'User Name',
                                                               ''),
                                                  '0021xx05': ('OB',
                                                               '1',
                                                               'Additional Change Data',
                                                               '')},
 'SCHICK TECHNOLOGIES - Change List Creator ID': {'0021xx01': ('UI',
                                                               '1',
                                                               'Reference Image Instance UID',
                                                               ''),
                                                  '0021xx02': ('SQ',
                                                               '1',
                                                               'Sequence',
                                                               '')},
 'SCHICK TECHNOLOGIES - Image Security Creator ID': {'0029xx01': ('UL',
                                                                  '1',
                                                                  'Image Checksum',
                                                                  '')},
 'SCHICK TECHNOLOGIES - Note Item Creator ID': {'0021xx01': ('ST',
                                                             '1',
                                                             'Text',
                                                             ''),
                                                '0021xx02': ('DT',
                                                             '1',
                                                             'Date',
                                                             ''),
                                                '0021xx03': ('PN',
                                                             '1',
                                                             'User Name',
                                                             ''),
                                                '0021xx04': ('US',
                                                             '2',
                                                             'Coordinates (X, Y)',
                                                             '')},
 'SCHICK TECHNOLOGIES - Note List Creator ID': {'0021xx01': ('UI',
                                                             '1',
                                                             'Reference Image Instance UID',
                                                             ''),
                                                '0021xx02': ('SQ',
                                                             '1',
                                                             'Item',
                                                             '')},
 'SCHICK TECHNOLOGIES - Viewset Creator ID': {'0009xx01': ('UI',
                                                           '1',
                                                           'Instance UID',
                                                           ''),
                                              '0009xx02': ('LO',
                                                           '1',
                                                           'Name',
                                                           ''),
                                              '0009xx03': ('SQ',
                                                           '1',
                                                           'Sequence',
                                                           ''),
                                              '0009xx04': ('UL',
                                                           '1',
                                                           'Mode',
                                                           ''),
                                              '0009xx05': ('UL',
                                                           '1',
                                                           'Type',
                                                           '')},
 'SCHICK TECHNOLOGIES - Viewset Item Creator ID': {'0009xx01': ('UI',
                                                                '1',
                                                                'Image Instance UID',
                                                                ''),
                                                   '0009xx02': ('US',
                                                                '1',
                                                                'Number',
                                                                ''),
                                                   '0009xx03': ('US',
                                                                '1',
                                                                'Order',
                                                                ''),
                                                   '0009xx04': ('US',
                                                                '1',
                                                                'Type',
                                                                ''),
                                                   '0009xx05': ('US',
                                                                '1',
                                                                'Orientation',
                                                                ''),
                                                   '0009xx06': ('US',
                                                                '4',
                                                                'Rect (Left, Top, Width, Height)',
                                                                ''),
                                                   '0009xx07': ('US',
                                                                '1',
                                                                'Caption Height',
                                                                ''),
                                                   '0009xx08': ('US',
                                                                '1',
                                                                'Source',
                                                                ''),
                                                   '0009xx09': ('US',
                                                                '1',
                                                                'Default Width',
                                                                ''),
                                                   '0009xx0a': ('US',
                                                                '1',
                                                                'Default Height',
                                                                '')},
 'SECTRA_Ident_01': {'0009xx01': ('LO', '1', 'Request number', ''),
                     '0009xx02': ('LO', '1', 'Examination number', ''),
                     '0009xx04': ('LO', '1', 'Series ID', ''),
                     '0009xx05': ('LO', '1', 'Series Order', ''),
                     '0009xx06': ('LO', '1', 'File Name', ''),
                     '0009xx07': ('LO', '1', 'Image Data ID', '')},
 'SECTRA_ImageInfo_01': {'0029xx01': ('OB', '1', 'Image info', ''),
                         '0029xx02': ('CS', '1', 'Marking', ''),
                         '0029xx03': ('LO', '1', 'No Decompression', ''),
                         '0029xx04': ('OB', '1', 'Image Info new', '')},
 'SECTRA_OverlayInfo_01': {'6001xx01': ('LO', '1', 'Sectra Overlay', '')},
 'SEGAMI MIML': {'0031xx98': ('OW', '1', 'Unknown', '')},
 'SET WINDOW': {'0019xx00': ('UN', '1', 'Set Window Image Filter', ''),
                '0019xx01': ('UN', '1', 'Set Window Magnification Power', '')},
 'SHS MagicView 300': {'0029xx01': ('FD', '1-n', 'Zoom Factor', ''),
                       '0029xx02': ('FD', '1', 'Pan Factor X', ''),
                       '0029xx03': ('FD', '1', 'Pan Factor Y', ''),
                       '0029xx04': ('LO', '1', 'NmPalette', '')},
 'SIEMENS CM VA0  ACQU': {'0019xx10': ('LO', '1', 'Parameter File Name', ''),
                          '0019xx11': ('LO', '1', 'Sequence File Name', ''),
                          '0019xx12': ('LO', '1', 'Sequence File Owner', ''),
                          '0019xx13': ('LO', '1', 'Sequence Description', ''),
                          '0019xx14': ('LO', '1', 'EPI File Name', ''),
                          '0019xx20': ('LO', '1', 'Mode File Name', ''),
                          '0019xx30': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 1',
                                       ''),
                          '0019xx31': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 2',
                                       ''),
                          '0019xx32': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 3',
                                       ''),
                          '0019xx33': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 4',
                                       ''),
                          '0019xx34': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 5',
                                       ''),
                          '0019xx35': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 6',
                                       ''),
                          '0019xx36': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 7',
                                       ''),
                          '0019xx37': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 8',
                                       ''),
                          '0019xx38': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 9',
                                       ''),
                          '0019xx39': ('LO',
                                       '1',
                                       'Convolution Kernel Comment 10',
                                       ''),
                          '0019xx3a': ('LO',
                                       '1',
                                       'Reading Code RZ1 Comment 1',
                                       ''),
                          '0019xx3b': ('LO',
                                       '1',
                                       'Reading Code RZ1 Comment 2',
                                       ''),
                          '0019xx3c': ('LO',
                                       '1',
                                       'Reading Code RZ2 Comment 1',
                                       '')},
 'SIEMENS CM VA0  CMS': {'0009xx00': ('IS',
                                      '1',
                                      'Number of Measurements',
                                      ''),
                         '0009xx10': ('CS', '1', 'Storage Mode', ''),
                         '0009xx12': ('UL', '1', 'Evaluation Mask Image', ''),
                         '0009xx26': ('DA', '1', 'Table Zero Date', ''),
                         '0009xx27': ('TM', '1', 'Table Zero Time', ''),
                         '0011xx0a': ('LO', '1', 'Unknown', ''),
                         '0011xx10': ('DA', '1', 'Registration Date', ''),
                         '0011xx11': ('TM', '1', 'Registration Time', ''),
                         '0011xx22': ('LO', '1', 'Unknown', ''),
                         '0011xx23': ('DS', '1', 'Used Patient Weight', ''),
                         '0011xx40': ('IS', '1', 'Organ Code', ''),
                         '0013xx00': ('PN', '1', 'Modifying Physician', ''),
                         '0013xx10': ('DA', '1', 'Modification Date', ''),
                         '0013xx12': ('TM', '1', 'Modification Time', ''),
                         '0013xx20': ('PN', '1', 'Patient Name', ''),
                         '0013xx22': ('LO', '1', 'Patient Id', ''),
                         '0013xx30': ('DA', '1', 'Patient Birthdate', ''),
                         '0013xx31': ('DS', '1', 'Patient Weight', ''),
                         '0013xx32': ('PN', '1', 'Patient Maiden Name', ''),
                         '0013xx33': ('PN', '1', 'Referring Physician', ''),
                         '0013xx34': ('LO', '1', 'Admitting Diagnosis', ''),
                         '0013xx35': ('CS', '1', 'Patient Sex', ''),
                         '0013xx40': ('LO', '1', 'Procedure Description', ''),
                         '0013xx42': ('CS', '1', 'Rest Direction', ''),
                         '0013xx44': ('CS', '1', 'Patient Position', ''),
                         '0013xx46': ('SH', '1', 'View Direction', ''),
                         '0013xx50': ('LO', '1', 'Unknown', ''),
                         '0013xx51': ('LO', '1', 'Unknown', ''),
                         '0013xx52': ('LO', '1', 'Unknown', ''),
                         '0013xx53': ('LO', '1', 'Unknown', ''),
                         '0013xx54': ('LO', '1', 'Unknown', ''),
                         '0013xx55': ('LO', '1', 'Unknown', ''),
                         '0013xx56': ('LO', '1', 'Unknown', ''),
                         '0019xx10': ('IS', '1', 'Net Frequency', ''),
                         '0019xx20': ('CS', '1', 'Measurement Mode', ''),
                         '0019xx30': ('CS', '1', 'Calculation Mode', ''),
                         '0019xx50': ('IS', '1', 'Noise Level', ''),
                         '0019xx60': ('IS', '1', 'Number of Data Bytes', ''),
                         '0019xx70': ('DS', '1-n', 'Unknown', ''),
                         '0019xx80': ('LO', '1', 'Unknown', ''),
                         '0021xx20': ('DS', '1-n', 'Field of View', ''),
                         '0021xx22': ('DS',
                                      '1',
                                      'Image Magnification Factor',
                                      ''),
                         '0021xx24': ('DS', '1-n', 'Image Scroll Offset', ''),
                         '0021xx26': ('IS', '1', 'Image Pixel Offset', ''),
                         '0021xx30': ('CS', '1', 'View Direction', ''),
                         '0021xx32': ('CS', '1', 'Rest Direction', ''),
                         '0021xx60': ('DS', '1-n', 'Image Position', ''),
                         '0021xx61': ('DS', '1-n', 'Image Normal', ''),
                         '0021xx63': ('DS', '1', 'Image Distance', ''),
                         '0021xx65': ('US',
                                      '1',
                                      'Image Positioning History Mask',
                                      ''),
                         '0021xx6a': ('DS', '1-n', 'Image Row', ''),
                         '0021xx6b': ('DS', '1-n', 'Image Column', ''),
                         '0021xx70': ('CS',
                                      '1-n',
                                      'Patient Orientation Set 1',
                                      ''),
                         '0021xx71': ('CS',
                                      '1-n',
                                      'Patient Orientation Set 2',
                                      ''),
                         '0021xx80': ('LO', '1', 'Study Name', ''),
                         '0021xx82': ('SH', '1', 'Study Type', ''),
                         '0029xx10': ('CS', '1', 'Window Style', ''),
                         '0029xx11': ('CS', '1', 'Window Look', ''),
                         '0029xx12': ('UL', '1', 'Window Table Index', ''),
                         '0029xx13': ('CS', '1', 'Window Scale', ''),
                         '0029xx20': ('CS', '1-n', 'Pixel Quality Code', ''),
                         '0029xx22': ('IS', '1-n', 'Pixel Quality Value', ''),
                         '0029xx50': ('CS', '1', 'Archive Code', ''),
                         '0029xx51': ('CS', '1', 'Exposure Code', ''),
                         '0029xx52': ('IS', '1', 'Sort Code', ''),
                         '0029xx53': ('CS', '1', 'Remote Copy Code', ''),
                         '0029xx60': ('IS', '1', 'Splash', ''),
                         '0051xx10': ('LO', '1-n', 'Image Text', ''),
                         '6021xx00': ('CS',
                                      '1',
                                      'Image Graphics Format Code',
                                      ''),
                         '6021xx10': ('OB', '1', 'Image Graphics', ''),
                         '7fe1xx00': ('OB', '1-n', 'Binary Data', '')},
 'SIEMENS CM VA0  COAD': {'0019xx3d': ('LO',
                                       '1',
                                       'Reading Code RZ2 Comment 2',
                                       '')},
 'SIEMENS CM VA0  LAB': {'0009xx10': ('LO',
                                      '1',
                                      'Generator Identification Label',
                                      ''),
                         '0009xx11': ('LO',
                                      '1',
                                      'Gantry Identification Label',
                                      ''),
                         '0009xx12': ('LO',
                                      '1',
                                      'XRay Tube Identification Label',
                                      ''),
                         '0009xx13': ('LO',
                                      '1',
                                      'Detector Identification Label',
                                      ''),
                         '0009xx14': ('LO',
                                      '1',
                                      'DAS Identification Label',
                                      ''),
                         '0009xx15': ('LO',
                                      '1',
                                      'SMI Identification Label',
                                      ''),
                         '0009xx16': ('LO',
                                      '1',
                                      'CPU Identification Label',
                                      ''),
                         '0009xx20': ('SH', '1', 'Header Version', '')},
 'SIEMENS CM VA0  OST': {'6023xx00': ('LO', '1', 'Osteo Contour Comment', ''),
                         '6023xx10': ('SS',
                                      '1-n',
                                      'Osteo Contour Buffer',
                                      '')},
 'SIEMENS CSA ENVELOPE': {'0029xx10': ('OB', '1', 'syngo Report Data', ''),
                          '0029xx11': ('OB',
                                       '1',
                                       'syngo Report Presentation',
                                       '')},
 'SIEMENS CSA HEADER': {'0029xx08': ('CS', '1', 'CSA Image Header Type', ''),
                        '0029xx09': ('LO',
                                     '1',
                                     'CSA Image Header Version',
                                     ''),
                        '0029xx10': ('OB', '1', 'CSA Image Header Info', ''),
                        '0029xx18': ('CS', '1', 'CSA Series Header Type', ''),
                        '0029xx19': ('LO',
                                     '1',
                                     'CSA Series Header Version',
                                     ''),
                        '0029xx20': ('OB', '1', 'CSA Series Header Info', '')},
 'SIEMENS CSA NON-IMAGE': {'0029xx08': ('CS', '1', 'CSA Data Type', ''),
                           '0029xx09': ('LO', '1', 'CSA Data Version', ''),
                           '0029xx10': ('OB', '1', 'CSA Data Info', ''),
                           '7fe1xx10': ('OB', '1', 'CSA Data', '')},
 'SIEMENS CSA REPORT': {'0029xx08': ('CS', '1', 'syngo Report Type', ''),
                        '0029xx09': ('LO', '1', 'syngo Report', ''),
                        '0029xx15': ('US', '1', 'SR Variant', ''),
                        '0029xx17': ('UI', '1', 'SC SOP Instance UID', '')},
 'SIEMENS CT VA0  COAD': {'0019xx10': ('IS',
                                       '1',
                                       'Distance Source to SourceSide Collimator',
                                       ''),
                          '0019xx11': ('IS',
                                       '1',
                                       'Distance Source to DetectorSide Collimator',
                                       ''),
                          '0019xx20': ('IS',
                                       '1',
                                       'Number of Possible Channels',
                                       ''),
                          '0019xx21': ('IS', '1', 'Mean Channel Number', ''),
                          '0019xx22': ('DS', '1', 'Detector Spacing', ''),
                          '0019xx23': ('DS', '1', 'Detector Center', ''),
                          '0019xx24': ('DS',
                                       '1',
                                       'Reading Integration Time',
                                       ''),
                          '0019xx50': ('DS', '1', 'Detector Alignment', ''),
                          '0019xx52': ('DS', '1', 'Table Feed', ''),
                          '0019xx54': ('DS', '1', 'Rotation Time', ''),
                          '0019xx60': ('DS', '1', 'Focus Alignment', ''),
                          '0019xx65': ('UL',
                                       '1',
                                       'Focal Spot Deflection Amplitude',
                                       ''),
                          '0019xx66': ('UL',
                                       '1',
                                       'Focal Spot Deflection Phase',
                                       ''),
                          '0019xx67': ('UL',
                                       '1',
                                       'Focal Spot Deflection Offset',
                                       ''),
                          '0019xx70': ('DS', '1', 'Water Scaling Factor', ''),
                          '0019xx71': ('DS', '1', 'Interpolation Factor', ''),
                          '0019xx80': ('CS', '1', 'Patient Region', ''),
                          '0019xx82': ('CS',
                                       '1',
                                       'Patient Phase of Life',
                                       ''),
                          '0019xx90': ('DS', '1', 'Osteo Offset', ''),
                          '0019xx92': ('DS',
                                       '1',
                                       'Osteo Regression Line Slope',
                                       ''),
                          '0019xx93': ('DS',
                                       '1',
                                       'Osteo Regression Line Intercept',
                                       ''),
                          '0019xx94': ('IS',
                                       '1',
                                       'Osteo Standardization Code',
                                       ''),
                          '0019xx96': ('IS', '1', 'Osteo Phantom Number', ''),
                          '0019xxa0': ('DS',
                                       '1',
                                       'Spiral Location Begin',
                                       ''),
                          '0019xxa1': ('DS', '1', 'Spiral Location End', ''),
                          '0019xxa2': ('CS', '1', 'Spiral z Profile', ''),
                          '0019xxa3': ('CS',
                                       '1',
                                       'Spiral Reconstruction Direction',
                                       ''),
                          '0019xxa4': ('DS',
                                       '1',
                                       'Spiral Reconstruction Increment',
                                       ''),
                          '0019xxa5': ('DS',
                                       '1',
                                       'Scan Tilt Plane Distance',
                                       ''),
                          '0019xxa6': ('UL',
                                       '1-n',
                                       'Mode Processing Step Mask',
                                       ''),
                          '0019xxa7': ('UL',
                                       '1',
                                       'Mode Processing Control Mask',
                                       ''),
                          '0019xxa8': ('UL', '1-n', 'Mode Master Mask', ''),
                          '0019xxa9': ('IS', '1', 'Mode Store Step', ''),
                          '0019xxaa': ('CS', '1', 'Focus Size Type', ''),
                          '0019xxab': ('IS',
                                       '1',
                                       'Mode Adaptive Filter Kind',
                                       ''),
                          '0019xxac': ('IS', '1', 'Mode MBH Kind', ''),
                          '0019xxad': ('IS', '1', 'Mode Balancing Kind', ''),
                          '0019xxae': ('IS',
                                       '1',
                                       'Number of Readings per Rotation',
                                       ''),
                          '0019xxaf': ('DS',
                                       '1',
                                       'Correction Table Reference Time',
                                       ''),
                          '0019xxb0': ('DS', '1', 'Feed per Rotation', ''),
                          '0019xxbd': ('IS', '1', 'Pulmo Trigger Level', ''),
                          '0019xxbe': ('DS', '1', 'Expiratoric Reserve', ''),
                          '0019xxbf': ('DS', '1', 'Vital Capacity', ''),
                          '0019xxc0': ('DS', '1', 'Pulmo Water', ''),
                          '0019xxc1': ('DS', '1', 'Pulmo Air', ''),
                          '0019xxc2': ('DA', '1', 'Pulmo Date', ''),
                          '0019xxc3': ('TM', '1', 'Pulmo Time', ''),
                          '0019xxc4': ('UL', '1', 'Unknown', ''),
                          '0019xxc5': ('IS', '1', 'Unknown', '')},
 'SIEMENS CT VA0  GEN': {'0019xx10': ('DS',
                                      '1',
                                      'Source Side Collimator Aperture',
                                      ''),
                         '0019xx11': ('DS',
                                      '1',
                                      'Detector Side Collimator Aperture',
                                      ''),
                         '0019xx20': ('IS', '1', 'Exposure Time current', ''),
                         '0019xx21': ('IS', '1', 'Exposure current', ''),
                         '0019xx25': ('DS',
                                      '1',
                                      'Generator Power current',
                                      ''),
                         '0019xx26': ('DS',
                                      '1',
                                      'Generator Voltage current',
                                      ''),
                         '0019xx40': ('UL', '1', 'Master Control Mask', ''),
                         '0019xx42': ('US', '1-n', 'Processing Mask', ''),
                         '0019xx44': ('UL', '1-n', 'IRS Data Number', ''),
                         '0019xx45': ('UL', '1-n', 'IRS Data Length', ''),
                         '0019xx62': ('IS',
                                      '1',
                                      'Number of Virtuell Channels',
                                      ''),
                         '0019xx70': ('IS', '1', 'Number of Reading', ''),
                         '0019xx71': ('CS', '1', 'Reading Code', ''),
                         '0019xx74': ('IS', '1', 'Number of Projections', ''),
                         '0019xx75': ('IS', '1', 'Number of Bytes', ''),
                         '0019xx80': ('IS',
                                      '1-n',
                                      'Reconstruction Algorithm Set',
                                      ''),
                         '0019xx81': ('IS',
                                      '1',
                                      'Reconstruction Algorithm Index',
                                      ''),
                         '0019xx82': ('LO',
                                      '1',
                                      'Regeneration Software Version',
                                      ''),
                         '0019xx84': ('IS',
                                      '1',
                                      'Multiscan Reconstruction Increment',
                                      ''),
                         '0019xx85': ('IS',
                                      '1',
                                      'Multiscan Reconstruction Width',
                                      ''),
                         '0019xx88': ('IS', '1', 'Range Number', ''),
                         '0021xx10': ('IS', '1', 'Rotation Angle', ''),
                         '0021xx11': ('IS', '1', 'Start Angle', ''),
                         '0021xx20': ('IS', '1', 'Scan', ''),
                         '0021xx30': ('IS', '1', 'Tube Position', ''),
                         '0021xx32': ('DS', '1', 'Length of Topogram', ''),
                         '0021xx34': ('DS', '1', 'Correction Factor', ''),
                         '0021xx36': ('DS',
                                      '1',
                                      'Maximum Table Position',
                                      ''),
                         '0021xx40': ('IS',
                                      '1',
                                      'Table Move Direction Code',
                                      ''),
                         '0021xx45': ('IS', '1', 'VOI Start Row', ''),
                         '0021xx46': ('IS', '1', 'VOI Stop Row', ''),
                         '0021xx47': ('IS', '1', 'VOI Start Column', ''),
                         '0021xx48': ('IS', '1', 'VOI Stop Column', ''),
                         '0021xx49': ('IS', '1', 'VOI Start Slice', ''),
                         '0021xx4a': ('IS', '1', 'VOI Stop Slice', ''),
                         '0021xx50': ('IS', '1', 'Vector Start Row', ''),
                         '0021xx51': ('IS', '1', 'Vector Row Step', ''),
                         '0021xx52': ('IS', '1', 'Vector Start Column', ''),
                         '0021xx53': ('IS', '1', 'Vector Column Step', ''),
                         '0021xx60': ('IS', '1', 'Range Type Code', ''),
                         '0021xx62': ('IS', '1', 'Reference Type Code', ''),
                         '0021xx70': ('DS', '1-n', 'Object Orientation', ''),
                         '0021xx72': ('DS', '1-n', 'Light Orientation', ''),
                         '0021xx75': ('DS', '1', 'Light Brightness', ''),
                         '0021xx76': ('DS', '1', 'Light Contrast', ''),
                         '0021xx7a': ('IS', '1-n', 'Overlay Threshold', ''),
                         '0021xx7b': ('IS', '1-n', 'Surface Threshold', ''),
                         '0021xx7c': ('IS',
                                      '1-n',
                                      'Grey Scale Threshold',
                                      ''),
                         '0021xxa0': ('IS', '1-n', 'Field of Interest', ''),
                         '0021xxa1': ('CS', '1', 'Image Filter Label', ''),
                         '0021xxa2': ('CS', '1', 'Exemplary Element 1', ''),
                         '0021xxa3': ('IS', '1-n', 'Exemplary Element 2', ''),
                         '0021xxa4': ('LO', '1', 'Exemplary Element 3', ''),
                         '0021xxa5': ('IS', '1', 'Reference Data Set 1', ''),
                         '0021xxa6': ('IS', '1', 'Reference Data Set 2', ''),
                         '0021xxa7': ('LO', '1', 'Window Program Name', '')},
 'SIEMENS CT VA0  IDE': {'0009xx10': ('LO', '1', 'SOMATOM Software Name', ''),
                         '0009xx30': ('CS', '1', 'Data Set Subtype 1', ''),
                         '0009xx31': ('SH', '1', 'Data Set Subtype 2', ''),
                         '0009xx32': ('SH', '1', 'Data Set Subtype 3', ''),
                         '0009xx33': ('SH', '1', 'Data Set Subtype 4', ''),
                         '0009xx34': ('SH', '1', 'Data Set Subtype 5', ''),
                         '0009xx40': ('LO', '1', 'Directory Text', ''),
                         '0009xx42': ('LO', '1', 'Exposure Time Text', ''),
                         '0009xx50': ('DA', '1', 'Scan Date', ''),
                         '0009xx51': ('TM', '1', 'Scan Time', '')},
 'SIEMENS CT VA0  ORI': {'0009xx20': ('LO',
                                      '1',
                                      'Original Data Set Owner',
                                      ''),
                         '0009xx30': ('SH', '1', 'Original Modality', '')},
 'SIEMENS CT VA0  ORMR': {'0021xx80': ('DS', '1', 'Repetition Time', ''),
                          '0021xx81': ('DS', '1', 'Echo Time', ''),
                          '0021xx82': ('DS', '1', 'Inversion Time', ''),
                          '0021xx83': ('IS', '1', 'Number of Averages', ''),
                          '0021xx84': ('DS', '1', 'Imaging Frequency', ''),
                          '0021xx85': ('LO', '1', 'Imaged Nucleus', ''),
                          '0021xx86': ('IS', '1', 'Echo Number', ''),
                          '0021xx90': ('DS', '1', 'Flip Angle', '')},
 'SIEMENS CT VA0  OST': {'6021xx00': ('LO', '1', 'Osteo Contour Comment', ''),
                         '6021xx10': ('US',
                                      '256',
                                      'Osteo Contour Buffer',
                                      '')},
 'SIEMENS CT VA0  RAW': {'0021xx10': ('UL',
                                      '1-n',
                                      'Creation Mask service',
                                      ''),
                         '0021xx20': ('UL',
                                      '1-n',
                                      'Evaluation Mask service',
                                      ''),
                         '0021xx30': ('US',
                                      '1-n',
                                      'Extended Processing Mask',
                                      ''),
                         '0021xx40': ('UL', '1-n', 'Manipulation Mask', ''),
                         '0021xx41': ('UL', '1-n', 'Composition Mask', ''),
                         '0021xx42': ('UL', '1-n', 'Alteration Mask', ''),
                         '0021xx43': ('UL', '1-n', 'Generation Mask', ''),
                         '0021xx44': ('UL', '1-n', 'Function Mask', ''),
                         '0021xx50': ('CS', '1', 'Mode Mirroring Code', '')},
 'SIEMENS DFR.01': {'0021xx10': ('US', '1', 'Graphic Evaluation Mask', ''),
                    '0021xx11': ('US', '1', 'Type 1st Graphic Element', ''),
                    '0021xx12': ('LO',
                                 '1',
                                 'Description 1st Graphic Element',
                                 ''),
                    '0021xx13': ('US', '1', 'Type 2nd Graphic Element', ''),
                    '0021xx14': ('LO',
                                 '1',
                                 'Description 2nd Graphic Element',
                                 ''),
                    '0021xx15': ('US', '1', 'Type 3rd Graphic Element', ''),
                    '0021xx16': ('LO',
                                 '1',
                                 'Description 3rd Graphic Element',
                                 ''),
                    '0021xx17': ('US', '1', 'Type 4th Graphic Element', ''),
                    '0021xx18': ('LO',
                                 '1',
                                 'Description 4th Graphic Element',
                                 ''),
                    '0021xx19': ('US', '1', 'Type 5th Graphic Element', ''),
                    '0021xx20': ('LO',
                                 '1',
                                 'Description 5th Graphic Element',
                                 ''),
                    '0021xx21': ('US', '1', 'Type 6th Graphic Element', ''),
                    '0021xx22': ('LO',
                                 '1',
                                 'Description 6th Graphic Element',
                                 ''),
                    '0021xx23': ('US', '1', 'Type 7th Graphic Element', ''),
                    '0021xx24': ('LO',
                                 '1',
                                 'Description 7th Graphic Element',
                                 ''),
                    '0021xx25': ('US', '1', 'Type 8th Graphic Element', ''),
                    '0021xx26': ('LO',
                                 '1',
                                 'Description 8th Graphic Element',
                                 ''),
                    '0021xx27': ('US', '1', 'Type 9th Graphic Element', ''),
                    '0021xx28': ('LO',
                                 '1',
                                 'Description 9th Graphic Element',
                                 ''),
                    '0021xx29': ('US', '1', 'Type 10th Graphic Element', ''),
                    '0021xx30': ('LO',
                                 '1',
                                 'Description 10th Graphic Element',
                                 '')},
 'SIEMENS DFR.01 MANIPULATED': {'0017xx11': ('US',
                                             '1',
                                             'Window Width Native Current',
                                             ''),
                                '0017xx12': ('US',
                                             '1',
                                             'Window Center Native',
                                             ''),
                                '0017xx14': ('US',
                                             '1',
                                             'Window Width Subtraction Current',
                                             ''),
                                '0017xx15': ('US',
                                             '1',
                                             'Window Center Subtraction Current',
                                             ''),
                                '0017xx25': ('DS',
                                             '1',
                                             'Edge Enhancement Native Current',
                                             ''),
                                '0017xx27': ('DS',
                                             '1',
                                             'Edge Enhancement Subtraction Current',
                                             ''),
                                '0017xx29': ('IS',
                                             '1',
                                             'Edge Enhancement %',
                                             ''),
                                '0017xx30': ('IS',
                                             '1',
                                             'Harmonization %',
                                             ''),
                                '0017xx31': ('US',
                                             '1',
                                             'DSA Representation Current',
                                             ''),
                                '0017xx32': ('US',
                                             '1',
                                             'Number of Mask Current',
                                             ''),
                                '0017xx33': ('US',
                                             '1',
                                             'RightLeft Mark Current',
                                             ''),
                                '0017xx35': ('US',
                                             '1',
                                             'Number of Series Representative',
                                             ''),
                                '0017xx37': ('US',
                                             '1',
                                             'Rectangle Shutter Horizontal Current',
                                             ''),
                                '0017xx38': ('US',
                                             '1',
                                             'Rectangle Shutter Vertical Aktuell',
                                             ''),
                                '0017xx71': ('LO',
                                             '1',
                                             'Landmark Current',
                                             ''),
                                '0017xx72': ('US', '1', 'Zoom Factor', ''),
                                '0017xx73': ('US',
                                             '1',
                                             'Roam Horizontal',
                                             ''),
                                '0017xx74': ('US', '1', 'Roam Vertikal', ''),
                                '0017xx77': ('IS',
                                             '1',
                                             'Pixel Shift Horizontal',
                                             ''),
                                '0017xx78': ('IS',
                                             '1',
                                             'Pixel Shift Vertikal',
                                             ''),
                                '0017xx79': ('US', '1', 'Image Flip', ''),
                                '0017xx7a': ('US', '1', 'Invers Current', ''),
                                '0017xx80': ('US', '1', 'Unknown', ''),
                                '0017xx83': ('SH',
                                             '1',
                                             'Documentation Flag',
                                             ''),
                                '0017xx84': ('LO', '1', 'Right Marker', ''),
                                '0017xx91': ('US',
                                             '1',
                                             'Summation Count Filling',
                                             ''),
                                '0017xx92': ('US',
                                             '1',
                                             'Summation Count Mask',
                                             ''),
                                '0017xx93': ('US', '1', 'PeakOp Start', ''),
                                '0017xx94': ('US', '1', 'PeakOp End', ''),
                                '0017xxa0': ('IS', '1', 'Cine Rate', ''),
                                '0017xxa1': ('LO', '1', 'Image Name', ''),
                                '0017xxa2': ('LO',
                                             '1',
                                             'Image Name Extension 1',
                                             ''),
                                '0017xxa3': ('LO',
                                             '1',
                                             'Image Name Extension 2',
                                             '')},
 'SIEMENS DFR.01 ORIGINAL': {'0017xx10': ('CS', '1', 'Image Type', ''),
                             '0017xx11': ('US',
                                          '1',
                                          'Window Width Native Original',
                                          ''),
                             '0017xx12': ('US',
                                          '1',
                                          'Window Center Native',
                                          ''),
                             '0017xx14': ('US',
                                          '1',
                                          'Window Width Subtraction Original',
                                          ''),
                             '0017xx15': ('US',
                                          '1',
                                          'Window Center Subtraction Original',
                                          ''),
                             '0017xx16': ('US',
                                          '1',
                                          'LUT Number for Autowindow',
                                          ''),
                             '0017xx18': ('US', '1', 'Unknown', ''),
                             '0017xx21': ('US',
                                          '1',
                                          'Edge Enhancement Kernelsize Original',
                                          ''),
                             '0017xx22': ('US',
                                          '1',
                                          'Edge Enhancement Mode Original',
                                          ''),
                             '0017xx23': ('US',
                                          '1-n',
                                          'Edge Enhancement LUTs Original',
                                          ''),
                             '0017xx24': ('US',
                                          '1',
                                          'Filter Type Native Original',
                                          ''),
                             '0017xx25': ('DS',
                                          '1',
                                          'Edge Enhancement Native Original',
                                          ''),
                             '0017xx26': ('US',
                                          '1',
                                          'Filter Type Subtraction Original',
                                          ''),
                             '0017xx27': ('DS',
                                          '1',
                                          'Edge Enhancement Subtraction Original',
                                          ''),
                             '0017xx2a': ('US', '1', 'Unknown', ''),
                             '0017xx30': ('IS', '1', 'Unknown', ''),
                             '0017xx31': ('US',
                                          '1',
                                          'DSA Representation Original',
                                          ''),
                             '0017xx32': ('US',
                                          '1',
                                          'Number of Maske Original',
                                          ''),
                             '0017xx33': ('US',
                                          '1',
                                          'RightLeft Mark Original',
                                          ''),
                             '0017xx34': ('DS', '1', 'Slice Position', ''),
                             '0017xx37': ('US',
                                          '1',
                                          'Rectangle Shutter Horizontal Original',
                                          ''),
                             '0017xx38': ('US',
                                          '1',
                                          'Rectangle Vertical Original',
                                          ''),
                             '0017xx41': ('DS', '1', 'Dose', ''),
                             '0017xx42': ('DS', '1', 'Dose Area Product', ''),
                             '0017xx43': ('US', '1', 'Focus', ''),
                             '0017xx44': ('US', '1', 'SDM', ''),
                             '0017xx45': ('DS',
                                          '1',
                                          'Image Intensifer Format',
                                          ''),
                             '0017xx46': ('DS',
                                          '1',
                                          'Density Correction',
                                          ''),
                             '0017xx47': ('LO', '1', 'Exposure Curves', ''),
                             '0017xx48': ('IS', '1', 'Unknown', ''),
                             '0017xx49': ('LO',
                                          '1',
                                          'Organ Program Name',
                                          ''),
                             '0017xx4a': ('IS',
                                          '1',
                                          'Count of Images in Series',
                                          ''),
                             '0017xx51': ('US',
                                          '1',
                                          'Image Intensifier Zoom',
                                          ''),
                             '0017xx52': ('UL',
                                          '1',
                                          'ROSA Receiver ErrCount',
                                          ''),
                             '0017xx61': ('US',
                                          '1',
                                          'Table Position Peri',
                                          ''),
                             '0017xx62': ('US',
                                          '1-n',
                                          'Series Numbers of Petri',
                                          ''),
                             '0017xx71': ('LO', '1', 'Landmark Original', ''),
                             '0017xx72': ('US', '1', 'Unknown', ''),
                             '0017xx73': ('US', '1', 'Unknown', ''),
                             '0017xx74': ('US', '1', 'Unknown', ''),
                             '0017xx79': ('US', '1', 'Unknown', ''),
                             '0017xx7a': ('US', '1', 'Invers Original', ''),
                             '0017xx7b': ('IS', '1', 'Unknown', ''),
                             '0017xxa0': ('IS', '1', 'Unknown', ''),
                             '0017xxb1': ('CS', '1', 'L2 Image', ''),
                             '0017xxb2': ('IS',
                                          '1',
                                          'L2 Acquisition Monitor',
                                          ''),
                             '0017xxc1': ('LO', '1', 'Folder UID', ''),
                             '0017xxc2': ('LO', '1', 'Series UID', ''),
                             '0017xxc3': ('LO', '1', 'Subseries UID', '')},
 'SIEMENS DFR.01 SERVICE': {'0021xx10': ('US', '1', '1 Plot', ''),
                            '0021xx11': ('US', '1', 'Width 1 Plot', ''),
                            '0021xx12': ('US', '1', '2 Plot', ''),
                            '0021xx13': ('US', '1', 'Width 2 Plot', ''),
                            '0021xx20': ('US',
                                         '1-5',
                                         'xCoordinate Region of Interest',
                                         ''),
                            '0021xx21': ('US',
                                         '1-5',
                                         'yCoordinate Region of Interest',
                                         ''),
                            '0021xx22': ('US',
                                         '1-5',
                                         'Width Region of Interest',
                                         ''),
                            '0021xx23': ('US',
                                         '1-5',
                                         'Height Region of Interest',
                                         '')},
 'SIEMENS DICOM': {'0009xx10': ('UN', '1', 'Unknown', ''),
                   '0009xx12': ('LO', '1', 'Unknown', '')},
 'SIEMENS DLR.01': {'0019xx10': ('LO', '1', 'Measurement Mode', ''),
                    '0019xx11': ('LO', '1', 'Image Type', ''),
                    '0019xx15': ('LO', '1', 'Software Version', ''),
                    '0019xx20': ('LO', '1', 'MPM Code', ''),
                    '0019xx21': ('LO', '1', 'Latitude', ''),
                    '0019xx22': ('LO', '1', 'Sensitivity', ''),
                    '0019xx23': ('LO', '1', 'EDR', ''),
                    '0019xx24': ('LO', '1', 'l fix', ''),
                    '0019xx25': ('LO', '1', 's fix', ''),
                    '0019xx26': ('LO', '1', 'Preset Mode', ''),
                    '0019xx27': ('LO', '1', 'Region', ''),
                    '0019xx28': ('LO', '1', 'Subregion', ''),
                    '0019xx30': ('LO', '1', 'Orientation', ''),
                    '0019xx31': ('LO', '1', 'Mark on Film', ''),
                    '0019xx32': ('LO', '1', 'Rotation on DRC', ''),
                    '0019xx40': ('LO', '1', 'Reader Type', ''),
                    '0019xx41': ('LO', '1', 'Sub Modality', ''),
                    '0019xx42': ('LO', '1', 'Reader Serial Number', ''),
                    '0019xx50': ('LO', '1', 'Cassette Scale', ''),
                    '0019xx51': ('LO', '1', 'Cassette Matrix', ''),
                    '0019xx52': ('LO', '1', 'Cassette Submatrix', ''),
                    '0019xx53': ('LO', '1', 'Barcode', ''),
                    '0019xx60': ('LO', '1', 'GT Contrast Type', ''),
                    '0019xx61': ('LO', '1', 'GA Rotation Amount', ''),
                    '0019xx62': ('LO', '1', 'GC Rotation Center', ''),
                    '0019xx63': ('LO', '1', 'GS Density Shift', ''),
                    '0019xx64': ('US', '1', 'RN Frequency Rank', ''),
                    '0019xx65': ('LO', '1', 'RE Frequency Enhancement', ''),
                    '0019xx66': ('LO', '1', 'RT Frequency Type', ''),
                    '0019xx67': ('LO', '1', 'Kernel Length', ''),
                    '0019xx68': ('UL', '1', 'Kernel Mode', ''),
                    '0019xx69': ('UL', '1', 'Convulsion Mode', ''),
                    '0019xx70': ('LO', '1', 'PLA Source', ''),
                    '0019xx71': ('LO', '1', 'PLA Destination', ''),
                    '0019xx75': ('LO', '1', 'UID Original Image', ''),
                    '0019xx76': ('LO', '1', 'Filterset', ''),
                    '0019xx80': ('LO', '1', 'Reader Header', ''),
                    '0019xx90': ('LO',
                                 '1',
                                 'PLA of Secondary Destination',
                                 ''),
                    '0019xxa0': ('DS', '1', 'Unknown', ''),
                    '0019xxa1': ('DS', '1', 'Unknown', ''),
                    '0041xx10': ('US', '1', 'Number of Hardcopies', ''),
                    '0041xx20': ('CS', '1', 'Film Format', ''),
                    '0041xx30': ('LO', '1', 'Film Size', ''),
                    '0041xx31': ('LO', '1', 'Full Film Format', '')},
 'SIEMENS ISI': {'0003xx08': ('US', '1', 'ISI Command Field', ''),
                 '0003xx11': ('US', '1', 'Attach ID Application Code', ''),
                 '0003xx12': ('UL', '1', 'Attach ID Message Count', ''),
                 '0003xx13': ('DA', '1', 'Attach ID Date', ''),
                 '0003xx14': ('TM', '1', 'Attach ID Time', ''),
                 '0003xx20': ('US', '1', 'Message Type', ''),
                 '0003xx30': ('DA', '1', 'Max Waiting Date', ''),
                 '0003xx31': ('TM', '1', 'Max Waiting Time', ''),
                 '0009xx01': ('UN', '1', 'RIS Patient Info IMGEF', ''),
                 '0009xx14': ('SQ', '1', 'RIS Patient Info IMGEF', ''),
                 '0011xx03': ('LO', '1', 'Patient UID', ''),
                 '0011xx04': ('LO', '1', 'Patient ID', ''),
                 '0011xx0a': ('LO', '1', 'Case ID', ''),
                 '0011xx22': ('LO', '1', 'Request ID', ''),
                 '0011xx23': ('LO', '1', 'Examination UID', ''),
                 '0011xx41': ('LO', '1', 'Medical Alerts', ''),
                 '0011xx42': ('LO', '1', 'Contrast Allergy', ''),
                 '0011xxa1': ('DA', '1', 'Patient Registration Date', ''),
                 '0011xxa2': ('TM', '1', 'Patient Registration Time', ''),
                 '0011xxb0': ('LO', '1', 'Patient Last Name', ''),
                 '0011xxb2': ('LO', '1', 'Patient First Name', ''),
                 '0011xxb4': ('CS', '1', 'Patient Hospital Status', ''),
                 '0011xxbc': ('LO', '1', 'Current Location Time', ''),
                 '0011xxc0': ('CS', '1', 'Patient Insurance Status', ''),
                 '0011xxd0': ('LO', '1', 'Patient Billing Type', ''),
                 '0011xxd2': ('LO', '1', 'Patient Billing Address', ''),
                 '0031xx12': ('LO', '1', 'Examination Reason', ''),
                 '0031xx30': ('DA', '1', 'Requested Date', ''),
                 '0031xx32': ('TM', '1', 'Worklist Request Start Time', ''),
                 '0031xx33': ('TM', '1', 'Worklist Request End Time', ''),
                 '0031xx4a': ('TM', '1', 'Requested Time', ''),
                 '0031xx80': ('LO', '1', 'Requested Location', ''),
                 '0055xx46': ('PN', '1', 'Current Ward', ''),
                 '0193xx02': ('LO', '1', 'RIS Key', ''),
                 '0307xx01': ('SQ', '1', 'RIS Worklist IMGEF', ''),
                 '0309xx01': ('SQ', '1', 'RIS Report IMGEF', ''),
                 '4009xx01': ('LO', '1', 'Report ID', ''),
                 '4009xx20': ('CS', '1', 'Report Status', ''),
                 '4009xx30': ('DA', '1', 'Report Creation Date', ''),
                 '4009xx70': ('PN', '1', 'Report Approving Physician', ''),
                 '4009xxe0': ('LO', '1', 'Report Text', ''),
                 '4009xxe1': ('LO', '1', 'Report Author', ''),
                 '4009xxe2': ('PN', '1', 'Report Transcriber', ''),
                 '4009xxe3': ('PN', '1', 'Reporting Radiologist', '')},
 'SIEMENS MED': {'0009xx10': ('LO', '1', 'Recognition Code', ''),
                 '0009xx30': ('US',
                              '1',
                              'Byte Offset of Original Header',
                              ''),
                 '0009xx31': ('US', '1', 'Length of Original Header', ''),
                 '0009xx40': ('US', '1', 'Byte Offset of Pixel Matrix', ''),
                 '0009xx41': ('UL', '1', 'Length of Pixel Matrix', ''),
                 '0009xx50': ('LO', '1', 'Unknown', ''),
                 '0009xx51': ('LO', '1', 'Unknown', ''),
                 '0009xx80': ('ST', '1', '', ''),
                 '0009xxf5': ('LO', '1', 'PDM EFID Placeholder', ''),
                 '0009xxf6': ('LO',
                              '1',
                              'PDM Data Object Type Extension',
                              ''),
                 '0011xx10': ('ST', '1', '', ''),
                 '0017xx00': ('ST', '1', '', ''),
                 '0017xx20': ('ST', '1', '', ''),
                 '0017xx60': ('LO', '1', '', ''),
                 '0017xx80': ('ST', '1', '', ''),
                 '0019xx01': ('SS', '1', '', ''),
                 '0019xx02': ('SS', '1', '', ''),
                 '0019xx03': ('SS', '1', '', ''),
                 '0019xx04': ('ST', '1', '', ''),
                 '0019xx05': ('ST', '1', '', ''),
                 '0019xx06': ('SL', '1', '', ''),
                 '0019xx07': ('SL', '1', '', ''),
                 '0019xx08': ('SS', '1', '', ''),
                 '0019xx09': ('SS', '1', '', ''),
                 '0019xx0a': ('ST', '1', '', ''),
                 '0019xx0b': ('ST', '1', '', ''),
                 '0019xx0c': ('SS', '1', '', ''),
                 '0019xx0d': ('ST', '1', '', ''),
                 '0019xx0e': ('ST', '1', '', ''),
                 '0019xx0f': ('SL', '1', '', ''),
                 '0019xx11': ('ST', '1', '', ''),
                 '0019xx12': ('ST', '1', '', ''),
                 '0019xx13': ('SS', '1', '', ''),
                 '0019xx14': ('SS', '1', '', ''),
                 '0019xx15': ('SS', '1', '', ''),
                 '0019xx16': ('SS', '1', '', ''),
                 '0019xx17': ('SS', '1', '', ''),
                 '0019xx18': ('SS', '1', '', ''),
                 '0019xx19': ('SS', '1', '', ''),
                 '0019xx1a': ('SS', '1', '', ''),
                 '0019xx1b': ('SS', '1', '', ''),
                 '0019xx1c': ('SS', '1', '', ''),
                 '0019xx1d': ('SS', '1', '', ''),
                 '0019xx20': ('SL', '1', '', ''),
                 '0019xx21': ('SL', '1', '', ''),
                 '0019xx22': ('SL', '1', '', ''),
                 '0019xx23': ('SS', '1', '', ''),
                 '0019xx24': ('SL', '1', '', ''),
                 '0019xx25': ('SL', '1', '', ''),
                 '0019xx26': ('SL', '1', '', ''),
                 '0019xx27': ('SL', '1', '', ''),
                 '0019xx30': ('SL', '1', '', ''),
                 '0019xx31': ('SL', '1', '', ''),
                 '0019xx32': ('SL', '1', '', ''),
                 '0019xx41': ('SS', '1', '', ''),
                 '0019xx42': ('SS', '1', '', ''),
                 '0019xx43': ('SS', '1', '', ''),
                 '0019xx44': ('SS', '1', '', ''),
                 '0019xx45': ('SL', '1', '', ''),
                 '0019xx47': ('SL', '1', '', ''),
                 '0019xx48': ('ST', '1', '', ''),
                 '0019xx49': ('SL', '1', '', ''),
                 '0019xx4a': ('SS', '1', '', ''),
                 '0019xx4b': ('SS', '1', '', ''),
                 '0019xx4c': ('SL', '1', '', ''),
                 '0019xx4e': ('SS', '1', '', ''),
                 '0019xx4f': ('SS', '1', '', ''),
                 '0019xx50': ('SS', '1', '', ''),
                 '0019xx51': ('SS', '1', '', ''),
                 '0019xx52': ('SS', '1', '', ''),
                 '0019xx53': ('SS', '1', '', ''),
                 '0019xx54': ('ST', '1', '', ''),
                 '0019xx55': ('SS', '1', '', ''),
                 '0019xx56': ('SS', '1', '', ''),
                 '0019xx57': ('SS', '1', '', ''),
                 '0019xx58': ('SS', '1', '', ''),
                 '0019xx59': ('SS', '1', '', ''),
                 '0019xx5a': ('ST', '1', '', ''),
                 '0019xx5b': ('SS', '1', '', ''),
                 '0019xx5c': ('SS', '1', '', ''),
                 '0019xx5d': ('SS', '1', '', ''),
                 '0019xx5e': ('SS', '1', '', ''),
                 '0019xx5f': ('SS', '1', '', ''),
                 '0019xx60': ('SS', '1', '', ''),
                 '0019xx61': ('SS', '1', '', ''),
                 '0019xx62': ('SS', '1', '', ''),
                 '0019xx63': ('SS', '1', '', ''),
                 '0019xx64': ('SS', '1', '', ''),
                 '0019xx65': ('SS', '1', '', ''),
                 '0019xx66': ('SS', '1', '', ''),
                 '0019xx67': ('SS', '1', '', ''),
                 '0019xx68': ('SL', '1', '', ''),
                 '0019xx69': ('SS', '1', '', ''),
                 '0019xx6a': ('SS', '1', '', ''),
                 '0019xx6b': ('SL', '1', '', ''),
                 '0019xx6c': ('SL', '1', '', ''),
                 '0019xx6d': ('SS', '1', '', ''),
                 '0019xx6e': ('SS', '1', '', ''),
                 '0019xx6f': ('SS', '1', '', ''),
                 '0019xx70': ('ST', '1', '', ''),
                 '0019xx71': ('ST', '1', '', ''),
                 '0019xx72': ('SL', '1', '', ''),
                 '0019xx73': ('SL', '1', '', ''),
                 '0019xx74': ('SS', '1', '', ''),
                 '0019xx75': ('SS', '1', '', ''),
                 '0019xx76': ('SS', '1', '', ''),
                 '0019xx77': ('SS', '1', '', ''),
                 '0019xx78': ('SS', '1', '', ''),
                 '0019xx7f': ('SS', '1', '', ''),
                 '0019xx80': ('SS', '1', '', ''),
                 '0019xx81': ('SS', '1', '', ''),
                 '0019xx82': ('SL', '1', '', ''),
                 '0019xx83': ('SS', '1', '', ''),
                 '0019xx84': ('SS', '1', '', ''),
                 '0019xx85': ('SS', '1', '', ''),
                 '0019xx86': ('SS', '1', '', ''),
                 '0019xx87': ('SS', '1', '', ''),
                 '0019xx88': ('SL', '1', '', ''),
                 '0019xx89': ('SS', '1', '', ''),
                 '0019xx8a': ('SL', '1', '', ''),
                 '0019xx8d': ('SL', '1', '', ''),
                 '0019xx8e': ('SL', '1', '', ''),
                 '0019xx91': ('SL', '1', '', ''),
                 '0019xx92': ('SL', '1', '', ''),
                 '0019xx93': ('SL', '1', '', ''),
                 '0019xx94': ('SS', '1', '', ''),
                 '0019xx95': ('SS', '1', '', ''),
                 '0019xx96': ('SL', '1', '', ''),
                 '0019xx97': ('SS', '1', '', ''),
                 '0019xxa0': ('SS', '1', '', ''),
                 '0019xxa1': ('SS', '1', '', ''),
                 '0019xxa2': ('SL', '1', '', ''),
                 '0019xxa3': ('SL', '1', '', ''),
                 '0019xxa4': ('SL', '1', '', ''),
                 '0019xxc0': ('SL', '1', '', ''),
                 '0019xxc1': ('SS', '1', '', ''),
                 '0019xxc2': ('SS', '1', '', ''),
                 '0019xxf0': ('SL', '1', '', ''),
                 '001fxx00': ('LO', '1', '', ''),
                 '001fxx02': ('LO', '1', '', ''),
                 '001fxx50': ('LO', '1', '', ''),
                 '001fxx70': ('LO', '1', '', ''),
                 '0021xx10': ('DS', '1', 'Zoom', ''),
                 '0021xx11': ('DS', '1-n', 'Target', ''),
                 '0021xx12': ('IS', '1', 'Tube Angle During Topogram', ''),
                 '0021xx20': ('US', '1', 'ROI Mask', ''),
                 '0031xx01': ('ST', '1', '', ''),
                 '0031xx03': ('SL', '1', '', ''),
                 '0031xx04': ('ST', '1', '', ''),
                 '0031xx05': ('SS', '1', '', ''),
                 '0031xx06': ('SL', '1', '', ''),
                 '0031xx07': ('SS', '1', '', ''),
                 '0031xx08': ('ST', '1', '', ''),
                 '0031xx09': ('SS', '1', '', ''),
                 '0031xx0a': ('SS', '1', '', ''),
                 '0031xx0b': ('SS', '1', '', ''),
                 '0031xx0c': ('SS', '1', '', ''),
                 '0031xx0d': ('SS', '1', '', ''),
                 '0031xx0e': ('SS', '1', '', ''),
                 '0031xx0f': ('SL', '1', '', ''),
                 '0031xx10': ('SL', '1', '', ''),
                 '0031xx11': ('SS', '1', '', ''),
                 '0041xx12': ('SL', '1', '', ''),
                 '0041xx13': ('SL', '1', '', ''),
                 '0041xx21': ('ST', '1', '', ''),
                 '0041xx30': ('ST', '1', '', ''),
                 '0041xx32': ('ST', '1', '', ''),
                 '0041xx34': ('ST', '1', '', ''),
                 '0041xx36': ('ST', '1', '', ''),
                 '0041xx40': ('ST', '1', '', ''),
                 '0041xx50': ('SS', '1', '', ''),
                 '0041xx52': ('SS', '1', '', ''),
                 '0041xx60': ('ST', '1', '', ''),
                 '0041xx70': ('SL', '1', '', ''),
                 '0041xx71': ('SL', '1', '', ''),
                 '0051xx10': ('SS', '1', '', ''),
                 '0051xx11': ('SS', '1', '', ''),
                 '0051xx12': ('SS', '1', '', ''),
                 '0051xx13': ('SS', '1', '', ''),
                 '0051xx14': ('SS', '1', '', ''),
                 '0051xx15': ('SL', '1', '', ''),
                 '0051xx18': ('SL', '1', '', ''),
                 '0053xx01': ('SS', '1', '', ''),
                 '0053xx02': ('SS', '1', '', ''),
                 '0053xx03': ('SS', '1', '', ''),
                 '0053xx10': ('SS', '1', '', ''),
                 '0053xx11': ('SL', '1', '', ''),
                 '0053xx12': ('SS', '1', '', ''),
                 '0053xx13': ('SL', '1', '', ''),
                 '0053xx14': ('SS', '1', '', ''),
                 '0053xx15': ('SL', '1', '', ''),
                 '0053xx16': ('SS', '1', '', ''),
                 '0053xx17': ('SS', '1', '', ''),
                 '0053xx18': ('SL', '1', '', ''),
                 '0053xx19': ('SS', '1', '', ''),
                 '0053xx1a': ('SS', '1', '', ''),
                 '0053xx1b': ('SL', '1', '', ''),
                 '0053xx1c': ('SS', '1', '', ''),
                 '0053xx1d': ('SL', '1', '', ''),
                 '0053xx30': ('SS', '1', '', ''),
                 '0053xx31': ('SS', '1', '', ''),
                 '0053xx32': ('SS', '1', '', ''),
                 '0053xx33': ('SL', '1', '', ''),
                 '0053xx40': ('SS', '1', '', ''),
                 '0053xx41': ('SL', '1', '', ''),
                 '0053xx42': ('SS', '1', '', ''),
                 '0053xx43': ('SL', '1', '', ''),
                 '0053xx44': ('SS', '1', '', ''),
                 '0055xx01': ('SS', '1', '', ''),
                 '0055xx02': ('SS', '1', '', ''),
                 '0055xx03': ('SL', '1', '', ''),
                 '0055xx20': ('SS', '1', '', ''),
                 '0055xx21': ('ST', '1', '', ''),
                 '0055xx22': ('SS', '1', '', ''),
                 '0055xx23': ('ST', '1', '', ''),
                 '0055xx24': ('SS', '1', '', ''),
                 '0055xx25': ('ST', '1', '', ''),
                 '0055xx29': ('SL', '1', '', ''),
                 '0055xx2a': ('SL', '1', '', ''),
                 '0055xx30': ('SS', '1', '', ''),
                 '0055xx31': ('ST', '1', '', ''),
                 '0055xx32': ('SS', '1', '', ''),
                 '0055xx33': ('ST', '1', '', ''),
                 '0055xx34': ('SS', '1', '', ''),
                 '0055xx35': ('ST', '1', '', ''),
                 '0055xx38': ('SL', '1', '', ''),
                 '0055xx39': ('SL', '1', '', ''),
                 '0055xx3a': ('SL', '1', '', ''),
                 '0055xx40': ('SS', '1', '', ''),
                 '0055xx48': ('SL', '1', '', ''),
                 '0055xx50': ('SS', '1', '', ''),
                 '0055xx51': ('SS', '1', '', ''),
                 '0055xx52': ('SS', '1', '', ''),
                 '0055xx53': ('ST', '1', '', ''),
                 '0055xx54': ('SL', '1', '', ''),
                 '0055xx55': ('SL', '1', '', ''),
                 '0055xx56': ('SS', '1', '', ''),
                 '0055xx57': ('SS', '1', '', ''),
                 '0055xx58': ('SL', '1', '', ''),
                 '0055xx59': ('ST', '1', '', ''),
                 '0055xx5a': ('SL', '1', '', ''),
                 '0055xx5b': ('SS', '1', '', ''),
                 '0055xx5c': ('ST', '1', '', ''),
                 '0055xx5d': ('SS', '1', '', ''),
                 '0055xx5e': ('SS', '1', '', ''),
                 '0055xx5f': ('SL', '1', '', ''),
                 '0055xx60': ('SS', '1', '', ''),
                 '0055xx61': ('SS', '1', '', ''),
                 '0055xx64': ('SS', '1', '', ''),
                 '0055xx65': ('SS', '1', '', ''),
                 '0055xx66': ('SS', '1', '', ''),
                 '0055xx67': ('SS', '1', '', ''),
                 '0055xx68': ('SS', '1', '', ''),
                 '0055xx69': ('SS', '1', '', ''),
                 '0055xx6a': ('SS', '1', '', ''),
                 '0055xx6b': ('SS', '1', '', ''),
                 '0055xx6c': ('SS', '1', '', ''),
                 '0055xx6d': ('SS', '1', '', ''),
                 '0055xx70': ('SL', '1', '', ''),
                 '0055xx71': ('SL', '1', '', ''),
                 '0055xx72': ('SL', '1', '', ''),
                 '0055xx73': ('SL', '1', '', ''),
                 '0055xx74': ('SL', '1', '', ''),
                 '0055xx75': ('SL', '1', '', ''),
                 '0055xx76': ('SL', '1', '', ''),
                 '0055xx77': ('SL', '1', '', ''),
                 '0055xx78': ('SL', '1', '', ''),
                 '0055xx80': ('SS', '1', '', ''),
                 '0055xx81': ('SS', '1', '', ''),
                 '0055xx82': ('SS', '1', '', ''),
                 '0055xx83': ('SS', '1', '', ''),
                 '0055xx84': ('SS', '1', '', ''),
                 '0055xx85': ('SS', '1', '', ''),
                 '0055xx86': ('SL', '1', '', ''),
                 '0055xx87': ('SL', '1', '', ''),
                 '0055xx88': ('SL', '1', '', ''),
                 '0055xx89': ('ST', '1', '', ''),
                 '0055xx8a': ('SS', '1', '', ''),
                 '0055xx8b': ('SL', '1', '', ''),
                 '0055xx8c': ('SS', '1', '', ''),
                 '0055xx8d': ('SL', '1', '', ''),
                 '0055xx8e': ('SL', '1', '', ''),
                 '0055xx8f': ('SL', '1', '', ''),
                 '0055xx90': ('SL', '1', '', ''),
                 '0055xx91': ('SS', '1', '', ''),
                 '0055xx92': ('ST', '1', '', ''),
                 '0055xx93': ('SL', '1', '', ''),
                 '0055xx94': ('SL', '1', '', ''),
                 '0055xx95': ('SL', '1', '', ''),
                 '0055xx96': ('SL', '1', '', ''),
                 '0055xx97': ('SL', '1', '', ''),
                 '0055xx98': ('SS', '1', '', ''),
                 '0055xx99': ('SS', '1', '', ''),
                 '0055xx9a': ('SS', '1', '', ''),
                 '0055xx9b': ('SS', '1', '', ''),
                 '0055xx9c': ('SS', '1', '', ''),
                 '0055xx9d': ('SL', '1', '', ''),
                 '0055xx9e': ('SL', '1', '', ''),
                 '0055xx9f': ('SL', '1', '', ''),
                 '0055xxa0': ('SL', '1', '', ''),
                 '0055xxa1': ('SL', '1', '', ''),
                 '0055xxa2': ('SL', '1', '', ''),
                 '0055xxa3': ('SL', '1', '', ''),
                 '0055xxa4': ('SS', '1', '', ''),
                 '0055xxa5': ('SL', '1', '', ''),
                 '0055xxa6': ('SL', '1', '', ''),
                 '0055xxa7': ('SS', '1', '', ''),
                 '0055xxa8': ('SS', '1', '', ''),
                 '0055xxa9': ('SS', '1', '', ''),
                 '0055xxb0': ('SS', '1', '', ''),
                 '0055xxb1': ('SS', '1', '', ''),
                 '0057xx10': ('SS', '1', '', ''),
                 '0057xx20': ('SL', '1', '', ''),
                 '5001xx01': ('SS', '1', '', ''),
                 '5001xx02': ('SL', '1', '', ''),
                 '5001xx03': ('SL', '1', '', ''),
                 '5001xx04': ('SL', '1', '', ''),
                 '5001xx05': ('SL', '1', '', ''),
                 '5001xx06': ('SL', '1', '', ''),
                 '5001xx07': ('ST', '1', '', ''),
                 '5001xx08': ('ST', '1', '', ''),
                 '5001xx09': ('ST', '1', '', ''),
                 '5001xx0a': ('ST', '1', '', ''),
                 '5001xx0b': ('SL', '1', '', ''),
                 '7001xx10': ('SS', '1', '', ''),
                 '7003xx10': ('SL', '1', '', ''),
                 '7005xx10': ('SS', '1', '', ''),
                 '7fe1xx10': ('SS', '1', '', ''),
                 '7fe3xx14': ('SL', '1', '', ''),
                 '7fe3xx15': ('SL', '1', '', ''),
                 '7fe3xx16': ('SL', '1', '', ''),
                 '7fe3xx17': ('SL', '1', '', ''),
                 '7fe3xx18': ('SL', '1', '', ''),
                 '7fe3xx19': ('ST', '1', '', ''),
                 '7fe3xx1a': ('SL', '1', '', ''),
                 '7fe3xx1b': ('SS', '1', '', ''),
                 '7fe3xx1c': ('SS', '1', '', ''),
                 '7fe3xx1e': ('SL', '1', '', ''),
                 '7fe3xx1f': ('SL', '1', '', ''),
                 '7fe3xx20': ('SL', '1', '', ''),
                 '7fe3xx21': ('SL', '1', '', ''),
                 '7fe3xx22': ('SL', '1', '', ''),
                 '7fe3xx23': ('SL', '1', '', ''),
                 '7fe3xx24': ('ST', '1', '', ''),
                 '7fe3xx25': ('SS', '1', '', '')},
 'SIEMENS MED DISPLAY': {'0029xx04': ('CS',
                                      '1',
                                      'Photometric Interpretation',
                                      ''),
                         '0029xx10': ('US', '1', 'Rows', ''),
                         '0029xx11': ('US', '1', 'Columns', ''),
                         '0029xx20': ('US', '1', 'Unknown', ''),
                         '0029xx21': ('US', '1', 'Unknown', ''),
                         '0029xx50': ('US', '2', 'Origin', ''),
                         '0029xx80': ('US', '1', 'Unknown', ''),
                         '0029xx99': ('LO', '1', 'Shutter Type', ''),
                         '0029xxa0': ('US',
                                      '1',
                                      'Rows of Rectangular Shutter',
                                      ''),
                         '0029xxa1': ('US',
                                      '1',
                                      'Columns of Rectangular Shutter',
                                      ''),
                         '0029xxa2': ('US',
                                      '1',
                                      'Origin of Rectangular Shutter',
                                      ''),
                         '0029xxb0': ('US',
                                      '1',
                                      'Radius of Circular Shutter',
                                      ''),
                         '0029xxb2': ('US',
                                      '1',
                                      'Origin of Circular Shutter',
                                      ''),
                         '0029xxc1': ('US',
                                      '1',
                                      'Contour of Irregular Shutter',
                                      '')},
 'SIEMENS MED DISPLAY 0000': {'0029xx99': ('LO', '1', 'Unknown', ''),
                              '0029xxc1': ('US', '1-n', 'Unknown', '')},
 'SIEMENS MED ECAT FILE INFO': {'0021xx00': ('OB',
                                             '1',
                                             'ECAT_Main_Header',
                                             ''),
                                '0021xx01': ('OB',
                                             '1',
                                             'ECAT_Image_Subheader',
                                             '')},
 'SIEMENS MED HG': {'0029xx10': ('US', '1', 'List of Group Numbers', ''),
                    '0029xx15': ('LO', '1', 'List of Shadow Owner Codes', ''),
                    '0029xx20': ('US', '1', 'List of Element Numbers', ''),
                    '0029xx30': ('US',
                                 '1',
                                 'List of Total Display Length',
                                 ''),
                    '0029xx40': ('LO', '1-n', 'List of Display Prefix', ''),
                    '0029xx50': ('LO', '1-n', 'List of Display Postfix', ''),
                    '0029xx60': ('US', '1', 'List of Text Position', ''),
                    '0029xx70': ('LO', '1', 'List of Text Concatenation', '')},
 'SIEMENS MED MAMMO': {'0029xx5a': ('CS', '1', 'Unknown', '')},
 'SIEMENS MED MG': {'0029xx10': ('US', '1', 'List of Group Numbers', ''),
                    '0029xx15': ('LO', '1', 'List of Shadow Owner Codes', ''),
                    '0029xx20': ('US', '1', 'List of Element Numbers', ''),
                    '0029xx30': ('US',
                                 '1',
                                 'List of Total Display Length',
                                 ''),
                    '0029xx40': ('LO', '1-n', 'List of Display Prefix', ''),
                    '0029xx50': ('LO', '1-n', 'List of Display Postfix', ''),
                    '0029xx60': ('US', '1', 'List of Text Position', ''),
                    '0029xx70': ('LO', '1', 'List of Text Concatenation', '')},
 'SIEMENS MED NM': {'0009xx80': ('LO', '1', 'Main Acquisition View', ''),
                    '0011xx10': ('CS', '1', 'Organ System', ''),
                    '0017xx00': ('ST', '1', 'Unknown 0017 0000', ''),
                    '0017xx20': ('CS', '1', 'Scanning Sequence', ''),
                    '0017xx60': ('DS', '1', 'KVP', ''),
                    '0017xx70': ('ST', '1', 'Unknown', ''),
                    '0017xx80': ('ST', '1-n', 'Unknown 0017 0080', ''),
                    '0019xx01': ('SS', '1', 'Number of detectors', ''),
                    '0019xx02': ('SS', '1', 'Number of scalers', ''),
                    '0019xx03': ('SS', '1', 'Scaler Index', ''),
                    '0019xx04': ('DS', '1', 'Radionuclide Units', ''),
                    '0019xx05': ('DS', '1', 'Radiopharmaceutical', ''),
                    '0019xx06': ('FL', '1', 'Display Magnification', ''),
                    '0019xx07': ('SL', '1', 'Scaler Counts', ''),
                    '0019xx08': ('SS',
                                 '1',
                                 'Processed Flag 0 Raw 1 Process',
                                 ''),
                    '0019xx09': ('SS',
                                 '1',
                                 'MicroDELTA Parameter Blocks',
                                 ''),
                    '0019xx0a': ('LO', '1', 'MicroDELTA File Extension', ''),
                    '0019xx0b': ('LO', '1', 'MicroDELTA Write ID', ''),
                    '0019xx0c': ('SS', '1', 'MicroDELTA Write Version', ''),
                    '0019xx0d': ('CS', '1', 'MicroDELTA Mode', ''),
                    '0019xx0e': ('LO', '1', 'MicroDELTA ESFR', ''),
                    '0019xx0f': ('SL', '1', 'Siemens ICON Data Type', ''),
                    '0019xx10': ('OW',
                                 '1',
                                 'MicroDELTA Expansion Blocks',
                                 ''),
                    '0019xx11': ('CS', '1', 'MicroDELTA Version', ''),
                    '0019xx12': ('LO', '1', 'MicroDELTA Trend', ''),
                    '0019xx13': ('SS',
                                 '1',
                                 'MicroDELTA Number of Overlays',
                                 ''),
                    '0019xx14': ('SS', '1', 'MicroDELTA Overlay Block', ''),
                    '0019xx15': ('SS',
                                 '1',
                                 'MicroDELTA Color Table Extra',
                                 ''),
                    '0019xx16': ('SS', '1', 'Number of Views', ''),
                    '0019xx17': ('SS', '1', 'MicroDELTA Thyroid Markers', ''),
                    '0019xx18': ('SS',
                                 '1',
                                 'MicroDELTA Color Table Used',
                                 ''),
                    '0019xx19': ('SS',
                                 '1',
                                 'Save Screen Flag 1 SaveScreen',
                                 ''),
                    '0019xx1a': ('SS', '1', 'MicroDELTA Overlay Map', ''),
                    '0019xx1b': ('SS', '1', 'SGI Converted LookUp Table', ''),
                    '0019xx1c': ('SS', '1', 'MicroDELTA Mystery1', ''),
                    '0019xx1d': ('SS', '1', 'MicroDELTA Mystery2', ''),
                    '0019xx20': ('FL',
                                 '1',
                                 'Time of Lasix Administration',
                                 ''),
                    '0019xx21': ('FL', '1', 'Lasix Dose mg', ''),
                    '0019xx22': ('FL', '1', 'Bladder Esidual Volume cc', ''),
                    '0019xx23': ('SS', '1', 'Bladder Image Extension', ''),
                    '0019xx24': ('FL', '1', 'Serum Creatinine mg/dl', ''),
                    '0019xx25': ('FL', '1', 'TER', ''),
                    '0019xx26': ('FL', '1', 'TER Lower Limit', ''),
                    '0019xx27': ('FL', '1', 'Body Surface Area m2', ''),
                    '0019xx30': ('FL', '1', 'CTQ Normal Margin', ''),
                    '0019xx31': ('FL',
                                 '1',
                                 'CTQ Abnormal Sagittal Margin',
                                 ''),
                    '0019xx32': ('FL',
                                 '1',
                                 'CTQ Abnormal Oblique Margin',
                                 ''),
                    '0019xx41': ('SS', '1', 'Accepted Beats', ''),
                    '0019xx42': ('SS', '1', 'Rejected Beats', ''),
                    '0019xx43': ('SS',
                                 '1',
                                 'Percent of R-R Interval Framed',
                                 ''),
                    '0019xx44': ('SS', '1', 'Beats Rejected Post PVC', ''),
                    '0019xx45': ('FL', '1', 'Trigger Source', ''),
                    '0019xx47': ('FL', '1', 'Beat Rejection Parameter', ''),
                    '0019xx48': ('SH', '1', 'Rejection Scheme', ''),
                    '0019xx49': ('FL', '1', 'PVC Threshold msec', ''),
                    '0019xx4a': ('SS',
                                 '1',
                                 'Framing Mode 1 Forward 2 F/B',
                                 ''),
                    '0019xx4b': ('SS', '1', 'Autobeat Window 0 No 1 Yes', ''),
                    '0019xx4c': ('FL',
                                 '1',
                                 'MicroDELTA Acquisition Time per Window msec',
                                 ''),
                    '0019xx4e': ('SS', '1', 'CTQ Unknown Entry Count', ''),
                    '0019xx4f': ('SS', '1', 'CTQ Matrix Size', ''),
                    '0019xx50': ('SS', '1', 'CTQ has been used', ''),
                    '0019xx51': ('SS', '1', 'CTQ Male Entry Count', ''),
                    '0019xx52': ('SS', '1', 'CTQ Female Entry Count', ''),
                    '0019xx53': ('SS', '1', 'CTQ Stress/Rest Time Delay', ''),
                    '0019xx54': ('CS', '1', 'CTQ Time Delay Units', ''),
                    '0019xx55': ('SS',
                                 '1',
                                 'CTQ Min Oblique Stack Count',
                                 ''),
                    '0019xx56': ('SS',
                                 '1',
                                 'CTQ Max Oblique Stack Count',
                                 ''),
                    '0019xx57': ('SS',
                                 '1',
                                 'CTQ Min Sagittal Stack Count',
                                 ''),
                    '0019xx58': ('SS',
                                 '1',
                                 'CTQ Max Sagittal Stack Count',
                                 ''),
                    '0019xx59': ('SS', '1', 'CTQ Min Radius Percent', ''),
                    '0019xx5a': ('UL',
                                 '1',
                                 'CTQ Find Max or Average Flag',
                                 ''),
                    '0019xx5b': ('SS',
                                 '1',
                                 'CTQ Basal Slice Index Offset',
                                 ''),
                    '0019xx5c': ('SS', '1', 'CTQ Starting Line Index', ''),
                    '0019xx5d': ('SS', '1', 'CTQ Line Counts', ''),
                    '0019xx5e': ('SS', '1', 'CTQ Radii Counts', ''),
                    '0019xx5f': ('SS', '1', 'CTQ Radial Angle Increment', ''),
                    '0019xx60': ('SS',
                                 '1',
                                 'Whole Body Processed Flag 0:Raw 1:Img1-Img2 2:Im',
                                 ''),
                    '0019xx61': ('SS', '1', 'Whole Body View', ''),
                    '0019xx62': ('SS',
                                 '1',
                                 'WB Display Field Length in cm',
                                 ''),
                    '0019xx63': ('SS', '1', 'WB Scan Length in cm', ''),
                    '0019xx64': ('SS', '1', 'WB Scan Speed cm/min', ''),
                    '0019xx65': ('SS',
                                 '1',
                                 'WB Scan Speed Mode 0 Manual 1 Auto',
                                 ''),
                    '0019xx66': ('SS',
                                 '1',
                                 'WB Scan Start 0 Head 1 Feet',
                                 ''),
                    '0019xx67': ('SS',
                                 '1',
                                 'WB Scan Direction 0 Lt to Rt 1 Rt to Lt',
                                 ''),
                    '0019xx68': ('FL', '1', 'WB Aperature Width in cm', ''),
                    '0019xx69': ('SS', '1', 'WB Number of Passes', ''),
                    '0019xx6a': ('SS', '1', 'WB Scan Time msec', ''),
                    '0019xx6b': ('FL', '1', 'WB Anterior kCounts View 1', ''),
                    '0019xx6c': ('FL', '1', 'WB Anterior kCounts View 2', ''),
                    '0019xx6d': ('FL', '1', 'WB Count Density', ''),
                    '0019xx6e': ('SS',
                                 '1',
                                 'WB Reference View Flag 1 Ref',
                                 ''),
                    '0019xx6f': ('FL',
                                 '1',
                                 'WB Coun Density Speed cm/min',
                                 ''),
                    '0019xx70': ('CS', '1', 'WB Scan Type', ''),
                    '0019xx71': ('LO', '1', 'WB IRIS Corr. File Name', ''),
                    '0019xx72': ('FL',
                                 '1',
                                 'WB Posterior kCounts View 1',
                                 ''),
                    '0019xx73': ('FL',
                                 '1',
                                 'WB Posterior kCounts View 2',
                                 ''),
                    '0019xx74': ('SS',
                                 '1',
                                 'WB Ant View Status No Img 1 Complete 2 Aborted',
                                 ''),
                    '0019xx75': ('SS',
                                 '1',
                                 'WB Post View Status No Img 1 Complete 2 Aborted',
                                 ''),
                    '0019xx76': ('SS', '1', 'WB Post Scan Time msec', ''),
                    '0019xx77': ('SS',
                                 '1',
                                 'WB Ant Pixel Overflow 1 Yes',
                                 ''),
                    '0019xx78': ('SS',
                                 '1',
                                 'WB Post Pixel Overflow 1 Yes',
                                 ''),
                    '0019xx7f': ('SS',
                                 '1',
                                 'Segment Type 0 Segments 2 Time/Segment',
                                 ''),
                    '0019xx80': ('SS', '1', 'Number of Segments', ''),
                    '0019xx81': ('SS',
                                 '1',
                                 'PVC Rejection Flag 1 Reject',
                                 ''),
                    '0019xx82': ('SL', '1', 'Total Counts Framed', ''),
                    '0019xx83': ('SS', '1', 'Total Beats Framed', ''),
                    '0019xx84': ('SS', '1', 'Present Time of Day', ''),
                    '0019xx85': ('SS', '1', 'Framed Counts', ''),
                    '0019xx86': ('SS', '1', 'Time per Segment msec', ''),
                    '0019xx87': ('LT', '1', 'BBA Miscellaneous Info', ''),
                    '0019xx88': ('SL', '1', 'Tolerance %', ''),
                    '0019xx89': ('SS', '1', 'SWG', ''),
                    '0019xx8a': ('SL', '1', 'R-R Interval msec', ''),
                    '0019xx8d': ('SL',
                                 '1',
                                 'Total Counts in Acquisition',
                                 ''),
                    '0019xx8e': ('SL', '1', 'Rejection Type', ''),
                    '0019xx91': ('FL', '1', 'Phase Total Counts', ''),
                    '0019xx92': ('SL', '1', 'Phase Pause msec', ''),
                    '0019xx93': ('SL', '1', 'Phase Start msec', ''),
                    '0019xx94': ('SS',
                                 '1',
                                 'Window Center Method 0 Avg 1 Peak',
                                 ''),
                    '0019xx95': ('SS', '1', 'Number of Beats to Average', ''),
                    '0019xx96': ('FL',
                                 '1',
                                 'Histogram Bin Interval msec',
                                 ''),
                    '0019xx97': ('SS', '1', 'Counts in Peak Bin', ''),
                    '0019xxa0': ('SS', '1', 'VPDs Detected', ''),
                    '0019xxa1': ('SS', '1', 'Number of Phases', ''),
                    '0019xxa2': ('SL',
                                 '1',
                                 'Requested Frame Duration msec',
                                 ''),
                    '0019xxa3': ('SL', '1', 'Frames per Phase', ''),
                    '0019xxa4': ('SL', '1', 'Frame Pause msec', ''),
                    '0019xxa5': ('SS',
                                 '1-n',
                                 'Number of repeats per phase',
                                 ''),
                    '0019xxa6': ('SS', '1-n', 'Cycles per repeat', ''),
                    '0019xxa7': ('SL', '1-n', 'Repeat start time', ''),
                    '0019xxa8': ('SL', '1-n', 'Repeat stop time', ''),
                    '0019xxa9': ('SL', '1-n', 'Effective repeat time', ''),
                    '0019xxaa': ('SS',
                                 '1-n',
                                 'Acquired cycles per repeat',
                                 ''),
                    '0019xxc0': ('FL', '1', 'Head Tilt degrees', ''),
                    '0019xxc1': ('SS', '1', 'Uniformity Correction Flag', ''),
                    '0019xxc2': ('SS', '1', 'Overflow Flag', ''),
                    '0019xxc3': ('ST', '1', 'Unknown', ''),
                    '0019xxf0': ('FL', '1', 'Pixel Dimensions', ''),
                    '001fxx50': ('DS', '1', 'Location RET', ''),
                    '0021xx00': ('OB', '1', 'ECAT File Menu Header', ''),
                    '0021xx01': ('OB', '1', 'ECAT File Subheader', ''),
                    '0021xx10': ('ST', '1', 'Unknown', ''),
                    '0031xx01': ('LO', '1', 'Camera Name', ''),
                    '0031xx02': ('SS', '1', 'Unknown Element 0031 02', ''),
                    '0031xx03': ('FL', '1', 'External Zoom', ''),
                    '0031xx04': ('FL', '1', 'CCD Energy Level', ''),
                    '0031xx05': ('SS', '1', 'CCD Window Width', ''),
                    '0031xx06': ('FL', '1', 'CCD Window Offset', ''),
                    '0031xx07': ('SS', '1', 'CCD Peaking Mode', ''),
                    '0031xx08': ('LO', '1', 'CCD Autopeak Function', ''),
                    '0031xx09': ('SS', '1', 'CCD Count Rate Mode', ''),
                    '0031xx0a': ('SS', '1', 'Analog Output Device', ''),
                    '0031xx0b': ('SS', '1', 'Communication Type', ''),
                    '0031xx0c': ('SS',
                                 '1',
                                 'Control Unit 1 ICON 2 DOT 3 ScintiView',
                                 ''),
                    '0031xx0d': ('SS', '1', 'WAM Mode', ''),
                    '0031xx0e': ('SS', '1', 'Event Control Mode', ''),
                    '0031xx0f': ('FL', '1', 'Zoom X Offset 0.1 mm', ''),
                    '0031xx10': ('FL', '1', 'Zoom Y Offset 0.1 mm', ''),
                    '0031xx11': ('SS', '1', 'Gantry Zero Position', ''),
                    '0031xx12': ('SS', '1', 'Unknown', ''),
                    '0031xx13': ('ST', '1', 'Unknown', ''),
                    '0031xx14': ('ST', '1', 'Unknown', ''),
                    '0031xx15': ('SL', '1-n', 'Unknown', ''),
                    '0031xx16': ('SL', '1-n', 'Unknown', ''),
                    '0031xx17': ('SS', '1-n', 'Unknown', ''),
                    '0031xx20': ('ST', '1', 'Unknown', ''),
                    '0031xx21': ('SS', '1', 'Unknown', ''),
                    '0033xx00': ('FL',
                                 '1-n',
                                 'Flood correction Matrix Det 1 upto SR 2.0',
                                 ''),
                    '0033xx01': ('FL',
                                 '1-n',
                                 'Flood correction Matrix Det 2 upto SR 2.0',
                                 ''),
                    '0033xx10': ('FL', '1-n', 'COR Data for Detector 1', ''),
                    '0033xx11': ('FL', '1-n', 'COR Data for Detector 2', ''),
                    '0033xx14': ('FL',
                                 '1',
                                 'MHR ( Y-Shift) data for detector 1',
                                 ''),
                    '0033xx15': ('FL',
                                 '1',
                                 'MHR ( Y-Shift) data for detector 2',
                                 ''),
                    '0033xx18': ('FL', '1-n', 'NCO Data for detector 1', ''),
                    '0033xx19': ('FL', '1-n', 'NCO Data for detector 2', ''),
                    '0033xx20': ('FL', '1', 'Bed correction angle', ''),
                    '0033xx21': ('FL', '1', 'Gantry correction angle', ''),
                    '0033xx22': ('SS', '1-n', 'Bed U/D correction data', ''),
                    '0033xx23': ('SS', '1-n', 'Unknown', ''),
                    '0033xx24': ('FL',
                                 '1',
                                 'Backprojection angle head 1',
                                 ''),
                    '0033xx25': ('FL',
                                 '1',
                                 'Backprojection angle head 2',
                                 ''),
                    '0033xx28': ('SL',
                                 '1',
                                 'Number of point sources used for NCO and MHR',
                                 ''),
                    '0033xx29': ('FL', '1', 'Crystal thickness', ''),
                    '0033xx30': ('LO',
                                 '1',
                                 'Preset name used for acquisition',
                                 ''),
                    '0033xx31': ('FL', '1', 'Camera config angle', ''),
                    '0033xx32': ('LO',
                                 '1',
                                 'Crystal type Startburst or not',
                                 ''),
                    '0033xx33': ('SL',
                                 '1',
                                 'Gantry step for COIN acquisitions',
                                 ''),
                    '0033xx34': ('FL',
                                 '1',
                                 'Bed step for wholebody or Coin acquisitions',
                                 ''),
                    '0033xx35': ('FL',
                                 '1',
                                 'Weight factor table for coincidence acquisitions',
                                 ''),
                    '0033xx36': ('FL',
                                 '1',
                                 'Transaxial acceptance width for coincidence',
                                 ''),
                    '0033xx37': ('SL', '1', 'Starburst flags', ''),
                    '0033xx38': ('FL', '1', 'Pixel scale factor', ''),
                    '0035xx00': ('LO', '1', 'Specialized tomo type', ''),
                    '0035xx01': ('LO', '1', 'Energy window type', ''),
                    '0035xx02': ('SS',
                                 '1',
                                 'Start and end row illuminated by wind position',
                                 ''),
                    '0035xx03': ('LO',
                                 '1',
                                 'Blank scan image for profile',
                                 ''),
                    '0035xx04': ('SS',
                                 '1',
                                 'Repeat number of the original dynamic SPECT',
                                 ''),
                    '0035xx05': ('SS',
                                 '1',
                                 'Phase number of the original dynamic SPECT',
                                 ''),
                    '0037xx00': ('OW',
                                 '1',
                                 'Flood correction matrix Detector 1',
                                 ''),
                    '0037xx80': ('OW',
                                 '1',
                                 'Flood correction matrix Detector 2',
                                 ''),
                    '0039xx00': ('LT',
                                 '1',
                                 'Toshiba CBF activity results',
                                 ''),
                    '0041xx01': ('SL', '1', 'Unknown', ''),
                    '0041xx02': ('SL', '1', 'Unknown', ''),
                    '0041xx05': ('FD', '1-n', 'Unknown', ''),
                    '0041xx06': ('FD', '1-n', 'Unknown', ''),
                    '0041xx07': ('FD', '1-n', 'Unknown', ''),
                    '0041xx08': ('FD', '1-n', 'Unknown', ''),
                    '0041xx11': ('FL', '1-n', 'Unknown', ''),
                    '0041xx21': ('LO',
                                 '1',
                                 'Text Relating to Data Object',
                                 ''),
                    '0041xx30': ('DA', '1', 'Folder Creation Date', ''),
                    '0041xx32': ('TM', '1', 'Folder Creation Time', ''),
                    '0041xx34': ('DA', '1', 'Folder Modification Date', ''),
                    '0041xx36': ('TM', '1', 'Folder Modification Time', ''),
                    '0041xx40': ('LO', '1', 'Folder Owner Name', ''),
                    '0041xx50': ('SS', '1', 'Folder Status', ''),
                    '0041xx70': ('SL', '1', 'Number of Images in Folder', ''),
                    '0041xx71': ('SL',
                                 '1',
                                 'Number of Non-Image Objects',
                                 ''),
                    '0043xx01': ('FL', '1-n', 'Unknown', ''),
                    '0043xx03': ('FL', '1-n', 'Unknown', ''),
                    '0043xx04': ('FL', '1-n', 'Unknown', ''),
                    '0051xx10': ('SS', '1', 'Number of Windows', ''),
                    '0051xx11': ('SS', '1', 'Average Heart Rate BPM', ''),
                    '0051xx12': ('SS', '1', 'Accepted Beats in Window', ''),
                    '0051xx13': ('SS', '1', 'Average R-R Interval msec', ''),
                    '0051xx14': ('SS', '1', 'Window Width %', ''),
                    '0051xx15': ('SL', '1', 'Hottest Pixel in Window', ''),
                    '0051xx18': ('SL', '1', 'Total Counts in Window', ''),
                    '0053xx01': ('SS',
                                 '1',
                                 'Terminate on Pixel Overflow Flag 1 Terminate',
                                 ''),
                    '0053xx02': ('SS',
                                 '1',
                                 'Terminate on List Buffer Overflow Flag',
                                 ''),
                    '0053xx03': ('SS', '1', 'First Frame by Counts', ''),
                    '0053xx10': ('SS',
                                 '1',
                                 'Elapsed Time Start Condition 0 None 1 Any 2 All',
                                 ''),
                    '0053xx11': ('SL', '1', 'Elapsed Time Start msec', ''),
                    '0053xx12': ('SS',
                                 '1',
                                 'Count Rate Start Condition 0 None 1 Any 2 All',
                                 ''),
                    '0053xx13': ('SL', '1', 'Count Rate Start', ''),
                    '0053xx14': ('SS',
                                 '1',
                                 'Start Heart Beat Count Condition 0 None 1 Any 2',
                                 ''),
                    '0053xx15': ('SL', '1', 'Start Heart Beat Count', ''),
                    '0053xx16': ('SS',
                                 '1',
                                 'Start Heart Rate Threshold Condition',
                                 ''),
                    '0053xx17': ('SS',
                                 '1',
                                 'Start Heart Rate Increasing Flag',
                                 ''),
                    '0053xx18': ('SL', '1', 'Start Heart Rate', ''),
                    '0053xx19': ('SL',
                                 '1',
                                 'Manual Stop Flag 0 No 1 Yes',
                                 ''),
                    '0053xx1a': ('SS',
                                 '1',
                                 'Elapsed Time Stop Condition 0 None 1 Any 2 All',
                                 ''),
                    '0053xx1b': ('SL', '1', 'Elapsed Time Stop', ''),
                    '0053xx1c': ('SS',
                                 '1',
                                 'Stop Heart Beat Count Condition 0 None 1 Any 2 A',
                                 ''),
                    '0053xx1d': ('SL', '1', 'Stop Heart Beat Count', ''),
                    '0053xx30': ('SS',
                                 '1',
                                 'Info Density Stop Condition',
                                 ''),
                    '0053xx31': ('SS', '1', 'Info Density Stop Scaler', ''),
                    '0053xx32': ('SS', '1', 'Info Density Stop Region', ''),
                    '0053xx33': ('SL', '1', 'Info Density Stop Count', ''),
                    '0053xx40': ('SS',
                                 '1',
                                 'Stop Condition Status 0 None 1 Any 2 All',
                                 ''),
                    '0053xx41': ('SL', '1', 'Stop Count', ''),
                    '0053xx42': ('SS',
                                 '1',
                                 'Stop Count Condition Status 0 None 1 Any 2 All',
                                 ''),
                    '0053xx43': ('SL', '1', 'Stop Time', ''),
                    '0053xx44': ('SS',
                                 '1',
                                 'Stop Time Condition Status 0 None 1 Any 2 All',
                                 ''),
                    '0055xx02': ('SS', '1', 'Unknown 55-02', ''),
                    '0055xx04': ('SS', '1', 'Prompt window width', ''),
                    '0055xx05': ('SS', '1', 'Random window width', ''),
                    '0055xx20': ('SS', '1', 'Flood Corr. Flag 1 Corr', ''),
                    '0055xx21': ('DS', '1', 'Flood Acquisition Date', ''),
                    '0055xx30': ('SS', '1', 'COR Corr. Flag 1 Corr', ''),
                    '0055xx31': ('DA', '1', 'COR Acquisition Date', ''),
                    '0055xx38': ('OW', '1', 'COR Data', ''),
                    '0055xx40': ('SS',
                                 '1',
                                 'Noncircular Orbit Flag 1 NCO',
                                 ''),
                    '0055xx48': ('FL', '1', 'NCO Values', ''),
                    '0055xx4c': ('SL', '1', 'Unknown', ''),
                    '0055xx4d': ('SL', '1', 'Unknown', ''),
                    '0055xx50': ('SS',
                                 '1',
                                 'Prone Flag 0 Supine 1 Prone',
                                 ''),
                    '0055xx51': ('SS',
                                 '1',
                                 'Orbit 0 Circular 1 Elliptical',
                                 ''),
                    '0055xx52': ('SS', '1', 'Total Rotation in Degrees', ''),
                    '0055xx53': ('CS',
                                 '1',
                                 'Zero Location (T=Top B=Bottom)',
                                 ''),
                    '0055xx54': ('FL', '1', 'Angular Step', ''),
                    '0055xx55': ('FL', '1', 'Start Angle', ''),
                    '0055xx56': ('SS', '1', 'Decay Corr. Flag 1 Corr', ''),
                    '0055xx57': ('SS', '1', 'Scatter Corr. Flag 1 Corr', ''),
                    '0055xx58': ('FL',
                                 '1',
                                 'Radial Map Info in 0.1 mm Inc.',
                                 ''),
                    '0055xx59': ('CS',
                                 '1',
                                 'Direction H HeadIn F FeetIn',
                                 ''),
                    '0055xx5a': ('FL', '1', 'Table Traverse cm', ''),
                    '0055xx5b': ('SS',
                                 '1',
                                 'Multiplexor Flag 1 Multiplexed',
                                 ''),
                    '0055xx5c': ('DS', '1', 'Pixel Acquisition Date', ''),
                    '0055xx5d': ('SS',
                                 '1',
                                 'Angle Type 1 360o 2 128 Steps',
                                 ''),
                    '0055xx5e': ('SL', '1', 'Orbit Definition', ''),
                    '0055xx5f': ('FL', '1', 'Arm Length in cm', ''),
                    '0055xx60': ('SS', '1', 'Auto Window Beats', ''),
                    '0055xx61': ('SS', '1', 'Non-gated File Extension', ''),
                    '0055xx64': ('SS', '1', 'TIC Error Values', ''),
                    '0055xx65': ('SS', '1', 'X1', ''),
                    '0055xx66': ('SS', '1', 'Y1', ''),
                    '0055xx67': ('SS', '1', 'X2', ''),
                    '0055xx68': ('SS', '1', 'Y2', ''),
                    '0055xx69': ('SS', '1', 'X3', ''),
                    '0055xx6a': ('SS', '1', 'Y3', ''),
                    '0055xx6b': ('SS', '1', 'X4', ''),
                    '0055xx6c': ('SS', '1', 'Y4', ''),
                    '0055xx6d': ('SS',
                                 '1',
                                 'Pixel Size Flag 1 Valid Size',
                                 ''),
                    '0055xx70': ('FL', '1', 'X Focal Length', ''),
                    '0055xx71': ('FL', '1', 'Y Focal Length', ''),
                    '0055xx72': ('FL', '1', 'X Gains', ''),
                    '0055xx73': ('FL', '1', 'Y Gains', ''),
                    '0055xx74': ('FL', '1', 'X Offset', ''),
                    '0055xx75': ('FL', '1', 'Y Offset', ''),
                    '0055xx76': ('FL', '1', 'X Principal Ray', ''),
                    '0055xx77': ('FL', '1', 'Y Principal Ray', ''),
                    '0055xx78': ('FL', '1', 'Total Flood Counts', ''),
                    '0055xx7e': ('FL', '1-n', 'Collimator thickness', ''),
                    '0055xx7f': ('FL',
                                 '1-n',
                                 'Collimator angular resolution',
                                 ''),
                    '0055xx80': ('SS',
                                 '1',
                                 'File Altered Flag 1 Altered',
                                 ''),
                    '0055xx81': ('SS', '1', 'Raw Data Extension', ''),
                    '0055xx82': ('SS', '1', 'Sagittal Extension', ''),
                    '0055xx83': ('SS', '1', 'Coronal Extension', ''),
                    '0055xx84': ('SS', '1', 'Transverse Extension', ''),
                    '0055xx85': ('SS', '1', 'Volume Rendered Extension', ''),
                    '0055xx86': ('SL',
                                 '1',
                                 'Plane of Transverse Bottom Slice',
                                 ''),
                    '0055xx87': ('SL',
                                 '1',
                                 'Plane of Transverse Top Slice',
                                 ''),
                    '0055xx88': ('SL', '1', 'Slice Step in Pixels', ''),
                    '0055xx8a': ('SL',
                                 '1',
                                 'Y-Axis Smooth Slice Weights',
                                 ''),
                    '0055xx8b': ('SL',
                                 '1',
                                 'Number of Transverse Slices',
                                 ''),
                    '0055xx8c': ('SS',
                                 '1',
                                 'Attenuation Flag 1 Chang 2 Sorenson',
                                 ''),
                    '0055xx8d': ('SS', '1', 'Sagittal Right Limit', ''),
                    '0055xx8e': ('SS', '1', 'Sagittal Left Limit', ''),
                    '0055xx8f': ('SS', '1', 'Coronal Posterior Limit', ''),
                    '0055xx90': ('SS', '1', 'Coronal Anterior Limit', ''),
                    '0055xx91': ('SS',
                                 '1',
                                 'Isotope Used in Reconstruction',
                                 ''),
                    '0055xx93': ('FL', '1', 'Filter Cutoff Frequency', ''),
                    '0055xx94': ('FL', '1', 'Filter Alpha Coefficient', ''),
                    '0055xx95': ('FL', '1', 'Filter Order', ''),
                    '0055xx96': ('FL', '1', 'Attenuation Cooefficient', ''),
                    '0055xx97': ('SS', '1', 'Percent Ray', ''),
                    '0055xx98': ('SS',
                                 '1',
                                 'Astigmatic Collimator 1 Neuro 2 Cardiac',
                                 ''),
                    '0055xx99': ('SS', '1', 'XP0', ''),
                    '0055xx9a': ('SS', '1', 'ZP0', ''),
                    '0055xx9b': ('SS', '1', 'XP1', ''),
                    '0055xx9c': ('SS', '1', 'ZP1', ''),
                    '0055xx9d': ('FL', '1', 'Rotation Matrix', ''),
                    '0055xx9e': ('FL', '1', 'X0', ''),
                    '0055xx9f': ('FL', '1', 'X1', ''),
                    '0055xxa0': ('FL', '1', 'Y0', ''),
                    '0055xxa1': ('FL', '1', 'Y1', ''),
                    '0055xxa2': ('FL', '1', 'Z0', ''),
                    '0055xxa3': ('FL', '1', 'Z1', ''),
                    '0055xxa4': ('SS', '1', 'Transverse Scale', ''),
                    '0055xxa5': ('FL', '1', 'Pixel Size X Direction mm', ''),
                    '0055xxa6': ('FL', '1', 'Pixel Size Y Direction mm', ''),
                    '0055xxa7': ('SS', '1', 'Regions File Extension', ''),
                    '0055xxa8': ('SS',
                                 '1',
                                 'Gated SPECT Bins Reconstructed',
                                 ''),
                    '0055xxa9': ('SS', '1', 'Vertical Oblique Image', ''),
                    '0055xxb0': ('SS', '1', 'Oblique Region First Slice', ''),
                    '0055xxb1': ('SS', '1', 'Oblique Region Last Slice', ''),
                    '0055xxc0': ('SS', '1-n', 'Unknown', ''),
                    '0055xxc2': ('SS', '1', 'Unknown', ''),
                    '0055xxc3': ('SS', '1', 'Unknown', ''),
                    '0055xxc4': ('SS', '1', 'Unknown', ''),
                    '0055xxd0': ('SS', '1', 'Unknown', ''),
                    '0057xx01': ('LO',
                                 '1',
                                 'e.soft DICOM original image type',
                                 ''),
                    '0057xx02': ('FL', '1', 'Dose calibration factor', ''),
                    '0057xx03': ('LO', '1', 'Units', ''),
                    '0057xx04': ('LO', '1', 'Decay correction', ''),
                    '0057xx05': ('SL', '1-n', 'Radio nuclide half life', ''),
                    '0057xx06': ('FL', '1', 'Rescale intercept', ''),
                    '0057xx07': ('FL', '1', 'Rescale Slope', ''),
                    '0057xx08': ('FL', '1', 'Frame reference time', ''),
                    '0057xx09': ('SL',
                                 '1',
                                 'Number of Radiopharmaceutical information seq',
                                 ''),
                    '0057xx0a': ('FL', '1', 'Decay factor', ''),
                    '0057xx0b': ('LO', '1', 'Counts source', ''),
                    '0057xx0c': ('SL',
                                 '1-n',
                                 'Radio Nuclide positron fraction',
                                 ''),
                    '0057xx10': ('SS', '1', 'Low Count', ''),
                    '0057xx20': ('SS', '1', 'Vertical Oblique Image', ''),
                    '5001xx02': ('SL', '1', 'Number of Points', ''),
                    '5001xx03': ('FL', '1', 'Minimal Value on X-Axis', ''),
                    '5001xx04': ('FL', '1', 'Maximal Value on X-Axis', ''),
                    '5001xx05': ('FL', '1', 'Minimal Value on Y-Axis', ''),
                    '5001xx06': ('FL', '1', 'Maximal Value on Y-Axis', ''),
                    '5001xx07': ('LO', '1', 'Curve Name', ''),
                    '5001xx08': ('LO', '1', 'Curve Function Label', ''),
                    '5001xx09': ('SH', '1', 'X Axis Label', ''),
                    '5001xx0a': ('SH', '1', 'Y Axis Label', ''),
                    '5001xx0b': ('OW', '1', 'Curve Data', ''),
                    '7fe1xx10': ('OW', '1', 'Compressed Pixel Data', ''),
                    '7fe3xx00': ('UL', '1', 'Length of Group 0x7FE3', ''),
                    '7fe3xx14': ('SL',
                                 '1',
                                 'Lowest Pixel Value in THIS Frame',
                                 ''),
                    '7fe3xx15': ('SL',
                                 '1',
                                 'Highest Pixel Value in THIS Frame',
                                 ''),
                    '7fe3xx16': ('SL', '1', 'Total Counts in THIS Frame', ''),
                    '7fe3xx17': ('SL',
                                 '1',
                                 'Duration of THIS Frame msec',
                                 ''),
                    '7fe3xx18': ('FL', '1', 'Frame Angle', ''),
                    '7fe3xx19': ('LO', '1', 'Frame Name', ''),
                    '7fe3xx1a': ('FL', '1', 'View Number', ''),
                    '7fe3xx1b': ('SS',
                                 '1',
                                 'Pixel Overflow Flag 1 Pixel Overflow',
                                 ''),
                    '7fe3xx1c': ('SS',
                                 '1',
                                 'Buffer Overflow Flag 1 Buffer Overflow',
                                 ''),
                    '7fe3xx1e': ('SL',
                                 '1',
                                 'Start Time of THIS Frame From Start of Study',
                                 ''),
                    '7fe3xx1f': ('SL', '1', 'ROI Maximum Pixel Value', ''),
                    '7fe3xx20': ('SL', '1', 'ROI Average Pixel Value', ''),
                    '7fe3xx21': ('SL', '1', 'ROI Total Counts', ''),
                    '7fe3xx22': ('SL', '1', 'ROI Total Pixels', ''),
                    '7fe3xx23': ('SL', '1', 'ROI Center Coordinates', ''),
                    '7fe3xx24': ('LO', '1', 'ROI Name', ''),
                    '7fe3xx25': ('SS', '1', 'ROI Data', ''),
                    '7fe3xx26': ('OW', '1', 'Unknown', ''),
                    '7fe3xx27': ('OW', '1', 'Unknown', ''),
                    '7fe3xx28': ('OW', '1', 'Unknown', ''),
                    '7fe3xx29': ('OW', '1', 'Unknown', '')},
 'SIEMENS MED OCS ACKNOWLEDGE FLAG': {'0039xx81': ('IS',
                                                   '1',
                                                   'Acknowledge Flag',
                                                   '')},
 'SIEMENS MED OCS AE TITLE': {'0039xx79': ('CS', '1', 'AE Title', '')},
 'SIEMENS MED OCS CALIBRATION DATE': {'0039xx81': ('CS',
                                                   '1',
                                                   'Calibration Date',
                                                   '')},
 'SIEMENS MED OCS CBT ARC INCREMENT': {'0039xx84': ('IS',
                                                    '1-n',
                                                    'Arc Increment',
                                                    '')},
 'SIEMENS MED OCS CBT ENDING GANTRY ANGLE': {'0039xx83': ('DS',
                                                          '1-n',
                                                          'Ending Projection Angle',
                                                          '')},
 'SIEMENS MED OCS CBT MISSING PROJECTION FRAMES': {'0039xx91': ('IS',
                                                                '1-n',
                                                                'Missing Projection Frames',
                                                                '')},
 'SIEMENS MED OCS CBT PATIENT_ORIENTATION': {'0039xx93': ('CS',
                                                          '1',
                                                          'Patient Orientation',
                                                          '')},
 'SIEMENS MED OCS CBT PROJECTION GANTRY POSITIONS': {'0039xx86': ('DS',
                                                                  '1-n',
                                                                  'Gantry Positions',
                                                                  '')},
 'SIEMENS MED OCS CBT RECON FILTER TYPE': {'0039xx90': ('IS',
                                                        '1',
                                                        'Reconstruction Filter Type',
                                                        '')},
 'SIEMENS MED OCS CBT RECON NUM OF SLICES': {'0039xx89': ('IS',
                                                          '1',
                                                          'Number of Reconstruction Slices',
                                                          '')},
 'SIEMENS MED OCS CBT RECON SLICE HEIGHT': {'0039xx88': ('IS',
                                                         '1',
                                                         'Reconstruction Slice Height',
                                                         '')},
 'SIEMENS MED OCS CBT RECON SLICE WIDTH': {'0039xx87': ('IS',
                                                        '1',
                                                        'Reconstruction Slice Width',
                                                        '')},
 'SIEMENS MED OCS CBT ROTATION DIRECTION': {'0039xx85': ('CS',
                                                         '1-n',
                                                         'Gantry Rotation Direction',
                                                         '')},
 'SIEMENS MED OCS CBT STARTING GANTRY ANGLE': {'0039xx82': ('DS',
                                                            '1-n',
                                                            'Starting Projection Angle',
                                                            '')},
 'SIEMENS MED OCS CBT TOTAL_MU': {'0039xx96': ('DS',
                                               '1',
                                               'Total MU delivered during Cone Beam',
                                               '')},
 'SIEMENS MED OCS COMMON EDGE': {'0039xx83': ('IS', '1', 'Common Edge', '')},
 'SIEMENS MED OCS FIELD ID': {'0039xx80': ('CS', '1', 'Field ID', '')},
 'SIEMENS MED OCS FIELD NAME': {'0039xx79': ('CS', '1', 'Field Name', '')},
 'SIEMENS MED OCS FP Alignment Calibration Date / Time': {'0039xx95': ('DT',
                                                                       '1',
                                                                       'Flat Panel Alignment last calibration Date and Time',
                                                                       '')},
 'SIEMENS MED OCS I0 MU SCALE FACTOR': {'0039xx97': ('IS',
                                                     '1',
                                                     'I0-MU Scale Factor',
                                                     '')},
 'SIEMENS MED OCS ICC MATRIX': {'0039xx82': ('DS',
                                             '2',
                                             'Image Center in Image Coordinates',
                                             '')},
 'SIEMENS MED OCS NUMBER OF FRAMES': {'0039xx76': ('IS',
                                                   '1',
                                                   'Number of Frames',
                                                   '')},
 'SIEMENS MED OCS NUMBER OF SUB FRAMES': {'0039xx77': ('IS',
                                                       '1',
                                                       'Number of Sub-Frames',
                                                       '')},
 'SIEMENS MED OCS PI ALIGNMENT IMAGE': {'0039xx94': ('IS',
                                                     '1',
                                                     'Alignment Offset Valid Flag',
                                                     '')},
 'SIEMENS MED OCS PI VALID PIXEL MAP': {'0039xx92': ('IS',
                                                     '1',
                                                     'Valid Pixel Map Flag',
                                                     '')},
 'SIEMENS MED OCS REFERENCE IMAGE': {'0039xx76': ('UI',
                                                  '1',
                                                  'Reference Image',
                                                  '')},
 'SIEMENS MED OCS REFERENCE LOCKED': {'0039xx88': ('IS',
                                                   '1',
                                                   'Locked Flag',
                                                   '')},
 'SIEMENS MED OCS SC IMG PIX SPC': {'0039xx87': ('DS',
                                                 '2',
                                                 'Non-RT Image Pixel Spacing',
                                                 '')},
 'SIEMENS MED OCS SC IMG SAD': {'0039xx86': ('DS',
                                             '1',
                                             'Non-RT Image SAD',
                                             '')},
 'SIEMENS MED OCS SC IMG SID': {'0039xx85': ('DS',
                                             '1',
                                             'Non-RT Image SID',
                                             '')},
 'SIEMENS MED OCS SCALED IMG PIX SPC': {'0039xx84': ('DS',
                                                     '2',
                                                     'Scaled Image Pixel Spacing',
                                                     '')},
 'SIEMENS MED OCS SITE NAME': {'0039xx78': ('CS', '1', 'Site Name', '')},
 'SIEMENS MED OCS TABLE LATERAL POSITION': {'0039xx98': ('DS',
                                                         '1',
                                                         'Lateral Table Position',
                                                         '')},
 'SIEMENS MED OCS TABLE LONGITUDINAL POSITION': {'0039xx99': ('DS',
                                                              '1',
                                                              'Longitudinal Table Position',
                                                              '')},
 'SIEMENS MED OCS TABLE OFFSET': {'0039xx78': ('DS', '3', 'Offset', '')},
 'SIEMENS MED OCS TABLE VERTICAL POSITION': {'0039xx75': ('DS',
                                                          '1',
                                                          'vertical Table Position',
                                                          '')},
 'SIEMENS MED OCS TRANS MATRIX': {'0039xx80': ('DS',
                                               '5',
                                               'Transformation Matrix',
                                               '')},
 'SIEMENS MED SMS USG ANTARES': {'0019xx00': ('UN',
                                              '1',
                                              'Private Creator Version',
                                              ''),
                                 '0019xx03': ('UN', '1', 'Frame Rate', ''),
                                 '0019xx0c': ('UN',
                                              '1',
                                              'Burned in Graphics',
                                              ''),
                                 '0019xx0d': ('UN',
                                              '1',
                                              'SieClear Index',
                                              ''),
                                 '0019xx20': ('UN',
                                              '1',
                                              'B-Mode Submode',
                                              ''),
                                 '0019xx21': ('UN',
                                              '1',
                                              'B-Mode Dynamic Range',
                                              ''),
                                 '0019xx22': ('UN',
                                              '1',
                                              'B-Mode Overall Gain',
                                              ''),
                                 '0019xx23': ('UN',
                                              '1',
                                              'B-Mode Res/Speed Index',
                                              ''),
                                 '0019xx24': ('UN',
                                              '1',
                                              'B-Mode Edge Enhance Index',
                                              ''),
                                 '0019xx25': ('UN',
                                              '1',
                                              'B-Mode Persistence Index',
                                              ''),
                                 '0019xx26': ('UN',
                                              '1',
                                              'B-Mode Map Index',
                                              ''),
                                 '0019xx27': ('US', '1', 'Unknown', ''),
                                 '0019xx28': ('US', '1', 'Unknown', ''),
                                 '0019xx29': ('US', '1', 'Unknown', ''),
                                 '0019xx2a': ('UN',
                                              '1',
                                              'B-Mode Tint Type',
                                              ''),
                                 '0019xx2d': ('UN',
                                              '1',
                                              'B-Mode Tint Index',
                                              ''),
                                 '0019xx2e': ('UN',
                                              '1',
                                              'ClarifyVE Index',
                                              ''),
                                 '0019xx31': ('US', '1', 'Unknown', ''),
                                 '0019xx3a': ('UN', '1', 'Image Flag', ''),
                                 '0019xx3b': ('LT', '1', 'Unknown', ''),
                                 '0019xx40': ('UN',
                                              '1',
                                              'Color Flow state',
                                              ''),
                                 '0019xx41': ('UN',
                                              '1',
                                              'Color Flow Wall Filter Index',
                                              ''),
                                 '0019xx42': ('UN',
                                              '1',
                                              'Color Flow Submode',
                                              ''),
                                 '0019xx43': ('UN',
                                              '1',
                                              'Color Flow Overall Gain',
                                              ''),
                                 '0019xx44': ('UN',
                                              '1',
                                              'Color Flow Res/Speed Index',
                                              ''),
                                 '0019xx46': ('UN',
                                              '1',
                                              'Color Flow Smooth Index',
                                              ''),
                                 '0019xx47': ('UN',
                                              '1',
                                              'Color Flow Persistence Index',
                                              ''),
                                 '0019xx48': ('UN',
                                              '1',
                                              'Color Flow Map Index',
                                              ''),
                                 '0019xx49': ('UN',
                                              '1',
                                              'Color Flow Priority Index',
                                              ''),
                                 '0019xx54': ('UN',
                                              '1',
                                              'Color Flow Maximum Velocity',
                                              ''),
                                 '0019xx60': ('UN',
                                              '1',
                                              'Doppler Dynamic Range',
                                              ''),
                                 '0019xx61': ('UN',
                                              '1',
                                              'Doppler Overall Gain',
                                              ''),
                                 '0019xx62': ('UN',
                                              '1',
                                              'Doppler Wall Filter',
                                              ''),
                                 '0019xx63': ('UN',
                                              '1',
                                              'Doppler Gate Size',
                                              ''),
                                 '0019xx65': ('UN',
                                              '1',
                                              'Doppler Map Index',
                                              ''),
                                 '0019xx66': ('UN',
                                              '1',
                                              'Doppler Submode',
                                              ''),
                                 '0019xx67': ('US', '1', 'Unknown', ''),
                                 '0019xx69': ('UN',
                                              '1',
                                              'Doppler Time/Freq Res Index',
                                              ''),
                                 '0019xx6a': ('UN',
                                              '1',
                                              'Doppler Trace Inverted',
                                              ''),
                                 '0019xx6c': ('UN',
                                              '1',
                                              'Doppler Tint Type',
                                              ''),
                                 '0019xx72': ('UN',
                                              '1',
                                              'Doppler Tint Index',
                                              ''),
                                 '0019xx80': ('UN',
                                              '1',
                                              'M-Mode Dynamic Range',
                                              ''),
                                 '0019xx81': ('UN',
                                              '1',
                                              'M-Mode Overall Gain',
                                              ''),
                                 '0019xx82': ('UN',
                                              '1',
                                              'M-Mode Edge Enhance Index',
                                              ''),
                                 '0019xx83': ('UN',
                                              '1',
                                              'M-Mode Map Index',
                                              ''),
                                 '0019xx86': ('UN',
                                              '1',
                                              'M-Mode Tint Type',
                                              ''),
                                 '0019xx87': ('UN',
                                              '1',
                                              'M-Mode Submode',
                                              ''),
                                 '0019xx88': ('UN',
                                              '1',
                                              'M-Mode Tint Index',
                                              ''),
                                 '0019xxa0': ('LT', '1', 'Unknown', '')},
 'SIEMENS MED SMS USG ANTARES 3D VOLUME': {'0039xx00': ('UN',
                                                        '1',
                                                        'Release Version',
                                                        ''),
                                           '0039xx03': ('UN',
                                                        '1',
                                                        'VolumeAcquisitionDuration',
                                                        ''),
                                           '0039xx04': ('UN',
                                                        '1',
                                                        'VolumeRawDataType',
                                                        ''),
                                           '0039xx05': ('UN',
                                                        '1',
                                                        'ScanType',
                                                        ''),
                                           '0039xx06': ('UN',
                                                        '1',
                                                        'ZlateralMin',
                                                        ''),
                                           '0039xx07': ('UN',
                                                        '1',
                                                        'ZlateralSpan',
                                                        ''),
                                           '0039xx08': ('UN',
                                                        '1',
                                                        'ZRadiusOfCurvature',
                                                        ''),
                                           '0039xx09': ('UN',
                                                        '1',
                                                        'WobbleCorrection',
                                                        ''),
                                           '0039xx10': ('UN',
                                                        '1',
                                                        'ScaleAlongWidth',
                                                        ''),
                                           '0039xx11': ('UN',
                                                        '1',
                                                        'ScaleAlongHeight',
                                                        ''),
                                           '0039xx12': ('UN',
                                                        '1',
                                                        'ScaleAlongDepth',
                                                        ''),
                                           '0039xx13': ('UN',
                                                        '1',
                                                        'BufferSize',
                                                        ''),
                                           '0039xx14': ('UN',
                                                        '1',
                                                        'AcquisitionRate',
                                                        ''),
                                           '0039xx15': ('UN',
                                                        '1',
                                                        'DepthMinCm',
                                                        ''),
                                           '0039xx16': ('UN',
                                                        '1',
                                                        'IsLeftRightFlippedEn',
                                                        ''),
                                           '0039xx17': ('UN',
                                                        '1',
                                                        'IsUpDownFlippedEn',
                                                        ''),
                                           '0039xx18': ('UN',
                                                        '1',
                                                        'IsVolumeGeomAccurate',
                                                        ''),
                                           '0039xx19': ('UN',
                                                        '1',
                                                        'BByteMaskOffset',
                                                        ''),
                                           '0039xx20': ('UN',
                                                        '1',
                                                        'BByteMaskSize',
                                                        ''),
                                           '0039xx21': ('UN',
                                                        '1',
                                                        'DepthMaxCm',
                                                        ''),
                                           '0039xx22': ('UN',
                                                        '1',
                                                        'AcqPlaneRotationDeg',
                                                        ''),
                                           '0039xx23': ('UN',
                                                        '1',
                                                        'BeamAxialSpan',
                                                        ''),
                                           '0039xx24': ('UN',
                                                        '1',
                                                        'BeamLateralMin',
                                                        ''),
                                           '0039xx25': ('UN',
                                                        '1',
                                                        'BeamLateralSpan',
                                                        ''),
                                           '0039xx26': ('UN',
                                                        '1',
                                                        'BeamAxialMin',
                                                        ''),
                                           '0039xx27': ('UN',
                                                        '1',
                                                        'NumDisplaySamples',
                                                        ''),
                                           '0039xx28': ('UN',
                                                        '1',
                                                        'DVolumeWidth',
                                                        ''),
                                           '0039xx29': ('UN',
                                                        '1',
                                                        'DVolumeDepth',
                                                        ''),
                                           '0039xx30': ('UN',
                                                        '1',
                                                        'DVolumeHeight',
                                                        ''),
                                           '0039xx31': ('UN',
                                                        '1',
                                                        'DVolumePosX',
                                                        ''),
                                           '0039xx32': ('UN',
                                                        '1',
                                                        'DVolumePosY',
                                                        ''),
                                           '0039xx33': ('UN',
                                                        '1',
                                                        'DVolumePosZ',
                                                        ''),
                                           '0039xx34': ('UN',
                                                        '1',
                                                        'DBeamAxialMin',
                                                        ''),
                                           '0039xx35': ('UN',
                                                        '1',
                                                        'DBeamAxialSpan',
                                                        ''),
                                           '0039xx36': ('UN',
                                                        '1',
                                                        'DBeamLateralMin',
                                                        ''),
                                           '0039xx37': ('UN',
                                                        '1',
                                                        'DBeamLateralSpan',
                                                        ''),
                                           '0039xx38': ('UN',
                                                        '1',
                                                        'NumOfVolumesInSequence',
                                                        ''),
                                           '0039xx39': ('UN',
                                                        '1',
                                                        'DByteMaskOffset',
                                                        ''),
                                           '0039xx40': ('UN',
                                                        '1',
                                                        'DByteMaskSize',
                                                        ''),
                                           '0039xx50': ('UN',
                                                        '1',
                                                        'PrivateCreatorVersionOfBookmark',
                                                        ''),
                                           '0039xx51': ('UN',
                                                        '1',
                                                        'BCutPlaneEnable',
                                                        ''),
                                           '0039xx52': ('UN',
                                                        '1',
                                                        'BMprColorMapIndex',
                                                        ''),
                                           '0039xx53': ('UN',
                                                        '1',
                                                        'BMprDynamicRangeDb',
                                                        ''),
                                           '0039xx54': ('UN',
                                                        '1',
                                                        'BMprGrayMapIndex',
                                                        ''),
                                           '0039xx55': ('UN',
                                                        '1',
                                                        'BVolumeRenderMode',
                                                        ''),
                                           '0039xx56': ('UN',
                                                        '1',
                                                        'BVrBrightness',
                                                        ''),
                                           '0039xx57': ('UN',
                                                        '1',
                                                        'BVrContrast',
                                                        ''),
                                           '0039xx58': ('UN',
                                                        '1',
                                                        'BVrColorMapIndex',
                                                        ''),
                                           '0039xx59': ('UN',
                                                        '1',
                                                        'BVrDynamicRangeDb',
                                                        ''),
                                           '0039xx5a': ('UN',
                                                        '1',
                                                        'BVrGrayMapIndex',
                                                        ''),
                                           '0039xx5b': ('UN',
                                                        '1',
                                                        'BVrOpacity',
                                                        ''),
                                           '0039xx5c': ('UN',
                                                        '1',
                                                        'BVrThresholdHigh',
                                                        ''),
                                           '0039xx5d': ('UN',
                                                        '1',
                                                        'BVrThresholdLow',
                                                        ''),
                                           '0039xx5e': ('UN',
                                                        '1',
                                                        'BPreProcessFilterMix',
                                                        ''),
                                           '0039xx5f': ('UN',
                                                        '1',
                                                        'CCutPlaneEnable',
                                                        ''),
                                           '0039xx60': ('UN',
                                                        '1',
                                                        'CFrontClipMode',
                                                        ''),
                                           '0039xx61': ('UN',
                                                        '1',
                                                        'CMprColorMapIndex',
                                                        ''),
                                           '0039xx62': ('UN',
                                                        '1',
                                                        'CMprColorFlowPriorityIndex',
                                                        ''),
                                           '0039xx63': ('UN',
                                                        '1',
                                                        'CVolumeRenderMode',
                                                        ''),
                                           '0039xx64': ('UN',
                                                        '1',
                                                        'CVrColorMapIndex',
                                                        ''),
                                           '0039xx65': ('UN',
                                                        '1',
                                                        'CVrColorFlowPriorityIndex',
                                                        ''),
                                           '0039xx66': ('UN',
                                                        '1',
                                                        'CVrOpacity',
                                                        ''),
                                           '0039xx67': ('UN',
                                                        '1',
                                                        'CVrThresholdHigh',
                                                        ''),
                                           '0039xx68': ('UN',
                                                        '1',
                                                        'CVrThresholdLow',
                                                        ''),
                                           '0039xx69': ('UN',
                                                        '1',
                                                        'VoiMode',
                                                        ''),
                                           '0039xx6a': ('UN',
                                                        '1',
                                                        'VoiRotationOffsetDeg',
                                                        ''),
                                           '0039xx6b': ('UN',
                                                        '1',
                                                        'VoiSizeRatioX',
                                                        ''),
                                           '0039xx6c': ('UN',
                                                        '1',
                                                        'VoiSizeRatioY',
                                                        ''),
                                           '0039xx6d': ('UN',
                                                        '1',
                                                        'VoiSizeRatioZ',
                                                        ''),
                                           '0039xx6e': ('UN',
                                                        '1',
                                                        'VoiSyncPlane',
                                                        ''),
                                           '0039xx6f': ('UN',
                                                        '1',
                                                        'VoiViewMode',
                                                        ''),
                                           '0039xx70': ('UN',
                                                        '1',
                                                        'VrOrientationA',
                                                        ''),
                                           '0039xx71': ('UN',
                                                        '1',
                                                        'MprOrientationA',
                                                        ''),
                                           '0039xx72': ('UN',
                                                        '1',
                                                        'VrOffsetVector',
                                                        ''),
                                           '0039xx73': ('UN',
                                                        '1',
                                                        'BlendingRatio',
                                                        ''),
                                           '0039xx74': ('UN',
                                                        '1',
                                                        'FusionBlendMode',
                                                        ''),
                                           '0039xx75': ('UN',
                                                        '1',
                                                        'QualityFactor',
                                                        ''),
                                           '0039xx76': ('UN',
                                                        '1',
                                                        'RendererType',
                                                        ''),
                                           '0039xx77': ('UN',
                                                        '1',
                                                        'SliceMode',
                                                        ''),
                                           '0039xx78': ('UN',
                                                        '1',
                                                        'ActiveQuad',
                                                        ''),
                                           '0039xx79': ('UN',
                                                        '1',
                                                        'ScreenMode',
                                                        ''),
                                           '0039xx7a': ('UN',
                                                        '1',
                                                        'CutPlaneSide',
                                                        ''),
                                           '0039xx7b': ('UN',
                                                        '1',
                                                        'WireframeMode',
                                                        ''),
                                           '0039xx7c': ('UN',
                                                        '1',
                                                        'CrossmarkMode',
                                                        ''),
                                           '0039xx7d': ('UN',
                                                        '1',
                                                        'MprDisplayType',
                                                        ''),
                                           '0039xx7e': ('UN',
                                                        '1',
                                                        'VolumeDisplayType',
                                                        ''),
                                           '0039xx7f': ('UN',
                                                        '1',
                                                        'LastReset',
                                                        ''),
                                           '0039xx80': ('UN',
                                                        '1',
                                                        'LastNonFullScreenMode',
                                                        ''),
                                           '0039xx81': ('UN',
                                                        '1',
                                                        'MprToolIndex',
                                                        ''),
                                           '0039xx82': ('UN',
                                                        '1',
                                                        'VoiToolIndex',
                                                        ''),
                                           '0039xx83': ('UN',
                                                        '1',
                                                        'ToolLoopMode',
                                                        ''),
                                           '0039xx84': ('UN',
                                                        '1',
                                                        'VolumeArbMode',
                                                        ''),
                                           '0039xx85': ('UN',
                                                        '1',
                                                        'MprZoomEn',
                                                        ''),
                                           '0039xx86': ('UN',
                                                        '1',
                                                        'IsVolumeZoomEn',
                                                        ''),
                                           '0039xx87': ('UN',
                                                        '1',
                                                        'ZoomLevelMpr',
                                                        ''),
                                           '0039xx88': ('UN',
                                                        '1',
                                                        'ZoomLevelVolume',
                                                        ''),
                                           '0039xx89': ('UN',
                                                        '1',
                                                        'IsAutoRotateEn',
                                                        ''),
                                           '0039xx8a': ('UN',
                                                        '1',
                                                        'AutoRotateAxis',
                                                        ''),
                                           '0039xx8b': ('UN',
                                                        '1',
                                                        'AutoRotateRangeIndex',
                                                        ''),
                                           '0039xx8c': ('UN',
                                                        '1',
                                                        'AutoRotateSpeedIndex',
                                                        ''),
                                           '0039xx8d': ('UN',
                                                        '1',
                                                        'CVrBrightness',
                                                        ''),
                                           '0039xx8e': ('UN',
                                                        '1',
                                                        'CFlowStateIndex',
                                                        ''),
                                           '0039xx8f': ('UN',
                                                        '1',
                                                        'BSubmodeIndex',
                                                        ''),
                                           '0039xx90': ('UN',
                                                        '1',
                                                        'CSubmodeIndex',
                                                        ''),
                                           '0039xx91': ('UN',
                                                        '1',
                                                        'DICOMAttrNameCutPlane',
                                                        ''),
                                           '0039xx92': ('UN',
                                                        '1',
                                                        'BookmarkChunkId',
                                                        ''),
                                           '0039xx93': ('UN',
                                                        '1',
                                                        'SequenceMinChunkId',
                                                        ''),
                                           '0039xx94': ('UN',
                                                        '1',
                                                        'SequenceMaxChunkId',
                                                        ''),
                                           '0039xx95': ('UN',
                                                        '1',
                                                        'VolumeRateHz',
                                                        ''),
                                           '0039xx9a': ('UN',
                                                        '1',
                                                        'VoiPositionOffsetX',
                                                        ''),
                                           '0039xx9b': ('UN',
                                                        '1',
                                                        'VoiPositionOffsetY',
                                                        ''),
                                           '0039xx9c': ('UN',
                                                        '1',
                                                        'VoiPositionOffsetZ',
                                                        ''),
                                           '0039xx9d': ('UN',
                                                        '1',
                                                        'VrToolIndex',
                                                        ''),
                                           '0039xx9e': ('UN',
                                                        '1',
                                                        'ShadingPercent',
                                                        ''),
                                           '0039xx9f': ('UN',
                                                        '1',
                                                        'VolumeType',
                                                        ''),
                                           '0039xxa0': ('UN',
                                                        '1',
                                                        'DICOMAttrNameVrQuadDisplayType',
                                                        ''),
                                           '0039xxa1': ('UN',
                                                        '1',
                                                        'DICOMAttrNameMprCenterLocation',
                                                        ''),
                                           '0039xxe0': ('UN',
                                                        '1',
                                                        'DICOMAttrNameSliceRangeType',
                                                        ''),
                                           '0039xxe1': ('UN',
                                                        '1',
                                                        'DICOMAttrNameSliceMPRPlane',
                                                        ''),
                                           '0039xxe2': ('UN',
                                                        '1',
                                                        'DICOMAttrNameSliceLayout',
                                                        ''),
                                           '0039xxe3': ('UN',
                                                        '1',
                                                        'DICOMAttrNameSliceSpacing',
                                                        ''),
                                           '0039xxe4': ('UN',
                                                        '1',
                                                        'DICOMAttrNameThinVrMode',
                                                        ''),
                                           '0039xxe5': ('UN',
                                                        '1',
                                                        'DICOMAttrNameThinVrThickness',
                                                        ''),
                                           '0039xxe6': ('UN',
                                                        '1',
                                                        'DICOMAttrNameVoiPivotX',
                                                        ''),
                                           '0039xxe7': ('UN',
                                                        '1',
                                                        'DICOMAttrNameVoiPivotY',
                                                        ''),
                                           '0039xxe8': ('UN',
                                                        '1',
                                                        'DICOMAttrNameVoiPivotZ',
                                                        ''),
                                           '0039xxe9': ('UN',
                                                        '1',
                                                        'DICOMAttrNameCTopVoiQuad',
                                                        '')},
 'SIEMENS MED SP DXMG WH AWS 1': {'0019xx01': ('UL', '1-n', 'Unknown', ''),
                                  '0019xx02': ('US', '2', 'Unknown', ''),
                                  '0041xx02': ('SH',
                                               '1',
                                               'Reason for the Requested Procedure',
                                               ''),
                                  '0055xx01': ('LO',
                                               '1',
                                               'Projection View Display String',
                                               '')},
 'SIEMENS MEDCOM HEADER': {'0029xx08': ('CS', '1', 'MedCom Header Type', ''),
                           '0029xx09': ('LO',
                                        '1',
                                        'MedCom Header Version',
                                        ''),
                           '0029xx10': ('OB', '1', 'MedCom Header Info', ''),
                           '0029xx20': ('OB',
                                        '1',
                                        'MedCom History Information',
                                        ''),
                           '0029xx31': ('LO', '1', 'PMTF Information 1', ''),
                           '0029xx32': ('UL', '1', 'PMTF Information 2', ''),
                           '0029xx33': ('UL', '1', 'PMTF Information 3', ''),
                           '0029xx34': ('CS', '1', 'PMTF Information 4', ''),
                           '0029xx35': ('UL', '1', 'PMTF Information 5', ''),
                           '0029xx40': ('SQ',
                                        '1',
                                        'Application Header Sequence',
                                        ''),
                           '0029xx41': ('CS',
                                        '1',
                                        'Application Header Type',
                                        ''),
                           '0029xx42': ('LO',
                                        '1',
                                        'Application Header ID',
                                        ''),
                           '0029xx43': ('LO',
                                        '1',
                                        'Application Header Version',
                                        ''),
                           '0029xx44': ('OB',
                                        '1',
                                        'Application Header Info',
                                        ''),
                           '0029xx50': ('LO',
                                        '8',
                                        'Workflow Control Flags',
                                        ''),
                           '0029xx51': ('CS',
                                        '1',
                                        'Arch. Management Flag Keep Online',
                                        ''),
                           '0029xx52': ('CS',
                                        '1',
                                        'Arch. Mgmnt Flag Do Not Archive',
                                        ''),
                           '0029xx53': ('CS',
                                        '1',
                                        'Image Location Status',
                                        ''),
                           '0029xx54': ('DS',
                                        '1',
                                        'Estimated Retrieve Time',
                                        ''),
                           '0029xx55': ('DS',
                                        '1',
                                        'Data Size of Retrieved Images',
                                        ''),
                           '0029xx70': ('SQ',
                                        '1',
                                        'Siemens Link Sequence',
                                        ''),
                           '0029xx71': ('AT', '1', 'Referenced Tag', ''),
                           '0029xx72': ('CS', '1', 'Referenced Tag Type', ''),
                           '0029xx73': ('UL',
                                        '1',
                                        'Referenced Value Length',
                                        ''),
                           '0029xx74': ('CS',
                                        '1',
                                        'Referenced Object Device Type',
                                        ''),
                           '0029xx75': ('OB',
                                        '1',
                                        'Referenced Object Device Location',
                                        ''),
                           '0029xx76': ('OB',
                                        '1',
                                        'Referenced Object ID',
                                        '')},
 'SIEMENS MEDCOM HEADER2': {'0029xx60': ('LO',
                                         '1',
                                         'Series Workflow Status',
                                         '')},
 'SIEMENS MEDCOM OOG': {'0029xx08': ('CS', '1', 'MedCom OOG Type', ''),
                        '0029xx09': ('LO', '1', 'MedCom OOG Version', ''),
                        '0029xx10': ('OB', '1', 'MedCom OOG Info', '')},
 'SIEMENS MR HEADER': {'0019xx08': ('CS', '1', 'CSA Image Header Type', ''),
                       '0019xx09': ('LO',
                                    '1',
                                    'CSA Image Header Version ??',
                                    ''),
                       '0019xx0a': ('US', '1', 'NumberOfImagesInMosaic', ''),
                       '0019xx0b': ('DS',
                                    '1',
                                    'SliceMeasurementDuration',
                                    ''),
                       '0019xx0c': ('IS', '1', 'B_value', ''),
                       '0019xx0d': ('CS', '1', 'DiffusionDirectionality', ''),
                       '0019xx0e': ('FD',
                                    '3',
                                    'DiffusionGradientDirection',
                                    ''),
                       '0019xx0f': ('SH', '1', 'GradientMode', ''),
                       '0019xx11': ('SH', '1', 'FlowCompensation', ''),
                       '0019xx12': ('SL', '3', 'TablePositionOrigin', ''),
                       '0019xx13': ('SL', '3', 'ImaAbsTablePosition', ''),
                       '0019xx14': ('IS', '3', 'ImaRelTablePosition', ''),
                       '0019xx15': ('FD', '3', 'SlicePosition_PCS', ''),
                       '0019xx16': ('DS', '1', 'TimeAfterStart', ''),
                       '0019xx17': ('DS', '1', 'SliceResolution', ''),
                       '0019xx18': ('IS', '1', 'RealDwellTime', ''),
                       '0019xx23': ('IS', '1', 'FMRIStimulInfo', ''),
                       '0019xx25': ('FD', '3', 'RBMoCoTrans', ''),
                       '0019xx26': ('FD', '3', 'RBMoCoRot', ''),
                       '0019xx27': ('FD', '6', 'B_matrix', ''),
                       '0019xx28': ('FD',
                                    '1',
                                    'BandwidthPerPixelPhaseEncode',
                                    ''),
                       '0019xx29': ('FD', '1', 'MosaicRefAcqTimes', ''),
                       '0051xx08': ('CS', '1', 'CSA Image Header Type', ''),
                       '0051xx09': ('LO',
                                    '1',
                                    'CSA Image Header Version ??',
                                    ''),
                       '0051xx0a': ('SH', '1', 'Unknown', ''),
                       '0051xx0b': ('SH', '1', 'AcquisitionMatrixText', ''),
                       '0051xx0c': ('SH', '1', 'Unknown', ''),
                       '0051xx0d': ('SH', '1', 'Unknown', ''),
                       '0051xx0e': ('SH', '1', 'Unknown', ''),
                       '0051xx0f': ('LO', '1', 'CoilString', ''),
                       '0051xx11': ('LO', '1', 'PATModeText', ''),
                       '0051xx12': ('SH', '1', 'Unknown', ''),
                       '0051xx13': ('SH', '1', 'PositivePCSDirections', ''),
                       '0051xx15': ('SH', '1', 'Unknown', ''),
                       '0051xx16': ('LO', '1', 'Unknown', ''),
                       '0051xx17': ('SH', '1', 'Unknown', ''),
                       '0051xx18': ('SH', '1', 'Unknown', ''),
                       '0051xx19': ('LO', '1', 'Unknown', '')},
 'SIEMENS MR VA0  COAD': {'0019xx12': ('DS',
                                       '1',
                                       'Magnetic Field Strength',
                                       ''),
                          '0019xx14': ('DS', '1', 'ADC Voltage', ''),
                          '0019xx16': ('DS', '1-n', 'ADC Offset', ''),
                          '0019xx20': ('DS',
                                       '1',
                                       'Transmitter Amplitude',
                                       ''),
                          '0019xx21': ('IS',
                                       '1',
                                       'Number of Transmitter Amplitudes',
                                       ''),
                          '0019xx22': ('DS',
                                       '1',
                                       'Transmitter Attenuator',
                                       ''),
                          '0019xx24': ('DS',
                                       '1',
                                       'Transmitter Calibration',
                                       ''),
                          '0019xx26': ('DS',
                                       '1',
                                       'Transmitter Reference',
                                       ''),
                          '0019xx50': ('DS', '1', 'Receiver Total Gain', ''),
                          '0019xx51': ('DS',
                                       '1',
                                       'Receiver Amplifier Gain',
                                       ''),
                          '0019xx52': ('DS',
                                       '1',
                                       'Receiver Preamplifier Gain',
                                       ''),
                          '0019xx54': ('DS',
                                       '1',
                                       'Receiver Cable Attenuation',
                                       ''),
                          '0019xx55': ('DS',
                                       '1',
                                       'Receiver Reference Gain',
                                       ''),
                          '0019xx56': ('IS',
                                       '1',
                                       'Receiver Filter Frequency',
                                       ''),
                          '0019xx60': ('DS',
                                       '1',
                                       'Reconstruction Scale Factor',
                                       ''),
                          '0019xx62': ('DS',
                                       '1',
                                       'Reference Scale Factor',
                                       ''),
                          '0019xx70': ('DS',
                                       '1',
                                       'Phase Gradient Amplitude',
                                       ''),
                          '0019xx71': ('DS',
                                       '1',
                                       'Readout Gradient Amplitude',
                                       ''),
                          '0019xx72': ('DS',
                                       '1',
                                       'Selection Gradient Amplitude',
                                       ''),
                          '0019xx80': ('DS',
                                       '1-n',
                                       'Gradient Delay Time',
                                       ''),
                          '0019xx82': ('DS',
                                       '1',
                                       'Total Gradient Delay Time',
                                       ''),
                          '0019xx90': ('LO',
                                       '1',
                                       'Sensitivity Correction Label',
                                       ''),
                          '0019xx91': ('DS',
                                       '1-5',
                                       'Saturation Phase Encoding Vector Coronal Component',
                                       ''),
                          '0019xx92': ('DS',
                                       '1-5',
                                       'Saturation Readout Vector Coronal Component',
                                       ''),
                          '0019xxa0': ('IS', '1', 'RF Watchdog Mask', ''),
                          '0019xxa1': ('DS',
                                       '1',
                                       'EPI Reconstruction Slope',
                                       ''),
                          '0019xxa2': ('DS',
                                       '1',
                                       'RF Power Error Indicator',
                                       ''),
                          '0019xxa5': ('DS',
                                       '1-n',
                                       'Specific Absorption Rate SAR',
                                       ''),
                          '0019xxa6': ('DS',
                                       '1-n',
                                       'Specific Energy Dose SED',
                                       ''),
                          '0019xxb0': ('UL',
                                       '1',
                                       'Adjustment Status Mask',
                                       ''),
                          '0019xxc1': ('DS', '1-n', 'EPI Capacity', ''),
                          '0019xxc2': ('DS', '1-n', 'EPI Inductance', ''),
                          '0019xxc3': ('IS',
                                       '1-n',
                                       'EPI Switch Configuration Code',
                                       ''),
                          '0019xxc4': ('IS',
                                       '1-n',
                                       'EPI Switch Hardware Code',
                                       ''),
                          '0019xxc5': ('DS',
                                       '1-n',
                                       'EPI Switch Delay Time',
                                       ''),
                          '0019xxd1': ('DS', '1', 'Flow Sensitivity', ''),
                          '0019xxd2': ('CS', '1', 'Calculation Submode', ''),
                          '0019xxd3': ('DS', '1', 'Field of View Ratio', ''),
                          '0019xxd4': ('IS', '1', 'Base Raw Matrix Size', ''),
                          '0019xxd5': ('IS',
                                       '1',
                                       '2D Phase Oversampling Lines',
                                       ''),
                          '0019xxd6': ('IS',
                                       '1',
                                       '3D Phase Oversampling Part',
                                       ''),
                          '0019xxd7': ('IS', '1', 'Echo Line Position', ''),
                          '0019xxd8': ('IS', '1', 'Echo Column Position', ''),
                          '0019xxd9': ('IS', '1', 'Lines per Segment', ''),
                          '0019xxda': ('CS',
                                       '1',
                                       'Phase Coding Direction',
                                       '')},
 'SIEMENS MR VA0  GEN': {'0019xx10': ('DS',
                                      '1',
                                      'Total Measurement Time nominal',
                                      ''),
                         '0019xx11': ('DS',
                                      '1',
                                      'Total Measurement Time current',
                                      ''),
                         '0019xx12': ('DS', '1', 'Start Delay Time', ''),
                         '0019xx13': ('DS', '1', 'Dwell Time', ''),
                         '0019xx14': ('IS', '1', 'Number of Phases', ''),
                         '0019xx16': ('UL',
                                      '1-n',
                                      'Sequence Control Mask',
                                      ''),
                         '0019xx18': ('UL',
                                      '1',
                                      'Measurement Status Mask',
                                      ''),
                         '0019xx20': ('IS',
                                      '1',
                                      'Number of Fourier Lines nominal',
                                      ''),
                         '0019xx21': ('IS',
                                      '1',
                                      'Number of Fourier Lines current',
                                      ''),
                         '0019xx26': ('IS',
                                      '1',
                                      'Number of Fourier Lines after Zero',
                                      ''),
                         '0019xx28': ('IS',
                                      '1',
                                      'First Measured Fourier Line',
                                      ''),
                         '0019xx30': ('IS', '1', 'Acquisition Columns', ''),
                         '0019xx31': ('IS',
                                      '1',
                                      'Reconstruction Columns',
                                      ''),
                         '0019xx40': ('IS', '1', 'AC Element Number', ''),
                         '0019xx41': ('UL',
                                      '1',
                                      'AC Element Select Mask',
                                      ''),
                         '0019xx42': ('UL', '1', 'AC Element Data Mask', ''),
                         '0019xx43': ('IS',
                                      '1-n',
                                      'AC Element To ADC Connect',
                                      ''),
                         '0019xx44': ('IS',
                                      '1-n',
                                      'AC Element Noise Level',
                                      ''),
                         '0019xx45': ('IS', '1', 'AC ADC Pair Number', ''),
                         '0019xx46': ('UL', '1', 'AC Combination Mask', ''),
                         '0019xx50': ('IS',
                                      '1',
                                      'Number of Averages current',
                                      ''),
                         '0019xx60': ('DS', '1', 'Flip Angle', ''),
                         '0019xx70': ('IS', '1', 'Number of Prescans', ''),
                         '0019xx81': ('CS',
                                      '1',
                                      'Filter Type for Raw Data',
                                      ''),
                         '0019xx82': ('DS',
                                      '1-4',
                                      'Filter Parameter for Raw Data',
                                      ''),
                         '0019xx83': ('CS',
                                      '1',
                                      'Filter Type for Image Data',
                                      ''),
                         '0019xx84': ('DS',
                                      '1-4',
                                      'Filter Parameter for Image Data',
                                      ''),
                         '0019xx85': ('CS',
                                      '1',
                                      'Filter Type for Phase Correction',
                                      ''),
                         '0019xx86': ('DS',
                                      '1-4',
                                      'Filter Parameter for Phase Correction',
                                      ''),
                         '0019xx87': ('CS',
                                      '1',
                                      'Normalization Filter Type for Image Data',
                                      ''),
                         '0019xx88': ('DS',
                                      '1-4',
                                      'Normalization Filter Parameter for Image Data',
                                      ''),
                         '0019xx90': ('IS',
                                      '1',
                                      'Number of Saturation Regions',
                                      ''),
                         '0019xx91': ('DS',
                                      '1-5',
                                      'Saturation Phase Encoding Vector Sagittal Compo...',
                                      ''),
                         '0019xx92': ('DS',
                                      '1-5',
                                      'Saturation Readout Vector Sagittal Component',
                                      ''),
                         '0019xx93': ('IS',
                                      '1',
                                      'EPI Stimulation Monitor Mode',
                                      ''),
                         '0019xx94': ('DS', '1', 'Image Rotation Angle', ''),
                         '0019xx96': ('UL', '1-n', 'Coil ID Mask', ''),
                         '0019xx97': ('UL', '1-n', 'Coil Class Mask', ''),
                         '0019xx98': ('DS', '1-n', 'Coil Position', ''),
                         '0019xxa0': ('DS',
                                      '1',
                                      'EPI Reconstruction Phase',
                                      ''),
                         '0019xxa1': ('DS',
                                      '1',
                                      'EPI Reconstruction Slope',
                                      ''),
                         '0021xx20': ('IS',
                                      '1',
                                      'Phase Corrections Rows sequence',
                                      ''),
                         '0021xx21': ('IS',
                                      '1',
                                      'Phase Corrections Columns sequence',
                                      ''),
                         '0021xx22': ('IS',
                                      '1',
                                      'Phase Corrections Rows reconstruction',
                                      ''),
                         '0021xx24': ('IS',
                                      '1',
                                      'Phase Corrections Columns reconstruction',
                                      ''),
                         '0021xx30': ('IS',
                                      '1',
                                      'Number of 3D Raw Partitions nominal',
                                      ''),
                         '0021xx31': ('IS',
                                      '1',
                                      'Number of 3D Raw Partitions current',
                                      ''),
                         '0021xx34': ('IS',
                                      '1',
                                      'Number of 3D Image Partitions',
                                      ''),
                         '0021xx36': ('IS',
                                      '1',
                                      'Actual 3D Image Partition Number',
                                      ''),
                         '0021xx39': ('DS', '1', 'Slab Thickness', ''),
                         '0021xx40': ('IS',
                                      '1',
                                      'Number of Slices nominal',
                                      ''),
                         '0021xx41': ('IS',
                                      '1',
                                      'Number of Slices current',
                                      ''),
                         '0021xx42': ('IS', '1', 'Current Slice Number', ''),
                         '0021xx43': ('IS', '1', 'Current Group Number', ''),
                         '0021xx44': ('DS',
                                      '1',
                                      'Current Slice Distance Factor',
                                      ''),
                         '0021xx45': ('IS', '1', 'MIP Start Row', ''),
                         '0021xx46': ('IS', '1', 'MIP Stop Row', ''),
                         '0021xx47': ('IS', '1', 'MIP Start Column', ''),
                         '0021xx48': ('IS', '1', 'MIP Stop Column', ''),
                         '0021xx49': ('IS', '1', 'MIP Start Slice', ''),
                         '0021xx4a': ('IS', '1', 'MIP Stop Slice', ''),
                         '0021xx4f': ('CS', '1', 'Order of Slices', ''),
                         '0021xx50': ('UL', '1', 'Signal Mask', ''),
                         '0021xx52': ('IS', '1', 'Delay after Trigger', ''),
                         '0021xx53': ('IS', '1', 'RRInterval', ''),
                         '0021xx54': ('DS',
                                      '1',
                                      'Number of Trigger Pulses',
                                      ''),
                         '0021xx56': ('DS',
                                      '1',
                                      'Repetition Time effective',
                                      ''),
                         '0021xx57': ('CS', '1', 'Gate Phase', ''),
                         '0021xx58': ('DS', '1', 'Gate Threshold', ''),
                         '0021xx59': ('DS', '1', 'Gated Ratio', ''),
                         '0021xx60': ('IS',
                                      '1',
                                      'Number of Interpolated Images',
                                      ''),
                         '0021xx70': ('IS', '1', 'Number of Echoes', ''),
                         '0021xx72': ('DS', '1', 'Second Echo Time', ''),
                         '0021xx73': ('DS',
                                      '1',
                                      'Second Repetition Time',
                                      ''),
                         '0021xx80': ('IS', '1', 'Cardiac Code', ''),
                         '0021xx91': ('DS',
                                      '1-n',
                                      'Saturation Phase Encoding Vector Transversal Co...',
                                      ''),
                         '0021xx92': ('DS',
                                      '1-n',
                                      'Saturation Readout Vector Transversal Component',
                                      ''),
                         '0021xx93': ('DS',
                                      '1',
                                      'EPI Change Value of Magnitude',
                                      ''),
                         '0021xx94': ('DS',
                                      '1',
                                      'EPI Change Value of X Component',
                                      ''),
                         '0021xx95': ('DS',
                                      '1',
                                      'EPI Change Value of Y Component',
                                      ''),
                         '0021xx96': ('DS',
                                      '1',
                                      'EPI Change Value of Z Component',
                                      '')},
 'SIEMENS MR VA0  RAW': {'0021xx00': ('CS', '1', 'Sequence Type', ''),
                         '0021xx01': ('IS', '1', 'Vector Size original', ''),
                         '0021xx02': ('IS', '1', 'Vector Size extended', ''),
                         '0021xx03': ('DS',
                                      '1',
                                      'Acquired Spectral Range',
                                      ''),
                         '0021xx04': ('DS', '1-n', 'VOI Position', ''),
                         '0021xx05': ('DS', '1-n', 'VOI Size', ''),
                         '0021xx06': ('IS',
                                      '1-n',
                                      'CSI Matrix Size original',
                                      ''),
                         '0021xx07': ('IS',
                                      '1-n',
                                      'CSI Matrix Size extended',
                                      ''),
                         '0021xx08': ('DS', '1-n', 'Spatial Grid Shift', ''),
                         '0021xx09': ('DS', '1', 'Signal Limits Minimum', ''),
                         '0021xx10': ('DS', '1', 'Signal Limits Maximum', ''),
                         '0021xx11': ('DS', '1', 'Spec Info Mask', ''),
                         '0021xx12': ('DS',
                                      '1',
                                      'EPI Time Rate of Change of Magnitude',
                                      ''),
                         '0021xx13': ('DS',
                                      '1',
                                      'EPI Time Rate of Change of X Component',
                                      ''),
                         '0021xx14': ('DS',
                                      '1',
                                      'EPI Time Rate of Change of Y Component',
                                      ''),
                         '0021xx15': ('DS',
                                      '1',
                                      'EPI Time Rate of Change of Z Component',
                                      ''),
                         '0021xx16': ('DS',
                                      '1',
                                      'EPI Time Rate of Change Legal Limit 1',
                                      ''),
                         '0021xx17': ('IS',
                                      '1',
                                      'EPI Operation Mode Flag',
                                      ''),
                         '0021xx18': ('DS',
                                      '1',
                                      'EPI Field Calculation Safety Factor',
                                      ''),
                         '0021xx19': ('DS',
                                      '1',
                                      'EPI Legal Limit 1 of Change Value',
                                      ''),
                         '0021xx20': ('DS',
                                      '1',
                                      'EPI Legal Limit 2 of Change Value',
                                      ''),
                         '0021xx21': ('DS', '1', 'EPI Rise Time', ''),
                         '0021xx30': ('DS', '1-n', 'AC ADC Offset', ''),
                         '0021xx31': ('DS',
                                      '1-n',
                                      'AC Preamplifier Gain',
                                      ''),
                         '0021xx50': ('CS', '1', 'Saturation Type', ''),
                         '0021xx51': ('DS',
                                      '1-n',
                                      'Saturation Normal Vector',
                                      ''),
                         '0021xx52': ('DS',
                                      '1-n',
                                      'Saturation Position Vector',
                                      ''),
                         '0021xx53': ('DS',
                                      '1-n',
                                      'Saturation Thickness',
                                      ''),
                         '0021xx54': ('DS', '1-n', 'Saturation Width', ''),
                         '0021xx55': ('DS', '1-n', 'Saturation Distance', '')},
 'SIEMENS NUMARIS II': {'7fe3xx00': ('LO',
                                     '1',
                                     'Image Graphics Format Code',
                                     ''),
                        '7fe3xx10': ('OB', '1', 'Image Graphics', ''),
                        '7fe3xx20': ('OB', '1', 'Image Graphics Dummy', '')},
 'SIEMENS RA GEN': {'0011xx20': ('UL', '1', 'Total Fluoro TimePatient', ''),
                    '0011xx25': ('UL', '1', 'Dose Area ProductPatient', ''),
                    '0011xx30': ('LO', '1', 'Patient DOB', ''),
                    '0011xx35': ('LO',
                                 '1',
                                 'Patient Initial Puck Counter',
                                 ''),
                    '0011xx40': ('CS', '1', 'Patient Initial Position', ''),
                    '0019xx15': ('CS', '1', 'Acquired Plane', ''),
                    '0019xx20': ('UL', '1', 'Scene Flag', ''),
                    '0019xx22': ('UL', '1', 'ReferencePhotofile Flag', ''),
                    '0019xx24': ('LO', '1', 'Scene Name', ''),
                    '0019xx26': ('US', '1', 'Acquisition Index', ''),
                    '0019xx28': ('US', '1', 'Mixed Pulse Mode', ''),
                    '0019xx2a': ('US', '1', 'Number of Positions', ''),
                    '0019xx2c': ('US', '1', 'Number of Phases', ''),
                    '0019xx2e': ('US',
                                 '1-n',
                                 'Framerate for 8 Positions',
                                 ''),
                    '0019xx30': ('US', '1-n', 'FramesPhase', ''),
                    '0019xx32': ('US', '1', 'Stepping Direction', ''),
                    '0019xx34': ('US', '1', 'Unknown', ''),
                    '0019xx36': ('US', '1', 'Unknown', ''),
                    '0019xx38': ('US', '1', 'Unknown', ''),
                    '0019xx3a': ('US', '1', 'Unknown', ''),
                    '0019xx3c': ('US', '1', 'Unknown', ''),
                    '0019xx3e': ('US', '1', 'Unknown', ''),
                    '0019xx40': ('US', '1', 'Unknown', ''),
                    '0019xx42': ('US', '1', 'Unknown', ''),
                    '0019xx44': ('US', '1', 'Image Transfer Delay', ''),
                    '0019xx46': ('UL', '1', 'InversNot Invers', ''),
                    '0019xx48': ('US', '1', 'Unknown', ''),
                    '0019xx4a': ('US', '1', 'Unknown', ''),
                    '0019xx4c': ('US', '1', 'Blanking Circle Diameter', ''),
                    '0019xx50': ('US', '1', 'Stand Data Valid', ''),
                    '0019xx52': ('US', '1', 'Table Tilt', ''),
                    '0019xx54': ('US', '1', 'Table Axis Rotation', ''),
                    '0019xx56': ('US',
                                 '1',
                                 'Table Longitudinal Position',
                                 ''),
                    '0019xx58': ('US', '1', 'Table Side Offset', ''),
                    '0019xx5a': ('US', '1', 'Table Isocenter Height', ''),
                    '0019xx5c': ('UN', '1', 'Unknown', ''),
                    '0019xx5e': ('UL', '1', 'Collimation Data Valid', ''),
                    '0019xx60': ('UL', '1', 'PERI Sequence Number', ''),
                    '0019xx62': ('UL', '1', 'PERI Total Scenes', ''),
                    '0019xx64': ('US', '1', 'PERI Overlap Top', ''),
                    '0019xx66': ('UL', '1', 'PERI Overlap Bottom', ''),
                    '0019xx68': ('UL', '1', 'Raw Image Number', ''),
                    '0019xx6a': ('UL', '1', 'XRay Data Valid', ''),
                    '0019xx70': ('US', '1-n', 'Unknown', ''),
                    '0019xx72': ('US', '1-n', 'Unknown', ''),
                    '0019xx74': ('US', '1-n', 'Unknown', ''),
                    '0019xx76': ('UL', '1', 'Filling Average Factor', ''),
                    '0019xx78': ('US', '1-n', 'Unknown', ''),
                    '0019xx7a': ('US', '1-n', 'Unknown', ''),
                    '0019xx7c': ('US', '1-n', 'Unknown', ''),
                    '0019xx7e': ('US', '1-n', 'Unknown', ''),
                    '0019xx80': ('US', '1-n', 'Unknown', ''),
                    '0019xx82': ('US', '1-n', 'Unknown', ''),
                    '0019xx84': ('US', '1-n', 'Unknown', ''),
                    '0019xx86': ('US', '1-n', 'Unknown', ''),
                    '0019xx88': ('US', '1-n', 'Unknown', ''),
                    '0019xx8a': ('US', '1-n', 'Unknown', ''),
                    '0019xx8c': ('US', '1-n', 'Unknown', ''),
                    '0019xx8e': ('US', '1-n', 'Unknown', ''),
                    '0019xx92': ('US', '1-n', 'Unknown', ''),
                    '0019xx94': ('US', '1-n', 'Unknown', ''),
                    '0019xx96': ('US', '1-n', 'Unknown', ''),
                    '0019xx98': ('US', '1-n', 'Unknown', ''),
                    '0019xx9a': ('US', '1-n', 'Unknown', ''),
                    '0019xx9c': ('UL', '1', 'II Level CalibrationFactor', ''),
                    '0019xx9e': ('UL', '1', 'Nativ Review Flag', ''),
                    '0021xx15': ('US', '1', 'Images in Study', ''),
                    '0021xx20': ('US', '1', 'Scenes in Study', ''),
                    '0021xx25': ('US', '1', 'Images in Photofile', ''),
                    '0021xx30': ('US', '1', 'Images in All Scenes', ''),
                    '0021xx40': ('US', '1', 'Unknown', '')},
 'SIEMENS RA PLANE A': {'0019xx20': ('UL',
                                     '1',
                                     'System Calibration Factor Plane A',
                                     ''),
                        '0019xx22': ('US',
                                     '1',
                                     'XRay Parameter Set Number',
                                     ''),
                        '0019xx24': ('US', '1', 'XRay System', ''),
                        '0019xx26': ('US', '1', 'Unknown', ''),
                        '0019xx28': ('US', '1', 'Acquired Display Mode', ''),
                        '0019xx2a': ('US', '1', 'Unknown', ''),
                        '0019xx2c': ('US', '1', 'Acquisition Framerate', ''),
                        '0019xx2e': ('US', '1', 'Maximum Frame Limit', ''),
                        '0019xx30': ('US', '1', 'Native Filter Type', ''),
                        '0019xx32': ('US', '1', 'Subtracted Filter Type', ''),
                        '0019xx34': ('US', '1', 'Filter Factor Native', ''),
                        '0019xx36': ('US',
                                     '1',
                                     'Anatomic Blackground Factor',
                                     ''),
                        '0019xx38': ('US',
                                     '1',
                                     'Window Upper Limit Native',
                                     ''),
                        '0019xx3a': ('US',
                                     '1',
                                     'Window Lower Limit Native',
                                     ''),
                        '0019xx3c': ('US',
                                     '1',
                                     'Window Brightness Phase 1 Sub',
                                     ''),
                        '0019xx3e': ('US',
                                     '1',
                                     'Window Brightness Phase 2 Sub',
                                     ''),
                        '0019xx40': ('US',
                                     '1',
                                     'Window Contrast Phase 1 Sub',
                                     ''),
                        '0019xx42': ('US',
                                     '1',
                                     'Window Contrast Phase 2 Sub',
                                     ''),
                        '0019xx44': ('US',
                                     '1',
                                     'Filter Factor Subtraction',
                                     ''),
                        '0019xx46': ('US', '1', 'Peak Opacified', ''),
                        '0019xx48': ('UL', '1', 'Mask Frame', ''),
                        '0019xx4a': ('UL', '1', 'BIH Frame', ''),
                        '0019xx4c': ('US',
                                     '1',
                                     'Center Beam Angulation CaudCran',
                                     ''),
                        '0019xx4e': ('US',
                                     '1',
                                     'Center Beam Angulation LR Anterior',
                                     ''),
                        '0019xx50': ('US', '1', 'Longitudinal Position', ''),
                        '0019xx52': ('US', '1', 'Side Offset', ''),
                        '0019xx54': ('US', '1', 'Isocenter Height', ''),
                        '0019xx56': ('US', '1', 'Image Twist', ''),
                        '0019xx58': ('US', '1', 'SourceImage Distance', ''),
                        '0019xx5a': ('US',
                                     '1',
                                     'Mechanical Magnet Factor',
                                     ''),
                        '0019xx5c': ('UL', '1', 'Calibration Flag', ''),
                        '0019xx5e': ('UL',
                                     '1',
                                     'Calibration Angle CranCaud',
                                     ''),
                        '0019xx60': ('UL',
                                     '1',
                                     'Calibration Angle RAOLAO',
                                     ''),
                        '0019xx62': ('UL',
                                     '1',
                                     'Calibration Table to Floor Distance',
                                     ''),
                        '0019xx64': ('UL',
                                     '1',
                                     'Calibration Isocenter to Floor Distance',
                                     ''),
                        '0019xx66': ('UL',
                                     '1',
                                     'Calibration Isocenter to Source Distance',
                                     ''),
                        '0019xx68': ('UL',
                                     '1',
                                     'Calibration Source to II Distance',
                                     ''),
                        '0019xx6a': ('UL', '1', 'Calibration II Zoom', ''),
                        '0019xx6c': ('UL', '1', 'Calibration II Field', ''),
                        '0019xx6e': ('UL', '1', 'Calibration Factor', ''),
                        '0019xx70': ('UL',
                                     '1',
                                     'Calibration Object to Image Distance',
                                     ''),
                        '0019xx72': ('UL',
                                     '1-n',
                                     'Calibration System Factor',
                                     ''),
                        '0019xx74': ('UL',
                                     '1-n',
                                     'Calibration System Correction',
                                     ''),
                        '0019xx76': ('UL',
                                     '1-n',
                                     'Calibration System II Formats',
                                     ''),
                        '0019xx78': ('UL',
                                     '1',
                                     'Calibration Gantry Data Valid',
                                     ''),
                        '0019xx7a': ('US',
                                     '1',
                                     'Collimator Square Breadth',
                                     ''),
                        '0019xx7c': ('US',
                                     '1',
                                     'Collimator Square Height',
                                     ''),
                        '0019xx7e': ('US',
                                     '1',
                                     'Collimator Square Diameter',
                                     ''),
                        '0019xx80': ('US',
                                     '1',
                                     'Collimator Finger Turn Angle',
                                     ''),
                        '0019xx82': ('US',
                                     '1',
                                     'Collimator Finger Position',
                                     ''),
                        '0019xx84': ('US',
                                     '1',
                                     'Collimator Diaphragm Turn Angle',
                                     ''),
                        '0019xx86': ('US',
                                     '1',
                                     'Collimator Diagphragm Position 1',
                                     ''),
                        '0019xx88': ('US',
                                     '1',
                                     'Collimator Diaphragm Position 2',
                                     ''),
                        '0019xx8a': ('US',
                                     '1',
                                     'Collimator Diaphragm Mode',
                                     ''),
                        '0019xx8c': ('US',
                                     '1',
                                     'Collimator Beam Limit Breadth',
                                     ''),
                        '0019xx8e': ('US',
                                     '1',
                                     'Collimator Beam Limit Height',
                                     ''),
                        '0019xx90': ('US',
                                     '1',
                                     'Collimator Beam Limit Diameter',
                                     ''),
                        '0019xx92': ('US', '1', 'XRay Control Mode', ''),
                        '0019xx94': ('US', '1', 'XRay System', ''),
                        '0019xx96': ('US', '1', 'Focal Spot', ''),
                        '0019xx98': ('US', '1', 'Exposure Control', ''),
                        '0019xx9a': ('US', '1', 'XRay Voltage', ''),
                        '0019xx9c': ('US', '1', 'XRay Current', ''),
                        '0019xx9e': ('UL',
                                     '1',
                                     'XRay Current Time Product',
                                     ''),
                        '0019xxa0': ('US', '1', 'Pulse Time', ''),
                        '0019xxa2': ('US',
                                     '1',
                                     'Scene Time Fluoro Clock',
                                     ''),
                        '0019xxa4': ('US', '1', 'Maximum PulseRate', ''),
                        '0019xxa6': ('US', '1', 'Pulses per Scene', ''),
                        '0019xxa8': ('UL',
                                     '1',
                                     'Dose Area Product of Scene',
                                     ''),
                        '0019xxaa': ('US', '1', 'Dose', ''),
                        '0019xxac': ('US', '1', 'Dose Rate', '')},
 'SIEMENS RA PLANE B': {'0019xx20': ('UL',
                                     '1',
                                     'System Calibration Factor Plane B',
                                     ''),
                        '0019xx22': ('US',
                                     '1',
                                     'XRay Parameter Set Number',
                                     ''),
                        '0019xx24': ('US', '1', 'XRay System', ''),
                        '0019xx26': ('US', '1', 'Unknown', ''),
                        '0019xx28': ('US', '1', 'Acquired Display Mode', ''),
                        '0019xx2a': ('US', '1', 'Unknown', ''),
                        '0019xx2c': ('US', '1', 'Acquisition Framerate', ''),
                        '0019xx2e': ('US', '1', 'Maximum Frame Limit', ''),
                        '0019xx30': ('US', '1', 'Native Filter Type', ''),
                        '0019xx32': ('US', '1', 'Subtracted Filter Type', ''),
                        '0019xx34': ('US', '1', 'Filter Factor Native', ''),
                        '0019xx36': ('US',
                                     '1',
                                     'Anatomic Blackground Factor',
                                     ''),
                        '0019xx38': ('US',
                                     '1',
                                     'Window Upper Limit Native',
                                     ''),
                        '0019xx3a': ('US',
                                     '1',
                                     'Window Lower Limit Native',
                                     ''),
                        '0019xx3c': ('US',
                                     '1',
                                     'Window Brightness Phase 1 Sub',
                                     ''),
                        '0019xx3e': ('US',
                                     '1',
                                     'Window Brightness Phase 2 Sub',
                                     ''),
                        '0019xx40': ('US',
                                     '1',
                                     'Window Contrast Phase 1 Sub',
                                     ''),
                        '0019xx42': ('US',
                                     '1',
                                     'Window Contrast Phase 2 Sub',
                                     ''),
                        '0019xx44': ('US',
                                     '1',
                                     'Filter Factor Subtraction',
                                     ''),
                        '0019xx46': ('US', '1', 'Peak Opacified', ''),
                        '0019xx48': ('UL', '1', 'Mask Frame', ''),
                        '0019xx4a': ('UL', '1', 'BIH Frame', ''),
                        '0019xx4c': ('US',
                                     '1',
                                     'Center Beam Angulation CaudCran',
                                     ''),
                        '0019xx4e': ('US',
                                     '1',
                                     'Center Beam Angulation LR Anterior',
                                     ''),
                        '0019xx50': ('US', '1', 'Longitudinal Position', ''),
                        '0019xx52': ('US', '1', 'Side Offset', ''),
                        '0019xx54': ('US', '1', 'Isocenter Height', ''),
                        '0019xx56': ('US', '1', 'Image Twist', ''),
                        '0019xx58': ('US', '1', 'SourceImage Distance', ''),
                        '0019xx5a': ('US',
                                     '1',
                                     'Mechanical Magnet Factor',
                                     ''),
                        '0019xx5c': ('UL', '1', 'Calibration Flag', ''),
                        '0019xx5e': ('UL',
                                     '1',
                                     'Calibration Angle CranCaud',
                                     ''),
                        '0019xx60': ('UL',
                                     '1',
                                     'Calibration Angle RAOLAO',
                                     ''),
                        '0019xx62': ('UL',
                                     '1',
                                     'Calibration Table to Floor Distance',
                                     ''),
                        '0019xx64': ('UL',
                                     '1',
                                     'Calibration Isocenter to Floor Distance',
                                     ''),
                        '0019xx66': ('UL',
                                     '1',
                                     'Calibration Isocenter to Source Distance',
                                     ''),
                        '0019xx68': ('UL',
                                     '1',
                                     'Calibration Source to II Distance',
                                     ''),
                        '0019xx6a': ('UL', '1', 'Calibration II Zoom', ''),
                        '0019xx6c': ('UL', '1', 'Calibration II Field', ''),
                        '0019xx6e': ('UL', '1', 'Calibration Factor', ''),
                        '0019xx70': ('UL',
                                     '1',
                                     'Calibration Object to Image Distance',
                                     ''),
                        '0019xx72': ('UL',
                                     '1-n',
                                     'Calibration System Factor',
                                     ''),
                        '0019xx74': ('UL',
                                     '1-n',
                                     'Calibration System Correction',
                                     ''),
                        '0019xx76': ('UL',
                                     '1-n',
                                     'Calibration System II Formats',
                                     ''),
                        '0019xx78': ('UL',
                                     '1',
                                     'Calibration Gantry Data Valid',
                                     ''),
                        '0019xx7a': ('US',
                                     '1',
                                     'Collimator Square Breadth',
                                     ''),
                        '0019xx7c': ('US',
                                     '1',
                                     'Collimator Square Height',
                                     ''),
                        '0019xx7e': ('US',
                                     '1',
                                     'Collimator Square Diameter',
                                     ''),
                        '0019xx80': ('US',
                                     '1',
                                     'Collimator Finger Turn Angle',
                                     ''),
                        '0019xx82': ('US',
                                     '1',
                                     'Collimator Finger Position',
                                     ''),
                        '0019xx84': ('US',
                                     '1',
                                     'Collimator Diaphragm Turn Angle',
                                     ''),
                        '0019xx86': ('US',
                                     '1',
                                     'Collimator Diagphragm Position 1',
                                     ''),
                        '0019xx88': ('US',
                                     '1',
                                     'Collimator Diaphragm Position 2',
                                     ''),
                        '0019xx8a': ('US',
                                     '1',
                                     'Collimator Diaphragm Mode',
                                     ''),
                        '0019xx8c': ('US',
                                     '1',
                                     'Collimator Beam Limit Breadth',
                                     ''),
                        '0019xx8e': ('US',
                                     '1',
                                     'Collimator Beam Limit Height',
                                     ''),
                        '0019xx90': ('US',
                                     '1',
                                     'Collimator Beam Limit Diameter',
                                     ''),
                        '0019xx92': ('US', '1', 'XRay Control Mode', ''),
                        '0019xx94': ('US', '1', 'XRay System', ''),
                        '0019xx96': ('US', '1', 'Focal Spot', ''),
                        '0019xx98': ('US', '1', 'Exposure Control', ''),
                        '0019xx9a': ('US', '1', 'XRay Voltage', ''),
                        '0019xx9c': ('US', '1', 'XRay Current', ''),
                        '0019xx9e': ('UL',
                                     '1',
                                     'XRay Current Time Product',
                                     ''),
                        '0019xxa0': ('US', '1', 'Pulse Time', ''),
                        '0019xxa2': ('US',
                                     '1',
                                     'Scene Time Fluoro Clock',
                                     ''),
                        '0019xxa4': ('US', '1', 'Maximum PulseRate', ''),
                        '0019xxa6': ('US', '1', 'Pulses per Scene', ''),
                        '0019xxa8': ('UL',
                                     '1',
                                     'Dose Area Product of Scene',
                                     ''),
                        '0019xxaa': ('US', '1', 'Dose', ''),
                        '0019xxac': ('US', '1', 'Dose Rate', '')},
 'SIEMENS RIS': {'0011xx10': ('LO', '1', 'Patient UID', ''),
                 '0011xx11': ('LO', '1', 'Patient ID', ''),
                 '0011xx20': ('DA', '1', 'Patient Registration Date', ''),
                 '0011xx21': ('TM', '1', 'Patient Registration Time', ''),
                 '0011xx30': ('PN', '1', 'Patient NameRIS', ''),
                 '0011xx31': ('PN', '1', 'Patient Prename', ''),
                 '0011xx40': ('LO', '1', 'Patient Hospital Status', ''),
                 '0011xx41': ('LO', '1', 'Medical Alerts', ''),
                 '0011xx42': ('LO', '1', 'Contrast Allergy', ''),
                 '0031xx10': ('LO', '1', 'Request UID', ''),
                 '0031xx45': ('LO', '1', 'Requesting Physician', ''),
                 '0031xx50': ('LO', '1', 'Requested Physician', ''),
                 '0033xx10': ('LO', '1', 'Patient Study UID', '')},
 'SIEMENS SIENET': {'0019xx01': ('DS', '1', 'Unknown', '')},
 'SIEMENS SMS-AX  ACQ 1.0': {'0021xx00': ('US', '1', 'Acquisition Type', ''),
                             '0021xx01': ('US', '1', 'Acquisition Mode', ''),
                             '0021xx02': ('US', '1', 'Footswitch Index', ''),
                             '0021xx03': ('US', '1', 'Acquisition Room', ''),
                             '0021xx04': ('SL',
                                          '1',
                                          'Current Time Product',
                                          ''),
                             '0021xx05': ('SL', '1', 'Dose', ''),
                             '0021xx06': ('SL', '1', 'Skin Dose Percent', ''),
                             '0021xx07': ('SL',
                                          '1',
                                          'Skin Dose Accumulation',
                                          ''),
                             '0021xx08': ('SL', '1', 'Skin Dose Rate', ''),
                             '0021xx09': ('UL', '1', 'Impac Filename', ''),
                             '0021xx0a': ('UL', '1', 'Copper Filter', ''),
                             '0021xx0b': ('US', '1', 'Measuring Field', ''),
                             '0021xx0c': ('SS',
                                          '3',
                                          'Post Blanking Circle',
                                          ''),
                             '0021xx0d': ('SS', '2-2n', 'Dyna Angles', ''),
                             '0021xx0e': ('SS', '1', 'Total Steps', ''),
                             '0021xx0f': ('SL',
                                          '3-3n',
                                          'Dyna X-Ray Info',
                                          ''),
                             '0021xx10': ('US',
                                          '1',
                                          'Modality LUT Input Gamma',
                                          ''),
                             '0021xx11': ('US',
                                          '1',
                                          'Modality LUT Output Gamma',
                                          ''),
                             '0021xx12': ('OB', '1-n', 'SH_STPAR', ''),
                             '0021xx13': ('US', '1', 'Acquisition Zoom', ''),
                             '0021xx14': ('SS',
                                          '1',
                                          'Dyna Angulation Step Width',
                                          ''),
                             '0021xx15': ('US', '1', 'Harmonization', ''),
                             '0021xx16': ('US', '1', 'DR Single Flag', ''),
                             '0021xx17': ('SL',
                                          '1',
                                          'Source to Isocenter',
                                          ''),
                             '0021xx18': ('US', '1', 'Pressure Data', ''),
                             '0021xx19': ('SL', '1', 'ECG Index Array', ''),
                             '0021xx1a': ('US', '1', 'FD Flag', ''),
                             '0021xx1b': ('OB', '1', 'SH_ZOOM', ''),
                             '0021xx1c': ('OB', '1', 'SH_COLPAR', ''),
                             '0021xx1d': ('US', '1', 'K-Factor', ''),
                             '0021xx1e': ('US', '8', 'EVE', ''),
                             '0021xx1f': ('SL', '1', 'Total Scene Time', ''),
                             '0021xx20': ('US', '1', 'Restore Flag', ''),
                             '0021xx21': ('US',
                                          '1',
                                          'Stand Movement Flag',
                                          ''),
                             '0021xx22': ('US', '1', 'FD Rows', ''),
                             '0021xx23': ('US', '1', 'FD Columns', ''),
                             '0021xx24': ('US',
                                          '1',
                                          'Table Movement Flag',
                                          ''),
                             '0021xx25': ('LO',
                                          '1',
                                          'Original Organ Program Name',
                                          ''),
                             '0021xx26': ('DS', '1', 'Crispy XPI Filter', ''),
                             '0021xx28': ('SQ', '1', 'Unknown', ''),
                             '0021xx30': ('OB', '1', 'Unknown', ''),
                             '0021xx40': ('US', '3', 'Unknown', ''),
                             '0021xx41': ('LO', '1', 'Unknown', ''),
                             '0021xx42': ('US', '1-n', 'Unknown', ''),
                             '0021xx57': ('SS', '1-3', 'Unknown', ''),
                             '0021xx58': ('DS', '1', 'Unknown', ''),
                             '0021xx71': ('DS', '1', 'Unknown', '')},
 'SIEMENS SMS-AX  ORIGINAL IMAGE INFO 1.0': {'0025xx00': ('US',
                                                          '1',
                                                          'View Native',
                                                          ''),
                                             '0025xx01': ('US',
                                                          '1',
                                                          'Original Series Number',
                                                          ''),
                                             '0025xx02': ('US',
                                                          '1',
                                                          'Original Image Number',
                                                          ''),
                                             '0025xx03': ('US',
                                                          '1',
                                                          'Win Center',
                                                          ''),
                                             '0025xx04': ('US',
                                                          '1',
                                                          'Win Width',
                                                          ''),
                                             '0025xx05': ('US',
                                                          '1',
                                                          'Win Brightness',
                                                          ''),
                                             '0025xx06': ('US',
                                                          '1',
                                                          'Win Contrast',
                                                          ''),
                                             '0025xx07': ('US',
                                                          '1',
                                                          'Original Frame Number',
                                                          ''),
                                             '0025xx08': ('US',
                                                          '1',
                                                          'Original Mask Frame Number',
                                                          ''),
                                             '0025xx09': ('US',
                                                          '1',
                                                          'Opac',
                                                          ''),
                                             '0025xx0a': ('US',
                                                          '1',
                                                          'Original Number of Frames',
                                                          ''),
                                             '0025xx0b': ('DS',
                                                          '1',
                                                          'Original Scene Duration',
                                                          ''),
                                             '0025xx0c': ('LO',
                                                          '1',
                                                          'Identifier LOID',
                                                          ''),
                                             '0025xx0d': ('SS',
                                                          '1-n',
                                                          'Original Scene VFR Info',
                                                          ''),
                                             '0025xx0e': ('SS',
                                                          '1',
                                                          'Original Frame ECG Position',
                                                          ''),
                                             '0025xx0f': ('SS',
                                                          '1',
                                                          'Original ECG 1st Frame Offset (retired)',
                                                          ''),
                                             '0025xx10': ('SS',
                                                          '1',
                                                          'Zoom Flag',
                                                          ''),
                                             '0025xx11': ('US',
                                                          '1',
                                                          'Flex',
                                                          ''),
                                             '0025xx12': ('US',
                                                          '1',
                                                          'Number of Mask Frames',
                                                          ''),
                                             '0025xx13': ('US',
                                                          '1',
                                                          'Number of Fill Frames',
                                                          ''),
                                             '0025xx14': ('IS',
                                                          '1',
                                                          'Series Number',
                                                          ''),
                                             '0025xx15': ('IS',
                                                          '1',
                                                          'Image Number',
                                                          ''),
                                             '0025xx16': ('IS',
                                                          '1',
                                                          'Unknown',
                                                          '')},
 'SIEMENS SMS-AX  QUANT 1.0': {'0023xx00': ('DS',
                                            '2',
                                            'Horizontal Calibration Pixel Size',
                                            ''),
                               '0023xx01': ('DS',
                                            '2',
                                            'Vertical Calibration Pixel Size',
                                            ''),
                               '0023xx02': ('LO',
                                            '1',
                                            'Calibration Object',
                                            ''),
                               '0023xx03': ('DS',
                                            '1',
                                            'Calibration Object Size',
                                            ''),
                               '0023xx04': ('LO',
                                            '1',
                                            'Calibration Method',
                                            ''),
                               '0023xx05': ('ST', '1', 'Filename', ''),
                               '0023xx06': ('IS', '1', 'Frame Number', ''),
                               '0023xx07': ('IS',
                                            '2',
                                            'Calibration Factor Multiplicity',
                                            ''),
                               '0023xx08': ('IS',
                                            '1',
                                            'Calibration TOD Value',
                                            '')},
 'SIEMENS SMS-AX  VIEW 1.0': {'0019xx00': ('US', '1', 'Review Mode', ''),
                              '0019xx01': ('US',
                                           '1',
                                           'Anatomical Background Percent',
                                           ''),
                              '0019xx02': ('US', '1', 'Number of Phases', ''),
                              '0019xx03': ('US',
                                           '1',
                                           'Apply Anatomical Background',
                                           ''),
                              '0019xx04': ('SS',
                                           '4-4n',
                                           'Pixel Shift Array',
                                           ''),
                              '0019xx05': ('US', '1', 'Brightness', ''),
                              '0019xx06': ('US', '1', 'Contrast', ''),
                              '0019xx07': ('US', '1', 'Enabled', ''),
                              '0019xx08': ('US',
                                           '1',
                                           'Native Edge Enh. Percent Gain',
                                           ''),
                              '0019xx09': ('SS',
                                           '1',
                                           'Native Edge Enh. LUT Index',
                                           ''),
                              '0019xx0a': ('SS',
                                           '1',
                                           'Native Edge Enh. Kernel Size',
                                           ''),
                              '0019xx0b': ('US',
                                           '1',
                                           'Subtr. Edge Enh. Percent Gain',
                                           ''),
                              '0019xx0c': ('SS',
                                           '1',
                                           'Subtr. Edge Enh. LUT Index',
                                           ''),
                              '0019xx0d': ('SS',
                                           '1',
                                           'Subtr. Edge Enh. Kernel Size',
                                           ''),
                              '0019xx0e': ('US', '1', 'Fade Percent', ''),
                              '0019xx0f': ('US',
                                           '1',
                                           'Flipped Before Laterality Applied',
                                           ''),
                              '0019xx10': ('US', '1', 'Apply Fade', ''),
                              '0019xx11': ('US', '1', 'RefImages Taken', ''),
                              '0019xx12': ('US', '1', 'Zoom', ''),
                              '0019xx13': ('SS', '1', 'Pan X', ''),
                              '0019xx14': ('SS', '1', 'Pan Y', ''),
                              '0019xx15': ('SS',
                                           '1',
                                           'Native Edge Enh. Adv Perc. Gain',
                                           ''),
                              '0019xx16': ('SS',
                                           '1',
                                           'Subtr. Edge Enh. Adv Perc. Gain',
                                           ''),
                              '0019xx17': ('US', '1', 'Invert Flag', ''),
                              '0019xx1a': ('OB', '1', 'Quant 1K Overlay', ''),
                              '0019xx1b': ('US',
                                           '1',
                                           'Original Resolution',
                                           ''),
                              '0019xx1c': ('DS',
                                           '1',
                                           'Auto Window Center',
                                           ''),
                              '0019xx1d': ('DS',
                                           '1',
                                           'Auto Window Width',
                                           '')},
 'SIEMENS Selma': {'0019xx06': ('IS', '1', 'Unknown', ''),
                   '0019xx07': ('IS', '1', 'Unknown', ''),
                   '0019xx08': ('IS', '1', 'Unknown', ''),
                   '0019xx26': ('LO', '1', 'Unknown', ''),
                   '0019xx29': ('LO', '1', 'Unknown', ''),
                   '0019xx30': ('US', '1', 'Unknown', ''),
                   '0019xx31': ('US', '1', 'Unknown', ''),
                   '0019xx32': ('US', '1', 'Unknown', ''),
                   '0019xx33': ('US', '1', 'Unknown', ''),
                   '0019xx34': ('US', '1', 'Unknown', ''),
                   '0019xx35': ('US', '1', 'Unknown', '')},
 'SIEMENS WH SR 1.0': {'0071xx01': ('LO', '1', 'Unknown', ''),
                       '0071xx02': ('LO', '1', 'Unknown', '')},
 'SIEMENS_FLCOMPACT_VA01A_PROC': {'0017xx0a': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx0b': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx0c': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx0d': ('FL',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx0e': ('LO',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx0f': ('LO',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx14': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx16': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx17': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx18': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx19': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx1a': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx1b': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx1c': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx1e': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx1f': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx20': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx21': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx22': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx23': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx24': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx25': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx26': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx27': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx28': ('FL',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx29': ('FL',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx48': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx49': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx4a': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx4b': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx4c': ('LO',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx4d': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx4e': ('LO',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx4f': ('LO',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx50': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx51': ('FL',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx52': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx53': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx54': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx55': ('SS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx5a': ('OW',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx5b': ('OW',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx5c': ('OW',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx64': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx66': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx67': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx68': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx85': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx86': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx87': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx88': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx89': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx8a': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx8b': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx8c': ('FL',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx8d': ('FL',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx8e': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xx8f': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxa0': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxa1': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxa2': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxa3': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxa4': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxa5': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxa6': ('US',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxb0': ('DS',
                                               '1',
                                               'Internal Data',
                                               ''),
                                  '0017xxc0': ('LO',
                                               '1',
                                               'Internal Data',
                                               '')},
 'SIENET': {'0009xx01': ('US', '1', 'SIENET Command Field', ''),
            '0009xx14': ('LO', '1', 'Receiver PLA', ''),
            '0009xx16': ('US', '1', 'Transfer Priority', ''),
            '0009xx29': ('LO', '1', 'Actual User', ''),
            '0009xx70': ('DS', '1', 'Unknown', ''),
            '0009xx71': ('DS', '1', 'Unknown', ''),
            '0009xx72': ('LO', '1', 'Unknown', ''),
            '0009xx73': ('LO', '1', 'Unknown', ''),
            '0009xx74': ('LO', '1', 'Unknown', ''),
            '0009xx75': ('LO', '1', 'Unknown', ''),
            '0091xx20': ('PN', '1-n', 'Patient Name', ''),
            '0095xx01': ('LO', '1', 'Examination Folder ID', ''),
            '0095xx04': ('UL', '1', 'Folder Reported Status', ''),
            '0095xx05': ('LO', '1', 'Folder Reporting Radiologist', ''),
            '0095xx07': ('LO', '1', 'SIENET ISA PLA', ''),
            '0095xx0c': ('UL', '1', 'Folder Rebuild Status', ''),
            '0095xx20': ('UN', '1', 'Unknown', ''),
            '0099xx02': ('UL', '1', 'Key Images', ''),
            '0099xx05': ('SL', '1', 'Image Number', '')},
 'SPI': {'0009xx10': ('LO', '1', 'Comments', ''),
         '0009xx15': ('LO', '1', 'Unique Identifier', ''),
         '0009xx40': ('US', '1', 'Data Object Type', ''),
         '0009xx41': ('SH', '1', 'Data Object Subtype', ''),
         '0011xx10': ('LO', '1', 'Organ', ''),
         '0011xx15': ('LO', '1', 'Allergy Indication', ''),
         '0011xx20': ('CS', '1', 'Pregnancy', ''),
         '0029xx60': ('LO', '1', 'Compression Algorithm', '')},
 'SPI RELEASE 1': {'0009xx10': ('LO', '1', 'Comments', ''),
                   '0009xx15': ('LO', '1', 'Unique Identifier', ''),
                   '0009xx40': ('US', '1', 'Data Object Type', ''),
                   '0009xx41': ('SH', '1', 'Data Object Subtype', ''),
                   '0011xx10': ('LO', '1', 'Organ', ''),
                   '0011xx15': ('LO', '1', 'Allergy Indication', ''),
                   '0011xx20': ('CS', '1', 'Pregnancy', ''),
                   '0029xx60': ('LO', '1', 'Compression Algorithm', '')},
 'SPI Release 1': {'0009xx08': ('CS', '1', 'Unknown', ''),
                   '0009xx10': ('LO', '1', 'Comments', ''),
                   '0009xx15': ('LO', '1', 'UID', ''),
                   '0009xx40': ('US', '1', 'Data Object Type', ''),
                   '0009xx41': ('SH', '1', 'Data Object Subtype', ''),
                   '0011xx10': ('LO', '1', 'Organ', ''),
                   '0011xx15': ('LO', '1', 'Allergy Indication', ''),
                   '0011xx20': ('LO', '1', 'Pregnancy', ''),
                   '0029xx60': ('LO', '1', 'Compression Algorithm', '')},
 'SPI-P Release 1': {'0009xx00': ('LT',
                                  '1',
                                  'Data Object Recognition Code',
                                  ''),
                     '0009xx04': ('LO', '1-n', 'Image Data Consistency', ''),
                     '0009xx08': ('US', '1', 'Unknown', ''),
                     '0009xx12': ('LO', '1', 'Unknown', ''),
                     '0009xx15': ('LO', '1', 'Unique Identifier', ''),
                     '0009xx16': ('LO', '1', 'Unknown', ''),
                     '0009xx18': ('LO', '1', 'Unknown', ''),
                     '0009xx21': ('LT', '1', 'Unknown', ''),
                     '0009xx31': ('LT', '1', 'PACS Unique Identifier', ''),
                     '0009xx34': ('LT', '1', 'Cluster Unique Identifier', ''),
                     '0009xx38': ('LT', '1', 'System Unique Identifier', ''),
                     '0009xx39': ('LT', '1', 'Unknown', ''),
                     '0009xx51': ('LT', '1', 'Study Unique Identifier', ''),
                     '0009xx61': ('LT', '1', 'Series Unique Identifier', ''),
                     '0009xx91': ('LT', '1', 'Unknown', ''),
                     '0009xxa0': ('UN', '1', 'Unknown', ''),
                     '0009xxf2': ('LT', '1', 'Unknown', ''),
                     '0009xxf3': ('UN', '1', 'Unknown', ''),
                     '0009xxf4': ('LT', '1', 'Unknown', ''),
                     '0009xxf5': ('UN', '1', 'Unknown', ''),
                     '0009xxf7': ('LT', '1', 'Unknown', ''),
                     '0011xx10': ('LT', '1', 'Patient Entry ID', ''),
                     '0011xx20': ('UN', '1', 'Unknown', ''),
                     '0011xx21': ('UN', '1', 'Unknown', ''),
                     '0011xx22': ('UN', '1', 'Unknown', ''),
                     '0011xx30': ('UN', '1', 'Unknown', ''),
                     '0011xx31': ('UN', '1', 'Unknown', ''),
                     '0011xx32': ('UN', '1', 'Unknown', ''),
                     '0019xx00': ('LO', '1', 'Unknown', ''),
                     '0019xx01': ('LO', '1', 'Unknown', ''),
                     '0019xx02': ('UN', '1', 'Unknown', ''),
                     '0019xx10': ('US', '1', 'Mains Frequency', ''),
                     '0019xx25': ('LO',
                                  '1-n',
                                  'Original Pixel Data Quality',
                                  ''),
                     '0019xx30': ('US', '1', 'ECG Triggering', ''),
                     '0019xx31': ('UN', '1', 'ECG 1 Offset', ''),
                     '0019xx32': ('UN', '1', 'ECG 2 Offset 1', ''),
                     '0019xx33': ('UN', '1', 'ECG 2 Offset 2', ''),
                     '0019xx50': ('US', '1', 'Video Scan Mode', ''),
                     '0019xx51': ('US', '1', 'Video LineRate', ''),
                     '0019xx60': ('US', '1', 'Xray Technique', ''),
                     '0019xx61': ('DS', '1', 'Image Identifier Fromat', ''),
                     '0019xx62': ('US', '1', 'Iris Diaphragm', ''),
                     '0019xx63': ('CS', '1', 'Filter', ''),
                     '0019xx64': ('CS', '1', 'Cine Parallel', ''),
                     '0019xx65': ('CS', '1', 'Cine Master', ''),
                     '0019xx70': ('US', '1', 'Exposure Channel', ''),
                     '0019xx71': ('UN',
                                  '1',
                                  'Exposure Channel First Image',
                                  ''),
                     '0019xx72': ('US', '1', 'Processing Channel', ''),
                     '0019xx80': ('DS', '1', 'Acquisition Delay', ''),
                     '0019xx81': ('UN', '1', 'Relative Image Time', ''),
                     '0019xx90': ('CS', '1', 'Video White Compression', ''),
                     '0019xxa0': ('US', '1', 'Angulation', ''),
                     '0019xxa1': ('US', '1', 'Rotation', ''),
                     '0021xx12': ('LT', '1', 'Series Unique Identifier', ''),
                     '0021xx14': ('LT', '1', 'Unknown', ''),
                     '0029xx00': ('DS', '4', 'Unknown', ''),
                     '0029xx20': ('DS', '1', 'Pixel Aspect Ratio', ''),
                     '0029xx25': ('LO',
                                  '1-n',
                                  'Processed Pixel Data Quality',
                                  ''),
                     '0029xx30': ('LT', '1', 'Unknown', ''),
                     '0029xx38': ('US', '1', 'Unknown', ''),
                     '0029xx60': ('LT', '1', 'Unknown', ''),
                     '0029xx61': ('LT', '1', 'Unknown', ''),
                     '0029xx67': ('LT', '1', 'Unknown', ''),
                     '0029xx70': ('LT', '1', 'Window ID', ''),
                     '0029xx71': ('CS', '1', 'Video Invert Subtracted', ''),
                     '0029xx72': ('CS',
                                  '1',
                                  'Video Invert Nonsubtracted',
                                  ''),
                     '0029xx77': ('CS', '1', 'Window Select Status', ''),
                     '0029xx78': ('LT', '1', 'ECG Display Printing ID', ''),
                     '0029xx79': ('CS', '1', 'ECG Display Printing', ''),
                     '0029xx7e': ('CS',
                                  '1',
                                  'ECG Display Printing Enable Status',
                                  ''),
                     '0029xx7f': ('CS',
                                  '1',
                                  'ECG Display Printing Select Status',
                                  ''),
                     '0029xx80': ('LT', '1', 'Physiological Display ID', ''),
                     '0029xx81': ('US',
                                  '1',
                                  'Preferred Physiological Channel Display',
                                  ''),
                     '0029xx8e': ('CS',
                                  '1',
                                  'Physiological Display Enable Status',
                                  ''),
                     '0029xx8f': ('CS',
                                  '1',
                                  'Physiological Display Select Status',
                                  ''),
                     '0029xx90': ('DS', '1-n', 'Unknown', ''),
                     '0029xx91': ('US', '1', 'Unknown', ''),
                     '0029xx9f': ('CS', '1', 'Unknown', ''),
                     '0029xxa0': ('DS', '1-n', 'Unknown', ''),
                     '0029xxa1': ('US', '1', 'Unknown', ''),
                     '0029xxaf': ('CS', '1', 'Unknown', ''),
                     '0029xxb0': ('DS', '1-n', 'Unknown', ''),
                     '0029xxb1': ('US', '1', 'Unknown', ''),
                     '0029xxbf': ('CS', '1', 'Unknown', ''),
                     '0029xxc0': ('LT', '1', 'Functional Shutter ID', ''),
                     '0029xxc1': ('US', '1', 'Field Of Shutter', ''),
                     '0029xxc5': ('LT',
                                  '1',
                                  'Field Of Shutter Rectangle',
                                  ''),
                     '0029xxce': ('CS', '1', 'Shutter Enable Status', ''),
                     '0029xxcf': ('CS', '1', 'Shutter Select Status', ''),
                     '7fe1xx10': ('UN', '1', 'Pixel Data', '')},
 'SPI-P Release 1;1': {'0009xxc0': ('LT', '1', 'Unknown', ''),
                       '0009xxc1': ('LT', '1', 'Unknown', ''),
                       '0019xx00': ('UN', '1', 'Physiological Data Type', ''),
                       '0019xx01': ('UN',
                                    '1',
                                    'Physiological Data Channel And Kind',
                                    ''),
                       '0019xx02': ('US', '1', 'Sample Bits Allocated', ''),
                       '0019xx03': ('US', '1', 'Sample Bits Stored', ''),
                       '0019xx04': ('US', '1', 'Sample High Bit', ''),
                       '0019xx05': ('US', '1', 'Sample Representation', ''),
                       '0019xx06': ('UN', '1', 'Smallest Sample Value', ''),
                       '0019xx07': ('UN', '1', 'Largest Sample Value', ''),
                       '0019xx08': ('UN', '1', 'Number Of Samples', ''),
                       '0019xx09': ('UN', '1', 'Sample Data', ''),
                       '0019xx0a': ('UN', '1', 'Sample Rate', ''),
                       '0019xx10': ('UN',
                                    '1',
                                    'Physiological Data Type 2',
                                    ''),
                       '0019xx11': ('UN',
                                    '1',
                                    'Physiological Data Channel And Kind 2',
                                    ''),
                       '0019xx12': ('US', '1', 'Sample Bits Allocated 2', ''),
                       '0019xx13': ('US', '1', 'Sample Bits Stored 2', ''),
                       '0019xx14': ('US', '1', 'Sample High Bit 2', ''),
                       '0019xx15': ('US', '1', 'Sample Representation 2', ''),
                       '0019xx16': ('UN', '1', 'Smallest Sample Value 2', ''),
                       '0019xx17': ('UN', '1', 'Largest Sample Value 2', ''),
                       '0019xx18': ('UN', '1', 'Number Of Samples 2', ''),
                       '0019xx19': ('UN', '1', 'Sample Data 2', ''),
                       '0019xx1a': ('UN', '1', 'Sample Rate 2', ''),
                       '0029xx00': ('LT', '1', 'Zoom ID', ''),
                       '0029xx01': ('DS', '1-n', 'Zoom Rectangle', ''),
                       '0029xx03': ('DS', '1', 'Zoom Factor', ''),
                       '0029xx04': ('US', '1', 'Zoom Function', ''),
                       '0029xx0e': ('CS', '1', 'Zoom Enable Status', ''),
                       '0029xx0f': ('CS', '1', 'Zoom Select Status', ''),
                       '0029xx40': ('LT', '1', 'Magnifying Glass ID', ''),
                       '0029xx41': ('DS',
                                    '1-n',
                                    'Magnifying Glass Rectangle',
                                    ''),
                       '0029xx43': ('DS', '1', 'Magnifying Glass Factor', ''),
                       '0029xx44': ('US',
                                    '1',
                                    'Magnifying Glass Function',
                                    ''),
                       '0029xx4e': ('CS',
                                    '1',
                                    'Magnifying Glass Enable Status',
                                    ''),
                       '0029xx4f': ('CS',
                                    '1',
                                    'Magnifying Glass Select Status',
                                    '')},
 'SPI-P Release 1;2': {'0029xx00': ('LT', '1', 'Subtraction Mask ID', ''),
                       '0029xx04': ('UN', '1', 'Masking Function', ''),
                       '0029xx0c': ('UN',
                                    '1',
                                    'Proprietary Masking Parameters',
                                    ''),
                       '0029xx1e': ('CS',
                                    '1',
                                    'Subtraction Mask Enable Status',
                                    ''),
                       '0029xx1f': ('CS',
                                    '1',
                                    'Subtraction Mask Select Status',
                                    '')},
 'SPI-P Release 1;3': {'0029xx00': ('LT', '1', 'Image Enhancement ID', ''),
                       '0029xx01': ('LT', '1', 'Image Enhancement', ''),
                       '0029xx02': ('LT', '1', 'Convolution ID', ''),
                       '0029xx03': ('LT', '1', 'Convolution Type', ''),
                       '0029xx04': ('LT',
                                    '1',
                                    'Convolution Kernel Size ID',
                                    ''),
                       '0029xx05': ('US', '2', 'Convolution Kernel Size', ''),
                       '0029xx06': ('US', '1-n', 'Convolution Kernel', ''),
                       '0029xx0c': ('DS', '1', 'Enhancement Gain', ''),
                       '0029xx1e': ('CS',
                                    '1',
                                    'Image Enhancement Enable Status',
                                    ''),
                       '0029xx1f': ('CS',
                                    '1',
                                    'Image Enhancement Select Status',
                                    '')},
 'SPI-P Release 2;1': {'0011xx18': ('LT', '1', 'Unknown', ''),
                       '0023xx0d': ('UI', '1', 'Unknown', ''),
                       '0023xx0e': ('UI', '1', 'Unknown', '')},
 'SPI-P-CTBE Release 1': {'0019xx00': ('IS', '1', 'Unknown', ''),
                          '0019xx02': ('IS', '1', 'Unknown', ''),
                          '0019xx03': ('DS', '1', 'Unknown', ''),
                          '0019xx04': ('IS', '1', 'Unknown', ''),
                          '0019xx05': ('DS', '1', 'Unknown', ''),
                          '0019xx0b': ('DS', '1', 'Unknown', ''),
                          '0019xx0c': ('IS', '1', 'Unknown', ''),
                          '0019xx14': ('IS', '1', 'Unknown', ''),
                          '0019xx18': ('IS', '1', 'Unknown', ''),
                          '0019xx19': ('IS', '1', 'Unknown', ''),
                          '0019xx1a': ('DS', '1', 'Unknown', ''),
                          '0019xx1b': ('IS', '1', 'Unknown', ''),
                          '0019xx1c': ('IS', '1', 'Unknown', ''),
                          '0019xx1d': ('DS', '1', 'Unknown', '')},
 'SPI-P-CTBE-Private Release 1': {'0021xx00': ('DS', '1', 'Unknown', '')},
 'SPI-P-GV-CT Release 1': {'0009xx00': ('LO', '1', 'Unknown', ''),
                           '0009xx10': ('LO', '1', 'Unknown', ''),
                           '0009xx20': ('LO', '1', 'Unknown', ''),
                           '0009xx30': ('LO', '1', 'Unknown', ''),
                           '0009xx40': ('LO', '1', 'Unknown', ''),
                           '0009xx50': ('LO', '1', 'Unknown', ''),
                           '0009xx60': ('LO', '1', 'Unknown', ''),
                           '0009xx70': ('LO', '1', 'Unknown', ''),
                           '0009xx75': ('LO', '1', 'Unknown', ''),
                           '0009xx80': ('LO', '1', 'Unknown', ''),
                           '0009xx90': ('LO', '1', 'Unknown', ''),
                           '0019xx08': ('IS', '1', 'Unknown', ''),
                           '0019xx09': ('IS', '1', 'Unknown', ''),
                           '0019xx0a': ('IS', '1', 'Unknown', ''),
                           '0019xx10': ('LO', '1', 'Unknown', ''),
                           '0019xx20': ('TM', '1', 'Unknown', ''),
                           '0019xx50': ('LO', '1', 'Unknown', ''),
                           '0019xx60': ('DS', '1', 'Unknown', ''),
                           '0019xx61': ('US', '1', 'Unknown', ''),
                           '0019xx63': ('LO', '1', 'Unknown', ''),
                           '0019xx64': ('US', '1', 'Unknown', ''),
                           '0019xx65': ('IS', '1', 'Unknown', ''),
                           '0019xx70': ('LT', '1', 'Unknown', ''),
                           '0019xx80': ('LO', '1', 'Unknown', ''),
                           '0019xx81': ('LO', '1', 'Unknown', ''),
                           '0019xx90': ('LO', '1', 'Unknown', ''),
                           '0019xxa0': ('LO', '1', 'Unknown', ''),
                           '0019xxa1': ('US', '1', 'Unknown', ''),
                           '0019xxa2': ('US', '1', 'Unknown', ''),
                           '0019xxa3': ('US', '1', 'Unknown', ''),
                           '0019xxb0': ('LO', '1', 'Unknown', ''),
                           '0019xxb1': ('LO', '1', 'Unknown', ''),
                           '0021xx20': ('LO', '1', 'Unknown', ''),
                           '0021xx30': ('DS', '1', 'Unknown', ''),
                           '0021xx40': ('LO', '1', 'Unknown', ''),
                           '0021xx50': ('LO', '1', 'Unknown', ''),
                           '0021xx60': ('DS', '1', 'Unknown', ''),
                           '0021xx70': ('DS', '1', 'Unknown', ''),
                           '0021xx80': ('DS', '1', 'Unknown', ''),
                           '0021xx90': ('DS', '1', 'Unknown', ''),
                           '0021xxa0': ('US', '1', 'Unknown', ''),
                           '0021xxa1': ('DS', '1', 'Unknown', ''),
                           '0021xxa2': ('DS', '1', 'Unknown', ''),
                           '0021xxa3': ('LT', '1', 'Unknown', ''),
                           '0021xxa4': ('LT', '1', 'Unknown', ''),
                           '0021xxb0': ('LO', '1', 'Unknown', ''),
                           '0021xxc0': ('LO', '1', 'Unknown', ''),
                           '0029xx10': ('LO', '1', 'Unknown', ''),
                           '0029xx30': ('UL', '1', 'Unknown', ''),
                           '0029xx31': ('UL', '1', 'Unknown', ''),
                           '0029xx32': ('UL', '1', 'Unknown', ''),
                           '0029xx33': ('UL', '1', 'Unknown', ''),
                           '0029xx80': ('LO', '1', 'Unknown', ''),
                           '0029xx90': ('LO', '1', 'Unknown', ''),
                           '0029xxd0': ('IS', '1', 'Unknown', ''),
                           '0029xxd1': ('IS', '1', 'Unknown', '')},
 'SPI-P-PCR Release 2': {'0019xx10': ('US', '1', 'Reader Mode', ''),
                         '0019xx20': ('ST', '1', 'MRM Code', ''),
                         '0019xx30': ('US', '1', 'Unknown', ''),
                         '0019xx40': ('DS', '1', 'Latitude', ''),
                         '0019xx60': ('ST', '1', 'View Name', ''),
                         '0019xx80': ('US', '1', 'Unknown', ''),
                         '0019xxa1': ('ST', '1', 'Unknown', ''),
                         '0019xxa3': ('DS', '1', 'Unknown', ''),
                         '0019xxa4': ('DS', '1', 'Unknown', ''),
                         '0019xxa5': ('DS', '1', 'Unknown', ''),
                         '0019xxa6': ('DS', '1', 'Unknown', ''),
                         '0019xxa7': ('DS', '1', 'Unknown', ''),
                         '0019xxa8': ('DS', '1', 'Unknown', ''),
                         '0019xxa9': ('DS', '1', 'Unknown', ''),
                         '0019xxaa': ('DS', '1', 'Unknown', ''),
                         '0019xxab': ('DS', '1', 'Unknown', ''),
                         '0019xxac': ('DS', '1', 'Unknown', ''),
                         '0019xxad': ('DS', '1', 'Unknown', ''),
                         '0019xxae': ('DS', '1', 'Unknown', ''),
                         '0019xxaf': ('ST', '1', 'Unknown', ''),
                         '0019xxb0': ('ST', '1', 'Unknown', ''),
                         '0019xxb1': ('ST', '1', 'Unknown', ''),
                         '0019xxb2': ('IS', '1', 'Unknown', ''),
                         '0019xxb3': ('IS', '1', 'Unknown', ''),
                         '0019xxb4': ('IS', '1', 'Unknown', ''),
                         '0019xxb5': ('DS', '1', 'Unknown', ''),
                         '0019xxb6': ('DS', '1', 'Unknown', ''),
                         '0019xxb7': ('ST', '1', 'Unknown', ''),
                         '0019xxb8': ('DS', '1', 'Unknown', ''),
                         '0019xxb9': ('ST', '1', 'Unknown', ''),
                         '0019xxba': ('ST', '1', 'Unknown', '')},
 'SPI-P-Private-CWS Release 1': {'0021xx00': ('LT',
                                              '1',
                                              'Window Of Images ID',
                                              ''),
                                 '0021xx01': ('CS',
                                              '1',
                                              'Window Of Images Type',
                                              ''),
                                 '0021xx02': ('IS',
                                              '1-n',
                                              'WindowOfImagesScope',
                                              '')},
 'SPI-P-Private-DCI Release 1': {'0019xx10': ('UN', '1', 'Unknown', ''),
                                 '0019xx11': ('UN', '1', 'Unknown', ''),
                                 '0019xx12': ('UN', '1', 'Unknown', ''),
                                 '0019xx13': ('UN', '1', 'Unknown', ''),
                                 '0019xx14': ('UN', '1', 'Unknown', ''),
                                 '0019xx15': ('UN', '1', 'Unknown', ''),
                                 '0019xx16': ('UN', '1', 'Unknown', ''),
                                 '0019xx17': ('UN', '1', 'Unknown', '')},
 'SPI-P-Private-DiDi Release 1': {'0019xx00': ('LT',
                                               '1',
                                               'Post Mode String',
                                               ''),
                                  '0019xx01': ('LT', '1', 'Post Data', ''),
                                  '0019xx10': ('LT', '1', 'Image Header', ''),
                                  '0019xx20': ('LT', '1', 'SCPreName', ''),
                                  '0019xx21': ('IS', '1', 'SCPostNo', ''),
                                  '0019xx22': ('LT',
                                               '1',
                                               'SCSOPInstanceUID',
                                               ''),
                                  '0019xx23': ('LT',
                                               '1',
                                               'SCCreationDate',
                                               ''),
                                  '0019xx24': ('LT',
                                               '1',
                                               'SCProcessingCategory',
                                               ''),
                                  '0019xx25': ('LT', '1', 'SCPostMethod', ''),
                                  '0019xx26': ('LT', '1', 'SCPostString', ''),
                                  '0019xx27': ('LT',
                                               '1',
                                               'SCPostString2',
                                               ''),
                                  '0019xx28': ('LT', '1', 'SCMode', ''),
                                  '0019xx29': ('IS', '1', 'SCStCommit', ''),
                                  '0019xx2a': ('IS', '1', 'SCExported', ''),
                                  '0019xx2b': ('IS', '1', 'SCPrinted', ''),
                                  '0019xx2c': ('LT', '1', 'SCOperator', ''),
                                  '0019xx40': ('LT', '1', 'SCPreName', ''),
                                  '0019xx41': ('IS', '1', 'SCPreType', '')},
 'SPI-P-Private_CDS Release 1': {'0021xx40': ('IS', '1', 'Unknown', ''),
                                 '0029xx00': ('UN', '1', 'Unknown', ''),
                                 '0029xx10': ('OB', '1', 'Unknown', '')},
 'SPI-P-Private_ICS Release 1': {'0019xx30': ('DS', '1', 'Unknown', ''),
                                 '0019xx31': ('LO', '1', 'Unknown', ''),
                                 '0029xx0d': ('SQ', '1', 'Unknown', ''),
                                 '0029xx0e': ('SQ', '1', 'Unknown', ''),
                                 '0029xx0f': ('SQ', '1', 'Unknown', ''),
                                 '0029xx10': ('SQ', '1', 'Unknown', ''),
                                 '0029xx1b': ('SQ', '1', 'Unknown', ''),
                                 '0029xx1c': ('SQ', '1', 'Unknown', ''),
                                 '0029xx1d': ('SQ', '1', 'Unknown', ''),
                                 '0029xx20': ('UN', '1', 'Unknown', ''),
                                 '0029xx21': ('SQ', '1', 'Unknown', ''),
                                 '0029xx4c': ('SQ', '1', 'Unknown', ''),
                                 '0029xx4d': ('SQ', '1', 'Unknown', ''),
                                 '0029xx4e': ('UN', '1', 'Unknown', ''),
                                 '0029xx4f': ('UN', '1', 'Unknown', ''),
                                 '0029xx50': ('UN', '1', 'Unknown', ''),
                                 '0029xx51': ('UN', '1', 'Unknown', ''),
                                 '0029xx67': ('LO', '1', 'Unknown', ''),
                                 '0029xx68': ('US', '1', 'Unknown', ''),
                                 '0029xx6a': ('LO', '1', 'Unknown', ''),
                                 '0029xx6b': ('US', '1', 'Unknown', ''),
                                 '0029xx72': ('SQ', '1', 'Unknown', ''),
                                 '0029xx91': ('IS', '1', 'Unknown', '')},
 'SPI-P-Private_ICS Release 1;1': {'0029xx00': ('SL', '1', 'Unknown', ''),
                                   '0029xx05': ('FL', '1', 'Unknown', ''),
                                   '0029xx06': ('FL', '1', 'Unknown', ''),
                                   '0029xx20': ('FL', '1', 'Unknown', ''),
                                   '0029xx21': ('FL', '1', 'Unknown', ''),
                                   '0029xx30': ('ST', '1', 'Unknown', ''),
                                   '0029xx6b': ('FD', '1', 'Unknown', ''),
                                   '0029xxcd': ('SQ', '1', 'Unknown', ''),
                                   '0029xxd4': ('FL', '1', 'Unknown', ''),
                                   '0029xxd5': ('FL', '1', 'Unknown', ''),
                                   '0029xxd6': ('ST', '1', 'Unknown', '')},
 'SPI-P-Private_ICS Release 1;2': {'0029xx00': ('FD', '1', 'Unknown', ''),
                                   '0029xx01': ('FD', '1', 'Unknown', ''),
                                   '0029xx02': ('FD', '1', 'Unknown', ''),
                                   '0029xx03': ('SL', '1', 'Unknown', ''),
                                   '0029xx04': ('SL', '1', 'Unknown', ''),
                                   '0029xx05': ('SL', '1', 'Unknown', ''),
                                   '0029xx30': ('LO', '1', 'Unknown', ''),
                                   '0029xxa0': ('UN', '1', 'Unknown', ''),
                                   '0029xxa1': ('UN', '1', 'Unknown', ''),
                                   '0029xxa2': ('UN', '1', 'Unknown', ''),
                                   '0029xxa3': ('UN', '1', 'Unknown', ''),
                                   '0029xxa5': ('SQ', '1', 'Unknown', ''),
                                   '0029xxa6': ('UN', '1', 'Unknown', ''),
                                   '0029xxd9': ('SQ', '1', 'Unknown', '')},
 'SPI-P-Private_ICS Release 1;3': {'0029xx00': ('ST', '1', 'Unknown', ''),
                                   '0029xx01': ('ST', '1', 'Unknown', ''),
                                   '0029xx60': ('US', '1', 'Unknown', ''),
                                   '0029xxb0': ('SL', '1', 'Unknown', ''),
                                   '0029xxb1': ('FL', '1', 'Unknown', ''),
                                   '0029xxb2': ('FL', '1', 'Unknown', ''),
                                   '0029xxb4': ('FL', '1', 'Unknown', ''),
                                   '0029xxb9': ('FL', '1', 'Unknown', ''),
                                   '0029xxc0': ('SQ', '1', 'Unknown', ''),
                                   '0029xxc1': ('SQ', '1', 'Unknown', ''),
                                   '0029xxc2': ('SQ', '1', 'Unknown', ''),
                                   '0029xxc3': ('SQ', '1', 'Unknown', ''),
                                   '0029xxc4': ('SQ', '1', 'Unknown', ''),
                                   '0029xxc5': ('SQ', '1', 'Unknown', '')},
 'SPI-P-Private_ICS Release 1;4': {'0029xx00': ('UL', '1', 'Unknown', ''),
                                   '0029xx01': ('FL', '2', 'Unknown', ''),
                                   '0029xx02': ('SQ', '1', 'Unknown', ''),
                                   '0029xx06': ('UL', '1', 'Unknown', ''),
                                   '0029xx07': ('SL', '1', 'Unknown', ''),
                                   '0029xx08': ('US', '1', 'Unknown', ''),
                                   '0029xx09': ('FL', '1', 'Unknown', ''),
                                   '0029xx0a': ('FL', '1', 'Unknown', ''),
                                   '0029xx0b': ('FL', '1', 'Unknown', ''),
                                   '0029xx0c': ('FL', '1', 'Unknown', ''),
                                   '0029xxa0': ('US', '1', 'Unknown', ''),
                                   '0029xxa1': ('US', '1', 'Unknown', ''),
                                   '0029xxb1': ('US', '1', 'Unknown', ''),
                                   '0029xxb2': ('US', '1', 'Unknown', ''),
                                   '0029xxb3': ('SL', '1', 'Unknown', ''),
                                   '0029xxb5': ('FL', '1', 'Unknown', ''),
                                   '0029xxbc': ('SL', '1', 'Unknown', ''),
                                   '0029xxbd': ('SL', '1', 'Unknown', ''),
                                   '0029xxbe': ('US', '1', 'Unknown', ''),
                                   '0029xxd6': ('UN', '1', 'Unknown', ''),
                                   '0029xxd7': ('UN', '1', 'Unknown', ''),
                                   '0029xxd8': ('UN', '1', 'Unknown', ''),
                                   '0029xxd9': ('UN', '1', 'Unknown', ''),
                                   '0029xxda': ('UN', '1', 'Unknown', ''),
                                   '0029xxdc': ('UN', '1', 'Unknown', ''),
                                   '0029xxdd': ('UN', '1', 'Unknown', ''),
                                   '0029xxe0': ('SQ', '1', 'Unknown', '')},
 'SPI-P-Private_ICS Release 1;5': {'0029xx50': ('CS', '1', 'Unknown', ''),
                                   '0029xx55': ('CS', '1', 'Unknown', '')},
 'SPI-P-Private_ICS Release 1;6': {'0029xx01': ('FL', '1', 'Unknown', ''),
                                   '0029xx02': ('LO', '1', 'Unknown', ''),
                                   '0029xx03': ('UL', '1', 'Unknown', ''),
                                   '0029xx04': ('LO', '1', 'Unknown', ''),
                                   '0029xx06': ('SQ', '1', 'Unknown', ''),
                                   '0029xx07': ('SQ', '1', 'Unknown', ''),
                                   '0029xx08': ('US', '1', 'Unknown', ''),
                                   '0029xx0a': ('US', '1', 'Unknown', ''),
                                   '0029xx0b': ('US', '1', 'Unknown', ''),
                                   '0029xx0c': ('US', '1', 'Unknown', ''),
                                   '0029xx0d': ('US', '1', 'Unknown', ''),
                                   '0029xx0f': ('LO', '1', 'Unknown', ''),
                                   '0029xx10': ('US', '1', 'Unknown', ''),
                                   '0029xx14': ('SQ', '1', 'Unknown', ''),
                                   '0029xx15': ('UL', '2', 'Unknown', ''),
                                   '0029xx16': ('FL', '1', 'Unknown', ''),
                                   '0029xx17': ('FL', '1', 'Unknown', ''),
                                   '0029xx1a': ('UL', '1', 'Unknown', ''),
                                   '0029xx1d': ('US', '1', 'Unknown', ''),
                                   '0029xx1f': ('FL', '1', 'Unknown', ''),
                                   '0029xx20': ('FL', '1', 'Unknown', ''),
                                   '0029xx21': ('UL', '1', 'Unknown', ''),
                                   '0029xx23': ('US', '1', 'Unknown', ''),
                                   '0029xx24': ('UL', '1', 'Unknown', ''),
                                   '0029xx2a': ('UL', '1', 'Unknown', ''),
                                   '0029xx2b': ('SQ', '1', 'Unknown', ''),
                                   '0029xx2c': ('UL', '1', 'Unknown', ''),
                                   '0029xx2d': ('SQ', '1', 'Unknown', ''),
                                   '0029xx2e': ('SQ', '1', 'Unknown', ''),
                                   '0029xx2f': ('SQ', '1', 'Unknown', ''),
                                   '0029xx32': ('SQ', '1', 'Unknown', ''),
                                   '0029xx34': ('SQ', '1', 'Unknown', ''),
                                   '0029xx35': ('SQ', '1', 'Unknown', ''),
                                   '0029xx36': ('SQ', '1', 'Unknown', ''),
                                   '0029xx37': ('SQ', '1', 'Unknown', ''),
                                   '0029xx38': ('SQ', '1', 'Unknown', ''),
                                   '0029xx39': ('FL', '1', 'Unknown', ''),
                                   '0029xx3d': ('SQ', '1', 'Unknown', ''),
                                   '0029xx43': ('US', '1', 'Unknown', ''),
                                   '0029xx44': ('US', '1', 'Unknown', ''),
                                   '0029xx48': ('UL', '1', 'Unknown', ''),
                                   '0029xx4f': ('SQ', '1', 'Unknown', ''),
                                   '0029xx5c': ('SQ', '1', 'Unknown', ''),
                                   '0029xx5d': ('UL', '1-n', 'Unknown', ''),
                                   '0029xx5e': ('UL', '1', 'Unknown', ''),
                                   '0029xx5f': ('US', '1', 'Unknown', ''),
                                   '0029xx63': ('US', '1', 'Unknown', ''),
                                   '0029xx65': ('SQ', '1', 'Unknown', ''),
                                   '0029xx66': ('UL', '1', 'Unknown', ''),
                                   '0029xx67': ('UL', '1', 'Unknown', ''),
                                   '0029xx68': ('UL', '1', 'Unknown', ''),
                                   '0029xx69': ('UL', '1', 'Unknown', ''),
                                   '0029xx6d': ('SQ', '1', 'Unknown', '')},
 'SPI-P-XSB-DCI Release 1': {'0019xx10': ('LT', '1', 'Video Beam Boost', ''),
                             '0019xx11': ('US',
                                          '1',
                                          'Channel Generating Video Sync',
                                          ''),
                             '0019xx12': ('US', '1', 'Video Gain', ''),
                             '0019xx13': ('US', '1', 'Video Offset', ''),
                             '0019xx20': ('DS',
                                          '1',
                                          'RTD Data Compression Factor',
                                          '')},
 'SPI-P-XSB-VISUB Release 1': {'0019xx00': ('UN', '1', 'Unknown', ''),
                               '0019xx10': ('UN', '1', 'Unknown', ''),
                               '0019xx11': ('UN', '1', 'Unknown', ''),
                               '0019xx12': ('UN', '1', 'Unknown', ''),
                               '0019xx20': ('LO', '1', 'Unknown', ''),
                               '0019xx40': ('UN', '1', 'Unknown', ''),
                               '0019xx50': ('LO', '1', 'Unknown', ''),
                               '0029xx00': ('LO', '1', 'Unknown', ''),
                               '0029xx01': ('DS', '1', 'Unknown', ''),
                               '0029xx02': ('CS', '1', 'Unknown', ''),
                               '0029xx0f': ('CS', '1', 'Unknown', ''),
                               '0029xx10': ('LO', '1', 'Unknown', ''),
                               '0029xx11': ('DS', '1', 'Unknown', ''),
                               '0029xx12': ('CS', '1', 'Unknown', ''),
                               '0029xx1f': ('CS', '1', 'Unknown', ''),
                               '0029xx20': ('LO', '1', 'Unknown', ''),
                               '0029xx21': ('DS', '1', 'Unknown', ''),
                               '0029xx22': ('CS', '1', 'Unknown', ''),
                               '0029xx2f': ('CS', '1', 'Unknown', ''),
                               '0029xx30': ('LO', '1', 'Unknown', ''),
                               '0029xx31': ('DS', '1', 'Unknown', ''),
                               '0029xx32': ('CS', '1', 'Unknown', ''),
                               '0029xx3f': ('CS', '1', 'Unknown', '')},
 'STENTOR': {'0073xx01': ('ST', '1', 'Unknown', ''),
             '0073xx02': ('ST', '1', 'Unknown', ''),
             '0073xx03': ('ST', '1', 'Unknown', '')},
 'SVISION': {'0017xx00': ('LO', '1', 'Extended Body Part', ''),
             '0017xx10': ('LO', '1', 'Extended View Position', ''),
             '0017xx20': ('SQ', '1', 'Scheduled Procedure Step', ''),
             '0017xxa0': ('IS', '1', 'Fixed Grid System', ''),
             '0017xxf0': ('IS', '1', 'Images SOP Class', ''),
             '0019xx00': ('IS', '1', 'AEC Field', ''),
             '0019xx01': ('IS', '1', 'AEC Film Screen', ''),
             '0019xx02': ('IS', '1', 'AEC Density', ''),
             '0019xx10': ('IS', '1', 'Patient Thickness', ''),
             '0019xx16': ('IS', '1', 'Unknown', ''),
             '0019xx18': ('IS', '1', 'Beam Distance', ''),
             '0019xx20': ('IS', '1', 'Workstation Number', ''),
             '0019xx28': ('IS', '1', 'Tube Number', ''),
             '0019xx30': ('IS', '1', 'Bucky Grid', ''),
             '0019xx34': ('IS', '1', 'Focus', ''),
             '0019xx38': ('IS', '1', 'Age Group', ''),
             '0019xx40': ('IS', '1', 'Collimator Distance X', ''),
             '0019xx41': ('IS', '1', 'Collimator Distance Y', ''),
             '0019xx50': ('IS', '1', 'Bucky Height', ''),
             '0019xx60': ('IS', '1', 'Bucky Angle', ''),
             '0019xx68': ('IS', '1', 'C-Arm Angle', ''),
             '0019xx69': ('IS', '1', 'Collimator Angle', ''),
             '0019xx70': ('IS', '1', 'Filter Number', ''),
             '0019xx74': ('LO', '1', 'Filter Material 1', ''),
             '0019xx75': ('LO', '1', 'Filter Material 2', ''),
             '0019xx78': ('DS', '1', 'Filter Thickness 1', ''),
             '0019xx79': ('DS', '1', 'Filter Thickness 2', ''),
             '0019xx80': ('IS', '1', 'Bucky Format', ''),
             '0019xx81': ('IS', '1', 'Object Position', ''),
             '0019xx90': ('LO', '1', 'Desk Command', ''),
             '0019xx91': ('IS', '1', 'Central Beam X', ''),
             '0019xx92': ('IS', '1', 'Central Beam Y', ''),
             '0019xx93': ('IS', '1', 'Tube Turn Angle', ''),
             '0019xx94': ('IS', '1', 'Stand drive level', ''),
             '0019xxa0': ('DS', '1', 'Extended Exposure Time', ''),
             '0019xxa1': ('DS', '1', 'Actual Exposure Time', ''),
             '0019xxa8': ('DS', '1', 'Extended X-ray Tube Current', ''),
             '0019xxb0': ('IS', '1', 'Dose Indicator', ''),
             '0019xxb1': ('IS', '1', 'Shift Reference Value', ''),
             '0019xxf0': ('IS', '1', 'Unknown', ''),
             '0021xx00': ('DS', '1', 'Noise Reduction', ''),
             '0021xx01': ('DS', '1', 'Contrast Amplification', ''),
             '0021xx02': ('DS', '1', 'Edge Contrast Boosting', ''),
             '0021xx03': ('DS', '1', 'Latitude Reduction', ''),
             '0021xx10': ('LO', '1', 'Find Range Algorithm', ''),
             '0021xx11': ('DS', '1', 'Threshold C-Algorithm', ''),
             '0021xx20': ('LO', '1', 'Sensometric Curve', ''),
             '0021xx30': ('DS', '1', 'Lower Window Offset', ''),
             '0021xx31': ('DS', '1', 'Upper Window Offset', ''),
             '0021xx40': ('DS', '1', 'Min. Printable Density', ''),
             '0021xx41': ('DS', '1', 'Max. Printable Density', ''),
             '0021xx50': ('DS', '1', 'Min. Window Latitude', ''),
             '0021xx51': ('DS', '1', 'Max. Window Latitude', ''),
             '0021xx52': ('DS', '1', 'Rel. Window Alignment', ''),
             '0021xx60': ('DS', '1', 'Decomposition Layer', ''),
             '0021xx90': ('DS', '1', 'Brightness', ''),
             '0021xx91': ('DS', '1', 'Contrast', ''),
             '0021xx92': ('DS', '1', 'Shape Factor', ''),
             '0023xx00': ('LO', '1', 'Image Laterality', ''),
             '0023xx01': ('IS', '1', 'Letter Position', ''),
             '0023xx02': ('IS', '1', 'Burned In Annotation', ''),
             '0023xx03': ('LO', '1', 'Unknown', ''),
             '0023xxf0': ('IS', '1', 'Image SOP Class', ''),
             '0025xx00': ('IS', '1', 'Original Image', ''),
             '0025xx01': ('IS', '1', 'Not Processed Image', ''),
             '0025xx02': ('IS', '1', 'Cut Out Image', ''),
             '0025xx03': ('IS', '1', 'Duplicated Image', ''),
             '0025xx04': ('IS', '1', 'Stored Image', ''),
             '0025xx05': ('IS', '1', 'Retrieved Image', ''),
             '0025xx06': ('IS', '1', 'New Image', ''),
             '0025xx07': ('IS', '1', 'Media Stored Image', ''),
             '0025xx08': ('IS', '1', 'Image State', ''),
             '0025xx09': ('IS', '1', 'Image Stitched Manually', ''),
             '0025xx0a': ('IS', '1', 'Image Stitched Automatically', ''),
             '0025xx20': ('LO', '1', 'Source Image File', ''),
             '0025xx21': ('LO', '1', 'Source UID', ''),
             '0027xx00': ('IS', '1', 'Number of Series', ''),
             '0027xx01': ('IS', '1', 'Number of Studies', ''),
             '0027xx10': ('DT', '1', 'Oldest Series', ''),
             '0027xx11': ('DT', '1', 'Newest Series', ''),
             '0027xx12': ('DT', '1', 'Oldest Study', ''),
             '0027xx13': ('DT', '1', 'Newest Study', ''),
             '0029xx00': ('IS', '1', 'Key Note Instance UID', ''),
             '0029xx01': ('IS', '1', 'Storage State', ''),
             '0029xx02': ('IS', '1', 'Referenced Image SOP Class', ''),
             '0029xx03': ('LO', '1', 'Ref. Image Instance UID', ''),
             '0029xx04': ('IS', '1', 'Rel. Pres. State Number', ''),
             '0029xx05': ('LO', '1', 'Rel. Presentation State UID', '')},
 'Siemens Ultrasound Miscellaneous': {'0019xx20': ('SH', '1', 'Unknown', '')},
 'Siemens: Thorax/Multix FD Image Stamp': {'0023xx00': ('US',
                                                        '1',
                                                        'Unknown',
                                                        ''),
                                           '0023xx01': ('US',
                                                        '1',
                                                        'Unknown',
                                                        ''),
                                           '0023xx02': ('US',
                                                        '1',
                                                        'Unknown',
                                                        ''),
                                           '0023xx03': ('US',
                                                        '1',
                                                        'Unknown',
                                                        ''),
                                           '0023xx04': ('US',
                                                        '1',
                                                        'Unknown',
                                                        '')},
 'Siemens: Thorax/Multix FD Lab Settings': {'0019xx00': ('LT',
                                                         '1',
                                                         'Internal Value',
                                                         ''),
                                            '0019xx02': ('LO',
                                                         '1',
                                                         'Total Area Dose Product',
                                                         ''),
                                            '0019xx04': ('LO',
                                                         '1',
                                                         'Unknown',
                                                         ''),
                                            '0019xx05': ('US',
                                                         '1',
                                                         'Cassette Image',
                                                         ''),
                                            '0019xx06': ('FD',
                                                         '1',
                                                         'Table Object Distance',
                                                         ''),
                                            '0019xx07': ('FD',
                                                         '1',
                                                         'Table Detector Distance',
                                                         ''),
                                            '0019xx08': ('US',
                                                         '1',
                                                         'Ortho Step Distance',
                                                         ''),
                                            '0021xx08': ('US',
                                                         '1',
                                                         'Auto Window Flag',
                                                         ''),
                                            '0021xx09': ('SL',
                                                         '1',
                                                         'Auto Window Center',
                                                         ''),
                                            '0021xx0a': ('SL',
                                                         '1',
                                                         'Auto Window Width',
                                                         ''),
                                            '0021xx0b': ('SS',
                                                         '1',
                                                         'Filter ID',
                                                         ''),
                                            '0021xx14': ('US',
                                                         '1',
                                                         'Anatomic Correct View',
                                                         ''),
                                            '0021xx15': ('SS',
                                                         '1',
                                                         'Auto Window Shift',
                                                         ''),
                                            '0021xx16': ('DS',
                                                         '1',
                                                         'Auto Window Expansion',
                                                         ''),
                                            '0021xx17': ('LO',
                                                         '1',
                                                         'System Type',
                                                         ''),
                                            '0021xx30': ('SH',
                                                         '1',
                                                         'Anatomic Sort Number',
                                                         ''),
                                            '0021xx31': ('SH',
                                                         '1',
                                                         'Acquisition Sort Number',
                                                         '')},
 'Siemens: Thorax/Multix FD Post Processing': {'0021xx00': ('US',
                                                            '1',
                                                            'Label Left',
                                                            ''),
                                               '0021xx01': ('SS',
                                                            '1',
                                                            'Label Left Orientation',
                                                            ''),
                                               '0021xx02': ('FL',
                                                            '1',
                                                            'Label Left Percentage X',
                                                            ''),
                                               '0021xx03': ('FL',
                                                            '1',
                                                            'Label Left Percentage X',
                                                            ''),
                                               '0021xx04': ('US',
                                                            '1',
                                                            'Label Right',
                                                            ''),
                                               '0021xx05': ('SS',
                                                            '1',
                                                            'Label Right Orientation',
                                                            ''),
                                               '0021xx06': ('FL',
                                                            '1',
                                                            'Label Right Percentage X',
                                                            ''),
                                               '0021xx07': ('FL',
                                                            '1',
                                                            'Label Right Percentage X',
                                                            ''),
                                               '0021xx08': ('US',
                                                            '1',
                                                            'Auto Window Flag',
                                                            ''),
                                               '0021xx09': ('SL',
                                                            '1',
                                                            'Auto Window Center',
                                                            ''),
                                               '0021xx0a': ('SL',
                                                            '1',
                                                            'Auto Window Width',
                                                            ''),
                                               '0021xx0b': ('SS',
                                                            '1',
                                                            'Filter ID',
                                                            ''),
                                               '0021xx0c': ('FL',
                                                            '1',
                                                            'Degree of Edge Enhancement',
                                                            ''),
                                               '0021xx0d': ('SS',
                                                            '1',
                                                            'Half Kernel Size',
                                                            ''),
                                               '0021xx0e': ('US',
                                                            '1',
                                                            'Dose Control Value',
                                                            ''),
                                               '0021xx0f': ('US',
                                                            '1',
                                                            'Deleted Image Flag',
                                                            ''),
                                               '0021xx10': ('US',
                                                            '1',
                                                            'Same Size Support',
                                                            ''),
                                               '0021xx11': ('SS',
                                                            '1',
                                                            'Label Left Init Position',
                                                            ''),
                                               '0021xx12': ('SS',
                                                            '1',
                                                            'Label Right Init Position',
                                                            ''),
                                               '0021xx13': ('SS',
                                                            '1',
                                                            'Patient Rotation',
                                                            ''),
                                               '0021xx14': ('US',
                                                            '1',
                                                            'Anatomic Correct View Flag',
                                                            ''),
                                               '0021xx15': ('SS',
                                                            '1',
                                                            'Auto Window Shift',
                                                            ''),
                                               '0021xx16': ('DS',
                                                            '1',
                                                            'Auto Window Expansion',
                                                            '')},
 'Siemens: Thorax/Multix FD Raw Image Settings': {'0025xx00': ('SS',
                                                               '1',
                                                               'Raw Image Amplification',
                                                               ''),
                                                  '0025xx01': ('SS',
                                                               '1',
                                                               'Gamma LUT',
                                                               ''),
                                                  '0025xx02': ('US',
                                                               '1',
                                                               'Collimator Manual',
                                                               ''),
                                                  '0025xx03': ('FL',
                                                               '1',
                                                               'Collimator Up Left X Percentage',
                                                               ''),
                                                  '0025xx04': ('FL',
                                                               '1',
                                                               'Collimator Up Right X Percentage',
                                                               ''),
                                                  '0025xx05': ('FL',
                                                               '1',
                                                               'Collimator Low Left X Percentage',
                                                               ''),
                                                  '0025xx06': ('FL',
                                                               '1',
                                                               'Collimator Low Right X Percentage',
                                                               ''),
                                                  '0025xx07': ('FL',
                                                               '1',
                                                               'Collimator Up Left Y Percentage',
                                                               ''),
                                                  '0025xx08': ('FL',
                                                               '1',
                                                               'Collimator Up Right Y Percentage',
                                                               ''),
                                                  '0025xx09': ('FL',
                                                               '1',
                                                               'Collimator Low Left Y Percentage',
                                                               ''),
                                                  '0025xx0a': ('FL',
                                                               '1',
                                                               'Collimator Low Right Y Percentage',
                                                               ''),
                                                  '0025xx0b': ('US',
                                                               '1',
                                                               'Set Gray',
                                                               ''),
                                                  '0025xx0c': ('SS',
                                                               '1',
                                                               'Harmonization Kernel',
                                                               ''),
                                                  '0025xx0d': ('FL',
                                                               '1',
                                                               'Harmonization Gain',
                                                               ''),
                                                  '0025xx0e': ('SS',
                                                               '1',
                                                               'Edge Enhancement Kernel',
                                                               ''),
                                                  '0025xx0f': ('FL',
                                                               '1',
                                                               'Edge Enhancement Gain',
                                                               ''),
                                                  '0025xx10': ('LT',
                                                               '1',
                                                               'Raw Image File Name',
                                                               ''),
                                                  '0025xx11': ('SS',
                                                               '1',
                                                               'Global Offset',
                                                               ''),
                                                  '0025xx12': ('SS',
                                                               '1',
                                                               'Image Columns',
                                                               ''),
                                                  '0025xx13': ('SS',
                                                               '1',
                                                               'Image Rows',
                                                               ''),
                                                  '0025xx14': ('SS',
                                                               '1',
                                                               'Image Alignment',
                                                               ''),
                                                  '0025xx15': ('SS',
                                                               '1',
                                                               'Active Image Columns',
                                                               ''),
                                                  '0025xx16': ('SS',
                                                               '1',
                                                               'Active Image Rows',
                                                               ''),
                                                  '0025xx17': ('LO',
                                                               '1',
                                                               'System Type',
                                                               ''),
                                                  '0025xx18': ('US',
                                                               '1',
                                                               'Auto Gain',
                                                               ''),
                                                  '0025xx19': ('US',
                                                               '1',
                                                               'Ortho Sub Sampling',
                                                               ''),
                                                  '0025xx1a': ('US',
                                                               '2',
                                                               'Image Crop Upper Left',
                                                               ''),
                                                  '0025xx1b': ('US',
                                                               '2',
                                                               'Image Crop Upper Right',
                                                               ''),
                                                  '0025xx1c': ('US',
                                                               '2',
                                                               'Image Crop Lower Left',
                                                               ''),
                                                  '0025xx1d': ('US',
                                                               '2',
                                                               'Image Crop Lower Right',
                                                               ''),
                                                  '0025xx30': ('US',
                                                               '1',
                                                               'Manual Cropping',
                                                               ''),
                                                  '0025xx31': ('SS',
                                                               '1',
                                                               'Gamma LUT Parameter 1',
                                                               ''),
                                                  '0025xx32': ('DS',
                                                               '1',
                                                               'Gamma LUT Parameter 2',
                                                               ''),
                                                  '0025xx33': ('SS',
                                                               '1',
                                                               'Gamma LUT Parameter 3',
                                                               ''),
                                                  '0025xx34': ('SS',
                                                               '1',
                                                               'Gamma LUT Parameter 4',
                                                               '')},
 'Siemens: Thorax/Multix FD Version': {'0017xx00': ('LO',
                                                    '1',
                                                    'Build Date',
                                                    ''),
                                       '0017xx01': ('LO',
                                                    '1',
                                                    'IOD Version',
                                                    '')},
 'Silhouette Annot V1.0': {'0029xx11': ('IS', '1', 'Annotation Name', ''),
                           '0029xx12': ('LT', '1', 'Annotation Font', ''),
                           '0029xx13': ('LT',
                                        '1',
                                        'Annotation Text Foreground Color',
                                        ''),
                           '0029xx14': ('LT',
                                        '1',
                                        'Annotation Text Background Color',
                                        ''),
                           '0029xx15': ('UL',
                                        '1',
                                        'Annotation Text Backing Mode',
                                        ''),
                           '0029xx16': ('UL',
                                        '1',
                                        'Annotation Text Justification',
                                        ''),
                           '0029xx17': ('UL',
                                        '1',
                                        'Annotation Text Location',
                                        ''),
                           '0029xx18': ('LT',
                                        '1',
                                        'Annotation Text String',
                                        ''),
                           '0029xx19': ('UL',
                                        '1',
                                        'Annotation Text Attach Mode',
                                        ''),
                           '0029xx20': ('UL',
                                        '1',
                                        'Annotation Text Cursor Mode',
                                        ''),
                           '0029xx21': ('UL',
                                        '1',
                                        'Annotation Text Shadow Offset X',
                                        ''),
                           '0029xx22': ('UL',
                                        '1',
                                        'Annotation Text Shadow Offset Y',
                                        ''),
                           '0029xx23': ('LT',
                                        '1',
                                        'Annotation Line Color',
                                        ''),
                           '0029xx24': ('UL',
                                        '1',
                                        'Annotation Line Thickness',
                                        ''),
                           '0029xx25': ('UL',
                                        '1',
                                        'Annotation Line Type',
                                        ''),
                           '0029xx26': ('UL',
                                        '1',
                                        'Annotation Line Style',
                                        ''),
                           '0029xx27': ('UL',
                                        '1',
                                        'Annotation Line Dash Length',
                                        ''),
                           '0029xx28': ('UL',
                                        '1',
                                        'Annotation Line Attach Mode',
                                        ''),
                           '0029xx29': ('UL',
                                        '1',
                                        'Annotation Line Point Count',
                                        ''),
                           '0029xx30': ('FD',
                                        '1',
                                        'Annotation Line Points',
                                        ''),
                           '0029xx31': ('UL',
                                        '1',
                                        'Annotation Line Control Size',
                                        ''),
                           '0029xx32': ('LT',
                                        '1',
                                        'Annotation Marker Color',
                                        ''),
                           '0029xx33': ('UL',
                                        '1',
                                        'Annotation Marker Type',
                                        ''),
                           '0029xx34': ('UL',
                                        '1',
                                        'Annotation Marker Size',
                                        ''),
                           '0029xx35': ('FD',
                                        '1',
                                        'Annotation Marker Location',
                                        ''),
                           '0029xx36': ('UL',
                                        '1',
                                        'Annotation Marker Attach Mode',
                                        ''),
                           '0029xx37': ('LT',
                                        '1',
                                        'Annotation Geom Color',
                                        ''),
                           '0029xx38': ('UL',
                                        '1',
                                        'Annotation Geom Thickness',
                                        ''),
                           '0029xx39': ('UL',
                                        '1',
                                        'Annotation Geom Line Style',
                                        ''),
                           '0029xx40': ('UL',
                                        '1',
                                        'Annotation Geom Dash Length',
                                        ''),
                           '0029xx41': ('UL',
                                        '1',
                                        'Annotation Geom Fill Pattern',
                                        ''),
                           '0029xx42': ('UL',
                                        '1',
                                        'Annotation Interactivity',
                                        ''),
                           '0029xx43': ('FD',
                                        '1',
                                        'Annotation Arrow Length',
                                        ''),
                           '0029xx44': ('FD',
                                        '1',
                                        'Annotation Arrow Angle',
                                        ''),
                           '0029xx45': ('UL',
                                        '1',
                                        "Annotation Don't Save",
                                        '')},
 'Silhouette Graphics Export V1.0': {'0029xx00': ('UI', '1', 'Unknown', '')},
 'Silhouette Line V1.0': {'0029xx11': ('IS', '1', 'Line Name', ''),
                          '0029xx12': ('LT', '1', 'Line Name Font', ''),
                          '0029xx13': ('UL', '1', 'Line Name Display', ''),
                          '0029xx14': ('LT', '1', 'Line Normal Color', ''),
                          '0029xx15': ('UL', '1', 'Line Type', ''),
                          '0029xx16': ('UL', '1', 'Line Thickness', ''),
                          '0029xx17': ('UL', '1', 'Line Style', ''),
                          '0029xx18': ('UL', '1', 'Line Dash Length', ''),
                          '0029xx19': ('UL', '1', 'Line Interactivity', ''),
                          '0029xx20': ('LT',
                                       '1',
                                       'Line Measurement Color',
                                       ''),
                          '0029xx21': ('LT',
                                       '1',
                                       'Line Measurement Font',
                                       ''),
                          '0029xx22': ('UL',
                                       '1',
                                       'Line Measurement Dash Length',
                                       ''),
                          '0029xx23': ('UL', '1', 'Line Point Space', ''),
                          '0029xx24': ('FD', '1', 'Line Points', ''),
                          '0029xx25': ('UL',
                                       '1',
                                       'Line Control Point Size',
                                       ''),
                          '0029xx26': ('UL',
                                       '1',
                                       'Line Control Point Space',
                                       ''),
                          '0029xx27': ('FD', '1', 'Line Control Points', ''),
                          '0029xx28': ('LT', '1', 'Line Label', ''),
                          '0029xx29': ('UL', '1', "Line Don't Save", '')},
 'Silhouette ROI V1.0': {'0029xx11': ('IS', '1', 'ROI Name', ''),
                         '0029xx12': ('LT', '1', 'ROI Name Font', ''),
                         '0029xx13': ('LT', '1', 'ROI Normal Color', ''),
                         '0029xx14': ('UL', '1', 'ROI Fill Pattern', ''),
                         '0029xx15': ('UL', '1', 'ROI Bp Seg', ''),
                         '0029xx16': ('UN', '1', 'ROI Bp Seg Pairs', ''),
                         '0029xx17': ('UL', '1', 'ROI Seed Space', ''),
                         '0029xx18': ('UN', '1', 'ROI Seeds', ''),
                         '0029xx19': ('UL', '1', 'ROI Line Thickness', ''),
                         '0029xx20': ('UL', '1', 'ROI Line Style', ''),
                         '0029xx21': ('UL', '1', 'ROI Line Dash Length', ''),
                         '0029xx22': ('UL', '1', 'ROI Interactivity', ''),
                         '0029xx23': ('UL', '1', 'ROI Name Position', ''),
                         '0029xx24': ('UL', '1', 'ROI Name Display', ''),
                         '0029xx25': ('LT', '1', 'ROI Label', ''),
                         '0029xx26': ('UL', '1', 'ROI Shape', ''),
                         '0029xx27': ('FD', '1', 'ROI Shape Tilt', ''),
                         '0029xx28': ('UL',
                                      '1',
                                      'ROI Shape Points Count',
                                      ''),
                         '0029xx29': ('UL',
                                      '1',
                                      'ROI Shape Points Space',
                                      ''),
                         '0029xx30': ('FD', '1', 'ROI Shape Points', ''),
                         '0029xx31': ('UL',
                                      '1',
                                      'ROI Shape Control Points Count',
                                      ''),
                         '0029xx32': ('UL',
                                      '1',
                                      'ROI Shape Control Points Space',
                                      ''),
                         '0029xx33': ('FD',
                                      '1',
                                      'ROI Shape Control Points',
                                      ''),
                         '0029xx34': ('UL', '1', "ROI Don't Save", '')},
 'Silhouette Sequence Ids V1.0': {'0029xx41': ('SQ', '1', 'Unknown', ''),
                                  '0029xx42': ('SQ', '1', 'Unknown', ''),
                                  '0029xx43': ('SQ', '1', 'Unknown', '')},
 'Silhouette V1.0': {'0029xx13': ('UL', '1', 'Unknown', ''),
                     '0029xx14': ('UL', '1', 'Unknown', ''),
                     '0029xx17': ('UN', '1', 'Unknown', ''),
                     '0029xx18': ('UN', '1', 'Unknown', ''),
                     '0029xx19': ('UL', '1', 'Unknown', ''),
                     '0029xx1a': ('UN', '1', 'Unknown', ''),
                     '0029xx1b': ('UL', '1', 'Unknown', ''),
                     '0029xx1c': ('UL', '1', 'Unknown', ''),
                     '0029xx1d': ('UN', '1', 'Unknown', ''),
                     '0029xx1e': ('UN', '1', 'Unknown', ''),
                     '0029xx21': ('US', '1', 'Unknown', ''),
                     '0029xx22': ('US', '1', 'Unknown', ''),
                     '0029xx23': ('US', '1', 'Unknown', ''),
                     '0029xx24': ('US', '1', 'Unknown', ''),
                     '0029xx25': ('US', '1', 'Unknown', ''),
                     '0029xx27': ('UN', '1', 'Unknown', ''),
                     '0029xx28': ('UN', '1', 'Unknown', ''),
                     '0029xx29': ('UN', '1', 'Unknown', ''),
                     '0029xx30': ('UN', '1', 'Unknown', ''),
                     '0029xx52': ('US', '1', 'Unknown', ''),
                     '0029xx53': ('LT', '1', 'Unknown', ''),
                     '0029xx54': ('UN', '1', 'Unknown', ''),
                     '0029xx55': ('LT', '1', 'Unknown', ''),
                     '0029xx56': ('LT', '1', 'Unknown', ''),
                     '0029xx57': ('UN', '1', 'Unknown', '')},
 'Silhouette VRS 3.0': {'0029xx13': ('UN', '1', 'Unknown', ''),
                        '0029xx14': ('UN', '1', 'Unknown', ''),
                        '0029xx17': ('UN', '1', 'Unknown', ''),
                        '0029xx18': ('UN', '1', 'Unknown', ''),
                        '0029xx19': ('UN', '1', 'Unknown', ''),
                        '0029xx1a': ('UN', '1', 'Unknown', ''),
                        '0029xx1b': ('UN', '1', 'Unknown', ''),
                        '0029xx1c': ('UN', '1', 'Unknown', ''),
                        '0029xx1d': ('UN', '1', 'Unknown', ''),
                        '0029xx1e': ('UN', '1', 'Unknown', ''),
                        '0029xx27': ('US', '1', 'Unknown', ''),
                        '0029xx28': ('UN', '1', 'Unknown', ''),
                        '0029xx30': ('UN', '1', 'Unknown', ''),
                        '0029xx32': ('UN', '1', 'Unknown', ''),
                        '0029xx34': ('UN', '1', 'Unknown', ''),
                        '0029xx35': ('CS', '1', 'Unknown', ''),
                        '0029xx36': ('US', '1', 'Unknown', '')},
 'Sound Technologies': {'f001xx00': ('CS', '1', 'Patient Species', ''),
                        'f001xx01': ('CS', '1', 'Patient Breed', ''),
                        'f001xx02': ('CS', '1', 'Patient Category Size', ''),
                        'f001xx03': ('CS',
                                     '1',
                                     'Patient Sex Extended (including spay/neuter)',
                                     ''),
                        'f001xx04': ('CS', '1', 'Image View', ''),
                        'f001xx05': ('CS', '1', 'Anatomy Imaged', ''),
                        'f001xx06': ('CS', '1', 'Image enhancements', ''),
                        'f001xx07': ('CS', '1', 'Detector Settings', ''),
                        'f001xx08': ('CS', '1', 'Application Version', ''),
                        'f001xx09': ('LO',
                                     '1',
                                     'Image Laterality 3Extended',
                                     ''),
                        'f001xx0a': ('PN', '1', 'Client Name', ''),
                        'f001xx0b': ('UI',
                                     '1',
                                     'Reference Study Instance Uid',
                                     ''),
                        'f001xx0c': ('UI',
                                     '1',
                                     'Reference Series Instance Uid',
                                     ''),
                        'f001xx0d': ('LO', '1', 'Exam Ref Id', ''),
                        'f001xx0e': ('ST',
                                     '1',
                                     'Physician Of Record Address',
                                     ''),
                        'f001xx0f': ('SH',
                                     '1',
                                     'Physician Of Record Phone Numbers',
                                     ''),
                        'f001xx10': ('LT', '1', 'Reason For Study', ''),
                        'f001xx11': ('LO', '1', 'Protocol', ''),
                        'f001xx12': ('LO', '1', 'CaptureInputType', ''),
                        'f001xx13': ('LT', '1', 'Exam Complaint', ''),
                        'f001xx14': ('LO', '1', 'Exam Web Code', ''),
                        'f001xx15': ('LO', '1', 'Exam Category', ''),
                        'f001xx16': ('SH', '1', 'Exam Diagnosis', ''),
                        'f001xx17': ('PN', '1', 'Exam Created By', ''),
                        'f001xx18': ('LO', '1', 'Exam Created By Group', ''),
                        'f001xx19': ('DT',
                                     '1',
                                     'Exam Required By DateTime',
                                     ''),
                        'f001xx1a': ('LO', '1', 'Capture Type', ''),
                        'f001xx1b': ('IS', '1', 'Telemed Exam ID', ''),
                        'f001xx1c': ('LO', '1', 'Exam Created By Guid', ''),
                        'f001xx1d': ('LO', '1', 'Client Name Guid', '')},
 'TMDTK': {'7effxx21': ('SQ', '1', 'Unknown', ''),
           '7effxx2e': ('LT', '1', 'Unknown', '')},
 'TOSHIBA COMAPL HEADER': {'0029xx08': ('CS', '1', 'COMAPL Header Type', ''),
                           '0029xx09': ('LO',
                                        '1',
                                        'COMAPL Header Version',
                                        ''),
                           '0029xx10': ('LO', '1', '', ''),
                           '0029xx20': ('OB',
                                        '1',
                                        'COMAPL History Information',
                                        ''),
                           '0029xx31': ('LO', '1-n', '', ''),
                           '0029xx32': ('UL', '1-n', '', ''),
                           '0029xx33': ('UL', '1-n', '', ''),
                           '0029xx34': ('CS', '1-n', '', '')},
 'TOSHIBA COMAPL OOG': {'0029xx08': ('CS', '1', 'COMAPL OOG Type', ''),
                        '0029xx09': ('LO', '1', 'COMAPL OOG Version', ''),
                        '0029xx10': ('LO', '1', '', ''),
                        '0029xx31': ('LO', '1-n', '', ''),
                        '0029xx32': ('UL', '1-n', '', ''),
                        '0029xx33': ('UL', '1-n', '', ''),
                        '0029xx34': ('CS', '1-n', '', '')},
 'TOSHIBA ENCRYPTED SR DATA': {'7015xx00': ('OB',
                                            '1',
                                            'Toshiba US Private Data',
                                            '')},
 'TOSHIBA MDW HEADER': {'0029xx08': ('CS',
                                     '1',
                                     'Application Header Type',
                                     ''),
                        '0029xx09': ('LO',
                                     '1',
                                     'Application Header Version',
                                     ''),
                        '0029xx10': ('CS', '1', 'Image Header Type', ''),
                        '0029xx11': ('LO', '1', 'Image Header Version', ''),
                        '0029xx12': ('OB', '1', 'Image Header Info', ''),
                        '0029xx18': ('CS', '1', 'Series Header Type', ''),
                        '0029xx19': ('LO', '1', 'Series Header Version', ''),
                        '0029xx20': ('OB', '1', 'Series Header Info', ''),
                        '0029xx31': ('LO', '1', 'PMTF Information 1', ''),
                        '0029xx32': ('UL', '1', 'PMTF Information 2', ''),
                        '0029xx33': ('UL', '1', 'PMTF Information 3', ''),
                        '0029xx34': ('CS', '1', 'PMTF Information 4', '')},
 'TOSHIBA MDW NON-IMAGE': {'0029xx08': ('CS',
                                        '1',
                                        'Application Header Type',
                                        ''),
                           '0029xx09': ('LO',
                                        '1',
                                        'Application Header Version',
                                        ''),
                           '0029xx10': ('OB',
                                        '1',
                                        'Application Header Data',
                                        ''),
                           '0029xx20': ('OB',
                                        '1',
                                        'Application Header Data',
                                        ''),
                           '7fe1xx10': ('OB',
                                        '1',
                                        'Toshiba US Private Data',
                                        '')},
 'TOSHIBA_MEC_1.0': {'0009xx01': ('LT', '1', 'Unknown', ''),
                     '0009xx02': ('US', '1-n', 'Unknown', ''),
                     '0009xx03': ('US', '1-n', 'Unknown', ''),
                     '0009xx04': ('US', '1-n', 'Unknown', ''),
                     '0011xx01': ('LT', '1', 'Unknown', ''),
                     '0011xx02': ('US', '1-n', 'Unknown', ''),
                     '0019xx01': ('US', '1-n', 'Unknown', ''),
                     '0019xx02': ('US', '1-n', 'Unknown', ''),
                     '0021xx01': ('US', '1-n', 'Unknown', ''),
                     '0021xx02': ('US', '1-n', 'Unknown', ''),
                     '0021xx03': ('US', '1-n', 'Unknown', ''),
                     '7ff1xx01': ('US', '1-n', 'Unknown', ''),
                     '7ff1xx02': ('US', '1-n', 'Unknown', ''),
                     '7ff1xx03': ('US', '1-n', 'Unknown', ''),
                     '7ff1xx10': ('US', '1-n', 'Unknown', '')},
 'TOSHIBA_MEC_CT3': {'7005xx00': ('OB', '1-n', 'CT Private Data 1', ''),
                     '7005xx03': ('SH', '1', 'Cardiac R-R Mean Time', ''),
                     '7005xx04': ('SH',
                                  '1',
                                  'Cardiac Reconstruction Gating Phase in Percent',
                                  ''),
                     '7005xx05': ('SH',
                                  '1',
                                  'Cardiac Reconstruction Gating Phase in ms',
                                  ''),
                     '7005xx06': ('SH',
                                  '1',
                                  'Cardiac Reconstruction Mode',
                                  ''),
                     '7005xx07': ('DS', '2', 'Reconstruction Center', ''),
                     '7005xx08': ('DS',
                                  '1',
                                  'Detector Slice Thickness in mm',
                                  ''),
                     '7005xx09': ('LO',
                                  '1',
                                  'Number of Detector rows to Reconstruct',
                                  ''),
                     '7005xx0a': ('DS', '1', 'Table Speed in mm/rot', ''),
                     '7005xx0b': ('SH', '1', 'Filter', ''),
                     '7005xx0c': ('SH',
                                  '1',
                                  'Reconstruction Correction Type',
                                  ''),
                     '7005xx0d': ('CS', '1', 'Organ', ''),
                     '7005xx0e': ('SH', '1', 'File Type Remarks', ''),
                     '7005xx0f': ('SH', '1', 'Direction', ''),
                     '7005xx10': ('OB', '1-n', 'CT Private Data 2', ''),
                     '7005xx11': ('LT', '1', 'Series Comment', ''),
                     '7005xx12': ('SH', '1', 'Position', ''),
                     '7005xx13': ('US', '1', 'Expert Plan No.', ''),
                     '7005xx14': ('US', '1', 'Reconstruction ROI No.', ''),
                     '7005xx15': ('US', '1', 'Special Helical ACQ No.', ''),
                     '7005xx16': ('UI', '1', 'Volume UID', ''),
                     '7005xx17': ('US',
                                  '1',
                                  'Total Frame Count in the Volume',
                                  ''),
                     '7005xx18': ('US', '1', 'Frame No.', ''),
                     '7005xx19': ('UL', '1', 'Frame Sort Key', ''),
                     '7005xx1a': ('US', '1', 'Frame Sort Order', ''),
                     '7005xx1b': ('SH', '1', 'Convolution Kernel', ''),
                     '7005xx1c': ('LO', '1', 'Contrast/Bolus Agent', ''),
                     '7005xx1d': ('UL', '1', 'Reconstruction Number', ''),
                     '7005xx1e': ('UL', '1', 'Raw Data Number', ''),
                     '7005xx1f': ('LO', '1', 'Volume Number', ''),
                     '7005xx20': ('UL', '1', 'Local Series Number', ''),
                     '7005xx21': ('LO',
                                  '1',
                                  'Decrease in Artifact Filter',
                                  ''),
                     '7005xx22': ('DS', '1', 'Reconstruction Interval', ''),
                     '7005xx23': ('DS', '1', 'Pitch Factor', ''),
                     '7005xx24': ('DA',
                                  '1',
                                  'The Acquisition Date of NRA',
                                  ''),
                     '7005xx25': ('UL', '1', 'Large Data File Attribute', ''),
                     '7005xx26': ('CS', '1-8', 'Large Data File Name', ''),
                     '7005xx28': ('SQ',
                                  '1',
                                  'Enhanced CT Private Sequence',
                                  ''),
                     '7005xx29': ('UI', '1', 'Frame UID', ''),
                     '7005xx30': ('CS', '1', 'Main Modality in Study', ''),
                     '7005xx35': ('DS', '2', 'Scan Range', ''),
                     '7005xx36': ('OB', '1-n', 'CT Private Data 3', ''),
                     '7005xx37': ('IS', '1', 'Total Frames', ''),
                     '7005xx38': ('IS', '1', 'Start Frame', ''),
                     '7005xx39': ('IS', '1', 'End Frame', ''),
                     '7005xx40': ('FD', '1', 'DLP Dose Length Product', ''),
                     '7005xx41': ('SH', '1', 'Raw Slice Information', ''),
                     '7005xx42': ('US', '1', 'Local Frame No', ''),
                     '7005xx43': ('DS', '3', 'Volume Vector', ''),
                     '7005xx44': ('US', '1', 'Volume Type', ''),
                     '7005xx45': ('DS',
                                  '1',
                                  'Relative Table Position of 4D Volume',
                                  ''),
                     '7005xx46': ('DS',
                                  '1',
                                  'Absolute Table Position of 4D Volume',
                                  ''),
                     '7005xx47': ('DS', '1', 'Slice Pitch of 4D Volume', ''),
                     '7005xx48': ('LO', '1', 'Respiratory Gating Inf.', ''),
                     '7005xx49': ('SH', '1', 'Respiration Phase', ''),
                     '7005xxf1': ('CS',
                                  '1',
                                  'Protect Mark for Image, Curve or Private Record',
                                  ''),
                     '7005xxf2': ('CS',
                                  '1',
                                  'Protect Mark for Series Record',
                                  ''),
                     '7005xxf3': ('CS',
                                  '1',
                                  'Protect Mark for Study Record',
                                  '')},
 'TOSHIBA_MEC_CT_1.0': {'0019xx01': ('IS', '1', 'Unknown', ''),
                        '0019xx02': ('IS', '1', 'Unknown', ''),
                        '0019xx03': ('US', '1-n', 'Unknown', ''),
                        '0019xx04': ('LT', '1', 'Unknown', ''),
                        '0019xx05': ('LT', '1', 'Unknown', ''),
                        '0019xx06': ('US', '1-n', 'Unknown', ''),
                        '0019xx07': ('US', '1-n', 'Unknown', ''),
                        '0019xx08': ('LT', '1', 'Orientation Head Feet', ''),
                        '0019xx09': ('LT', '1', 'View Direction', ''),
                        '0019xx0a': ('LT',
                                     '1',
                                     'Orientation Supine Prone',
                                     ''),
                        '0019xx0b': ('DS', '1', 'Location', ''),
                        '0019xx0c': ('CS', '1', 'Scan View Direction', ''),
                        '0019xx0d': ('TM', '1', 'Time', ''),
                        '0019xx0e': ('DS', '1', 'Unknown', ''),
                        '7ff1xx01': ('US', '1-n', 'Unknown', ''),
                        '7ff1xx02': ('US', '1-n', 'Unknown', ''),
                        '7ff1xx03': ('IS', '1', 'Unknown', ''),
                        '7ff1xx04': ('IS', '1', 'Unknown', ''),
                        '7ff1xx05': ('US', '1-n', 'Unknown', ''),
                        '7ff1xx07': ('US', '1-n', 'Unknown', ''),
                        '7ff1xx08': ('US', '1-n', 'Unknown', ''),
                        '7ff1xx09': ('US', '1-n', 'Unknown', ''),
                        '7ff1xx0a': ('LT', '1', 'Unknown', ''),
                        '7ff1xx0b': ('US', '1-n', 'Unknown', ''),
                        '7ff1xx0c': ('US', '1-n', 'Unknown', ''),
                        '7ff1xx0d': ('US', '1-n', 'Unknown', '')},
 'TOSHIBA_MEC_MR3': {'700dxx00': ('DS', '1', 'Scale Factor', ''),
                     '700dxx01': ('OB', '1', 'Acquisition Order', ''),
                     '700dxx02': ('DS', '9', 'Orientation Vector', ''),
                     '700dxx03': ('SS', '1', 'Flip Flag', ''),
                     '700dxx04': ('OB', '1', 'Rotate Information', ''),
                     '700dxx05': ('DS', '4', 'FOV', ''),
                     '700dxx06': ('US', '4', 'Image Matrix', ''),
                     '700dxx07': ('OB', '1', 'Image Information', ''),
                     '700dxx08': ('OB', '1', 'Original Data', ''),
                     '700dxx09': ('SS', '1', 'Original Data Flag', ''),
                     '700dxx80': ('US', '1', 'Number of PAC channel', ''),
                     '700dxx81': ('US', '1', 'Reference mode', ''),
                     '700dxx82': ('SQ', '1', 'Gain value group for MRS', ''),
                     '700dxx83': ('FL',
                                  '1',
                                  'Gain value of each channel for MRS',
                                  ''),
                     '700dxx84': ('FL',
                                  '1',
                                  'Phase value of each channel for MRS',
                                  ''),
                     '700dxx85': ('FL',
                                  '1',
                                  'Reference gain value of each channel for MRS',
                                  ''),
                     '700dxx86': ('FL',
                                  '1',
                                  'Reference gain value of each channel for MRS',
                                  ''),
                     '700dxx87': ('FL',
                                  '1',
                                  'Receiver gain of reference scan',
                                  ''),
                     '700dxx88': ('UL', '1', 'Flag of water Sat pulse', ''),
                     '700dxx89': ('FL', '1', 'Selected contrast TE', ''),
                     '700dxx8a': ('SQ', '1', 'Raw Data Set Sequence', ''),
                     '700dxx8b': ('DS', '1', 'Multi Slice number', ''),
                     '700dxx8c': ('DS', '1', 'Multi Coverage number', ''),
                     '700dxx8d': ('SQ', '1', 'Raw Data Sequence', ''),
                     '700dxx8e': ('DS', '1', 'Coil Channel No.', ''),
                     '700dxx8f': ('OB', '1', 'MRS Raw Data', ''),
                     '700dxx90': ('OF', '1', 'MRS Ref Raw Data', ''),
                     '700dxx91': ('FL', '1', 'Receiver gain of prescan', '')},
 'TOSHIBA_MEC_OT3': {'0009xx00': ('LO', '1', 'HIS/RIS Study ID', ''),
                     '7019xx71': ('CS', '1', 'Indicator of creator', ''),
                     '7019xx72': ('LO',
                                  '1',
                                  'ID of quality assurance reviewer',
                                  ''),
                     '7019xx73': ('PN',
                                  '1',
                                  'Name of quality assurance reviewer',
                                  ''),
                     '7019xx74': ('DA',
                                  '1',
                                  'Date of completion of quality assurance',
                                  ''),
                     '7019xx75': ('TM',
                                  '1',
                                  'Time of completion of quality assurance',
                                  ''),
                     '7019xx76': ('LO',
                                  '1',
                                  'Host name of quality assurance station',
                                  ''),
                     '7019xx77': ('CS',
                                  '1',
                                  'Station name and version of quality assurance station',
                                  ''),
                     '7019xx78': ('CS',
                                  '1',
                                  'Flag of completion of quality assurance',
                                  ''),
                     '7019xx79': ('CS',
                                  '1',
                                  'Status of quality assurance review',
                                  ''),
                     '7019xx7a': ('UI', '1', 'Original SOP Instance UID', ''),
                     '7019xx7b': ('UI',
                                  '1',
                                  'Original Series Instance UID',
                                  ''),
                     '7019xx7c': ('UI',
                                  '1',
                                  'Original Study Instance UID',
                                  ''),
                     '7019xx7d': ('US',
                                  '1',
                                  'Rotation information for image display from original image',
                                  ''),
                     '7019xx7e': ('SQ', '1', 'Sequence of LR mark', ''),
                     '7019xx7f': ('US',
                                  '1',
                                  'Rotation status at creation of LR mark',
                                  ''),
                     '7019xx80': ('OB_OW',
                                  '1',
                                  'Original image data on area of original LR mark',
                                  ''),
                     '7019xx81': ('SS',
                                  '1',
                                  'X start position of LR mark',
                                  ''),
                     '7019xx82': ('SS',
                                  '1',
                                  'Y start position of LR mark',
                                  ''),
                     '7019xx83': ('US',
                                  '1',
                                  'Size of LR mark in X direction',
                                  ''),
                     '7019xx84': ('US',
                                  '1',
                                  'Size of LR mark in Y direction',
                                  ''),
                     '7019xx85': ('LO', '1', 'Previous Patient ID', ''),
                     '7019xx86': ('CS', '1', 'Previous modality', '')},
 'TOSHIBA_MEC_XA3': {'7079xx10': ('LO', '1', '', ''),
                     '7079xx21': ('SH', '5', '', ''),
                     '7079xx22': ('IS', '2', '', ''),
                     '7079xx23': ('IS', '2', '', ''),
                     '7079xx24': ('DS', '1', '', ''),
                     '7079xx25': ('SH', '1', '', ''),
                     '7079xx26': ('DS', '2', '', ''),
                     '7079xx27': ('US', '2', '', ''),
                     '7079xx28': ('US', '1', '', ''),
                     '7079xx29': ('US', '10', '', ''),
                     '7079xx2a': ('US', '5', '', ''),
                     '7079xx2b': ('UN', '1', '', ''),
                     '7079xx2c': ('SH', '3', '', ''),
                     '7079xx2d': ('SS', '2', '', ''),
                     '7079xx2e': ('SH', '1', '', ''),
                     '7079xx2f': ('SH', '1', '', ''),
                     '7079xx30': ('US', '1', '', ''),
                     '7079xx31': ('US', '1-n', '', ''),
                     '7079xx32': ('SH', '2', '', ''),
                     '7079xx33': ('US', '1-n', '', ''),
                     '7079xx34': ('SH', '1', '', ''),
                     '7079xx35': ('SH', '1', '', ''),
                     '7079xx36': ('SH', '1', '', ''),
                     '7079xx37': ('US', '4', '', ''),
                     '7079xx38': ('SS', '1-n', '', ''),
                     '7079xx39': ('SS', '1-n', '', ''),
                     '7079xx3a': ('US', '2', '', ''),
                     '7079xx3b': ('SH', '1', '', ''),
                     '7079xx3c': ('DS', '2', '', ''),
                     '7079xx3d': ('SS', '2', '', ''),
                     '7079xx3e': ('SH', '1', '', ''),
                     '7079xx3f': ('US', '2', '', ''),
                     '7079xx40': ('SH', '2', '', ''),
                     '7079xx41': ('SS', '2', '', ''),
                     '7079xx42': ('SH', '1', '', ''),
                     '7079xx43': ('SH', '1', '', ''),
                     '7079xx44': ('US', '1', '', ''),
                     '7079xx45': ('SH', '1', '', ''),
                     '7079xx46': ('SS', '1', '', ''),
                     '7079xx47': ('SS', '18', '', ''),
                     '7079xx48': ('US', '12', '', ''),
                     '7079xx49': ('US', '3', '', ''),
                     '7079xx4a': ('US', '1', '', ''),
                     '7079xx4b': ('LO', '3', '', ''),
                     '7079xx4c': ('OB', '1', '', ''),
                     '7079xx4d': ('LO', '3', '', ''),
                     '7079xx4e': ('SL', '35', '', ''),
                     '7079xx4f': ('SH', '3', '', ''),
                     '7079xx50': ('US', '1-n', '', ''),
                     '7079xx51': ('US', '1-n', '', ''),
                     '7079xx52': ('US', '1', '', ''),
                     '7079xx53': ('SH', '1', '', ''),
                     '7079xx54': ('US', '5', '', ''),
                     '7079xx55': ('UL', '47-47n', '', ''),
                     '7079xx56': ('US', '1', '', ''),
                     '7079xx57': ('US', '1-n', '', ''),
                     '7079xx58': ('US', '1', '', ''),
                     '7079xx59': ('US', '2-2n', '', ''),
                     '7079xx5a': ('US', '1', '', ''),
                     '7079xx5b': ('US', '2', '', ''),
                     '7079xx5c': ('US', '2-2n', '', ''),
                     '7079xx5d': ('SH', '1', '', ''),
                     '7079xx5e': ('US', '2', '', ''),
                     '7079xx5f': ('SS', '4-4n', '', ''),
                     '7079xx60': ('US', '1-n', '', ''),
                     '7079xx61': ('SS', '30-30n', '', ''),
                     '7079xx62': ('US', '4', '', ''),
                     '7079xx63': ('US', '1-n', '', ''),
                     '7079xx64': ('US', '1-n', '', ''),
                     '7079xx65': ('US', '1-n', '', ''),
                     '7079xx66': ('US', '1-n', '', ''),
                     '7079xx67': ('US', '1-n', '', ''),
                     '7079xx68': ('US', '1-n', '', ''),
                     '7079xx69': ('US', '1-n', '', ''),
                     '7079xx6a': ('US', '1-n', '', ''),
                     '7079xx6b': ('US', '1-n', '', ''),
                     '7079xx6c': ('US', '1', '', ''),
                     '7079xx6d': ('DS', '1', '', ''),
                     '7079xx6e': ('LO', '1', '', ''),
                     '7079xx6f': ('DS', '1', '', ''),
                     '7079xx70': ('DS', '1', '', ''),
                     '7079xx71': ('DS', '1-n', '', ''),
                     '7079xx72': ('DS', '1-n', '', ''),
                     '7079xx73': ('SL', '4', '', ''),
                     '7079xx74': ('SL', '28', '', ''),
                     '7079xx75': ('SH', '1', '', ''),
                     '7079xx76': ('US', '1', '', ''),
                     '7079xx77': ('SL', '1', '', ''),
                     '7079xx78': ('US', '1', '', ''),
                     '7079xx79': ('US', '1', '', ''),
                     '7079xx7b': ('SH', '1', 'Unknown', ''),
                     '7079xx80': ('LO', '1', '', ''),
                     '7079xx81': ('SS', '1-n', '', ''),
                     '7079xx82': ('SS', '1-n', '', '')},
 'TOSHIBA_SR': {'7015xx10': ('OB', '1', 'Unknown', ''),
                '7015xx60': ('OB', '1', 'Unknown', '')},
 'V1': {'0011xx01': ('OB', '1', 'User Data', ''),
        '0011xx02': ('DS', '1', 'Normalization Coefficient', ''),
        '0011xx03': ('DS', '1-n', 'Receiving Gain', ''),
        '0011xx04': ('DS', '1', 'Mean Image Noise', '')},
 'Varian Medical Systems VISION 3253': {'3253xx00': ('UN',
                                                     '1',
                                                     'XML stream.',
                                                     ''),
                                        '3253xx01': ('UN',
                                                     '1',
                                                     'Data length of the XML stream',
                                                     ''),
                                        '3253xx02': ('UN',
                                                     '1',
                                                     'Extended Interface Format tag',
                                                     '')},
 'Viewing Protocol': {'0065xx93': ('CS', '1', 'Unknown', '')},
 'Vital Images SW 3.4': {'5653xx10': ('OB', '1', 'Saved Workflow', ''),
                         '5653xx11': ('LO',
                                      '1',
                                      'Saved Workflow File Name',
                                      ''),
                         '5653xx12': ('OB',
                                      '1',
                                      'Saved Workflow File Data',
                                      ''),
                         '5653xx13': ('SL',
                                      '1',
                                      'Saved Workflow File Length',
                                      ''),
                         '5653xx14': ('SQ',
                                      '1',
                                      'Saved Workflow File Sequence',
                                      ''),
                         '5653xx15': ('SQ', '1', 'Image Sequence', ''),
                         '5653xx16': ('SL',
                                      '1',
                                      'Volume Interpolated Slices',
                                      ''),
                         '5653xx17': ('UI',
                                      '1',
                                      'Volume SOP Instance UID',
                                      ''),
                         '5653xx18': ('SH', '1', 'Saved Workflow Mark', ''),
                         '5653xx19': ('UI', '1', 'Unknown', ''),
                         '5653xx22': ('UI', '1', 'Unknown', ''),
                         '5653xx23': ('LO', '1', 'Unknown', '')},
 'Voxar 2.16.124.113543.6003.1999.12.20.12.5.0': {'1135xx00': ('UI',
                                                               '1',
                                                               'Private Voxar Capture UID',
                                                               ''),
                                                  '1135xx01': ('OB',
                                                               '1',
                                                               'Private Voxar Saved State',
                                                               ''),
                                                  '1135xx02': ('SQ',
                                                               '1',
                                                               'Private Voxar Icon Image Sequence',
                                                               ''),
                                                  '1135xx03': ('ST',
                                                               '1',
                                                               'Private Voxar Top Right Display Demographics',
                                                               ''),
                                                  '1135xx04': ('ST',
                                                               '1',
                                                               'Private Voxar Bottom Left Display Demographics',
                                                               ''),
                                                  '1135xx05': ('IS',
                                                               '1',
                                                               'Private Voxar Span State Schema',
                                                               ''),
                                                  '1135xx06': ('UL',
                                                               '1',
                                                               'Private Voxar Live Image Restored Size',
                                                               ''),
                                                  '1135xx07': ('UI',
                                                               '1',
                                                               'Private Voxar CaptureType',
                                                               ''),
                                                  '1135xx08': ('SQ',
                                                               '1',
                                                               'Private Voxar Capture Source Series UID Sequence',
                                                               ''),
                                                  '1135xx09': ('UI',
                                                               '1',
                                                               'Private Voxar Capture Source Series UID',
                                                               ''),
                                                  '1135xx10': ('IS',
                                                               '1',
                                                               'Private Voxar Background Gray For Capture',
                                                               ''),
                                                  '1135xx11': ('IS',
                                                               '1',
                                                               'Private Voxar Calcium Scoring Report Schema',
                                                               ''),
                                                  '1135xx12': ('IS',
                                                               '1',
                                                               'Private Voxar Source Series Number',
                                                               ''),
                                                  '1135xx13': ('LO',
                                                               '1',
                                                               'Private Voxar Bottom Left Display Demographics',
                                                               '')},
 'WG12 Supplement 43': {'0009xx01': ('SQ', '1', 'Event Timer Sequence', ''),
                        '0009xx02': ('FD', '1', 'Event Time Interval', ''),
                        '0009xx03': ('SQ', '1', 'Event Code Sequence', ''),
                        '0019xx01': ('FD', '1', 'Focus Depth(s)', ''),
                        '0019xx03': ('SQ',
                                     '1',
                                     'Excluded Intervals Sequence',
                                     ''),
                        '0019xx04': ('DT',
                                     '1',
                                     'Exclusion Start Datetime',
                                     ''),
                        '0019xx05': ('FD', '1', 'Exclusion Duration', ''),
                        '0019xx06': ('SQ',
                                     '1',
                                     'US Image Description Sequence',
                                     ''),
                        '0019xx07': ('SQ',
                                     '1',
                                     'Image Data Type Sequence',
                                     ''),
                        '0019xx08': ('CS', '1', 'Data Type', ''),
                        '0019xx09': ('SQ',
                                     '1',
                                     'Transducer Scan Geometry Code Sequence',
                                     ''),
                        '0019xx0b': ('CS', '1', 'Aliased Data Type', ''),
                        '0019xx0c': ('CS',
                                     '1',
                                     'Position Measuring Device Used',
                                     ''),
                        '0019xx0d': ('SQ',
                                     '1',
                                     'Transducer Scanning Configuration Code Sequence',
                                     ''),
                        '0019xx0e': ('SQ',
                                     '1',
                                     'Transducer Beam Steering Code Sequence',
                                     ''),
                        '0019xx0f': ('SQ',
                                     '1',
                                     'Transducer Access Code Sequence',
                                     ''),
                        '0021xx01': ('FD',
                                     '1',
                                     'Image Position (Volume)',
                                     ''),
                        '0021xx02': ('FD',
                                     '1',
                                     'Image Orientation (Volume)',
                                     ''),
                        '0021xx07': ('CS',
                                     '1',
                                     'Ultrasound Acquisition Geometry',
                                     ''),
                        '0021xx08': ('FD', '1', 'Apex Position', ''),
                        '0021xx09': ('FD',
                                     '1',
                                     'Volume to Transducer Mapping Matrix',
                                     ''),
                        '0021xx0a': ('FD',
                                     '1',
                                     'Volume to Table Mapping Matrix',
                                     ''),
                        '0021xx0c': ('CS',
                                     '1',
                                     'Patient Frame of Reference Source',
                                     ''),
                        '0021xx0d': ('FD',
                                     '1',
                                     'Temporal Position Time Offset',
                                     ''),
                        '0021xx0e': ('SQ',
                                     '1',
                                     'Plane Position (Volume) Sequence',
                                     ''),
                        '0021xx0f': ('SQ',
                                     '1',
                                     'Plane Orientation (Volume) Sequence',
                                     ''),
                        '0021xx10': ('SQ',
                                     '1',
                                     'Temporal Position Sequence',
                                     ''),
                        '0021xx11': ('CS',
                                     '1',
                                     'Dimension Organization Type',
                                     ''),
                        '0029xx01': ('SQ',
                                     '1',
                                     'Data Frame Assignment Sequence',
                                     ''),
                        '0029xx02': ('CS', '1', 'Data Path Assignment', ''),
                        '0029xx03': ('US',
                                     '1',
                                     'Bits Mapped to Color Lookup Table',
                                     ''),
                        '0029xx04': ('SQ', '1', 'Opacity 1 LUT Sequence', ''),
                        '0029xx05': ('CS',
                                     '1',
                                     'Opacity 1 LUT Transfer Function',
                                     ''),
                        '0029xx06': ('FD', '1', 'Opacity Constant', ''),
                        '0029xx07': ('US',
                                     '1',
                                     'Opacity Lookup Table Descriptor',
                                     ''),
                        '0029xx08': ('OW',
                                     '1',
                                     'Opacity Lookup Table Data',
                                     ''),
                        '0029xx0b': ('SQ',
                                     '1',
                                     'Enhanced Palette Color Lookup Table Sequence',
                                     ''),
                        '0029xx0c': ('SQ', '1', 'Opacity 2 LUT Sequence', ''),
                        '0029xx0d': ('CS',
                                     '1',
                                     'Opacity 2 LUT Transfer Function',
                                     ''),
                        '0029xx0e': ('CS', '1', 'Data Path ID', ''),
                        '0029xx0f': ('CS',
                                     '1',
                                     'RGB LUT Transfer Function',
                                     ''),
                        '0029xx10': ('CS',
                                     '1',
                                     'Alpha LUT Transfer Function',
                                     ''),
                        '0041xx01': ('CS',
                                     '1',
                                     'Performed Protocol Type',
                                     '')},
 'http://www.gemedicalsystems.com/it_solutions/bamwallthickness/1.0': {'3119xx10': ('DT',
                                                                                    '1',
                                                                                    'BAM WallThickness Session Date/Time',
                                                                                    ''),
                                                                       '3119xx20': ('PN',
                                                                                    '1',
                                                                                    'BAM WallThickness Session Creator',
                                                                                    ''),
                                                                       '3119xx30': ('CS',
                                                                                    '1',
                                                                                    'BAM WallThickness Session Completion Flag',
                                                                                    ''),
                                                                       '3119xx40': ('SQ',
                                                                                    '1',
                                                                                    'BAM WallThickness File Sequence',
                                                                                    ''),
                                                                       '3119xx50': ('ST',
                                                                                    '1',
                                                                                    'BAM WallThickness File Name',
                                                                                    ''),
                                                                       '3119xx60': ('OB',
                                                                                    '1',
                                                                                    'BAM WallThickness File Content',
                                                                                    '')},
 'http://www.gemedicalsystems.com/it_solutions/orthoview/2.1': {'3117xx10': ('DT',
                                                                             '1',
                                                                             'OrthoView Session Date/Time',
                                                                             ''),
                                                                '3117xx20': ('PN',
                                                                             '1',
                                                                             'OrthoView Session Creator',
                                                                             ''),
                                                                '3117xx30': ('CS',
                                                                             '1',
                                                                             'OrthoView Session Completion Flag',
                                                                             ''),
                                                                '3117xx40': ('SQ',
                                                                             '1',
                                                                             'OrthoView File Sequence',
                                                                             ''),
                                                                '3117xx50': ('ST',
                                                                             '1',
                                                                             'OrthoView File Name',
                                                                             ''),
                                                                '3117xx60': ('OB',
                                                                             '1',
                                                                             'OrthoView File Content',
                                                                             '')},
 'http://www.gemedicalsystems.com/it_solutions/rad_pacs/': {'3115xx01': ('UT',
                                                                         '1',
                                                                         'Reference to pacs study',
                                                                         ''),
                                                            '3115xx02': ('UT',
                                                                         '1',
                                                                         'Reference to pacs image',
                                                                         ''),
                                                            '3115xx03': ('CS',
                                                                         '1',
                                                                         'Pacs examnotes flag',
                                                                         '')},
 'syngoDynamics': {'0021xxae': ('OB', '1', 'Unknown', '')}}
