"""
Searchable Combobox for Contact Display Names
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: HistoryWidget.py 89 2004-09-11 18:58:51Z henning $

from Tkinter import *
import Pmw
import InputWidgets
import ToolTip
import broadcaster

class HistoryWidget(Pmw.MegaWidget):
    def __init__(self, parent = None, command = None, prevCommand = None, nextCommand = None, **kw):

        # Define the megawidget options.
        INITOPT = Pmw.INITOPT
        optiondefs = (
            ('height',         16,            INITOPT),
            ('width',          16,            INITOPT),
            ('borderwidth',    2,             INITOPT),
            ('padx',           0,             INITOPT),
            ('pady',           0,             INITOPT),
            ('sticky',         'ew',          INITOPT),
            )
        self.defineoptions(kw, optiondefs)
        
        Pmw.MegaWidget.__init__(self, parent)
        frame = self.interior()
        frame.grid(column=2,row=1, sticky=self['sticky'])

        self.btnPrev = InputWidgets.ArrowButton(frame, direction='left', command = self.prev)
        self.btnNext = InputWidgets.ArrowButton(frame, direction='right', command = self.next)

        self.btnPrev.grid(column=0, row=0)
        self.btnNext.grid(column=1, row=0)

        self.btnPrev.configure(state='disabled')
        self.btnNext.configure(state='disabled')

        self.prevCommand = prevCommand or command
        self.nextCommand = nextCommand or command

        ToolTip.ToolTip(self.btnPrev, "Go back in history")
        ToolTip.ToolTip(self.btnNext, "Go forward in history")

        self._list = []
        self._currIndex = 0
        
    def addHistory(self, item):
        # only add to history if not already present
        if len(self._list)==0 or item != self._list[-1]:
            self._list.append(item)
            if len(self._list) > 1:
                self._currIndex = len(self._list) - 1
                self.btnPrev.configure(state='normal')
    
    def prev(self):
        if self._currIndex > 0:
            self._currIndex -= 1
            if self.prevCommand is not None:
                self.prevCommand(self._list[self._currIndex])
            self.btnNext.configure(state='normal')
        if self._currIndex < 1:
            self.btnPrev.configure(state='disabled')

    def next(self):
        if self._currIndex + 1 < len(self._list):
            self._currIndex += 1
            if self.nextCommand is not None:
                self.nextCommand(self._list[self._currIndex])
            self.btnPrev.configure(state='normal')
        if self._currIndex+1 >= len(self._list):
            self.btnNext.configure(state='disabled')

    def getHistory(self):
        return self._list
    
    def configure(self, **kws):
        if kws.has_key('state'):
            self.btnPrev.configure(state=kws['state'])
            self.btnNext.configure(state=kws['state'])
            del kws['state'] 
        Pmw.MegaWidget.configure(self, **kws)
