/* $Cambridge: hermes/src/prayer/cmd/cmd_abook_import.c,v 1.4 2008/09/17 17:20:25 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

/* Import Pine format addressbook from accountd system */

void cmd_abook_import(struct session *session)
{
    struct request *request = session->request;
    struct abook *abook = session->options->abook;
    char *text;
    unsigned long count;

    /* Fetch .addressbook from account server */
    if (!(text = account_abook_get(session->account, request->pool))) {
        session_alert(session, "Unable to download addressbook file");
        session_redirect(session, request, "abook_xfer");
        return;
    }

    if (!abook_import_pine_valid(text)) {
        session_alert(session, "Invalid/Unsupported addressbook format");
        session_redirect(session, request, "abook_list");
        return;
    }

    count = abook_import_pine(abook, text);

    if (count != 1)
        session_message(session, "Imported %lu aliases", count);
    else
        session_message(session, "Imported 1 alias");

    if (count > 0)
        session->options->save = T;

    session_redirect(session, request, "abook_list");
}
