//
// MediaTypeTest.cpp
//
// $Id: //poco/1.3/Net/testsuite/src/MediaTypeTest.cpp#1 $
//
// Copyright (c) 2005-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "MediaTypeTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/Net/MediaType.h"


using Poco::Net::MediaType;


MediaTypeTest::MediaTypeTest(const std::string& name): CppUnit::TestCase(name)
{
}


MediaTypeTest::~MediaTypeTest()
{
}


void MediaTypeTest::testParse()
{
	MediaType mt1("text/plain");
	assert (mt1.getType() == "text");
	assert (mt1.getSubType() == "plain");
	assert (mt1.parameters().empty());
	
	MediaType mt2("text/xml;charset=us-ascii");
	assert (mt2.getType() == "text");
	assert (mt2.getSubType() == "xml");
	assert (!mt2.parameters().empty());
	assert (mt2.getParameter("charset") == "us-ascii");
	
	MediaType mt3("application/test; param1=value1; param2=\"value 2\"");
	assert (mt3.getType() == "application");
	assert (mt3.getSubType() == "test");
	assert (!mt3.parameters().empty());
	assert (mt3.getParameter("param1") == "value1");
	assert (mt3.getParameter("PARAM2") == "value 2");
}


void MediaTypeTest::testToString()
{
	MediaType mt1("text", "plain");
	assert (mt1.toString() == "text/plain");
	
	mt1.setParameter("charset", "iso-8859-1");
	assert (mt1.toString() == "text/plain; charset=iso-8859-1");
	
	MediaType mt2("application", "test");
	mt2.setParameter("param1", "value1");
	mt2.setParameter("param2", "value 2");
	assert (mt2.toString() == "application/test; param1=value1; param2=\"value 2\"");
}


void MediaTypeTest::testMatch()
{
	MediaType mt1("Text/Plain");
	MediaType mt2("text/plain");
	MediaType mt3("text/xml");
	assert (mt1.matches(mt2));
	assert (!mt1.matches(mt3));
	assert (mt1.matches("text"));
	assert (mt2.matches("text"));
	assert (mt3.matches("text"));
}


void MediaTypeTest::setUp()
{
}


void MediaTypeTest::tearDown()
{
}


CppUnit::Test* MediaTypeTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("MediaTypeTest");

	CppUnit_addTest(pSuite, MediaTypeTest, testParse);
	CppUnit_addTest(pSuite, MediaTypeTest, testToString);
	CppUnit_addTest(pSuite, MediaTypeTest, testMatch);

	return pSuite;
}
