.SH LIBRARY
Printer Application Framework (libpappl, "pkg-config --cflags --libs pappl")

.SH SYNOPSIS
.B #include <pappl/pappl.h>
.PP
.I typedef struct _pappl_client_s
.B pappl_client_t;
.PP
.I char *
.br
.BI papplClientGetCSRFToken "(pappl_client_t *client, char *buffer, size_t bufsize);"
.PP
.I char *
.br
.BI papplClientGetCookie "(pappl_client_t *client, const char *name, char *buffer, size_t bufsize);"
.PP
.I int
.br
.BI papplClientGetForm "(pappl_client_t *client, cups_option_t **form);"
.PP
.I const char *
.br
.BI papplClientGetHostName "(pappl_client_t *client);"
.PP
.I int
.br
.BI papplClientGetHostPort "(pappl_client_t *client);"
.PP
.I http_t *
.br
.BI papplClientGetHTTP "(pappl_client_t *client);"
.PP
.I pappl_job_t *
.br
.BI papplClientGetJob "(pappl_client_t *client);"
.PP
.I http_state_t
.br
.BI papplClientGetMethod "(pappl_client_t *client);"
.PP
.I ipp_op_t
.br
.BI papplClientGetOperation "(pappl_client_t *client);"
.PP
.I const char *
.br
.BI papplClientGetOptions "(pappl_client_t *client);"
.PP
.I pappl_printer_t *
.br
.BI papplClientGetPrinter "(pappl_client_t *client);"
.PP
.I ipp_t *
.br
.BI papplClientGetRequest "(pappl_client_t *client);"
.PP
.I ipp_t *
.br
.BI papplClientGetResponse "(pappl_client_t *client);"
.PP
.I pappl_system_t *
.br
.BI papplClientGetSystem "(pappl_client_t *client);"
.PP
.I const char *
.br
.BI papplClientGetURI "(pappl_client_t *client);"
.PP
.I const char *
.br
.BI papplClientGetUsername "(pappl_client_t *client);"
.PP
.I bool
.br
.BI papplClientHTMLAuthorize "(pappl_client_t *client);"
.PP
.I void
.br
.BI papplClientHTMLEscape "(pappl_client_t *client, const char *s, size_t slen);"
.PP
.I void
.br
.BI papplClientHTMLFooter "(pappl_client_t *client);"
.PP
.I void
.br
.BI papplClientHTMLHeader "(pappl_client_t *client, const char *title, int refresh);"
.PP
.I void
.br
.BI papplClientHTMLPrintf "(pappl_client_t *client, const char *format, ...);"
.PP
.I void
.br
.BI papplClientHTMLPuts "(pappl_client_t *client, const char *s);"
.PP
.I void
.br
.BI papplClientHTMLStartForm "(pappl_client_t *client, const char *action, bool multipart);"
.PP
.I http_status_t
.br
.BI papplClientIsAuthorized "(pappl_client_t *client);"
.PP
.I bool
.br
.BI papplClientRespond "(pappl_client_t *client, http_status_t code, const char *content_coding, const char *type, time_t last_modified, size_t length);"
.PP
.I ipp_t *
.br
.BI papplClientRespondIPP "(pappl_client_t *client, ipp_status_t status, const char *message, ...);"
.PP
.I bool
.br
.BI papplClientRespondRedirect "(pappl_client_t *client, http_status_t code, const char *path);"
.PP
.I void
.br
.BI papplClientSetCookie "(pappl_client_t *client, const char * name, const char *value, int expires);"
.PP
.I bool
.br
.BI papplClientValidateForm "(pappl_client_t *client, int num_form, cups_option_t *form);"

.SH DESCRIPTION
The
.B PAPPL
client functions provide access to client connections.
Client connections and the life cycle of the
.B pappl_client_t
objects are managed automatically by the system object for the printer application.
.PP
The
.B papplClientGet
functions get the current values for various client-supplied request data.
.SH RESPONDING TO CLIENT REQUESTS
The
.B papplClientRespond
function starts a HTTP response to a client request.
The
.B papplClientHTMLHeader
and
.B papplClientHTMLFooter
functions send standard HTML headers and footers for the printer application's configured web interface while the
.B papplClientHTMLEscape, papplClientHTMLPrintf, papplClientHTMLPuts,
and
.B papplClientHTMLStartForm
functions send HTML messages or strings.
Use the
.B papplClientGetHTTP
and (CUPS)
.B httpWrite2
functions to send arbitrary data in a client response.
Cookies can be included in web browser requests using the
.B papplClientSetCookie
function.
.PP
The
.B papplClientRespondIPP
function starts an IPP response.
Use the various CUPS
.B ippAdd
functions to add attributes to the response message.
.PP
The
.B papplClientRespondRedirect
function sends a redirection response to the client.

.SH HTML FORMS
.B PAPPL
provides the
.B papplClientGetCSRFToken, papplClientGetForm, papplClientHTMLStartForm
and
.B papplClientValidateForm
functions to securely manage HTML forms.
.PP
The
.B papplClientHTMLStartForm
function starts a HTML form and inserts a hidden variable containing a CSRF token that was generated by
.B PAPPL
from a secure session key that is periodically updated.
Upon receipt of a follow-up form submission request, the
.B papplClientGetForm
and
.B papplClientValidateForm
functions can be used to securely read the form data (including any file attachments) and validate the hidden CSRF token.

.SH AUTHENTICATION AND AUTHORIZATION
.B PAPPL
supports both user-based authentication using PAM modules and a simple cookie-based password authentication mechanism that is used to limit administrative access through the web interface.
.PP
The
.B papplHTMLAuthorize
function authorizes access to the web interface and handles displaying an authentication form on the client's web browser.
The return value indicates whether the client is authorized to access the web page.
.PP
The
.B papplIsAuthorized
function can be used to determine whether the current client is authorized to perform administrative operations and is normally only used for IPP clients.
Local users are always authorized while remote users must provide credentials (typically a username and password) for access.
This function will return an HTTP status code that can be provided to the
.B httpClientSendResponse
function.
The value
.I HTTP_STATUS_CONTINUE
indicates that authorization is granted and the request should continue.
The
.B papplGetUsername
function can be used to obtain the authenticated user identity.
