##############################################################################
#
#  WordPress Multiple Vulnerabilities - Sept08
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/12
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0192
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900219);
 script_bugtraq_id(30750, 31068, 31115);
 script_cve_id("CVE-2008-3747");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_name("WordPress Multiple Vulnerabilities");
 script_summary("Check for version of WordPress");
 desc = "
 Overview : This host is running WordPress, which is prone to multiple
 vulnerabilities.

 Vulnerability Insight :

        The flaws are due to,
                - SQL column-truncation issue.
		- Weakness in the entropy of generated passwords.
		- functions get_edit_post_link(), and get_edit_comment_link() fail
                  to use SSL when transmitting data.

        Impact : Successful exploitation will allow attackers to reset the
        password of arbitrary accounts, guess randomly generated passwords,
        obtain sensitive information and possibly to impersonate users and
        tamper with network data.

 Impact Level : Application

 Affected Software/OS :
        WordPress 2.6.1 and prior versions.

 Fix : Upgrade to WordPress 2.6.2 or later.
 http://wordpress.org/

 References :
 http://www.sektioneins.de/advisories/SE-2008-05.txt
 http://seclists.org/fulldisclosure/2008/Sep/0194.html
 http://www.juniper.net/security/auto/vulnerabilities/vuln31068.html
 http://www.juniper.net/security/auto/vulnerabilities/vuln30750.html

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.3
 Risk factor : High";

 script_description(desc);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


 include("http_func.inc");
 include("http_keepalive.inc");

 port = get_http_port(default:80);
 if(!port){
        exit(0);
 }

 foreach path (make_list("/wordpress", cgi_dirs()))
 {
        sndReq = http_get(item:string(path, "/index.php"), port:port);
        rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
        if(rcvRes == NULL){
                exit(0);
        }

	if(egrep(pattern:"Powered by WordPress", string:rcvRes) &&
           egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
        {
                if(egrep(pattern:"WordPress 2\.([0-5](\..*)?|6(\.[01])?)[^.0-9]",
                         string:rcvRes)){
                        security_hole(port);
                }
                exit(0);
        }
 }

