###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tcpdb_detect.nasl 2380 2009-05-25 10:58:24Z may $
#
# TCPDB Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900550);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("TCPDB Version Detection");
  desc = "

  Overview: This script detects the installed version of TCPDB and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of TCPDB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

wwwPort = get_http_port(default:80);
if(!wwwPort){
  exit(0);
}

foreach dir (make_list("/tcpdb", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/main.php"), port:wwwPort);
  rcvRes = http_send_recv(port:wwwPort, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if("TCPDB" >< rcvRes)
  {
    tcpdbVer = eregmatch(pattern:"TCPDB version ([0-9]\.[0-9])", string:rcvRes);
    if(tcpdbVer[1]!= NULL)
    {
      set_kb_item(name:"www/" + wwwPort + "/TCPDB", value:tcpdbVer[1] + " under " + dir);
      security_note(data:"TCPDB version " + tcpdbVer[1] + " running at " +
                         "location " + dir +  " was detected on the host");
      exit(0);
    }
  }
}
