###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_piwik_php_code_exec_vuln.nasl 6368 2009-12-29 13:19:31Z dec $
#
# Piwik PHP Code Execution Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900992);
  script_version("$Revision: 7620 $: 1.0");
  script_tag(name:"cvss_base", value:"4.6");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4140");
  script_bugtraq_id(37314);
  script_name("Piwik PHP Code Execution Vulnerability");
  desc = "
  Overview: This host is running Piwik and is prone to PHP Code Execution
  vulnerability.

  Vulnerability Insight:
  This flaw is caused due to improper validatin of data passed into 'name' and
  'HTTP_RAW_POST_DATA' parameters in ofc_upload_image.php which can be exploited
  to create php files containing malicious php code.

  Impact:
  Successful exploitation will let the remote attackers execute malicious PHP
  code to compromise the remote machine running the vulnerable application.

  Impact Level: Application

  Affected Software/OS:
  Open Flash Chart version 2 Beta 1 through 2.x
  Piwik version 0.2.35 through 0.4.3 on all platforms.

  Fix: Upgrade Piwik to 0.4.4 or higher version,
  http://piwik.org/ and for Open Flash Chart,
  No solution or patch is available as on Decemeber 29th, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://teethgrinder.co.uk/open-flash-chart/

  References:
  http://secunia.com/advisories/37078
  http://www.openwall.com/lists/oss-security/2009/12/14/1
  http://packetstormsecurity.org/0910-exploits/piwik-upload.txt

  CVSS Score:
    CVSS Base Score     : 4.6 (AV:N/AC:H/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 3.6
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for PHP file creation in Piwik");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

piwikPort = get_http_port(default:80);
if(!piwikPort){
  exit(0);
}

if(safe_checks()){
  exit(0);
}

foreach dir (make_list("/", "/piwik054", "/analytics", cgi_dirs()))
{
  sndReq = http_get(item:string(dir + "/index.php"), port:piwikPort);
  rcvRes = http_send_recv(port:piwikPort, data:sndReq);

  if("Piwik" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    request = http_get(item:string(dir+"/libs/open-flash-chart/php-ofc-library"+
                     "/ofc_upload_image.php?name=openvas.php"), port:piwikPort);
    response = http_send_recv(port:piwikPort, data:request);

    if("openvas.php" >< response && "tmp-upload-images" >< response &&
        egrep(pattern:"^HTTP/.* 200 OK", string:response))
    {
      security_warning(piwikPort);
      exit(0);
    }
  }
}
