###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_mult_vuln_dec09_lin01.nasl 6283 2009-12-21 19:02:33Z dec $
#
# Firefox Multiple Vulnerabilities Dec-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902005);
  script_version("$Revision: 8288 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3979", "CVE-2009-3981", "CVE-2009-3983", "CVE-2009-3984",
                "CVE-2009-3985", "CVE-2009-3986", "CVE-2009-3987");
  script_bugtraq_id(37361, 37363, 37366, 37367, 37370, 37365, 37360);
  script_name("Firefox Multiple Vulnerabilities Dec-09 (Linux)");
  desc = "
  Overview: The host is installed with Firefox Browser and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  For more information about vulnerabilities on Firefox, refer the links
  mentioned in references.

  Impact:
  Successful exploitation will let the attacker to conduct spoofing attacks,
  bypass certain security restrictions, manipulate certain data, disclose
  sensitive information, or compromise a user's system.

  Impact Level: Application/System

  Affected Software/OS:
  Firefox version prior to 3.0.16 on Linux.

  Fix:
  Upgrade to Firefox version 3.0.16
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://secunia.com/advisories/37699
  http://www.vupen.com/english/advisories/2009/3547
  http://www.mozilla.org/security/announce/2009/mfsa2009-65.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-68.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-69.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-70.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-71.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Firefox Check
ffVer = get_kb_item("Firefox/Linux/Ver");
if(ffVer)
{
  # Grep for Firefox version prior to 3.0.16
  if(version_is_less(version:ffVer, test_version:"3.0.16")){
    security_hole(0);
  }
}
