###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mozilla-thunderbird vulnerabilities USN-400-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840116);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.1");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "400-1");
  script_cve_id("CVE-2006-6497", "CVE-2006-6498", "CVE-2006-6499", "CVE-2006-6501", "CVE-2006-6502", "CVE-2006-6503", "CVE-2006-6505", "CVE-2006-6506");
  script_name( "Ubuntu Update for mozilla-thunderbird vulnerabilities USN-400-1");
  desc = "

  Vulnerability Insight:

  Georgi Guninski and David Bienvenu discovered that long Content-Type and
  RFC2047-encoded headers we vulnerable to heap overflows.  By tricking
  the user into opening a specially crafted email, an attacker could
  execute arbitrary code with user privileges.  (CVE-2006-6506)
  
  Various flaws have been reported that allow an attacker to execute
  arbitrary code with user privileges or bypass internal XSS protections
  by tricking the user into opening a malicious email containing
  JavaScript.  Please note that JavaScript is disabled by default for
  emails, and it is not recommended to enable it.  (CVE-2006-6497,
  CVE-2006-6498, CVE-2006-6499, CVE-2006-6501, CVE-2006-6502,
  CVE-2006-6503)

  Affected Software/OS:
  mozilla-thunderbird vulnerabilities on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-January/000460.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mozilla-thunderbird vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.9-0ubuntu0.6.06", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.9-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.9-0ubuntu0.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.9-0ubuntu0.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.9-0ubuntu0.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.9-0ubuntu0.5.10", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}