###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for freeradius MDVA-2010:031 (freeradius)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830814);
  script_version("$Revision: 7452 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2010:031");
  script_name("Mandriva Update for freeradius MDVA-2010:031 (freeradius)");
  desc = "

  Vulnerability Insight:

  Perl scripts shipped in the freeradius-web sub package use File::Temp
  perl module incorrectly, preventing to execute them correctly. In these
  perl scripts, a change was made to replace the line &quot;use File::Temp
  \;&quot; by &quot;use File::Tempqw\(tempfile tempdir\)\;&quot;.

  Affected Software/OS:
  freeradius on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00049.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of freeradius");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"freeradius", rpm:"freeradius~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-krb5", rpm:"freeradius-krb5~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-ldap", rpm:"freeradius-ldap~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-mysql", rpm:"freeradius-mysql~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-postgresql", rpm:"freeradius-postgresql~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-unixODBC", rpm:"freeradius-unixODBC~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-web", rpm:"freeradius-web~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1", rpm:"libfreeradius1~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius-devel", rpm:"libfreeradius-devel~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1", rpm:"lib64freeradius1~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius-devel", rpm:"lib64freeradius-devel~2.1.7~4.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}