###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Ignite-UX HPSBUX01219
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835114);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "01219");
  script_name( "HP-UX Update for Ignite-UX HPSBUX01219");
  desc = "

  Vulnerability Insight:
  A potential vulnerability has been identified withHP-UX running Ignite-UX 
  where the vulnerability couldbe exploited to allow a remote authorized 
  userunauthorized access. 

  Impact:
  Remote unauthorized access

  Affected Software/OS:
  Ignite-UX on
  HP-UX B.11.00, B.11.11, B.11.22, and B.11.23 running Ignite-UX. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01035681-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Ignite-UX");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-KRN-11-22", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-SERVICES", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.FILESRV-1122IA", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.CFG-FILE-11-22", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.MGMT-TOOLS", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.IGNITE", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.OBAM-RUN", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.RECOVERY", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-COMMON-IA", revision:"C.6.2.241", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-KRN-11-23", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-SERVICES", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.MGMT-TOOLS", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.IGNITE", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.OBAM-RUN", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.RECOVERY", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.FILE-SRV-11-23", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-COMMON-PA", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-COMMON-IA", revision:"C.6.2.241", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-KRN-11-00", revision:"C.6.2.241", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-SERVICES", revision:"C.6.2.241", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.FILE-SRV-11-00", revision:"C.6.2.241", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.MGMT-TOOLS", revision:"C.6.2.241", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.IGNITE", revision:"C.6.2.241", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.OBAM-RUN", revision:"C.6.2.241", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.RECOVERY", revision:"C.6.2.241", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"change permissions, remove files", revision:"C.6.2.241", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-KRN-11-11", revision:"C.6.2.241", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.BOOT-SERVICES", revision:"C.6.2.241", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.FILE-SRV-11-11", revision:"C.6.2.241", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.MGMT-TOOLS", revision:"C.6.2.241", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.IGNITE", revision:"C.6.2.241", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.OBAM-RUN", revision:"C.6.2.241", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Ignite-UX.RECOVERY", revision:"C.6.2.241", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}