##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_flock_detect_win.nasl 4375 2009-08-31 17:38:24Z aug $
#
# Flock Version Detection (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800877);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Flock Version Detection (Win)");
  desc = "
  Overview: This script detects the installed version of Flock Browser and
  sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Flock Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion"))
{
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Flock\Flock")){
  exit(0);
}

foreach item (registry_enum_keys(key:"SOFTWARE\Flock\Flock"))
{
  flockVer = eregmatch(pattern:"([0-9]\.[0-9.]+((b|rc)[0-9])?)", string:item);

  if(!isnull(flockVer[1]))
  {
    set_kb_item(name:"Flock/Win/Ver", value:flockVer[1]);
    security_note(data:"Flock version " + flockVer[1] + " was detected on the host");
  }
}
