# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8449 (subversion)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64620);
 script_cve_id("CVE-2009-2411");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"8.5");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 11 FEDORA-2009-8449 (subversion)");

 desc = "The remote host is missing an update to subversion
announced via advisory FEDORA-2009-8449.

Update Information:

This update includes the latest stable release of Subversion, fixing many bugs
and a security issue:

Matt Lewis reported multiple heap overflow flaws in Subversion (servers
and clients) when parsing binary deltas. Malicious users with commit
access to a vulnerable server could uses these flaws to cause a heap
overflow on the server running Subversion. A malicious Subversion server
could use these flaws to cause a heap overflow on vulnerable clients when
they attempt to checkout or update, resulting in a crash or, possibly,
arbitrary code execution on the vulnerable client. (CVE-2009-2411)

ChangeLog:

* Fri Aug  7 2009 Joe Orton  1.6.4-2
- update to 1.6.4
* Thu Jul 23 2009 Joe Orton  1.6.3-2
- remove -devel dependency on -gnome, -kde (#513313)

References:

[ 1 ] Bug #514744 - CVE-2009-2411 subversion: integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=514744

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update subversion' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8449

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8449 (subversion)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mod_dav_svn", rpm:"mod_dav_svn~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"subversion", rpm:"subversion~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"subversion-devel", rpm:"subversion-devel~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"subversion-gnome", rpm:"subversion-gnome~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"subversion-javahl", rpm:"subversion-javahl~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"subversion-kde", rpm:"subversion-kde~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"subversion-perl", rpm:"subversion-perl~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"subversion-ruby", rpm:"subversion-ruby~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"subversion-debuginfo", rpm:"subversion-debuginfo~1.6.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
