# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7780 (wxGTK)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64464);
 script_cve_id("CVE-2009-2369");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-7780 (wxGTK)");

 desc = "The remote host is missing an update to wxGTK
announced via advisory FEDORA-2009-7780.

Update Information:

added fix for CVE-2009-2369

ChangeLog:

* Wed Jul 15 2009 Dan Hork  - 2.8.10-2
- add fix for CVE-2009-2369 (#511279)

References:

[ 1 ] Bug #511279 - wxGTK: Integer overflow in JPEG image decoder (DoS, ACE)
https://bugzilla.redhat.com/show_bug.cgi?id=511279

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update wxGTK' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7780

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-7780 (wxGTK)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wxBase", rpm:"wxBase~2.8.10~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wxGTK", rpm:"wxGTK~2.8.10~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wxGTK-devel", rpm:"wxGTK-devel~2.8.10~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wxGTK-gl", rpm:"wxGTK-gl~2.8.10~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wxGTK-media", rpm:"wxGTK-media~2.8.10~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wxGTK-debuginfo", rpm:"wxGTK-debuginfo~2.8.10~2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
