# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3204 (pam)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63788);
 script_cve_id("CVE-2009-0887");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.6");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-3204 (pam)";
 script_name(name);

 desc = "The remote host is missing an update to pam
announced via advisory FEDORA-2009-3204.

Update Information:

Update to new minor upstream release. Minor security issue fixes and bug fixes.
ChangeLog:

* Mon Mar 30 2009 Tomas Mraz  1.0.4-4
- replace libtool to drop unneeded /lib64 rpath
* Thu Mar 26 2009 Tomas Mraz  1.0.4-3
- replace all std descriptors when calling helpers (#491471)
* Tue Mar 17 2009 Tomas Mraz  1.0.4-2
- update to new upstream minor release (bugfixes and minor security fixes)

References:

[ 1 ] Bug #489932 - CVE-2009-0887 pam: integer signedness error in _pam_StrTok()
https://bugzilla.redhat.com/show_bug.cgi?id=489932
[ 2 ] Bug #487216 - CVE-2009:0579 pam: MINDAYS not respected by pam for password changing
https://bugzilla.redhat.com/show_bug.cgi?id=487216

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update pam' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3204

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-3204 (pam)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"pam", rpm:"pam~1.0.4~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam-devel", rpm:"pam-devel~1.0.4~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam-debuginfo", rpm:"pam-debuginfo~1.0.4~4.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
