# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10539 (perl-Net-OAuth)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66050);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-10539 (perl-Net-OAuth)");

 desc = "The remote host is missing an update to perl-Net-OAuth
announced via advisory FEDORA-2009-10539.

Update Information:

A session fixation vulnerability was discovered in OAuth protocol 1.0. Perl
OAuth bindings were updated to support the new version of the OAauth protocol
that was issued to address the vulnerability.    All OAuth users are strongly
advised to update to this updated package and protocol version 1.0a which fixes
the vulnerability.    Upstream advisory: http://oauth.net/advisories/2009-1

ChangeLog:

* Tue Oct 13 2009 Lubomir Rintel (Good Data)  - 0.19-1
- Update to 0.19, fixes security issue (2009.1)
* Sun Jul 26 2009 Fedora Release Engineering  - 0.14-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

References:

[ 1 ] Bug #528608 - current perl-Net-OAuth does not support OAuth 1.0a
https://bugzilla.redhat.com/show_bug.cgi?id=528608

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update perl-Net-OAuth' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10539

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-10539 (perl-Net-OAuth)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-Net-OAuth", rpm:"perl-Net-OAuth~0.19~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
