# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0917 (tor)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63270);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-0917 (tor)";
 script_name(name);

 desc = "The remote host is missing an update to tor
announced via advisory FEDORA-2009-0917.

Update Information:

New upstream release 0.2.0.33, with lots of bug fixes and one security fix:
https://blog.torproject.org/blog/tor-0.2.0.33-stable-released
ChangeLog:

* Thu Jan 22 2009 Enrico Scholz  - 0.2.0.33-1
- updated to 0.2.0.33 (SECURITY: fixed heap-corruption bug)
* Sun Dec  7 2008 Enrico Scholz  - 0.2.0.32-1
- updated to 0.2.0.32
- removed -setgroups patch; supplementary groups are now set upstream

References:

[ 1 ] Bug #481289 - tor: remote heap corruption bug fixed in 0.2.0.33
https://bugzilla.redhat.com/show_bug.cgi?id=481289

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update tor' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0917

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-0917 (tor)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"tor", rpm:"tor~0.2.0.33~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tor-core", rpm:"tor-core~0.2.0.33~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tor-lsb", rpm:"tor-lsb~0.2.0.33~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tor-debuginfo", rpm:"tor-debuginfo~0.2.0.33~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
