# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 430-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53129);
 script_bugtraq_id(9520);
 script_cve_id("CVE-2004-0047");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 430-1 (trr19)";
 script_name(name);

 desc = "The remote host is missing an update to trr19
announced via advisory DSA 430-1.

Steve Kemp discovered a problem in trr19, a type trainer application
for GNU Emacs, which is written as a pair of setgid() binaries and
wrapper programs which execute commands for GNU Emacs.  However, the
binaries don't drop privileges before executing a command, allowing an
attacker to gain access to the local group games.

For the stable distribution (woody) this problem has been fixed in
version 1.0beta5-15woody1.  The mipsel binary will be added later.

For the unstable distribution (sid) this problem will fixed soon.

We recommend that you upgrade your trr19 package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20430-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 430-1 (trr19)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"trr19", ver:"1.0beta5-15woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
