# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1578-1 (php4)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61031);
 script_cve_id("CVE-2007-3799", "CVE-2007-3806", "CVE-2007-3998", "CVE-2007-4657", "CVE-2008-2051");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1578-1 (php4)";
 script_name(name);

 desc = "The remote host is missing an update to php4
announced via advisory DSA 1578-1.

Several vulnerabilities have been discovered in PHP version 4, a
server-side, HTML-embedded scripting language. The Common Vulnerabilities
and Exposures project identifies the following problems:

CVE-2007-3799

The session_start function allows remote attackers to insert
arbitrary attributes into the session cookie via special characters
in a cookie that is obtained from various parameters.

CVE-2007-3806

A denial of service was possible through a malicious script abusing
the glob() function.

CVE-2007-3998

Certain maliciously constructed input to the wordwrap() function could
lead to a denial of service attack.

CVE-2007-4657

Large len values of the stspn() or strcspn() functions could allow an
attacker to trigger integer overflows to expose memory or cause denial
of service.

CVE-2008-2051

The escapeshellcmd API function could be attacked via incomplete
multibyte chars.


For the stable distribution (etch), these problems have been fixed in
version 6:4.4.4-8+etch6.

The php4 are no longer present the unstable distribution (sid).

We recommend that you upgrade your php4 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201578-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1578-1 (php4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php4", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pear", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xslt", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php4", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-odbc", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pspell", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-domxml", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-curl", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-dev", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-sybase", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcal", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php4", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcrypt", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-recode", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pgsql", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-common", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cli", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-interbase", ver:"4.4.4-8+etch6", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
