# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1369-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58590);
 script_cve_id("CVE-2007-3913");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1369-1 (gforge)";
 script_name(name);

 desc = "The remote host is missing an update to gforge
announced via advisory DSA 1369-1.

Sumit I. Siddharth discovered that Gforge, a collaborative development
tool performs insufficient input sanitising, which allows SQL injection.

For the oldstable distribution (sarge) this problem has been fixed in
version 3.1-31sarge2.

For the stable distribution (etch) this problem has been fixed in
version 4.5.14-22etch1.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your gforge package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201369-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1369-1 (gforge)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gforge-common", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-cvs", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-db-postgresql", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-dns-bind9", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-ftp-proftpd", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-ldap-openldap", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-lists-mailman", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-exim4", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-exim", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-postfix", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-shell-ldap", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-sourceforge-transition", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-web-apache", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sourceforge", ver:"3.1-31sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-common", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-db-postgresql", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-dns-bind9", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-ftp-proftpd", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-ldap-openldap", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-lists-mailman", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-courier", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-exim4", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-exim", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-postfix", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-shell-ldap", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-shell-postgresql", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-web-apache", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge", ver:"4.5.14-22etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
