//
// C++ Implementation: rename
//
// Description: 
//
//
// Author: Spiros Georgaras <sng@hellug.gr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "inputdir.h"
#include "iconload.h"
// #include "settings.h"

#include <kurl.h>
#include <krun.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <QtGui/QDialog>
#include <QMouseEvent>

#define HISTORY_ITEMS 25

// gWen::gWen(QDialog *)
inpDir::inpDir(QDialog* )
	:QDialog()
{
	setupUi(this);
}
inpDir::inpDir(QDialog* , iconload * ic){
	setupUi(this);
	setWindowTitle(windowTitle()+" - GwenRename");
	readHistory();
 	numOfHistoryItems=dir->count();
// 	dir->setCurrentText(QString::null); old impl
	dir->setCurrentIndex(-1);
	dir->setDuplicatesEnabled(false);
	
	pix->setPixmap(ic->Icon(0));
	btOpen->setIcon(KIcon(ic->Icon(1)));
	buttonOk->setIcon(KIcon(ic->Icon(3)));
	buttonCancel->setIcon(KIcon(ic->Icon(4)));
	buttonHelp->setIcon(KIcon(ic->Icon(6)));
	
	
	
	
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( buttonOkClicked() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( dir, SIGNAL( textChanged(const QString&) ), this, SLOT( textHasChanged(const QString&) ) );
	connect( btOpen, SIGNAL( clicked() ), this, SLOT( openDirSelectionDialog() ) );
	connect( buttonHelp, SIGNAL( clicked() ), this, SLOT( showHelp() ) );
	connect( dir, SIGNAL( returnPressed() ), this, SLOT( buttonOkClicked() ) );
	res=QString::null;
	dir->setFocus();
}

inpDir::~inpDir()
{

}


void inpDir::openDirSelectionDialog(){
	QString path=QString::null;
	if(buttonOk->isEnabled())
		path=dir->currentText();
	if(path.isNull()) path=QDir::homePath();
	KUrl newURL = KFileDialog::getExistingDirectoryUrl( KUrl(path), this, QString(i18n("Folder selection")+" - GwenRename"));
	if(newURL.isLocalFile()){
// 		dir->setCurrentText(newURL.path()); old impl
		if(dir->count()>numOfHistoryItems)
			dir->removeItem(0);
		dir->insertItems(0,QStringList(newURL.path()));
		dir->setCurrentIndex(0);
	}
}


void inpDir::textHasChanged( const QString & txt ){
	bool mode=false;
	if(txt.startsWith("/")){
		QFileInfo f(txt);
		if(f.exists() && f.isReadable() && f.isWritable())
    	mode=true;
	}
	buttonOk->setEnabled(mode);
}


void inpDir::buttonOkClicked(){
	if(!buttonOk->isEnabled())
		return;
// 	int found=-1;
	res=dir->currentText();
// 	qWarning("res = %s",res.toLocal8Bit().constData());
	
	for(int i=dir->count()-1;i>=0;i--)
		if(dir->itemText(i)==res)
			dir->removeItem(i);
	dir->insertItems(0,QStringList(res));
	numOfHistoryItems=dir->count();
	writeHistory();
	
// 	dir->setSizeLimit(10); old impl
	dir->setMaxVisibleItems(10);
	accept();
}




void inpDir::showHelp(){
		KRun::runCommand(QString("khelpcenter \"help:/gwenrename/using-GwenRename.html#input-folder-selection\""),this);
}


void inpDir::keyPressEvent( QKeyEvent *e ){
	e->accept();
// 	if(e->key()==Qt::Key_F1 && e->state()==Qt::NoButton) old impl
	if(e->key()==Qt::Key_F1 && e->modifiers()==Qt::NoModifier)
		showHelp();
// 	else if(e->key()==Qt::Key_Escape && e->state()==Qt::NoButton) old impl
	else if(e->key()==Qt::Key_Escape && e->modifiers()==Qt::NoModifier)
		reject();
}

void inpDir::resizeEvent ( QResizeEvent *e ){
	setMaximumHeight(height());
	e->accept();
}

void inpDir::readHistory(){
	QString tmp;
	QString group;
	QStringList t;
	KConfig config("gwenrenamerc");
// 	config.setGroup("FolderHistory"); old impl
	KConfigGroup grp=config.group("FolderHistory");
// 	for(int i=HISTORY_ITEMS-1;i>=0;i--){ old impl
	for(int i=0;i<HISTORY_ITEMS;i++){
		group=QString("Exp%1").arg(i);
// 		tmp=config.readEntry(group,QString::null); old impl
		tmp=grp.readEntry(group,"");
		if(!tmp.isEmpty()){
			QFileInfo f(tmp);
			if(f.exists() && f.isDir())
// 				dir->insertItems(tmp,0); old impl
				t<<tmp;
		}
	}
	if (!t.isEmpty()) dir->insertItems(0,t);
}

void inpDir::writeHistory(){
	QString group;
	KConfig config("gwenrenamerc");
// 	config.setGroup("FolderHistory"); old impl
	KConfigGroup grp=config.group("FolderHistory");
	for(int i=0;i<HISTORY_ITEMS;i++){
		group=QString("Exp%1").arg(i);
		grp.deleteEntry(group);
		if(dir->itemText(i).isEmpty()) continue;
//		qWarning("%s - %s",group.toLocal8Bit().constData(),dir->itemText(i).toLocal8Bit().constData());
		grp.writeEntry(group,dir->itemText(i));
	}
}

QString inpDir::selectedFolder(){
	return res;
}
#include "inputdir.moc"
