/* Test for decoding SMS on Nokia 6510 driver */

#include <gammu.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "common.h"

#include "../libgammu/protocol/protocol.h"	/* Needed for GSM_Protocol_Message */
#include "../libgammu/gsmstate.h"	/* Needed for state machine internals */

#include "../helper/message-display.h"

unsigned char data[] = {
	0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x9E, 0x00, 0x00, 0x02, 0xE2, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B,
	0x00, 0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x31, 0x00, 0x32, 0x00, 0x36, 0x00, 0x39, 0x00, 0x36,
	0x00, 0x38, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x51, 0x00, 0x14, 0x91, 0x53, 0x58, 0x76, 0x98, 0x21, 0x43, 0x65, 0x87, 0x19, 0x32, 0x00, 0x00,
	0xFF, 0xA0, 0x05, 0x00, 0x03, 0x00, 0x02, 0x01, 0x82, 0x68, 0x16, 0x68, 0x5E, 0x97, 0xD3, 0x5D,
	0xA0, 0xE3, 0x9B, 0x4C, 0x07, 0x91, 0xEB, 0xA0, 0xB2, 0x1C, 0xB4, 0x7E, 0xB7, 0xDB, 0x65, 0x3A,
	0x08, 0xAD, 0x2E, 0xB7, 0x41, 0xEF, 0x33, 0x68, 0x1D, 0x76, 0x83, 0xE6, 0xEC, 0x30, 0x1C, 0x5E,
	0x06, 0x85, 0xCD, 0x20, 0x77, 0x9D, 0x05, 0x9A, 0x3F, 0x5C, 0x20, 0xA4, 0x3D, 0x3D, 0x07, 0x91,
	0xEB, 0x20, 0x7B, 0x58, 0x0E, 0x42, 0x97, 0xE5, 0xA0, 0x75, 0xDD, 0xED, 0x2E, 0x83, 0xC8, 0x75,
	0x90, 0xFA, 0x0D, 0x9A, 0x3F, 0x40, 0xF0, 0xF0, 0x7C, 0x5E, 0x76, 0x93, 0xCB, 0x20, 0x77, 0x7D,
	0x3E, 0x2F, 0x83, 0xDA, 0xE9, 0x33, 0x28, 0x0D, 0x42, 0xBF, 0xED, 0x65, 0xB2, 0xB8, 0xEE, 0x26,
	0x97, 0xDD, 0x2E, 0x50, 0xB3, 0xEC, 0x06, 0xB1, 0xD3, 0xE7, 0x32, 0x28, 0x0D, 0x22, 0x87, 0xCF,
	0xA0, 0xB2, 0x1C, 0x44, 0xAE, 0x83, 0xD8, 0x6F, 0x3B, 0x3B, 0x7D, 0xA6, 0x83, 0xEA, 0x01, 0x01,
	0x91, 0x01, 0x00, 0x01, 0x01, 0x03, 0x01, 0x4C, 0x00, 0x41, 0x00, 0x68, 0x00, 0x2C, 0x00, 0x20,
	0x00, 0x73, 0x00, 0x75, 0x00, 0x72, 0x00, 0x74, 0x00, 0x2E, 0x00, 0x20, 0x00, 0x47, 0x00, 0x6F,
	0x00, 0x64, 0x00, 0x74, 0x00, 0x20, 0x00, 0x64, 0x00, 0x75, 0x00, 0x20, 0x00, 0x65, 0x00, 0x72,
	0x00, 0x20, 0x00, 0x6B, 0x00, 0x6F, 0x00, 0x6D, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x74, 0x00, 0x20,
	0x00, 0x68, 0x00, 0x6A, 0x00, 0x65, 0x00, 0x6D, 0x00, 0x20, 0x00, 0x6F, 0x00, 0x67, 0x00, 0x20,
	0x00, 0x6B, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x20, 0x00, 0x73, 0x00, 0x6C, 0x00, 0x61, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x65, 0x00, 0x20, 0x00, 0x61, 0x00, 0x66, 0x00, 0x20, 0x00, 0x6E, 0x00, 0x75,
	0x00, 0x2C, 0x00, 0x20, 0x00, 0x73, 0x00, 0xE5, 0x00, 0x2E, 0x00, 0x20, 0x00, 0x48, 0x00, 0x76,
	0x00, 0x69, 0x00, 0x73, 0x00, 0x20, 0x00, 0x64, 0x00, 0x75, 0x00, 0x20, 0x00, 0x76, 0x00, 0x61,
	0x00, 0x72, 0x00, 0x20, 0x00, 0x68, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x6B, 0x00, 0x75,
	0x00, 0x6E, 0x00, 0x6E, 0x00, 0x65, 0x00, 0x20, 0x00, 0x64, 0x00, 0x75, 0x00, 0x20, 0x00, 0x6A,
	0x00, 0x6F, 0x00, 0x20, 0x00, 0x73, 0x00, 0xE5, 0x00, 0x20, 0x00, 0x70, 0x00, 0x61, 0x00, 0x73,
	0x00, 0x73, 0x00, 0x65, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x65, 0x00, 0x20, 0x00, 0x6E, 0x00, 0x75,
	0x00, 0x73, 0x00, 0x73, 0x00, 0x65, 0x00, 0x20, 0x00, 0x6D, 0x00, 0x69, 0x00, 0x67, 0x00, 0x20,
	0x00, 0x69, 0x00, 0x20, 0x00, 0x68, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x65, 0x00, 0x64, 0x00, 0x62,
	0x00, 0x75, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x65, 0x00, 0x6E, 0x00, 0x2E, 0x00, 0x20, 0x00, 0x4D,
	0x00, 0x65, 0x00, 0x6E, 0x00, 0x20, 0x00, 0x6C, 0x00, 0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x20,
	0x00, 0x69, 0x00, 0x20, 0x00, 0x64, 0x00, 0x61, 0x00, 0x67, 0x00, 0x20, 0x00, 0x65, 0x00, 0x72,
	0x00, 0x20, 0x00, 0x64, 0x00, 0x75, 0x00, 0x20, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x6C,
	0x00, 0x69, 0x00, 0x67, 0x00, 0x74, 0x00, 0x20, 0x00, 0x75, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x73,
	0x00, 0x6B, 0x00, 0x79, 0x00, 0x6C, 0x00, 0x64, 0x00, 0x74, 0x00, 0x2E, 0x00, 0x20, 0x00, 0x3B,
	0x00, 0x29, 0x00, 0x00, 0x04, 0x00, 0x18, 0x00, 0x2B, 0x00, 0x34, 0x00, 0x35, 0x00, 0x36, 0x00,
	0x31, 0x00, 0x32, 0x00, 0x36, 0x00, 0x39, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00, 0x00, 0x0C,
	0x00, 0x02, 0x37, 0x00, 0x07, 0x00, 0x01, 0x0E, 0x05, 0x00, 0x01, 0x02, 0x06, 0x00, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x00, 0x01, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x09, 0x00, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x07, 0x00, 0x01, 0x0E, 0x05, 0x00, 0x01, 0x07, 0x12, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x00, 0x01, 0x00, 0x00,
};

const char text[] = "Ah, surt. Godt du er kommet hjem og kan slappe af nu, så. Hvis du var her kunne du jo så passende nusse mig i hovedbunden. Men lige i dag er du lovligt u";
char decoded_text[200];

/* This is not part of API! */
extern GSM_Error N6510_DecodeFilesystemSMS(GSM_StateMachine * s, GSM_MultiSMSMessage * sms, GSM_File * FFF, int location);

int main(int argc UNUSED, char **argv UNUSED)
{
	GSM_Debug_Info *debug_info;
	GSM_StateMachine *s;
	GSM_File file;
	GSM_Error error;
	GSM_MultiSMSMessage sms;

	/* Init locales for proper output */
	GSM_InitLocales(NULL);

	debug_info = GSM_GetGlobalDebug();
	GSM_SetDebugFileDescriptor(stderr, FALSE, debug_info);
	GSM_SetDebugLevel("textall", debug_info);

	/* Allocates state machine */
	s = GSM_AllocStateMachine();
	test_result(s != NULL);

	debug_info = GSM_GetDebug(s);
	GSM_SetDebugGlobal(TRUE, debug_info);

	/* Init file */
	file.Buffer = malloc(sizeof(data));
	memcpy(file.Buffer, data, sizeof(data));
	file.Used = sizeof(data);
	file.ID_FullName[0] = 0;
	file.ID_FullName[1] = 0;
	GSM_GetCurrentDateTime(&(file.Modified));

	/* Parse it */
	error = N6510_DecodeFilesystemSMS(s, &sms, &file, 0);

	/* Display message */
	DisplayMultiSMSInfo(&sms, FALSE, TRUE, NULL, NULL);
	DisplayMultiSMSInfo(&sms, TRUE, TRUE, NULL, NULL);

	/* Free state machine */
	GSM_FreeStateMachine(s);

	/* Check expected text */
	/* We do not compare full text due to locales problem */
	EncodeUTF8(decoded_text, sms.SMS[0].Text);
	test_result(strcmp(text, decoded_text) == 0);

	gammu_test_result(error, "N6510_DecodeFilesystemSMS");

	return 0;
}

/* Editor configuration
 * vim: noexpandtab sw=8 ts=8 sts=8 tw=72:
 */



