#include "prefsDialog.h"
#include <kfiledialog.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kfontdialog.h>
#include <klocale.h>
#include <knuminput.h>
#include <kurlrequester.h>

prefsDialog::prefsDialog (QWidget* parent, const char* name)
	:prefsDialogData(parent, name)
{
    setCaption( i18n("KWeather Preferences") );
    centerOnScreen( this );

    connect(m_offlineMode, SIGNAL(toggled(bool)), this, SLOT(offlineModeToggled(bool)));
    connect(ICAOlink, SIGNAL(leftClickedURL(const QString&)), this, SLOT(processURL(const QString&)));
    connect(m_enableLog, SIGNAL(toggled(bool)), this, SLOT(enableLogWidgets(bool)));
    connect(fontButton, SIGNAL(released()), SLOT(selectFont()));
}

prefsDialog::~prefsDialog()
{
}

/** Get the report location string. */
QString prefsDialog::reportLocation() const {
    return m_reportLocation->text();
}

int prefsDialog::updateInterval() const {
    return m_updateInterval->value();
}

bool prefsDialog::offLineMode() const {
    return m_offlineMode->isChecked();
}

bool prefsDialog::smallView() const {
    return m_smallView->isChecked();
}

QString prefsDialog::logFile() const {
    return m_logFile->url();
}

/** Set the pref box file name to the current prefs file name. */
void prefsDialog::setLogFile( QString s ){
    m_logFile->setURL(s);
}

/** Set the LCD and Slider value */
void prefsDialog::setUpdateInterval(int i){
    m_updateInterval->setValue (i);
}

/** Set the small view mode checkbox */
void prefsDialog::setSmallView( bool b){
    m_smallView->setChecked (b);
}

/** Set the offline mode checkbox */
void prefsDialog::setOffLineMode( bool b ){
    m_offlineMode->setChecked (b);
    offlineModeToggled(b);
}

/** The current report location */
void prefsDialog::setReportLocation( QString s ){
    m_reportLocation->setText( s );
}

/** Open Konqueror to this link. */
void prefsDialog::processURL(const QString& url){
    kapp->invokeBrowser( url );
}

void prefsDialog::selectFont()
{
    int result = KFontDialog::getFont( theFont );
    if (result == KFontDialog::Accepted)
        updateFont();
}

QFont prefsDialog::font() const
{
    return theFont;
}

void prefsDialog::setFont(QFont font)
{
    theFont = font;
    updateFont();
}

void prefsDialog::updateFont()
{
    QString fontDesc = theFont.family()+", "
        +QString::number(theFont.pointSize())+i18n(" Point");
    samplefont->setText(fontDesc);
    samplefont->setFont(theFont);
}

void prefsDialog::enableLogWidgets(bool b)
{
    m_logFile->setEnabled(b);
    m_labelLogFile->setEnabled(b);
}

bool prefsDialog::enableLog() const
{
    return m_enableLog->isChecked();
}

void prefsDialog::setEnableLog(bool b)
{
    m_enableLog->setChecked ( b );
    enableLogWidgets( b );
}

void prefsDialog::offlineModeToggled(bool b)
{
    m_updateInterval->setEnabled(!b);
}

#include "prefsDialog.moc"
