/***************************************************************************
                          kcontroladdedit.h  -  description
                             -------------------
    begin                : Sun May 27 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTROLADDEDIT_H
#define KCONTROLADDEDIT_H

#include "fileread.h"

#include <qwidget.h>
#include <kwizard.h>

#include <kurlrequester.h>
#include <kcombobox.h>
#include <klistview.h>
#include <knuminput.h>

#include <qpushbutton.h>
#include <qmultilineedit.h>


/**Add or edit questions
 * This is the Wizard that allows adding and editing of
 * Questions (and corresponding possible answers) to the
 * KEduca Document.
 * This will be called from the Editor (class KControlDoc)
 *@author Javier Campos
 */

class KControlAddEdit : public KWizard  {
    Q_OBJECT

public:
    KControlAddEdit(QWidget *parent = 0, const char *name = 0, bool modal = true, WFlags f = 0);
    ~KControlAddEdit();
    /** Init keducaFile pointer and EditMode */
    void init(FileRead *keducaFile, bool editMode);
    /** show current Page */
    void showPage(QWidget *page);

private: // Private methods
    /** Init graphical interface */
//  void initGUI();
    /** Fill page of current record */
    void fillPage();
    /** Refresh klistview of answers */
    void refreshAnswer_list();
    /** Add question with form data */
    void addQuestion();
    /** Write config settings */
    void configWrite();
    /** Read config settings */
    void configRead();
    /** Set page question */
    void setPageQuestion();
    /** Set answer page */
    void setPageAnswer();

private: // Private attributes

    /** Copy of answers */
    struct AnswerCopy	{
        QString text;
        bool result;
        int points;
    };

    /** Question text */
    QMultiLineEdit *_questionText;
    /** Picture browser */
    KURLRequester *_questionPicture;
    /** Question type */
    KComboBox *_questionType;
    /** Question explain */
    QMultiLineEdit *_questionExplain;
    /** Question tip */
    QLineEdit *_questionTip;
    /** Answer text */
    QMultiLineEdit *_answerText;
    /** Answer value */
    KComboBox *_answerValue;
    /** Question point */
    KIntNumInput *_questionPoint;
    /** Answer points */
    KIntNumInput *_answerPoints;
    /** Button insert answers */
    QPushButton *_buttonInsert;
    /** Answer list */
    KListView *_listAnswers;
    /** Button remove answer */
    QPushButton *_buttonRemove;
    /** Button down answer */
    QPushButton *_buttonDown;
    /** Button up answer */
    QPushButton *_buttonUp;
    /** Time */
    KIntNumInput *_questionTime;

    /** Copy of answers */
    QValueList<AnswerCopy> _answerCopy;
    /** Pointer to keduca of kcontrol page */
    FileRead *_keducaFile;
    /** Is a edit modify? */
    bool _editMode;
    /** Preview image */
    QLabel *_questionPreview1;
    /** Preview image 2 */
    QLabel *_questionPreview2;
    /** Page question */
    QWidget *_pageQuestion;
    /** Page answer */
    QWidget *_pageAnswer;

private slots: // Private slots
    /** Remove answer */
    void slot_ButtonRemove();

private slots: // Private slots
    /** Accept changes */
    void accept();
    /** Button insert */
    void slot_ButtonAdd();
    /** Button Down */
    void slot_ButtonDown();
    /** Button Up */
    void slot_ButtonUp();
    /** Question data changed */
    void slotDataChanged();
    /** Preview image */
    void slotPreview( const QString & );
    /** Change question type */
    void slotQuestionType( int index );
};

#endif
