/***************************************************************************
                            QWMatrix.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QWMATRIX_H
#define QWMATRIX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

* $Id: QWMatrix.h,v 1.2 2001/11/21 23:39:02 rdale Exp $
*
* Definition of QWMatrix class
*
* Created : 941020
*
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
*
* This file is part of the kernel module of the Qt GUI Toolkit.
*
* This file may be distributed under the terms of the Q Public License
* as defined by Trolltech AS of Norway and appearing in the file
* LICENSE.QPL included in the packaging of this file.
*
* This file may be distributed and/or modified under the terms of the
* GNU General Public License version 2 as published by the Free Software
* Foundation and appearing in the file LICENSE.GPL included in the
* packaging of this file.
*
* Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
* licenses may use this file in accordance with the Qt Commercial License
* Agreement provided with the Software.
*
* This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
* WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
*   information about Qt Commercial License Agreements.
* See http://www.trolltech.com/qpl/ for QPL licensing information.
* See http://www.trolltech.com/gpl/ for GPL licensing information.
*
* Contact info@trolltech.com if any conditions of this licensing are
* not clear to you.
*
********************************************************************
 @short 
* $Id:  qt/qwmatrix.
*/
@class QPoint; 
@class QPointArray; 
@class QRect; 

@interface  QWMatrix : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- initWithDouble: (double)m11 m12: (double)m12 m21: (double)m21 m22: (double)m22 dx: (double)dx dy: (double)dy;
- setMatrix: (double)m11 m12: (double)m12 m21: (double)m21 m22: (double)m22 dx: (double)dx dy: (double)dy;
- (double) m11;
- (double) m12;
- (double) m21;
- (double) m22;
- (double) dx;
- (double) dy;
- mapInt: (int)x y: (int)y tx: (int*)tx ty: (int*)ty;
- mapDouble: (double)x y: (double)y tx: (double*)tx ty: (double*)ty;
- (QRect*) mapRect: (QRect*)arg1;
- (QPoint*) mapPoint: (QPoint*)p;
//- (QRect*) mapRect: (QRect*)r;
- (QPointArray*) mapPointArray: (QPointArray*)a;
- reset;
- (BOOL) isIdentity;
- (QWMatrix*) translate: (double)dx dy: (double)dy;
- (QWMatrix*) scale: (double)sx sy: (double)sy;
- (QWMatrix*) shear: (double)sh sv: (double)sv;
- (QWMatrix*) rotate: (double)a;
- (BOOL) isInvertible;
- (QWMatrix*) invert: (int*)arg1;
- (QWMatrix*) invert;
@end

#endif
