/***************************************************************************
* $Id: SoundPlayer.java,v 1.2 2002/03/10 16:08:01 rdale Exp $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;


class SoundPlayer  extends QMainWindow {

private    QSound bucket3;
private    QSound bucket4;

//
// Very simple example of QSound.play(filename)
//
// 99% of this program is just boilerplate Qt code to put up a nice
// window so you think something special is happening.
//


SoundPlayer()
{
    super();
    bucket3 = new QSound("sounds/3.wav");
    bucket4 = new QSound("sounds/4.wav");
    
	if (!QSound.isAvailable()) {
	// Bail out.  Programs in which sound is not critical
	// could just silently (hehe) ignore the lack of a server.
	//
	QMessageBox.warning(this,"No Sound",
		"<p><b>Sorry, you are not running the Network Audio System.</b>"
		+ "<p>If you have the `au' command, run it in the background before this program. "
		+ "The latest release of the Network Audio System can be obtained from:"
		+ "<pre>\n"
		+ " &nbsp;\n"
		+ "   ftp.ncd.com:/pub/ncd/technology/src/nas\n"
		+ "   ftp.x.org:/contrib/audio/nas\n"
		+ "</pre>"
		+ "<p>Release 1.2 of NAS is also included with the X11R6"
		+ "contrib distribution."
		+ "<p>After installing NAS, you will then need to reconfigure Qt with NAS sound support");
    }

    QPopupMenu file = new QPopupMenu(this);
    file.insertItem("Play &1",  this, SLOT("doPlay1()"), new QKeySequence(CTRL+Key_1));
    file.insertItem("Play &2",  this, SLOT("doPlay2()"), new QKeySequence(CTRL+Key_2));
    file.insertItem("Play from bucket &3",  this, SLOT("doPlay3()"), new QKeySequence(CTRL+Key_3));
    file.insertItem("Play from bucket &4",  this, SLOT("doPlay4()"), new QKeySequence(CTRL+Key_4));
    file.insertSeparator();
    file.insertItem("Play 3 and 4 together",  this, SLOT("doPlay34()"));
    file.insertItem("Play all together",  this, SLOT("doPlay1234()"));
    file.insertSeparator();
    file.insertItem("E&xit",  qApp(), SLOT("quit()"));
    menuBar().insertItem("&File", file);
}

void doPlay1()
{
    QSound.play("sounds/1.wav");
}

void doPlay2()
{
    QSound.play("sounds/2.wav");
}

void doPlay3()
{
    bucket3.play();
}

void doPlay4()
{
    bucket4.play();
}

void doPlay34()
{
    // Some sound platforms will only play one sound at a time
    bucket3.play();
    bucket4.play();
}

void doPlay1234()
{
    // Some sound platforms will only play one sound at a time
    QSound.play("sounds/1.wav");
    QSound.play("sounds/2.wav");
    bucket3.play();
    bucket4.play();
}

public static void main(String[] args)
{
    QApplication app = new QApplication(args);
    SoundPlayer sp = new SoundPlayer();
    app.setMainWidget(sp);
    sp.setCaption("Qt Example - Sounds");
    sp.show();
    app.exec();
    return;
}

	static {
		qtjava.initialize();
	}

}

