/***************************************************************************
                            KMimeMagic.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KMIMEMAGIC_H
#define KMIMEMAGIC_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 May be removed in KDE 4.0
 Determine auto-magically the type of file,
 not only by using its extension, but also by reading its contents.

 Unless specified otherwise, KMimeMagic uses
 $KDEDIR/share/mimelnk/magic for this purpose.

 To make KMimeMagic restore the 'atime' of a file after it opened it,
 add its directory in kmimemagicrc like:
 [Settings]
 atimeDirs=/tmp,/var/tmp,/home/dfaure/tmp
 This isn't done by default because it changes the 'ctime'.
 See kmimemagic.cpp for a full discussion on this issue.

 The basic usage of KMimeMagic is :

 The result is contained in the class @ref KMimeMagicResult.
 
 @short 

*/
@class KMimeMagicResult;
@class QByteArray;

@interface  KMimeMagic : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Create a parser and initialize it with the given config file.
   
*/
- initWithText: (NSString *)configFile;

/** 
 Destroy the parser.
   
*/
- (void) dealloc;

/** 
 Merge an existing parse table with the data from the
 given file.

*/
- (BOOL) mergeConfig: (NSString *)configFile;

/** 
 Merge an existing parse table with the data from the
 given buffer.

*/
- (BOOL) mergeBufConfig: (NSString *)arg1;

/** 
 Enable/Disable follow-links.

 (Default is disabled.)
   
*/
- setFollowLinks: (BOOL)_enable;

/** 
 Try to find a MimeType for the given file.

 If no special
 MimeType is found, the default MimeType is returned.
 This function looks at the content of the file.

*/
- (KMimeMagicResult*) findFileType: (NSString *)_filename;

/** 
 Same functionality as above, except data is not
 read from a file.

 Instead a buffer can be supplied which
 is examined. The integer parameter supplies the length of
 the buffer.

*/
- (KMimeMagicResult*) findBufferType: (QByteArray*)p;

/** 
 Same functionality as @ref -findBufferType but with
 additional capability of distinguishing between
 C-headers and C-Source.

 For this purpose this function looks
 at the extension of the filename. This means that 'filename'
 can be a filename on some FTP server, too.

*/
- (KMimeMagicResult*) findBufferFileType: (QByteArray*)arg1 filename: (NSString *)filename;

/** 
 Returns a pointer to the unique KMimeMagic instance in this process.
   
*/
+ (KMimeMagic*) self;
//+ initStatic;
@end

#endif
