package org.kde.koala;
import org.kde.qt.*;


/** {@link KWinModule} emits these signals */
public interface KWinModuleSignals {

/** 
 A window has been removed.

*/
	void windowRemoved( int identifier );

/** 
 The window changed somehow.

*/
	void windowChanged( int identifier );

/** 
 The number of desktops changed.

*/
	void numberOfDesktopsChanged( int num );

/** 
 Desktops have been renamed.
     
*/
	void desktopNamesChanged();
	void destroyed( QObject obj );

/** 
 A window has been added.

*/
	void windowAdded( int identifier );

/** 
 Emitted when a dock window has been removed.

*/
	void systemTrayWindowRemoved( int identifier );

/** 
 Emitted when the stacking order of the window changed. The new order
 can be obtained with {@link KWinModule#stackingOrder}.
     
*/
	void stackingOrderChanged();

/**  
 Something changed with the struts, may or may not have changed
 the work area.
     
*/
	void strutChanged();

/** 
 The workarea has changed.
     
*/
	void workAreaChanged();

/** 
 Hint that <Window> is active (= has focus) now.

*/
	void activeWindowChanged( int arg1 );

/** 
 Switched to another virtual desktop.

*/
	void currentDesktopChanged( int desktop );

/** 
 Emitted when a dock window has been added.

*/
	void systemTrayWindowAdded( int identifier );
}

