/***************************************************************************
                            KFileView.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class defines an interface to all file views. Its intent is
 to allow to switch the view of the files in the selector very easily.
 It defines some pure virtual functions, that must be implemented to
 make a file view working.

 Since this class is not a widget, but it's meant to be added to other
 widgets, its most important function is {@link #widget.} This should return
 a pointer to the implemented widget.

 @author Stephan Kulow <coolo@kde.org>

 @version $Id: KFileView.java,v 1.7 2002/11/26 04:17:32 rdale Exp $

 @short A base class for views of the KDE file selector.
*/
public class  KFileView implements QtSupport, KFileViewInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KFileView(Class dummy){}


/** 
 Destructor
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 inserts a list of items.

*/
//	public native void addItemList( ArrayList list);

/** 
 a pure virtual function to get a QWidget, that can be added to
 other widgets. This function is needed to make it possible for
 derived classes to derive from other widgets.

*/
	public native QWidget widget();

/** 
 ### As const-method, to be fixed in 3.0
     
*/
//	public native QWidget widget();

/** 
 Sets <code>filename</code> the current item in the view, if available.
     
*/
	public native void setCurrentItem( String filename);

/** 
 Reimplement this to set <code>item</code> the current item in the view, e.g.
 the item having focus.
     
*/
	public native void setCurrentItem( KFileItem item);

/** 

*/
	public native KFileItem currentFileItem();

/** 
 Clears the view and all item lists.
     
*/
	public native void clear();

/** 
 does a repaint of the view.

 The default implementation calls
 <pre>widget().repaint(f)</pre>

*/
	public native void updateView( boolean f);
	public native void updateView();
	public native void updateView( KFileItem arg1);

/** 
 Removes an item from the list; has to be implemented by the view.
 Call KFileView.removeItem( item ) after removing it.
     
*/
	public native void removeItem( KFileItem item);

/** 
 This hook is called when all items of the currently listed directory
 are listed and inserted into the view, i.e. there won't come any new
 items anymore.
     
*/
	public native void listingCompleted();

/** 
 Returns the sorting order of the internal list. Newly added files
 are added through this sorting.
      
*/
	public native boolean sorting();

/** 
 Sets the sorting order of the view.

 Default is QDir.Name | QDir.IgnoreCase | QDir.DirsFirst
 Override this in your subclass and sort accordingly (usually by
 setting the sorting-key for every item and telling QIconView
 or QListView to sort.

 A view may choose to use a different sorting than QDir.Name, Time
 or Size. E.g. to sort by mimetype or any possible string. Set the
 sorting to QDir.Unsorted for that and do the rest internally.

*/
	public native void setSorting( int sort);

/** 
 Tells whether the current items are in reversed order (shortcut to
 sorting() & QDir.Reversed).
     
*/
	public native boolean isReversed();
	public native void sortReversed();

/** 

*/
	public native int count();

/** 

*/
	public native int numFiles();

/** 

*/
	public native int numDirs();
	public native void setSelectionMode( int sm);
	public native int selectionMode();
	public native void setViewMode( int vm);
	public native int viewMode();

/** 

*/
	public native String viewName();

/** 
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".
     
*/
	public native void setViewName( String name);
	public native void setParentView( KFileViewInterface parent);

/** 
 The derived view must implement this function to add
 the file in the widget.

 Make sure to call this implementation, i.e.
 KFileView.insertItem( i );

     
*/
	public native void insertItem( KFileItem i);

/** 
 pure virtual function, that should be implemented to clear
 the view. At this moment the list is already empty

*/
	public native void clearView();

/** 
 pure virtual function, that should be implemented to make item i
 visible, i.e. by scrolling the view appropriately.
     
*/
	public native void ensureItemVisible( KFileItem i);

/** 
 Clears any selection, unhighlights everything. Must be implemented by
 the view.
     
*/
	public native void clearSelection();

/** 
 Selects all items. You may want to override this, if you can implement
 it more efficiently than calling setSelected() with every item.
 This works only in Multiselection mode of course.
     
*/
	public native void selectAll();

/** 
 Inverts the current selection, i.e. selects all items, that were up to
 now not selected and deselects the other.
     
*/
	public native void invertSelection();

/** 
 Tells the view that it should highlight the item.
 This function must be implemented by the view.

*/
	public native void setSelected( KFileItem arg1, boolean enable);

/** 

*/
	public native boolean isSelected( KFileItem arg1);

/** 

*/
	public native ArrayList selectedItems();

/** 

*/
	public native ArrayList items();
	public native KFileItem firstFileItem();
	public native KFileItem nextItem( KFileItem arg1);
	public native KFileItem prevItem( KFileItem arg1);

/** 
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.
     
*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/** 

*/
	public native boolean onlyDoubleClickSelectsFiles();

/** 
 increases the number of dirs and files.

*/
	public native boolean updateNumbers( KFileItem i);

/** 

*/
	public native KActionCollection actionCollection();
	public native KFileViewSignaler signaler();
	public native void readConfig( KConfig arg1, String group);
	public native void readConfig( KConfig arg1);
	public native void writeConfig( KConfig arg1, String group);
	public native void writeConfig( KConfig arg1);

/** 
 This method calculates a String from the given parameters, that is
 suitable for sorting with e.g. QIconView or QListView. Their
 Item-classes usually have a setKey( String ) method or a virtual
 method String key() that is used for sorting.

*/
	public static native String sortingKey( String value, boolean isDir, int sortSpec);

/** 
 An overloaded method that takes not a String, but a number as sort
 criterion. You can use this for file-sizes or dates/times for example.
 If you use a time_t, you need to cast that to KIO.filesize_t because
 of ambiguity problems.
     
*/
	public static native String sortingKey( int value, boolean isDir, int sortSpec);
	public static final int Files = 1;
	public static final int Directories = 2;
	public static final int All = Files|Directories;
}
