/* This file is part of the KDE Linux Kernel Configurator
   Copyright (c) 2001 Malte Starostik <malte@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

// $Id: configuration.h,v 1.12 2002/03/13 21:32:23 malte Exp $

#ifndef _CONFIGURATION_H_
#define _CONFIGURATION_H_

#include "configurationbase.h"

class KHTMLPart;
class KURL;

namespace Config {
	class Parser;
}
namespace KParts {
	struct URLArgs;
}

class Configuration : public ConfigurationBase
{
	Q_OBJECT
public:
	Configuration(QWidget *parent, const char *name = 0);
	virtual ~Configuration();

	void load();
	void save();
	void defaults();

signals:
	void changed(bool);

protected slots:
	virtual void slotUpdateArchs();
	virtual void slotParseConfig();
	virtual void slotLoadFrom();
	virtual void slotSaveAs();
	virtual void slotSelected();
	virtual void slotConfigChanged();
	void slotURLRequest(const KURL &, const KParts::URLArgs &);
	void slotDelayedHelp();

protected:
	virtual void keyPressEvent(QKeyEvent *);

private:
	const QString &dataDir();
	QString defaultConfig() const;
	void loadConfig(const QString &fileName);
	void saveConfig(const QString &fileName);

private:
	KHTMLPart *m_helpView;

	Config::Parser *m_parser;
	QString m_configFile;
	QString m_dataDir;
	QString m_intro;
	bool m_showingIntro;
	QTimer *m_helpTimer;
};

#endif
// vim: ts=4 sw=4 noet
