/*****************************************************************************\
    hpijs97.h : HP Inkjet Server

    Copyright (c) 1996 - 2002, Hewlett-Packard Co.
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the Hewlett-Packard nor the names of its
       contributors may be used to endorse or promote products derived
       from this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
    IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
    NOT LIMITED TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR
    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
    STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
    IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/

#ifndef hpijs97_INCLUDED
#define hpijs97_INCLUDED

#define DEVICE_NAME_MAX 16

/* Ghostscript defines for paper sizes. */
#define PAPER_SIZE_LETTER 2
#define PAPER_SIZE_LEGAL 3
#define PAPER_SIZE_A4 26

/* Packet commands. */
typedef enum
{
   ACK = 1,
   KILL,        /* kill server, no ack */
   SET_SHMID,
   SET_MODEL,
   SET_PRINTMODE,
   SET_PAPER,
   SET_PIXELS_PER_ROW,
   SND_RASTER,
   SND_NULL_RASTER,
   NEW_PAGE,
   GET_MODEL,
   GET_PRINTMODE,
   GET_PRINTMODE_CNT,
   GET_PAPER,
   GET_RESOLUTION,
   GET_EFFECTIVE_RESOLUTION,
   GET_SRV_VERSION,
   SET_RESOLUTION,
   SET_DEVICE_NAME,
   GET_PIXELS_PER_ROW,
   GET_PRINTABLE_AREA,        /* in inches */
   GET_PHYSICAL_PAGE_SIZE,    /* in inches */
   GET_PRINTABLE_START        /* in inches */
} PK_CMD;

/* Individual packets. PK_CMD must be first in all packets. */
typedef struct
{
   PK_CMD cmd;
   int id;
} PK_SHMID;

typedef struct
{
   PK_CMD cmd;
   int width;
  int outwidth;
} PK_PIXELS_PER_ROW;

typedef struct
{
  PK_CMD cmd;
  int val;
} PK_MODEL;

typedef PK_MODEL PK_MODE;

typedef struct
{
  PK_CMD cmd;
  int size;
} PK_PAPER;

typedef struct
{
  PK_CMD cmd;
  int x;
  int y;
} PK_RESOLUTION;

typedef struct
{
  PK_CMD cmd;
  char name[DEVICE_NAME_MAX];
} PK_DEVICE_NAME;

typedef struct
{
  PK_CMD cmd;
  char str[DEVICE_NAME_MAX];
} PK_VERSION;

typedef struct
{
   PK_CMD cmd;
   float width;
   float height;
} PK_PRINTABLE_AREA;

typedef struct
{
   PK_CMD cmd;
   float x;
   float y;
} PK_PHYSICAL_PAGE_SIZE;

typedef PK_PHYSICAL_PAGE_SIZE PK_PRINTABLE_START;

/* Common packet. */
typedef union
{
  PK_CMD cmd;
  PK_SHMID shm;
  PK_MODEL model;
  PK_MODE mode;
  PK_PAPER paper;
  PK_RESOLUTION res;
  PK_PIXELS_PER_ROW ppr;
  PK_DEVICE_NAME dev;
  PK_VERSION ver;
  PK_PRINTABLE_AREA parea;
  PK_PHYSICAL_PAGE_SIZE psize;
  PK_PRINTABLE_START pstart;
} PK;

/* Server descriptor. */
typedef struct
{
   int fds2c;   /* server to client */
   int fdc2s;   /* client to server */
   int shmid;
   char *shmbuf;
   char *srv_to_client;
   char *client_to_srv;
} SRVD;

/* Enumerated device table. */
typedef struct
{
   PRINTER_TYPE model;
   const char *name;
} DEV;

extern int bug(const char *fmt, ...);

#endif        /* hpijs_INCLUDED */
