/***********************************************************
Copyright 1993 by Ove Kalkan

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* 
 * IconBP.h - Private definitions for IconB widget
 * 
 */

#ifndef _XslIconBP_h
#define _XslIconBP_h

/***********************************************************************
 *
 * IconB Widget Private Data
 *
 ***********************************************************************/

#include "IconB.h"
#include <X11/Xaw/SimpleP.h>

/* New fields for the IconB widget class record */

typedef struct {int foo;} IconBClassPart;

/* Full class record declaration */
typedef struct _IconBClassRec {
	CoreClassPart	core_class;
	SimpleClassPart	simple_class;
	IconBClassPart	iconB_class;
} IconBClassRec;

extern IconBClassRec iconBClassRec;

typedef enum {
	HighlightNone,		/* Do not highlight. */
	HighlightWhenUnset,	/* Highlight only when unset, this is
				   to preserve current iconButton widget 
				   functionality. */
	HighlightAlways		/* Always highlight, lets the toggle widget
				   and other subclasses do the right thing. */
} XtIconButtonHighlight;

/* New fields for the IconB widget record */
typedef struct {
	/* resources */
	Pixmap		image;
	Pixmap		shape;
	Pixmap		simage;
	Pixmap		sshape;
	Dimension	width;
	Dimension	height;
	XtCallbackList	callbacks;
	Dimension	highlight_thickness;
	
	/* private state */
	Boolean		set;
	GC		normal_GC;
	GC		gray_GC;
	Pixmap		stipple;
} IconBPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _IconBRec {
	CorePart	core;
	SimplePart	simple;
	IconBPart	iconB;
} IconBRec;

#endif /* _XslLabelP_h */
